/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/app/messages/chunks/pageSelectors.ts":
/*!**************************************************!*\
  !*** ./src/app/messages/chunks/pageSelectors.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PageSelectors: () => (/* binding */ PageSelectors)
/* harmony export */ });
class PageSelectors {
    constructor(params) {
        Object.keys(params).forEach((key) => {
            this[key] = params[key];
        });
    }
}


/***/ }),

/***/ "./src/app/messages/index.ts":
/*!***********************************!*\
  !*** ./src/app/messages/index.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createErrorMessage: () => (/* binding */ createErrorMessage),
/* harmony export */   createExecuteContentScriptMessage: () => (/* binding */ createExecuteContentScriptMessage),
/* harmony export */   createGetClaimButtonMessage: () => (/* binding */ createGetClaimButtonMessage),
/* harmony export */   createGetDocumentReadyStateMessage: () => (/* binding */ createGetDocumentReadyStateMessage),
/* harmony export */   createGetElementMessage: () => (/* binding */ createGetElementMessage),
/* harmony export */   createGetPageLoginFormMessage: () => (/* binding */ createGetPageLoginFormMessage),
/* harmony export */   createGetPageSearchFormMessage: () => (/* binding */ createGetPageSearchFormMessage),
/* harmony export */   createGetTouristLinksMessage: () => (/* binding */ createGetTouristLinksMessage),
/* harmony export */   createStateMessage: () => (/* binding */ createStateMessage),
/* harmony export */   createTabMessage: () => (/* binding */ createTabMessage)
/* harmony export */ });
/* harmony import */ var _messageConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./messageConstants */ "./src/app/messages/messageConstants.ts");

function createTabMessage() {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_PAGE_STATUS,
        payload: null
    };
}
function createStateMessage(isClaimPage, claimNumber, sourceId, secretField, claimId, senderElementId, paymentOperationId, additionalInfo) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.STATE_MESSAGE,
        payload: {
            isClaimPage,
            claimId,
            claimNumber,
            sourceId,
            secretField,
            senderElementId,
            paymentOperationId,
            additionalInfo,
        }
    };
}
function createGetDocumentReadyStateMessage() {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_DOCUMENT_STATE
    };
}
function createGetElementMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_ELEMENT_MESSAGE,
        payload
    };
}
function createGetTouristLinksMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_TOURIST_LINKS,
        payload
    };
}
function createGetPageSearchFormMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_PAGE_SEARCH_FORM,
        payload
    };
}
function createGetPageLoginFormMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_PAGE_LOGIN_FORM,
        payload
    };
}
function createGetClaimButtonMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_CLAIM_BUTTON,
        payload
    };
}
function createErrorMessage(error) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.ERROR_MESSAGE,
        error,
        payload: null
    };
}
function createExecuteContentScriptMessage(data) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.EXECUTE_CONTENT_SCRIPT,
        payload: data
    };
}


/***/ }),

/***/ "./src/app/messages/messageConstants.ts":
/*!**********************************************!*\
  !*** ./src/app/messages/messageConstants.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ERROR_MESSAGE: () => (/* binding */ ERROR_MESSAGE),
/* harmony export */   EXECUTE_CONTENT_SCRIPT: () => (/* binding */ EXECUTE_CONTENT_SCRIPT),
/* harmony export */   EXECUTE_SCRIPT: () => (/* binding */ EXECUTE_SCRIPT),
/* harmony export */   GET_CLAIM_BUTTON: () => (/* binding */ GET_CLAIM_BUTTON),
/* harmony export */   GET_DOCUMENT_STATE: () => (/* binding */ GET_DOCUMENT_STATE),
/* harmony export */   GET_ELEMENT_MESSAGE: () => (/* binding */ GET_ELEMENT_MESSAGE),
/* harmony export */   GET_IDS_MESSAGE: () => (/* binding */ GET_IDS_MESSAGE),
/* harmony export */   GET_IDS_MESSAGE_AND_STATUS: () => (/* binding */ GET_IDS_MESSAGE_AND_STATUS),
/* harmony export */   GET_PAGE_LOGIN_FORM: () => (/* binding */ GET_PAGE_LOGIN_FORM),
/* harmony export */   GET_PAGE_SEARCH_FORM: () => (/* binding */ GET_PAGE_SEARCH_FORM),
/* harmony export */   GET_PAGE_STATUS: () => (/* binding */ GET_PAGE_STATUS),
/* harmony export */   GET_TOURIST_LINKS: () => (/* binding */ GET_TOURIST_LINKS),
/* harmony export */   STATE_MESSAGE: () => (/* binding */ STATE_MESSAGE)
/* harmony export */ });
const STATE_MESSAGE = 'STATE MESSAGE';
const ERROR_MESSAGE = 'ERROR MESSAGE';
const GET_PAGE_STATUS = 'GET PAGE STATUS';
const GET_IDS_MESSAGE = 'GET IDS';
const GET_DOCUMENT_STATE = 'GET DOCUMENT STATE';
const GET_ELEMENT_MESSAGE = 'GET ELEMENT';
const GET_TOURIST_LINKS = 'GET TOURIST LINKS';
const GET_PAGE_LOGIN_FORM = 'GET PAGE LOGIN FORM';
const GET_PAGE_SEARCH_FORM = 'GET PAGE SEARCH FORM';
const GET_CLAIM_BUTTON = 'GET CLAIM BUTTON';
const GET_IDS_MESSAGE_AND_STATUS = 'GET IDS MESSAGE AND STATUS';
const EXECUTE_SCRIPT = 'EXECUTE SCRIPT';
const EXECUTE_CONTENT_SCRIPT = 'EXECUTE CONTENT SCRIPT';


/***/ }),

/***/ "./src/app/models/chunks/createFillFnMessage.ts":
/*!******************************************************!*\
  !*** ./src/app/models/chunks/createFillFnMessage.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createFillFnMessage: () => (/* binding */ createFillFnMessage)
/* harmony export */ });
/* harmony import */ var _notificationBody__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./notificationBody */ "./src/app/models/chunks/notificationBody.ts");

function createFillFnMessage({ claimId, operator, errorText }) {
    return {
        title: errorText === null
            ? _notificationBody__WEBPACK_IMPORTED_MODULE_0__.FillFnMessageTexts.DONE
            : _notificationBody__WEBPACK_IMPORTED_MODULE_0__.FillFnMessageTexts.FAIL,
        body: {
            claimId,
            operator,
            errorText
        },
        toString() {
            return this.body.errorText
                ? `
                    Ошибка: ${this.body.errorText}\n
                    Tуроператор: ${this.body.operator.title}, Заявка №${this.body.claimId}`
                : `Tуроператор: ${this.body.operator.title}, Заявка №${this.body.claimId}`;
        }
    };
}


/***/ }),

/***/ "./src/app/models/chunks/createSendIdsMessage.ts":
/*!*******************************************************!*\
  !*** ./src/app/models/chunks/createSendIdsMessage.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSendIdsMessage: () => (/* binding */ createSendIdsMessage)
/* harmony export */ });
/* harmony import */ var _notificationBody__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./notificationBody */ "./src/app/models/chunks/notificationBody.ts");

function createSendIdsMessage({ status, message }) {
    return {
        title: status === _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatus.DONE
            ? _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatusTexts.DONE
            : _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatusTexts.FAIL,
        body: {
            status,
            message
        },
        toString() {
            return this.body.status === _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatus.FAIL
                ? `Ошибка отправки: ${this.body.message}`
                : `Успешная отправка: ${this.body.message}`;
        }
    };
}


/***/ }),

/***/ "./src/app/models/chunks/notificationBody.ts":
/*!***************************************************!*\
  !*** ./src/app/models/chunks/notificationBody.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FillFnMessageTexts: () => (/* binding */ FillFnMessageTexts),
/* harmony export */   SendIdsStatus: () => (/* binding */ SendIdsStatus),
/* harmony export */   SendIdsStatusTexts: () => (/* binding */ SendIdsStatusTexts)
/* harmony export */ });
var SendIdsStatus;
(function (SendIdsStatus) {
    SendIdsStatus["DONE"] = "DONE";
    SendIdsStatus["FAIL"] = "FAIL";
})(SendIdsStatus || (SendIdsStatus = {}));
var SendIdsStatusTexts;
(function (SendIdsStatusTexts) {
    SendIdsStatusTexts["DONE"] = "\u0418\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u044B \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u043F\u0435\u0440\u0435\u0434\u0430\u043D\u044B \u043D\u0430 \u0441\u0435\u0440\u0432\u0435\u0440!";
    SendIdsStatusTexts["FAIL"] = "\u041F\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0438\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u043E\u0432 \u043D\u0435 \u0443\u0434\u0430\u043B\u0430\u0441\u044C";
})(SendIdsStatusTexts || (SendIdsStatusTexts = {}));
var FillFnMessageTexts;
(function (FillFnMessageTexts) {
    FillFnMessageTexts["DONE"] = "\u0417\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u0435 \u0432\u044B\u043F\u043E\u043B\u043D\u0435\u043D\u043E \u0443\u0441\u043F\u0435\u0448\u043D\u043E!";
    FillFnMessageTexts["FAIL"] = "\u0417\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u0435 \u043D\u0435 \u0432\u044B\u043F\u043E\u043B\u043D\u0435\u043D\u043E";
})(FillFnMessageTexts || (FillFnMessageTexts = {}));


/***/ }),

/***/ "./src/app/models/errors.ts":
/*!**********************************!*\
  !*** ./src/app/models/errors.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RequestError: () => (/* binding */ RequestError)
/* harmony export */ });
class RequestError extends Error {
    constructor(reason) {
        super(reason);
        this.name = 'RequestError';
        this.message = 'Ошибка запроса';
        this.message = `${this.message}: ${reason}`;
    }
}


/***/ }),

/***/ "./src/app/models/index.ts":
/*!*********************************!*\
  !*** ./src/app/models/index.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ClaimConfirmationStatus: () => (/* binding */ ClaimConfirmationStatus),
/* harmony export */   EmptyScript: () => (/* binding */ EmptyScript),
/* harmony export */   ErrorTypes: () => (/* binding */ ErrorTypes),
/* harmony export */   MessageTypes: () => (/* binding */ MessageTypes),
/* harmony export */   PageStatuses: () => (/* binding */ PageStatuses),
/* harmony export */   RequestError: () => (/* reexport safe */ _errors__WEBPACK_IMPORTED_MODULE_0__.RequestError),
/* harmony export */   ScriptType: () => (/* binding */ ScriptType),
/* harmony export */   SenderTypes: () => (/* binding */ SenderTypes)
/* harmony export */ });
/* harmony import */ var _errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./errors */ "./src/app/models/errors.ts");

var ScriptType;
(function (ScriptType) {
    ScriptType[ScriptType["Login"] = 0] = "Login";
    ScriptType[ScriptType["FormFill"] = 1] = "FormFill";
    ScriptType[ScriptType["VisaFill"] = 2] = "VisaFill";
    ScriptType[ScriptType["NavToBookedClaim"] = 3] = "NavToBookedClaim";
})(ScriptType || (ScriptType = {}));
const EmptyScript = {
    scriptId: '',
    tourOperatorId: '',
    sletatId: 0,
    body: '',
    createDateUtc: '',
    type: ScriptType.Login,
    isActive: false,
    version: '',
};
var ClaimConfirmationStatus;
(function (ClaimConfirmationStatus) {
    ClaimConfirmationStatus[ClaimConfirmationStatus["NOT_CONFIRMED"] = 1] = "NOT_CONFIRMED";
    ClaimConfirmationStatus[ClaimConfirmationStatus["WAITING"] = 2] = "WAITING";
    ClaimConfirmationStatus[ClaimConfirmationStatus["CONFIRMED"] = 3] = "CONFIRMED";
})(ClaimConfirmationStatus || (ClaimConfirmationStatus = {}));
var ErrorTypes;
(function (ErrorTypes) {
    ErrorTypes["NO_CLAIM_PAGE"] = "\u0412\u044B \u043D\u0435 \u043D\u0430\u0445\u043E\u0434\u0438\u0442\u0435\u0441\u044C \u043D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0435 \u0437\u0430\u044F\u0432\u043A\u0438";
    ErrorTypes["NO_VISA_NEEDED"] = "\u041E\u0444\u043E\u0440\u043C\u043B\u0435\u043D\u0438\u0435 \u0432\u0438\u0437\u044B \u0434\u043B\u044F \u0434\u0430\u043D\u043D\u043E\u0439 \u0437\u0430\u044F\u0432\u043A\u0438 \u043D\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F";
    ErrorTypes["NO_TO_ID"] = "\u041F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u0435\u043D. \u041D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0435 \u0426\u0411 \u043D\u0435 \u0443\u043A\u0430\u0437\u0430\u043D id \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430, \u043F\u043E\u043F\u0440\u043E\u0431\u0443\u0439\u0442\u0435 \u043F\u043E\u0437\u0436\u0435.";
    ErrorTypes["NO_CLAIM_ID"] = "\u041F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u0435\u043D. \u041D\u0435 \u043F\u0440\u043E\u0441\u0442\u0430\u0432\u043B\u0435\u043D \u043D\u043E\u043C\u0435\u0440 \u0437\u0430\u044F\u0432\u043A\u0438 \u0442\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430.";
    ErrorTypes["TO_NOT_SUPPORTED"] = "\u0423\u0432\u044B, \u0424\u0438\u043B\u044F \u043F\u043E\u043A\u0430 \u0447\u0442\u043E \u043D\u0435 \u043F\u043E\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u0434\u0430\u043D\u043D\u043E\u0433\u043E \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 :(";
    ErrorTypes["TO_RESTRICTED"] = "\u0414\u0430\u043D\u043D\u044B\u0439 \u0442\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440 \u043D\u0435 \u043F\u0440\u0435\u0434\u043E\u0441\u0442\u0430\u0432\u043B\u044F\u0435\u0442 \u043F\u0440\u044F\u043C\u0443\u044E \u0441\u0441\u044B\u043B\u043A\u0443 \u043D\u0430 \u0442\u0443\u0440, \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u0435 \u0432\u043E\u0437\u043C\u043E\u0436\u043D\u043E \u0442\u043E\u043B\u044C\u043A\u043E \u0432\u0440\u0443\u0447\u043D\u0443\u044E";
    ErrorTypes["CLAIM_ALREADY_BOOKED"] = "\u0414\u0430\u043D\u043D\u0430\u044F \u0437\u0430\u044F\u0432\u043A\u0430 \u0443\u0436\u0435 \u0431\u044B\u043B\u0430 \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0430 \u0438 \u0437\u0430\u0431\u0440\u043E\u043D\u0438\u0440\u043E\u0432\u0430\u043D\u0430 \u043D\u0430 \u0441\u0430\u0439\u0442\u0435 \u0442\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430. \u0427\u0442\u043E\u0431\u044B \u043F\u0440\u043E\u0441\u043C\u043E\u0442\u0440\u0435\u0442\u044C \u0435\u0435, \u0432\u043E\u0441\u043F\u043E\u043B\u044C\u0437\u0443\u0439\u0442\u0435\u0441\u044C \u043A\u043D\u043E\u043F\u043A\u043E\u0439 \"\u041B\u0443\u043F\u0430\"";
    ErrorTypes["UNKNOWN"] = "\u041F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u0435\u043D. \u041D\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043D\u0430\u044F \u043E\u0448\u0438\u0431\u043A\u0430.";
})(ErrorTypes || (ErrorTypes = {}));
var MessageTypes;
(function (MessageTypes) {
    MessageTypes["GET_PAGE_STATUS"] = "GET PAGE STATUS";
    MessageTypes["PASS_TO_CREDS"] = "PASS TO CREDS";
    MessageTypes["ERROR"] = "ERROR";
    MessageTypes["GET_IDS"] = "GET IDS";
    MessageTypes["GET_ELEMENT"] = "GET ELEMENT";
    MessageTypes["GET_TOURIST_LINKS"] = "GET TOURIST LINKS";
    MessageTypes["GET_PAGE_LOGIN_FORM"] = "GET PAGE LOGIN FORM";
    MessageTypes["GET_PAGE_SEARCH_FORM"] = "GET PAGE SEARCH FORM";
    MessageTypes["GET_CLAIM_BUTTON"] = "GET CLAIM BUTTON";
    MessageTypes["GET_DOCUMENT_STATE"] = "GET DOCUMENT STATE";
    MessageTypes["GET_IDS_MESSAGE_AND_STATUS"] = "GET IDS MESSAGE AND STATUS";
    MessageTypes["EXECUTE_CONTENT_SCRIPT"] = "EXECUTE CONTENT SCRIPT";
})(MessageTypes || (MessageTypes = {}));
var PageStatuses;
(function (PageStatuses) {
    PageStatuses["IS_CLAIM_PAGE"] = "IS_CLAIM_PAGE";
    PageStatuses["IS_OPERATOR_SUPPORTED"] = "IS_OPERATOR_SUPPORTED";
})(PageStatuses || (PageStatuses = {}));
var SenderTypes;
(function (SenderTypes) {
    SenderTypes[SenderTypes["TAB_SENDER"] = 0] = "TAB_SENDER";
    SenderTypes[SenderTypes["EXT_SENDER"] = 1] = "EXT_SENDER";
})(SenderTypes || (SenderTypes = {}));


/***/ }),

/***/ "./src/app/operators.ts":
/*!******************************!*\
  !*** ./src/app/operators.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OPERATORS: () => (/* binding */ OPERATORS),
/* harmony export */   tryGetOperator: () => (/* binding */ tryGetOperator)
/* harmony export */ });
/* harmony import */ var _serverScripts_operators_156__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../serverScripts/operators/156 */ "./src/serverScripts/operators/156.ts");
/* harmony import */ var _serverScripts_operators_3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../serverScripts/operators/3 */ "./src/serverScripts/operators/3.ts");
/* harmony import */ var _serverScripts_operators_4__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../serverScripts/operators/4 */ "./src/serverScripts/operators/4.ts");
/* harmony import */ var _serverScripts_operators_6__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../serverScripts/operators/6 */ "./src/serverScripts/operators/6.ts");
/* harmony import */ var _serverScripts_operators_7__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../serverScripts/operators/7 */ "./src/serverScripts/operators/7.ts");
/* harmony import */ var _serverScripts_operators_inturist__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../serverScripts/operators/inturist */ "./src/serverScripts/operators/inturist.ts");
/* harmony import */ var _serverScripts_operators_14__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./../serverScripts/operators/14 */ "./src/serverScripts/operators/14.ts");
/* harmony import */ var _serverScripts_operators_19__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./../serverScripts/operators/19 */ "./src/serverScripts/operators/19.ts");
/* harmony import */ var _serverScripts_operators_20__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./../serverScripts/operators/20 */ "./src/serverScripts/operators/20.ts");
/* harmony import */ var _serverScripts_operators_rusExpress__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../serverScripts/operators/rusExpress */ "./src/serverScripts/operators/rusExpress.ts");
/* harmony import */ var _serverScripts_operators_39__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./../serverScripts/operators/39 */ "./src/serverScripts/operators/39.ts");
/* harmony import */ var _serverScripts_operators_41__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./../serverScripts/operators/41 */ "./src/serverScripts/operators/41.ts");
/* harmony import */ var _serverScripts_operators_42__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./../serverScripts/operators/42 */ "./src/serverScripts/operators/42.ts");
/* harmony import */ var _serverScripts_operators_46__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./../serverScripts/operators/46 */ "./src/serverScripts/operators/46.ts");
/* harmony import */ var _serverScripts_operators_49__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./../serverScripts/operators/49 */ "./src/serverScripts/operators/49.ts");
/* harmony import */ var _serverScripts_operators_51__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./../serverScripts/operators/51 */ "./src/serverScripts/operators/51.ts");
/* harmony import */ var _serverScripts_operators_53__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./../serverScripts/operators/53 */ "./src/serverScripts/operators/53.ts");
/* harmony import */ var _serverScripts_operators_54__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./../serverScripts/operators/54 */ "./src/serverScripts/operators/54.ts");
/* harmony import */ var _serverScripts_operators_78__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./../serverScripts/operators/78 */ "./src/serverScripts/operators/78.ts");
/* harmony import */ var _serverScripts_operators_81__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./../serverScripts/operators/81 */ "./src/serverScripts/operators/81.ts");
/* harmony import */ var _serverScripts_operators_artTour__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./../serverScripts/operators/artTour */ "./src/serverScripts/operators/artTour.ts");
/* harmony import */ var _serverScripts_operators_93__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./../serverScripts/operators/93 */ "./src/serverScripts/operators/93.ts");
/* harmony import */ var _serverScripts_operators_107__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./../serverScripts/operators/107 */ "./src/serverScripts/operators/107.ts");
/* harmony import */ var _serverScripts_operators_108__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./../serverScripts/operators/108 */ "./src/serverScripts/operators/108.ts");
/* harmony import */ var _serverScripts_operators_112__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./../serverScripts/operators/112 */ "./src/serverScripts/operators/112.ts");
/* harmony import */ var _serverScripts_operators_113__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./../serverScripts/operators/113 */ "./src/serverScripts/operators/113.ts");
/* harmony import */ var _serverScripts_operators_123__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./../serverScripts/operators/123 */ "./src/serverScripts/operators/123.ts");
/* harmony import */ var _serverScripts_operators_130__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./../serverScripts/operators/130 */ "./src/serverScripts/operators/130.ts");
/* harmony import */ var _serverScripts_operators_131__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./../serverScripts/operators/131 */ "./src/serverScripts/operators/131.ts");
/* harmony import */ var _serverScripts_operators_141__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./../serverScripts/operators/141 */ "./src/serverScripts/operators/141.ts");
/* harmony import */ var _serverScripts_operators_142__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./../serverScripts/operators/142 */ "./src/serverScripts/operators/142.ts");
/* harmony import */ var _serverScripts_operators_145__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./../serverScripts/operators/145 */ "./src/serverScripts/operators/145.ts");
/* harmony import */ var _serverScripts_operators_152__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./../serverScripts/operators/152 */ "./src/serverScripts/operators/152.ts");
/* harmony import */ var _serverScripts_operators_153__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./../serverScripts/operators/153 */ "./src/serverScripts/operators/153.ts");
/* harmony import */ var _serverScripts_operators_155__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./../serverScripts/operators/155 */ "./src/serverScripts/operators/155.ts");
/* harmony import */ var _serverScripts_operators_158__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./../serverScripts/operators/158 */ "./src/serverScripts/operators/158.ts");
/* harmony import */ var _serverScripts_operators_160__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./../serverScripts/operators/160 */ "./src/serverScripts/operators/160.ts");
/* harmony import */ var _serverScripts_operators_162__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./../serverScripts/operators/162 */ "./src/serverScripts/operators/162.ts");
/* harmony import */ var _serverScripts_operators_165__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./../serverScripts/operators/165 */ "./src/serverScripts/operators/165.ts");
/* harmony import */ var _serverScripts_operators_171__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./../serverScripts/operators/171 */ "./src/serverScripts/operators/171.ts");
/* harmony import */ var _serverScripts_operators_174__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./../serverScripts/operators/174 */ "./src/serverScripts/operators/174.ts");
/* harmony import */ var _serverScripts_operators_184__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./../serverScripts/operators/184 */ "./src/serverScripts/operators/184.ts");
/* harmony import */ var _serverScripts_operators_kompasKz__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./../serverScripts/operators/kompasKz */ "./src/serverScripts/operators/kompasKz.ts");
/* harmony import */ var _serverScripts_operators_evroport__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./../serverScripts/operators/evroport */ "./src/serverScripts/operators/evroport.ts");
/* harmony import */ var _serverScripts_operators_sanatKz__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./../serverScripts/operators/sanatKz */ "./src/serverScripts/operators/sanatKz.ts");
/* harmony import */ var _serverScripts_operators_205__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./../serverScripts/operators/205 */ "./src/serverScripts/operators/205.ts");
/* harmony import */ var _serverScripts_operators_213__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./../serverScripts/operators/213 */ "./src/serverScripts/operators/213.ts");
/* harmony import */ var _serverScripts_operators_219__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ../serverScripts/operators/219 */ "./src/serverScripts/operators/219.ts");
/* harmony import */ var _serverScripts_operators_229__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ../serverScripts/operators/229 */ "./src/serverScripts/operators/229.ts");
/* harmony import */ var _serverScripts_operators_231__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./../serverScripts/operators/231 */ "./src/serverScripts/operators/231.ts");
/* harmony import */ var _serverScripts_operators_237__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./../serverScripts/operators/237 */ "./src/serverScripts/operators/237.ts");
/* harmony import */ var _serverScripts_operators_238__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./../serverScripts/operators/238 */ "./src/serverScripts/operators/238.ts");
/* harmony import */ var _serverScripts_operators_248__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./../serverScripts/operators/248 */ "./src/serverScripts/operators/248.ts");
/* harmony import */ var _serverScripts_operators_252__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./../serverScripts/operators/252 */ "./src/serverScripts/operators/252.ts");
/* harmony import */ var _serverScripts_operators_260__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./../serverScripts/operators/260 */ "./src/serverScripts/operators/260.ts");
/* harmony import */ var _serverScripts_operators_269__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./../serverScripts/operators/269 */ "./src/serverScripts/operators/269.ts");
/* harmony import */ var _serverScripts_operators_277__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./../serverScripts/operators/277 */ "./src/serverScripts/operators/277.ts");
/* harmony import */ var _serverScripts_operators_280__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./../serverScripts/operators/280 */ "./src/serverScripts/operators/280.ts");
/* harmony import */ var _serverScripts_operators_282__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./../serverScripts/operators/282 */ "./src/serverScripts/operators/282.ts");
/* harmony import */ var _serverScripts_operators_301__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./../serverScripts/operators/301 */ "./src/serverScripts/operators/301.ts");
/* harmony import */ var _serverScripts_operators_302__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./../serverScripts/operators/302 */ "./src/serverScripts/operators/302.ts");
/* harmony import */ var _serverScripts_operators_304__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./../serverScripts/operators/304 */ "./src/serverScripts/operators/304.ts");
/* harmony import */ var _serverScripts_operators_309__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./../serverScripts/operators/309 */ "./src/serverScripts/operators/309.ts");
/* harmony import */ var _serverScripts_operators_311__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./../serverScripts/operators/311 */ "./src/serverScripts/operators/311.ts");
/* harmony import */ var _serverScripts_operators_315__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./../serverScripts/operators/315 */ "./src/serverScripts/operators/315.ts");
/* harmony import */ var _serverScripts_operators_331__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./../serverScripts/operators/331 */ "./src/serverScripts/operators/331.ts");
/* harmony import */ var _serverScripts_operators_343__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ./../serverScripts/operators/343 */ "./src/serverScripts/operators/343.ts");
/* harmony import */ var _serverScripts_operators_344__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ./../serverScripts/operators/344 */ "./src/serverScripts/operators/344.ts");
/* harmony import */ var _serverScripts_operators_345__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ./../serverScripts/operators/345 */ "./src/serverScripts/operators/345.ts");
/* harmony import */ var _serverScripts_operators_348__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ./../serverScripts/operators/348 */ "./src/serverScripts/operators/348.ts");
/* harmony import */ var _serverScripts_operators_361__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ./../serverScripts/operators/361 */ "./src/serverScripts/operators/361.ts");
/* harmony import */ var _serverScripts_operators_378__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ./../serverScripts/operators/378 */ "./src/serverScripts/operators/378.ts");
/* harmony import */ var _serverScripts_operators_380__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ./../serverScripts/operators/380 */ "./src/serverScripts/operators/380.ts");
/* harmony import */ var _serverScripts_operators_382__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ./../serverScripts/operators/382 */ "./src/serverScripts/operators/382.ts");
/* harmony import */ var _serverScripts_operators_392__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(/*! ./../serverScripts/operators/392 */ "./src/serverScripts/operators/392.ts");
/* harmony import */ var _serverScripts_operators_415__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(/*! ./../serverScripts/operators/415 */ "./src/serverScripts/operators/415.ts");
/* harmony import */ var _serverScripts_operators_429__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(/*! ./../serverScripts/operators/429 */ "./src/serverScripts/operators/429.ts");
/* harmony import */ var _serverScripts_operators_431__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(/*! ./../serverScripts/operators/431 */ "./src/serverScripts/operators/431.ts");
/* harmony import */ var _serverScripts_operators_432__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(/*! ./../serverScripts/operators/432 */ "./src/serverScripts/operators/432.ts");
/* harmony import */ var _serverScripts_operators_439__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(/*! ./../serverScripts/operators/439 */ "./src/serverScripts/operators/439.ts");
/* harmony import */ var _serverScripts_operators_449__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(/*! ./../serverScripts/operators/449 */ "./src/serverScripts/operators/449.ts");
/* harmony import */ var _serverScripts_operators_450__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(/*! ./../serverScripts/operators/450 */ "./src/serverScripts/operators/450.ts");
/* harmony import */ var _serverScripts_operators_452__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(/*! ./../serverScripts/operators/452 */ "./src/serverScripts/operators/452.ts");
/* harmony import */ var _serverScripts_operators_453__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(/*! ../serverScripts/operators/453 */ "./src/serverScripts/operators/453.ts");
/* harmony import */ var _serverScripts_operators_454__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(/*! ./../serverScripts/operators/454 */ "./src/serverScripts/operators/454.ts");
/* harmony import */ var _serverScripts_operators_457__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__(/*! ./../serverScripts/operators/457 */ "./src/serverScripts/operators/457.ts");
/* harmony import */ var _serverScripts_operators_536__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__(/*! ./../serverScripts/operators/536 */ "./src/serverScripts/operators/536.ts");
/* harmony import */ var _serverScripts_operators_544__WEBPACK_IMPORTED_MODULE_87__ = __webpack_require__(/*! ./../serverScripts/operators/544 */ "./src/serverScripts/operators/544.ts");
/* harmony import */ var _serverScripts_operators_564__WEBPACK_IMPORTED_MODULE_88__ = __webpack_require__(/*! ./../serverScripts/operators/564 */ "./src/serverScripts/operators/564.ts");
/* harmony import */ var _serverScripts_operators_970__WEBPACK_IMPORTED_MODULE_89__ = __webpack_require__(/*! ../serverScripts/operators/970 */ "./src/serverScripts/operators/970.ts");
/* harmony import */ var _serverScripts_operators_743__WEBPACK_IMPORTED_MODULE_90__ = __webpack_require__(/*! ./../serverScripts/operators/743 */ "./src/serverScripts/operators/743.ts");
/* harmony import */ var _serverScripts_operators_768__WEBPACK_IMPORTED_MODULE_91__ = __webpack_require__(/*! ./../serverScripts/operators/768 */ "./src/serverScripts/operators/768.ts");
/* harmony import */ var _serverScripts_operators_800__WEBPACK_IMPORTED_MODULE_92__ = __webpack_require__(/*! ./../serverScripts/operators/800 */ "./src/serverScripts/operators/800.ts");
/* harmony import */ var _serverScripts_operators_iway__WEBPACK_IMPORTED_MODULE_93__ = __webpack_require__(/*! ./../serverScripts/operators/iway */ "./src/serverScripts/operators/iway.ts");
/* harmony import */ var _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__ = __webpack_require__(/*! ./../serverScripts/operators/tourClick */ "./src/serverScripts/operators/tourClick.ts");
/* harmony import */ var _serverScripts_operators_letsFly__WEBPACK_IMPORTED_MODULE_95__ = __webpack_require__(/*! ../serverScripts/operators/letsFly */ "./src/serverScripts/operators/letsFly.ts");
/* harmony import */ var _serverScripts_operators_2147483639__WEBPACK_IMPORTED_MODULE_96__ = __webpack_require__(/*! ./../serverScripts/operators/2147483639 */ "./src/serverScripts/operators/2147483639.ts");
/* harmony import */ var _serverScripts_operators_2147483640__WEBPACK_IMPORTED_MODULE_97__ = __webpack_require__(/*! ./../serverScripts/operators/2147483640 */ "./src/serverScripts/operators/2147483640.ts");
/* harmony import */ var _serverScripts_operators_2147483641__WEBPACK_IMPORTED_MODULE_98__ = __webpack_require__(/*! ./../serverScripts/operators/2147483641 */ "./src/serverScripts/operators/2147483641.ts");
/* harmony import */ var _serverScripts_operators_2147483645__WEBPACK_IMPORTED_MODULE_99__ = __webpack_require__(/*! ./../serverScripts/operators/2147483645 */ "./src/serverScripts/operators/2147483645.ts");
/* harmony import */ var _serverScripts_operators_eskazan__WEBPACK_IMPORTED_MODULE_100__ = __webpack_require__(/*! ../serverScripts/operators/eskazan */ "./src/serverScripts/operators/eskazan.ts");
/* harmony import */ var _serverScripts_operators_oneClickTravel__WEBPACK_IMPORTED_MODULE_101__ = __webpack_require__(/*! ../serverScripts/operators/oneClickTravel */ "./src/serverScripts/operators/oneClickTravel.ts");
/* harmony import */ var _serverScripts_operators_kazunion__WEBPACK_IMPORTED_MODULE_102__ = __webpack_require__(/*! ../serverScripts/operators/kazunion */ "./src/serverScripts/operators/kazunion.ts");
/* harmony import */ var _serverScripts_operators_tariTour__WEBPACK_IMPORTED_MODULE_103__ = __webpack_require__(/*! ../serverScripts/operators/tariTour */ "./src/serverScripts/operators/tariTour.ts");
/* harmony import */ var _serverScripts_operators_skanTour__WEBPACK_IMPORTED_MODULE_104__ = __webpack_require__(/*! ../serverScripts/operators/skanTour */ "./src/serverScripts/operators/skanTour.ts");
/* harmony import */ var _serverScripts_operators_vodohod__WEBPACK_IMPORTED_MODULE_105__ = __webpack_require__(/*! ../serverScripts/operators/vodohod */ "./src/serverScripts/operators/vodohod.ts");
/* harmony import */ var _serverScripts_operators_melinoTravel__WEBPACK_IMPORTED_MODULE_106__ = __webpack_require__(/*! ../serverScripts/operators/melinoTravel */ "./src/serverScripts/operators/melinoTravel.ts");
/* harmony import */ var _serverScripts_operators_rivieraTour__WEBPACK_IMPORTED_MODULE_107__ = __webpack_require__(/*! ../serverScripts/operators/rivieraTour */ "./src/serverScripts/operators/rivieraTour.ts");
/* harmony import */ var _serverScripts_operators_unona__WEBPACK_IMPORTED_MODULE_108__ = __webpack_require__(/*! ../serverScripts/operators/unona */ "./src/serverScripts/operators/unona.ts");
/* harmony import */ var _serverScripts_operators_magput__WEBPACK_IMPORTED_MODULE_109__ = __webpack_require__(/*! ../serverScripts/operators/magput */ "./src/serverScripts/operators/magput.ts");






































































//import { Krypton } from './../serverScripts/operators/355';








































const tryGetOperator = (sletatId, toAlias) => {
    if (sletatId) {
        const op = OPERATORS[sletatId];
        if (op) {
            return op;
        }
    }
    if (toAlias) {
        const op = OPERATORS[toAlias];
        if (op) {
            return op;
        }
    }
    return null;
};
const OPERATORS = {
    3: _serverScripts_operators_3__WEBPACK_IMPORTED_MODULE_1__.Pegas,
    4: _serverScripts_operators_4__WEBPACK_IMPORTED_MODULE_2__.TezTour,
    6: _serverScripts_operators_6__WEBPACK_IMPORTED_MODULE_3__.Coral,
    7: _serverScripts_operators_7__WEBPACK_IMPORTED_MODULE_4__.BiblioGlobus,
    //9: Intourist,
    14: _serverScripts_operators_14__WEBPACK_IMPORTED_MODULE_6__.PacGroup,
    19: _serverScripts_operators_19__WEBPACK_IMPORTED_MODULE_7__.Anex,
    20: _serverScripts_operators_20__WEBPACK_IMPORTED_MODULE_8__.IcsTravel,
    38: _serverScripts_operators_rusExpress__WEBPACK_IMPORTED_MODULE_9__.RusExpress,
    39: _serverScripts_operators_39__WEBPACK_IMPORTED_MODULE_10__.DiamondTours,
    41: _serverScripts_operators_41__WEBPACK_IMPORTED_MODULE_11__.Bontour,
    42: _serverScripts_operators_42__WEBPACK_IMPORTED_MODULE_12__.ZlataPraga,
    46: _serverScripts_operators_46__WEBPACK_IMPORTED_MODULE_13__.Troyka,
    49: _serverScripts_operators_49__WEBPACK_IMPORTED_MODULE_14__.Vilar,
    51: _serverScripts_operators_51__WEBPACK_IMPORTED_MODULE_15__.Ambotis,
    53: _serverScripts_operators_53__WEBPACK_IMPORTED_MODULE_16__.IntravelStoleshniki,
    54: _serverScripts_operators_54__WEBPACK_IMPORTED_MODULE_17__.Sunmar,
    78: _serverScripts_operators_78__WEBPACK_IMPORTED_MODULE_18__.Unex,
    81: _serverScripts_operators_81__WEBPACK_IMPORTED_MODULE_19__.Spectrum,
    83: _serverScripts_operators_artTour__WEBPACK_IMPORTED_MODULE_20__.ArtTour,
    93: _serverScripts_operators_93__WEBPACK_IMPORTED_MODULE_21__.Balkan,
    107: _serverScripts_operators_107__WEBPACK_IMPORTED_MODULE_22__.Danko,
    108: _serverScripts_operators_108__WEBPACK_IMPORTED_MODULE_23__.DeltaTours,
    112: _serverScripts_operators_112__WEBPACK_IMPORTED_MODULE_24__.ExpressTour,
    113: _serverScripts_operators_113__WEBPACK_IMPORTED_MODULE_25__.Grand,
    123: _serverScripts_operators_123__WEBPACK_IMPORTED_MODULE_26__.Itm,
    125: _serverScripts_operators_439__WEBPACK_IMPORTED_MODULE_79__.Paks,
    130: _serverScripts_operators_130__WEBPACK_IMPORTED_MODULE_27__.WestTravel,
    131: _serverScripts_operators_131__WEBPACK_IMPORTED_MODULE_28__.ArtTravel,
    141: _serverScripts_operators_141__WEBPACK_IMPORTED_MODULE_29__.YugoStar,
    142: _serverScripts_operators_142__WEBPACK_IMPORTED_MODULE_30__.MoreTravel,
    145: _serverScripts_operators_145__WEBPACK_IMPORTED_MODULE_31__.RozaVetrov,
    152: _serverScripts_operators_152__WEBPACK_IMPORTED_MODULE_32__.MeridianExpress,
    153: _serverScripts_operators_153__WEBPACK_IMPORTED_MODULE_33__.Delfin,
    155: _serverScripts_operators_155__WEBPACK_IMPORTED_MODULE_34__.BSI,
    156: _serverScripts_operators_156__WEBPACK_IMPORTED_MODULE_0__.Maldives,
    158: _serverScripts_operators_158__WEBPACK_IMPORTED_MODULE_35__.Solvex,
    160: _serverScripts_operators_160__WEBPACK_IMPORTED_MODULE_36__.Dsbw,
    162: _serverScripts_operators_162__WEBPACK_IMPORTED_MODULE_37__.ChinaTravel,
    165: _serverScripts_operators_165__WEBPACK_IMPORTED_MODULE_38__.Devisu,
    171: _serverScripts_operators_171__WEBPACK_IMPORTED_MODULE_39__.AmigoS,
    174: _serverScripts_operators_174__WEBPACK_IMPORTED_MODULE_40__.Capricorn,
    184: _serverScripts_operators_184__WEBPACK_IMPORTED_MODULE_41__.Interunion,
    191: _serverScripts_operators_sanatKz__WEBPACK_IMPORTED_MODULE_44__.SanatKz,
    194: _serverScripts_operators_kompasKz__WEBPACK_IMPORTED_MODULE_42__.KompasKz,
    199: _serverScripts_operators_evroport__WEBPACK_IMPORTED_MODULE_43__.Evroport,
    205: _serverScripts_operators_205__WEBPACK_IMPORTED_MODULE_45__.AmigoTours,
    213: _serverScripts_operators_213__WEBPACK_IMPORTED_MODULE_46__.Mouzenidis,
    219: _serverScripts_operators_219__WEBPACK_IMPORTED_MODULE_47__.SochiPlanet,
    229: _serverScripts_operators_229__WEBPACK_IMPORTED_MODULE_48__.TuiOld,
    231: _serverScripts_operators_231__WEBPACK_IMPORTED_MODULE_49__.MultiTour,
    237: _serverScripts_operators_237__WEBPACK_IMPORTED_MODULE_50__.DvmTour,
    238: _serverScripts_operators_238__WEBPACK_IMPORTED_MODULE_51__.RusTour,
    244: _serverScripts_operators_tariTour__WEBPACK_IMPORTED_MODULE_103__.TariTour,
    248: _serverScripts_operators_248__WEBPACK_IMPORTED_MODULE_52__.AvroraBg,
    252: _serverScripts_operators_252__WEBPACK_IMPORTED_MODULE_53__.Alean,
    260: _serverScripts_operators_260__WEBPACK_IMPORTED_MODULE_54__.Kandagar,
    269: _serverScripts_operators_269__WEBPACK_IMPORTED_MODULE_55__.NatalieTours,
    277: _serverScripts_operators_277__WEBPACK_IMPORTED_MODULE_56__.VremiaTour,
    280: _serverScripts_operators_280__WEBPACK_IMPORTED_MODULE_57__.GTV,
    282: _serverScripts_operators_282__WEBPACK_IMPORTED_MODULE_58__.Petropolitana,
    301: _serverScripts_operators_301__WEBPACK_IMPORTED_MODULE_59__.RobinsonTours,
    302: _serverScripts_operators_302__WEBPACK_IMPORTED_MODULE_60__.Premiera,
    304: _serverScripts_operators_304__WEBPACK_IMPORTED_MODULE_61__.GoodTimeTravel,
    309: _serverScripts_operators_309__WEBPACK_IMPORTED_MODULE_62__.Ivolga,
    311: _serverScripts_operators_311__WEBPACK_IMPORTED_MODULE_63__.Matreshka,
    315: _serverScripts_operators_315__WEBPACK_IMPORTED_MODULE_64__.Beleon,
    322: _serverScripts_operators_kazunion__WEBPACK_IMPORTED_MODULE_102__.Kazunion,
    331: _serverScripts_operators_331__WEBPACK_IMPORTED_MODULE_65__.Acti,
    343: _serverScripts_operators_343__WEBPACK_IMPORTED_MODULE_66__.PlanTravel1,
    344: _serverScripts_operators_344__WEBPACK_IMPORTED_MODULE_67__.Panteon,
    345: _serverScripts_operators_345__WEBPACK_IMPORTED_MODULE_68__.Vand,
    348: _serverScripts_operators_348__WEBPACK_IMPORTED_MODULE_69__.PlanTravel,
    361: _serverScripts_operators_361__WEBPACK_IMPORTED_MODULE_70__.SpaceTravel,
    378: _serverScripts_operators_378__WEBPACK_IMPORTED_MODULE_71__.PearlRiver,
    380: _serverScripts_operators_380__WEBPACK_IMPORTED_MODULE_72__.TUInew,
    382: _serverScripts_operators_382__WEBPACK_IMPORTED_MODULE_73__.SelfieTravel,
    392: _serverScripts_operators_392__WEBPACK_IMPORTED_MODULE_74__.Aerotour,
    415: _serverScripts_operators_415__WEBPACK_IMPORTED_MODULE_75__.Clickvoyage,
    429: _serverScripts_operators_429__WEBPACK_IMPORTED_MODULE_76__.RExpress,
    431: _serverScripts_operators_431__WEBPACK_IMPORTED_MODULE_77__.EliteTravel,
    432: _serverScripts_operators_432__WEBPACK_IMPORTED_MODULE_78__.Unicorn,
    439: _serverScripts_operators_439__WEBPACK_IMPORTED_MODULE_79__.Paks,
    449: _serverScripts_operators_449__WEBPACK_IMPORTED_MODULE_80__.OneTouchTravel,
    450: _serverScripts_operators_450__WEBPACK_IMPORTED_MODULE_81__.PegasTui,
    451: _serverScripts_operators_skanTour__WEBPACK_IMPORTED_MODULE_104__.SkanTour,
    452: _serverScripts_operators_452__WEBPACK_IMPORTED_MODULE_82__.D2,
    453: _serverScripts_operators_453__WEBPACK_IMPORTED_MODULE_83__.Veditour,
    454: _serverScripts_operators_454__WEBPACK_IMPORTED_MODULE_84__.IziTour,
    457: _serverScripts_operators_457__WEBPACK_IMPORTED_MODULE_85__.FunSunKz,
    521: _serverScripts_operators_vodohod__WEBPACK_IMPORTED_MODULE_105__.Vodohod,
    536: _serverScripts_operators_536__WEBPACK_IMPORTED_MODULE_86__.Krypton,
    544: _serverScripts_operators_544__WEBPACK_IMPORTED_MODULE_87__.CrimeanWave,
    560: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    564: _serverScripts_operators_564__WEBPACK_IMPORTED_MODULE_88__.RZHDTour,
    565: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    587: _serverScripts_operators_970__WEBPACK_IMPORTED_MODULE_89__.TourPlatforma,
    593: _serverScripts_operators_letsFly__WEBPACK_IMPORTED_MODULE_95__.LetsFly,
    620: _serverScripts_operators_unona__WEBPACK_IMPORTED_MODULE_108__.Unona,
    743: _serverScripts_operators_743__WEBPACK_IMPORTED_MODULE_90__.Loti,
    747: _serverScripts_operators_magput__WEBPACK_IMPORTED_MODULE_109__.MagPut,
    768: _serverScripts_operators_768__WEBPACK_IMPORTED_MODULE_91__.Mercury,
    797: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    800: _serverScripts_operators_800__WEBPACK_IMPORTED_MODULE_92__.MyAgent,
    820: _serverScripts_operators_rusExpress__WEBPACK_IMPORTED_MODULE_9__.RusExpress,
    803: _serverScripts_operators_letsFly__WEBPACK_IMPORTED_MODULE_95__.LetsFly,
    821: _serverScripts_operators_eskazan__WEBPACK_IMPORTED_MODULE_100__.EsKazan,
    857: _serverScripts_operators_iway__WEBPACK_IMPORTED_MODULE_93__.IWay,
    860: _serverScripts_operators_melinoTravel__WEBPACK_IMPORTED_MODULE_106__.MelinoTravel,
    861: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    897: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    917: _serverScripts_operators_inturist__WEBPACK_IMPORTED_MODULE_5__.Intourist,
    926: _serverScripts_operators_oneClickTravel__WEBPACK_IMPORTED_MODULE_101__.OneClickTravel,
    922: _serverScripts_operators_rivieraTour__WEBPACK_IMPORTED_MODULE_107__.RivieraTour,
    943: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    949: _serverScripts_operators_kazunion__WEBPACK_IMPORTED_MODULE_102__.Kazunion,
    970: _serverScripts_operators_970__WEBPACK_IMPORTED_MODULE_89__.TourPlatforma,
    2147483639: _serverScripts_operators_2147483639__WEBPACK_IMPORTED_MODULE_96__.CityTravel,
    2147483640: _serverScripts_operators_2147483640__WEBPACK_IMPORTED_MODULE_97__.AcademService,
    2147483641: _serverScripts_operators_2147483641__WEBPACK_IMPORTED_MODULE_98__.Bronevik,
    2147483642: _serverScripts_operators_7__WEBPACK_IMPORTED_MODULE_4__.BiblioGlobus,
    2147483643: _serverScripts_operators_252__WEBPACK_IMPORTED_MODULE_53__.Alean,
    2147483645: _serverScripts_operators_2147483645__WEBPACK_IMPORTED_MODULE_99__.Ostrovok,
    2147483646: _serverScripts_operators_800__WEBPACK_IMPORTED_MODULE_92__.MyAgent
};


/***/ }),

/***/ "./src/app/utils/chunks/common/clientUtils.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/common/clientUtils.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   wait: () => (/* binding */ wait)
/* harmony export */ });
// тут будут лежать полезные скрипты, которые нужно копировать при добавлении кода на сайте ТО
function getTouristAge(tourist) {
    const [day, month, year] = tourist.birthday.split('.');
    const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
    const ageDate = new Date(ageDiffMs);
    return ageDate.getUTCFullYear() - 1970;
}
function wait(timeout) {
    return new Promise((resolve) => {
        setTimeout(() => resolve(), timeout);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/common/executeContentScript.ts":
/*!*************************************************************!*\
  !*** ./src/app/utils/chunks/common/executeContentScript.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeContentScript: () => (/* binding */ executeContentScript)
/* harmony export */ });
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../messages */ "./src/app/messages/index.ts");
/* harmony import */ var _sendTabMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");


function executeContentScript(tab, data) {
    (0,_sendTabMessage__WEBPACK_IMPORTED_MODULE_1__.sendTabMessage)(tab.id, (0,_messages__WEBPACK_IMPORTED_MODULE_0__.createExecuteContentScriptMessage)(data));
}


/***/ }),

/***/ "./src/app/utils/chunks/common/oneForNoData.ts":
/*!*****************************************************!*\
  !*** ./src/app/utils/chunks/common/oneForNoData.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   oneForNoData: () => (/* binding */ oneForNoData)
/* harmony export */ });
function oneForNoData(tourist) {
    if (tourist.IsNationalPassport || tourist.isNationalPassport) {
        tourist.passportSeries = tourist.isNoPassportData || !tourist.passportSeries || tourist.passportSeries === '' ? '1'.repeat(4) : tourist.passportSeries;
        tourist.passportNumber = tourist.isNoPassportData || !tourist.passportNumber || tourist.passportNumber === '' ? '1'.repeat(6) : tourist.passportNumber;
    }
    else {
        tourist.passportSeries = tourist.isNoPassportData || !tourist.passportSeries || tourist.passportSeries === '' ? '1'.repeat(2) : tourist.passportSeries;
        tourist.passportNumber = tourist.isNoPassportData || !tourist.passportNumber || tourist.passportNumber === '' ? '1'.repeat(7) : tourist.passportNumber;
    }
    return tourist;
}


/***/ }),

/***/ "./src/app/utils/chunks/constants_urls.ts":
/*!************************************************!*\
  !*** ./src/app/utils/chunks/constants_urls.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CB_CLAIM_FULL_PATH: () => (/* binding */ CB_CLAIM_FULL_PATH),
/* harmony export */   CB_CLAIM_ID_PARAM: () => (/* binding */ CB_CLAIM_ID_PARAM),
/* harmony export */   CB_CLAIM_PATH: () => (/* binding */ CB_CLAIM_PATH),
/* harmony export */   CB_HOSTS: () => (/* binding */ CB_HOSTS),
/* harmony export */   cbApiUrl: () => (/* binding */ cbApiUrl),
/* harmony export */   scriptsApiUrl: () => (/* binding */ scriptsApiUrl),
/* harmony export */   toNumberSaveUrl: () => (/* binding */ toNumberSaveUrl)
/* harmony export */ });
// const env: string = 'local';
// const env: string = 'dev';
const env = 'prod';
// local api: http://local-api-cbdebug.sletat.ru
// dev api: https://api-cbdebug.sletat.ru
// urls
const cbApiUrl = env === 'local' ?
    'http://localhost:8081' :
    env === 'dev' ?
        'https://api-cbdebug.sletat.ru' :
        'https://api-cb.global.sletat.ru';
const toNumberSaveUrl = cbApiUrl + '/private/toolbarapi/setTourOperatorClaimNumber';
// TODO: не забыть поменять обратно https://autofill-api.sletat.ru
const scriptsApiUrl = env === 'local' || env === 'dev' ?
    'https://autofill-api.global.sletat.ru' :
    'https://autofill-api.global.sletat.ru';
//https://autofill-api.sletat.ru;
// dev-api: cbdebug.sletat.ru
// local-api: local-booking.sletat.ru
// url parts
const CB_HOSTS = env === 'local' ?
    ['127.0.0.1:8080', 'local-booking.sletat.ru'] :
    env === 'dev' ?
        ['cbdebug.sletat.ru', 'cbdebug7.sletat.ru'] :
        ['cb.sletat.ru', 'cb-25.sletat.ru', 'cb-75.sletat.ru', 'cb-rsv.sletat.ru', 'cb.global.sletat.ru', 'cb-beta.global.sletat.ru'];
const CB_CLAIM_PATH = '/Claim';
const CB_CLAIM_FULL_PATH = '/Claim/Index';
const CB_CLAIM_ID_PARAM = 'claimId';


/***/ }),

/***/ "./src/app/utils/chunks/createPushNotification.ts":
/*!********************************************************!*\
  !*** ./src/app/utils/chunks/createPushNotification.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPushNotification: () => (/* binding */ createPushNotification)
/* harmony export */ });
/* harmony import */ var _models_chunks_createFillFnMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../models/chunks/createFillFnMessage */ "./src/app/models/chunks/createFillFnMessage.ts");
/* harmony import */ var _models_chunks_createSendIdsMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/chunks/createSendIdsMessage */ "./src/app/models/chunks/createSendIdsMessage.ts");


function createPushNotification(options) {
    let pushMessage = { title: '', body: { toString: () => '' } };
    switch (true) {
        case (options.hasOwnProperty('claimId')):
            const { claimId, operator, errorText } = options;
            pushMessage = (0,_models_chunks_createFillFnMessage__WEBPACK_IMPORTED_MODULE_0__.createFillFnMessage)({ claimId, operator, errorText });
            break;
        case (options.hasOwnProperty('status')):
            const { status, message } = options;
            pushMessage = (0,_models_chunks_createSendIdsMessage__WEBPACK_IMPORTED_MODULE_1__.createSendIdsMessage)({ status, message });
            break;
        case (options.hasOwnProperty('notificationMessage')):
            const { notificationMessage, title } = options;
            pushMessage.body = notificationMessage;
            pushMessage.title = title;
            pushMessage.toString = () => pushMessage.body.toString();
            break;
        default:
            break;
    }
    return new Promise((resolve, reject) => {
        chrome.notifications.create({ type: 'basic', iconUrl: 'icon.png', title: pushMessage.title, message: pushMessage.toString() }, () => resolve());
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/createTab.ts":
/*!*******************************************!*\
  !*** ./src/app/utils/chunks/createTab.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createNewTab: () => (/* binding */ createNewTab),
/* harmony export */   createTab: () => (/* binding */ createTab)
/* harmony export */ });
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
function createTab(_a) {
    return __awaiter(this, arguments, void 0, function* ({ active, url }) {
        var tabs = yield chrome.tabs.query({ active: true, lastFocusedWindow: true });
        const properties = {
            url: url,
            active: active,
            index: tabs && tabs.length >= 1
                ? tabs[0].index + 1
                : undefined
        };
        var tab = yield chrome.tabs.create(properties);
        return tab;
    });
}
function createNewTab(url) {
    return __awaiter(this, void 0, void 0, function* () {
        return createTab({
            active: true,
            url: url,
            windowId: chrome.windows.WINDOW_ID_CURRENT
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts":
/*!***********************************************************!*\
  !*** ./src/app/utils/chunks/executeLoginScriptInTabV3.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeLoginScriptInTabV3: () => (/* binding */ executeLoginScriptInTabV3)
/* harmony export */ });
/* harmony import */ var _executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _loginFormCode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./loginFormCode */ "./src/app/utils/chunks/loginFormCode.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function executeLoginScriptInTabV3(tab, selector) {
    return __awaiter(this, void 0, void 0, function* () {
        yield (0,_executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__.executeScriptInTabV3)(tab, _loginFormCode__WEBPACK_IMPORTED_MODULE_1__.getLoginFormCode, [selector]);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/executeScriptInTab.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/executeScriptInTab.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeScriptInTabV3: () => (/* binding */ executeScriptInTabV3),
/* harmony export */   injectFillScriptInTabAndRun: () => (/* binding */ injectFillScriptInTabAndRun)
/* harmony export */ });
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
function executeScriptInTabV3(tab, func, args) {
    return __awaiter(this, void 0, void 0, function* () {
        //await injectCoreFunctionsIntoPage(tab);
        let result = yield chrome.scripting.executeScript({
            target: { tabId: tab.id },
            func: func,
            args: args
        });
        return result[0];
    });
}
function injectFillScriptInTabAndRun(tab, fileName, param) {
    return __awaiter(this, void 0, void 0, function* () {
        // @ts-ignore
        yield executeScriptInTabV3(tab, (auto_context) => { auto_context_data = auto_context; }, [param]);
        yield chrome.scripting.executeScript({
            target: { tabId: tab.id, allFrames: false },
            files: [fileName],
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/goToClaimOperatorType.ts":
/*!*******************************************************!*\
  !*** ./src/app/utils/chunks/goToClaimOperatorType.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GoToClaimOperatorType: () => (/* binding */ GoToClaimOperatorType)
/* harmony export */ });
var GoToClaimOperatorType;
(function (GoToClaimOperatorType) {
    GoToClaimOperatorType[GoToClaimOperatorType["Base"] = 0] = "Base";
    GoToClaimOperatorType[GoToClaimOperatorType["Another"] = 1] = "Another";
    GoToClaimOperatorType[GoToClaimOperatorType["Accomodation"] = 2] = "Accomodation";
    GoToClaimOperatorType[GoToClaimOperatorType["Flight"] = 3] = "Flight";
})(GoToClaimOperatorType || (GoToClaimOperatorType = {}));


/***/ }),

/***/ "./src/app/utils/chunks/loginFormCode.ts":
/*!***********************************************!*\
  !*** ./src/app/utils/chunks/loginFormCode.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getLoginFormCode: () => (/* binding */ getLoginFormCode)
/* harmony export */ });
function getLoginFormCode(pageSelectors) {
    try {
        debugger;
        console.log('getLoginFormCode');
        console.dir(pageSelectors);
        console.log(pageSelectors.packet.loginPath);
        console.log(pageSelectors.packet.passwordPath);
        console.log(pageSelectors.packet.submitPath);
        let login = document.querySelector(pageSelectors.packet.loginPath);
        let password = document.querySelector(pageSelectors.packet.passwordPath);
        let submit = document.querySelector(pageSelectors.packet.submitPath);
        console.log('getLoginFormCode 1');
        if (login !== null) {
            console.log('getLoginFormCode 2');
            login.dispatchEvent(new Event('focus'));
            login.value = `${pageSelectors.login}`;
            // on TUI site there's Knockout hook matching only on keypress event
            // so without this workaroud we couldn't post login value
            login.dispatchEvent(new Event('keypress', { bubbles: true }));
            login.dispatchEvent(new Event('input', { bubbles: true }));
            login.dispatchEvent(new Event('change', { bubbles: true }));
            login.dispatchEvent(new Event('blur', { bubbles: true }));
            password.dispatchEvent(new Event('focus', { bubbles: true }));
            password.value = `${pageSelectors.password}`;
            password.dispatchEvent(new Event('input', { bubbles: true }));
            password.dispatchEvent(new Event('keypress', { bubbles: true }));
            password.dispatchEvent(new Event('change', { bubbles: true }));
            password.dispatchEvent(new Event('blur', { bubbles: true }));
            setTimeout(function () { submit.click(); }, 500);
        }
    }
    catch (e) {
        console.warn(e);
    }
}


/***/ }),

/***/ "./src/app/utils/chunks/makeOperatorSenderButton.ts":
/*!**********************************************************!*\
  !*** ./src/app/utils/chunks/makeOperatorSenderButton.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   makeOperatorSenderButton: () => (/* binding */ makeOperatorSenderButton)
/* harmony export */ });
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../models */ "./src/app/models/index.ts");
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../operators */ "./src/app/operators.ts");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants */ "./src/app/utils/constants.ts");
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dom */ "./src/app/utils/dom.ts");




const getErrorType = (claimIdTO, sourceId) => {
    if (!sourceId || !sourceId.length) {
        return _models__WEBPACK_IMPORTED_MODULE_0__.ErrorTypes.NO_TO_ID;
    }
    if (!claimIdTO || !claimIdTO.length) {
        return _models__WEBPACK_IMPORTED_MODULE_0__.ErrorTypes.NO_CLAIM_ID;
    }
    if (sourceId && !(parseInt(sourceId, 10) in _operators__WEBPACK_IMPORTED_MODULE_1__.OPERATORS)) {
        return _models__WEBPACK_IMPORTED_MODULE_0__.ErrorTypes.TO_NOT_SUPPORTED;
    }
    return _models__WEBPACK_IMPORTED_MODULE_0__.ErrorTypes.UNKNOWN;
};
const makeOperatorSenderButton = (sourceId, claimIdTO, type, toAlias) => {
    const style = _constants__WEBPACK_IMPORTED_MODULE_2__.claimMagnifierButtonStyles[type];
    const sendNotPossible = !sourceId.length && !toAlias || !claimIdTO.length;
    const button = (0,_dom__WEBPACK_IMPORTED_MODULE_3__.createElement)('button', style);
    button.dataset.claimTouroperatorNumber = claimIdTO;
    button.dataset.sourceId = sourceId;
    button.dataset.tooltip = `${!sendNotPossible ?
        style.title : getErrorType(claimIdTO, sourceId)}`;
    button.appendChild((0,_dom__WEBPACK_IMPORTED_MODULE_3__.createElement)('i', { className: `icon ${!sendNotPossible ? 'search' : 'ban'}` }));
    if (sendNotPossible) {
        button.classList.add('grey');
        button.style.cursor = 'not-allowed';
    }
    else {
        button.classList.add(style.activeClass);
        button.style.cursor = 'pointer';
    }
    return button;
};


/***/ }),

/***/ "./src/app/utils/chunks/removeCookies.ts":
/*!***********************************************!*\
  !*** ./src/app/utils/chunks/removeCookies.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   removeCookies: () => (/* binding */ removeCookies),
/* harmony export */   removeCookiesCreateTabAndLogin: () => (/* binding */ removeCookiesCreateTabAndLogin),
/* harmony export */   removeCookiesForTouroperator: () => (/* binding */ removeCookiesForTouroperator)
/* harmony export */ });
/* harmony import */ var _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _createTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




function removeCookies(params) {
    return __awaiter(this, void 0, void 0, function* () {
        for (let cookieName of params.cookieNames) {
            yield chrome.cookies.remove({ url: params.url, name: cookieName });
        }
    });
}
function removeCookiesForTouroperator(operator) {
    return __awaiter(this, void 0, void 0, function* () {
        yield removeCookies({
            url: operator.link(),
            cookieNames: operator.cookie.auth
        });
    });
}
function removeCookiesCreateTabAndLogin(params) {
    return __awaiter(this, void 0, void 0, function* () {
        yield removeCookiesForTouroperator(params.operator);
        let tab = yield (0,_createTab__WEBPACK_IMPORTED_MODULE_1__.createTab)({
            active: true,
            url: params.newTabUrl
        });
        yield (0,_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, params.operator.packet.loginPath);
        yield (0,_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_2__.executeLoginScriptInTabV3)(tab, new _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
            login: params.login,
            password: params.password,
            packet: params.operator.packet
        }));
        return tab;
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/sendTabMessage.ts":
/*!************************************************!*\
  !*** ./src/app/utils/chunks/sendTabMessage.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sendTabMessage: () => (/* binding */ sendTabMessage)
/* harmony export */ });
function sendTabMessage(tabId, message) {
    return new Promise((resolve, reject) => {
        chrome.tabs.sendMessage(tabId, message, (response) => {
            // console.log('RESPONSE TAB ', response);
            return resolve(response);
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/startTrackingElementInternal.ts":
/*!**************************************************************!*\
  !*** ./src/app/utils/chunks/startTrackingElementInternal.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   startTrackingElement: () => (/* binding */ startTrackingElement),
/* harmony export */   startTrackingElementDisappear: () => (/* binding */ startTrackingElementDisappear)
/* harmony export */ });
/* harmony import */ var _sendTabMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../messages */ "./src/app/messages/index.ts");


// грубо говоря эта функция ждет появления selector в tab-e
function startTrackingElement(tab, selector, frame, delay = 1000, maxWaitTime = 300000) {
    return startTrackingElementInternal(response => response.element, tab, selector, frame, delay, maxWaitTime);
}
function startTrackingElementDisappear(tab, selector, frame, delay = 1000, maxWaitTime = 300000) {
    return startTrackingElementInternal(response => !response.element, tab, selector, frame, delay, maxWaitTime);
}
const startTrackingElementInternal = (conditionFunc, tab, selector, frame, delay = 1000, maxWaitTime = 300000) => {
    return new Promise((resolve, reject) => {
        const curTime = Date.now();
        const timer = setInterval(() => {
            (0,_sendTabMessage__WEBPACK_IMPORTED_MODULE_0__.sendTabMessage)(tab.id, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetElementMessage)({ elementSelector: selector, frame: frame }))
                .then((response) => {
                if (response && conditionFunc(response)) {
                    clearInterval(timer);
                    resolve(response);
                }
                if (Date.now() - curTime >= maxWaitTime) {
                    clearInterval(timer);
                    reject(null);
                }
            });
        }, delay);
    });
};


/***/ }),

/***/ "./src/app/utils/chunks/updateListener.ts":
/*!************************************************!*\
  !*** ./src/app/utils/chunks/updateListener.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   updateListener: () => (/* binding */ updateListener),
/* harmony export */   updateListenerOnSpecificNewPage: () => (/* binding */ updateListenerOnSpecificNewPage),
/* harmony export */   updateListenerOnSpecificPage: () => (/* binding */ updateListenerOnSpecificPage)
/* harmony export */ });
function updateListener(baseTabId, onUpdateFunc) {
    const updatedLiscener = (tabId, changeInfo, updatedTab) => {
        onUpdateFunc(tabId, changeInfo, updatedTab);
    };
    chrome.tabs.onUpdated.addListener(updatedLiscener);
    const removedLiscener = (tabId, removeInfo) => {
        if (tabId === baseTabId) {
            chrome.tabs.onUpdated.removeListener(updatedLiscener);
            chrome.tabs.onRemoved.removeListener(removedLiscener);
        }
    };
    chrome.tabs.onRemoved.addListener(removedLiscener);
}
function updateListenerOnSpecificPage(baseTabId, pageRegExp, onUpdateFunc) {
    const updatedLiscener = (tabId, changeInfo, updatedTab) => {
        console.log('updateListenerOnSpecificPage' + updatedTab.url);
        if (changeInfo.status && changeInfo.status.toLowerCase() === 'complete'
            && tabId === baseTabId
            && updatedTab.url
            && pageRegExp.test(updatedTab.url)) {
            if (onUpdateFunc(tabId, changeInfo, updatedTab) && chrome.tabs.onUpdated.hasListener(updatedLiscener)) {
                chrome.tabs.onUpdated.removeListener(updatedLiscener);
            }
        }
    };
    chrome.tabs.onUpdated.addListener(updatedLiscener);
    const removedLiscener = (tabId, removeInfo) => {
        if (tabId === baseTabId) {
            chrome.tabs.onUpdated.removeListener(updatedLiscener);
            chrome.tabs.onRemoved.removeListener(removedLiscener);
        }
    };
    chrome.tabs.onRemoved.addListener(removedLiscener);
}
function updateListenerOnSpecificNewPage(baseTabId, pageRegExp, onUpdateFunc) {
    const updatedLiscener = (tabId, changeInfo, updatedTab) => {
        console.log('updateListenerOnSpecificNewPage' + updatedTab.url);
        if (changeInfo.status && changeInfo.status.toLowerCase() === 'complete'
            && updatedTab.openerTabId
            && updatedTab.openerTabId == baseTabId
            && updatedTab.url
            && pageRegExp.test(updatedTab.url)) {
            if (onUpdateFunc(tabId, changeInfo, updatedTab) && chrome.tabs.onUpdated.hasListener(updatedLiscener)) {
                chrome.tabs.onUpdated.removeListener(updatedLiscener);
            }
        }
    };
    chrome.tabs.onUpdated.addListener(updatedLiscener);
    const removedLiscener = (tabId, removeInfo) => {
        if (tabId === baseTabId) {
            chrome.tabs.onUpdated.removeListener(updatedLiscener);
            chrome.tabs.onRemoved.removeListener(removedLiscener);
        }
    };
    chrome.tabs.onRemoved.addListener(removedLiscener);
}


/***/ }),

/***/ "./src/app/utils/constants.ts":
/*!************************************!*\
  !*** ./src/app/utils/constants.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RU_DOMISTIC_COUNTRIES: () => (/* binding */ RU_DOMISTIC_COUNTRIES),
/* harmony export */   claimAnotherTOAliasSelector: () => (/* binding */ claimAnotherTOAliasSelector),
/* harmony export */   claimIdTOSelector: () => (/* binding */ claimIdTOSelector),
/* harmony export */   claimMagnifierButtonStyles: () => (/* binding */ claimMagnifierButtonStyles),
/* harmony export */   claimMagnifierOperatorTypes: () => (/* binding */ claimMagnifierOperatorTypes),
/* harmony export */   claimNumberSelector: () => (/* binding */ claimNumberSelector),
/* harmony export */   claimRefundFillerOperators: () => (/* binding */ claimRefundFillerOperators),
/* harmony export */   claimSecretFieldAttr: () => (/* binding */ claimSecretFieldAttr),
/* harmony export */   claimSecretFieldId: () => (/* binding */ claimSecretFieldId),
/* harmony export */   claimTOAliasSelector: () => (/* binding */ claimTOAliasSelector),
/* harmony export */   claimTransferFillerOperators: () => (/* binding */ claimTransferFillerOperators),
/* harmony export */   fileHostName: () => (/* binding */ fileHostName),
/* harmony export */   loaderImageName: () => (/* binding */ loaderImageName),
/* harmony export */   mockPrevVisasData: () => (/* binding */ mockPrevVisasData),
/* harmony export */   myAgentTicketButtonOptions: () => (/* binding */ myAgentTicketButtonOptions),
/* harmony export */   myAgentTicketTransferButtonOptions: () => (/* binding */ myAgentTicketTransferButtonOptions),
/* harmony export */   refundPaymentTOButtonOptions: () => (/* binding */ refundPaymentTOButtonOptions),
/* harmony export */   sourceAutoFillAccomodationSelector: () => (/* binding */ sourceAutoFillAccomodationSelector),
/* harmony export */   sourceAutoFillAnotherSelector: () => (/* binding */ sourceAutoFillAnotherSelector),
/* harmony export */   sourceAutoFillFlightSelector: () => (/* binding */ sourceAutoFillFlightSelector),
/* harmony export */   sourceAutoFillSelector: () => (/* binding */ sourceAutoFillSelector),
/* harmony export */   sourceAutoFillerToken: () => (/* binding */ sourceAutoFillerToken),
/* harmony export */   sourceAutoFillerTokenAccomodation: () => (/* binding */ sourceAutoFillerTokenAccomodation),
/* harmony export */   sourceAutoFillerTokenAnother: () => (/* binding */ sourceAutoFillerTokenAnother),
/* harmony export */   sourceAutoFillerTokenFlight: () => (/* binding */ sourceAutoFillerTokenFlight),
/* harmony export */   sourceIdSelector: () => (/* binding */ sourceIdSelector),
/* harmony export */   transferPaymentTOButtonOptions: () => (/* binding */ transferPaymentTOButtonOptions)
/* harmony export */ });
const RU_DOMISTIC_COUNTRIES = 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия';
// selectors
const sourceAutoFillSelector = 'input[data-claim="autofill-data-touroperator"]';
const sourceAutoFillAnotherSelector = 'input[data-claim="autofill-data-another-touroperator"]';
const sourceAutoFillAccomodationSelector = 'input[data-claim="autofill-data-accomodation-touroperator"]';
const sourceAutoFillFlightSelector = 'input[data-claim="autofill-data-flight-touroperator"]';
const sourceAutoFillerToken = '#AutoFillerToken';
const sourceAutoFillerTokenAnother = '#AutoFillerTokenAnother';
const sourceAutoFillerTokenAccomodation = '#AutoFillerTokenAccomodation';
const sourceAutoFillerTokenFlight = '#AutoFillerTokenFlight';
const sourceIdSelector = '[data-claim-sourceid]';
const claimNumberSelector = '[data-claim-number]';
const claimIdTOSelector = '[data-claim-touroperatornumber]';
const claimSecretFieldId = '#AutoFillerToken';
const claimSecretFieldAttr = '[data-autofiller]';
const claimTOAliasSelector = '[data-claim-toalias]';
const claimAnotherTOAliasSelector = '[data-claim-anothertoalias]';
const loaderImageName = 'loader.gif';
//export const loaderImageName = 'loader-new_year.gif';
// loaders
const fileHostName = 'https://localhost:5555/api/visa-fill/version';
const mockPrevVisasData = [
    {
        countyName: 'Исландия',
        countryId: 0,
        validFrom: '03.02.2016',
        validTo: '04.02.2016',
        number: 'AAAA',
    },
    {
        countyName: 'Швеция',
        countryId: 0,
        validFrom: '03.02.2017',
        validTo: '04.02.2017',
        number: 'AAAA',
    }
];
const transferPaymentTOButtonOptions = {
    className: 'uk-button uk-button-minw-40',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Перейти на страницу оформления переноса',
};
const refundPaymentTOButtonOptions = {
    className: 'uk-button uk-button-minw-40',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Перейти на страницу оформления возврата',
};
const myAgentTicketButtonOptions = {
    className: 'uk-button uk-button-minw-40',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Купить билет на Мой Агент',
};
const myAgentTicketTransferButtonOptions = {
    className: 'uk-button uk-button-minw-40 myAgentTransfer',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Купить билет на Мой Агент',
};
const claimTransferFillerOperators = [9];
const claimRefundFillerOperators = [9];
//export const goToMyAgentOperators: number[] = [452];
// each operator now has several magnifier buttons with different behaviour
const claimMagnifierOperatorTypes = {
    3: ['default', 'reserve'],
    4: ['default'],
    6: ['default'],
    7: ['default'],
    9: ['default'],
    14: ['default'],
    19: ['default', 'reserve'],
    20: ['default'],
    38: ['default'],
    39: ['default'],
    41: ['default'],
    46: ['default'],
    49: ['default'],
    51: ['default'],
    53: ['default'],
    54: ['default'],
    78: ['default'],
    81: ['default'],
    83: ['default'],
    87: ['default'],
    93: ['default'],
    107: ['default'],
    108: ['default'],
    112: ['default'],
    113: ['default'],
    123: ['default'],
    125: ['default'],
    130: ['default'],
    131: ['default'],
    141: ['default'],
    153: ['default'],
    155: ['default'],
    158: ['default'],
    160: ['default'],
    165: ['default'],
    171: ['default'],
    184: ['default'],
    199: ['default'],
    205: ['default'],
    213: ['default'],
    214: ['default'],
    229: ['default'],
    231: ['default'],
    237: ['default'],
    238: ['default'],
    248: ['default'],
    252: ['default'],
    259: ['default'],
    260: ['default'],
    269: ['default'],
    277: ['default'],
    301: ['default'],
    302: ['default'],
    304: ['default'],
    306: ['default'],
    309: ['default'],
    311: ['default'],
    315: ['default'],
    331: ['default'],
    343: ['default'],
    344: ['default'],
    345: ['default'],
    348: ['default'],
    355: ['default'],
    361: ['default'],
    380: ['default'],
    431: ['default'],
};
// styles for each magnifier buttonType
const claimMagnifierButtonStyles = {
    'default': {
        id: 'autofill-goto-claim',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО',
        activeClass: 'orange',
    },
    'default-another': {
        id: 'autofill-goto-claim-another',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО (фактический)',
        activeClass: 'purple',
    },
    'default-acc': {
        id: 'autofill-goto-claim-accomodation',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО (проживание)',
        activeClass: 'green',
    },
    'default-flg': {
        id: 'autofill-goto-claim-flight',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО (перелет)',
        activeClass: 'yellow',
    },
    'reserve': {
        id: 'autofill-goto-claim',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на резервном сайте ТО',
        activeClass: 'blue',
    },
};


/***/ }),

/***/ "./src/app/utils/dom.ts":
/*!******************************!*\
  !*** ./src/app/utils/dom.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createElement: () => (/* binding */ createElement),
/* harmony export */   getClaimDataFields: () => (/* binding */ getClaimDataFields),
/* harmony export */   getTourOperatorClaimDataFields: () => (/* binding */ getTourOperatorClaimDataFields),
/* harmony export */   makeOperatorGoToMyAgentButton: () => (/* binding */ makeOperatorGoToMyAgentButton),
/* harmony export */   makeOperatorGoToMyAgentTransferButton: () => (/* binding */ makeOperatorGoToMyAgentTransferButton),
/* harmony export */   makeOperatorGoToPaymentRefundButton: () => (/* binding */ makeOperatorGoToPaymentRefundButton),
/* harmony export */   makeOperatorGoToPaymentTransferButton: () => (/* binding */ makeOperatorGoToPaymentTransferButton)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./src/app/utils/constants.ts");

function setElementProps(element, props) {
    Object.keys(props).forEach((key) => {
        element[key] = props[key];
        if (props[key] instanceof Object) {
            setElementProps(element[key], props[key]);
        }
    });
}
function createElement(tagName, options) {
    const element = document.createElement(tagName);
    if (options) {
        setElementProps(element, options);
    }
    return element;
}
function getClaimDataFields() {
    return {
        sourceId: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.sourceIdSelector),
        claimIdTO: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimIdTOSelector),
        claimNumber: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimNumberSelector),
        secretField: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimSecretFieldId + _constants__WEBPACK_IMPORTED_MODULE_0__.claimSecretFieldAttr),
        toAlias: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimTOAliasSelector),
        anotherToAlias: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimAnotherTOAliasSelector),
    };
}
function getTourOperatorClaimDataFields(sourceSelector, tokenSelector) {
    if (sourceSelector != undefined || sourceSelector != null) {
        return {
            claimData: document.querySelector(sourceSelector),
            secretField: document.querySelector(tokenSelector)
        };
    }
    return {};
}
const makeOperatorGoToPaymentTransferButton = () => {
    const button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.transferPaymentTOButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-arrow-right' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};
const makeOperatorGoToPaymentRefundButton = () => {
    const button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.refundPaymentTOButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-arrow-right' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};
const makeOperatorGoToMyAgentButton = () => {
    const button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.myAgentTicketButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-ticket' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};
const makeOperatorGoToMyAgentTransferButton = () => {
    const button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.myAgentTicketTransferButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-ticket' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};


/***/ }),

/***/ "./src/app/utils/index.ts":
/*!********************************!*\
  !*** ./src/app/utils/index.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addMessageListener: () => (/* reexport safe */ _messages__WEBPACK_IMPORTED_MODULE_3__.addMessageListener),
/* harmony export */   createElement: () => (/* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_2__.createElement),
/* harmony export */   detectSender: () => (/* reexport safe */ _messages__WEBPACK_IMPORTED_MODULE_3__.detectSender),
/* harmony export */   getClaimDataFields: () => (/* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_2__.getClaimDataFields),
/* harmony export */   getCurrentTab: () => (/* reexport safe */ _tabs__WEBPACK_IMPORTED_MODULE_1__.getCurrentTab),
/* harmony export */   getTourOperatorClaimDataFields: () => (/* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_2__.getTourOperatorClaimDataFields),
/* harmony export */   sendMessage: () => (/* reexport safe */ _messages__WEBPACK_IMPORTED_MODULE_3__.sendMessage),
/* harmony export */   startTrackingElementInCurTab: () => (/* binding */ startTrackingElementInCurTab),
/* harmony export */   stringifyQsParams: () => (/* reexport safe */ _url__WEBPACK_IMPORTED_MODULE_0__.stringifyQsParams),
/* harmony export */   waitForDocumentReady: () => (/* binding */ waitForDocumentReady)
/* harmony export */ });
/* harmony import */ var _url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./url */ "./src/app/utils/url.ts");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dom */ "./src/app/utils/dom.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./messages */ "./src/app/utils/messages.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../messages */ "./src/app/messages/index.ts");
/* harmony import */ var _chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./chunks/sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







function waitForDocumentReady(tab, delay = 1000) {
    return new Promise((resolve, reject) => {
        function func() {
            chrome.webNavigation.onDOMContentLoaded.removeListener(func);
            resolve();
        }
        chrome.webNavigation.onDOMContentLoaded.addListener(func);
    });
}
function startTrackingElementInCurTab(selector, delay = 1000) {
    return new Promise((resolve, reject) => {
        const curTime = Date.now();
        const timer = setInterval(() => __awaiter(this, void 0, void 0, function* () {
            const tab = yield (0,_tabs__WEBPACK_IMPORTED_MODULE_1__.getCurrentTab)();
            (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_5__.sendTabMessage)(tab.id, (0,_messages__WEBPACK_IMPORTED_MODULE_4__.createGetElementMessage)({ elementSelector: selector }))
                .then((response) => {
                if (response && response.element) {
                    clearInterval(timer);
                    resolve(tab);
                }
                if (Date.now() - curTime >= 300000 && !response.element) {
                    clearInterval(timer);
                    reject('Time limit exeeded');
                }
            });
        }), delay);
    });
}


/***/ }),

/***/ "./src/app/utils/messages.ts":
/*!***********************************!*\
  !*** ./src/app/utils/messages.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addMessageListener: () => (/* binding */ addMessageListener),
/* harmony export */   detectSender: () => (/* binding */ detectSender),
/* harmony export */   requestOnClaimPageLogin: () => (/* binding */ requestOnClaimPageLogin),
/* harmony export */   requestSearchForm: () => (/* binding */ requestSearchForm),
/* harmony export */   requestToursitLinks: () => (/* binding */ requestToursitLinks),
/* harmony export */   sendMessage: () => (/* binding */ sendMessage)
/* harmony export */ });
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models */ "./src/app/models/index.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../messages */ "./src/app/messages/index.ts");
/* harmony import */ var _chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./chunks/sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



function addMessageListener(listener) {
    chrome.runtime.onMessage.addListener(listener);
    return () => {
        chrome.runtime.onMessage.removeListener(listener);
    };
}
function sendMessage(message) {
    return new Promise((resolve, reject) => {
        chrome.runtime.sendMessage(message, (response) => resolve(response));
    });
}
function detectSender(sender) {
    const { url } = sender;
    if (url.indexOf('chrome-extension') > -1) {
        return _models__WEBPACK_IMPORTED_MODULE_0__.SenderTypes.EXT_SENDER;
    }
    return _models__WEBPACK_IMPORTED_MODULE_0__.SenderTypes.TAB_SENDER;
}
function requestOnClaimPageLogin(tabId, params, delay = 1000) {
    return new Promise((resolve, reject) => {
        const curTime = Date.now();
        const timer = setInterval(() => {
            (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__.sendTabMessage)(tabId, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetPageLoginFormMessage)(params))
                .then((response) => {
                if (response.loginForm !== null) {
                    clearInterval(timer);
                    resolve({ needToLogin: true });
                }
                if (Date.now() - curTime >= 5000 && !response.loginForm) {
                    clearInterval(timer);
                    resolve({ needToLogin: false });
                }
            });
        }, delay);
    });
}
function requestSearchForm(tabId, params, delay = 1000) {
    return new Promise((resolve, reject) => {
        const timer = setInterval(() => __awaiter(this, void 0, void 0, function* () {
            try {
                const message = yield (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__.sendTabMessage)(tabId, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetPageSearchFormMessage)(params));
                if (message && message.queryInput !== null) {
                    clearInterval(timer);
                    resolve();
                }
                else {
                    clearInterval(timer);
                    reject();
                }
            }
            catch (e) {
                clearInterval(timer);
                reject();
            }
        }), delay);
    });
}
function requestToursitLinks(tabId, params, delay = 1000) {
    return new Promise((resolve, reject) => {
        const curTime = Date.now();
        const timer = setInterval(() => {
            (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__.sendTabMessage)(tabId, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetTouristLinksMessage)(params))
                .then((response) => {
                if (response.links.length) {
                    clearInterval(timer);
                    resolve(response);
                }
                if (Date.now() - curTime >= 10000 && !response.links.length) {
                    clearInterval(timer);
                    reject('Time limit exeeded');
                }
            });
        }, delay);
    });
}


/***/ }),

/***/ "./src/app/utils/page.ts":
/*!*******************************!*\
  !*** ./src/app/utils/page.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isClaimCheckSupported: () => (/* binding */ isClaimCheckSupported),
/* harmony export */   isClaimPage: () => (/* binding */ isClaimPage),
/* harmony export */   isOperatorSupported: () => (/* binding */ isOperatorSupported)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _chunks_constants_urls__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");


function isClaimPage({ host, pathname, search }) {
    return Boolean(_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_1__.CB_HOSTS.indexOf(host.toLowerCase()) !== -1 &&
        (pathname.toLowerCase() === _chunks_constants_urls__WEBPACK_IMPORTED_MODULE_1__.CB_CLAIM_PATH.toLowerCase() ||
            pathname.toLowerCase() === _chunks_constants_urls__WEBPACK_IMPORTED_MODULE_1__.CB_CLAIM_FULL_PATH.toLowerCase()) &&
        search.toLowerCase().indexOf(_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_1__.CB_CLAIM_ID_PARAM.toLowerCase()) >= 0);
}
function isOperatorSupported(sourceId) {
    return sourceId in _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS;
}
function isClaimCheckSupported(claimNumber, tourOperatorId) {
    return tourOperatorId in _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS
        && claimNumber.length > 0
        && _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[tourOperatorId].hasOwnProperty('link');
}


/***/ }),

/***/ "./src/app/utils/tabs.ts":
/*!*******************************!*\
  !*** ./src/app/utils/tabs.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCurrentTab: () => (/* binding */ getCurrentTab),
/* harmony export */   getCurrentWindow: () => (/* binding */ getCurrentWindow),
/* harmony export */   removeTab: () => (/* binding */ removeTab),
/* harmony export */   updateTab: () => (/* binding */ updateTab),
/* harmony export */   updateTabUrl: () => (/* binding */ updateTabUrl),
/* harmony export */   waitNewTab: () => (/* binding */ waitNewTab)
/* harmony export */ });
function waitNewTab() {
    return new Promise((resolve, reject) => {
        const func = (tab) => {
            chrome.tabs.onCreated.removeListener(func);
            resolve(tab);
        };
        chrome.tabs.onCreated.addListener(func);
    });
}
function getCurrentTab(windowId = chrome.windows.WINDOW_ID_CURRENT) {
    const params = { active: true, windowId };
    return new Promise((resolve, reject) => {
        chrome.tabs.query(params, tabs => resolve(tabs[0]));
    });
}
function getCurrentWindow() {
    return new Promise((resolve, reject) => {
        chrome.windows.getCurrent({
            populate: true
        }, browserWindow => resolve(browserWindow));
    });
}
function updateTab(tabId, options) {
    return new Promise((resolve, reject) => {
        chrome.tabs.update(tabId, options, (updatedTab) => resolve(updatedTab));
    });
}
function updateTabUrl(tab, url) {
    return updateTab(tab.id, { url: url });
}
const removeTab = (tab) => new Promise((resolve) => chrome.tabs.remove(tab.id, () => resolve()));


/***/ }),

/***/ "./src/app/utils/url.ts":
/*!******************************!*\
  !*** ./src/app/utils/url.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyQsParams: () => (/* binding */ stringifyQsParams)
/* harmony export */ });
function stringifyQsParams(params) {
    return Object.keys(params).reduce((acc, param, index, array) => {
        return acc += `${param}=${params[param]}${index === (array.length - 1) ? '' : '&'}`;
    }, '');
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_6.ts":
/*!**************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_6.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contentCoralFill: () => (/* binding */ contentCoralFill),
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_6__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/6 */ "./src/serverScripts/operators/6.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/common/oneForNoData */ "./src/app/utils/chunks/common/oneForNoData.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_common_executeContentScript__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/utils/chunks/common/executeContentScript */ "./src/app/utils/chunks/common/executeContentScript.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, tourUrl } = context;
        try {
            function getInvoiceEmailByCBCompany(bookingCompanyId) {
                switch (bookingCompanyId.toUpperCase()) {
                    case '62B8B7E0-C368-4EC0-8FC6-CEE8BBCBBE41': return 'Aryld@corp.sletat.ru';
                    case '4016198A-5249-43B7-B3A0-A4CF53B96CD4': return 'ocb@corp.sletat.ru'; // ну 2 ОЦБ, ну что поделать
                    case 'A284BFD4-08E5-4F7D-A11C-F745C3C8BDC5': return 'ocb@corp.sletat.ru'; // жизнь такая
                    case 'A0C2A815-DAEC-47F1-A558-C921F13482CC': return 'mgt@corp.sletat.ru'; // Гор
                    default: return "";
                }
            }
            Array.prototype.forEach.call(data.autoFillerData.touristDataItems, tourist => {
                tourist.email = getInvoiceEmailByCBCompany(data.bookingCompanyId);
                return (0,_app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_9__.oneForNoData)(tourist);
            });
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__.removeCookiesForTouroperator)(_operators_6__WEBPACK_IMPORTED_MODULE_0__.Coral);
            var tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({
                active: true,
                url: _operators_6__WEBPACK_IMPORTED_MODULE_0__.Coral.link(),
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, 'div[data-target="#sign-in"]');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__.executeScriptInTabV3)(tab, () => { document.querySelector('div[data-target="#sign-in"]').click(); });
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_7__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_6__WEBPACK_IMPORTED_MODULE_0__.Coral.packet
            }));
            var tourpackageRegex = /coralagency\.ru\/reservation\/tourpackage\/tourists.*$/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__.updateListenerOnSpecificPage)(tab.id, tourpackageRegex, (tabId, changeInfo, updatedTab) => {
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, 'div[id^=tourist-form]')
                    .then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000 * 2))
                    .then(() => {
                    (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__.executeScriptInTabV3)(tab, claimFillerNewTour, [{
                            tourists: context.data.autoFillerData.touristDataItems,
                            customer: context.data.autoFillerData.customer
                        }]);
                    data.scriptKey = 'coralFill';
                    (0,_app_utils_chunks_common_executeContentScript__WEBPACK_IMPORTED_MODULE_13__.executeContentScript)(tab, data);
                })
                    .then(() => (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, 'input#closed1'))
                    .then(() => {
                    if (data.isAdvanceBooking) {
                        (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__.executeScriptInTabV3)(tab, () => { document.querySelector('input#closed1').click(); });
                    }
                });
                return true;
            });
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, 'span.icon-Profile-Menu');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(2000);
            yield (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_8__.updateTabUrl)(tab, tourUrl);
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(2 * 1000);
        }
        catch (e) {
            console.log("Coral фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_1__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFillerNewTour(data) {
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
        FieldType[FieldType["Human"] = 6] = "Human";
        FieldType[FieldType["NotFilled"] = 7] = "NotFilled";
    })(FieldType || (FieldType = {}));
    function doCustomerFill(tourist) {
        debugger;
        function wait(timeout) {
            return new Promise((resolve) => {
                setTimeout(() => resolve(), timeout);
            });
        }
        function SetReactValue(touristBlock, touristField) {
            var element = touristBlock.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value && touristField.value != '') {
                // @ts-ignore
                var previousValue = element.value;
                // @ts-ignore
                element.value = touristField.value;
                // @ts-ignore
                element._valueTracker.setValue(previousValue);
                var event = new Event('input', { bubbles: true });
                element.dispatchEvent(event);
            }
        }
        let chain = new Promise(resolse => resolse());
        const fields = [{
                htmlElementSelector: `input[name="surname"]`,
                value: tourist.surnameRus
            }, {
                htmlElementSelector: `input[name="name"]`,
                value: tourist.nameRus
            }, {
                htmlElementSelector: `input[name="patronymic"],  input[name="middleName"]`,
                value: tourist.middleNameRus
            }, {
                htmlElementSelector: `input[name="birthday"]`,
                value: tourist.birthday
            }, {
                htmlElementSelector: `input[name="address"]`,
                value: tourist.address
            }, {
                htmlElementSelector: `input[name="documentSeries"]`,
                value: tourist.passportSeries
            }, {
                htmlElementSelector: `input[name="documentNumber"]`,
                value: tourist.passportNumber
            }, {
                htmlElementSelector: `input[name="mobilePhone"]`,
                value: tourist.phone
            }, {
                htmlElementSelector: `input[name="email"]`,
                value: tourist.email
            }];
        chain = chain.then(() => {
            var custText = document.querySelector('span.customer-text');
            if (custText && custText.nextElementSibling) {
                // @ts-ignore
                custText.nextElementSibling.click();
            }
        });
        chain = chain.then(() => wait(1000));
        var customerBlock = document.querySelector('div#modalBody form.payer-modal-form');
        if (!customerBlock) {
            console.log('customerBlock не нашелся');
            return;
        }
        fields.forEach((f, i) => {
            chain = chain.then(() => SetReactValue(customerBlock, f));
            chain = chain.then(() => wait(500));
        });
    }
    function getExpireDate(date, lag = 25) {
        if (!date || date === '') {
            return '';
        }
        const [day, month, year] = date.split('.');
        var expireDate = new Date(parseInt(year, 10) + lag, parseInt(month, 10) - 1, parseInt(day, 10), 0, 0);
        var newDay = expireDate.getDate();
        var newMonth = expireDate.getMonth() + 1;
        var newYear = expireDate.getFullYear();
        return `${newDay < 10 ? '0' + newDay : newDay}.${newMonth < 10 ? '0' + newMonth : newMonth}.${newYear}`;
    }
    function prepareExpireDate(tourist) {
        const dateNow = new Date(Date.now());
        const dateNowString = `${dateNow.getDate()}.${dateNow.getMonth() + 1}.${dateNow.getFullYear()}`;
        if (!tourist.passportExpireDate || tourist.passportExpireDate === '') {
            return getExpireDate(dateNowString, 15);
        }
        return getExpireDate(tourist.passportExpireDate, 15);
    }
    function wait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function SetReactValue(touristBlock, touristField) {
        var element = touristBlock.querySelector(touristField.htmlElementSelector);
        if (element && touristField.value && touristField.value != '') {
            element.dispatchEvent(new FocusEvent('focusin', { bubbles: true }));
            element.value = touristField.value;
            element.dispatchEvent(new Event('input', { bubbles: true }));
            element.dispatchEvent(new FocusEvent('focusout', { bubbles: true }));
        }
    }
    function SetSex(tourist, touristBlock) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                // @ts-ignore
                touristBlock.querySelector('input[value="0"]').click();
                break;
            case 2:
            case 4:
            case 6:
                // @ts-ignore
                touristBlock.querySelector('input[value="1"]').click();
                break;
        }
    }
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function NotFilledField(touristBlock, touristField) {
        let block = touristBlock.querySelector(touristField.htmlElementSelector);
        let defaultSelectedValueDiv = touristBlock.querySelector(`${touristField.htmlElementSelector} div.true__single-value`);
        if (defaultSelectedValueDiv && defaultSelectedValueDiv.innerText) {
            console.log(`defaultSelectedValueDiv = ${defaultSelectedValueDiv}`);
            console.log(`touristField.value = ${touristField.value}`);
            if (defaultSelectedValueDiv.innerText === touristField.value) {
                return;
            }
        }
        if (block && block.parentNode && block.parentNode.parentNode && block.parentNode.parentNode.parentNode) {
            block.parentNode.parentNode.parentNode.style.border = "10px solid red";
            block.parentNode.parentNode.parentNode.style.borderRadius = '20px';
            let div = document.createElement("div");
            div.style.textAlign = 'center';
            div.append(`--> ${touristField.value} <--`);
            block.parentNode.parentNode.parentNode.appendChild(div);
        }
    }
    function doTouristsFill(tourists, touristBlocks) {
        debugger;
        let chain = new Promise(resolse => resolse());
        // сортируем детей по возрасту в порядке позрастания, потому что Интурист альтернативно одаренный
        var tmpTouristsArray = [];
        var tmpChildTouristsArray = [];
        for (var i = 0; i < tourists.length; i++) {
            var tourist = tourists[i];
            if (getTouristAge(tourist) < 14) {
                tmpChildTouristsArray.push(tourist);
            }
            else {
                tmpTouristsArray[i] = tourist;
            }
        }
        tmpChildTouristsArray = tmpChildTouristsArray.reverse();
        tourists = tmpTouristsArray.concat(tmpChildTouristsArray);
        Array.prototype.forEach.call(tourists, (tourist, touristIndex) => {
            const touristFields = [
                {
                    htmlElementSelector: `input[name="gender"]`,
                    value: tourist.nameEng,
                    fieldType: FieldType.Sex
                }, {
                    htmlElementSelector: `input[name="name"]`,
                    value: tourist.nameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="surName"]`,
                    value: tourist.surnameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="patronymic"],  input[name="middleName"]`,
                    value: tourist.middleNameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="birthDate"]`,
                    value: tourist.birthday,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportGivenDate"]`,
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportValidThru"]`,
                    value: tourist.passportExpireDate && tourist.passportExpireDate !== '' ? tourist.passportExpireDate : prepareExpireDate(tourist),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportSerie"]`,
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportNumber"]`,
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="issuedby"]`,
                    value: tourist.passportIssueOrg,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="phoneNumber"]`,
                    value: tourist.phone,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="invoiceMail"]`,
                    value: tourist.email,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `div#nationality`,
                    value: tourist.citizenshipName,
                    fieldType: FieldType.NotFilled
                }, {
                    htmlElementSelector: `input[name="address"]`,
                    value: tourist.address,
                    fieldType: FieldType.Text
                }
            ];
            var touristBlock = touristBlocks[touristIndex];
            touristFields.forEach(touristField => {
                switch (touristField.fieldType) {
                    case FieldType.Sex:
                        chain = chain.then(() => SetSex(tourist, touristBlock));
                        break;
                    case FieldType.Text:
                        chain = chain.then(() => SetReactValue(touristBlock, touristField));
                        break;
                    case FieldType.NotFilled:
                        chain = chain.then(() => NotFilledField(touristBlock, touristField));
                        break;
                    default:
                        break;
                }
                chain = chain.then(() => wait(500));
            });
        });
    }
    doTouristsFill(data.tourists, document.querySelectorAll('div[id^=tourist-form] form.form-custom'));
}
function contentCoralFill(data) {
    console.log('Content EXECUTE_CONTENT_SCRIPT');
    let forms = document.querySelectorAll('div[id^=tourist-form] form.form-custom');
    Array.prototype.forEach.call(forms, (form, formIndex) => {
        let row = document.createElement('div');
        Array.prototype.forEach.call(data.autoFillerData.touristDataItems, (tourist, touristIndex) => {
            let button = document.createElement('button');
            button.innerText = `${tourist.name} ${tourist.surname}`;
            button.style.marginRight = '1em';
            button.style.backgroundColor = '#e03997';
            button.style.color = '#fff';
            button.style.borderColor = '#fff';
            button.style.borderRadius = '5px';
            button.addEventListener('click', (e) => {
                debugger;
                e.preventDefault();
                console.log(`button.addEventListener ${formIndex}${touristIndex}, ${tourist.name} ${tourist.surname}`);
                //@ts-ignore
                fillTourist(e.target.parentNode.parentNode, tourist);
            });
            row.appendChild(button);
        });
        if (form) {
            form.appendChild(row);
        }
    });
}
function fillTourist(block, tourist) {
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
        FieldType[FieldType["Human"] = 6] = "Human";
        FieldType[FieldType["NotFilled"] = 7] = "NotFilled";
    })(FieldType || (FieldType = {}));
    function prepareExpireDate(tourist) {
        const dateNow = new Date(Date.now());
        const dateNowString = `${dateNow.getDate()}.${dateNow.getMonth() + 1}.${dateNow.getFullYear()}`;
        if (!tourist.passportExpireDate || tourist.passportExpireDate === '') {
            return getExpireDate(dateNowString, 15);
        }
        return getExpireDate(tourist.passportExpireDate, 15);
    }
    function getExpireDate(date, lag = 25) {
        if (!date || date === '') {
            return '';
        }
        const [day, month, year] = date.split('.');
        var expireDate = new Date(parseInt(year, 10) + lag, parseInt(month, 10) - 1, parseInt(day, 10), 0, 0);
        var newDay = expireDate.getDate();
        var newMonth = expireDate.getMonth() + 1;
        var newYear = expireDate.getFullYear();
        return `${newDay < 10 ? '0' + newDay : newDay}.${newMonth < 10 ? '0' + newMonth : newMonth}.${newYear}`;
    }
    function NotFilledField(touristBlock, touristField) {
        let block = touristBlock.querySelector(touristField.htmlElementSelector);
        let defaultSelectedValueDiv = touristBlock.querySelector(`${touristField.htmlElementSelector} div.true__single-value`);
        if (defaultSelectedValueDiv && defaultSelectedValueDiv.innerText) {
            console.log(`defaultSelectedValueDiv = ${defaultSelectedValueDiv}`);
            console.log(`touristField.value = ${touristField.value}`);
            if (defaultSelectedValueDiv.innerText === touristField.value) {
                return;
            }
        }
        if (block && block.parentNode && block.parentNode.parentNode && block.parentNode.parentNode.parentNode) {
            block.parentNode.parentNode.parentNode.style.border = "10px solid red";
            block.parentNode.parentNode.parentNode.style.borderRadius = '20px';
            let div = document.createElement("div");
            div.style.textAlign = 'center';
            div.append(`--> ${touristField.value} <--`);
            block.parentNode.parentNode.parentNode.appendChild(div);
        }
    }
    function SetSex(touristBlock, tourist) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                // @ts-ignore
                touristBlock.querySelector('input[value="0"]').click();
                break;
            case 2:
            case 4:
            case 6:
                // @ts-ignore
                touristBlock.querySelector('input[value="1"]').click();
                break;
        }
    }
    function SetReactValue(touristBlock, touristField) {
        var element = touristBlock.querySelector(touristField.htmlElementSelector);
        if (element && touristField.value && touristField.value != '') {
            element.dispatchEvent(new FocusEvent('focusin', { bubbles: true }));
            element.value = touristField.value;
            element.dispatchEvent(new Event('input', { bubbles: true }));
            element.dispatchEvent(new FocusEvent('focusout', { bubbles: true }));
        }
    }
    let chain = Promise.resolve();
    const touristFields = [
        {
            htmlElementSelector: `input[name="gender"]`,
            value: tourist.nameEng,
            fieldType: FieldType.Sex
        }, {
            htmlElementSelector: `input[name="name"]`,
            value: tourist.nameEng,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="surName"]`,
            value: tourist.surnameEng,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="patronymic"],  input[name="middleName"]`,
            value: tourist.middleNameEng,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="birthDate"]`,
            value: tourist.birthday,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="passportGivenDate"]`,
            value: tourist.passportDate,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="passportValidThru"]`,
            value: tourist.passportExpireDate && tourist.passportExpireDate !== '' ? tourist.passportExpireDate : prepareExpireDate(tourist),
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="passportSerie"]`,
            value: tourist.passportSeries,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="passportNumber"]`,
            value: tourist.passportNumber,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="issuedby"]`,
            value: tourist.passportIssueOrg,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="phoneNumber"]`,
            value: tourist.phone,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="invoiceMail"]`,
            value: tourist.email,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `div#nationality`,
            value: tourist.citizenshipName,
            fieldType: FieldType.NotFilled
        }, {
            htmlElementSelector: `input[name="address"]`,
            value: tourist.address,
            fieldType: FieldType.Text
        }
    ];
    touristFields.forEach(touristField => {
        switch (touristField.fieldType) {
            case FieldType.Sex:
                chain = chain.then(() => SetSex(block, tourist));
                break;
            case FieldType.Text:
                chain = chain.then(() => SetReactValue(block, touristField));
                break;
            case FieldType.NotFilled:
                chain = chain.then(() => NotFilledField(block, touristField));
                break;
            default:
                break;
        }
        chain = chain.then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(500));
    });
}


/***/ }),

/***/ "./src/serverScripts/operators/107.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/107.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Danko: () => (/* binding */ Danko)
/* harmony export */ });
const Danko = {
    link: (operatorClaimId) => 'https://online.danko.ru/private/account/login.aspx',
    title: 'ДАНКО Трэвел Компани',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'userName\']",' +
            '"passwordPath":"input[name=\'password\']", ' +
            '"submitPath": "input[name=\'ctl00$General$btLogin\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/108.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/108.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DeltaTours: () => (/* binding */ DeltaTours)
/* harmony export */ });
const DeltaTours = {
    link: (operatorClaimId) => `http://delta-tours.tourmanager.ru/login`,
    title: 'DELTA TOURS / Дельта Интерконтиненталь',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#ls-main #login",' +
            '"passwordPath":"#ls-main #password", ' +
            '"submitPath": "#ls-main .login input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['current_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/112.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/112.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ExpressTour: () => (/* binding */ ExpressTour)
/* harmony export */ });
const ExpressTour = {
    link: (operatorClaimId) => `http://online.expresstours.ru`,
    title: 'Экспресс тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        packet: {
            loginPath: "#ctl00_Login_ctl01, #ctl00_generalContent_LoginControl_txtUserName",
            passwordPath: "#ctl00_Login_ctl02, #ctl00_generalContent_LoginControl_txtPassword",
            submitPath: "input[name='ctl00$Login$ctl03'], #ctl00_generalContent_LoginControl_btnLogin"
        },
        password: 'zi71kk30'
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/113.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/113.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Grand: () => (/* binding */ Grand)
/* harmony export */ });
const Grand = {
    link: (operatorClaimId) => 'http://online.grand-travels.ru',
    title: 'Grand',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: 'input#ctl00_generalContent_LoginControl_txtUserName, input#ctl00_Login_ctl01',
            passwordPath: 'input#ctl00_generalContent_LoginControl_txtPassword, input#ctl00_Login_ctl02',
            submitPath: 'input#ctl00_generalContent_LoginControl_btnLogin, input.loginbutton'
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/123.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/123.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Itm: () => (/* binding */ Itm)
/* harmony export */ });
const Itm = {
    link: () => ``,
    title: 'ITM Group',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        packet: JSON.parse('{"' +
            'loginPath":"#ctl00_generalContent_LoginControl_txtUserName , #login",' +
            '"passwordPath": "#ctl00_generalContent_LoginControl_txtPassword , #password", ' +
            '"submitPath": "#ctl00_generalContent_LoginControl_btnLogin , button.btn.sign-in' +
            '"}'),
        password: ''
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth', '.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/130.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/130.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WestTravel: () => (/* binding */ WestTravel)
/* harmony export */ });
const WestTravel = {
    link: (operatorClaimId) => `http://online.west-travel.ru/MasterWebStandard/login.aspx`,
    title: 'Вест Тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/131.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/131.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArtTravel: () => (/* binding */ ArtTravel)
/* harmony export */ });
const ArtTravel = {
    link: (operatorClaimId) => `http://res.art-travel.ru/MasterWebStandard/login.aspx`,
    title: 'Арт-Тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#ctl00_Login_ctl01, #Login',
            passwordPath: '#ctl00_Login_ctl02, #Password',
            submitPath: 'input[name=\'ctl00$Login$ctl03\'], div.loginForm-rightCol input[type=submit]'
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/14.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/14.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PacGroup: () => (/* binding */ PacGroup)
/* harmony export */ });
const PacGroup = {
    link: (operatorClaimId) => 'https://online.pac.ru/online/login.aspx',
    title: 'PAC GROUP',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: '#UserName',
        passwordPath: '#Password',
        submitPath: 'form button[type=submit]'
    },
    selectors: {},
    cookie: {
        auth: ['.AspNetCore.Identity.Application']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/141.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/141.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   YugoStar: () => (/* binding */ YugoStar)
/* harmony export */ });
const YugoStar = {
    link: (operatorClaimId) => `http://online.yugo-star.ru/masterweb/login.aspx`,
    title: 'Юго Стар',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_Login_ctl02", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', 'MagTravelWebClient']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/142.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/142.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MoreTravel: () => (/* binding */ MoreTravel)
/* harmony export */ });
const MoreTravel = {
    link: (operatorClaimId) => `https://www.moretravel.ru/login.php`,
    title: 'More Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#form_login > fieldset > label > span > input[name=login]',
            passwordPath: '#form_login > fieldset > label > span > input[name=pass]',
            submitPath: '#form_login > div > button[type=submit]'
        }
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/145.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/145.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RozaVetrov: () => (/* binding */ RozaVetrov)
/* harmony export */ });
const RozaVetrov = {
    link: () => ``,
    title: 'Роза Ветров',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        packet: {
            loginPath: "input#ctl00_generalContent_LoginControl_txtUserName, input#ctl00_Login_ctl01",
            passwordPath: "input#ctl00_generalContent_LoginControl_txtPassword, input#ctl00_Login_ctl02",
            submitPath: "input[name='ctl00$generalContent$LoginControl$btnLogin'], input[name='ctl00$Login$ctl03']"
        },
        password: ''
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth', '.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/152.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/152.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MeridianExpress: () => (/* binding */ MeridianExpress)
/* harmony export */ });
const MeridianExpress = {
    link: (operatorClaimId) => `http://remote.meridian-express.ru:8585`,
    title: 'Меридиан Экспресс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', 'ASP.NET_SessionId']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/153.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/153.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Delfin: () => (/* binding */ Delfin)
/* harmony export */ });
const Delfin = {
    link: (operatorClaimId) => `https://www.delfin-tour.ru`,
    title: 'ДЕЛЬФИН',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "input[name='login'], input[name='lg-login']",
        passwordPath: "input[name='password'], input[name='lg-pass']",
        submitPath: "button.login-form__submit, form[class~='login-form'] button[type='submit']"
    },
    selectors: {},
    cookie: {
        auth: ['token', 'delfin-tour']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/155.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/155.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BSI: () => (/* binding */ BSI)
/* harmony export */ });
const BSI = {
    link: (operatorClaimId) => `https://www.bsigroup.ru/cabinet/`,
    title: 'Би Эс Ай (BSI)',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#bottom_login_form input[name=\'login\']",' +
            '"passwordPath":"#bottom_login_form input[name=\'pass\']", ' +
            '"submitPath": "#bottom_login_form input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID BITRIX_SM_atkn_w']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/156.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/156.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Maldives: () => (/* binding */ Maldives)
/* harmony export */ });
const Maldives = {
    link: (operatorClaimId) => `http://online.maldives.ru/cl_refer?`,
    title: 'Мальдивиана',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": "button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID BITRIX_SM_atkn_w']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/158.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/158.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Solvex: () => (/* binding */ Solvex)
/* harmony export */ });
const Solvex = {
    link: (operatorClaimId) => 'http://online.solvex.ru/DistributedSearch/login.aspx',
    title: 'SOLVEX',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#inputEmail3, input#ctl00_generalContent_LoginControl_txtUserName , #login",
            "passwordPath": "#inputPassword3, input#ctl00_generalContent_LoginControl_txtPassword , #password",
            "submitPath": "#enter, input#ctl00_generalContent_LoginControl_btnLogin , #loginDialog > div > div > div.modal-footer > div.row > div.col-lg-2.col-md-2.col-sm-2 > button > span"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', 'kx-auth', 'ASP.NET_SessionId']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/160.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/160.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Dsbw: () => (/* binding */ Dsbw)
/* harmony export */ });
const Dsbw = {
    link: (operatorClaimId) => `http://tourml.dsbw.ru/MasterWeb15/login.aspx`,
    title: 'ДСБВ (DSBW)',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "#ctl00_generalContent_LoginControl_btnLogin"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#login , #ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#password , #ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "#loginDialog .modal-footer button , #ctl00_generalContent_LoginControl_btnLogin"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth', '.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/162.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/162.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChinaTravel: () => (/* binding */ ChinaTravel)
/* harmony export */ });
const ChinaTravel = {
    link: (operatorClaimId) => `http://online.chinatravel.ru/mw/login.aspx`,
    title: 'China Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName , #ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword , #ctl00_Login_ctl02", ' +
            '"submitPath": "#ctl00_generalContent_LoginControl_btnLogin , .loginbutton"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['identityCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/165.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/165.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Devisu: () => (/* binding */ Devisu)
/* harmony export */ });
const Devisu = {
    link: (operatorClaimId) => 'http://ttt.devisu.ru/mw9/login.aspx',
    title: 'De Visu',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_Login_ctl02", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/171.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/171.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AmigoS: () => (/* binding */ AmigoS)
/* harmony export */ });
const AmigoS = {
    link: (operatorClaimId) => 'https://dynamic.amigo-s.ru',
    title: 'Amigo S',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "input[name='ctl00$generalContent$LoginControl$txtUserName']",
            passwordPath: "input[name='ctl00$generalContent$LoginControl$txtPassword']",
            submitPath: "input[name='ctl00$generalContent$LoginControl$btnLogin']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['kx-auth3']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/174.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/174.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Capricorn: () => (/* binding */ Capricorn)
/* harmony export */ });
const Capricorn = {
    link: (operatorClaimId) => 'https://www.capricorn.ru/',
    title: 'Каприкон',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_Login_ctl02", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/184.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/184.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Interunion: () => (/* binding */ Interunion)
/* harmony export */ });
const Interunion = {
    link: (operatorClaimId) => 'http://online.interunion.ru/MW2018/login.aspx',
    title: 'Интерюнион',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$Login$ctl01\']",' +
            '"passwordPath":"input[name=\'ctl00$Login$ctl02\']", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/19.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/19.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Anex: () => (/* binding */ Anex)
/* harmony export */ });
const Anex = {
    link: (operatorClaimId) => 'http://online3.anextour.ru/default.php?page=cl_refer&samo=ok',
    title: 'Anex',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "input[name='login']",
        passwordPath: "input[name='password']",
        submitPath: "form button[type=submit], form button.button"
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    },
};


/***/ }),

/***/ "./src/serverScripts/operators/20.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/20.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IcsTravel: () => (/* binding */ IcsTravel)
/* harmony export */ });
const IcsTravel = {
    link: (operatorClaimId) => `https://www.icstrvl.ru/agent/login.html`,
    title: 'ICS Travel Group',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#lform_login",
            "passwordPath": "#lform_password",
            "submitPath": ".for_form .sbmt"
        }
    },
    selectors: {},
    cookie: {
        auth: ['ag_ticket']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/205.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/205.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AmigoTours: () => (/* binding */ AmigoTours)
/* harmony export */ });
const AmigoTours = {
    link: (operatorClaimId) => 'https://online.amigo-tours.ru',
    title: 'Amigo Tours',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "input#Login, #ctl00_generalContent_LoginControl_txtUserName",
        passwordPath: "input#Password, #ctl00_generalContent_LoginControl_txtPassword",
        submitPath: "form input[type=submit], input[name='ctl00$generalContent$LoginControl$btnLogin']"
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/213.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/213.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mouzenidis: () => (/* binding */ Mouzenidis)
/* harmony export */ });
const Mouzenidis = {
    link: (operatorClaimId) => 'https://online215.mouzenidis-travel.ru/Account/LogOn',
    title: 'Mouzenidis Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#AuthenticateUser div[data-bind='bsValid: quickReservationController.UserName'] input , #LoginViewModel_Username",
            "passwordPath": "#AuthenticateUser div[data-bind='bsValid: quickReservationController.Password'] input , #LoginViewModel_Password",
            "submitPath": "#AuthenticateUser button.btn-primary , button[value='login']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.AUTHMZT1', 'idsrv.session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/2147483639.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/2147483639.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CityTravel: () => (/* binding */ CityTravel)
/* harmony export */ });
const CityTravel = {
    link: (operatorClaimId) => `https://city.travel`,
    title: 'City Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form input[name=user_mail]",
            "passwordPath": "form input[name=user_pwd]",
            "submitPath": "form button[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/2147483640.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/2147483640.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AcademService: () => (/* binding */ AcademService)
/* harmony export */ });
const AcademService = {
    link: (operatorClaimId) => `https://b2b.acase.ru/`,
    title: 'Академ Сервис',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            companyPath: "form input#buyer_input",
            loginPath: "form input#login_input",
            passwordPath: "form input#password_input",
            submitPath: "form input[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/2147483641.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/2147483641.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Bronevik: () => (/* binding */ Bronevik)
/* harmony export */ });
const Bronevik = {
    link: (operatorClaimId) => `https://bronevik.com`,
    title: 'Мой Агент',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form.auth_form input[aria-label=Login]",
            "passwordPath": "form.auth_form input[type=password]",
            "submitPath": "form.auth_form button[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/2147483645.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/2147483645.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ostrovok: () => (/* binding */ Ostrovok)
/* harmony export */ });
const Ostrovok = {
    link: (operatorClaimId) => `https://b2b.ostrovok.ru`,
    title: 'Мой Агент',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input[name=email]",
            "passwordPath": "input[name=pass]",
            "submitPath": "button[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/219.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/219.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SochiPlanet: () => (/* binding */ SochiPlanet)
/* harmony export */ });
const SochiPlanet = {
    link: (operatorClaimId) => `http://online.mercury-europe.ru/MasterWebMercury/login.aspx`,
    title: 'Планета Сочи',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input[name='ctl00$generalContent$LoginControl$txtUserName'] , #login",
            "passwordPath": "input[name='ctl00$generalContent$LoginControl$txtPassword'] , #password",
            "submitPath": "input[name='ctl00$generalContent$LoginControl$btnLogin'] , #loginDialog > div > div > div.modal-footer > div > div.col-lg-4.col-md-4.col-sm-4 > button > span"
        },
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/229.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/229.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TuiOld: () => (/* binding */ TuiOld)
/* harmony export */ });
const TuiOld = {
    link: (operatorClaimId) => `http://my.tui.ru/Online/Orders/?sr_id=${operatorClaimId}`,
    title: 'TUI old',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        packet: {
            loginPath: "#form_login",
            passwordPath: "#form_password",
            submitPath: "#form_submit",
        },
    },
    selectors: {
        claimButton: '.zayavki tbody tr:nth-child(1)'
    },
    cookie: {
        auth: ['.ASPXFORMSAUTH', 'PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/231.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/231.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MultiTour: () => (/* binding */ MultiTour)
/* harmony export */ });
const MultiTour = {
    link: (operatorClaimId) => `https://www.multitour.ru`,
    title: 'МУЛЬТИТУР',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: ".auth-form input[name='login']",
        passwordPath: ".auth-form input[name='pass']",
        submitPath: "form button[type=submit]"
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/237.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/237.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DvmTour: () => (/* binding */ DvmTour)
/* harmony export */ });
const DvmTour = {
    link: (operatorClaimId) => `http://online.dvm-tour.ru/toursearch/`,
    title: 'ДВМ-Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#auth_blk #auth_login",
            "passwordPath": "#auth_blk #auth_pwd",
            "submitPath": "#auth_blk .auth_sub"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.ASPXAUTH']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/238.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/238.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RusTour: () => (/* binding */ RusTour)
/* harmony export */ });
const RusTour = {
    link: (operatorClaimId) => 'http://online.rus-tour.travel/server/auth.php',
    title: 'Русь-Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": "#loginForm .button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/248.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/248.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AvroraBg: () => (/* binding */ AvroraBg)
/* harmony export */ });
const AvroraBg = {
    link: (operatorClaimId) => `http://online.avrorabg.ru/MasterWebStandard/login.aspx`,
    title: 'Аврора БГ',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#ctl00_Login_ctl01",
            "passwordPath": "#ctl00_Login_ctl02",
            "submitPath": "input[name='ctl00$Login$ctl03']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/252.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/252.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Alean: () => (/* binding */ Alean)
/* harmony export */ });
const Alean = {
    link: (operatorClaimId) => 'https://www.alean.ru',
    title: 'Алеан',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: 'form.cabinetLogin-form input#login',
            passwordPath: 'form.cabinetLogin-form input#password',
            submitPath: 'form.cabinetLogin-form button[type=submit]'
        },
    },
    cookie: {
        auth: ['ksb_PRO_agency_account_id']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/260.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/260.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Kandagar: () => (/* binding */ Kandagar)
/* harmony export */ });
const Kandagar = {
    link: (operatorClaimId) => 'http://online.kandagar.com/MW/login.aspx',
    title: 'Кандагар',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: {
            "loginPath": "#loginValue , input[name='ctl00$generalContent$LoginControl$txtUserName']",
            "passwordPath": "#passwordValue , input[name='ctl00$generalContent$LoginControl$txtPassword']",
            "submitPath": "#exitButton , input[name='ctl00$generalContent$LoginControl$btnLogin'] , #logon"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/269.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/269.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NatalieTours: () => (/* binding */ NatalieTours)
/* harmony export */ });
const NatalieTours = {
    link: () => ``,
    title: 'NatalieTours',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        packet: JSON.parse('{"loginPath":"#login","passwordPath": "#password", "submitPath": "#ok"}'),
        password: ''
    },
    selectors: {},
    cookie: {
        auth: ['JSESSIONID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/277.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/277.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   VremiaTour: () => (/* binding */ VremiaTour)
/* harmony export */ });
const VremiaTour = {
    link: (operatorClaimId) => `https://vremiatour.ru/tourmanager?countryId=2&tm_page=%2Flogin`,
    title: 'Время-тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":".login input[name=\'login\']",' +
            '"passwordPath":".login input[name=\'password\']", ' +
            '"submitPath": ".login .submit input"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'login\']",' +
            '"passwordPath":"input[name=\'password\']", ' +
            '"submitPath": "#login-form input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['current_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/280.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/280.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GTV: () => (/* binding */ GTV)
/* harmony export */ });
const GTV = {
    link: (operatorClaimId) => `http://online.gtv-operator.ru/`,
    title: 'GTV Operator',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_Login_ctl02", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    },
};


/***/ }),

/***/ "./src/serverScripts/operators/282.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/282.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Petropolitana: () => (/* binding */ Petropolitana)
/* harmony export */ });
const Petropolitana = {
    link: (operatorClaimId) => `http://www.petropolitana.com/`,
    title: 'Petropolitana',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "input#login, input#ctl00_generalContent_LoginControl_txtUserName",
            passwordPath: "input#password, input#ctl00_generalContent_LoginControl_txtPassword",
            submitPath: "button.sign-in, input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth']
    },
};


/***/ }),

/***/ "./src/serverScripts/operators/3.ts":
/*!******************************************!*\
  !*** ./src/serverScripts/operators/3.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Pegas: () => (/* binding */ Pegas)
/* harmony export */ });
const Pegas = {
    link: (operatorClaimId) => `https://agency.pegast.ru`,
    title: 'Pegas',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        packet: {
            loginPath: "form.auth-form__form input#input_1",
            passwordPath: "form.auth-form__form input#input_2",
            submitPath: "form.auth-form__form button#auth-submit-button",
        }
    },
    selectors: {},
    cookie: {
        auth: ['.AspNetCore.Cookies']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/301.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/301.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RobinsonTours: () => (/* binding */ RobinsonTours)
/* harmony export */ });
const RobinsonTours = {
    link: (operatorClaimId) => `http://109.167.211.76/MasterWeb/login.aspx`,
    title: 'Робинзон',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#ctl00_Login_ctl01, #ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "#ctl00_Login_ctl02, #ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "input[name='ctl00$Login$ctl03'], #ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/302.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/302.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Premiera: () => (/* binding */ Premiera)
/* harmony export */ });
const Premiera = {
    link: (operatorClaimId) => `http://samo.premiera.travel/cl_refer`,
    title: 'Премьера',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "#loginForm #login",
        passwordPath: "#loginForm #password",
        submitPath: "#loginForm button"
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/304.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/304.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GoodTimeTravel: () => (/* binding */ GoodTimeTravel)
/* harmony export */ });
const GoodTimeTravel = {
    link: (operatorClaimId) => 'http://online.goodtimetravel.ru/cl_refer?',
    title: 'Good Time Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": "#loginForm .button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/309.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/309.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ivolga: () => (/* binding */ Ivolga)
/* harmony export */ });
const Ivolga = {
    link: (operatorClaimId) => `http://www.ivolgatour.com/tm?id=1409&tm_page=%2Forder%2Fwork`,
    title: 'Иволга',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#login",' +
            '"passwordPath":"#password", ' +
            '"submitPath": ".login .submit input"' +
            '}'),
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#login-form input[name=\'login\']",' +
            '"passwordPath":"#login-form input[name=\'password\']", ' +
            '"submitPath": "#login-form input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['current_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/311.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/311.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Matreshka: () => (/* binding */ Matreshka)
/* harmony export */ });
const Matreshka = {
    link: (operatorClaimId) => `http://online.matreshkatour.com/MasterWeb/login.aspx`,
    title: 'Матрёшка-Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/315.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/315.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Beleon: () => (/* binding */ Beleon)
/* harmony export */ });
const Beleon = {
    link: (operatorClaimId) => `http://online.beleontours.ru/account/login`,
    title: 'Beleon Tours',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#Login",' +
            '"passwordPath":"#Password", ' +
            '"submitPath": "#loginform input[type=\'submit\']"' +
            '}'),
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#Login",' +
            '"passwordPath":"#Password", ' +
            '"submitPath": "#loginForm input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.AspNet.ApplicationCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/331.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/331.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Acti: () => (/* binding */ Acti)
/* harmony export */ });
const Acti = {
    link: (operatorClaimId) => 'http://online.actitour.ru/cl_refer',
    title: 'ACTI tour Russia',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#login",' +
            '"passwordPath":"#passwd", ' +
            '"submitPath": "#loginForm button.button"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/343.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/343.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlanTravel1: () => (/* binding */ PlanTravel1)
/* harmony export */ });
const PlanTravel1 = {
    link: (operatorClaimId) => `https://booking.plantravel.ru`,
    title: 'Планета тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "#loginForm #login, input#ctl00_generalContent_LoginControl_txtUserName, #login",
        passwordPath: "#loginForm #passwd, input#ctl00_generalContent_LoginControl_txtPassword, #password",
        submitPath: "#loginForm button, input#ctl00_generalContent_LoginControl_btnLogin, button[data-bind='click: login']"
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/344.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/344.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Panteon: () => (/* binding */ Panteon)
/* harmony export */ });
const Panteon = {
    link: (operatorClaimId) => `http://booking.panteon.ru`,
    title: 'Пантеон Тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "#login, #ctl00_generalContent_LoginControl_txtUserName",
        passwordPath: "#password, #ctl00_generalContent_LoginControl_txtPassword",
        submitPath: "#loginDialog button.sign-in, #ctl00_generalContent_LoginControl_btnLogin"
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', 'CommonApplicationAuthCookie_.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/345.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/345.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Vand: () => (/* binding */ Vand)
/* harmony export */ });
const Vand = {
    link: () => ``,
    title: 'Ванд',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        packet: {
            "loginPath": "form#login-auth-form input[name='login']",
            "passwordPath": "form#login-auth-form input[name='password']",
            "submitPath": "form#login-auth-form button[type='submit']"
        },
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/348.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/348.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlanTravel: () => (/* binding */ PlanTravel)
/* harmony export */ });
const PlanTravel = {
    link: (operatorClaimId) => `http://online.plantravel.ru/cl_refer?loggedout=1`,
    title: 'Планета тревел Lets Fly',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#loginForm #login",
            "passwordPath": "#loginForm #passwd",
            "submitPath": "#loginForm button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/361.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/361.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SpaceTravel: () => (/* binding */ SpaceTravel)
/* harmony export */ });
const SpaceTravel = {
    link: (operatorClaimId) => 'https://cb.space-travel.ru',
    title: 'Спейс Тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: 'form#loginForm input#login',
        passwordPath: 'form#loginForm input#password',
        submitPath: 'form#loginForm button.button'
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/378.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/378.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PearlRiver: () => (/* binding */ PearlRiver)
/* harmony export */ });
const PearlRiver = {
    link: (operatorClaimId) => 'http://web.prtc.travel',
    title: 'Жемчужная река',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": ".samo_container .panel button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/380.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/380.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TUInew: () => (/* binding */ TUInew)
/* harmony export */ });
const TUInew = {
    link: (operatorClaimId) => `http://b2b.tui.ru/default.php?page=cl_refer`,
    title: 'TUI new',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        packet: {
            loginPath: "#login , #MainContent_LoginControl_UserName",
            passwordPath: "#passwd , #MainContent_LoginControl_Password",
            submitPath: "button.button , input[name='ctl00$MainContent$LoginControl$ctl05'] , #login_button",
            // pageFormPath: {
            //     loginPath: "#login",
            //     passwordPath: "#passwd",
            //     submitPath: "button.button"
            // },
        },
    },
    selectors: {
        queryInput: '.frm-input.element.CLAIMBEGIN.cl',
        searchButton: '.load'
    },
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/382.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/382.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelfieTravel: () => (/* binding */ SelfieTravel)
/* harmony export */ });
const SelfieTravel = {
    link: (operatorClaimId) => 'https://b2b.selfietravel.kz',
    title: 'SelfieTravel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: 'form#loginForm input#login',
        passwordPath: 'form#loginForm input#password',
        submitPath: 'form#loginForm button.button'
    },
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/39.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/39.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DiamondTours: () => (/* binding */ DiamondTours)
/* harmony export */ });
const DiamondTours = {
    link: (operatorClaimId) => `http://www.diamondtours.ru/diamond/agency/pa.jsp`,
    title: 'Даймонд Турс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#entrance .nickname",' +
            '"passwordPath":"#entrance #password", ' +
            '"submitPath": "#entrance button"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'j_username\']",' +
            '"passwordPath":"input[name=\'j_password\']", ' +
            '"submitPath": "button[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['JSESSIONID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/392.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/392.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Aerotour: () => (/* binding */ Aerotour)
/* harmony export */ });
const Aerotour = {
    link: (operatorClaimId) => `https://online.aerotur.travel/MasterWeb/login.aspx`,
    title: 'АЭРОТУР',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#ctl00_generalContent_LoginControl_txtUserName , #login",
            "passwordPath": "#ctl00_generalContent_LoginControl_txtPassword , #password",
            "submitPath": "#ctl00_generalContent_LoginControl_btnLogin , .btn .btn-default .sign-in , #loginDialog > div > div > div.modal-footer > div.row > div.col-lg-2.col-md-2.col-sm-2 > button > span"
        }
    },
    selectors: {},
    cookie: {
        auth: ['identityCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/4.ts":
/*!******************************************!*\
  !*** ./src/serverScripts/operators/4.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TezTour: () => (/* binding */ TezTour)
/* harmony export */ });
const TezTour = {
    link: (operatorClaimId) => `https://plus.tez-tour.com`,
    title: 'TezTour',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        packet: {
            loginPath: "form#login-form input#login-edit-0-email",
            passwordPath: "form#login-form input#login-edit-0-password",
            submitPath: "form#login-form input[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/41.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/41.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Bontour: () => (/* binding */ Bontour)
/* harmony export */ });
const Bontour = {
    link: (operatorClaimId) => `http://bontour.ru/agencies/online-booking/`,
    title: 'Бон Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#login",' +
            '"passwordPath":"#passwd", ' +
            '"submitPath": "#loginbox input[type=\'submit\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#login",' +
            '"passwordPath":"#passwd", ' +
            '"submitPath": "#loginForm input.button"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/415.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/415.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Clickvoyage: () => (/* binding */ Clickvoyage)
/* harmony export */ });
const Clickvoyage = {
    link: (operatorClaimId) => `https://clickvoyage.ru/DisplayOrders/AgencyOrders`,
    title: 'Click Voyage',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'info@sleta',
        password: 'drfiv86yu8',
        packet: {
            "loginPath": "#UserName, #ctl00_generalContent_LoginControl_txtUserName, #app > div > div > div > form > div:nth-child(1) > div > div > input",
            "passwordPath": "#Password, #ctl00_generalContent_LoginControl_txtPassword, #app > div > div > div > form > div:nth-child(2) > div > div > input",
            "submitPath": "#submitLoginForm, #ctl00_generalContent_LoginControl_btnLogin, #app > div > div > div > div > button"
        }
    },
    selectors: {
        queryInput: '.frm-input.element.CLAIMBEGIN.cl',
        searchButton: '.load'
    },
    cookie: {
        auth: ['.ASPXAUTH', 'SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/42.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/42.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ZlataPraga: () => (/* binding */ ZlataPraga)
/* harmony export */ });
const ZlataPraga = {
    link: (operatorClaimId) => `https://www.zlatapraga.ru/on-line/?url=cl_refer`,
    title: 'Злата Прага',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#loginForm #login',
            passwordPath: '#loginForm #passwd',
            submitPath: '#loginForm button',
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/429.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/429.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RExpress: () => (/* binding */ RExpress)
/* harmony export */ });
const RExpress = {
    link: (operatorClaimId) => 'https://online-express.ru',
    title: 'Русский Экспресс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "#ctl00_generalContent_LoginControl_txtUserName, form input#auth-sign-in-email",
        passwordPath: "#ctl00_generalContent_LoginControl_txtPassword, form input#auth-sign-in-password",
        submitPath: "#ctl00_generalContent_LoginControl_btnLogin, form button.auth-button"
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', 'onex']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/431.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/431.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EliteTravel: () => (/* binding */ EliteTravel)
/* harmony export */ });
const EliteTravel = {
    link: (operatorClaimId) => 'http://elita-travel.com/login',
    title: 'Elite Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#tabs input[name='login'], input#ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "#tabs input[name='password'], input#ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "#tabs-3 input[type='submit'], input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['current_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/432.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/432.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Unicorn: () => (/* binding */ Unicorn)
/* harmony export */ });
const Unicorn = {
    link: (operatorClaimId) => `http://b2b.unicorn.ru/Login.aspx`,
    title: 'Unicorn',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#edtUsername',
            passwordPath: '#edtPassw',
            submitPath: '#BtnLogin'
        }
    },
    selectors: {},
    cookie: {
        auth: ['identityCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/439.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/439.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Paks: () => (/* binding */ Paks)
/* harmony export */ });
const Paks = {
    link: (operatorClaimId) => 'https://newonline.paks.ru',
    title: 'Пакс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form#loginForm input#login",
            passwordPath: "form#loginForm input#password",
            submitPath: "form#loginForm button.button"
        },
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/449.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/449.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OneTouchTravel: () => (/* binding */ OneTouchTravel)
/* harmony export */ });
const OneTouchTravel = {
    link: (operatorClaimId) => 'https://b2b.onetouch.travel',
    title: 'OneTouchTrravel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        packet: {
            loginPath: 'form#loginForm input#login',
            passwordPath: 'form#loginForm input#password',
            submitPath: 'form#loginForm button.button'
        },
    },
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/450.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/450.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PegasTui: () => (/* binding */ PegasTui)
/* harmony export */ });
const PegasTui = {
    link: (operatorClaimId) => `https://pegast.ru/agency/private/pegasys/booking/${operatorClaimId}`,
    title: 'Pegas from tui',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'sletat',
        packet: JSON.parse('{"loginPath":"#username","passwordPath": "#password", "submitPath": ".auth_block input.main-button , #login-button , .auth-form #submit", "operatorIdSelector": ".pegasys-order-id"}'),
        password: 'nGtyxm'
    },
    selectors: {},
    cookie: {
        auth: ['SESSID', 'ASP.NET_SessionId', '__RequestVerificationToken', '.ASPXAUTH', 'PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/452.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/452.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D2: () => (/* binding */ D2)
/* harmony export */ });
const D2 = {
    link: (operatorClaimId) => `https://lk.d2insur.ru`,
    title: 'D2',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "input#USER_LOGIN",
        passwordPath: "input#USER_PASSWORD",
        submitPath: "input#Login"
    },
    selectors: {},
    cookie: {
        auth: ['BITRIX_SM_UIDH', 'PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/453.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/453.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Veditour: () => (/* binding */ Veditour)
/* harmony export */ });
const Veditour = {
    link: (operatorClaimId) => `http://advanced.veditour.ru/login.aspx`,
    title: 'ВЕДИ ТУРГРУПП',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#ctl00_Login_ctl01, input#ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "#ctl00_Login_ctl02, input#ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "input[name='ctl00$Login$ctl03'], input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/454.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/454.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IziTour: () => (/* binding */ IziTour)
/* harmony export */ });
const IziTour = {
    link: (operatorClaimId) => 'https://online.izi.tours',
    title: 'Турплатформа',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "form#loginForm input#login",
        passwordPath: "form#loginForm input#password",
        submitPath: "form#loginForm button"
    },
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/457.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/457.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FunSunKz: () => (/* binding */ FunSunKz)
/* harmony export */ });
const FunSunKz = {
    link: (operatorClaimId) => 'https://b2b.fstravel.asia/',
    title: 'ФанСанКЗ',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "form#loginForm input#login",
        passwordPath: "form#loginForm input#password",
        submitPath: "form#loginForm button"
    },
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/46.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/46.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Troyka: () => (/* binding */ Troyka)
/* harmony export */ });
const Troyka = {
    link: (operatorClaimId) => `http://www.troyka.travel/online/cl_refer`,
    title: 'Тройка Холдинг',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#loginForm #login",' +
            '"passwordPath":"#loginForm #passwd", ' +
            '"submitPath": "#loginForm button"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/49.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/49.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Vilar: () => (/* binding */ Vilar)
/* harmony export */ });
const Vilar = {
    link: (operatorClaimId) => `http://online.vilar-tours.ru/default.php?page=cl_refer`,
    title: 'Vilar Tours',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#loginForm #login",' +
            '"passwordPath":"#loginForm #passwd", ' +
            '"submitPath": "#loginForm button"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/51.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/51.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ambotis: () => (/* binding */ Ambotis)
/* harmony export */ });
const Ambotis = {
    link: (operatorClaimId) => 'https://online.ambotis.ru',
    title: 'Ambotis Holidays',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: ' #loginForm #login',
            passwordPath: '#loginForm #passwd, #loginForm #password',
            submitPath: '#loginForm button.button'
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/53.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/53.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IntravelStoleshniki: () => (/* binding */ IntravelStoleshniki)
/* harmony export */ });
const IntravelStoleshniki = {
    link: (operatorClaimId) => 'https://online.intravel.ru/online/cl_refer?',
    title: 'Intravel Stoleshniki',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "#login",
            passwordPath: "#passwd",
            submitPath: "#loginbox .button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/536.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/536.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Krypton: () => (/* binding */ Krypton)
/* harmony export */ });
const Krypton = {
    link: (operatorClaimId) => 'http://online.kryptontour.ru',
    title: 'Криптон',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input#Login",
            "passwordPath": "input#Password",
            "submitPath": "form#loginform input[type=submit] , section#loginForm input[type='submit']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/54.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/54.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Sunmar: () => (/* binding */ Sunmar)
/* harmony export */ });
const Sunmar = {
    link: (operatorClaimId) => 'https://sunmaragency.ru',
    title: 'Sunmar',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: 'form#signInForm input#txt-username',
        passwordPath: 'form#signInForm input#txt-password',
        submitPath: 'form#signInForm button#signInSubmit'
    },
    cookie: {
        auth: ['ApiToken', '.AspNetCore.Cookies']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/544.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/544.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CrimeanWave: () => (/* binding */ CrimeanWave)
/* harmony export */ });
const CrimeanWave = {
    link: (operatorClaimId) => 'https://b2b.besttt.ru',
    title: 'Крымская Волна',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "div#loginbox input#login",
            "passwordPath": "div#loginbox input#passwd",
            "submitPath": "div#loginbox button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/564.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/564.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RZHDTour: () => (/* binding */ RZHDTour)
/* harmony export */ });
const RZHDTour = {
    link: (operatorClaimId) => 'https://rzdtour.com',
    title: 'РЖД Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input#ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "input#ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/6.ts":
/*!******************************************!*\
  !*** ./src/serverScripts/operators/6.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Coral: () => (/* binding */ Coral)
/* harmony export */ });
const Coral = {
    link: (operatorClaimId) => 'https://coralagency.ru',
    title: 'Coral',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: 'form#signInForm input#txt-username',
        passwordPath: 'form#signInForm input#txt-password',
        submitPath: 'form#signInForm button#signInSubmit'
    },
    cookie: {
        auth: ['ApiToken', '.AspNetCore.Cookies']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/7.ts":
/*!******************************************!*\
  !*** ./src/serverScripts/operators/7.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BiblioGlobus: () => (/* binding */ BiblioGlobus)
/* harmony export */ });
const BiblioGlobus = {
    link: (operatorClaimId) => `https://www.bgoperator.ru`,
    title: 'Biblio Globus',
    authType: 'forms',
    claimUrlAuthType: 'basic',
    credentials: {
        login: 'sletat',
        packet: {
            loginPath: "#login",
            passwordPath: "#pwd",
            submitPath: "button.auth_tbl_btn_send"
        },
        password: '0I9~6!0!RWabduJ6Nw',
    },
    selectors: {
        claimButton: '#reqlist tbody td:nth-child(1) a',
        provisaButton: '#Form .buttons a[href^="chservice"]'
    },
    cookie: {
        auth: ['A1', 'L', 'Z1', 'T']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/743.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/743.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Loti: () => (/* binding */ Loti)
/* harmony export */ });
const Loti = {
    link: (operatorClaimId) => 'https://online.loti.ru',
    title: 'Loti',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "form#loginForm input#login",
        passwordPath: "form#loginForm input#password",
        submitPath: "form#loginForm button"
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/768.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/768.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mercury: () => (/* binding */ Mercury)
/* harmony export */ });
const Mercury = {
    link: (operatorClaimId) => `https://samo2.mercury-europe.ru`,
    title: 'Меркурий',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form#loginForm input#login",
            passwordPath: "form#loginForm input#password",
            submitPath: "form#loginForm button.button"
        },
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/78.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/78.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Unex: () => (/* binding */ Unex)
/* harmony export */ });
const Unex = {
    link: (operatorClaimId) => `http://www.unextour.ru/account/login`,
    title: 'UNEX',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "#Login",
            passwordPath: "#Password",
            submitPath: "#loginmenu .form-group input[type=\'submit\']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.AspNet.ApplicationCookie', '.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/800.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/800.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MyAgent: () => (/* binding */ MyAgent)
/* harmony export */ });
const MyAgent = {
    link: (operatorClaimId) => `https://myagent.online/#/`,
    title: 'Мой Агент',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "div.LoginForm input[type=text]",
            "passwordPath": "div.LoginForm input[type=password]",
            "submitPath": "div.LoginForm button[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/81.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/81.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Spectrum: () => (/* binding */ Spectrum)
/* harmony export */ });
const Spectrum = {
    link: (operatorClaimId) => 'http://online.spectrum.ru/cl_refer?',
    title: 'Спектрум',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form#loginForm input#login",
            passwordPath: "form#loginForm input#password",
            submitPath: "form#loginForm button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/93.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/93.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Balkan: () => (/* binding */ Balkan)
/* harmony export */ });
const Balkan = {
    link: (operatorClaimId) => `http://tour.balkan.ru/login.aspx`,
    title: 'BALKAN',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "#ctl00_Login_ctl01 , #ctl00_generalContent_LoginControl_txtUserName , #a_log",
            passwordPath: "#ctl00_Login_ctl02 , #ctl00_generalContent_LoginControl_txtPassword , #a_pass",
            submitPath: "input[name='ctl00$Login$ctl03'] , input[name='ctl00$generalContent$LoginControl$btnLogin'] , header ~ .container button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/970.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/970.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TourPlatforma: () => (/* binding */ TourPlatforma)
/* harmony export */ });
const TourPlatforma = {
    link: (operatorClaimId) => 'https://online.tour-platform.ru',
    title: 'Турплатформа',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "#loginForm #login",
            passwordPath: "#loginForm #password",
            submitPath: "#loginForm button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/artTour.ts":
/*!************************************************!*\
  !*** ./src/serverScripts/operators/artTour.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArtTour: () => (/* binding */ ArtTour)
/* harmony export */ });
const ArtTour = {
    link: (operatorClaimId) => `http://online.arttour.ru`,
    title: 'АРТ-ТУР',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "#login",
        passwordPath: "#password",
        submitPath: "#loginForm .button"
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/eskazan.ts":
/*!************************************************!*\
  !*** ./src/serverScripts/operators/eskazan.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EsKazan: () => (/* binding */ EsKazan)
/* harmony export */ });
const EsKazan = {
    link: (operatorClaimId) => 'https://tour-platform.ru',
    title: 'Турплатформа',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form.login input[type='text'], input#ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "form.login input[type='password'], input#ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "form.login div.base-button, input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/evroport.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/evroport.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Evroport: () => (/* binding */ Evroport)
/* harmony export */ });
const Evroport = {
    link: (operatorClaimId) => 'https://samo.evroport.ru',
    title: 'Evroport',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "#login",
        passwordPath: "#password",
        submitPath: "#loginForm .button"
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/inturist.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/inturist.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Intourist: () => (/* binding */ Intourist)
/* harmony export */ });
const Intourist = {
    link: (operatorClaimId) => 'https://searchtour.intourist.ru',
    title: 'NTK Intourist',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        packet: {
            loginPath: "#loginForm #login",
            passwordPath: "#loginForm #password",
            submitPath: "#loginForm button"
        },
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/iway.ts":
/*!*********************************************!*\
  !*** ./src/serverScripts/operators/iway.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IWay: () => (/* binding */ IWay)
/* harmony export */ });
//857
const IWay = {
    link: (operatorClaimId) => `https://iway.ru`,
    title: 'IWay',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "form#signin-form input[name=login]",
        passwordPath: "form#signin-form input[name=password]",
        submitPath: "form#signin-form button[type=submit]"
    },
    selectors: {},
    cookie: {
        auth: ['authSite']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/kazunion.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/kazunion.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Kazunion: () => (/* binding */ Kazunion)
/* harmony export */ });
const Kazunion = {
    link: (operatorClaimId) => 'https://online.kazunion.com',
    title: 'kazunion',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "form input#login",
        passwordPath: "form input#password",
        submitPath: "form button.button"
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/kompasKz.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/kompasKz.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KompasKz: () => (/* binding */ KompasKz)
/* harmony export */ });
const KompasKz = {
    link: (operatorClaimId) => `https://online.kompastour.kz`,
    title: 'KompasKz',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "form#loginForm input#login",
        passwordPath: "form#loginForm input#password",
        submitPath: "form#loginForm button.button"
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/letsFly.ts":
/*!************************************************!*\
  !*** ./src/serverScripts/operators/letsFly.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LetsFly: () => (/* binding */ LetsFly)
/* harmony export */ });
const LetsFly = {
    link: (operatorClaimId) => `https://samo.sletat.ru`,
    title: 'LetsFly',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form#loginForm input#login",
            passwordPath: "form#loginForm input#password",
            submitPath: "form#loginForm button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/magput.ts":
/*!***********************************************!*\
  !*** ./src/serverScripts/operators/magput.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MagPut: () => (/* binding */ MagPut)
/* harmony export */ });
const MagPut = {
    link: (operatorClaimId) => 'https://tury.magput.ru/agent/search_page.php',
    title: 'Магазин Путешествий',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form input#login",
            passwordPath: "form input#inputPassword",
            submitPath: "form button[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/melinoTravel.ts":
/*!*****************************************************!*\
  !*** ./src/serverScripts/operators/melinoTravel.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MelinoTravel: () => (/* binding */ MelinoTravel)
/* harmony export */ });
const MelinoTravel = {
    link: (operatorClaimId) => 'https://b2b.melinotravel.com',
    title: 'Melino Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "form input#login",
        passwordPath: "form input#password",
        submitPath: "form button.button"
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/oneClickTravel.ts":
/*!*******************************************************!*\
  !*** ./src/serverScripts/operators/oneClickTravel.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OneClickTravel: () => (/* binding */ OneClickTravel)
/* harmony export */ });
const OneClickTravel = {
    link: (operatorClaimId) => 'https://93.184.162.101',
    title: 'One Click Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form input#login",
            passwordPath: "form input#password",
            submitPath: "form button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/rivieraTour.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/operators/rivieraTour.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RivieraTour: () => (/* binding */ RivieraTour)
/* harmony export */ });
const RivieraTour = {
    link: (operatorClaimId) => `http://online.riviera-sochi.ru/MasterWeb_15/login.aspx`,
    title: 'Ривьера Сочи',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form input#login",
            "passwordPath": "form input#passwd",
            "submitPath": "form button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/rusExpress.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/rusExpress.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RusExpress: () => (/* binding */ RusExpress)
/* harmony export */ });
const RusExpress = {
    link: (operatorClaimId) => 'https://online.r-express.ru',
    title: 'Русский Экспресс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: 'form#loginForm input#login',
            passwordPath: 'form#loginForm input#password',
            submitPath: 'form#loginForm button.button'
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/sanatKz.ts":
/*!************************************************!*\
  !*** ./src/serverScripts/operators/sanatKz.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SanatKz: () => (/* binding */ SanatKz)
/* harmony export */ });
const SanatKz = {
    link: (operatorClaimId) => `http://online.sanat.kz`,
    title: 'SanatKz',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    packet: {
        loginPath: "div#loginDialog input#login, input#ctl00_generalContent_LoginControl_txtUserName",
        passwordPath: "div#loginDialog input#password, input#ctl00_generalContent_LoginControl_txtPassword",
        submitPath: "div#loginDialog button.sign-in, input[name='ctl00$generalContent$LoginControl$btnLogin']"
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/skanTour.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/skanTour.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SkanTour: () => (/* binding */ SkanTour)
/* harmony export */ });
const SkanTour = {
    link: (operatorClaimId) => 'https://old.scantour.ru',
    title: 'СканТур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input[name=login]",
            "passwordPath": "input[name=password]",
            "submitPath": "input[name=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/tariTour.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/tariTour.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TariTour: () => (/* binding */ TariTour)
/* harmony export */ });
const TariTour = {
    link: (operatorClaimId) => 'https://www.tarispb.ru',
    title: 'Тари Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input#agentLoginName",
            "passwordPath": "input#agentLoginPswd",
            "submitPath": "form#agentLoginForm button[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/tourClick.ts":
/*!**************************************************!*\
  !*** ./src/serverScripts/operators/tourClick.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TourClick: () => (/* binding */ TourClick)
/* harmony export */ });
const TourClick = {
    link: (operatorClaimId) => 'https://id154.tour-click.ru',
    title: 'TourClick',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form#login-form input#input-18",
            passwordPath: "form#login-form input#input-21",
            submitPath: "button[form=login-form]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['tourclick_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/unona.ts":
/*!**********************************************!*\
  !*** ./src/serverScripts/operators/unona.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Unona: () => (/* binding */ Unona)
/* harmony export */ });
const Unona = {
    link: (operatorClaimId) => 'https://kldtur.ru',
    title: 'Vodohod',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form.form-login input#log",
            passwordPath: "form.form-login input#pwd",
            submitPath: "form.form-login input[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/vodohod.ts":
/*!************************************************!*\
  !*** ./src/serverScripts/operators/vodohod.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Vodohod: () => (/* binding */ Vodohod)
/* harmony export */ });
const Vodohod = {
    link: (operatorClaimId) => 'https://vodohod.com',
    title: 'Vodohod',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "div.section-auth__content input[name=login]",
            "passwordPath": "div.section-auth__content input[name=password]",
            "submitPath": "div.section-auth__bottom button[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!****************************!*\
  !*** ./src/app/content.ts ***!
  \****************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./messages */ "./src/app/messages/index.ts");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/dom */ "./src/app/utils/dom.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./models */ "./src/app/models/index.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils */ "./src/app/utils/index.ts");
/* harmony import */ var _utils_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/constants */ "./src/app/utils/constants.ts");
/* harmony import */ var _utils_chunks_makeOperatorSenderButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/chunks/makeOperatorSenderButton */ "./src/app/utils/chunks/makeOperatorSenderButton.ts");
/* harmony import */ var _utils_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils/page */ "./src/app/utils/page.ts");
/* harmony import */ var _utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils/chunks/goToClaimOperatorType */ "./src/app/utils/chunks/goToClaimOperatorType.ts");
/* harmony import */ var _utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _serverScripts_formFill_formFill_6__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../serverScripts/formFill/formFill_6 */ "./src/serverScripts/formFill/formFill_6.ts");











let DOMLoaded = false;
function waitForDomLoaded() {
    return new Promise((resolve, reject) => {
        const timerId = setInterval(() => {
            if (DOMLoaded) {
                clearInterval(timerId);
                resolve();
            }
        }, 1000);
    });
}
(0,_utils__WEBPACK_IMPORTED_MODULE_3__.addMessageListener)((message, sender, sendResponse) => {
    switch (message.type) {
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.GET_PAGE_STATUS:
            // Здесь пришлось убрать обертку так как не получалось отправить респонс
            // обратно в попап, чтобы обновить стейт
            if (DOMLoaded) {
                if (!(0,_utils_page__WEBPACK_IMPORTED_MODULE_6__.isClaimPage)(window.location)) {
                    sendResponse({ isClaimPage: false });
                    return;
                }
                const { sourceId, claimIdTO, claimNumber, secretField, toAlias } = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getClaimDataFields)();
                if (!sourceId) {
                    return;
                }
                sendResponse({
                    isClaimPage: (0,_utils_page__WEBPACK_IMPORTED_MODULE_6__.isClaimPage)(window.location),
                    claimId: claimIdTO.dataset.claimTouroperatornumber,
                    claimNumber: claimNumber.dataset.claimNumber,
                    sourceId: parseInt(sourceId.dataset.claimSourceid, 10),
                    isOperatorSupported: (0,_utils_page__WEBPACK_IMPORTED_MODULE_6__.isOperatorSupported)(parseInt(sourceId.dataset.claimSourceid, 10)),
                    secretField: encodeURIComponent(secretField.dataset.autofiller)
                });
                return;
            }
            break;
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.GET_IDS:
            if (message && message.payload && message.payload.claimNo && message.payload.claimNo !== '') {
                let claimNoElement = document.querySelector(message.payload.claimNo);
                sendResponse({
                    claimNo: (claimNoElement && claimNoElement.innerHTML) || '',
                    claimNoValue: (claimNoElement && claimNoElement.value) || '',
                    claimNumber: message.payload.claimNumber,
                    claimNoElement: claimNoElement
                });
            }
            else {
                sendResponse({
                    claimNo: '',
                    claimNumber: message.payload.claimNumber,
                    claimNoElement: null
                });
            }
            break;
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.GET_IDS_MESSAGE_AND_STATUS:
            if (message && message.payload
                && message.payload.claimNo && message.payload.claimNo !== ''
                && message.payload.statusSelector && message.payload.statusSelector !== '') {
                let claimNoElement = document.querySelector(message.payload.claimNo);
                let claimStatusElement = document.querySelector(message.payload.statusSelector);
                sendResponse({
                    claimNo: (claimNoElement && claimNoElement.innerHTML) || '',
                    claimNumber: message.payload.claimNumber,
                    claimNoElement: claimNoElement,
                    claimStatus: (claimStatusElement && claimNoElement.innerHTML) || '',
                    claimStatusElement: claimStatusElement
                });
            }
            else {
                sendResponse({
                    claimNo: '',
                    claimNumber: message.payload.claimNumber,
                    claimNoElement: null,
                    claimStatus: null,
                    claimStatusElement: null
                });
            }
            break;
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.GET_ELEMENT:
            const frame = message.payload.frame
                ? window.top.document.querySelector(message.payload.frame).contentWindow.document
                : null;
            let element = frame
                ? frame.querySelector(message.payload.elementSelector)
                : window.top.document.querySelector(message.payload.elementSelector);
            // console.log('GET_ELEMENT');
            // console.dir(element);
            sendResponse({
                element: element,
                innerHTML: element && element.innerHTML ? element.innerHTML : ''
            });
            break;
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.EXECUTE_CONTENT_SCRIPT:
            switch (message.payload.scriptKey) {
                case 'coralFill': {
                    (0,_serverScripts_formFill_formFill_6__WEBPACK_IMPORTED_MODULE_9__.contentCoralFill)(message.payload);
                    break;
                }
                default: break;
            }
            break;
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.GET_DOCUMENT_STATE:
            sendResponse({ documentState: document.readyState });
            break;
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.GET_TOURIST_LINKS:
            switch (message.payload.operatorId) {
                case 3:
                    const touristBlock = document.querySelector(message.payload.touristBlock);
                    sendResponse({ links: Array.prototype.map.call(touristBlock.querySelectorAll('tbody tr:not(:first-child)'), (row) => ({ href: row.querySelector('.link-popup.person_popup_link').href })) });
                    break;
                case 9:
                case 229:
                    sendResponse({ links: document.querySelector(message.payload.touristBlock).innerHTML });
                    break;
            }
            break;
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.GET_PAGE_LOGIN_FORM:
            sendResponse({ loginForm: document.querySelector(message.payload.formPath) || null });
            break;
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.GET_CLAIM_BUTTON:
            sendResponse({ claimButton: document.querySelector(message.payload.claimButton).innerHTML || null });
            break;
        case _models__WEBPACK_IMPORTED_MODULE_2__.MessageTypes.GET_PAGE_SEARCH_FORM:
            sendResponse({ queryInput: document.querySelector(message.payload.queryInput) || null });
            break;
        default:
            break;
    }
});
function doFillScript() {
    console.log('doFillScript');
}
const createButton = (options) => {
    var buttonTarget; // = new HTMLElement; 
    console.log(`createButton ${options.buttonTargetSelector}`);
    buttonTarget = document.getElementById(options.buttonTargetSelector);
    const { claimData, secretField } = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getTourOperatorClaimDataFields)(options.sourceAutoFillSelector, options.sourceAutoFillerToken);
    console.dir(claimData);
    const senderButton = (0,_utils_chunks_makeOperatorSenderButton__WEBPACK_IMPORTED_MODULE_5__.makeOperatorSenderButton)(claimData.dataset.claimSourceid, claimData.dataset.claimTouroperatornumber, options.type, claimData.dataset.claimToalias);
    buttonTarget.appendChild(senderButton);
    senderButton.addEventListener('click', () => {
        senderButton.innerHTML = `<i class="clock icon"></i>`;
        senderButton.setAttribute('disabled', 'disabled');
        (0,_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_8__.wait)(10 * 1000)
            .then(() => {
            senderButton.removeAttribute('disabled');
            senderButton.innerHTML = `<i class="icon search"></i>`;
            senderButton.style.backgroundColor = null;
        });
        if (!claimData.dataset.claimTouroperatornumber.length) {
            return;
        }
        (0,_utils__WEBPACK_IMPORTED_MODULE_3__.sendMessage)((0,_messages__WEBPACK_IMPORTED_MODULE_0__.createStateMessage)((0,_utils_page__WEBPACK_IMPORTED_MODULE_6__.isClaimPage)(window.location), claimData.dataset.claimNumber, parseInt(claimData.dataset.claimSourceid, 10), encodeURIComponent(secretField.dataset.autofiller), claimData.dataset.claimTouroperatornumber, 'magnifier', undefined, {
            magnifierType: options.type,
        }));
    });
};
const createOperatorSenderButton = (type, operatorType) => new Promise(resolve => {
    switch (operatorType) {
        case _utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__.GoToClaimOperatorType.Base: {
            console.log('GoToClaimOperatorType.Base');
            createButton({
                type: type,
                buttonTargetSelector: 'AutoFiller-GoToOperatorPage',
                sourceAutoFillSelector: _utils_constants__WEBPACK_IMPORTED_MODULE_4__.sourceAutoFillSelector,
                sourceAutoFillerToken: _utils_constants__WEBPACK_IMPORTED_MODULE_4__.sourceAutoFillerToken
            });
        }
        case _utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__.GoToClaimOperatorType.Another: {
            createButton({
                type: type + '-another',
                buttonTargetSelector: 'AutoFiller-GoAnotherToOperatorPage',
                sourceAutoFillSelector: _utils_constants__WEBPACK_IMPORTED_MODULE_4__.sourceAutoFillAnotherSelector,
                sourceAutoFillerToken: _utils_constants__WEBPACK_IMPORTED_MODULE_4__.sourceAutoFillerTokenAnother
            });
        }
        case _utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__.GoToClaimOperatorType.Accomodation: {
            createButton({
                type: type + '-acc',
                buttonTargetSelector: 'AutoFiller-GoAccomodationToOperatorPage',
                sourceAutoFillSelector: _utils_constants__WEBPACK_IMPORTED_MODULE_4__.sourceAutoFillAccomodationSelector,
                sourceAutoFillerToken: _utils_constants__WEBPACK_IMPORTED_MODULE_4__.sourceAutoFillerTokenAccomodation
            });
        }
        case _utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__.GoToClaimOperatorType.Accomodation: {
            createButton({
                type: type + '-flg',
                buttonTargetSelector: 'AutoFiller-GoFlightToOperatorPage',
                sourceAutoFillSelector: _utils_constants__WEBPACK_IMPORTED_MODULE_4__.sourceAutoFillFlightSelector,
                sourceAutoFillerToken: _utils_constants__WEBPACK_IMPORTED_MODULE_4__.sourceAutoFillerTokenFlight
            });
        }
    }
    resolve();
});
// creates all magnifier buttons for operator
const createOperatorSenderButtons = (operatorType = _utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__.GoToClaimOperatorType.Base) => {
    const { sourceId, claimIdTO, claimNumber, secretField } = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getClaimDataFields)();
    console.log('createOperatorSenderButtons');
    if (!sourceId) {
        return Promise.reject('Unable to create operator magnifier buttons');
    }
    const operatorId = parseInt(sourceId.dataset.claimSourceid, 10);
    return Promise.all((_utils_constants__WEBPACK_IMPORTED_MODULE_4__.claimMagnifierOperatorTypes[operatorId] || ['default']).map((type) => createOperatorSenderButton(type, operatorType)));
};
const createButtonsByMarkers = (markerSelector, supportingSourcesIds, tabSelector, contentSelector, factoryMethod, postCreation) => new Promise((resolve) => {
    const { sourceId, claimIdTO, claimNumber, secretField } = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getClaimDataFields)();
    if (!sourceId) {
        return Promise.reject('Unable to buttons');
    }
    const sourceIdNum = parseInt(sourceId.dataset.claimSourceid, 10);
    if (supportingSourcesIds && supportingSourcesIds.indexOf(sourceIdNum) === -1) {
        return;
    }
    const tab = document.querySelector(tabSelector);
    const waitForFrameClaimContent = (exists) => new Promise(resolve => {
        let interval = 0;
        const checkIfContentExists = () => {
            const container = document.querySelector(contentSelector);
            if (exists && container) {
                clearInterval(interval);
                resolve(interval);
            }
            if (!exists && !container) {
                clearInterval(interval);
                resolve(interval);
            }
        };
        let timer = setInterval(checkIfContentExists, 100);
    });
    const createBt = (target) => {
        const bt = factoryMethod();
        target.appendChild(bt);
        postCreation(bt, target);
    };
    let interval = -1;
    const createButtons = (targets) => {
        Array.prototype.forEach.call(targets, (target) => {
            if (!target.querySelector('button')) {
                createBt(target);
            }
        });
        clearInterval(interval);
        let timer = setInterval(checkBts, 100);
    };
    const checkBts = () => {
        const targets = document.querySelectorAll(markerSelector);
        Array.prototype.forEach.call(targets, (target) => {
            if (!target.querySelector('button')) {
                createBt(target);
            }
        });
    };
    const targets = document.querySelectorAll(markerSelector);
    createButtons(targets);
    resolve();
});
const createButtonsByMarkersMyAgent = (getTargets, supportingSourcesIds, tabSelector, contentSelector, factoryMethod, postCreation) => new Promise((resolve) => {
    const { sourceId, claimIdTO, claimNumber, secretField } = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getClaimDataFields)();
    if (!sourceId) {
        return Promise.reject('Unable to buttons');
    }
    const sourceIdNum = parseInt(sourceId.dataset.claimSourceid, 10);
    if (supportingSourcesIds && supportingSourcesIds.indexOf(sourceIdNum) === -1) {
        return;
    }
    const tab = document.querySelector(tabSelector);
    const waitForFrameClaimContent = (exists) => new Promise(resolve => {
        let interval = 0;
        const checkIfContentExists = () => {
            const container = document.querySelector(contentSelector);
            if (exists && container) {
                clearInterval(interval);
                resolve(interval);
            }
            if (!exists && !container) {
                clearInterval(interval);
                resolve(interval);
            }
        };
        let timer = setInterval(checkIfContentExists, 100);
    });
    const createBt = (target) => {
        const bt = factoryMethod();
        target.appendChild(bt);
        postCreation(bt, target);
    };
    let interval = -1;
    const createButtons = (targets) => {
        Array.prototype.forEach.call(targets, (target) => {
            if (!target.querySelector('button.myAgentTransfer')) {
                createBt(target);
            }
        });
        clearInterval(interval);
        let timer = setInterval(checkBts, 100);
    };
    const checkBts = () => {
        const targets = getTargets();
        Array.prototype.forEach.call(targets, (target) => {
            if (!target.querySelector('button')) {
                createBt(target);
            }
        });
    };
    const targets = getTargets();
    createButtons(targets);
    resolve();
});
const createOperatorGoToPaymentTransferButtons = () => {
    const { sourceId, claimIdTO, claimNumber, secretField } = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getClaimDataFields)();
    const sourceIdNum = parseInt(sourceId.dataset.claimSourceid, 10);
    return createButtonsByMarkers('.AutoFiller-GoToPaymentTransfer', _utils_constants__WEBPACK_IMPORTED_MODULE_4__.claimTransferFillerOperators, '#PageControlClaimMain_T1T', '#GridClaimTransfer_DXDataRow0', _utils_dom__WEBPACK_IMPORTED_MODULE_1__.makeOperatorGoToPaymentTransferButton, (bt, target) => {
        bt.addEventListener('click', () => {
            (0,_utils__WEBPACK_IMPORTED_MODULE_3__.sendMessage)((0,_messages__WEBPACK_IMPORTED_MODULE_0__.createStateMessage)((0,_utils_page__WEBPACK_IMPORTED_MODULE_6__.isClaimPage)(window.location), claimNumber.dataset.claimNumber, sourceIdNum, encodeURIComponent(secretField.dataset.autofiller), claimIdTO.dataset.claimTouroperatornumber, 'goToPaymentTransferBt', target.getAttribute('data-autofiller')));
        });
    });
};
const createOperatorGoToMyAgentButtons = () => {
    const { sourceId, claimIdTO, claimNumber, secretField } = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getClaimDataFields)();
    const sourceIdNum = parseInt(sourceId.dataset.claimSourceid, 10);
    return createButtonsByMarkers('.AutoFiller-GoToMyAgentBotton', null, '#PageControlClaimMain_T1T', '#GridClaimRefund_DXDataRow0', _utils_dom__WEBPACK_IMPORTED_MODULE_1__.makeOperatorGoToMyAgentButton, (bt, target) => {
        bt.addEventListener('click', () => {
            (0,_utils__WEBPACK_IMPORTED_MODULE_3__.sendMessage)((0,_messages__WEBPACK_IMPORTED_MODULE_0__.createStateMessage)((0,_utils_page__WEBPACK_IMPORTED_MODULE_6__.isClaimPage)(window.location), claimNumber.dataset.claimNumber, sourceIdNum, encodeURIComponent(secretField.dataset.autofiller), claimIdTO.dataset.claimTouroperatornumber, 'goToMyAgent', target.getAttribute('data-autofiller')));
        });
    });
};
const createOperatorGoToMyAgentTransferButtons = (link) => {
    const { sourceId, claimIdTO, claimNumber, secretField } = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getClaimDataFields)();
    const sourceIdNum = parseInt(sourceId.dataset.claimSourceid, 10);
    return createButtonsByMarkersMyAgent(() => {
        var tds = link.parentNode.parentNode.getElementsByTagName('td');
        var lastTd = tds[tds.length - 1];
        return lastTd.querySelectorAll('div');
    }, null, '#PageControlClaimMain_T1T', '#GridClaimRefund_DXDataRow0', _utils_dom__WEBPACK_IMPORTED_MODULE_1__.makeOperatorGoToMyAgentTransferButton, (bt, target) => {
        bt.addEventListener('click', () => {
            (0,_utils__WEBPACK_IMPORTED_MODULE_3__.sendMessage)((0,_messages__WEBPACK_IMPORTED_MODULE_0__.createStateMessage)((0,_utils_page__WEBPACK_IMPORTED_MODULE_6__.isClaimPage)(window.location), claimNumber.dataset.claimNumber, sourceIdNum, encodeURIComponent(secretField.dataset.autofiller), claimIdTO.dataset.claimTouroperatornumber, 'goToMyAgent', target.getAttribute('data-autofiller'), {
                id: link.dataset.id, url: link.dataset.url
            }));
        });
    });
};
const createOperatorGoToPaymentRefundButtons = () => {
    const { sourceId, claimIdTO, claimNumber, secretField } = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getClaimDataFields)();
    const sourceIdNum = parseInt(sourceId.dataset.claimSourceid, 10);
    return createButtonsByMarkers('.AutoFiller-GoToPaymentRefund', _utils_constants__WEBPACK_IMPORTED_MODULE_4__.claimRefundFillerOperators, '#PageControlClaimMain_T1T', '#GridClaimRefund_DXDataRow0', _utils_dom__WEBPACK_IMPORTED_MODULE_1__.makeOperatorGoToPaymentRefundButton, (bt, target) => {
        bt.addEventListener('click', () => {
            (0,_utils__WEBPACK_IMPORTED_MODULE_3__.sendMessage)((0,_messages__WEBPACK_IMPORTED_MODULE_0__.createStateMessage)((0,_utils_page__WEBPACK_IMPORTED_MODULE_6__.isClaimPage)(window.location), claimNumber.dataset.claimNumber, sourceIdNum, encodeURIComponent(secretField.dataset.autofiller), claimIdTO.dataset.claimTouroperatornumber, 'goToPaymentRefundBt', target.getAttribute('data-autofiller')));
        });
    });
};
waitForDomLoaded()
    .then(() => {
    const curTime = Date.now();
    //console.log('waitForDomLoaded = true');
    const timer = setInterval(() => {
        //console.log("document.querySelector('div#AutoFiller-GoToOperatorPage')");
        const autoFillDiv = document.querySelector('div#AutoFiller-GoToOperatorPage');
        if (autoFillDiv
            && autoFillDiv.innerHTML !== null
            && typeof (autoFillDiv.innerHTML) !== 'undefined'
            && autoFillDiv.innerHTML.trim() === '') {
            return Promise.resolve()
                .then(() => createOperatorSenderButtons(_utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__.GoToClaimOperatorType.Base))
                .catch(() => { });
        }
        const autoFillAnotherDiv = document.querySelector('div#AutoFiller-GoAnotherToOperatorPage');
        if (autoFillAnotherDiv
            && autoFillAnotherDiv.innerHTML !== null
            && typeof (autoFillAnotherDiv.innerHTML) !== 'undefined'
            && autoFillAnotherDiv.innerHTML.trim() === '') {
            return Promise.resolve()
                .then(() => createOperatorSenderButtons(_utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__.GoToClaimOperatorType.Another))
                .catch(() => { });
        }
        const autoFillAccomodationDiv = document.querySelector('div#AutoFiller-GoAccomodationToOperatorPage');
        if (autoFillAccomodationDiv
            && autoFillAccomodationDiv.innerHTML !== null
            && typeof (autoFillAccomodationDiv.innerHTML) !== 'undefined'
            && autoFillAccomodationDiv.innerHTML.trim() === '') {
            return Promise.resolve()
                .then(() => createOperatorSenderButtons(_utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__.GoToClaimOperatorType.Accomodation))
                .catch(() => { });
        }
        const autoFillFlightDiv = document.querySelector('div#AutoFiller-GoFlightToOperatorPage');
        if (autoFillFlightDiv
            && autoFillFlightDiv.innerHTML !== null
            && typeof (autoFillFlightDiv.innerHTML) !== 'undefined'
            && autoFillFlightDiv.innerHTML.trim() === '') {
            return Promise.resolve()
                .then(() => createOperatorSenderButtons(_utils_chunks_goToClaimOperatorType__WEBPACK_IMPORTED_MODULE_7__.GoToClaimOperatorType.Flight))
                .catch(() => { });
        }
        if (Date.now() - curTime >= 1 * 60 * 60 * 1000) {
            clearInterval(timer);
        }
    }, 2 * 1000);
    return Promise.resolve();
})
    .then(() => {
    const curTime = Date.now();
    const timer = setInterval(() => {
        const autoFillAnotherDiv = document.querySelector('div.AutoFiller-GoToMyAgentBotton');
        if (autoFillAnotherDiv
            && autoFillAnotherDiv.innerHTML !== null
            && typeof (autoFillAnotherDiv.innerHTML) !== 'undefined'
            && autoFillAnotherDiv.innerHTML.trim() === '') {
            return Promise.resolve()
                .then(() => createOperatorGoToMyAgentButtons())
                .catch(() => { });
        }
        if (Date.now() - curTime >= 10 * 60 * 60 * 1000) {
            clearInterval(timer);
        }
    }, 2 * 1000);
    return Promise.resolve();
})
    .then(() => {
    const curTime = Date.now();
    const timer = setInterval(() => {
        const autoFilltransferUrls = document.querySelectorAll('a[data-type="МойАгент-ЖД"], a[data-type="МойАгент-АВИА"], a[data-type="Fly"]');
        let allButtonsPromises = [];
        if (autoFilltransferUrls.length > 0) {
            for (let i = 0; i < autoFilltransferUrls.length; i++) {
                let autoFilltransferUrl = autoFilltransferUrls[i];
                allButtonsPromises.push(createOperatorGoToMyAgentTransferButtons(autoFilltransferUrl));
            }
            return Promise.all(allButtonsPromises);
        }
        if (Date.now() - curTime >= 10 * 60 * 60 * 1000) {
            clearInterval(timer);
        }
    }, 2 * 1000);
    return Promise.resolve();
})
    .then(() => createOperatorGoToPaymentTransferButtons())
    .then(() => createOperatorGoToPaymentRefundButtons())
    .catch(() => { });
document.addEventListener('DOMContentLoaded', () => {
    DOMLoaded = true;
});

})();

/******/ })()
;
//# sourceMappingURL=content.js.map