/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/app/messages/chunks/createGetIdsMessage.ts":
/*!********************************************************!*\
  !*** ./src/app/messages/chunks/createGetIdsMessage.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createGetIdsMessage: () => (/* binding */ createGetIdsMessage)
/* harmony export */ });
/* harmony import */ var _messageConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../messageConstants */ "./src/app/messages/messageConstants.ts");

function createGetIdsMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_IDS_MESSAGE,
        payload
    };
}


/***/ }),

/***/ "./src/app/messages/chunks/pageSelectors.ts":
/*!**************************************************!*\
  !*** ./src/app/messages/chunks/pageSelectors.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PageSelectors: () => (/* binding */ PageSelectors)
/* harmony export */ });
class PageSelectors {
    constructor(params) {
        Object.keys(params).forEach((key) => {
            this[key] = params[key];
        });
    }
}


/***/ }),

/***/ "./src/app/messages/index.ts":
/*!***********************************!*\
  !*** ./src/app/messages/index.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createErrorMessage: () => (/* binding */ createErrorMessage),
/* harmony export */   createExecuteContentScriptMessage: () => (/* binding */ createExecuteContentScriptMessage),
/* harmony export */   createGetClaimButtonMessage: () => (/* binding */ createGetClaimButtonMessage),
/* harmony export */   createGetDocumentReadyStateMessage: () => (/* binding */ createGetDocumentReadyStateMessage),
/* harmony export */   createGetElementMessage: () => (/* binding */ createGetElementMessage),
/* harmony export */   createGetPageLoginFormMessage: () => (/* binding */ createGetPageLoginFormMessage),
/* harmony export */   createGetPageSearchFormMessage: () => (/* binding */ createGetPageSearchFormMessage),
/* harmony export */   createGetTouristLinksMessage: () => (/* binding */ createGetTouristLinksMessage),
/* harmony export */   createStateMessage: () => (/* binding */ createStateMessage),
/* harmony export */   createTabMessage: () => (/* binding */ createTabMessage)
/* harmony export */ });
/* harmony import */ var _messageConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./messageConstants */ "./src/app/messages/messageConstants.ts");

function createTabMessage() {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_PAGE_STATUS,
        payload: null
    };
}
function createStateMessage(isClaimPage, claimNumber, sourceId, secretField, claimId, senderElementId, paymentOperationId, additionalInfo) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.STATE_MESSAGE,
        payload: {
            isClaimPage,
            claimId,
            claimNumber,
            sourceId,
            secretField,
            senderElementId,
            paymentOperationId,
            additionalInfo,
        }
    };
}
function createGetDocumentReadyStateMessage() {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_DOCUMENT_STATE
    };
}
function createGetElementMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_ELEMENT_MESSAGE,
        payload
    };
}
function createGetTouristLinksMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_TOURIST_LINKS,
        payload
    };
}
function createGetPageSearchFormMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_PAGE_SEARCH_FORM,
        payload
    };
}
function createGetPageLoginFormMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_PAGE_LOGIN_FORM,
        payload
    };
}
function createGetClaimButtonMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_CLAIM_BUTTON,
        payload
    };
}
function createErrorMessage(error) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.ERROR_MESSAGE,
        error,
        payload: null
    };
}
function createExecuteContentScriptMessage(data) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.EXECUTE_CONTENT_SCRIPT,
        payload: data
    };
}


/***/ }),

/***/ "./src/app/messages/messageConstants.ts":
/*!**********************************************!*\
  !*** ./src/app/messages/messageConstants.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ERROR_MESSAGE: () => (/* binding */ ERROR_MESSAGE),
/* harmony export */   EXECUTE_CONTENT_SCRIPT: () => (/* binding */ EXECUTE_CONTENT_SCRIPT),
/* harmony export */   EXECUTE_SCRIPT: () => (/* binding */ EXECUTE_SCRIPT),
/* harmony export */   GET_CLAIM_BUTTON: () => (/* binding */ GET_CLAIM_BUTTON),
/* harmony export */   GET_DOCUMENT_STATE: () => (/* binding */ GET_DOCUMENT_STATE),
/* harmony export */   GET_ELEMENT_MESSAGE: () => (/* binding */ GET_ELEMENT_MESSAGE),
/* harmony export */   GET_IDS_MESSAGE: () => (/* binding */ GET_IDS_MESSAGE),
/* harmony export */   GET_IDS_MESSAGE_AND_STATUS: () => (/* binding */ GET_IDS_MESSAGE_AND_STATUS),
/* harmony export */   GET_PAGE_LOGIN_FORM: () => (/* binding */ GET_PAGE_LOGIN_FORM),
/* harmony export */   GET_PAGE_SEARCH_FORM: () => (/* binding */ GET_PAGE_SEARCH_FORM),
/* harmony export */   GET_PAGE_STATUS: () => (/* binding */ GET_PAGE_STATUS),
/* harmony export */   GET_TOURIST_LINKS: () => (/* binding */ GET_TOURIST_LINKS),
/* harmony export */   STATE_MESSAGE: () => (/* binding */ STATE_MESSAGE)
/* harmony export */ });
const STATE_MESSAGE = 'STATE MESSAGE';
const ERROR_MESSAGE = 'ERROR MESSAGE';
const GET_PAGE_STATUS = 'GET PAGE STATUS';
const GET_IDS_MESSAGE = 'GET IDS';
const GET_DOCUMENT_STATE = 'GET DOCUMENT STATE';
const GET_ELEMENT_MESSAGE = 'GET ELEMENT';
const GET_TOURIST_LINKS = 'GET TOURIST LINKS';
const GET_PAGE_LOGIN_FORM = 'GET PAGE LOGIN FORM';
const GET_PAGE_SEARCH_FORM = 'GET PAGE SEARCH FORM';
const GET_CLAIM_BUTTON = 'GET CLAIM BUTTON';
const GET_IDS_MESSAGE_AND_STATUS = 'GET IDS MESSAGE AND STATUS';
const EXECUTE_SCRIPT = 'EXECUTE SCRIPT';
const EXECUTE_CONTENT_SCRIPT = 'EXECUTE CONTENT SCRIPT';


/***/ }),

/***/ "./src/app/models/chunks/createFillFnMessage.ts":
/*!******************************************************!*\
  !*** ./src/app/models/chunks/createFillFnMessage.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createFillFnMessage: () => (/* binding */ createFillFnMessage)
/* harmony export */ });
/* harmony import */ var _notificationBody__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./notificationBody */ "./src/app/models/chunks/notificationBody.ts");

function createFillFnMessage({ claimId, operator, errorText }) {
    return {
        title: errorText === null
            ? _notificationBody__WEBPACK_IMPORTED_MODULE_0__.FillFnMessageTexts.DONE
            : _notificationBody__WEBPACK_IMPORTED_MODULE_0__.FillFnMessageTexts.FAIL,
        body: {
            claimId,
            operator,
            errorText
        },
        toString() {
            return this.body.errorText
                ? `
                    Ошибка: ${this.body.errorText}\n
                    Tуроператор: ${this.body.operator.title}, Заявка №${this.body.claimId}`
                : `Tуроператор: ${this.body.operator.title}, Заявка №${this.body.claimId}`;
        }
    };
}


/***/ }),

/***/ "./src/app/models/chunks/createSendIdsMessage.ts":
/*!*******************************************************!*\
  !*** ./src/app/models/chunks/createSendIdsMessage.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSendIdsMessage: () => (/* binding */ createSendIdsMessage)
/* harmony export */ });
/* harmony import */ var _notificationBody__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./notificationBody */ "./src/app/models/chunks/notificationBody.ts");

function createSendIdsMessage({ status, message }) {
    return {
        title: status === _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatus.DONE
            ? _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatusTexts.DONE
            : _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatusTexts.FAIL,
        body: {
            status,
            message
        },
        toString() {
            return this.body.status === _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatus.FAIL
                ? `Ошибка отправки: ${this.body.message}`
                : `Успешная отправка: ${this.body.message}`;
        }
    };
}


/***/ }),

/***/ "./src/app/models/chunks/emptyFieldFillerType.ts":
/*!*******************************************************!*\
  !*** ./src/app/models/chunks/emptyFieldFillerType.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmptyFieldFillerType: () => (/* binding */ EmptyFieldFillerType)
/* harmony export */ });
var EmptyFieldFillerType;
(function (EmptyFieldFillerType) {
    EmptyFieldFillerType[EmptyFieldFillerType["No"] = 0] = "No";
    EmptyFieldFillerType[EmptyFieldFillerType["OneForNoData"] = 1] = "OneForNoData";
})(EmptyFieldFillerType || (EmptyFieldFillerType = {}));


/***/ }),

/***/ "./src/app/models/chunks/fillerParams.ts":
/*!***********************************************!*\
  !*** ./src/app/models/chunks/fillerParams.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MapFillerParams: () => (/* binding */ MapFillerParams)
/* harmony export */ });
/* harmony import */ var _utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../../utils/chunks/common/oneForNoData */ "./src/app/utils/chunks/common/oneForNoData.ts");
/* harmony import */ var _emptyFieldFillerType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./emptyFieldFillerType */ "./src/app/models/chunks/emptyFieldFillerType.ts");


function MapFillerParams(data, fillerType = _emptyFieldFillerType__WEBPACK_IMPORTED_MODULE_1__.EmptyFieldFillerType.No) {
    try {
        if (data && data.autoFillerData && data.autoFillerData.customer) {
            data.autoFillerData.customer.eVoucherClaimNumber = data.eVoucherClaimNumber;
            data.autoFillerData.customer.eVoucherCurrency = data.eVoucherCurrency;
            data.autoFillerData.customer.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
            data.autoFillerData.customer.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
        }
    }
    catch (e) { }
    switch (fillerType) {
        case _emptyFieldFillerType__WEBPACK_IMPORTED_MODULE_1__.EmptyFieldFillerType.OneForNoData: {
            Array.prototype.forEach.call(data.autoFillerData.touristDataItems, tourist => {
                return (0,_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_0__.oneForNoData)(tourist);
            });
            break;
        }
        case _emptyFieldFillerType__WEBPACK_IMPORTED_MODULE_1__.EmptyFieldFillerType.No:
        default: break;
    }
    return {
        tourists: data.autoFillerData.touristDataItems,
        bookingCompanyId: data.bookingCompanyId,
        countryTo: data.countryTo,
        customer: data.autoFillerData.customer,
        isAdvanceBooking: data.isAdvanceBooking
    };
}


/***/ }),

/***/ "./src/app/models/chunks/notificationBody.ts":
/*!***************************************************!*\
  !*** ./src/app/models/chunks/notificationBody.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FillFnMessageTexts: () => (/* binding */ FillFnMessageTexts),
/* harmony export */   SendIdsStatus: () => (/* binding */ SendIdsStatus),
/* harmony export */   SendIdsStatusTexts: () => (/* binding */ SendIdsStatusTexts)
/* harmony export */ });
var SendIdsStatus;
(function (SendIdsStatus) {
    SendIdsStatus["DONE"] = "DONE";
    SendIdsStatus["FAIL"] = "FAIL";
})(SendIdsStatus || (SendIdsStatus = {}));
var SendIdsStatusTexts;
(function (SendIdsStatusTexts) {
    SendIdsStatusTexts["DONE"] = "\u0418\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u044B \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u043F\u0435\u0440\u0435\u0434\u0430\u043D\u044B \u043D\u0430 \u0441\u0435\u0440\u0432\u0435\u0440!";
    SendIdsStatusTexts["FAIL"] = "\u041F\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0438\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u043E\u0432 \u043D\u0435 \u0443\u0434\u0430\u043B\u0430\u0441\u044C";
})(SendIdsStatusTexts || (SendIdsStatusTexts = {}));
var FillFnMessageTexts;
(function (FillFnMessageTexts) {
    FillFnMessageTexts["DONE"] = "\u0417\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u0435 \u0432\u044B\u043F\u043E\u043B\u043D\u0435\u043D\u043E \u0443\u0441\u043F\u0435\u0448\u043D\u043E!";
    FillFnMessageTexts["FAIL"] = "\u0417\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u0435 \u043D\u0435 \u0432\u044B\u043F\u043E\u043B\u043D\u0435\u043D\u043E";
})(FillFnMessageTexts || (FillFnMessageTexts = {}));


/***/ }),

/***/ "./src/app/models/errors.ts":
/*!**********************************!*\
  !*** ./src/app/models/errors.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RequestError: () => (/* binding */ RequestError)
/* harmony export */ });
class RequestError extends Error {
    constructor(reason) {
        super(reason);
        this.name = 'RequestError';
        this.message = 'Ошибка запроса';
        this.message = `${this.message}: ${reason}`;
    }
}


/***/ }),

/***/ "./src/app/models/index.ts":
/*!*********************************!*\
  !*** ./src/app/models/index.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ClaimConfirmationStatus: () => (/* binding */ ClaimConfirmationStatus),
/* harmony export */   EmptyScript: () => (/* binding */ EmptyScript),
/* harmony export */   ErrorTypes: () => (/* binding */ ErrorTypes),
/* harmony export */   MessageTypes: () => (/* binding */ MessageTypes),
/* harmony export */   PageStatuses: () => (/* binding */ PageStatuses),
/* harmony export */   RequestError: () => (/* reexport safe */ _errors__WEBPACK_IMPORTED_MODULE_0__.RequestError),
/* harmony export */   ScriptType: () => (/* binding */ ScriptType),
/* harmony export */   SenderTypes: () => (/* binding */ SenderTypes)
/* harmony export */ });
/* harmony import */ var _errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./errors */ "./src/app/models/errors.ts");

var ScriptType;
(function (ScriptType) {
    ScriptType[ScriptType["Login"] = 0] = "Login";
    ScriptType[ScriptType["FormFill"] = 1] = "FormFill";
    ScriptType[ScriptType["VisaFill"] = 2] = "VisaFill";
    ScriptType[ScriptType["NavToBookedClaim"] = 3] = "NavToBookedClaim";
})(ScriptType || (ScriptType = {}));
const EmptyScript = {
    scriptId: '',
    tourOperatorId: '',
    sletatId: 0,
    body: '',
    createDateUtc: '',
    type: ScriptType.Login,
    isActive: false,
    version: '',
};
var ClaimConfirmationStatus;
(function (ClaimConfirmationStatus) {
    ClaimConfirmationStatus[ClaimConfirmationStatus["NOT_CONFIRMED"] = 1] = "NOT_CONFIRMED";
    ClaimConfirmationStatus[ClaimConfirmationStatus["WAITING"] = 2] = "WAITING";
    ClaimConfirmationStatus[ClaimConfirmationStatus["CONFIRMED"] = 3] = "CONFIRMED";
})(ClaimConfirmationStatus || (ClaimConfirmationStatus = {}));
var ErrorTypes;
(function (ErrorTypes) {
    ErrorTypes["NO_CLAIM_PAGE"] = "\u0412\u044B \u043D\u0435 \u043D\u0430\u0445\u043E\u0434\u0438\u0442\u0435\u0441\u044C \u043D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0435 \u0437\u0430\u044F\u0432\u043A\u0438";
    ErrorTypes["NO_VISA_NEEDED"] = "\u041E\u0444\u043E\u0440\u043C\u043B\u0435\u043D\u0438\u0435 \u0432\u0438\u0437\u044B \u0434\u043B\u044F \u0434\u0430\u043D\u043D\u043E\u0439 \u0437\u0430\u044F\u0432\u043A\u0438 \u043D\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F";
    ErrorTypes["NO_TO_ID"] = "\u041F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u0435\u043D. \u041D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0435 \u0426\u0411 \u043D\u0435 \u0443\u043A\u0430\u0437\u0430\u043D id \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430, \u043F\u043E\u043F\u0440\u043E\u0431\u0443\u0439\u0442\u0435 \u043F\u043E\u0437\u0436\u0435.";
    ErrorTypes["NO_CLAIM_ID"] = "\u041F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u0435\u043D. \u041D\u0435 \u043F\u0440\u043E\u0441\u0442\u0430\u0432\u043B\u0435\u043D \u043D\u043E\u043C\u0435\u0440 \u0437\u0430\u044F\u0432\u043A\u0438 \u0442\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430.";
    ErrorTypes["TO_NOT_SUPPORTED"] = "\u0423\u0432\u044B, \u0424\u0438\u043B\u044F \u043F\u043E\u043A\u0430 \u0447\u0442\u043E \u043D\u0435 \u043F\u043E\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u0434\u0430\u043D\u043D\u043E\u0433\u043E \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 :(";
    ErrorTypes["TO_RESTRICTED"] = "\u0414\u0430\u043D\u043D\u044B\u0439 \u0442\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440 \u043D\u0435 \u043F\u0440\u0435\u0434\u043E\u0441\u0442\u0430\u0432\u043B\u044F\u0435\u0442 \u043F\u0440\u044F\u043C\u0443\u044E \u0441\u0441\u044B\u043B\u043A\u0443 \u043D\u0430 \u0442\u0443\u0440, \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u0435 \u0432\u043E\u0437\u043C\u043E\u0436\u043D\u043E \u0442\u043E\u043B\u044C\u043A\u043E \u0432\u0440\u0443\u0447\u043D\u0443\u044E";
    ErrorTypes["CLAIM_ALREADY_BOOKED"] = "\u0414\u0430\u043D\u043D\u0430\u044F \u0437\u0430\u044F\u0432\u043A\u0430 \u0443\u0436\u0435 \u0431\u044B\u043B\u0430 \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0430 \u0438 \u0437\u0430\u0431\u0440\u043E\u043D\u0438\u0440\u043E\u0432\u0430\u043D\u0430 \u043D\u0430 \u0441\u0430\u0439\u0442\u0435 \u0442\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430. \u0427\u0442\u043E\u0431\u044B \u043F\u0440\u043E\u0441\u043C\u043E\u0442\u0440\u0435\u0442\u044C \u0435\u0435, \u0432\u043E\u0441\u043F\u043E\u043B\u044C\u0437\u0443\u0439\u0442\u0435\u0441\u044C \u043A\u043D\u043E\u043F\u043A\u043E\u0439 \"\u041B\u0443\u043F\u0430\"";
    ErrorTypes["UNKNOWN"] = "\u041F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u0435\u043D. \u041D\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043D\u0430\u044F \u043E\u0448\u0438\u0431\u043A\u0430.";
})(ErrorTypes || (ErrorTypes = {}));
var MessageTypes;
(function (MessageTypes) {
    MessageTypes["GET_PAGE_STATUS"] = "GET PAGE STATUS";
    MessageTypes["PASS_TO_CREDS"] = "PASS TO CREDS";
    MessageTypes["ERROR"] = "ERROR";
    MessageTypes["GET_IDS"] = "GET IDS";
    MessageTypes["GET_ELEMENT"] = "GET ELEMENT";
    MessageTypes["GET_TOURIST_LINKS"] = "GET TOURIST LINKS";
    MessageTypes["GET_PAGE_LOGIN_FORM"] = "GET PAGE LOGIN FORM";
    MessageTypes["GET_PAGE_SEARCH_FORM"] = "GET PAGE SEARCH FORM";
    MessageTypes["GET_CLAIM_BUTTON"] = "GET CLAIM BUTTON";
    MessageTypes["GET_DOCUMENT_STATE"] = "GET DOCUMENT STATE";
    MessageTypes["GET_IDS_MESSAGE_AND_STATUS"] = "GET IDS MESSAGE AND STATUS";
    MessageTypes["EXECUTE_CONTENT_SCRIPT"] = "EXECUTE CONTENT SCRIPT";
})(MessageTypes || (MessageTypes = {}));
var PageStatuses;
(function (PageStatuses) {
    PageStatuses["IS_CLAIM_PAGE"] = "IS_CLAIM_PAGE";
    PageStatuses["IS_OPERATOR_SUPPORTED"] = "IS_OPERATOR_SUPPORTED";
})(PageStatuses || (PageStatuses = {}));
var SenderTypes;
(function (SenderTypes) {
    SenderTypes[SenderTypes["TAB_SENDER"] = 0] = "TAB_SENDER";
    SenderTypes[SenderTypes["EXT_SENDER"] = 1] = "EXT_SENDER";
})(SenderTypes || (SenderTypes = {}));


/***/ }),

/***/ "./src/app/operators.ts":
/*!******************************!*\
  !*** ./src/app/operators.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OPERATORS: () => (/* binding */ OPERATORS),
/* harmony export */   tryGetOperator: () => (/* binding */ tryGetOperator)
/* harmony export */ });
/* harmony import */ var _serverScripts_operators_156__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../serverScripts/operators/156 */ "./src/serverScripts/operators/156.ts");
/* harmony import */ var _serverScripts_operators_3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../serverScripts/operators/3 */ "./src/serverScripts/operators/3.ts");
/* harmony import */ var _serverScripts_operators_4__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../serverScripts/operators/4 */ "./src/serverScripts/operators/4.ts");
/* harmony import */ var _serverScripts_operators_6__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../serverScripts/operators/6 */ "./src/serverScripts/operators/6.ts");
/* harmony import */ var _serverScripts_operators_7__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../serverScripts/operators/7 */ "./src/serverScripts/operators/7.ts");
/* harmony import */ var _serverScripts_operators_inturist__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../serverScripts/operators/inturist */ "./src/serverScripts/operators/inturist.ts");
/* harmony import */ var _serverScripts_operators_14__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./../serverScripts/operators/14 */ "./src/serverScripts/operators/14.ts");
/* harmony import */ var _serverScripts_operators_19__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./../serverScripts/operators/19 */ "./src/serverScripts/operators/19.ts");
/* harmony import */ var _serverScripts_operators_20__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./../serverScripts/operators/20 */ "./src/serverScripts/operators/20.ts");
/* harmony import */ var _serverScripts_operators_rusExpress__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../serverScripts/operators/rusExpress */ "./src/serverScripts/operators/rusExpress.ts");
/* harmony import */ var _serverScripts_operators_39__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./../serverScripts/operators/39 */ "./src/serverScripts/operators/39.ts");
/* harmony import */ var _serverScripts_operators_41__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./../serverScripts/operators/41 */ "./src/serverScripts/operators/41.ts");
/* harmony import */ var _serverScripts_operators_42__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./../serverScripts/operators/42 */ "./src/serverScripts/operators/42.ts");
/* harmony import */ var _serverScripts_operators_46__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./../serverScripts/operators/46 */ "./src/serverScripts/operators/46.ts");
/* harmony import */ var _serverScripts_operators_49__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./../serverScripts/operators/49 */ "./src/serverScripts/operators/49.ts");
/* harmony import */ var _serverScripts_operators_51__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./../serverScripts/operators/51 */ "./src/serverScripts/operators/51.ts");
/* harmony import */ var _serverScripts_operators_53__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./../serverScripts/operators/53 */ "./src/serverScripts/operators/53.ts");
/* harmony import */ var _serverScripts_operators_54__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./../serverScripts/operators/54 */ "./src/serverScripts/operators/54.ts");
/* harmony import */ var _serverScripts_operators_78__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./../serverScripts/operators/78 */ "./src/serverScripts/operators/78.ts");
/* harmony import */ var _serverScripts_operators_81__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./../serverScripts/operators/81 */ "./src/serverScripts/operators/81.ts");
/* harmony import */ var _serverScripts_operators_artTour__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./../serverScripts/operators/artTour */ "./src/serverScripts/operators/artTour.ts");
/* harmony import */ var _serverScripts_operators_93__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./../serverScripts/operators/93 */ "./src/serverScripts/operators/93.ts");
/* harmony import */ var _serverScripts_operators_107__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./../serverScripts/operators/107 */ "./src/serverScripts/operators/107.ts");
/* harmony import */ var _serverScripts_operators_108__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./../serverScripts/operators/108 */ "./src/serverScripts/operators/108.ts");
/* harmony import */ var _serverScripts_operators_112__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./../serverScripts/operators/112 */ "./src/serverScripts/operators/112.ts");
/* harmony import */ var _serverScripts_operators_113__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./../serverScripts/operators/113 */ "./src/serverScripts/operators/113.ts");
/* harmony import */ var _serverScripts_operators_123__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./../serverScripts/operators/123 */ "./src/serverScripts/operators/123.ts");
/* harmony import */ var _serverScripts_operators_130__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./../serverScripts/operators/130 */ "./src/serverScripts/operators/130.ts");
/* harmony import */ var _serverScripts_operators_131__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./../serverScripts/operators/131 */ "./src/serverScripts/operators/131.ts");
/* harmony import */ var _serverScripts_operators_141__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./../serverScripts/operators/141 */ "./src/serverScripts/operators/141.ts");
/* harmony import */ var _serverScripts_operators_142__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./../serverScripts/operators/142 */ "./src/serverScripts/operators/142.ts");
/* harmony import */ var _serverScripts_operators_145__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./../serverScripts/operators/145 */ "./src/serverScripts/operators/145.ts");
/* harmony import */ var _serverScripts_operators_152__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./../serverScripts/operators/152 */ "./src/serverScripts/operators/152.ts");
/* harmony import */ var _serverScripts_operators_153__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./../serverScripts/operators/153 */ "./src/serverScripts/operators/153.ts");
/* harmony import */ var _serverScripts_operators_155__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./../serverScripts/operators/155 */ "./src/serverScripts/operators/155.ts");
/* harmony import */ var _serverScripts_operators_158__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./../serverScripts/operators/158 */ "./src/serverScripts/operators/158.ts");
/* harmony import */ var _serverScripts_operators_160__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./../serverScripts/operators/160 */ "./src/serverScripts/operators/160.ts");
/* harmony import */ var _serverScripts_operators_162__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./../serverScripts/operators/162 */ "./src/serverScripts/operators/162.ts");
/* harmony import */ var _serverScripts_operators_165__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./../serverScripts/operators/165 */ "./src/serverScripts/operators/165.ts");
/* harmony import */ var _serverScripts_operators_171__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./../serverScripts/operators/171 */ "./src/serverScripts/operators/171.ts");
/* harmony import */ var _serverScripts_operators_174__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./../serverScripts/operators/174 */ "./src/serverScripts/operators/174.ts");
/* harmony import */ var _serverScripts_operators_184__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./../serverScripts/operators/184 */ "./src/serverScripts/operators/184.ts");
/* harmony import */ var _serverScripts_operators_kompasKz__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./../serverScripts/operators/kompasKz */ "./src/serverScripts/operators/kompasKz.ts");
/* harmony import */ var _serverScripts_operators_evroport__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./../serverScripts/operators/evroport */ "./src/serverScripts/operators/evroport.ts");
/* harmony import */ var _serverScripts_operators_sanatKz__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./../serverScripts/operators/sanatKz */ "./src/serverScripts/operators/sanatKz.ts");
/* harmony import */ var _serverScripts_operators_205__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./../serverScripts/operators/205 */ "./src/serverScripts/operators/205.ts");
/* harmony import */ var _serverScripts_operators_213__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./../serverScripts/operators/213 */ "./src/serverScripts/operators/213.ts");
/* harmony import */ var _serverScripts_operators_219__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ../serverScripts/operators/219 */ "./src/serverScripts/operators/219.ts");
/* harmony import */ var _serverScripts_operators_229__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ../serverScripts/operators/229 */ "./src/serverScripts/operators/229.ts");
/* harmony import */ var _serverScripts_operators_231__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./../serverScripts/operators/231 */ "./src/serverScripts/operators/231.ts");
/* harmony import */ var _serverScripts_operators_237__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./../serverScripts/operators/237 */ "./src/serverScripts/operators/237.ts");
/* harmony import */ var _serverScripts_operators_238__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./../serverScripts/operators/238 */ "./src/serverScripts/operators/238.ts");
/* harmony import */ var _serverScripts_operators_248__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./../serverScripts/operators/248 */ "./src/serverScripts/operators/248.ts");
/* harmony import */ var _serverScripts_operators_252__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./../serverScripts/operators/252 */ "./src/serverScripts/operators/252.ts");
/* harmony import */ var _serverScripts_operators_260__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./../serverScripts/operators/260 */ "./src/serverScripts/operators/260.ts");
/* harmony import */ var _serverScripts_operators_269__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./../serverScripts/operators/269 */ "./src/serverScripts/operators/269.ts");
/* harmony import */ var _serverScripts_operators_277__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./../serverScripts/operators/277 */ "./src/serverScripts/operators/277.ts");
/* harmony import */ var _serverScripts_operators_280__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./../serverScripts/operators/280 */ "./src/serverScripts/operators/280.ts");
/* harmony import */ var _serverScripts_operators_282__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./../serverScripts/operators/282 */ "./src/serverScripts/operators/282.ts");
/* harmony import */ var _serverScripts_operators_301__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./../serverScripts/operators/301 */ "./src/serverScripts/operators/301.ts");
/* harmony import */ var _serverScripts_operators_302__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./../serverScripts/operators/302 */ "./src/serverScripts/operators/302.ts");
/* harmony import */ var _serverScripts_operators_304__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./../serverScripts/operators/304 */ "./src/serverScripts/operators/304.ts");
/* harmony import */ var _serverScripts_operators_309__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./../serverScripts/operators/309 */ "./src/serverScripts/operators/309.ts");
/* harmony import */ var _serverScripts_operators_311__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./../serverScripts/operators/311 */ "./src/serverScripts/operators/311.ts");
/* harmony import */ var _serverScripts_operators_315__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./../serverScripts/operators/315 */ "./src/serverScripts/operators/315.ts");
/* harmony import */ var _serverScripts_operators_331__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./../serverScripts/operators/331 */ "./src/serverScripts/operators/331.ts");
/* harmony import */ var _serverScripts_operators_343__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ./../serverScripts/operators/343 */ "./src/serverScripts/operators/343.ts");
/* harmony import */ var _serverScripts_operators_344__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ./../serverScripts/operators/344 */ "./src/serverScripts/operators/344.ts");
/* harmony import */ var _serverScripts_operators_345__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ./../serverScripts/operators/345 */ "./src/serverScripts/operators/345.ts");
/* harmony import */ var _serverScripts_operators_348__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ./../serverScripts/operators/348 */ "./src/serverScripts/operators/348.ts");
/* harmony import */ var _serverScripts_operators_361__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ./../serverScripts/operators/361 */ "./src/serverScripts/operators/361.ts");
/* harmony import */ var _serverScripts_operators_378__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ./../serverScripts/operators/378 */ "./src/serverScripts/operators/378.ts");
/* harmony import */ var _serverScripts_operators_380__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ./../serverScripts/operators/380 */ "./src/serverScripts/operators/380.ts");
/* harmony import */ var _serverScripts_operators_382__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ./../serverScripts/operators/382 */ "./src/serverScripts/operators/382.ts");
/* harmony import */ var _serverScripts_operators_392__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(/*! ./../serverScripts/operators/392 */ "./src/serverScripts/operators/392.ts");
/* harmony import */ var _serverScripts_operators_415__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(/*! ./../serverScripts/operators/415 */ "./src/serverScripts/operators/415.ts");
/* harmony import */ var _serverScripts_operators_429__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(/*! ./../serverScripts/operators/429 */ "./src/serverScripts/operators/429.ts");
/* harmony import */ var _serverScripts_operators_431__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(/*! ./../serverScripts/operators/431 */ "./src/serverScripts/operators/431.ts");
/* harmony import */ var _serverScripts_operators_432__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(/*! ./../serverScripts/operators/432 */ "./src/serverScripts/operators/432.ts");
/* harmony import */ var _serverScripts_operators_439__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(/*! ./../serverScripts/operators/439 */ "./src/serverScripts/operators/439.ts");
/* harmony import */ var _serverScripts_operators_449__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(/*! ./../serverScripts/operators/449 */ "./src/serverScripts/operators/449.ts");
/* harmony import */ var _serverScripts_operators_450__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(/*! ./../serverScripts/operators/450 */ "./src/serverScripts/operators/450.ts");
/* harmony import */ var _serverScripts_operators_452__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(/*! ./../serverScripts/operators/452 */ "./src/serverScripts/operators/452.ts");
/* harmony import */ var _serverScripts_operators_453__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(/*! ../serverScripts/operators/453 */ "./src/serverScripts/operators/453.ts");
/* harmony import */ var _serverScripts_operators_454__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(/*! ./../serverScripts/operators/454 */ "./src/serverScripts/operators/454.ts");
/* harmony import */ var _serverScripts_operators_457__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__(/*! ./../serverScripts/operators/457 */ "./src/serverScripts/operators/457.ts");
/* harmony import */ var _serverScripts_operators_536__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__(/*! ./../serverScripts/operators/536 */ "./src/serverScripts/operators/536.ts");
/* harmony import */ var _serverScripts_operators_544__WEBPACK_IMPORTED_MODULE_87__ = __webpack_require__(/*! ./../serverScripts/operators/544 */ "./src/serverScripts/operators/544.ts");
/* harmony import */ var _serverScripts_operators_564__WEBPACK_IMPORTED_MODULE_88__ = __webpack_require__(/*! ./../serverScripts/operators/564 */ "./src/serverScripts/operators/564.ts");
/* harmony import */ var _serverScripts_operators_970__WEBPACK_IMPORTED_MODULE_89__ = __webpack_require__(/*! ../serverScripts/operators/970 */ "./src/serverScripts/operators/970.ts");
/* harmony import */ var _serverScripts_operators_743__WEBPACK_IMPORTED_MODULE_90__ = __webpack_require__(/*! ./../serverScripts/operators/743 */ "./src/serverScripts/operators/743.ts");
/* harmony import */ var _serverScripts_operators_768__WEBPACK_IMPORTED_MODULE_91__ = __webpack_require__(/*! ./../serverScripts/operators/768 */ "./src/serverScripts/operators/768.ts");
/* harmony import */ var _serverScripts_operators_800__WEBPACK_IMPORTED_MODULE_92__ = __webpack_require__(/*! ./../serverScripts/operators/800 */ "./src/serverScripts/operators/800.ts");
/* harmony import */ var _serverScripts_operators_iway__WEBPACK_IMPORTED_MODULE_93__ = __webpack_require__(/*! ./../serverScripts/operators/iway */ "./src/serverScripts/operators/iway.ts");
/* harmony import */ var _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__ = __webpack_require__(/*! ./../serverScripts/operators/tourClick */ "./src/serverScripts/operators/tourClick.ts");
/* harmony import */ var _serverScripts_operators_letsFly__WEBPACK_IMPORTED_MODULE_95__ = __webpack_require__(/*! ../serverScripts/operators/letsFly */ "./src/serverScripts/operators/letsFly.ts");
/* harmony import */ var _serverScripts_operators_2147483639__WEBPACK_IMPORTED_MODULE_96__ = __webpack_require__(/*! ./../serverScripts/operators/2147483639 */ "./src/serverScripts/operators/2147483639.ts");
/* harmony import */ var _serverScripts_operators_2147483640__WEBPACK_IMPORTED_MODULE_97__ = __webpack_require__(/*! ./../serverScripts/operators/2147483640 */ "./src/serverScripts/operators/2147483640.ts");
/* harmony import */ var _serverScripts_operators_2147483641__WEBPACK_IMPORTED_MODULE_98__ = __webpack_require__(/*! ./../serverScripts/operators/2147483641 */ "./src/serverScripts/operators/2147483641.ts");
/* harmony import */ var _serverScripts_operators_2147483645__WEBPACK_IMPORTED_MODULE_99__ = __webpack_require__(/*! ./../serverScripts/operators/2147483645 */ "./src/serverScripts/operators/2147483645.ts");
/* harmony import */ var _serverScripts_operators_eskazan__WEBPACK_IMPORTED_MODULE_100__ = __webpack_require__(/*! ../serverScripts/operators/eskazan */ "./src/serverScripts/operators/eskazan.ts");
/* harmony import */ var _serverScripts_operators_oneClickTravel__WEBPACK_IMPORTED_MODULE_101__ = __webpack_require__(/*! ../serverScripts/operators/oneClickTravel */ "./src/serverScripts/operators/oneClickTravel.ts");
/* harmony import */ var _serverScripts_operators_kazunion__WEBPACK_IMPORTED_MODULE_102__ = __webpack_require__(/*! ../serverScripts/operators/kazunion */ "./src/serverScripts/operators/kazunion.ts");
/* harmony import */ var _serverScripts_operators_tariTour__WEBPACK_IMPORTED_MODULE_103__ = __webpack_require__(/*! ../serverScripts/operators/tariTour */ "./src/serverScripts/operators/tariTour.ts");
/* harmony import */ var _serverScripts_operators_skanTour__WEBPACK_IMPORTED_MODULE_104__ = __webpack_require__(/*! ../serverScripts/operators/skanTour */ "./src/serverScripts/operators/skanTour.ts");
/* harmony import */ var _serverScripts_operators_vodohod__WEBPACK_IMPORTED_MODULE_105__ = __webpack_require__(/*! ../serverScripts/operators/vodohod */ "./src/serverScripts/operators/vodohod.ts");
/* harmony import */ var _serverScripts_operators_melinoTravel__WEBPACK_IMPORTED_MODULE_106__ = __webpack_require__(/*! ../serverScripts/operators/melinoTravel */ "./src/serverScripts/operators/melinoTravel.ts");
/* harmony import */ var _serverScripts_operators_rivieraTour__WEBPACK_IMPORTED_MODULE_107__ = __webpack_require__(/*! ../serverScripts/operators/rivieraTour */ "./src/serverScripts/operators/rivieraTour.ts");
/* harmony import */ var _serverScripts_operators_unona__WEBPACK_IMPORTED_MODULE_108__ = __webpack_require__(/*! ../serverScripts/operators/unona */ "./src/serverScripts/operators/unona.ts");
/* harmony import */ var _serverScripts_operators_magput__WEBPACK_IMPORTED_MODULE_109__ = __webpack_require__(/*! ../serverScripts/operators/magput */ "./src/serverScripts/operators/magput.ts");






































































//import { Krypton } from './../serverScripts/operators/355';








































const tryGetOperator = (sletatId, toAlias) => {
    if (sletatId) {
        const op = OPERATORS[sletatId];
        if (op) {
            return op;
        }
    }
    if (toAlias) {
        const op = OPERATORS[toAlias];
        if (op) {
            return op;
        }
    }
    return null;
};
const OPERATORS = {
    3: _serverScripts_operators_3__WEBPACK_IMPORTED_MODULE_1__.Pegas,
    4: _serverScripts_operators_4__WEBPACK_IMPORTED_MODULE_2__.TezTour,
    6: _serverScripts_operators_6__WEBPACK_IMPORTED_MODULE_3__.Coral,
    7: _serverScripts_operators_7__WEBPACK_IMPORTED_MODULE_4__.BiblioGlobus,
    //9: Intourist,
    14: _serverScripts_operators_14__WEBPACK_IMPORTED_MODULE_6__.PacGroup,
    19: _serverScripts_operators_19__WEBPACK_IMPORTED_MODULE_7__.Anex,
    20: _serverScripts_operators_20__WEBPACK_IMPORTED_MODULE_8__.IcsTravel,
    38: _serverScripts_operators_rusExpress__WEBPACK_IMPORTED_MODULE_9__.RusExpress,
    39: _serverScripts_operators_39__WEBPACK_IMPORTED_MODULE_10__.DiamondTours,
    41: _serverScripts_operators_41__WEBPACK_IMPORTED_MODULE_11__.Bontour,
    42: _serverScripts_operators_42__WEBPACK_IMPORTED_MODULE_12__.ZlataPraga,
    46: _serverScripts_operators_46__WEBPACK_IMPORTED_MODULE_13__.Troyka,
    49: _serverScripts_operators_49__WEBPACK_IMPORTED_MODULE_14__.Vilar,
    51: _serverScripts_operators_51__WEBPACK_IMPORTED_MODULE_15__.Ambotis,
    53: _serverScripts_operators_53__WEBPACK_IMPORTED_MODULE_16__.IntravelStoleshniki,
    54: _serverScripts_operators_54__WEBPACK_IMPORTED_MODULE_17__.Sunmar,
    78: _serverScripts_operators_78__WEBPACK_IMPORTED_MODULE_18__.Unex,
    81: _serverScripts_operators_81__WEBPACK_IMPORTED_MODULE_19__.Spectrum,
    83: _serverScripts_operators_artTour__WEBPACK_IMPORTED_MODULE_20__.ArtTour,
    93: _serverScripts_operators_93__WEBPACK_IMPORTED_MODULE_21__.Balkan,
    107: _serverScripts_operators_107__WEBPACK_IMPORTED_MODULE_22__.Danko,
    108: _serverScripts_operators_108__WEBPACK_IMPORTED_MODULE_23__.DeltaTours,
    112: _serverScripts_operators_112__WEBPACK_IMPORTED_MODULE_24__.ExpressTour,
    113: _serverScripts_operators_113__WEBPACK_IMPORTED_MODULE_25__.Grand,
    123: _serverScripts_operators_123__WEBPACK_IMPORTED_MODULE_26__.Itm,
    125: _serverScripts_operators_439__WEBPACK_IMPORTED_MODULE_79__.Paks,
    130: _serverScripts_operators_130__WEBPACK_IMPORTED_MODULE_27__.WestTravel,
    131: _serverScripts_operators_131__WEBPACK_IMPORTED_MODULE_28__.ArtTravel,
    141: _serverScripts_operators_141__WEBPACK_IMPORTED_MODULE_29__.YugoStar,
    142: _serverScripts_operators_142__WEBPACK_IMPORTED_MODULE_30__.MoreTravel,
    145: _serverScripts_operators_145__WEBPACK_IMPORTED_MODULE_31__.RozaVetrov,
    152: _serverScripts_operators_152__WEBPACK_IMPORTED_MODULE_32__.MeridianExpress,
    153: _serverScripts_operators_153__WEBPACK_IMPORTED_MODULE_33__.Delfin,
    155: _serverScripts_operators_155__WEBPACK_IMPORTED_MODULE_34__.BSI,
    156: _serverScripts_operators_156__WEBPACK_IMPORTED_MODULE_0__.Maldives,
    158: _serverScripts_operators_158__WEBPACK_IMPORTED_MODULE_35__.Solvex,
    160: _serverScripts_operators_160__WEBPACK_IMPORTED_MODULE_36__.Dsbw,
    162: _serverScripts_operators_162__WEBPACK_IMPORTED_MODULE_37__.ChinaTravel,
    165: _serverScripts_operators_165__WEBPACK_IMPORTED_MODULE_38__.Devisu,
    171: _serverScripts_operators_171__WEBPACK_IMPORTED_MODULE_39__.AmigoS,
    174: _serverScripts_operators_174__WEBPACK_IMPORTED_MODULE_40__.Capricorn,
    184: _serverScripts_operators_184__WEBPACK_IMPORTED_MODULE_41__.Interunion,
    191: _serverScripts_operators_sanatKz__WEBPACK_IMPORTED_MODULE_44__.SanatKz,
    194: _serverScripts_operators_kompasKz__WEBPACK_IMPORTED_MODULE_42__.KompasKz,
    199: _serverScripts_operators_evroport__WEBPACK_IMPORTED_MODULE_43__.Evroport,
    205: _serverScripts_operators_205__WEBPACK_IMPORTED_MODULE_45__.AmigoTours,
    213: _serverScripts_operators_213__WEBPACK_IMPORTED_MODULE_46__.Mouzenidis,
    219: _serverScripts_operators_219__WEBPACK_IMPORTED_MODULE_47__.SochiPlanet,
    229: _serverScripts_operators_229__WEBPACK_IMPORTED_MODULE_48__.TuiOld,
    231: _serverScripts_operators_231__WEBPACK_IMPORTED_MODULE_49__.MultiTour,
    237: _serverScripts_operators_237__WEBPACK_IMPORTED_MODULE_50__.DvmTour,
    238: _serverScripts_operators_238__WEBPACK_IMPORTED_MODULE_51__.RusTour,
    244: _serverScripts_operators_tariTour__WEBPACK_IMPORTED_MODULE_103__.TariTour,
    248: _serverScripts_operators_248__WEBPACK_IMPORTED_MODULE_52__.AvroraBg,
    252: _serverScripts_operators_252__WEBPACK_IMPORTED_MODULE_53__.Alean,
    260: _serverScripts_operators_260__WEBPACK_IMPORTED_MODULE_54__.Kandagar,
    269: _serverScripts_operators_269__WEBPACK_IMPORTED_MODULE_55__.NatalieTours,
    277: _serverScripts_operators_277__WEBPACK_IMPORTED_MODULE_56__.VremiaTour,
    280: _serverScripts_operators_280__WEBPACK_IMPORTED_MODULE_57__.GTV,
    282: _serverScripts_operators_282__WEBPACK_IMPORTED_MODULE_58__.Petropolitana,
    301: _serverScripts_operators_301__WEBPACK_IMPORTED_MODULE_59__.RobinsonTours,
    302: _serverScripts_operators_302__WEBPACK_IMPORTED_MODULE_60__.Premiera,
    304: _serverScripts_operators_304__WEBPACK_IMPORTED_MODULE_61__.GoodTimeTravel,
    309: _serverScripts_operators_309__WEBPACK_IMPORTED_MODULE_62__.Ivolga,
    311: _serverScripts_operators_311__WEBPACK_IMPORTED_MODULE_63__.Matreshka,
    315: _serverScripts_operators_315__WEBPACK_IMPORTED_MODULE_64__.Beleon,
    322: _serverScripts_operators_kazunion__WEBPACK_IMPORTED_MODULE_102__.Kazunion,
    331: _serverScripts_operators_331__WEBPACK_IMPORTED_MODULE_65__.Acti,
    343: _serverScripts_operators_343__WEBPACK_IMPORTED_MODULE_66__.PlanTravel1,
    344: _serverScripts_operators_344__WEBPACK_IMPORTED_MODULE_67__.Panteon,
    345: _serverScripts_operators_345__WEBPACK_IMPORTED_MODULE_68__.Vand,
    348: _serverScripts_operators_348__WEBPACK_IMPORTED_MODULE_69__.PlanTravel,
    361: _serverScripts_operators_361__WEBPACK_IMPORTED_MODULE_70__.SpaceTravel,
    378: _serverScripts_operators_378__WEBPACK_IMPORTED_MODULE_71__.PearlRiver,
    380: _serverScripts_operators_380__WEBPACK_IMPORTED_MODULE_72__.TUInew,
    382: _serverScripts_operators_382__WEBPACK_IMPORTED_MODULE_73__.SelfieTravel,
    392: _serverScripts_operators_392__WEBPACK_IMPORTED_MODULE_74__.Aerotour,
    415: _serverScripts_operators_415__WEBPACK_IMPORTED_MODULE_75__.Clickvoyage,
    429: _serverScripts_operators_429__WEBPACK_IMPORTED_MODULE_76__.RExpress,
    431: _serverScripts_operators_431__WEBPACK_IMPORTED_MODULE_77__.EliteTravel,
    432: _serverScripts_operators_432__WEBPACK_IMPORTED_MODULE_78__.Unicorn,
    439: _serverScripts_operators_439__WEBPACK_IMPORTED_MODULE_79__.Paks,
    449: _serverScripts_operators_449__WEBPACK_IMPORTED_MODULE_80__.OneTouchTravel,
    450: _serverScripts_operators_450__WEBPACK_IMPORTED_MODULE_81__.PegasTui,
    451: _serverScripts_operators_skanTour__WEBPACK_IMPORTED_MODULE_104__.SkanTour,
    452: _serverScripts_operators_452__WEBPACK_IMPORTED_MODULE_82__.D2,
    453: _serverScripts_operators_453__WEBPACK_IMPORTED_MODULE_83__.Veditour,
    454: _serverScripts_operators_454__WEBPACK_IMPORTED_MODULE_84__.IziTour,
    457: _serverScripts_operators_457__WEBPACK_IMPORTED_MODULE_85__.FunSunKz,
    521: _serverScripts_operators_vodohod__WEBPACK_IMPORTED_MODULE_105__.Vodohod,
    536: _serverScripts_operators_536__WEBPACK_IMPORTED_MODULE_86__.Krypton,
    544: _serverScripts_operators_544__WEBPACK_IMPORTED_MODULE_87__.CrimeanWave,
    560: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    564: _serverScripts_operators_564__WEBPACK_IMPORTED_MODULE_88__.RZHDTour,
    565: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    587: _serverScripts_operators_970__WEBPACK_IMPORTED_MODULE_89__.TourPlatforma,
    593: _serverScripts_operators_letsFly__WEBPACK_IMPORTED_MODULE_95__.LetsFly,
    620: _serverScripts_operators_unona__WEBPACK_IMPORTED_MODULE_108__.Unona,
    743: _serverScripts_operators_743__WEBPACK_IMPORTED_MODULE_90__.Loti,
    747: _serverScripts_operators_magput__WEBPACK_IMPORTED_MODULE_109__.MagPut,
    768: _serverScripts_operators_768__WEBPACK_IMPORTED_MODULE_91__.Mercury,
    797: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    800: _serverScripts_operators_800__WEBPACK_IMPORTED_MODULE_92__.MyAgent,
    820: _serverScripts_operators_rusExpress__WEBPACK_IMPORTED_MODULE_9__.RusExpress,
    803: _serverScripts_operators_letsFly__WEBPACK_IMPORTED_MODULE_95__.LetsFly,
    821: _serverScripts_operators_eskazan__WEBPACK_IMPORTED_MODULE_100__.EsKazan,
    857: _serverScripts_operators_iway__WEBPACK_IMPORTED_MODULE_93__.IWay,
    860: _serverScripts_operators_melinoTravel__WEBPACK_IMPORTED_MODULE_106__.MelinoTravel,
    861: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    897: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    917: _serverScripts_operators_inturist__WEBPACK_IMPORTED_MODULE_5__.Intourist,
    926: _serverScripts_operators_oneClickTravel__WEBPACK_IMPORTED_MODULE_101__.OneClickTravel,
    922: _serverScripts_operators_rivieraTour__WEBPACK_IMPORTED_MODULE_107__.RivieraTour,
    943: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_94__.TourClick,
    949: _serverScripts_operators_kazunion__WEBPACK_IMPORTED_MODULE_102__.Kazunion,
    970: _serverScripts_operators_970__WEBPACK_IMPORTED_MODULE_89__.TourPlatforma,
    2147483639: _serverScripts_operators_2147483639__WEBPACK_IMPORTED_MODULE_96__.CityTravel,
    2147483640: _serverScripts_operators_2147483640__WEBPACK_IMPORTED_MODULE_97__.AcademService,
    2147483641: _serverScripts_operators_2147483641__WEBPACK_IMPORTED_MODULE_98__.Bronevik,
    2147483642: _serverScripts_operators_7__WEBPACK_IMPORTED_MODULE_4__.BiblioGlobus,
    2147483643: _serverScripts_operators_252__WEBPACK_IMPORTED_MODULE_53__.Alean,
    2147483645: _serverScripts_operators_2147483645__WEBPACK_IMPORTED_MODULE_99__.Ostrovok,
    2147483646: _serverScripts_operators_800__WEBPACK_IMPORTED_MODULE_92__.MyAgent
};


/***/ }),

/***/ "./src/app/services/chunks/getAndSendSamoTONumber.ts":
/*!***********************************************************!*\
  !*** ./src/app/services/chunks/getAndSendSamoTONumber.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAndSendSamoTONumber: () => (/* binding */ getAndSendSamoTONumber)
/* harmony export */ });
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



function getAndSendSamoTONumber(tab, claimNumber) {
    return __awaiter(this, void 0, void 0, function* () {
        yield (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_0__.startTrackingElement)(tab, 'div#cl_refer span.claim');
        let response = yield (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_1__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'div#cl_refer span.claim', claimNumber);
        yield (0,_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
    });
}


/***/ }),

/***/ "./src/app/services/chunks/getFillerDataByClaimId.ts":
/*!***********************************************************!*\
  !*** ./src/app/services/chunks/getFillerDataByClaimId.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFillerDataByClaimId: () => (/* binding */ getFillerDataByClaimId)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils */ "./src/app/utils/index.ts");
/* harmony import */ var _utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../utils/chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");


function getFillerDataByClaimId(params) {
    return fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_1__.cbApiUrl}/AutoFillerApi/GetAutoFillerDataByToken?${(0,_utils__WEBPACK_IMPORTED_MODULE_0__.stringifyQsParams)(params)}`)
        .then(response => response.json());
    // .catch((err) => new Promise<ErrorResponse<{}>>(resolve => resolve({
    //     message: err.toString(),
    //     payload: {}
    // } as ErrorResponse<{}>)));
}


/***/ }),

/***/ "./src/app/services/chunks/sendIdAndAnotherIdToBookingCenter.ts":
/*!**********************************************************************!*\
  !*** ./src/app/services/chunks/sendIdAndAnotherIdToBookingCenter.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sendIdAndAnotherIdToBookingCenter: () => (/* binding */ sendIdAndAnotherIdToBookingCenter)
/* harmony export */ });
/* harmony import */ var _utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");

function sendIdAndAnotherIdToBookingCenter(claimId, tourOperatorClaimId, anotherTourOperatorClaimId, isConfirmed = false) {
    console.log(`sendIdAndAnotherIdToBookingCenter: claimId = ${claimId}, tourOperatorClaimId = ${tourOperatorClaimId}, cbApiUrl = ${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}`);
    return fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/private/toolbarapi/setTourOperatorClaimNumberAndAnotherTourOperatorNumber`, {
        method: 'post',
        headers: {
            'Content-type': 'application/json; charset=utf-8'
        },
        body: JSON.stringify({
            claimId,
            tourOperatorClaimId,
            anotherTourOperatorClaimId,
            isConfirmed
        })
    })
        .then((response) => response.status === 200
        ? 'Ids has been sent' : 'Fail')
        .catch((error) => error.message);
}


/***/ }),

/***/ "./src/app/services/chunks/sendIdsToBookingCenter.ts":
/*!***********************************************************!*\
  !*** ./src/app/services/chunks/sendIdsToBookingCenter.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sendIdsToBookingCenter: () => (/* binding */ sendIdsToBookingCenter)
/* harmony export */ });
/* harmony import */ var _utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../../utils/chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");

function sendIdsToBookingCenter(claimId, tourOperatorClaimId, isConfirmed = false) {
    console.log(`sendIdsToBookingCenter: claimId = ${claimId}, tourOperatorClaimId = ${tourOperatorClaimId}, cbApiUrl = ${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}`);
    return fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/private/toolbarapi/setTourOperatorClaimNumber`, {
        method: 'post',
        headers: {
            'Content-type': 'application/json; charset=utf-8'
        },
        body: JSON.stringify({
            claimId,
            tourOperatorClaimId,
            isConfirmed
        })
    })
        .then((response) => response.status === 200
        ? 'Ids has been sent' : 'Fail')
        .catch((error) => error.message);
}


/***/ }),

/***/ "./src/app/services/index.ts":
/*!***********************************!*\
  !*** ./src/app/services/index.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAuthLegalEntities: () => (/* binding */ getAuthLegalEntities),
/* harmony export */   getClaimRefundFileUrl: () => (/* binding */ getClaimRefundFileUrl),
/* harmony export */   getClaimRefundOperationDetails: () => (/* binding */ getClaimRefundOperationDetails),
/* harmony export */   getClaimTransferFileUrl: () => (/* binding */ getClaimTransferFileUrl),
/* harmony export */   getClaimTransferOperationDetails: () => (/* binding */ getClaimTransferOperationDetails),
/* harmony export */   getClaimUrl: () => (/* binding */ getClaimUrl),
/* harmony export */   "getOperatorLoginPathAndСredentials": () => (/* binding */ getOperatorLoginPathAndСredentials),
/* harmony export */   getSletatIdFromURL: () => (/* binding */ getSletatIdFromURL),
/* harmony export */   sendErrorReport: () => (/* binding */ sendErrorReport),
/* harmony export */   sendTourOperatorClaimDetailsToBookingCenter: () => (/* binding */ sendTourOperatorClaimDetailsToBookingCenter)
/* harmony export */ });
/* harmony import */ var _utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../utils/chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils */ "./src/app/utils/index.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");



function getClaimUrl(params) {
    return fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/AutoFillerApi/GetTourOperatorPathToClaimByToken?${(0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params)}`)
        .then(response => response.json());
}
const sendTourOperatorClaimDetailsToBookingCenter = (data) => {
    return new Promise((resolve) => {
        fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/private/toolbarapi/setTourOperatorClaimDetails`, {
            method: 'post',
            headers: {
                'Content-type': 'application/json; charset=utf-8'
            },
            body: JSON.stringify(data)
        }).then((response) => resolve(response.status === 200 ? _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.DONE : _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.FAIL));
    });
};
const sendErrorReport = (params) => new Promise((resolve, reject) => fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/AutoFillerApi/AutofillerErrorReport`, {
    method: 'post',
    headers: {
        'Content-type': 'application/json; charset=utf-8'
    },
    body: JSON.stringify(params)
}).then((response) => response.json().then((data) => resolve(data.Result))));
const getClaimTransferOperationDetails = (params) => new Promise((resolve, regect) => fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/AutoFillerApi/GetClaimTransferOperationDetails?${(0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params)}`).then((response) => response.json().then((data) => resolve(data.Result))));
const getClaimRefundOperationDetails = (params) => new Promise((resolve, reject) => fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/AutoFillerApi/GetClaimRefundOperationDetails?${(0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params)}`).then((response) => response.json().then(data => resolve(data.Result))));
const getAuthLegalEntities = () => new Promise((resolve, reject) => fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/AutoFillerApi/GetAutofillerAuthLegalEntities`).then((response) => response.json().then((data) => resolve(data.Result))));
// при авторизации вызывается первым
const getSletatIdFromURL = (params) => new Promise((resolve, reject) => fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/AutoFillerApi/GetAutofillSletatIdFromUrl?${(0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params)}`).then((response) => {
    if (!response.ok) {
        resolve({
            message: response.statusText,
            payload: {}
        });
    }
    response.json().then((data) => resolve(data.Result));
}));
// при авторизации вызывается вторым
const getOperatorLoginPathAndСredentials = (params) => new Promise((resolve, reject) => fetch(`${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/AutoFillerApi/GetOperatorLoginPathAndСredentials?${(0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params)}`).then((response) => {
    if (!response.ok) {
        resolve({
            message: response.statusText,
            payload: {}
        });
    }
    response.json().then((data) => resolve(data.Result));
}));
const getClaimTransferFileUrl = (transferId, template) => `${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/api/files/GetClaimTransferDocument?transferId=${transferId}&template=${template}`;
const getClaimRefundFileUrl = (refundId, template) => `${_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl}/api/files/GetClaimRefundDocument?refundId=${refundId}&template=${template}`;


/***/ }),

/***/ "./src/app/utils/chunks/checkCookieExistence.ts":
/*!******************************************************!*\
  !*** ./src/app/utils/chunks/checkCookieExistence.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkCookieExistence: () => (/* binding */ checkCookieExistence)
/* harmony export */ });
function checkCookieExistence(params) {
    return new Promise((resolve) => {
        chrome.cookies.get({ url: params.url, name: params.cookieName }, cookie => cookie && cookie.value && cookie.value !== ''
            ? resolve(cookie.value)
            : resolve(''));
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/common/clientUtils.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/common/clientUtils.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   wait: () => (/* binding */ wait)
/* harmony export */ });
// тут будут лежать полезные скрипты, которые нужно копировать при добавлении кода на сайте ТО
function getTouristAge(tourist) {
    const [day, month, year] = tourist.birthday.split('.');
    const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
    const ageDate = new Date(ageDiffMs);
    return ageDate.getUTCFullYear() - 1970;
}
function wait(timeout) {
    return new Promise((resolve) => {
        setTimeout(() => resolve(), timeout);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/common/emptyForNoDataAndOnes.ts":
/*!**************************************************************!*\
  !*** ./src/app/utils/chunks/common/emptyForNoDataAndOnes.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   emptyForNoDataAndOnes: () => (/* binding */ emptyForNoDataAndOnes),
/* harmony export */   isOnlyOneOrEmpty: () => (/* binding */ isOnlyOneOrEmpty)
/* harmony export */ });
/* harmony import */ var _passportFiledNames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./passportFiledNames */ "./src/app/utils/chunks/common/passportFiledNames.ts");

function isOnlyOneOrEmpty(str, charToSearch = '1') {
    if (!str || str === '') {
        return true;
    }
    str = str.replace(' ', '');
    for (var i = 0; i < str.length; i++) {
        if (str[i] !== charToSearch) {
            return false;
        }
    }
    return true;
}
function emptyForNoDataAndOnes(tourist) {
    if (!tourist) {
        return tourist;
    }
    Array.prototype.forEach.call(_passportFiledNames__WEBPACK_IMPORTED_MODULE_0__.PassportFieldNames, (field) => {
        if (tourist.isNoPassportData || isOnlyOneOrEmpty(tourist[field])) {
            tourist[field] = '';
        }
    });
    return tourist;
}


/***/ }),

/***/ "./src/app/utils/chunks/common/executeContentScript.ts":
/*!*************************************************************!*\
  !*** ./src/app/utils/chunks/common/executeContentScript.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeContentScript: () => (/* binding */ executeContentScript)
/* harmony export */ });
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../messages */ "./src/app/messages/index.ts");
/* harmony import */ var _sendTabMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");


function executeContentScript(tab, data) {
    (0,_sendTabMessage__WEBPACK_IMPORTED_MODULE_1__.sendTabMessage)(tab.id, (0,_messages__WEBPACK_IMPORTED_MODULE_0__.createExecuteContentScriptMessage)(data));
}


/***/ }),

/***/ "./src/app/utils/chunks/common/oneForNoData.ts":
/*!*****************************************************!*\
  !*** ./src/app/utils/chunks/common/oneForNoData.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   oneForNoData: () => (/* binding */ oneForNoData)
/* harmony export */ });
function oneForNoData(tourist) {
    if (tourist.IsNationalPassport || tourist.isNationalPassport) {
        tourist.passportSeries = tourist.isNoPassportData || !tourist.passportSeries || tourist.passportSeries === '' ? '1'.repeat(4) : tourist.passportSeries;
        tourist.passportNumber = tourist.isNoPassportData || !tourist.passportNumber || tourist.passportNumber === '' ? '1'.repeat(6) : tourist.passportNumber;
    }
    else {
        tourist.passportSeries = tourist.isNoPassportData || !tourist.passportSeries || tourist.passportSeries === '' ? '1'.repeat(2) : tourist.passportSeries;
        tourist.passportNumber = tourist.isNoPassportData || !tourist.passportNumber || tourist.passportNumber === '' ? '1'.repeat(7) : tourist.passportNumber;
    }
    return tourist;
}


/***/ }),

/***/ "./src/app/utils/chunks/common/orderedNumbersForNoData.ts":
/*!****************************************************************!*\
  !*** ./src/app/utils/chunks/common/orderedNumbersForNoData.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   rundomNumbersForNoData: () => (/* binding */ rundomNumbersForNoData)
/* harmony export */ });
/* harmony import */ var _emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./emptyForNoDataAndOnes */ "./src/app/utils/chunks/common/emptyForNoDataAndOnes.ts");

function rundomNumbersForNoData(tourist, touristIndex) {
    if (!tourist) {
        return tourist;
    }
    if (tourist.IsNationalPassport || tourist.isNationalPassport) {
        tourist.passportSeries = tourist.isNoPassportData || (0,_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_0__.isOnlyOneOrEmpty)(tourist.passportSeries) ? (touristIndex + 1).toString().repeat(4) : tourist.passportSeries;
        tourist.passportNumber = tourist.isNoPassportData || (0,_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_0__.isOnlyOneOrEmpty)(tourist.passportNumber) ? getRundomNumberString(6) : tourist.passportNumber;
    }
    else {
        tourist.passportSeries = tourist.isNoPassportData || (0,_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_0__.isOnlyOneOrEmpty)(tourist.passportSeries) ? (touristIndex + 1).toString().repeat(2) : tourist.passportSeries;
        tourist.passportNumber = tourist.isNoPassportData || (0,_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_0__.isOnlyOneOrEmpty)(tourist.passportNumber) ? getRundomNumberString(7) : tourist.passportNumber;
    }
    return tourist;
}
function getRundomNumberString(len) {
    var result = '';
    for (var i = 0; i < len; i++) {
        result += (Math.floor(Math.random() * 10)).toString();
    }
    return result;
}


/***/ }),

/***/ "./src/app/utils/chunks/common/passportFiledNames.ts":
/*!***********************************************************!*\
  !*** ./src/app/utils/chunks/common/passportFiledNames.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PassportFieldNames: () => (/* binding */ PassportFieldNames),
/* harmony export */   PassportNumberFileds: () => (/* binding */ PassportNumberFileds)
/* harmony export */ });
const PassportFieldNames = [
    'passportDate',
    'passportExpireDate',
    'passportIssueCode',
    'passportIssueOrg',
    'passportNumber',
    'passportSeries'
];
const PassportNumberFileds = [
    'passportNumber',
    'passportSeries'
];


/***/ }),

/***/ "./src/app/utils/chunks/constants_urls.ts":
/*!************************************************!*\
  !*** ./src/app/utils/chunks/constants_urls.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CB_CLAIM_FULL_PATH: () => (/* binding */ CB_CLAIM_FULL_PATH),
/* harmony export */   CB_CLAIM_ID_PARAM: () => (/* binding */ CB_CLAIM_ID_PARAM),
/* harmony export */   CB_CLAIM_PATH: () => (/* binding */ CB_CLAIM_PATH),
/* harmony export */   CB_HOSTS: () => (/* binding */ CB_HOSTS),
/* harmony export */   cbApiUrl: () => (/* binding */ cbApiUrl),
/* harmony export */   scriptsApiUrl: () => (/* binding */ scriptsApiUrl),
/* harmony export */   toNumberSaveUrl: () => (/* binding */ toNumberSaveUrl)
/* harmony export */ });
// const env: string = 'local';
// const env: string = 'dev';
const env = 'prod';
// local api: http://local-api-cbdebug.sletat.ru
// dev api: https://api-cbdebug.sletat.ru
// urls
const cbApiUrl = env === 'local' ?
    'http://localhost:8081' :
    env === 'dev' ?
        'https://api-cbdebug.sletat.ru' :
        'https://api-cb.global.sletat.ru';
const toNumberSaveUrl = cbApiUrl + '/private/toolbarapi/setTourOperatorClaimNumber';
// TODO: не забыть поменять обратно https://autofill-api.sletat.ru
const scriptsApiUrl = env === 'local' || env === 'dev' ?
    'https://autofill-api.global.sletat.ru' :
    'https://autofill-api.global.sletat.ru';
//https://autofill-api.sletat.ru;
// dev-api: cbdebug.sletat.ru
// local-api: local-booking.sletat.ru
// url parts
const CB_HOSTS = env === 'local' ?
    ['127.0.0.1:8080', 'local-booking.sletat.ru'] :
    env === 'dev' ?
        ['cbdebug.sletat.ru', 'cbdebug7.sletat.ru'] :
        ['cb.sletat.ru', 'cb-25.sletat.ru', 'cb-75.sletat.ru', 'cb-rsv.sletat.ru', 'cb.global.sletat.ru', 'cb-beta.global.sletat.ru'];
const CB_CLAIM_PATH = '/Claim';
const CB_CLAIM_FULL_PATH = '/Claim/Index';
const CB_CLAIM_ID_PARAM = 'claimId';


/***/ }),

/***/ "./src/app/utils/chunks/createPushNotification.ts":
/*!********************************************************!*\
  !*** ./src/app/utils/chunks/createPushNotification.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPushNotification: () => (/* binding */ createPushNotification)
/* harmony export */ });
/* harmony import */ var _models_chunks_createFillFnMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../models/chunks/createFillFnMessage */ "./src/app/models/chunks/createFillFnMessage.ts");
/* harmony import */ var _models_chunks_createSendIdsMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/chunks/createSendIdsMessage */ "./src/app/models/chunks/createSendIdsMessage.ts");


function createPushNotification(options) {
    let pushMessage = { title: '', body: { toString: () => '' } };
    switch (true) {
        case (options.hasOwnProperty('claimId')):
            const { claimId, operator, errorText } = options;
            pushMessage = (0,_models_chunks_createFillFnMessage__WEBPACK_IMPORTED_MODULE_0__.createFillFnMessage)({ claimId, operator, errorText });
            break;
        case (options.hasOwnProperty('status')):
            const { status, message } = options;
            pushMessage = (0,_models_chunks_createSendIdsMessage__WEBPACK_IMPORTED_MODULE_1__.createSendIdsMessage)({ status, message });
            break;
        case (options.hasOwnProperty('notificationMessage')):
            const { notificationMessage, title } = options;
            pushMessage.body = notificationMessage;
            pushMessage.title = title;
            pushMessage.toString = () => pushMessage.body.toString();
            break;
        default:
            break;
    }
    return new Promise((resolve, reject) => {
        chrome.notifications.create({ type: 'basic', iconUrl: 'icon.png', title: pushMessage.title, message: pushMessage.toString() }, () => resolve());
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/createTab.ts":
/*!*******************************************!*\
  !*** ./src/app/utils/chunks/createTab.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createNewTab: () => (/* binding */ createNewTab),
/* harmony export */   createTab: () => (/* binding */ createTab)
/* harmony export */ });
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
function createTab(_a) {
    return __awaiter(this, arguments, void 0, function* ({ active, url }) {
        var tabs = yield chrome.tabs.query({ active: true, lastFocusedWindow: true });
        const properties = {
            url: url,
            active: active,
            index: tabs && tabs.length >= 1
                ? tabs[0].index + 1
                : undefined
        };
        var tab = yield chrome.tabs.create(properties);
        return tab;
    });
}
function createNewTab(url) {
    return __awaiter(this, void 0, void 0, function* () {
        return createTab({
            active: true,
            url: url,
            windowId: chrome.windows.WINDOW_ID_CURRENT
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts":
/*!***********************************************************!*\
  !*** ./src/app/utils/chunks/executeLoginScriptInTabV3.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeLoginScriptInTabV3: () => (/* binding */ executeLoginScriptInTabV3)
/* harmony export */ });
/* harmony import */ var _executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _loginFormCode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./loginFormCode */ "./src/app/utils/chunks/loginFormCode.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function executeLoginScriptInTabV3(tab, selector) {
    return __awaiter(this, void 0, void 0, function* () {
        yield (0,_executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__.executeScriptInTabV3)(tab, _loginFormCode__WEBPACK_IMPORTED_MODULE_1__.getLoginFormCode, [selector]);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/executeReactLoginScriptInTabV3.ts":
/*!****************************************************************!*\
  !*** ./src/app/utils/chunks/executeReactLoginScriptInTabV3.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeReactLoginScriptInTabV3: () => (/* binding */ executeReactLoginScriptInTabV3)
/* harmony export */ });
/* harmony import */ var _executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _loginFormCodeReact__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./loginFormCodeReact */ "./src/app/utils/chunks/loginFormCodeReact.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function executeReactLoginScriptInTabV3(tab, selector) {
    return __awaiter(this, void 0, void 0, function* () {
        yield (0,_executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__.executeScriptInTabV3)(tab, _loginFormCodeReact__WEBPACK_IMPORTED_MODULE_1__.getReactLoginFormCode, [selector]);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/executeScript.ts":
/*!***********************************************!*\
  !*** ./src/app/utils/chunks/executeScript.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeScript: () => (/* binding */ executeScript)
/* harmony export */ });
function executeScript(frame, code) {
    return new Promise((resolve, reject) => {
        chrome.tabs.executeScript(frame.tabId, { frameId: frame.id, code }, (result) => {
            const message = JSON.parse(result[0]);
            if (message) {
                return reject(message);
            }
            return resolve();
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/executeScriptInTab.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/executeScriptInTab.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeScriptInTabV3: () => (/* binding */ executeScriptInTabV3),
/* harmony export */   injectFillScriptInTabAndRun: () => (/* binding */ injectFillScriptInTabAndRun)
/* harmony export */ });
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
function executeScriptInTabV3(tab, func, args) {
    return __awaiter(this, void 0, void 0, function* () {
        //await injectCoreFunctionsIntoPage(tab);
        let result = yield chrome.scripting.executeScript({
            target: { tabId: tab.id },
            func: func,
            args: args
        });
        return result[0];
    });
}
function injectFillScriptInTabAndRun(tab, fileName, param) {
    return __awaiter(this, void 0, void 0, function* () {
        // @ts-ignore
        yield executeScriptInTabV3(tab, (auto_context) => { auto_context_data = auto_context; }, [param]);
        yield chrome.scripting.executeScript({
            target: { tabId: tab.id, allFrames: false },
            files: [fileName],
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/getCurrentTabAsync.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/getCurrentTabAsync.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCurrentTabAsync: () => (/* binding */ getCurrentTabAsync)
/* harmony export */ });
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
function getCurrentTabAsync() {
    return __awaiter(this, void 0, void 0, function* () {
        var tabs = yield chrome.tabs.query({ active: true, lastFocusedWindow: true });
        return tabs[0];
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/loginFormCode.ts":
/*!***********************************************!*\
  !*** ./src/app/utils/chunks/loginFormCode.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getLoginFormCode: () => (/* binding */ getLoginFormCode)
/* harmony export */ });
function getLoginFormCode(pageSelectors) {
    try {
        debugger;
        console.log('getLoginFormCode');
        console.dir(pageSelectors);
        console.log(pageSelectors.packet.loginPath);
        console.log(pageSelectors.packet.passwordPath);
        console.log(pageSelectors.packet.submitPath);
        let login = document.querySelector(pageSelectors.packet.loginPath);
        let password = document.querySelector(pageSelectors.packet.passwordPath);
        let submit = document.querySelector(pageSelectors.packet.submitPath);
        console.log('getLoginFormCode 1');
        if (login !== null) {
            console.log('getLoginFormCode 2');
            login.dispatchEvent(new Event('focus'));
            login.value = `${pageSelectors.login}`;
            // on TUI site there's Knockout hook matching only on keypress event
            // so without this workaroud we couldn't post login value
            login.dispatchEvent(new Event('keypress', { bubbles: true }));
            login.dispatchEvent(new Event('input', { bubbles: true }));
            login.dispatchEvent(new Event('change', { bubbles: true }));
            login.dispatchEvent(new Event('blur', { bubbles: true }));
            password.dispatchEvent(new Event('focus', { bubbles: true }));
            password.value = `${pageSelectors.password}`;
            password.dispatchEvent(new Event('input', { bubbles: true }));
            password.dispatchEvent(new Event('keypress', { bubbles: true }));
            password.dispatchEvent(new Event('change', { bubbles: true }));
            password.dispatchEvent(new Event('blur', { bubbles: true }));
            setTimeout(function () { submit.click(); }, 500);
        }
    }
    catch (e) {
        console.warn(e);
    }
}


/***/ }),

/***/ "./src/app/utils/chunks/loginFormCodeReact.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/loginFormCodeReact.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getReactLoginFormCode: () => (/* binding */ getReactLoginFormCode),
/* harmony export */   loginFormCodeReact: () => (/* binding */ loginFormCodeReact)
/* harmony export */ });
const loginFormCodeReact = ({ login, password, packet: { loginPath, passwordPath, submitPath } }) => `
    try {

        function SetReactValue(selector, value) {
            const element = document.querySelector(selector);
    
            if(element){
                let uiEvents = document.createEvent('UIEvents');
                uiEvents.initEvent('focus', false, false);
                element.dispatchEvent(uiEvents);
    
                let setValue = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value').set;
                setValue.call(element, value);
                let e = new Event('input', { bubbles: true, cancelable: false });
                element.dispatchEvent(e);
    
                uiEvents = document.createEvent('UIEvents');
                uiEvents.initEvent('blur', false, false);
                element.dispatchEvent(uiEvents);
            }
        }

        if (!login && !password && !submit) {
            var login;
            var password;
            var submit;
        }

        login = "${loginPath.replace(/\\'/g, '\\\'')}";
        password = "${passwordPath.replace(/\'/g, '\\\'')}";
        submit = document.querySelector("${submitPath.replace(/\'/g, '\\\'')}");

        if (login !== null) {

            SetReactValue(login, '${login}');
            SetReactValue(password, '${password}');

            submit.click();
        }


    } catch (e) {
        JSON.stringify({error: e.stack});
    }
`;
function getReactLoginFormCode(pageSelectors) {
    debugger;
    function SetReactValue(selector, value) {
        const element = document.querySelector(selector);
        if (element) {
            let uiEvents = document.createEvent('UIEvents');
            uiEvents.initEvent('focus', false, false);
            element.dispatchEvent(uiEvents);
            let setValue = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value').set;
            setValue.call(element, value);
            let e = new Event('input', { bubbles: true, cancelable: false });
            element.dispatchEvent(e);
            uiEvents = document.createEvent('UIEvents');
            uiEvents.initEvent('blur', false, false);
            element.dispatchEvent(uiEvents);
        }
    }
    try {
        if (!login && !password && !submit) {
            var login;
            var password;
            var submit;
        }
        login = pageSelectors.packet.loginPath;
        password = pageSelectors.packet.passwordPath;
        submit = document.querySelector(pageSelectors.packet.submitPath);
        if (login !== null) {
            SetReactValue(login, pageSelectors.login);
            SetReactValue(password, pageSelectors.password);
            submit.click();
        }
    }
    catch (e) {
        JSON.stringify({ error: e.stack });
    }
}


/***/ }),

/***/ "./src/app/utils/chunks/moveEvoucherDataToCustomer.ts":
/*!************************************************************!*\
  !*** ./src/app/utils/chunks/moveEvoucherDataToCustomer.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   moveEvoucherDataToCustomer: () => (/* binding */ moveEvoucherDataToCustomer)
/* harmony export */ });
function moveEvoucherDataToCustomer(customer, data) {
    var _a;
    if (!customer || !data)
        return customer;
    customer.eVoucherClaimNumber = data.eVoucherClaimNumber;
    customer.eVoucherCurrency = data.eVoucherCurrency;
    customer.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
    try {
        // @ts-ignore
        (_a = data.autoFillerData.customer) === null || _a === void 0 ? void 0 : _a.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
    }
    catch (e) {
        console.log('moveEvoucherDataToCustomer');
        console.log(e);
        console.dir(e);
    }
    return customer;
}


/***/ }),

/***/ "./src/app/utils/chunks/navigateToClaimPageCustomeLoginCodeAndCompany.ts":
/*!*******************************************************************************!*\
  !*** ./src/app/utils/chunks/navigateToClaimPageCustomeLoginCodeAndCompany.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navigateToClaimPageCustomeLoginCodeAndCompany: () => (/* binding */ navigateToClaimPageCustomeLoginCodeAndCompany)
/* harmony export */ });
/* harmony import */ var _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _executeScript__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./executeScript */ "./src/app/utils/chunks/executeScript.ts");


function navigateToClaimPageCustomeLoginCodeAndCompany(tab, credentians, packet, customeLoginFormCode) {
    return new Promise((resolve, reject) => {
        function func(frame) {
            if (frame.tabId !== tab.id) {
                return;
            }
            chrome.webNavigation.onCompleted.removeListener(func);
            const code = customeLoginFormCode(new _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: credentians.login,
                packet: packet,
                password: credentians.password,
                company: credentians.company
            }));
            //console.log('loginFormCode');
            //console.log(code);
            (0,_executeScript__WEBPACK_IMPORTED_MODULE_1__.executeScript)(frame, code);
            return resolve(frame);
        }
        chrome.webNavigation.onCompleted.addListener(func);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/removeCookies.ts":
/*!***********************************************!*\
  !*** ./src/app/utils/chunks/removeCookies.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   removeCookies: () => (/* binding */ removeCookies),
/* harmony export */   removeCookiesCreateTabAndLogin: () => (/* binding */ removeCookiesCreateTabAndLogin),
/* harmony export */   removeCookiesForTouroperator: () => (/* binding */ removeCookiesForTouroperator)
/* harmony export */ });
/* harmony import */ var _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _createTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




function removeCookies(params) {
    return __awaiter(this, void 0, void 0, function* () {
        for (let cookieName of params.cookieNames) {
            yield chrome.cookies.remove({ url: params.url, name: cookieName });
        }
    });
}
function removeCookiesForTouroperator(operator) {
    return __awaiter(this, void 0, void 0, function* () {
        yield removeCookies({
            url: operator.link(),
            cookieNames: operator.cookie.auth
        });
    });
}
function removeCookiesCreateTabAndLogin(params) {
    return __awaiter(this, void 0, void 0, function* () {
        yield removeCookiesForTouroperator(params.operator);
        let tab = yield (0,_createTab__WEBPACK_IMPORTED_MODULE_1__.createTab)({
            active: true,
            url: params.newTabUrl
        });
        yield (0,_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, params.operator.packet.loginPath);
        yield (0,_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_2__.executeLoginScriptInTabV3)(tab, new _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
            login: params.login,
            password: params.password,
            packet: params.operator.packet
        }));
        return tab;
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/removeFromLocalStorage.ts":
/*!********************************************************!*\
  !*** ./src/app/utils/chunks/removeFromLocalStorage.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   removeFromLocalStorage: () => (/* binding */ removeFromLocalStorage)
/* harmony export */ });
const storage = chrome.storage.local;
function removeFromLocalStorage(key) {
    return new Promise((resolve, reject) => {
        storage.remove(key, () => {
            var error = chrome.runtime.lastError;
            if (error) {
                console.error(error);
            }
            resolve();
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/removeSamoPassportBlur.ts":
/*!********************************************************!*\
  !*** ./src/app/utils/chunks/removeSamoPassportBlur.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   removeSamoPassportBlur: () => (/* binding */ removeSamoPassportBlur)
/* harmony export */ });
/* harmony import */ var _executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function removeSamoPassportBlur(tab) {
    return __awaiter(this, void 0, void 0, function* () {
        yield (0,_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_1__.startTrackingElement)(tab, 'span.passport_data');
        yield (0,_executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__.executeScriptInTabV3)(tab, () => { document.querySelectorAll('span.passport_data').forEach((span) => { span.classList.remove('blur'); }); });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/sendTabMessage.ts":
/*!************************************************!*\
  !*** ./src/app/utils/chunks/sendTabMessage.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sendTabMessage: () => (/* binding */ sendTabMessage)
/* harmony export */ });
function sendTabMessage(tabId, message) {
    return new Promise((resolve, reject) => {
        chrome.tabs.sendMessage(tabId, message, (response) => {
            // console.log('RESPONSE TAB ', response);
            return resolve(response);
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/startTrackingElementInternal.ts":
/*!**************************************************************!*\
  !*** ./src/app/utils/chunks/startTrackingElementInternal.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   startTrackingElement: () => (/* binding */ startTrackingElement),
/* harmony export */   startTrackingElementDisappear: () => (/* binding */ startTrackingElementDisappear)
/* harmony export */ });
/* harmony import */ var _sendTabMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../messages */ "./src/app/messages/index.ts");


// грубо говоря эта функция ждет появления selector в tab-e
function startTrackingElement(tab, selector, frame, delay = 1000, maxWaitTime = 300000) {
    return startTrackingElementInternal(response => response.element, tab, selector, frame, delay, maxWaitTime);
}
function startTrackingElementDisappear(tab, selector, frame, delay = 1000, maxWaitTime = 300000) {
    return startTrackingElementInternal(response => !response.element, tab, selector, frame, delay, maxWaitTime);
}
const startTrackingElementInternal = (conditionFunc, tab, selector, frame, delay = 1000, maxWaitTime = 300000) => {
    return new Promise((resolve, reject) => {
        const curTime = Date.now();
        const timer = setInterval(() => {
            (0,_sendTabMessage__WEBPACK_IMPORTED_MODULE_0__.sendTabMessage)(tab.id, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetElementMessage)({ elementSelector: selector, frame: frame }))
                .then((response) => {
                if (response && conditionFunc(response)) {
                    clearInterval(timer);
                    resolve(response);
                }
                if (Date.now() - curTime >= maxWaitTime) {
                    clearInterval(timer);
                    reject(null);
                }
            });
        }, delay);
    });
};


/***/ }),

/***/ "./src/app/utils/chunks/trackingIdSelector.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/trackingIdSelector.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   startTrackingElementValue: () => (/* binding */ startTrackingElementValue),
/* harmony export */   startTrackingIdSelector: () => (/* binding */ startTrackingIdSelector),
/* harmony export */   startTrackingIdSelectorWithClaimNumberValidation: () => (/* binding */ startTrackingIdSelectorWithClaimNumberValidation)
/* harmony export */ });
/* harmony import */ var _messages_chunks_createGetIdsMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../messages/chunks/createGetIdsMessage */ "./src/app/messages/chunks/createGetIdsMessage.ts");
/* harmony import */ var _sendTabMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");


function startTrackingIdSelector(tab, idSelector, delay = 1000, timeLimit = 600000) {
    return trackingIdSelector(tab, (0,_messages_chunks_createGetIdsMessage__WEBPACK_IMPORTED_MODULE_0__.createGetIdsMessage)({ claimNo: idSelector }), delay, timeLimit);
}
function startTrackingIdSelectorWithClaimNumberValidation(tab, idSelector, claimNumber, delay = 1000, timeLimit = 600000) {
    let message = (0,_messages_chunks_createGetIdsMessage__WEBPACK_IMPORTED_MODULE_0__.createGetIdsMessage)({ claimNo: idSelector });
    message.payload.claimNumber = claimNumber;
    return trackingIdSelector(tab, message, delay, timeLimit, (response) => { return response && response.claimNo.length && response.claimNumber === claimNumber; });
}
function startTrackingElementValue(tab, idSelector, delay = 1000, timeLimit = 600000) {
    let message = (0,_messages_chunks_createGetIdsMessage__WEBPACK_IMPORTED_MODULE_0__.createGetIdsMessage)({ claimNo: idSelector });
    return trackingIdSelector(tab, message, delay, timeLimit, (response) => { return response && response.claimNoValue; });
}
function trackingIdSelector(tab, message, delay, timeLimit = 600000, resolveCondition = (response) => {
    return response && response.claimNo.length;
}) {
    return new Promise((resolve, reject) => {
        const curTime = Date.now();
        const timer = setInterval(() => {
            (0,_sendTabMessage__WEBPACK_IMPORTED_MODULE_1__.sendTabMessage)(tab.id, message)
                .then((response) => {
                // console.log('trackingIdSelector response');
                // console.dir(response);
                if (resolveCondition(response)) {
                    clearInterval(timer);
                    resolve(response);
                }
                if (Date.now() - curTime >= timeLimit && (!response || !response.claimNo.length)) {
                    clearInterval(timer);
                    reject('Time limit exeeded');
                }
            });
        }, delay);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/updateListener.ts":
/*!************************************************!*\
  !*** ./src/app/utils/chunks/updateListener.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   updateListener: () => (/* binding */ updateListener),
/* harmony export */   updateListenerOnSpecificNewPage: () => (/* binding */ updateListenerOnSpecificNewPage),
/* harmony export */   updateListenerOnSpecificPage: () => (/* binding */ updateListenerOnSpecificPage)
/* harmony export */ });
function updateListener(baseTabId, onUpdateFunc) {
    const updatedLiscener = (tabId, changeInfo, updatedTab) => {
        onUpdateFunc(tabId, changeInfo, updatedTab);
    };
    chrome.tabs.onUpdated.addListener(updatedLiscener);
    const removedLiscener = (tabId, removeInfo) => {
        if (tabId === baseTabId) {
            chrome.tabs.onUpdated.removeListener(updatedLiscener);
            chrome.tabs.onRemoved.removeListener(removedLiscener);
        }
    };
    chrome.tabs.onRemoved.addListener(removedLiscener);
}
function updateListenerOnSpecificPage(baseTabId, pageRegExp, onUpdateFunc) {
    const updatedLiscener = (tabId, changeInfo, updatedTab) => {
        console.log('updateListenerOnSpecificPage' + updatedTab.url);
        if (changeInfo.status && changeInfo.status.toLowerCase() === 'complete'
            && tabId === baseTabId
            && updatedTab.url
            && pageRegExp.test(updatedTab.url)) {
            if (onUpdateFunc(tabId, changeInfo, updatedTab) && chrome.tabs.onUpdated.hasListener(updatedLiscener)) {
                chrome.tabs.onUpdated.removeListener(updatedLiscener);
            }
        }
    };
    chrome.tabs.onUpdated.addListener(updatedLiscener);
    const removedLiscener = (tabId, removeInfo) => {
        if (tabId === baseTabId) {
            chrome.tabs.onUpdated.removeListener(updatedLiscener);
            chrome.tabs.onRemoved.removeListener(removedLiscener);
        }
    };
    chrome.tabs.onRemoved.addListener(removedLiscener);
}
function updateListenerOnSpecificNewPage(baseTabId, pageRegExp, onUpdateFunc) {
    const updatedLiscener = (tabId, changeInfo, updatedTab) => {
        console.log('updateListenerOnSpecificNewPage' + updatedTab.url);
        if (changeInfo.status && changeInfo.status.toLowerCase() === 'complete'
            && updatedTab.openerTabId
            && updatedTab.openerTabId == baseTabId
            && updatedTab.url
            && pageRegExp.test(updatedTab.url)) {
            if (onUpdateFunc(tabId, changeInfo, updatedTab) && chrome.tabs.onUpdated.hasListener(updatedLiscener)) {
                chrome.tabs.onUpdated.removeListener(updatedLiscener);
            }
        }
    };
    chrome.tabs.onUpdated.addListener(updatedLiscener);
    const removedLiscener = (tabId, removeInfo) => {
        if (tabId === baseTabId) {
            chrome.tabs.onUpdated.removeListener(updatedLiscener);
            chrome.tabs.onRemoved.removeListener(removedLiscener);
        }
    };
    chrome.tabs.onRemoved.addListener(removedLiscener);
}


/***/ }),

/***/ "./src/app/utils/constants.ts":
/*!************************************!*\
  !*** ./src/app/utils/constants.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RU_DOMISTIC_COUNTRIES: () => (/* binding */ RU_DOMISTIC_COUNTRIES),
/* harmony export */   claimAnotherTOAliasSelector: () => (/* binding */ claimAnotherTOAliasSelector),
/* harmony export */   claimIdTOSelector: () => (/* binding */ claimIdTOSelector),
/* harmony export */   claimMagnifierButtonStyles: () => (/* binding */ claimMagnifierButtonStyles),
/* harmony export */   claimMagnifierOperatorTypes: () => (/* binding */ claimMagnifierOperatorTypes),
/* harmony export */   claimNumberSelector: () => (/* binding */ claimNumberSelector),
/* harmony export */   claimRefundFillerOperators: () => (/* binding */ claimRefundFillerOperators),
/* harmony export */   claimSecretFieldAttr: () => (/* binding */ claimSecretFieldAttr),
/* harmony export */   claimSecretFieldId: () => (/* binding */ claimSecretFieldId),
/* harmony export */   claimTOAliasSelector: () => (/* binding */ claimTOAliasSelector),
/* harmony export */   claimTransferFillerOperators: () => (/* binding */ claimTransferFillerOperators),
/* harmony export */   fileHostName: () => (/* binding */ fileHostName),
/* harmony export */   loaderImageName: () => (/* binding */ loaderImageName),
/* harmony export */   mockPrevVisasData: () => (/* binding */ mockPrevVisasData),
/* harmony export */   myAgentTicketButtonOptions: () => (/* binding */ myAgentTicketButtonOptions),
/* harmony export */   myAgentTicketTransferButtonOptions: () => (/* binding */ myAgentTicketTransferButtonOptions),
/* harmony export */   refundPaymentTOButtonOptions: () => (/* binding */ refundPaymentTOButtonOptions),
/* harmony export */   sourceAutoFillAccomodationSelector: () => (/* binding */ sourceAutoFillAccomodationSelector),
/* harmony export */   sourceAutoFillAnotherSelector: () => (/* binding */ sourceAutoFillAnotherSelector),
/* harmony export */   sourceAutoFillFlightSelector: () => (/* binding */ sourceAutoFillFlightSelector),
/* harmony export */   sourceAutoFillSelector: () => (/* binding */ sourceAutoFillSelector),
/* harmony export */   sourceAutoFillerToken: () => (/* binding */ sourceAutoFillerToken),
/* harmony export */   sourceAutoFillerTokenAccomodation: () => (/* binding */ sourceAutoFillerTokenAccomodation),
/* harmony export */   sourceAutoFillerTokenAnother: () => (/* binding */ sourceAutoFillerTokenAnother),
/* harmony export */   sourceAutoFillerTokenFlight: () => (/* binding */ sourceAutoFillerTokenFlight),
/* harmony export */   sourceIdSelector: () => (/* binding */ sourceIdSelector),
/* harmony export */   transferPaymentTOButtonOptions: () => (/* binding */ transferPaymentTOButtonOptions)
/* harmony export */ });
const RU_DOMISTIC_COUNTRIES = 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия';
// selectors
const sourceAutoFillSelector = 'input[data-claim="autofill-data-touroperator"]';
const sourceAutoFillAnotherSelector = 'input[data-claim="autofill-data-another-touroperator"]';
const sourceAutoFillAccomodationSelector = 'input[data-claim="autofill-data-accomodation-touroperator"]';
const sourceAutoFillFlightSelector = 'input[data-claim="autofill-data-flight-touroperator"]';
const sourceAutoFillerToken = '#AutoFillerToken';
const sourceAutoFillerTokenAnother = '#AutoFillerTokenAnother';
const sourceAutoFillerTokenAccomodation = '#AutoFillerTokenAccomodation';
const sourceAutoFillerTokenFlight = '#AutoFillerTokenFlight';
const sourceIdSelector = '[data-claim-sourceid]';
const claimNumberSelector = '[data-claim-number]';
const claimIdTOSelector = '[data-claim-touroperatornumber]';
const claimSecretFieldId = '#AutoFillerToken';
const claimSecretFieldAttr = '[data-autofiller]';
const claimTOAliasSelector = '[data-claim-toalias]';
const claimAnotherTOAliasSelector = '[data-claim-anothertoalias]';
const loaderImageName = 'loader.gif';
//export const loaderImageName = 'loader-new_year.gif';
// loaders
const fileHostName = 'https://localhost:5555/api/visa-fill/version';
const mockPrevVisasData = [
    {
        countyName: 'Исландия',
        countryId: 0,
        validFrom: '03.02.2016',
        validTo: '04.02.2016',
        number: 'AAAA',
    },
    {
        countyName: 'Швеция',
        countryId: 0,
        validFrom: '03.02.2017',
        validTo: '04.02.2017',
        number: 'AAAA',
    }
];
const transferPaymentTOButtonOptions = {
    className: 'uk-button uk-button-minw-40',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Перейти на страницу оформления переноса',
};
const refundPaymentTOButtonOptions = {
    className: 'uk-button uk-button-minw-40',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Перейти на страницу оформления возврата',
};
const myAgentTicketButtonOptions = {
    className: 'uk-button uk-button-minw-40',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Купить билет на Мой Агент',
};
const myAgentTicketTransferButtonOptions = {
    className: 'uk-button uk-button-minw-40 myAgentTransfer',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Купить билет на Мой Агент',
};
const claimTransferFillerOperators = [9];
const claimRefundFillerOperators = [9];
//export const goToMyAgentOperators: number[] = [452];
// each operator now has several magnifier buttons with different behaviour
const claimMagnifierOperatorTypes = {
    3: ['default', 'reserve'],
    4: ['default'],
    6: ['default'],
    7: ['default'],
    9: ['default'],
    14: ['default'],
    19: ['default', 'reserve'],
    20: ['default'],
    38: ['default'],
    39: ['default'],
    41: ['default'],
    46: ['default'],
    49: ['default'],
    51: ['default'],
    53: ['default'],
    54: ['default'],
    78: ['default'],
    81: ['default'],
    83: ['default'],
    87: ['default'],
    93: ['default'],
    107: ['default'],
    108: ['default'],
    112: ['default'],
    113: ['default'],
    123: ['default'],
    125: ['default'],
    130: ['default'],
    131: ['default'],
    141: ['default'],
    153: ['default'],
    155: ['default'],
    158: ['default'],
    160: ['default'],
    165: ['default'],
    171: ['default'],
    184: ['default'],
    199: ['default'],
    205: ['default'],
    213: ['default'],
    214: ['default'],
    229: ['default'],
    231: ['default'],
    237: ['default'],
    238: ['default'],
    248: ['default'],
    252: ['default'],
    259: ['default'],
    260: ['default'],
    269: ['default'],
    277: ['default'],
    301: ['default'],
    302: ['default'],
    304: ['default'],
    306: ['default'],
    309: ['default'],
    311: ['default'],
    315: ['default'],
    331: ['default'],
    343: ['default'],
    344: ['default'],
    345: ['default'],
    348: ['default'],
    355: ['default'],
    361: ['default'],
    380: ['default'],
    431: ['default'],
};
// styles for each magnifier buttonType
const claimMagnifierButtonStyles = {
    'default': {
        id: 'autofill-goto-claim',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО',
        activeClass: 'orange',
    },
    'default-another': {
        id: 'autofill-goto-claim-another',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО (фактический)',
        activeClass: 'purple',
    },
    'default-acc': {
        id: 'autofill-goto-claim-accomodation',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО (проживание)',
        activeClass: 'green',
    },
    'default-flg': {
        id: 'autofill-goto-claim-flight',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО (перелет)',
        activeClass: 'yellow',
    },
    'reserve': {
        id: 'autofill-goto-claim',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на резервном сайте ТО',
        activeClass: 'blue',
    },
};


/***/ }),

/***/ "./src/app/utils/dom.ts":
/*!******************************!*\
  !*** ./src/app/utils/dom.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createElement: () => (/* binding */ createElement),
/* harmony export */   getClaimDataFields: () => (/* binding */ getClaimDataFields),
/* harmony export */   getTourOperatorClaimDataFields: () => (/* binding */ getTourOperatorClaimDataFields),
/* harmony export */   makeOperatorGoToMyAgentButton: () => (/* binding */ makeOperatorGoToMyAgentButton),
/* harmony export */   makeOperatorGoToMyAgentTransferButton: () => (/* binding */ makeOperatorGoToMyAgentTransferButton),
/* harmony export */   makeOperatorGoToPaymentRefundButton: () => (/* binding */ makeOperatorGoToPaymentRefundButton),
/* harmony export */   makeOperatorGoToPaymentTransferButton: () => (/* binding */ makeOperatorGoToPaymentTransferButton)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./src/app/utils/constants.ts");

function setElementProps(element, props) {
    Object.keys(props).forEach((key) => {
        element[key] = props[key];
        if (props[key] instanceof Object) {
            setElementProps(element[key], props[key]);
        }
    });
}
function createElement(tagName, options) {
    const element = document.createElement(tagName);
    if (options) {
        setElementProps(element, options);
    }
    return element;
}
function getClaimDataFields() {
    return {
        sourceId: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.sourceIdSelector),
        claimIdTO: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimIdTOSelector),
        claimNumber: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimNumberSelector),
        secretField: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimSecretFieldId + _constants__WEBPACK_IMPORTED_MODULE_0__.claimSecretFieldAttr),
        toAlias: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimTOAliasSelector),
        anotherToAlias: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimAnotherTOAliasSelector),
    };
}
function getTourOperatorClaimDataFields(sourceSelector, tokenSelector) {
    if (sourceSelector != undefined || sourceSelector != null) {
        return {
            claimData: document.querySelector(sourceSelector),
            secretField: document.querySelector(tokenSelector)
        };
    }
    return {};
}
const makeOperatorGoToPaymentTransferButton = () => {
    const button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.transferPaymentTOButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-arrow-right' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};
const makeOperatorGoToPaymentRefundButton = () => {
    const button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.refundPaymentTOButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-arrow-right' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};
const makeOperatorGoToMyAgentButton = () => {
    const button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.myAgentTicketButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-ticket' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};
const makeOperatorGoToMyAgentTransferButton = () => {
    const button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.myAgentTicketTransferButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-ticket' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};


/***/ }),

/***/ "./src/app/utils/fillCBLegalEntities.ts":
/*!**********************************************!*\
  !*** ./src/app/utils/fillCBLegalEntities.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillCBLegalEntities: () => (/* binding */ fillCBLegalEntities)
/* harmony export */ });
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");



const CbLeList = {
    aryld: {
        name: 'ООО «АРИЛЬД»',
        dirFullName: 'Князева Анна Андреевна',
        legalAddress: '197198, г. Санкт-Петербург, ул. Кирочная, д. 9 литера А, помещение 3-Н',
        postAddress: '197198, г. Санкт-Петербург, ул. Кирочная, д. 9 литера А, помещение 3-Н',
        phone: '+7 981 131 71 05',
        ogrn: '1187847239678',
        inn: '7841076829',
        kpp: '784101001',
        rs: '40702810701460009067',
        buk: '044525297',
        ks: '30101810945250000297',
        baseOn: 'устава'
    },
    ocb: {
        name: 'ООО «ОЦБ»',
        dirFullName: 'Поплавская Евгения Вячеславовна',
        legalAddress: '195112, г. Санкт-Петербург, пл. Карла Фаберже, д.8, Литер Б, офис 710',
        postAddress: '195112, г. Санкт-Петербург, пл. Карла Фаберже, д.8, Литер Б, офис 710',
        phone: '8 (812) 309-26-66 , 8-981-820-10-86',
        ogrn: '1167847394758',
        inn: '7806253031',
        kpp: '780601001',
        rs: '40702810101460008891',
        buk: '044525297',
        ks: '30101810945250000297',
        baseOn: 'устава'
    },
    msy: {
        name: 'ООО «МСУ Тех»',
        dirFullName: 'Вершинин Андрей Михайлович',
        legalAddress: '195112, г. Санкт-Петербург, пл. Карла Фаберже, д.8, Литер Б, офис 708',
        postAddress: '195112, г. Санкт-Петербург, пл. Карла Фаберже, д.8, Литер Б, офис 708',
        phone: '8 (812) 309-26- 66, +7-996-788-36-27',
        ogrn: '1089848041580',
        inn: '7801483715',
        kpp: '780601001',
        rs: '40702810932310000447',
        buk: '044030786',
        ks: '30101810600000000786',
        baseOn: 'устава'
    }
};
function fillCBLegalEntities(info) {
    return Promise.resolve()
        .then(() => new Promise((resolve) => {
        chrome.tabs.query({ active: true, lastFocusedWindow: true }, (tabs) => {
            resolve(tabs[0]);
        });
    }))
        .then(tab => (0,_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTabV3)(tab, requestFiller, [CbLeList[info.cbLe]]))
        .catch((error) => (0,_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_1__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatus.FAIL, message: error.message }));
}
function requestFiller(cbLe) {
    function handleLeFields(leFields) {
        leFields.forEach(leField => {
            const element = document.querySelector(leField.htmlElementSelector);
            if (element && leField.value) {
                element.value = leField.value;
                element.dispatchEvent(new FocusEvent("focus", { bubbles: true }));
                element.dispatchEvent(new InputEvent("input", { bubbles: true }));
                element.dispatchEvent(new InputEvent("keyup", { bubbles: true }));
                element.dispatchEvent(new Event("change", { bubbles: true }));
            }
        });
    }
    function doFill(cbLe) {
        const leFields = [{
                htmlElementSelector: 'input[name=orgName]',
                value: cbLe.name
            }, {
                htmlElementSelector: 'input[name=org_director]',
                value: cbLe.dirFullName
            }, {
                htmlElementSelector: 'input[name=jurAddress]',
                value: cbLe.legalAddress
            }, {
                htmlElementSelector: 'input[name=postalAddress]',
                value: cbLe.postAddress
            }, {
                htmlElementSelector: 'input[name=agPhone]',
                value: cbLe.phone
            }, {
                htmlElementSelector: 'input[name=agOgrn]',
                value: cbLe.ogrn
            }, {
                htmlElementSelector: 'input[name=agInn]',
                value: cbLe.inn
            }, {
                htmlElementSelector: 'input[name=agKPP]',
                value: cbLe.kpp
            }, {
                htmlElementSelector: 'input[name=agRS]',
                value: cbLe.rs
            }, {
                htmlElementSelector: 'input[name=agBIK]',
                value: cbLe.buk
            }, {
                htmlElementSelector: 'input[name=agKS]',
                value: cbLe.ks
            }, {
                htmlElementSelector: 'input[name=doverforsign]',
                value: cbLe.baseOn
            }];
        handleLeFields(leFields);
    }
    doFill(cbLe);
}


/***/ }),

/***/ "./src/app/utils/index.ts":
/*!********************************!*\
  !*** ./src/app/utils/index.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addMessageListener: () => (/* reexport safe */ _messages__WEBPACK_IMPORTED_MODULE_3__.addMessageListener),
/* harmony export */   createElement: () => (/* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_2__.createElement),
/* harmony export */   detectSender: () => (/* reexport safe */ _messages__WEBPACK_IMPORTED_MODULE_3__.detectSender),
/* harmony export */   getClaimDataFields: () => (/* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_2__.getClaimDataFields),
/* harmony export */   getCurrentTab: () => (/* reexport safe */ _tabs__WEBPACK_IMPORTED_MODULE_1__.getCurrentTab),
/* harmony export */   getTourOperatorClaimDataFields: () => (/* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_2__.getTourOperatorClaimDataFields),
/* harmony export */   sendMessage: () => (/* reexport safe */ _messages__WEBPACK_IMPORTED_MODULE_3__.sendMessage),
/* harmony export */   startTrackingElementInCurTab: () => (/* binding */ startTrackingElementInCurTab),
/* harmony export */   stringifyQsParams: () => (/* reexport safe */ _url__WEBPACK_IMPORTED_MODULE_0__.stringifyQsParams),
/* harmony export */   waitForDocumentReady: () => (/* binding */ waitForDocumentReady)
/* harmony export */ });
/* harmony import */ var _url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./url */ "./src/app/utils/url.ts");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dom */ "./src/app/utils/dom.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./messages */ "./src/app/utils/messages.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../messages */ "./src/app/messages/index.ts");
/* harmony import */ var _chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./chunks/sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







function waitForDocumentReady(tab, delay = 1000) {
    return new Promise((resolve, reject) => {
        function func() {
            chrome.webNavigation.onDOMContentLoaded.removeListener(func);
            resolve();
        }
        chrome.webNavigation.onDOMContentLoaded.addListener(func);
    });
}
function startTrackingElementInCurTab(selector, delay = 1000) {
    return new Promise((resolve, reject) => {
        const curTime = Date.now();
        const timer = setInterval(() => __awaiter(this, void 0, void 0, function* () {
            const tab = yield (0,_tabs__WEBPACK_IMPORTED_MODULE_1__.getCurrentTab)();
            (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_5__.sendTabMessage)(tab.id, (0,_messages__WEBPACK_IMPORTED_MODULE_4__.createGetElementMessage)({ elementSelector: selector }))
                .then((response) => {
                if (response && response.element) {
                    clearInterval(timer);
                    resolve(tab);
                }
                if (Date.now() - curTime >= 300000 && !response.element) {
                    clearInterval(timer);
                    reject('Time limit exeeded');
                }
            });
        }), delay);
    });
}


/***/ }),

/***/ "./src/app/utils/messages.ts":
/*!***********************************!*\
  !*** ./src/app/utils/messages.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addMessageListener: () => (/* binding */ addMessageListener),
/* harmony export */   detectSender: () => (/* binding */ detectSender),
/* harmony export */   requestOnClaimPageLogin: () => (/* binding */ requestOnClaimPageLogin),
/* harmony export */   requestSearchForm: () => (/* binding */ requestSearchForm),
/* harmony export */   requestToursitLinks: () => (/* binding */ requestToursitLinks),
/* harmony export */   sendMessage: () => (/* binding */ sendMessage)
/* harmony export */ });
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models */ "./src/app/models/index.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../messages */ "./src/app/messages/index.ts");
/* harmony import */ var _chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./chunks/sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



function addMessageListener(listener) {
    chrome.runtime.onMessage.addListener(listener);
    return () => {
        chrome.runtime.onMessage.removeListener(listener);
    };
}
function sendMessage(message) {
    return new Promise((resolve, reject) => {
        chrome.runtime.sendMessage(message, (response) => resolve(response));
    });
}
function detectSender(sender) {
    const { url } = sender;
    if (url.indexOf('chrome-extension') > -1) {
        return _models__WEBPACK_IMPORTED_MODULE_0__.SenderTypes.EXT_SENDER;
    }
    return _models__WEBPACK_IMPORTED_MODULE_0__.SenderTypes.TAB_SENDER;
}
function requestOnClaimPageLogin(tabId, params, delay = 1000) {
    return new Promise((resolve, reject) => {
        const curTime = Date.now();
        const timer = setInterval(() => {
            (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__.sendTabMessage)(tabId, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetPageLoginFormMessage)(params))
                .then((response) => {
                if (response.loginForm !== null) {
                    clearInterval(timer);
                    resolve({ needToLogin: true });
                }
                if (Date.now() - curTime >= 5000 && !response.loginForm) {
                    clearInterval(timer);
                    resolve({ needToLogin: false });
                }
            });
        }, delay);
    });
}
function requestSearchForm(tabId, params, delay = 1000) {
    return new Promise((resolve, reject) => {
        const timer = setInterval(() => __awaiter(this, void 0, void 0, function* () {
            try {
                const message = yield (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__.sendTabMessage)(tabId, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetPageSearchFormMessage)(params));
                if (message && message.queryInput !== null) {
                    clearInterval(timer);
                    resolve();
                }
                else {
                    clearInterval(timer);
                    reject();
                }
            }
            catch (e) {
                clearInterval(timer);
                reject();
            }
        }), delay);
    });
}
function requestToursitLinks(tabId, params, delay = 1000) {
    return new Promise((resolve, reject) => {
        const curTime = Date.now();
        const timer = setInterval(() => {
            (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__.sendTabMessage)(tabId, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetTouristLinksMessage)(params))
                .then((response) => {
                if (response.links.length) {
                    clearInterval(timer);
                    resolve(response);
                }
                if (Date.now() - curTime >= 10000 && !response.links.length) {
                    clearInterval(timer);
                    reject('Time limit exeeded');
                }
            });
        }, delay);
    });
}


/***/ }),

/***/ "./src/app/utils/navToBookedClaim.ts":
/*!*******************************************!*\
  !*** ./src/app/utils/navToBookedClaim.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navigateToBookedClaim: () => (/* binding */ navigateToBookedClaim)
/* harmony export */ });
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_3 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_3.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_4 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_4.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_6__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_6 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_6.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_7__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_7 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_7.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_14__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_14 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_14.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_19__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_19 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_19.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_20__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_20 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_20.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_51__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_51 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_51.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_54__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_54 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_54.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_81__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_81 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_81.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_83__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_83 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_83.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_112__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_112 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_112.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_113__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_113 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_113.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_153__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_153 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_153.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_171__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_171 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_171.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_kompasKz__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_kompasKz */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_kompasKz.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_sanatKz__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_sanatKz */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_sanatKz.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_205__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_205 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_205.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_231__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_231 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_231.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_252__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_252 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_252.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_302__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_302 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_302.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_343__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_343 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_343.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_344__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_344 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_344.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_361__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_361 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_361.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_380__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_380 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_380.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_382__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_382 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_382.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_429__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_429 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_429.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_439__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_439 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_439.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_449__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_449 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_449.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_452__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_452 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_452.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_454__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_454 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_454.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_457__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_457 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_457.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_743__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_743 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_743.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_768__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_768 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_768.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_820__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_820 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_820.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_melinoTravel__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_melinoTravel */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_melinoTravel.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_iway__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_iway */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_iway.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_tourplatform_samo__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_tourplatform_samo */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_tourplatform_samo.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_evroport__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_evroport */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_evroport.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_intourist__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_intourist */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_intourist.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_letsFly__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_letsFly */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_letsFly.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_oneClickTravel__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_oneClickTravel */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_oneClickTravel.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_kazunion__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_kazunion */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_kazunion.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483634__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_2147483634 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483634.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_19_samo__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_19_samo */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_19_samo.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483639__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_2147483639 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483639.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483640__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_2147483640 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483640.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483641__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_2147483641 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483641.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483645__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_2147483645 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483645.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_800__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./../../serverScripts/navToBookedClaim/navToBookedClaim_800 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_800.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

























































function navigateToBookedClaim(_a, Creditans_1) {
    return __awaiter(this, arguments, void 0, function* ({ tourUrl, claimId, sourceId, claimNumber, secretField }, Creditans) {
        const navToBookedClaiArgs = {
            credentials: Creditans,
            tourUrl: tourUrl,
            secretField: secretField,
            claimNumber: claimNumber,
            sourceId: sourceId,
            claimId: claimId
        };
        switch (sourceId) {
            case 3: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_3__WEBPACK_IMPORTED_MODULE_0__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 4: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_4__WEBPACK_IMPORTED_MODULE_1__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 6: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_6__WEBPACK_IMPORTED_MODULE_2__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 7: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_7__WEBPACK_IMPORTED_MODULE_3__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 14: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_14__WEBPACK_IMPORTED_MODULE_4__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 19: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_19__WEBPACK_IMPORTED_MODULE_5__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 20: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_20__WEBPACK_IMPORTED_MODULE_6__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 51: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_51__WEBPACK_IMPORTED_MODULE_7__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 54: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_54__WEBPACK_IMPORTED_MODULE_8__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 81: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_81__WEBPACK_IMPORTED_MODULE_9__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 83: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_83__WEBPACK_IMPORTED_MODULE_10__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 112: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_112__WEBPACK_IMPORTED_MODULE_11__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 113: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_113__WEBPACK_IMPORTED_MODULE_12__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 153: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_153__WEBPACK_IMPORTED_MODULE_13__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 171: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_171__WEBPACK_IMPORTED_MODULE_14__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 191: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_sanatKz__WEBPACK_IMPORTED_MODULE_16__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 194: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_kompasKz__WEBPACK_IMPORTED_MODULE_15__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 199: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_evroport__WEBPACK_IMPORTED_MODULE_38__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 205: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_205__WEBPACK_IMPORTED_MODULE_17__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 231: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_231__WEBPACK_IMPORTED_MODULE_18__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 252: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_252__WEBPACK_IMPORTED_MODULE_19__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 302: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_302__WEBPACK_IMPORTED_MODULE_20__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 322: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_kazunion__WEBPACK_IMPORTED_MODULE_42__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 343: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_343__WEBPACK_IMPORTED_MODULE_21__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 344: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_344__WEBPACK_IMPORTED_MODULE_22__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 361: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_361__WEBPACK_IMPORTED_MODULE_23__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 380: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_380__WEBPACK_IMPORTED_MODULE_24__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 382: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_382__WEBPACK_IMPORTED_MODULE_25__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 429: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_429__WEBPACK_IMPORTED_MODULE_26__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 439: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_439__WEBPACK_IMPORTED_MODULE_27__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 449: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_449__WEBPACK_IMPORTED_MODULE_28__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 452: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_452__WEBPACK_IMPORTED_MODULE_29__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 454: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_454__WEBPACK_IMPORTED_MODULE_30__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 457: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_457__WEBPACK_IMPORTED_MODULE_31__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 743: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_743__WEBPACK_IMPORTED_MODULE_32__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 768: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_768__WEBPACK_IMPORTED_MODULE_33__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 803: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_letsFly__WEBPACK_IMPORTED_MODULE_40__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 820: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_820__WEBPACK_IMPORTED_MODULE_34__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 857: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_iway__WEBPACK_IMPORTED_MODULE_36__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 860: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_melinoTravel__WEBPACK_IMPORTED_MODULE_35__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 917: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_intourist__WEBPACK_IMPORTED_MODULE_39__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 926: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_oneClickTravel__WEBPACK_IMPORTED_MODULE_41__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 949: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_kazunion__WEBPACK_IMPORTED_MODULE_42__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 970: {
                yield (0,_serverScripts_navToBookedClaim_navToBookedClaim_tourplatform_samo__WEBPACK_IMPORTED_MODULE_37__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483629: {
                navToBookedClaiArgs.credentials.login = 'api_LT';
                navToBookedClaiArgs.credentials.password = '7ul86o4n';
                navToBookedClaiArgs.tourUrl = 'https://searchtour.intourist.ru/cl_refer?CLAIM={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_intourist__WEBPACK_IMPORTED_MODULE_39__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483630: {
                navToBookedClaiArgs.credentials.login = 'mgt@corp';
                navToBookedClaiArgs.credentials.password = '9q|W[Hx2';
                navToBookedClaiArgs.tourUrl = 'https://b2b.onetouch.travel/cl_refer?CLAIM={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_449__WEBPACK_IMPORTED_MODULE_28__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483632: {
                navToBookedClaiArgs.credentials.login = 'gortr';
                navToBookedClaiArgs.credentials.password = 'd1v1h3';
                navToBookedClaiArgs.tourUrl = 'https://online.r-express.ru/cl_refer?CLAIM={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_820__WEBPACK_IMPORTED_MODULE_34__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483633: {
                navToBookedClaiArgs.credentials.login = 'LetsflyOnline_api';
                navToBookedClaiArgs.credentials.password = 'qwx0hwBw-';
                navToBookedClaiArgs.tourUrl = 'https://samo.sletat.ru/cl_refer?CLAIM={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_letsFly__WEBPACK_IMPORTED_MODULE_40__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483634: {
                navToBookedClaiArgs.credentials.login = 'sletatdt';
                navToBookedClaiArgs.credentials.password = 'T#-uI35_17ez0cz';
                navToBookedClaiArgs.tourUrl = 'https://www.russeas.ru/requests?nrequest={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483634__WEBPACK_IMPORTED_MODULE_43__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483635: {
                navToBookedClaiArgs.credentials.login = 'api_LT';
                navToBookedClaiArgs.credentials.password = 'S1vrX5sN';
                navToBookedClaiArgs.tourUrl = 'https://samo.anextour.ru/cl_refer?CLAIM={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_19_samo__WEBPACK_IMPORTED_MODULE_44__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483636: {
                navToBookedClaiArgs.credentials.login = 'sletatdt';
                navToBookedClaiArgs.credentials.password = 'QL622VLt';
                navToBookedClaiArgs.tourUrl = 'https://b2b.fstravel.com/cl_refer?CLAIM={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_380__WEBPACK_IMPORTED_MODULE_24__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483639: {
                navToBookedClaiArgs.credentials.login = 'sletatdt@sletat.ru';
                navToBookedClaiArgs.credentials.password = 'Sletat2022';
                navToBookedClaiArgs.tourUrl = 'https://city.travel/user/orders?bookid={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483639__WEBPACK_IMPORTED_MODULE_45__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483640: {
                navToBookedClaiArgs.credentials.company = 'GORTRAVEL';
                navToBookedClaiArgs.credentials.login = 'roman';
                navToBookedClaiArgs.credentials.password = '111111';
                navToBookedClaiArgs.tourUrl = 'https://b2b.acase.ru/order/{0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483640__WEBPACK_IMPORTED_MODULE_46__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483641: {
                navToBookedClaiArgs.credentials.login = 'r.shvets';
                navToBookedClaiArgs.credentials.password = 'zM3PsU8';
                navToBookedClaiArgs.tourUrl = 'https://bronevik.com/ru/client/view.php?claim={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483641__WEBPACK_IMPORTED_MODULE_47__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483642: {
                navToBookedClaiArgs.credentials.login = 'gortr';
                navToBookedClaiArgs.credentials.password = 'Nv7N3-*tOQQatN6vh';
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_7__WEBPACK_IMPORTED_MODULE_3__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483643: {
                navToBookedClaiArgs.credentials.login = 'mgt@cb.sletat.ru';
                navToBookedClaiArgs.credentials.password = 'mgt@cb.sletat.ru';
                navToBookedClaiArgs.tourUrl = 'https://www.alean.ru/agency/cabinet/#!/orderbook/{0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_252__WEBPACK_IMPORTED_MODULE_19__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483645: {
                navToBookedClaiArgs.credentials.login = 'sletatdt@sletat.ru';
                navToBookedClaiArgs.credentials.password = 'Sletat2022.//';
                navToBookedClaiArgs.tourUrl = 'https://b2b.ostrovok.ru/my/orders/?order_id={0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483645__WEBPACK_IMPORTED_MODULE_48__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            case 2147483646: {
                navToBookedClaiArgs.credentials.login = 'sletatdt@sletat.ru';
                navToBookedClaiArgs.credentials.password = 'LewCwp7ef8';
                navToBookedClaiArgs.tourUrl = 'https://simpleconnect.online/#/avia/order/{0}'.replace('{0}', claimId);
                (0,_serverScripts_navToBookedClaim_navToBookedClaim_800__WEBPACK_IMPORTED_MODULE_49__.navToBookedClaim)(navToBookedClaiArgs);
                break;
            }
            default:
                console.warn(`Для ${sourceId} navToBookedClaim не нашелся`);
                break;
        }
    });
}


/***/ }),

/***/ "./src/app/utils/navigateToFormFill.ts":
/*!*********************************************!*\
  !*** ./src/app/utils/navigateToFormFill.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navigateToFormFill: () => (/* binding */ navigateToFormFill)
/* harmony export */ });
/* harmony import */ var _chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");
/* harmony import */ var _serverScripts_formFill_formFill_3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_3 */ "./src/serverScripts/formFill/formFill_3.ts");
/* harmony import */ var _serverScripts_formFill_formFill_4__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_4 */ "./src/serverScripts/formFill/formFill_4.ts");
/* harmony import */ var _serverScripts_formFill_formFill_6__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_6 */ "./src/serverScripts/formFill/formFill_6.ts");
/* harmony import */ var _serverScripts_formFill_formFill_7__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_7 */ "./src/serverScripts/formFill/formFill_7.ts");
/* harmony import */ var _serverScripts_formFill_formFill_14__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_14 */ "./src/serverScripts/formFill/formFill_14.ts");
/* harmony import */ var _serverScripts_formFill_formFill_19__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_19 */ "./src/serverScripts/formFill/formFill_19.ts");
/* harmony import */ var _serverScripts_formFill_formFill_20__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_20 */ "./src/serverScripts/formFill/formFill_20.ts");
/* harmony import */ var _serverScripts_formFill_formFill_51__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_51 */ "./src/serverScripts/formFill/formFill_51.ts");
/* harmony import */ var _serverScripts_formFill_formFill_54__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_54 */ "./src/serverScripts/formFill/formFill_54.ts");
/* harmony import */ var _serverScripts_formFill_formFill_81__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_81 */ "./src/serverScripts/formFill/formFill_81.ts");
/* harmony import */ var _serverScripts_formFill_formFill_artTour__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_artTour */ "./src/serverScripts/formFill/formFill_artTour.ts");
/* harmony import */ var _serverScripts_formFill_formFill_112__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_112 */ "./src/serverScripts/formFill/formFill_112.ts");
/* harmony import */ var _serverScripts_formFill_formFill_113__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_113 */ "./src/serverScripts/formFill/formFill_113.ts");
/* harmony import */ var _serverScripts_formFill_formFill_153__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_153 */ "./src/serverScripts/formFill/formFill_153.ts");
/* harmony import */ var _serverScripts_formFill_formFill_171__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_171 */ "./src/serverScripts/formFill/formFill_171.ts");
/* harmony import */ var _serverScripts_formFill_formFill_kompasKz__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_kompasKz */ "./src/serverScripts/formFill/formFill_kompasKz.ts");
/* harmony import */ var _serverScripts_formFill_formFill_sanatKz__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_sanatKz */ "./src/serverScripts/formFill/formFill_sanatKz.ts");
/* harmony import */ var _serverScripts_formFill_formFill_205__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_205 */ "./src/serverScripts/formFill/formFill_205.ts");
/* harmony import */ var _serverScripts_formFill_formFill_231__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_231 */ "./src/serverScripts/formFill/formFill_231.ts");
/* harmony import */ var _serverScripts_formFill_formFill_252__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_252 */ "./src/serverScripts/formFill/formFill_252.ts");
/* harmony import */ var _serverScripts_formFill_formFill_302__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_302 */ "./src/serverScripts/formFill/formFill_302.ts");
/* harmony import */ var _serverScripts_formFill_formFill_plantravel_canary__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_plantravel_canary */ "./src/serverScripts/formFill/formFill_plantravel_canary.ts");
/* harmony import */ var _serverScripts_formFill_formFill_344__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_344 */ "./src/serverScripts/formFill/formFill_344.ts");
/* harmony import */ var _serverScripts_formFill_formFill_spaceTravel__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_spaceTravel */ "./src/serverScripts/formFill/formFill_spaceTravel.ts");
/* harmony import */ var _serverScripts_formFill_formFill_380__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_380 */ "./src/serverScripts/formFill/formFill_380.ts");
/* harmony import */ var _serverScripts_formFill_formFill_382__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_382 */ "./src/serverScripts/formFill/formFill_382.ts");
/* harmony import */ var _serverScripts_formFill_formFill_439__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_439 */ "./src/serverScripts/formFill/formFill_439.ts");
/* harmony import */ var _serverScripts_formFill_formFill_449__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_449 */ "./src/serverScripts/formFill/formFill_449.ts");
/* harmony import */ var _serverScripts_formFill_formFill_452__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_452 */ "./src/serverScripts/formFill/formFill_452.ts");
/* harmony import */ var _serverScripts_formFill_formFill_454__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_454 */ "./src/serverScripts/formFill/formFill_454.ts");
/* harmony import */ var _serverScripts_formFill_formFill_457__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_457 */ "./src/serverScripts/formFill/formFill_457.ts");
/* harmony import */ var _serverScripts_formFill_formFill_743__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_743 */ "./src/serverScripts/formFill/formFill_743.ts");
/* harmony import */ var _serverScripts_formFill_formFill_768__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_768 */ "./src/serverScripts/formFill/formFill_768.ts");
/* harmony import */ var _serverScripts_formFill_formFill_820__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_820 */ "./src/serverScripts/formFill/formFill_820.ts");
/* harmony import */ var _serverScripts_formFill_formFill_evroport__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_evroport */ "./src/serverScripts/formFill/formFill_evroport.ts");
/* harmony import */ var _serverScripts_formFill_formFill_melinoTravel__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_melinoTravel */ "./src/serverScripts/formFill/formFill_melinoTravel.ts");
/* harmony import */ var _serverScripts_formFill_formFill_intourist_Samo__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_intourist_Samo */ "./src/serverScripts/formFill/formFill_intourist_Samo.ts");
/* harmony import */ var _serverScripts_formFill_formFill_kazunion_samo__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_kazunion_samo */ "./src/serverScripts/formFill/formFill_kazunion_samo.ts");
/* harmony import */ var _serverScripts_formFill_formFill_kazunion_kz__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_kazunion_kz */ "./src/serverScripts/formFill/formFill_kazunion_kz.ts");
/* harmony import */ var _serverScripts_formFill_formFill_letsFly_samo__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_letsFly_samo */ "./src/serverScripts/formFill/formFill_letsFly_samo.ts");
/* harmony import */ var _serverScripts_formFill_formFill_oneClickTravel__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_oneClickTravel */ "./src/serverScripts/formFill/formFill_oneClickTravel.ts");
/* harmony import */ var _serverScripts_formFill_formFill_tourplatform_samo__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./../../serverScripts/formFill/formFill_tourplatform_samo */ "./src/serverScripts/formFill/formFill_tourplatform_samo.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











































function navigateToFormFill(_a, data_1) {
    return __awaiter(this, arguments, void 0, function* ({ tourUrl, claimId, sourceId, claimNumber, secretField }, data) {
        const context = {
            data: data,
            tourUrl: tourUrl,
            secretField: secretField,
            claimNumber: claimNumber,
            sourceId: sourceId,
            toNumberSaveUrl: _chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.toNumberSaveUrl
        };
        switch (sourceId) {
            case 3:
                yield (0,_serverScripts_formFill_formFill_3__WEBPACK_IMPORTED_MODULE_1__.formFill)(context);
                break;
            case 4:
                yield (0,_serverScripts_formFill_formFill_4__WEBPACK_IMPORTED_MODULE_2__.formFill)(context);
                break;
            case 6:
                yield (0,_serverScripts_formFill_formFill_6__WEBPACK_IMPORTED_MODULE_3__.formFill)(context);
                break;
            case 7:
                yield (0,_serverScripts_formFill_formFill_7__WEBPACK_IMPORTED_MODULE_4__.formFill)(context);
                break;
            case 14:
                yield (0,_serverScripts_formFill_formFill_14__WEBPACK_IMPORTED_MODULE_5__.formFill)(context);
                break;
            case 19:
                yield (0,_serverScripts_formFill_formFill_19__WEBPACK_IMPORTED_MODULE_6__.formFill)(context);
                break;
            case 20:
                yield (0,_serverScripts_formFill_formFill_20__WEBPACK_IMPORTED_MODULE_7__.formFill)(context);
                break;
            case 51:
                yield (0,_serverScripts_formFill_formFill_51__WEBPACK_IMPORTED_MODULE_8__.formFill)(context);
                break;
            case 54:
                yield (0,_serverScripts_formFill_formFill_54__WEBPACK_IMPORTED_MODULE_9__.formFill)(context);
                break;
            case 81:
                yield (0,_serverScripts_formFill_formFill_81__WEBPACK_IMPORTED_MODULE_10__.formFill)(context);
                break;
            case 83:
                yield (0,_serverScripts_formFill_formFill_artTour__WEBPACK_IMPORTED_MODULE_11__.formFill)(context);
                break;
            case 112:
                yield (0,_serverScripts_formFill_formFill_112__WEBPACK_IMPORTED_MODULE_12__.formFill)(context);
                break;
            case 113:
                yield (0,_serverScripts_formFill_formFill_113__WEBPACK_IMPORTED_MODULE_13__.formFill)(context);
                break;
            case 153:
                yield (0,_serverScripts_formFill_formFill_153__WEBPACK_IMPORTED_MODULE_14__.formFill)(context);
                break;
            case 171:
                yield (0,_serverScripts_formFill_formFill_171__WEBPACK_IMPORTED_MODULE_15__.formFill)(context);
                break;
            case 191:
                yield (0,_serverScripts_formFill_formFill_sanatKz__WEBPACK_IMPORTED_MODULE_17__.formFill)(context);
                break;
            case 194:
                yield (0,_serverScripts_formFill_formFill_kompasKz__WEBPACK_IMPORTED_MODULE_16__.formFill)(context);
                break;
            case 199:
                yield (0,_serverScripts_formFill_formFill_evroport__WEBPACK_IMPORTED_MODULE_35__.formFill)(context);
                break;
            case 205:
                yield (0,_serverScripts_formFill_formFill_205__WEBPACK_IMPORTED_MODULE_18__.formFill)(context);
                break;
            case 231:
                yield (0,_serverScripts_formFill_formFill_231__WEBPACK_IMPORTED_MODULE_19__.formFill)(context);
                break;
            case 252:
                yield (0,_serverScripts_formFill_formFill_252__WEBPACK_IMPORTED_MODULE_20__.formFill)(context);
                break;
            case 302:
                yield (0,_serverScripts_formFill_formFill_302__WEBPACK_IMPORTED_MODULE_21__.formFill)(context);
                break;
            case 322:
                yield (0,_serverScripts_formFill_formFill_kazunion_samo__WEBPACK_IMPORTED_MODULE_38__.formFill)(context);
                break;
            case 343:
                yield (0,_serverScripts_formFill_formFill_plantravel_canary__WEBPACK_IMPORTED_MODULE_22__.formFill)(context);
                break;
            case 344:
                yield (0,_serverScripts_formFill_formFill_344__WEBPACK_IMPORTED_MODULE_23__.formFill)(context);
                break;
            case 361:
                yield (0,_serverScripts_formFill_formFill_spaceTravel__WEBPACK_IMPORTED_MODULE_24__.formFill)(context);
                break;
            case 380:
                yield (0,_serverScripts_formFill_formFill_380__WEBPACK_IMPORTED_MODULE_25__.formFill)(context);
                break;
            case 382:
                yield (0,_serverScripts_formFill_formFill_382__WEBPACK_IMPORTED_MODULE_26__.formFill)(context);
                break;
            case 439:
                yield (0,_serverScripts_formFill_formFill_439__WEBPACK_IMPORTED_MODULE_27__.formFill)(context);
                break;
            case 449:
                yield (0,_serverScripts_formFill_formFill_449__WEBPACK_IMPORTED_MODULE_28__.formFill)(context);
                break;
            case 452:
                yield (0,_serverScripts_formFill_formFill_452__WEBPACK_IMPORTED_MODULE_29__.formFill)(context);
                break;
            case 454:
                yield (0,_serverScripts_formFill_formFill_454__WEBPACK_IMPORTED_MODULE_30__.formFill)(context);
                break;
            case 457:
                yield (0,_serverScripts_formFill_formFill_457__WEBPACK_IMPORTED_MODULE_31__.formFill)(context);
                break;
            case 743:
                yield (0,_serverScripts_formFill_formFill_743__WEBPACK_IMPORTED_MODULE_32__.formFill)(context);
                break;
            case 768:
                yield (0,_serverScripts_formFill_formFill_768__WEBPACK_IMPORTED_MODULE_33__.formFill)(context);
                break;
            case 803:
                yield (0,_serverScripts_formFill_formFill_letsFly_samo__WEBPACK_IMPORTED_MODULE_40__.formFill)(context);
                break;
            case 820:
                yield (0,_serverScripts_formFill_formFill_820__WEBPACK_IMPORTED_MODULE_34__.formFill)(context);
                break;
            case 860:
                yield (0,_serverScripts_formFill_formFill_melinoTravel__WEBPACK_IMPORTED_MODULE_36__.formFill)(context);
                break;
            case 917:
                yield (0,_serverScripts_formFill_formFill_intourist_Samo__WEBPACK_IMPORTED_MODULE_37__.formFill)(context);
                break;
            case 926:
                yield (0,_serverScripts_formFill_formFill_oneClickTravel__WEBPACK_IMPORTED_MODULE_41__.formFill)(context);
                break;
            case 949:
                yield (0,_serverScripts_formFill_formFill_kazunion_kz__WEBPACK_IMPORTED_MODULE_39__.formFill)(context);
                break;
            case 970:
                yield (0,_serverScripts_formFill_formFill_tourplatform_samo__WEBPACK_IMPORTED_MODULE_42__.formFill)(context);
                break;
            default:
                console.warn(`Для ${sourceId} formFill не нашелся`);
                break;
        }
    });
}


/***/ }),

/***/ "./src/app/utils/parseDateString.ts":
/*!******************************************!*\
  !*** ./src/app/utils/parseDateString.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseDateString: () => (/* binding */ parseDateString)
/* harmony export */ });
const parseDateString = (dateString) => {
    const [day, month, year] = dateString.split('.');
    return new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10));
};


/***/ }),

/***/ "./src/app/utils/performTOAuth.ts":
/*!****************************************!*\
  !*** ./src/app/utils/performTOAuth.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   performTOAuth: () => (/* binding */ performTOAuth)
/* harmony export */ });
/* harmony import */ var _serverScripts_login_login_3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../../serverScripts/login/login_3 */ "./src/serverScripts/login/login_3.ts");
/* harmony import */ var _serverScripts_login_login_4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../serverScripts/login/login_4 */ "./src/serverScripts/login/login_4.ts");
/* harmony import */ var _serverScripts_login_login_6__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../../serverScripts/login/login_6 */ "./src/serverScripts/login/login_6.ts");
/* harmony import */ var _serverScripts_login_login_7__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../../serverScripts/login/login_7 */ "./src/serverScripts/login/login_7.ts");
/* harmony import */ var _serverScripts_login_login_14__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../../serverScripts/login/login_14 */ "./src/serverScripts/login/login_14.ts");
/* harmony import */ var _serverScripts_login_login_19__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../../serverScripts/login/login_19 */ "./src/serverScripts/login/login_19.ts");
/* harmony import */ var _serverScripts_login_login_20__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./../../serverScripts/login/login_20 */ "./src/serverScripts/login/login_20.ts");
/* harmony import */ var _serverScripts_login_login_51__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./../../serverScripts/login/login_51 */ "./src/serverScripts/login/login_51.ts");
/* harmony import */ var _serverScripts_login_login_54__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./../../serverScripts/login/login_54 */ "./src/serverScripts/login/login_54.ts");
/* harmony import */ var _serverScripts_login_login_81__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./../../serverScripts/login/login_81 */ "./src/serverScripts/login/login_81.ts");
/* harmony import */ var _serverScripts_login_login_83__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./../../serverScripts/login/login_83 */ "./src/serverScripts/login/login_83.ts");
/* harmony import */ var _serverScripts_login_login_112__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./../../serverScripts/login/login_112 */ "./src/serverScripts/login/login_112.ts");
/* harmony import */ var _serverScripts_login_login_113__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./../../serverScripts/login/login_113 */ "./src/serverScripts/login/login_113.ts");
/* harmony import */ var _serverScripts_login_login_153__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./../../serverScripts/login/login_153 */ "./src/serverScripts/login/login_153.ts");
/* harmony import */ var _serverScripts_login_login_171__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./../../serverScripts/login/login_171 */ "./src/serverScripts/login/login_171.ts");
/* harmony import */ var _serverScripts_login_login_205__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./../../serverScripts/login/login_205 */ "./src/serverScripts/login/login_205.ts");
/* harmony import */ var _serverScripts_login_login_231__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./../../serverScripts/login/login_231 */ "./src/serverScripts/login/login_231.ts");
/* harmony import */ var _serverScripts_login_login_252__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./../../serverScripts/login/login_252 */ "./src/serverScripts/login/login_252.ts");
/* harmony import */ var _serverScripts_login_login_302__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./../../serverScripts/login/login_302 */ "./src/serverScripts/login/login_302.ts");
/* harmony import */ var _serverScripts_login_login_343__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./../../serverScripts/login/login_343 */ "./src/serverScripts/login/login_343.ts");
/* harmony import */ var _serverScripts_login_login_344__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./../../serverScripts/login/login_344 */ "./src/serverScripts/login/login_344.ts");
/* harmony import */ var _serverScripts_login_login_361__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./../../serverScripts/login/login_361 */ "./src/serverScripts/login/login_361.ts");
/* harmony import */ var _serverScripts_login_login_380__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./../../serverScripts/login/login_380 */ "./src/serverScripts/login/login_380.ts");
/* harmony import */ var _serverScripts_login_login_382__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./../../serverScripts/login/login_382 */ "./src/serverScripts/login/login_382.ts");
/* harmony import */ var _serverScripts_login_login_439__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./../../serverScripts/login/login_439 */ "./src/serverScripts/login/login_439.ts");
/* harmony import */ var _serverScripts_login_login_449__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./../../serverScripts/login/login_449 */ "./src/serverScripts/login/login_449.ts");
/* harmony import */ var _serverScripts_login_login_452__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./../../serverScripts/login/login_452 */ "./src/serverScripts/login/login_452.ts");
/* harmony import */ var _serverScripts_login_login_454__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./../../serverScripts/login/login_454 */ "./src/serverScripts/login/login_454.ts");
/* harmony import */ var _serverScripts_login_login_457__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./../../serverScripts/login/login_457 */ "./src/serverScripts/login/login_457.ts");
/* harmony import */ var _serverScripts_login_login_743__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./../../serverScripts/login/login_743 */ "./src/serverScripts/login/login_743.ts");
/* harmony import */ var _serverScripts_login_login_768__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./../../serverScripts/login/login_768 */ "./src/serverScripts/login/login_768.ts");
/* harmony import */ var _serverScripts_login_login_820__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./../../serverScripts/login/login_820 */ "./src/serverScripts/login/login_820.ts");
/* harmony import */ var _serverScripts_login_login_evroport__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./../../serverScripts/login/login_evroport */ "./src/serverScripts/login/login_evroport.ts");
/* harmony import */ var _serverScripts_login_login_intourist_samo__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./../../serverScripts/login/login_intourist_samo */ "./src/serverScripts/login/login_intourist_samo.ts");
/* harmony import */ var _serverScripts_login_login_iway__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./../../serverScripts/login/login_iway */ "./src/serverScripts/login/login_iway.ts");
/* harmony import */ var _serverScripts_login_login_kazunion__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./../../serverScripts/login/login_kazunion */ "./src/serverScripts/login/login_kazunion.ts");
/* harmony import */ var _serverScripts_login_login_kazunion_kz__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./../../serverScripts/login/login_kazunion_kz */ "./src/serverScripts/login/login_kazunion_kz.ts");
/* harmony import */ var _serverScripts_login_login_kompasKz__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./../../serverScripts/login/login_kompasKz */ "./src/serverScripts/login/login_kompasKz.ts");
/* harmony import */ var _serverScripts_login_login_letsFly__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./../../serverScripts/login/login_letsFly */ "./src/serverScripts/login/login_letsFly.ts");
/* harmony import */ var _serverScripts_login_login_melinoTravel__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./../../serverScripts/login/login_melinoTravel */ "./src/serverScripts/login/login_melinoTravel.ts");
/* harmony import */ var _serverScripts_login_login_OneClickTravel__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./../../serverScripts/login/login_OneClickTravel */ "./src/serverScripts/login/login_OneClickTravel.ts");
/* harmony import */ var _serverScripts_login_login_sanatKz__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./../../serverScripts/login/login_sanatKz */ "./src/serverScripts/login/login_sanatKz.ts");
/* harmony import */ var _serverScripts_login_login_tourplatform_samo__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./../../serverScripts/login/login_tourplatform_samo */ "./src/serverScripts/login/login_tourplatform_samo.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











































function performTOAuth(sourceId, data) {
    return __awaiter(this, void 0, void 0, function* () {
        switch (sourceId) {
            case 3: {
                yield (0,_serverScripts_login_login_3__WEBPACK_IMPORTED_MODULE_0__.login)({ data: data });
                break;
            }
            case 4: {
                yield (0,_serverScripts_login_login_4__WEBPACK_IMPORTED_MODULE_1__.login)({ data: data });
                break;
            }
            case 6: {
                yield (0,_serverScripts_login_login_6__WEBPACK_IMPORTED_MODULE_2__.login)({ data: data });
                break;
            }
            case 7: {
                yield (0,_serverScripts_login_login_7__WEBPACK_IMPORTED_MODULE_3__.login)({ data: data });
                break;
            }
            case 14: {
                yield (0,_serverScripts_login_login_14__WEBPACK_IMPORTED_MODULE_4__.login)({ data: data });
                break;
            }
            case 19: {
                yield (0,_serverScripts_login_login_19__WEBPACK_IMPORTED_MODULE_5__.login)({ data: data });
                break;
            }
            case 20: {
                yield (0,_serverScripts_login_login_20__WEBPACK_IMPORTED_MODULE_6__.login)({ data: data });
                break;
            }
            case 51: {
                yield (0,_serverScripts_login_login_51__WEBPACK_IMPORTED_MODULE_7__.login)({ data: data });
                break;
            }
            case 54: {
                yield (0,_serverScripts_login_login_54__WEBPACK_IMPORTED_MODULE_8__.login)({ data: data });
                break;
            }
            case 81: {
                yield (0,_serverScripts_login_login_81__WEBPACK_IMPORTED_MODULE_9__.login)({ data: data });
                break;
            }
            case 83: {
                yield (0,_serverScripts_login_login_83__WEBPACK_IMPORTED_MODULE_10__.login)({ data: data });
                break;
            }
            case 112: {
                yield (0,_serverScripts_login_login_112__WEBPACK_IMPORTED_MODULE_11__.login)({ data: data });
                break;
            }
            case 113: {
                yield (0,_serverScripts_login_login_113__WEBPACK_IMPORTED_MODULE_12__.login)({ data: data });
                break;
            }
            case 153: {
                yield (0,_serverScripts_login_login_153__WEBPACK_IMPORTED_MODULE_13__.login)({ data: data });
                break;
            }
            case 171: {
                yield (0,_serverScripts_login_login_171__WEBPACK_IMPORTED_MODULE_14__.login)({ data: data });
                break;
            }
            case 191: {
                yield (0,_serverScripts_login_login_sanatKz__WEBPACK_IMPORTED_MODULE_41__.login)({ data: data });
                break;
            }
            case 194: {
                yield (0,_serverScripts_login_login_kompasKz__WEBPACK_IMPORTED_MODULE_37__.login)({ data: data });
                break;
            }
            case 199: {
                yield (0,_serverScripts_login_login_evroport__WEBPACK_IMPORTED_MODULE_32__.login)({ data: data });
                break;
            }
            case 205: {
                yield (0,_serverScripts_login_login_205__WEBPACK_IMPORTED_MODULE_15__.login)({ data: data });
                break;
            }
            case 231: {
                yield (0,_serverScripts_login_login_231__WEBPACK_IMPORTED_MODULE_16__.login)({ data: data });
                break;
            }
            case 252: {
                yield (0,_serverScripts_login_login_252__WEBPACK_IMPORTED_MODULE_17__.login)({ data: data });
                break;
            }
            case 302: {
                yield (0,_serverScripts_login_login_302__WEBPACK_IMPORTED_MODULE_18__.login)({ data: data });
                break;
            }
            case 322: {
                yield (0,_serverScripts_login_login_kazunion__WEBPACK_IMPORTED_MODULE_35__.login)({ data: data });
                break;
            }
            case 343: {
                yield (0,_serverScripts_login_login_343__WEBPACK_IMPORTED_MODULE_19__.login)({ data: data });
                break;
            }
            case 344: {
                yield (0,_serverScripts_login_login_344__WEBPACK_IMPORTED_MODULE_20__.login)({ data: data });
                break;
            }
            case 361: {
                yield (0,_serverScripts_login_login_361__WEBPACK_IMPORTED_MODULE_21__.login)({ data: data });
                break;
            }
            case 380: {
                yield (0,_serverScripts_login_login_380__WEBPACK_IMPORTED_MODULE_22__.login)({ data: data });
                break;
            }
            case 382: {
                yield (0,_serverScripts_login_login_382__WEBPACK_IMPORTED_MODULE_23__.login)({ data: data });
                break;
            }
            case 439: {
                yield (0,_serverScripts_login_login_439__WEBPACK_IMPORTED_MODULE_24__.login)({ data: data });
                break;
            }
            case 449: {
                yield (0,_serverScripts_login_login_449__WEBPACK_IMPORTED_MODULE_25__.login)({ data: data });
                break;
            }
            case 452: {
                yield (0,_serverScripts_login_login_452__WEBPACK_IMPORTED_MODULE_26__.login)({ data: data });
                break;
            }
            case 454: {
                yield (0,_serverScripts_login_login_454__WEBPACK_IMPORTED_MODULE_27__.login)({ data: data });
                break;
            }
            case 457: {
                yield (0,_serverScripts_login_login_457__WEBPACK_IMPORTED_MODULE_28__.login)({ data: data });
                break;
            }
            case 743: {
                yield (0,_serverScripts_login_login_743__WEBPACK_IMPORTED_MODULE_29__.login)({ data: data });
                break;
            }
            case 768: {
                yield (0,_serverScripts_login_login_768__WEBPACK_IMPORTED_MODULE_30__.login)({ data: data });
                break;
            }
            case 803: {
                yield (0,_serverScripts_login_login_letsFly__WEBPACK_IMPORTED_MODULE_38__.login)({ data: data });
                break;
            }
            case 860: {
                yield (0,_serverScripts_login_login_melinoTravel__WEBPACK_IMPORTED_MODULE_39__.login)({ data: data });
                break;
            }
            case 820: {
                yield (0,_serverScripts_login_login_820__WEBPACK_IMPORTED_MODULE_31__.login)({ data: data });
                break;
            }
            case 857: {
                yield (0,_serverScripts_login_login_iway__WEBPACK_IMPORTED_MODULE_34__.login)({ data: data });
                break;
            }
            case 917: {
                yield (0,_serverScripts_login_login_intourist_samo__WEBPACK_IMPORTED_MODULE_33__.login)({ data: data });
                break;
            }
            case 926: {
                yield (0,_serverScripts_login_login_OneClickTravel__WEBPACK_IMPORTED_MODULE_40__.login)({ data: data });
                break;
            }
            case 949: {
                yield (0,_serverScripts_login_login_kazunion_kz__WEBPACK_IMPORTED_MODULE_36__.login)({ data: data });
                break;
            }
            case 970: {
                yield (0,_serverScripts_login_login_tourplatform_samo__WEBPACK_IMPORTED_MODULE_42__.login)({ data: data });
                break;
            }
            default:
                console.warn(`Для ${sourceId} performTOAuth не нашелся`);
                break;
        }
    });
}


/***/ }),

/***/ "./src/app/utils/tabs.ts":
/*!*******************************!*\
  !*** ./src/app/utils/tabs.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCurrentTab: () => (/* binding */ getCurrentTab),
/* harmony export */   getCurrentWindow: () => (/* binding */ getCurrentWindow),
/* harmony export */   removeTab: () => (/* binding */ removeTab),
/* harmony export */   updateTab: () => (/* binding */ updateTab),
/* harmony export */   updateTabUrl: () => (/* binding */ updateTabUrl),
/* harmony export */   waitNewTab: () => (/* binding */ waitNewTab)
/* harmony export */ });
function waitNewTab() {
    return new Promise((resolve, reject) => {
        const func = (tab) => {
            chrome.tabs.onCreated.removeListener(func);
            resolve(tab);
        };
        chrome.tabs.onCreated.addListener(func);
    });
}
function getCurrentTab(windowId = chrome.windows.WINDOW_ID_CURRENT) {
    const params = { active: true, windowId };
    return new Promise((resolve, reject) => {
        chrome.tabs.query(params, tabs => resolve(tabs[0]));
    });
}
function getCurrentWindow() {
    return new Promise((resolve, reject) => {
        chrome.windows.getCurrent({
            populate: true
        }, browserWindow => resolve(browserWindow));
    });
}
function updateTab(tabId, options) {
    return new Promise((resolve, reject) => {
        chrome.tabs.update(tabId, options, (updatedTab) => resolve(updatedTab));
    });
}
function updateTabUrl(tab, url) {
    return updateTab(tab.id, { url: url });
}
const removeTab = (tab) => new Promise((resolve) => chrome.tabs.remove(tab.id, () => resolve()));


/***/ }),

/***/ "./src/app/utils/url.ts":
/*!******************************!*\
  !*** ./src/app/utils/url.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyQsParams: () => (/* binding */ stringifyQsParams)
/* harmony export */ });
function stringifyQsParams(params) {
    return Object.keys(params).reduce((acc, param, index, array) => {
        return acc += `${param}=${params[param]}${index === (array.length - 1) ? '' : '&'}`;
    }, '');
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_112.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_112.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_112__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/112 */ "./src/serverScripts/operators/112.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_112__WEBPACK_IMPORTED_MODULE_0__.ExpressTour);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, _operators_112__WEBPACK_IMPORTED_MODULE_0__.ExpressTour.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_112__WEBPACK_IMPORTED_MODULE_0__.ExpressTour.credentials.packet
            }));
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(3 * 1000);
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [{ tourists: data.autoFillerData.touristDataItems }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_112__WEBPACK_IMPORTED_MODULE_0__.ExpressTour, errorText: null });
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_8__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'span[id$="DogovorCode"]', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' });
        }
        catch (e) {
            console.log("Grand фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log(data);
    const touristBlocks = document.querySelectorAll('#ctl00_generalContent_touristData_dgTourists tr:not(.h1)');
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(touristItem => {
            const element = block.querySelector(touristItem.htmlElementSelector);
            if (element) {
                element.value = touristItem.value;
            }
        });
    }
    function setSexSelect(select, tourist) {
        select.options[tourist.touristType - 1].selected = true;
    }
    Array.prototype.forEach.call(touristBlocks, (block, index) => {
        const tourist = data.tourists[index];
        const fieldIndex = index + 2;
        if (!tourist) {
            return;
        }
        window.scrollTo(0, document.body.scrollHeight);
        const fields = [{
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_txtLastName`,
                value: tourist.surname
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_txtFirstName`,
                value: tourist.name
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtBirthDate_txtDay`,
                value: tourist.birthday ? tourist.birthday.split('.')[0] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtBirthDate_txtMonth`,
                value: tourist.birthday ? tourist.birthday.split('.')[1] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtBirthDate_txtYear`,
                value: tourist.birthday ? tourist.birthday.split('.')[2] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_pPassport_txtPassportSeries`,
                value: tourist.passportSeries
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_pPassport_txtPassportNumber`,
                value: tourist.passportNumber
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateEnd_txtDay`,
                value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[0] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateEnd_txtMonth`,
                value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[1] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateEnd_txtYear`,
                value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[2] : ''
            }];
        const sexSelect = block.querySelector(`select[name="ctl00$generalContent$touristData$dgTourists$ctl0${fieldIndex}$ddlSex"]`);
        handleTouristFields(fields, block);
        setSexSelect(sexSelect, tourist);
    });
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_113.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_113.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_113__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/113 */ "./src/serverScripts/operators/113.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__.removeCookiesForTouroperator)(_operators_113__WEBPACK_IMPORTED_MODULE_0__.Grand);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, _operators_113__WEBPACK_IMPORTED_MODULE_0__.Grand.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_7__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_113__WEBPACK_IMPORTED_MODULE_0__.Grand.credentials.packet
            }));
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_8__.wait)(3 * 1000);
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_9__.executeScriptInTabV3)(tab, claimFiller, [{ tourists: data.autoFillerData.touristDataItems }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_2__.createPushNotification)({ claimId: claimNumber, operator: _operators_113__WEBPACK_IMPORTED_MODULE_0__.Grand, errorText: null });
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_10__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'span[id$="DogovorCode"]', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_11__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_2__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' });
        }
        catch (e) {
            console.log("Grand фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_2__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log(data);
    const touristBlocks = document.querySelectorAll('#ctl00_generalContent_touristData_dgTourists tr:not(.h1)');
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(touristItem => {
            const element = block.querySelector(touristItem.htmlElementSelector);
            if (element) {
                element.value = touristItem.value;
            }
        });
    }
    function setSexSelect(select, tourist) {
        select.options[tourist.touristType - 1].selected = true;
    }
    Array.prototype.forEach.call(touristBlocks, (block, index) => {
        const tourist = data.tourists[index];
        const fieldIndex = index + 2;
        if (!tourist) {
            return;
        }
        window.scrollTo(0, document.body.scrollHeight);
        const fields = [{
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_txtLastName`,
                value: tourist.surname
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_txtFirstName`,
                value: tourist.name
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtBirthDate_txtDay`,
                value: tourist.birthday ? tourist.birthday.split('.')[0] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtBirthDate_txtMonth`,
                value: tourist.birthday ? tourist.birthday.split('.')[1] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtBirthDate_txtYear`,
                value: tourist.birthday ? tourist.birthday.split('.')[2] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_pPassport_txtPassportSeries`,
                value: tourist.passportSeries
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_pPassport_txtPassportNumber`,
                value: tourist.passportNumber
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateEnd_txtDay`,
                value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[0] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateEnd_txtMonth`,
                value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[1] : ''
            }, {
                htmlElementSelector: `#ctl00_generalContent_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateEnd_txtYear`,
                value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[2] : ''
            }];
        const sexSelect = block.querySelector(`select[name="ctl00$generalContent$touristData$dgTourists$ctl0${fieldIndex}$ddlSex"]`);
        handleTouristFields(fields, block);
        setSexSelect(sexSelect, tourist);
    });
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_14.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_14.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _operators_14__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../operators/14 */ "./src/serverScripts/operators/14.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const authUrl = 'https://www.pac.ru/account/login';
        const { data, secretField, claimNumber, sourceId, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_7__.removeCookiesForTouroperator)(_operators_14__WEBPACK_IMPORTED_MODULE_11__.PacGroup);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({
                active: true,
                url: authUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_8__.startTrackingElement)(tab, _operators_14__WEBPACK_IMPORTED_MODULE_11__.PacGroup.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_5__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_14__WEBPACK_IMPORTED_MODULE_11__.PacGroup.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_8__.startTrackingElement)(tab, 'div.js-authorization-user');
            yield (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_10__.updateTabUrl)(tab, tourUrl);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_8__.startTrackingElement)(tab, 'form.js-form-order');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTabV3)(tab, claimFiller, [{ tourists: data.autoFillerData.touristDataItems }]);
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_9__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'div.lk-order__head h1', context.claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__.sendIdsToBookingCenter)(context.claimNumber, ((claimNo) => {
                if (claimNo && claimNo !== '') {
                    var parse = claimNo.match(/(\S+\s\№)(\w+)/);
                    if (parse.length >= 3) {
                        return parse[2];
                    }
                    else
                        return '';
                }
                else
                    return '';
            })(response.claimNo));
        }
        catch (e) {
            console.log("PacGroup фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('PacGroup claimFiller');
    var mainChain = Promise.resolve();
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
    })(FieldType || (FieldType = {}));
    var childCount = 0;
    function wait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function fillText(block, touristField) {
        mainChain = mainChain.then(() => new Promise((resolve, reject) => {
            if (block && touristField.value) {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element) {
                    element.dispatchEvent(new Event('focus'));
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('input', { bubbles: true }));
                    element.dispatchEvent(new Event('change', { bubbles: true }));
                    // element.dispatchEvent(new Event('blur'));
                }
            }
            resolve();
        }));
        mainChain = mainChain.then(() => wait(250));
    }
    function setSexRadios(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            const sexRadios = block.querySelectorAll(touristField.htmlElementSelector);
            switch (touristField.value) {
                case 1:
                case 3:
                case 5:
                    sexRadios[0].click();
                    break;
                case 2:
                case 4:
                case 6:
                    sexRadios[1].click();
                    break;
            }
            res();
        }));
        mainChain = mainChain.then(() => wait(250));
    }
    function setDropDownValue(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            const touristForm = block.querySelector('.person_form , .changePersonDialog');
            const selectElement = touristForm.querySelector(touristField.htmlElementSelector);
            if (selectElement && touristField !== null && touristField.value !== null) {
                const validOpltions = [].filter.call(selectElement.options, (option) => option.innerText.toLowerCase().trim() === touristField.value.toLocaleLowerCase().trim());
                if (validOpltions.length > 0) {
                    const validOption = validOpltions[0];
                    if (selectElement.nextElementSibling && selectElement.nextElementSibling.firstElementChild) {
                        selectElement.nextElementSibling.firstElementChild.innerText = validOption.innerText;
                    }
                    selectElement.value = validOption.value;
                    selectElement.dispatchEvent(new Event('change'));
                }
            }
            res();
        }));
        mainChain = mainChain.then(() => wait(250));
    }
    function handleTouristFields(touristFields, block) {
        if (!block) {
            console.log('!block is true');
            return;
        }
        touristFields.forEach(touristItem => {
            switch (touristItem.fieldType) {
                case FieldType.Text:
                    fillText(block, touristItem);
                    break;
                case FieldType.Radio:
                    setSexRadios(block, touristItem);
                    break;
                case FieldType.Select:
                    setDropDownValue(block, touristItem);
                    break;
                case FieldType.DatePicker:
                    fillDatePicker(block, touristItem);
                    break;
                default: break;
            }
        });
    }
    function fillDatePicker(block, touristField) {
        mainChain = mainChain.then(() => new Promise((resolve, reject) => {
            if (block && touristField.value) {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element) {
                    element.dispatchEvent(new Event('focus'));
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('input', { bubbles: true }));
                    element.dispatchEvent(new Event('change', { bubbles: true }));
                    // element.dispatchEvent(new Event('blur'));
                }
            }
            resolve();
        }));
        mainChain = mainChain.then(() => wait(100));
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            var selectedDate = document.querySelector('table.ui-datepicker-calendar td a[aria-current=true]');
            if (selectedDate) {
                selectedDate.click();
            }
            res();
        }));
        mainChain = mainChain.then(() => wait(500));
    }
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function formatPhone(phone) {
        if (phone !== null) {
            phone = phone.replace('+', '').replace('-', '').replace('(', '').replace(')', '').replace(' ', '');
            // return `+7(${phone.slice(1, 4)}) ${phone.slice(4, 7)}-${phone.slice(7, 11)}`;
            return phone;
        }
        else {
            return '';
        }
    }
    function fillTourist(element, tourist, index) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            if (element) {
                const divIcon = element.querySelector('div.form-group-gender__icon');
                if (divIcon && divIcon.click) {
                    divIcon.click();
                    res();
                }
            }
            else {
                rej();
            }
        }));
        mainChain = mainChain.then(() => wait(100), () => console.log('Некоторая печаль приключилась с ссылками на формы туристов'));
        const touristDataTarget = element.getAttribute('data-target');
        if (tourist) {
            let personAgeType = 'adult';
            if (getTouristAge(tourist) < 14) {
                index = childCount;
                personAgeType = 'child';
                childCount += 1;
            }
            const touristFields = [
                {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.LastName"], input[name="services[${index}].Tourist.Lastname"]`,
                    value: tourist.surnameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.FirstName"], input[name="services[${index}].Tourist.Firstname"]`,
                    value: tourist.nameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.MiddleName"], input[name="services[${index}].Tourist.MiddleName"]`,
                    value: tourist.middleNameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.Birthday"], input[name="services[${index}].Tourist.Birthday"]`,
                    value: tourist.birthday,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.Gender"]`,
                    value: tourist.touristType,
                    fieldType: FieldType.Radio
                },
                {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.Documents[0].Number"]`,
                    value: ((tourist) => {
                        if (tourist
                            && tourist !== null
                            && tourist.passportSeries !== null
                            && tourist.passportNumber !== null) {
                            return tourist.passportSeries + tourist.passportNumber;
                        }
                        else
                            return '';
                    })(tourist),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.Documents[0].IssueDate"]`,
                    value: tourist.passportDate,
                    fieldType: FieldType.DatePicker
                }, {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.Documents[0].ExpirationDate"]`,
                    value: tourist.passportExpireDate,
                    fieldType: FieldType.DatePicker
                }, {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.Phone"], input[name="services[${index}].Tourist.Phone"]`,
                    value: formatPhone(tourist.phone),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="Form.ServiceGroups[0].TouristServices[${personAgeType}${index}].Tourist.Email"], input[name="services[${index}].Tourist.Email"]`,
                    value: tourist.email,
                    fieldType: FieldType.Text
                },
            ];
            let touristForm = null;
            document.querySelectorAll('div.order-person').forEach(formElement => {
                if (touristDataTarget && touristDataTarget === formElement.getAttribute('data-tab')) {
                    touristForm = formElement;
                }
            });
            handleTouristFields(touristFields, touristForm);
        }
    }
    function doFill(data) {
        var touristRowLinksSelector = 'div.order-person-list__tabs > div.order-person__tab';
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            document.querySelectorAll('div.js-form-steps li.js-form-step')[1].click(); // переход в табик с туристами
            res();
        }))
            .then(() => wait(200));
        data.tourists.forEach(function (tourist, index) {
            var links = document.querySelectorAll(touristRowLinksSelector);
            if (links && links[index]) {
                return fillTourist(links[index], tourist, index);
            }
        });
    }
    debugger;
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_153.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_153.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_153__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/153 */ "./src/serverScripts/operators/153.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./../../app/utils/chunks/common/oneForNoData */ "./src/app/utils/chunks/common/oneForNoData.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_153__WEBPACK_IMPORTED_MODULE_0__.Delfin);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: tourUrl
            });
            const regExp = /www\.delfin\-tour\.ru\/cabinet\/Orders\/Single\/(\S+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                return true;
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'button[data-type="information"]');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_10__.executeScriptInTabV3)(tab, () => {
                var buttons = document.querySelectorAll('div.content button.btn');
                if (buttons.length >= 1) {
                    buttons[1].click();
                }
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'input[name="lg-login"]');
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_11__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_8__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_153__WEBPACK_IMPORTED_MODULE_0__.Delfin.packet
            }));
            Array.prototype.forEach.call(data.autoFillerData.touristDataItems, tourist => {
                return (0,_app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_9__.oneForNoData)(tourist);
            });
            function getTouristAge(tourist) {
                const [day, month, year] = tourist.birthday.split('.');
                const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
                const ageDate = new Date(ageDiffMs);
                return ageDate.getUTCFullYear() - 1970;
            }
            // сортируем детей по возрасту в порядке возрастания, потому что Дельфин альтернативно одаренный
            var tmpTouristsArray = [];
            var tmpChildTouristsArray = [];
            for (var i = 0; i < data.autoFillerData.touristDataItems.length; i++) {
                var tourist = data.autoFillerData.touristDataItems[i];
                if (getTouristAge(tourist) < 14) {
                    tmpChildTouristsArray.push(tourist);
                }
                else {
                    tmpTouristsArray[i] = tourist;
                }
            }
            tmpChildTouristsArray = tmpChildTouristsArray.reverse();
            data.autoFillerData.touristDataItems = tmpTouristsArray.concat(tmpChildTouristsArray);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'table.table.table-hover.table-striped > tbody');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_10__.executeScriptInTabV3)(tab, claimFilter, [{
                    tourists: data.autoFillerData.touristDataItems,
                    countyTo: data.countryTo
                }]);
            let response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'div.tabbable-custom li.active a[data-toggle=tab]', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, formatClaimNo(response.claimNo));
        }
        catch (e) {
            console.log("Delfin фатальная ошибка");
            console.log(e);
            console.dir(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function formatClaimNo(claimNo) {
    if (claimNo !== null) {
        return claimNo.replace(/№ /, '');
    }
    return claimNo;
}
function claimFilter(data) {
    var global_blocks = document.querySelectorAll('table.table.table-hover.table-striped > tbody')[1].childNodes;
    console.log(`Blocks.length = ${global_blocks.length}`);
    console.log(`Tourists.length = ${data.tourists.length}`);
    debugger;
    for (var i = 0; i < data.tourists.length; i++) {
        fillSpecificTourist(i);
    }
    function fillSpecificTourist(i) {
        function handleTouristFields(touristFields, block) {
            touristFields.forEach(touristItem => {
                const element = block.querySelector(touristItem.htmlElementSelector);
                if (element && touristItem.value) {
                    element.value = touristItem.value;
                    element.dispatchEvent(new Event('input'));
                    element.dispatchEvent(new Event('change'));
                }
            });
        }
        function fill(i) {
            const tourist = data.tourists[i];
            var block = global_blocks[i];
            if (!tourist) {
                return;
            }
            const fields = [
                {
                    htmlElementSelector: 'input[data-field="surName"]',
                    value: tourist.surnameRus
                },
                {
                    htmlElementSelector: 'input[data-field="name"]',
                    value: tourist.nameRus
                },
                {
                    htmlElementSelector: 'input[data-field="patronymic"]',
                    value: tourist.middleNameRus
                },
                {
                    htmlElementSelector: 'input[data-field="documentSerial"]',
                    value: tourist.passportSeries
                },
                {
                    htmlElementSelector: 'input[data-field="documentNumber"]',
                    value: tourist.passportNumber
                }
            ];
            const femaleBtn = block.querySelector('label[title="Женский"]');
            const maleBtn = block.querySelector('label[title="Мужской"]');
            const birthdayField = {
                htmlElementSelector: 'input[data-field="birthdate"]',
                value: tourist.birthday
            };
            handleTouristFields(fields, block);
            setSex(maleBtn, femaleBtn, tourist);
            setDate(birthdayField, block);
        }
        function setSex(maleDd, femaleDd, tourist) {
            if (!maleDd || !femaleDd) {
                return;
            }
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    maleDd.click();
                    break;
                case 2:
                case 4:
                case 6:
                    femaleDd.click();
                    break;
            }
        }
        function setDate(touristBday, block) {
            // @ts-ignore
            block.querySelector('input[data-field="birthdate"]').value = touristBday.value;
            // @ts-ignore
            block.querySelector('input[data-field="birthdate"]').dispatchEvent(new Event('input'));
        }
        fill(i);
    }
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_171.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_171.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_171__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/171 */ "./src/serverScripts/operators/171.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { data, claimNumber, tourUrl } = context;
        try {
            try {
                // @ts-ignore
                (_a = data.autoFillerData.customer) === null || _a === void 0 ? void 0 : _a.eVoucherClaimNumber = data.eVoucherClaimNumber;
                // @ts-ignore
                (_b = data.autoFillerData.customer) === null || _b === void 0 ? void 0 : _b.eVoucherCurrency = data.eVoucherCurrency;
                // @ts-ignore
                (_c = data.autoFillerData.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
                // @ts-ignore
                (_d = data.autoFillerData.customer) === null || _d === void 0 ? void 0 : _d.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
            }
            catch (e) {
                console.log('Что-то пошло не так, пока добавлялись даныне договора: ');
                console.log(e);
            }
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_171__WEBPACK_IMPORTED_MODULE_0__.AmigoS);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'div.header');
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_9__.PageSelectors({
                login: data.login,
                packet: _operators_171__WEBPACK_IMPORTED_MODULE_0__.AmigoS.credentials.packet,
                password: data.password
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'div#tourist_data_list');
            const regExp = /dynamic\.amigo\-s\.ru\/mw\/(OrderInfo|orderInfo)\.aspx\?dg_code=(\S+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_8__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 3) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, parsedUrl[2].toUpperCase())
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                return true;
            });
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000 * 10);
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    countyTo: data.countryTo,
                    customer: data.autoFillerData.customer
                }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_171__WEBPACK_IMPORTED_MODULE_0__.AmigoS, errorText: null });
        }
        catch (e) {
            console.log("фатальная ошибка");
            console.log(e);
            console.dir(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        const touristBlocks = document.querySelectorAll('div#tourist_data_list div.fui-tourists-form-holder');
        function fillCustomer(customer) {
            var customerBlock = document.querySelector('div#ctl00_generalContent_MainManTouristEP');
            if (!customerBlock || !customer)
                return;
            const fields = [{
                    htmlElementSelector: `#ctl00_generalContent_FIOMainManTourist`,
                    value: `${customer.surnameRus} ${customer.nameRus} ${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BirthdayMainTouristDay`,
                    value: customer.birthday.split('.')[0]
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BirthdayMainTouristMonth`,
                    value: customer.birthday.split('.')[1]
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BirthdayMainTouristYear`,
                    value: customer.birthday.split('.')[2]
                }, {
                    htmlElementSelector: `#ctl00_generalContent_PassportMainTourist`,
                    value: `${customer.passportSeries} ${customer.passportNumber}`
                }, {
                    htmlElementSelector: `#ctl00_generalContent_AgentDogovorMainTourist`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `#ctl00_generalContent_AgentDogovorDateMainTouristDay`,
                    value: customer.eVoucherContractDate.split('.')[0]
                }, {
                    htmlElementSelector: `#ctl00_generalContent_AgentDogovorDateMainTouristMonth`,
                    value: customer.eVoucherContractDate.split('.')[1]
                }, {
                    htmlElementSelector: `#ctl00_generalContent_AgentDogovorDateMainTouristYear`,
                    value: customer.eVoucherContractDate.split('.')[2]
                }, {
                    htmlElementSelector: `#ctl00_generalContent_AgentSummDogovorMainTourist`,
                    value: `${customer.eVoucherCustomerPriceInPaymentCurrency}`
                }];
            handleTouristFields(fields, customerBlock);
        }
        function setSexSelect(select, tourist) {
            if (select.options.length <= 6) {
                select.options[tourist.touristType - 1].selected = true;
            }
            else {
                select.options[tourist.touristType].selected = true; // потому что там появляется первый option который '-'
            }
            select.dispatchEvent(new Event('change'));
        }
        function handleTouristFields(touristFields, block) {
            if (!block)
                return;
            touristFields.forEach(touristItem => {
                const element = block.querySelector(touristItem.htmlElementSelector);
                if (element) {
                    element.value = touristItem.value;
                    // element.dispatchEvent(new Event('input'));
                    // element.dispatchEvent(new Event('change'));
                }
            });
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            const fieldIndex = index + 2;
            const dateFormat = 'DD.MM.YYYY';
            const defaultDate = '01.01.1900';
            if (!tourist) {
                return;
            }
            const fields = [{
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_txtLastName`,
                    value: tourist.surname
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_txtFirstName`,
                    value: tourist.name
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_txtPatronymic`,
                    value: tourist.middlename
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtBirthDate_txtDay`,
                    value: tourist.birthday ? tourist.birthday.split('.')[0] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtBirthDate_txtMonth`,
                    value: tourist.birthday ? tourist.birthday.split('.')[1] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtBirthDate_txtYear`,
                    value: tourist.birthday ? tourist.birthday.split('.')[2] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_pPassport_txtPassportSeries`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_pPassport_txtPassportNumber`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_pPassportRus_txtPassportSeries`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_pPassportRus_txtPassportNumber`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDate_txtDay`,
                    value: tourist.passportDate ? tourist.passportDate.split('.')[0] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDate_txtMonth`,
                    value: tourist.passportDate ? tourist.passportDate.split('.')[1] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDate_txtYear`,
                    value: tourist.passportDate ? tourist.passportDate.split('.')[2] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateRus_txtDay`,
                    value: tourist.passportDate ? tourist.passportDate.split('.')[0] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateRus_txtMonth`,
                    value: tourist.passportDate ? tourist.passportDate.split('.')[1] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateRus_txtYear`,
                    value: tourist.passportDate ? tourist.passportDate.split('.')[2] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateEnd_txtDay`,
                    value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[0] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateEnd_txtMonth`,
                    value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[1] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_sdtPassportDateEnd_txtYear`,
                    value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[2] : ''
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_txtPhone`,
                    value: tourist.phone
                }, {
                    htmlElementSelector: `#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0${fieldIndex}_txtEmail`,
                    value: tourist.email
                }];
            const sexSelect = block.querySelector(`select[name="ctl00$generalContent$BasketTourists$touristData$dgTourists$ctl0${fieldIndex}$ddlSex"]`);
            handleTouristFields(fields, block);
            setSexSelect(sexSelect, tourist);
        });
        fillCustomer(data.customer);
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_19.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_19.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_19__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/19 */ "./src/serverScripts/operators/19.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_common_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/common/emptyForNoDataAndOnes */ "./src/app/utils/chunks/common/emptyForNoDataAndOnes.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, } = context;
        let { tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_12__.removeCookies)({
                url: 'http://samo.anextour.ru',
                cookieNames: ['SAMO']
            });
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_12__.removeCookies)({
                url: 'http://parser.anextour.ru',
                cookieNames: ['SAMO']
            });
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_12__.removeCookies)({
                url: 'https://searchtour.anextour.com',
                cookieNames: ['SAMO']
            });
            var tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, "div#loginbox");
            Array.prototype.forEach.call(data.autoFillerData.touristDataItems, tourist => {
                return (0,_app_utils_chunks_common_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_8__.emptyForNoDataAndOnes)(tourist);
            });
            var regExp = /(samo|parser)\.anextour\.(com|ru)\/default\.php\?page\=cl_refer&CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__.updateListenerOnSpecificNewPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 4) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_5__.sendIdsToBookingCenter)(claimNumber, parsedUrl[3].toUpperCase())
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                return true;
            });
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_13__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_9__.PageSelectors({
                packet: _operators_19__WEBPACK_IMPORTED_MODULE_0__.Anex.packet,
                login: data.login,
                password: data.password
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_7__.wait)(1000);
            let fillerParams = {
                tourists: data.autoFillerData.touristDataItems,
                customer: data.autoFillerData.customer,
                bookingCompanyId: data.bookingCompanyId,
                countryTo: data.countryTo,
                isAdvanceBooking: data.isAdvanceBooking
            };
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(tab, claimFiller, [fillerParams]);
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_11__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'span.claim', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_5__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' });
        }
        catch (e) {
            console.log("Фатальная ошибка Anex");
            console.log(e);
            console.dir(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    let chain = Promise.resolve();
    function wait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    console.log(data.tourists);
    const touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
    function setSexRadios(index, tourist) {
        let sexTypeIndex = 0;
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                sexTypeIndex = 2;
                break;
            case 2:
            case 4:
            case 6:
                sexTypeIndex = 1;
                break;
        }
        document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    const handleTouristFields = (block, touristFields) => {
        touristFields.forEach(touristField => {
            const element = block.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                console.log(touristField.value);
                element.value = touristField.value;
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
        });
    };
    const setHuman = (index, tourist) => {
        let humanDdItemIndex = 0;
        switch (tourist.touristType) {
            case 1:
                humanDdItemIndex = 2;
                break;
            case 2:
                humanDdItemIndex = 3;
                break;
            case 3:
                humanDdItemIndex = 1;
                break;
            case 4:
                humanDdItemIndex = 1;
                break;
            case 5:
                humanDdItemIndex = 1;
                break;
            case 6:
                humanDdItemIndex = 1;
                break;
        }
        document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        let option = document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`);
        if (option) {
            option.dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
    };
    const setCitezenship = (index, tourist) => {
        const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
        let text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
            if (tourist.citizenshipName.trim() === option.innerText.trim()) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
        var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
        searchinp.value = text;
        dropdown.dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    };
    function setCustomerCitezenship(customer) {
        const select = document.querySelector(`select[name="frm[phys_byer][-1][NATIONALITY]"]`);
        let text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
            if (customer.citizenship === option.value) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var searchinp = document.querySelector(`select[name="frm[phys_byer][-1][NATIONALITY]"] ~ div.chosen-container input`);
        var dropdown = document.querySelector(`select[name="frm[phys_byer][-1][NATIONALITY]"] ~ div.chosen-container`);
        searchinp.value = text;
        dropdown.dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[phys_byer][-1][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    ;
    function preparePhone(phone) {
        if (phone) {
            phone = phone.replace(/\D/g, '');
            if (phone && phone.startsWith('7')) {
                return '+' + phone;
            }
            if (phone && phone.startsWith('8')) {
                return '+7' + phone.substr(1, phone.length);
            }
        }
        return phone;
    }
    const contacts = document.querySelector('input[name=CONTACTS]');
    if (contacts !== null) {
        contacts.value = 'alltours@cb.sletat.ru';
    }
    function toUpperCase(input) {
        if (!input || input === '') {
            return '';
        }
        return input.toUpperCase();
    }
    function getOptionIndexByName(texts, liSelector) {
        const lis = document.querySelectorAll(liSelector);
        for (var i = 0; i < lis.length; i++) {
            var li = lis[i];
            if (li && li.innerText && texts.indexOf(li.innerText.replaceAll(' ', '').toUpperCase()) !== -1) {
                return i;
            }
        }
        return 0;
    }
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function setDocumentType(index, tourist, countryTo) {
        document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        let optionIndex = -1;
        if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
            optionIndex = getOptionIndexByName(['Свидетельство о рождении'.replaceAll(' ', '').toUpperCase(), 'Birth certificate'.replaceAll(' ', '').toUpperCase()], `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container ul.chosen-results li`);
        }
        else {
            if (tourist.isNationalPassport) {
                optionIndex = getOptionIndexByName(['Паспорт'.replaceAll(' ', '').toUpperCase(), 'Passport'.replaceAll(' ', '').toUpperCase()], `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container ul.chosen-results li`);
            }
            else {
                optionIndex = getOptionIndexByName(['Заграничный паспорт'.replaceAll(' ', '').toUpperCase(), 'International passport'.replaceAll(' ', '').toUpperCase()], `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container ul.chosen-results li`);
            }
        }
        document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function setCustomerDocumentType(tourist) {
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        let optionIndex = -1;
        optionIndex = getOptionIndexByName(['Паспорт'.replaceAll(' ', '').toUpperCase(), 'Passport'.replaceAll(' ', '').toUpperCase()], `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container ul.chosen-results li`);
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function fillCustomer(customer) {
        if (!customer)
            return;
        var customerBlock = document.querySelector('div.BUYERINFO');
        if (!customerBlock || !customer)
            return;
        const touristFields = [{
                htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                value: toUpperCase(`${customer.surnameRus}`)
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                value: toUpperCase(`${customer.nameRus}`)
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                value: toUpperCase(`${customer.middleNameRus}`)
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                value: toUpperCase(customer.address)
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                value: toUpperCase(customer.passportSeries)
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                value: toUpperCase(customer.passportNumber)
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                value: toUpperCase(customer.phone)
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                value: toUpperCase(customer.email)
            }];
        handleTouristFields(customerBlock, touristFields);
        setCustomerCitezenship(customer);
        setCustomerDocumentType(customer);
    }
    function DateToString(date) {
        var mm = date.getMonth() + 1;
        var dd = date.getDate();
        return [(dd > 9 ? '' : '0') + dd,
            (mm > 9 ? '' : '0') + mm,
            date.getFullYear()]
            .join('');
    }
    ;
    Array.prototype.forEach.call(touristBlocks, (block, index) => {
        const tourist = data.tourists[index];
        if (!tourist) {
            return;
        }
        chain = chain.then(() => setHuman(index, tourist));
        chain = chain.then(() => wait(500));
        chain = chain.then(() => setSexRadios(index, tourist));
        chain = chain.then(() => wait(500));
        const touristFieldsFirst = [{
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                value: toUpperCase(tourist.surnameEng)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                value: toUpperCase(tourist.surname)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                value: toUpperCase(tourist.nameEng)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                value: toUpperCase(tourist.name)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                value: toUpperCase(tourist.nameRus)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                value: toUpperCase(tourist.surname)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                value: toUpperCase(tourist.surnameRus)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                value: toUpperCase(tourist.middleNameRus)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                value: tourist.birthday
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                value: preparePhone(tourist.phone) || '+79587764656'
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                value: tourist.email || 'ocb@corp.sletat.ru'
            }];
        chain = chain.then(() => handleTouristFields(block, touristFieldsFirst));
        chain = chain.then(() => wait(500));
        chain = chain.then(() => setCitezenship(index, tourist));
        chain = chain.then(() => wait(500));
        chain = chain.then(() => setDocumentType(index, tourist, data.countryTo));
        const touristFieldsSecond = [
            {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                value: tourist.passportSeries
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                value: tourist.passportNumber
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                value: tourist.passportExpireDate
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                value: !tourist.passportDate || tourist.passportDate === '' ? DateToString(new Date) : tourist.passportDate
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
            }
        ];
        chain = chain.then(() => handleTouristFields(block, touristFieldsSecond));
        chain = chain.then(() => wait(500));
        console.log(index);
    });
    chain = chain.then(() => wait(500));
    chain = chain.then(() => {
        if (data.isAdvanceBooking) {
            const chckbx = document.querySelector('input#CALCULATED_CLAIM');
            if (chckbx) {
                chckbx.click();
            }
            try {
                document.querySelector('td.calculated').style.border = '10px solid red';
            }
            catch (e) { }
        }
    });
    chain = chain.then(() => wait(500));
    chain = chain.then(() => fillCustomer(data.customer));
    function addPlashka(cbCompanyId) {
        const getBookingCompanyByCBGuid = (guid) => {
            const guidBookingCompany = {
                '62b8b7e0-c368-4ec0-8fc6-cee8bbcbbe41': { name: 'ООО «АРИЛЬД»', color: '#00875a' },
                '4016198a-5249-43b7-b3a0-a4cf53b96cd4': { name: 'ООО «ОЦБ»', color: '#ff8b00' },
                'a284bfd4-08e5-4f7d-a11c-f745c3c8bdc5': { name: 'ООО «ОЦБ K»', color: '#ff8b00' },
                'a0c2a815-daec-47f1-a558-c921f13482cc': { name: 'ООО «ГорТревел»', color: '#0747a6' },
                '96c57522-c7b9-43fb-ab7a-15f98d3972d4': { name: 'ООО «Все Туры»', color: '#de350b' },
                'eee2cd51-5bb0-495b-9067-ec30adfece47': { name: 'ООО «ГорТревел В»', color: '#403294' },
                '387d946b-82e6-4a9d-bd02-1ebde5ebcd0a': { name: 'ИП Абрамов Денис Дмитриевич', color: '#ffab00' },
                'd85b47f8-d524-4f85-9dd6-70100983fb49': { name: 'ООО «МСУ Тех»', color: '#66FF00' },
                '7784c883-fad4-4402-ba0a-07fda56f5edb': { name: 'ООО СолнцеТур', color: '#505f79' }
            };
            return guidBookingCompany[guid] || { name: 'ООО НЕИЗВЕСТНО', color: 'pink' };
        };
        var urLico = getBookingCompanyByCBGuid(cbCompanyId);
        const divToAddParent = document.createElement('div');
        divToAddParent.id = 'urlicocbParent';
        divToAddParent.setAttribute('style', `
                width: 532px;
                height: 50px;
                position: relative;
                border: 10px solid ${urLico.color};
                border-radius: 10px;
                margin-bottom: 10px;
            `);
        const divToAddChild = document.createElement('div');
        divToAddChild.innerHTML = urLico.name;
        divToAddChild.id = 'urlicocbChild';
        divToAddChild.setAttribute('style', `
                margin: 0;
                position: absolute;
                top: 50%;
                left: 50%;
                -ms-transform: translate(-50%, -50%);
                transform: translate(-50%, -50%);
                font-weight: bold;
                font-size: x-large;
            `);
        divToAddParent.appendChild(divToAddChild);
        const priceInfo = document.querySelector('div.PRICEINFO');
        if (priceInfo) {
            priceInfo.prepend(divToAddParent);
        }
    }
    chain = chain.then(() => wait(500));
    chain = chain.then(() => addPlashka(data.bookingCompanyId));
    function delay(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function removeAllCheckboxesInCategory(popup, categoryName) {
        const tableHeaders = Array.from(popup.getElementsByTagName("th"));
        const categoryHeader = tableHeaders.find(x => x.innerText == categoryName);
        if (!categoryHeader)
            return;
        const categoryHeaderP = categoryHeader.parentElement;
        const categoryHeaderPP = categoryHeaderP.parentElement;
        const categoryTableBody = categoryHeaderPP.nextElementSibling;
        removeAllCheckboxes(categoryTableBody);
    }
    function removeAllCheckboxes(tableBody) {
        while (true) {
            const checkBoxes = Array.from(tableBody.getElementsByTagName("input"));
            const checkedCheckBox = checkBoxes.find(x => x.checked && !x.disabled);
            if (!(checkedCheckBox))
                return;
            checkedCheckBox.click();
        }
    }
    function removeInsurances() {
        try {
            const popupOpenButton = document.getElementsByClassName('additional_insures')[0];
            popupOpenButton.click();
            delay(4 * 1000)
                .then(() => {
                let popup = document.querySelector("#additional_insures");
                if (!popup)
                    throw "failed to find popup";
                removeAllCheckboxes(popup);
                return new Promise((res, rej) => res(0));
            })
                .then(() => delay(2 * 1000))
                .then(() => {
                const saveBtn = document.getElementById('ADD_ADDITIONAL_INSURES');
                saveBtn.click();
            });
        }
        catch (ex) {
            throw ex;
        }
    }
    function deleteEverything() {
        removeInsurances();
    }
    chain = chain.then(() => wait(500));
    chain = chain.then(() => deleteEverything());
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_20.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_20.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_20__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/20 */ "./src/serverScripts/operators/20.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__.removeCookiesForTouroperator)(_operators_20__WEBPACK_IMPORTED_MODULE_0__.IcsTravel);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, _operators_20__WEBPACK_IMPORTED_MODULE_0__.IcsTravel.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_20__WEBPACK_IMPORTED_MODULE_0__.IcsTravel.credentials.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '#form_id_main');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000);
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [{ tourists: data.autoFillerData.touristDataItems }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_20__WEBPACK_IMPORTED_MODULE_0__.IcsTravel, errorText: null });
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'div.hotel_order_title .itm span.red', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' });
        }
        catch (e) {
            console.log("IcsTravel фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('claimFiller IcsTravel');
    debugger;
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(touristItem => {
            const element = block.querySelector(touristItem.htmlElementSelector);
            if (element && touristItem.value) {
                element.value = touristItem.value;
            }
        });
    }
    function getSelectValue(citizenship) {
        if (!citizenship)
            return '3102';
        switch (citizenship.toUpperCase()) {
            case 'РОССИЯ': return '3102';
            case 'УКРАИНА': return '3104';
            case 'МОЛДОВА': return '3105';
            case 'АРМЕНИЯ': return '3108';
            case 'БЕЛАРУСЬ': return '3124';
            case 'АЗЕРБАЙДЖАН': return '3143';
            case 'ЛАТВИЯ': return '3160';
            case 'БОЛГАРИЯ': return '3129';
            case 'УЗБЕКИСТАН': return '3142';
            default: return '3102';
        }
    }
    function setCitizenshipSelect(select, tourist) {
        if (!select) {
            return;
        }
        // @ts-ignore
        const options = Array.apply(null, select.options);
        options.forEach((option) => {
            if (option.value === getSelectValue(tourist.citizenshipName)) {
                option.selected = true;
            }
        });
    }
    function setSexSelect(select, tourist) {
        if (!select) {
            return;
        }
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                select.options[1].selected = true;
                break;
            case 2:
            case 4:
            case 6:
                select.options[2].selected = true;
                break;
        }
    }
    function formatPhone(phone) {
        if (phone !== null) {
            phone = phone.trim().replace('+', '').replace('-', '').replace('(', '').replace(')', '');
            return `+7(${phone.slice(1, 4)}) ${phone.slice(4, 7)}-${phone.slice(7, 11)}`;
        }
        else {
            return '';
        }
    }
    function doFill(touristBlocks, tourists) {
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = tourists[index];
            const fieldIndex = index + 1;
            if (!tourist) {
                return;
            }
            const fields = [{
                    htmlElementSelector: `input[name="l_name${fieldIndex}"]`,
                    value: tourist.surnameEng
                }, {
                    htmlElementSelector: `input[name="name${fieldIndex}"]`,
                    value: tourist.nameEng
                }, {
                    htmlElementSelector: `input[name="m_name${fieldIndex}"]`,
                    value: tourist.middleNameEng
                }, {
                    htmlElementSelector: `input[name="bdate${fieldIndex}"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="num_passport${fieldIndex}"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="passport${fieldIndex}"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="pass_begins${fieldIndex}"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="pass_ends${fieldIndex}"]`,
                    value: tourist.passportExpireDate
                }];
            const citizenshipSelect = block.querySelector(`select[name="citizenship${fieldIndex}"]`);
            const sexSelect = block.querySelector(`select[name="gender${fieldIndex}"]`);
            handleTouristFields(fields, block);
            setCitizenshipSelect(citizenshipSelect, tourist);
            setSexSelect(sexSelect, tourist);
            const birhdayInput = block.querySelector(`input[name="bdate${fieldIndex}"]`);
            birhdayInput.dispatchEvent(new Event('focus'));
            const selectedDate = document.querySelector('.ui-datepicker-current-day');
            if (selectedDate) {
                selectedDate.dispatchEvent(new Event('click'));
            }
            if (index === 0) {
                const additionalFields = [{
                        htmlElementSelector: `input#sabre_phone`,
                        value: formatPhone(tourist.phone)
                    }, {
                        htmlElementSelector: `input#sabre_email`,
                        value: tourist.email
                    }];
                const additionalBlock = document.querySelector('form#form_id_main');
                if (additionalBlock) {
                    handleTouristFields(additionalFields, additionalBlock);
                }
            }
        });
    }
    var touristBlocks = document.querySelectorAll('form  div[class="halfTab"]');
    doFill(touristBlocks, data.tourists);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_205.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_205.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_205__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/205 */ "./src/serverScripts/operators/205.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, tourUrl } = context;
        const loginUrl = 'https://online.amigo-tours.ru/MasterWebStandard/login.aspx';
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_205__WEBPACK_IMPORTED_MODULE_0__.AmigoTours);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: loginUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, _operators_205__WEBPACK_IMPORTED_MODULE_0__.AmigoTours.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_12__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_205__WEBPACK_IMPORTED_MODULE_0__.AmigoTours.packet
            }));
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_13__.wait)(5 * 1000);
            yield (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_9__.updateTabUrl)(tab, tourUrl);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'div.cart-tourist-item');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_13__.wait)(3000);
            const regExp = /online\.amigo\-tours\.ru\/dynamic\/order\/(\S{10})/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_11__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1].toUpperCase())
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                return true;
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'div.cart-tourist-list');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFilter, [{
                    tourists: data.autoFillerData.touristDataItems,
                    countyTo: data.countryTo
                }]);
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_13__.wait)(1000);
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'div.cabinet-top-row table > tbody > tr:nth-child(2) > td:nth-child(2)', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_205__WEBPACK_IMPORTED_MODULE_0__.AmigoTours, errorText: null });
        }
        catch (e) {
            console.log("фатальная ошибка");
            console.log(e);
            console.dir(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFilter(fillerData) {
    console.log('ClaimFilter AmigoTours');
    let mainChain = Promise.resolve();
    function wait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function fillText(block, touristField) {
        mainChain = mainChain.then(() => {
            const element = block.querySelector(touristField.htmlElementSelector);
            if (element
                && element.parentElement
                && element.parentElement.style
                && element.parentElement.style.display !== null
                && typeof (element.parentElement.style.display) !== 'undefined'
                && element.parentElement.style.display !== 'none'
                && touristField.value) {
                element.dispatchEvent(new FocusEvent('focus'));
                element.value = touristField.value;
                element.dispatchEvent(new InputEvent('input', { bubbles: true }));
                element.dispatchEvent(new Event('change', { bubbles: true }));
            }
        });
    }
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(touristItem => {
            switch (touristItem.fieldType) {
                case FieldType.Sex:
                    setSex(block, touristItem);
                    break;
                case FieldType.Text:
                    fillText(block, touristItem);
                    break;
                case FieldType.NotFilled:
                    NotFilledField(block, touristItem);
                    break;
                default: break;
            }
        });
        mainChain = mainChain.then(() => wait(100));
    }
    function setSex(block, touristField) {
        mainChain = mainChain.then(() => {
            var sexInputs = block.querySelectorAll(touristField.htmlElementSelector);
            switch (touristField.value) {
                case 1:
                case 3:
                case 5:
                    sexInputs[0].click();
                    break;
                case 2:
                case 4:
                case 6:
                    sexInputs[1].click();
                    break;
            }
        });
    }
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function setDocumentType(tourist, block) {
        mainChain = mainChain.then(() => {
            let optionIndex = -1;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(fillerData.countryTo.toUpperCase()) !== -1) {
                optionIndex = 1;
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = 0;
                }
                else {
                    optionIndex = 2;
                }
            }
            // (window as any).ko.dataFor(block.querySelector('select[data-bind^="selectPicker: documentType"]')).documentType(optionIndex);
        });
        mainChain = mainChain.then(() => wait(100));
    }
    function setCitizenship(tourist, block) {
        mainChain = mainChain.then(() => {
            try {
                const citizenships = {
                    'Россия': '7',
                    'Беларусь': '425',
                    'Украина': '439',
                    'Абхазия': '542'
                };
                if (tourist && tourist.citizenship && tourist.citizenship !== null) {
                    // (window as any)
                    // .ko
                    // .dataFor(block.querySelector('div[data-bind="validationElement:citizenCountryId"]'))
                    // //@ts-ignore
                    //     .citizenCountryId(citizenships[tourist.citizenship]);
                }
            }
            catch (e) {
                console.dir(e);
                console.dir(tourist);
                console.dir(block);
            }
        });
        mainChain = mainChain.then(() => wait(100));
    }
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
        FieldType[FieldType["Human"] = 6] = "Human";
        FieldType[FieldType["NotFilled"] = 7] = "NotFilled";
    })(FieldType || (FieldType = {}));
    function NotFilledField(touristBlock, touristField) {
        let block = touristBlock.querySelector(touristField.htmlElementSelector);
        let defaultSelectedValueDiv = touristBlock.querySelector(`${touristField.htmlElementSelector} span.filter-option`);
        if (defaultSelectedValueDiv && defaultSelectedValueDiv.innerText) {
            console.log(`defaultSelectedValueDiv = ${defaultSelectedValueDiv && defaultSelectedValueDiv.innerText}`);
            console.log(`touristField.value = ${touristField.value}`);
            if (defaultSelectedValueDiv.innerText === touristField.value) {
                return;
            }
        }
        if (block) {
            block.style.border = "10px solid red";
            block.style.borderRadius = '20px';
            if (touristField.value) {
                let div = document.createElement("div");
                div.style.textAlign = 'center';
                div.append(`--> ${touristField.value} <--`);
                block.appendChild(div);
            }
        }
    }
    function doFill(tourists, blocks, countryTo) {
        var tmpTouristsArray = [];
        var tmpChildTouristsArray = [];
        for (var i = 0; i < tourists.length; i++) {
            var tourist = tourists[i];
            if (getTouristAge(tourist) < 14) {
                tmpChildTouristsArray.push(tourist);
            }
            else {
                tmpTouristsArray[i] = tourist;
            }
        }
        tmpChildTouristsArray = tmpChildTouristsArray.reverse();
        tourists = tmpTouristsArray.concat(tmpChildTouristsArray);
        Array.prototype.forEach.call(blocks, (block, index) => {
            let tourist = tourists[index];
            const fields = [
                {
                    htmlElementSelector: `input[name="TouristsRealSex${index}"]`,
                    value: tourist.touristType,
                    fieldType: FieldType.Sex
                },
                {
                    htmlElementSelector: 'input[data-bind*="lastName"]',
                    value: tourist.surname,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="firstName"]',
                    value: tourist.name,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="middleName"]',
                    value: tourist.middlename,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="value:birthday"]',
                    value: tourist.birthday,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="russianPassportSeries"]',
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="russianPassportNumber"]',
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="russianPassportDate"]',
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="foreignPassportSeries"]',
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="foreignPassportNumber"]',
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="birthCertSerial"]',
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="birthCertNumber"]',
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[data-bind*="birthCertDate"]',
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'div.cart-tourist-document-t',
                    value: null,
                    fieldType: FieldType.NotFilled
                },
                {
                    htmlElementSelector: 'input[placeholder="Дата выдачи"]',
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input[placeholder="Действителен до"]',
                    value: tourist.passportExpireDate,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'div.cart-tourist-citizenship',
                    value: tourist.citizenshipName,
                    fieldType: FieldType.NotFilled
                }
            ];
            handleTouristFields(fields, block);
        });
    }
    doFill(fillerData.tourists, document.querySelectorAll('div.cart-tourist-item'), fillerData.countryTo);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_231.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_231.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _operators_231__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../operators/231 */ "./src/serverScripts/operators/231.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












// const loginUrl: string = 'https://www.multitour.ru/privateoffice';
// export function formFill(context: IClaimFillerContext): Promise<chrome.webNavigation.WebNavigationUrlCallbackDetails | void> {
//     const {
//         data,
//         secretField,
//         claimNumber,
//         sourceId,
//     } = context;
//     let { tourUrl } = context;
//     let navigateUrl = '';
//     let claimDetails: ClaimDetails;
//     let sourceTab: chrome.tabs.Tab;
//     if (tourUrl.indexOf('privateperson') !== -1) {
//         return Promise.resolve()
//         .then(() => new Promise( (resolve) => {
//             chrome.tabs.query({active: true, lastFocusedWindow: true}, (tabs: chrome.tabs.Tab[]) => {
//                 sourceTab = tabs[0];
//                 resolve();
//             });
//         }))
//         .then(() => {
//             claimDetails = {
//                 cityFrom: data.cityFrom,
//                 countryTo: data.countryTo,
//                 hotelName: data.hotelName,
//                 duration: data.duration,
//                 resort: data.resort,
//                 travelDate: data.travelDate
//             };
//             navigateUrl = tourUrl = handleNavigateUrl(tourUrl, MultiTour);
//             if (! /^(http|https):\/\/.*$/.test(navigateUrl) ) {
//                 navigateUrl = `http://${navigateUrl}`;
//             }
//             MultiTour.credentials!.login = data.login;
//             MultiTour.credentials!.password = data.password;
//             switch (MultiTour.authType) {
//                 case AuthTypes.BASIC:
//                     navigateUrl = insertUrlCreds(tourUrl, {
//                         username: MultiTour.credentials!.login,
//                         password: MultiTour.credentials!.password
//                     });
//                     break;
//                 case AuthTypes.FORMS:
//                     break;
//             }
//             let promise: Promise<void>;
//             if (MultiTour.cookie.userInfo) {
//                 promise = checkCookie({
//                     url: navigateUrl,
//                     cookieName: MultiTour.cookie.userInfo,
//                     searchValue: MultiTour.credentials!.login as string
//                 });
//             } else {
//                 promise = Promise.reject('');
//             }
//             return promise.then(
//                 () => console.log('Уже авторизованы под нужным пользователем.'),
//                 () => removeCookies({
//                     url: navigateUrl,
//                     cookieNames: MultiTour.cookie.auth
//                 })).then(() => createTab({
//                     active: true,
//                     url: navigateUrl,
//                     windowId: chrome.windows.WINDOW_ID_CURRENT
//             }));
//         })
//         .then((tab: chrome.tabs.Tab) => {
//             const autofillData = {
//                 behaviorType: 'form_fill',
//                 token: secretField,
//                 claimNumber: claimNumber,
//                 operatorId: sourceId,
//                 bookingCompanyId: data.bookingCompanyId,
//             };
//             const t = tab;
//             const listener = (tabId: number, info: chrome.tabs.TabChangeInfo) => {
//                 if (t && info.status === 'complete' && tabId === t.id) {
//                     setSessionStorageKeyInTab(t, 'autofill-data', JSON.stringify(autofillData));
//                     chrome.tabs.onUpdated.removeListener(listener);
//                 }
//             };
//             chrome.tabs.onUpdated.addListener(listener);
//             const fillerContext = {
//                 tab: tab,
//                 data: data.autoFillerData,
//                 claimNumber: claimNumber,
//                 sourceId: sourceId,
//                 navigateUrl: navigateUrl,
//                 autofillData: autofillData,
//                 claimDetails: claimDetails,
//                 sourceTab: sourceTab,
//             };
//             return createTabAndDeleteCookies(MultiTour, loginUrl, {
//                 login: data.login,
//                 password: data.password,
//             })
//             .then((data: {tab: chrome.tabs.Tab, navigate_url: string}) => {
//                 return navigateToClaimPage(data.tab, MultiTour, MultiTour.credentials!.packet)
//                     .then(() => delay(1000))
//                     .then(() => Promise.race(
//                         MultiTour.cookie.auth.map((cookie) => startTrackingCookie({
//                             url: data.navigate_url,
//                             cookieName: cookie,
//                         }))
//                     ))
//                     .then(() => {
//                         chrome.tabs.remove(data.tab.id as number);
//                     })
//                     .then(() => {
//                         chrome.tabs.update(tab.id as number, {
//                             active: true,
//                             highlighted: true,
//                         });
//                     })
//                     .then(() => chrome.tabs.reload(tab.id as number))
//                     .then(() => delay(3 * 1000));
//             })
//             .then(() => startTrackingElement(tab, 'form#form-booking div.bron-uslugi-block2 table.tablebron1.tablebron_mobile'))
//             .then(() => {
//                 const code: string = stringifyFn(PrivatePersonClaimFilter, fillerContext.data.touristDataItems);
//                 // console.log('claimFilter:\n');
//                 // console.log(code);
//                 return executeScriptInTab(tab, {code : code});
//             })
//             .then(() => createPushNotification({ claimId: fillerContext.claimNumber, operator: MultiTour, errorText: null}))
//             .then(() => startTrackingIdSelectorWithClaimNumberValidation(tab, 'div.title-h.float-l > span', fillerContext.claimNumber))
//             .then((response: any) => sendIdsToBookingCenter(fillerContext.claimNumber, getToNumber(response.claimNo)))
//             .then((response: string) => createPushNotification({ status: SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }))
//             .catch((error: Error) => createPushNotification({ status: SendIdsStatus.FAIL, message: error.message }));
//         });
//     } else {
//         return Promise.resolve()
//         .then(() => {
//             claimDetails = {
//                 cityFrom: data.cityFrom,
//                 countryTo: data.countryTo,
//                 hotelName: data.hotelName,
//                 duration: data.duration,
//                 resort: data.resort,
//                 travelDate: data.travelDate
//             };
//             navigateUrl = tourUrl = handleNavigateUrl(tourUrl, MultiTour);
//             if (! /^(http|https):\/\/.*$/.test(navigateUrl) ) {
//                 navigateUrl = `http://${navigateUrl}`;
//             }
//             MultiTour.credentials!.login = data.login;
//             MultiTour.credentials!.password = data.password;
//             switch (MultiTour.authType) {
//                 case AuthTypes.BASIC:
//                     navigateUrl = insertUrlCreds(tourUrl, {
//                         username: MultiTour.credentials!.login,
//                         password: MultiTour.credentials!.password
//                     });
//                     break;
//                 case AuthTypes.FORMS:
//                     break;
//             }
//             let promise: Promise<void>;
//             if (MultiTour.cookie.userInfo) {
//                 promise = checkCookie({
//                     url: navigateUrl,
//                     cookieName: MultiTour.cookie.userInfo,
//                     searchValue: MultiTour.credentials!.login as string
//                 });
//             } else {
//                 promise = Promise.reject('');
//             }
//             return promise.then(
//                 () => console.log('Уже авторизованы под нужным пользователем.'),
//                 () => removeCookies({
//                     url: navigateUrl,
//                     cookieNames: MultiTour.cookie.auth
//                 }))
//                 .then(() => createTab({
//                     active: true,
//                     url: navigateUrl,
//                     windowId: chrome.windows.WINDOW_ID_CURRENT
//                 }));
//         })
//         .then((tab: chrome.tabs.Tab) => {
//             const autofillData = {
//                 behaviorType: 'form_fill',
//                 token: secretField,
//                 claimNumber: claimNumber,
//                 operatorId: sourceId,
//                 bookingCompanyId: data.bookingCompanyId,
//             };
//             const t = tab;
//             const listener = (tabId: number, info: chrome.tabs.TabChangeInfo) => {
//                 if (t && info.status === 'complete' && tabId === t.id) {
//                     setSessionStorageKeyInTab(t, 'autofill-data', JSON.stringify(autofillData));
//                     chrome.tabs.onUpdated.removeListener(listener);
//                 }
//             };
//             chrome.tabs.onUpdated.addListener(listener);
//             const fillerContext = {
//                 tab: tab,
//                 data: data.autoFillerData,
//                 claimNumber: claimNumber,
//                 sourceId: sourceId,
//                 navigateUrl: navigateUrl,
//                 autofillData: autofillData,
//                 claimDetails: claimDetails,
//                 sourceTab: sourceTab,
//             };
//             return navigateToClaimPage(fillerContext.tab, MultiTour, MultiTour.credentials!.packet)
//             .then(() => startTrackingElement(tab, 'form#form-booking div.bron-uslugi-block2 table.tablebron1, form#booking-form div.bron-uslugi-block2 table.tablebron1'))
//             .then(() => {
//                 const code: string = stringifyFn(ClaimFilter, fillerContext.data.touristDataItems);
//                 // console.log('claimFilter:\n');
//                 // console.log(code);
//                 return executeScriptInTab(tab, {code : code});
//             })
//             .then(() => createPushNotification({ claimId: fillerContext.claimNumber, operator: MultiTour, errorText: null}))
//             .then(() => startTrackingIdSelectorWithClaimNumberValidation(tab, 'div.title-h.float-l > span', fillerContext.claimNumber))
//             .then((response: any) => sendIdsToBookingCenter(fillerContext.claimNumber, getToNumber(response.claimNo)))
//             .then((response: string) => createPushNotification({ status: SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }))
//             .catch((error: Error) => createPushNotification({ status: SendIdsStatus.FAIL, message: error.message }));
//         });
//     }
// }
function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_8__.removeCookiesForTouroperator)(_operators_231__WEBPACK_IMPORTED_MODULE_11__.MultiTour);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_5__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, _operators_231__WEBPACK_IMPORTED_MODULE_11__.MultiTour.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_231__WEBPACK_IMPORTED_MODULE_11__.MultiTour.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, 'form#form-booking');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_3__.wait)(3000);
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__.executeScriptInTabV3)(tab, ClaimFilter, [{
                    tourists: data.autoFillerData.touristDataItems
                }]);
            var responce = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_10__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'div.title-h.float-l > span', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__.sendIdsToBookingCenter)(claimNumber, getToNumber(responce.claimNo));
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ claimId: claimNumber, operator: _operators_231__WEBPACK_IMPORTED_MODULE_11__.MultiTour, errorText: null });
        }
        catch (e) {
            console.log("фатальная ошибка");
            console.log(e);
            console.dir(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function getToNumber(claimNo) {
    const dataMatch = claimNo.match(/(\D)(№\s{1})(\S*)/);
    if (dataMatch && dataMatch.length >= 3) {
        return dataMatch[3];
    }
    else {
        return '';
    }
}
// function PrivatePersonClaimFilter(data: Array<Tourist>) {
//     const buttonTeg: HTMLButtonElement = document.createElement('button') as HTMLButtonElement;
//     buttonTeg.id = 'autoFillButton';
//     buttonTeg.setAttribute('onClick', 'doFillScript()');
//     document.body.appendChild(buttonTeg);
//     const scriptTeg: HTMLScriptElement = document.createElement('script') as HTMLScriptElement;
//     scriptTeg.id = 'autoFillScript';
//     scriptTeg.innerHTML = `
//         function doFillScript() {
//             var data = ${JSON.stringify(data)};
//             ${handleTouristFields.toString()}
//             ${setOptionSelected.toString()}
//             ${setSex.toString()}
//             ${setCitizenshipSelect.toString()}
//             ${doFill.toString()}
//             doFill(data);
//         }
//     `;
//     document.body.appendChild(scriptTeg);
//     (document.querySelector('#autoFillButton') as HTMLButtonElement).click();
//     function handleTouristFields(touristFields: TouristFieldElement[]) {
//         touristFields.forEach(touristItem => {
//             const element = document.querySelector(touristItem.htmlElementSelector) as HTMLInputElement;
//             if (element) {
//                 // element.dispatchEvent(new Event('focus'));
//                 element.value = touristItem.value as string;
//                 // element.dispatchEvent(new Event('input'));
//                 // element.dispatchEvent(new Event('change'));
//                 element.dispatchEvent(new Event('blur'));
//             }
//         });
//     }
//     function setOptionSelected(pattern: string, options: HTMLOptionsCollection): void {
//         for (let i = 0; i < options.length; i++) {
//             const option: HTMLOptionElement = options[i];
//             if (option && option.textContent && option.textContent.trim().toLowerCase() === pattern.trim().toLowerCase()) {
//                 option.selected = true;
//                 break;
//             }
//         }
//     }
//     function setSex(sexSelector: string, tourist: Tourist) {
//         const sexSelect: HTMLSelectElement = document.querySelector(sexSelector) as HTMLSelectElement;
//         if (sexSelect) {
//             switch (tourist.touristType) {
//                 case 1: { setOptionSelected('М', sexSelect.options); break; }
//                 case 2: { setOptionSelected('Ж', sexSelect.options); break; }
//                 case 3: { setOptionSelected('Реб-М', sexSelect.options); break; }
//                 case 4: { setOptionSelected('Реб-Ж', sexSelect.options); break; }
//                 case 5: { setOptionSelected('Млад-М', sexSelect.options); break; }
//                 case 6: { setOptionSelected('Млад-Ж', sexSelect.options); break; }
//             }
//         }
//     }
//     function setCitizenshipSelect(selector: string, tourist: Tourist) {
//         const citizenSelect: HTMLSelectElement = document.querySelector(selector) as HTMLSelectElement;
//         if (citizenSelect) {
//             setOptionSelected(tourist.citizenshipName || '', citizenSelect.options);
//         }
//     }
//     function doFill(data: Array<Tourist>) {
//         Array.prototype.forEach.call(data, (tourist: Tourist, index: number) => {
//             // console.dir(tourist);
//             const fields: TouristFieldElement[] = [{
//                 htmlElementSelector: `input[name="service[0][persons][${index}][surname]"]`,
//                 value: tourist.surname
//             }, {
//                 htmlElementSelector: `input[name="service[0][persons][${index}][firstname]"]`,
//                 value: tourist.name
//             }, {
//                 htmlElementSelector: `input[name="service[0][persons][${index}][middlename]"]`,
//                 value: tourist.middlename
//             }, {
//                 htmlElementSelector: `input[name="service[0][persons][${index}][birthday]"]`,
//                 value: tourist.birthday
//             }, {
//                 htmlElementSelector: `input[name="service[0][persons][${index}][passports]"]`,
//                 value: tourist.passportSeries
//             }, {
//                 htmlElementSelector: `input[name="service[0][persons][${index}][passportn]"]`,
//                 value: tourist.passportNumber
//             }, {
//                 htmlElementSelector: `input[name="service[0][persons][${index}][passportdate]"]`,
//                 value: tourist.passportExpireDate
//             }, {
//                 htmlElementSelector: `input[name="service[0][persons][${index}][tel]"]`,
//                 value: tourist.phone
//             }];
//             handleTouristFields(fields);
//             setSex(`select[name="service[0][persons][${index}][sex]"]`, tourist);
//             setCitizenshipSelect(`select[name="service[0][persons][${index}][citizen]"]`, tourist);
//         });
//     }
// }
function ClaimFilter(data) {
    function handleTouristFields(touristFields) {
        touristFields.forEach(touristItem => {
            const element = document.querySelector(touristItem.htmlElementSelector);
            if (element) {
                // element.dispatchEvent(new Event('focus'));
                element.value = touristItem.value;
                // element.dispatchEvent(new Event('input'));
                // element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('blur'));
            }
        });
    }
    function setOptionSelected(pattern, options) {
        for (let i = 0; i < options.length; i++) {
            const option = options[i];
            if (option && option.textContent && option.textContent.trim().toLowerCase() === pattern.trim().toLowerCase()) {
                option.selected = true;
                break;
            }
        }
    }
    function setSex(sexSelector, tourist) {
        const sexSelect = document.querySelector(sexSelector);
        if (sexSelect) {
            switch (tourist.touristType) {
                case 1: {
                    setOptionSelected('М', sexSelect.options);
                    break;
                }
                case 2: {
                    setOptionSelected('Ж', sexSelect.options);
                    break;
                }
                case 3: {
                    setOptionSelected('Реб-М', sexSelect.options);
                    break;
                }
                case 4: {
                    setOptionSelected('Реб-Ж', sexSelect.options);
                    break;
                }
                case 5: {
                    setOptionSelected('Млад-М', sexSelect.options);
                    break;
                }
                case 6: {
                    setOptionSelected('Млад-Ж', sexSelect.options);
                    break;
                }
            }
        }
    }
    function setCitizenshipSelect(selector, tourist) {
        const citizenSelect = document.querySelector(selector);
        if (citizenSelect) {
            setOptionSelected(tourist.citizenshipName || '', citizenSelect.options);
        }
    }
    function doFill(data) {
        Array.prototype.forEach.call(data, (tourist, index) => {
            // console.dir(tourist);
            const fields = [{
                    htmlElementSelector: `input[name="service[0][persons][${index}][surname]"]`,
                    value: tourist.surname
                }, {
                    htmlElementSelector: `input[name="service[0][persons][${index}][firstname]"]`,
                    value: tourist.name
                }, {
                    htmlElementSelector: `input[name="service[0][persons][${index}][middlename]"]`,
                    value: tourist.middlename
                }, {
                    htmlElementSelector: `input[name="service[0][persons][${index}][birthday]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="service[0][persons][${index}][passports]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="service[0][persons][${index}][passportn]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="service[0][persons][${index}][passportdate]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="service[0][persons][${index}][tel]"]`,
                    value: tourist.phone.replace('+', '')
                }];
            handleTouristFields(fields);
            setSex(`select[name="service[0][persons][${index}][sex]"]`, tourist);
            setCitizenshipSelect(`select[name="service[0][persons][${index}][citizen]"]`, tourist);
        });
    }
    doFill(data.tourists);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_252.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_252.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_252__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/252 */ "./src/serverScripts/operators/252.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_252__WEBPACK_IMPORTED_MODULE_0__.Alean);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: 'https://www.alean.ru/agency/cabinet/login',
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, _operators_252__WEBPACK_IMPORTED_MODULE_0__.Alean.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_11__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_252__WEBPACK_IMPORTED_MODULE_0__.Alean.credentials.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'div.hat-logo a.hat-logoLink');
            const regExp = /alean\.ru\/agency\/booking\/\?ksbtid\S+/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_9__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(updatedTab, 'form.bookingTouristsForm')
                    .then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_12__.wait)(5 * 1000))
                    .then(() => (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [{
                        tourists: data.autoFillerData.touristDataItems,
                        customer: data.autoFillerData.customer,
                        countryTo: data.countryTo,
                    }]));
                return true;
            });
            yield (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_8__.updateTabUrl)(tab, tourUrl);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'div.hat-logo a.hat-logoLink');
            const regExpForTONumber = /alean\.ru\/agency\/cabinet\/\#\!\/orderbook\/(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_9__.updateListenerOnSpecificPage)(tab.id, regExpForTONumber, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExpForTONumber);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                return true;
            });
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_252__WEBPACK_IMPORTED_MODULE_0__.Alean, errorText: null });
        }
        catch (e) {
            console.log("фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('Alean claimFiller');
    debugger;
    function doFill(data) {
        function toUpperCase(input) {
            if (!input || input === '') {
                return '';
            }
            return input.toUpperCase().replaceAll('-', '').replaceAll(' ', '');
        }
        function handleTouristFields(block, touristFields) {
            if (!block)
                return;
            touristFields.forEach(field => {
                var input = block.querySelector(field.htmlElementSelector);
                if (input && field.value) {
                    input.dispatchEvent(new Event('focus', { bubbles: true }));
                    input.value = field.value;
                    input.dispatchEvent(new Event('input', { bubbles: true }));
                    input.dispatchEvent(new Event('keypress', { bubbles: true }));
                    input.dispatchEvent(new Event('change', { bubbles: true }));
                    input.dispatchEvent(new Event('blur', { bubbles: true }));
                }
            });
        }
        ;
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(index, tourist, countryTo) {
            let valueToSet = null;
            var selectInput = document.querySelector(`select#document-select-${index + 1}`);
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                valueToSet = 'BIRTH_CERTIFICATE';
            }
            else {
                if (tourist.isNationalPassport) {
                    valueToSet = 'PASSPORT';
                }
                else {
                    valueToSet = 'FOREIGN_PASSPORT';
                }
            }
            if (selectInput) {
                selectInput.value = valueToSet;
                selectInput.dispatchEvent(new Event('change', { bubbles: true }));
            }
        }
        function setSex(index, tourist) {
            let valueToSet = null;
            var selectInput = document.querySelector(`select#gender-${index + 1}`);
            if (selectInput) {
                switch (tourist.touristType) {
                    case 1:
                    case 3:
                    case 5:
                        selectInput.value = 'MALE';
                        break;
                    case 2:
                    case 4:
                    case 6:
                        selectInput.value = 'FEMALE';
                        break;
                }
                selectInput.dispatchEvent(new Event('change', { bubbles: true }));
            }
        }
        var touristBlocks = document.querySelectorAll('div.bookingTouristsForm-item');
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            var touristIndex = index + 1;
            if (!tourist) {
                return;
            }
            setDocumentType(index, tourist, data.countryTo);
            setSex(index, tourist);
            const touristFields = [{
                    htmlElementSelector: `input#surname-latin-${touristIndex}`,
                    value: toUpperCase(tourist.surnameEng)
                }, {
                    htmlElementSelector: `input#surname-${touristIndex}`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input#name-latin-${touristIndex}`,
                    value: toUpperCase(tourist.nameEng)
                }, {
                    htmlElementSelector: `input#name-${touristIndex}`,
                    value: toUpperCase(tourist.name)
                }, {
                    htmlElementSelector: `input#midname-${touristIndex}`,
                    value: toUpperCase(tourist.middlename)
                }, {
                    htmlElementSelector: `input#midname-latin-${touristIndex}`,
                    value: toUpperCase(tourist.middleNameEng)
                }, {
                    htmlElementSelector: `input#birthdate-${touristIndex}`,
                    value: toUpperCase(tourist.birthday)
                }, {
                    htmlElementSelector: `input#passport-${touristIndex}`,
                    value: toUpperCase(`${tourist.passportSeries.replace('-', '')}${tourist.passportNumber}`)
                }, {
                    htmlElementSelector: `input#date-issue-${touristIndex}`,
                    value: toUpperCase(`${tourist.passportDate}`)
                }];
            handleTouristFields(block, touristFields);
        });
        handleTouristFields(document.querySelector('form.bookingTouristsContactsForm'), [
            {
                htmlElementSelector: `input#contacts-phone`,
                value: data.customer.phone
            }, {
                htmlElementSelector: `input#contacts-email`,
                value: data.customer.email
            }
        ]);
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_3.ts":
/*!**************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_3.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_checkCookieExistence__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/checkCookieExistence */ "./src/app/utils/chunks/checkCookieExistence.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { data, claimNumber, } = context;
        let tourUrl = context.tourUrl;
        try {
            // await removeCookies({
            //     url: 'https://agency.pegast.ru',
            //     cookieNames: ['.AspNetCore.Cookies']
            // });
            // await removeCookies({
            //     url: 'https://pegast-px.global.sletat.ru',
            //     cookieNames: ['.AspNetCore.Cookies']
            // });
            if (tourUrl && tourUrl.indexOf('{{STAYAWAY}}') === -1) {
                tourUrl = tourUrl.replace('agency.pegast.ru', 'pegast-px.global.sletat.ru');
                // let tempTab: chrome.tabs.Tab = await createTab({
                //     active: true,
                //     url: 'https://admin:password@pegast-px.global.sletat.ru',
                //     windowId: chrome.windows.WINDOW_ID_CURRENT
                // });
                // await startTrackingElement(tempTab, 'a.top__logo-img');
                // await removeTab(tempTab);
                // await wait(1000);
            }
            else {
                tourUrl = tourUrl.replace('{{STAYAWAY}}', '');
            }
            let cookie = yield (0,_app_utils_chunks_checkCookieExistence__WEBPACK_IMPORTED_MODULE_9__.checkCookieExistence)({
                url: 'https://pegast-px.global.sletat.ru',
                cookieName: '.AspNetCore.Cookies'
            });
            // let cookieTx = await checkCookieExistence({
            //     url: 'https://agency.pegast.ru',
            //     cookieName: '.AspNetCore.Cookies'
            // });
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_0__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            if (!cookie || cookie === '') {
                yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_1__.startTrackingElement)(tab, 'form.auth-form__form');
                yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_8__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_6__.PageSelectors({
                    login: data.login,
                    password: data.password,
                    // login: 'Trmarket',      // data.login,
                    // password: 'FEFhFKj1',   // data.password,
                    packet: {
                        loginPath: "form input#input_1",
                        passwordPath: "form input#input_2",
                        submitPath: "form button#auth-submit-button"
                    }
                }));
            }
            // @ts-ignore
            (_a = data.autoFillerData.customer) === null || _a === void 0 ? void 0 : _a.eVoucherClaimNumber = data.eVoucherClaimNumber;
            // @ts-ignore
            (_b = data.autoFillerData.customer) === null || _b === void 0 ? void 0 : _b.eVoucherCurrency = data.eVoucherCurrency;
            // @ts-ignore
            (_c = data.autoFillerData.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
            try {
                // @ts-ignore
                (_d = data.autoFillerData.customer) === null || _d === void 0 ? void 0 : _d.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
            }
            catch (e) { }
            const regExp = /(agency\.pegast\.ru)|(pegast\-px\.global\.sletat\.ru)\/MyAccount\/Bookings\/(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_7__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                debugger;
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 4) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_3__.sendIdsToBookingCenter)(claimNumber, parsedUrl[3])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_4__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                return true;
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_1__.startTrackingElement)(tab, 'div.booking-persons-list__wrapper');
            var fillerParams = {
                tourists: data.autoFillerData.touristDataItems,
                customer: data.autoFillerData.customer,
                countryTo: data.countryTo,
                bookingCompanyId: data.bookingCompanyId
            };
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTabV3)(tab, claimFiller, [fillerParams]);
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_10__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'div.bookings-edit__wrapper span.format-number', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_3__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_4__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' });
        }
        catch (e) {
            console.log("Pegas фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_4__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function wait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function waitForFormLoad(touristBlock) {
        return new Promise((resolve, reject) => {
            if (touristBlock) {
                var formButton = touristBlock.querySelector('button.tool-bn');
                if (formButton) {
                    formButton.click();
                    resolve();
                }
            }
            reject();
        })
            .then(() => wait(300), () => console.log('Либо туриста не нашли, либо кнопку открытия формы'))
            .then(() => new Promise((resolve, reject) => {
            const timer = setInterval(() => {
                if (document.querySelector('div#person-edit-dialog___BV_modal_content_')) {
                    clearInterval(timer);
                    resolve();
                }
            }, 600);
        }));
    }
    function handleTouristFields(fields) {
        Array.prototype.forEach.call(fields, (field, index) => {
            var htmlFiled = document.querySelector(field.htmlElementSelector);
            if (htmlFiled) {
                htmlFiled.dispatchEvent(new Event('focus', { bubbles: true }));
                htmlFiled.value = field.value;
                htmlFiled.dispatchEvent(new Event('input', { bubbles: true }));
                htmlFiled.dispatchEvent(new Event('keypress', { bubbles: true }));
                htmlFiled.dispatchEvent(new Event('change', { bubbles: true }));
                htmlFiled.dispatchEvent(new Event('blur', { bubbles: true }));
            }
        });
    }
    function fillTouristFields(fields) {
        return new Promise((res, rej) => { handleTouristFields(fields); res(); });
    }
    function searchForCitizenshipLi(country, lis) {
        if (country === null)
            return null;
        var result = null;
        Array.prototype.forEach.call(lis, (li, index) => {
            var divCountry = li.querySelector('div div');
            if (divCountry && divCountry.innerText) {
                var liCountry = divCountry.innerText;
                if (liCountry.trim().toUpperCase() === country.trim().toUpperCase()) {
                    result = li;
                }
            }
        });
        return result;
    }
    function setCitizenship(tourist) {
        return new Promise((res, rej) => {
            var citizenshipDDbutton = document.querySelector('div.change-person-citizenship button.dropdown__button');
            if (citizenshipDDbutton) {
                citizenshipDDbutton.click();
                res();
            }
            rej();
        })
            .then(() => wait(200), () => console.log('div.change-person-citizenship не обнаружился'))
            .then(() => new Promise((res, rej) => {
            var citizenshipButtons = document.querySelectorAll('div.dropdown__popper.dropdown__popper--single-select ul.single-select__list li.single-select__item');
            if (citizenshipButtons && citizenshipButtons.length > 1) {
                var liToClick = searchForCitizenshipLi(tourist.citizenshipName, citizenshipButtons);
                if (liToClick) {
                    liToClick.click();
                }
                res();
            }
            rej();
        }));
    }
    function fillSex(tourist) {
        return new Promise((res, rej) => {
            var sexDDbutton = document.querySelector('div[data-qa="gender"] button.dropdown__button');
            if (sexDDbutton) {
                sexDDbutton.click();
                res();
            }
            rej();
        })
            .then(() => wait(100), () => console.log('data-qa=gender не обнаружился'))
            .then(() => new Promise((res, rej) => {
            var sexButtons = document.querySelectorAll('div.dropdown__popper.dropdown__popper--single-select ul.single-select__list li.single-select__item');
            if (sexButtons && sexButtons.length > 1) {
                switch (tourist.touristType) {
                    case 1:
                    case 3:
                    case 5:
                        sexButtons[0].click();
                        break;
                    case 2:
                    case 4:
                    case 6:
                        sexButtons[1].click();
                        break;
                }
                res();
            }
            rej();
        }));
    }
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function setDocType(tourist, countryTo) {
        return new Promise((res, rej) => {
            var docTypeDDbutton = document.querySelector('div.change-person-traveldocumenttype button.dropdown__button');
            if (docTypeDDbutton) {
                docTypeDDbutton.click();
                res();
            }
            rej();
        })
            .then(() => wait(100), () => console.log('div.change-person-traveldocumenttype не обнаружился'))
            .then(() => new Promise((res, rej) => {
            var docTypeButtons = document.querySelectorAll('div.dropdown__popper.dropdown__popper--single-select ul.single-select__list li.single-select__item');
            if (docTypeButtons && docTypeButtons.length > 2) {
                if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                    docTypeButtons[2].click();
                }
                else {
                    if (tourist.isNationalPassport) {
                        docTypeButtons[0].click();
                    }
                    else {
                        docTypeButtons[1].click();
                    }
                }
                res();
            }
            rej();
        }));
    }
    function clickSaveButton() {
        return new Promise((res, rej) => {
            var buttonToClick = document.querySelector('div#person-edit-dialog___BV_modal_content_ button[data-qa="primary-button"]');
            if (buttonToClick) {
                buttonToClick.click();
            }
            else {
                console.log('Кнопка сохранения не нашлась');
            }
            res();
        });
    }
    function fillCustomer() {
        return new Promise((res, rej) => {
            var customerButton = document.querySelector('button.js-who-is-customer-button');
            if (customerButton) {
                customerButton.click();
                res();
            }
            rej();
        })
            .then(() => wait(100))
            .then(() => {
            if (!data.customer)
                return Promise.resolve();
            var firstPortionfields = [{
                    htmlElementSelector: 'form.js-who-is-customer-container input[data-qa="private-customer-last-name"]',
                    value: data.customer.surname || data.customer.surnameRus || data.customer.surnameEng || ''
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container input[data-qa="private-customer-first-name"]',
                    value: data.customer.name || data.customer.nameRus || data.customer.nameEng || ''
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container input[data-qa="private-customer-middle-name"]',
                    value: data.customer.middleNameRus || data.customer.middleNameEng || data.customer.middlename || ''
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container div[data-qa="private-customer-date-of-birth"] input',
                    value: data.customer.birthday
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container input[data-qa="private-customer-phone"]',
                    value: '89967883622' //data.customer.phone
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container input[data-qa="private-customer-email"]',
                    value: 'tver11@solncetur.com' //data.customer.email
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container textarea[data-qa="private-customer-address"]',
                    value: data.customer.address || ''
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container input[data-qa="private-customer-document-number"]',
                    value: `${data.customer.passportSeries} ${data.customer.passportNumber}`
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container textarea[data-qa="private-customer-document-issuer-name"]',
                    value: data.customer.passportIssueOrg || ''
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container input[data-qa="private-customer-document-issuer-code"]',
                    value: data.customer.passportIssueCode || ''
                }, {
                    htmlElementSelector: 'form.js-who-is-customer-container div[data-qa="private-customer-document-issue-date"] input',
                    value: data.customer.passportDate
                }];
            return fillTouristFields(firstPortionfields);
        });
    }
    function insuranceFill() {
        var smallChain = Promise.resolve();
        smallChain = smallChain.then(() => {
            var expandButton = document.querySelector('button.booking-insurance-services-list__item-expand-button');
            if (expandButton) {
                expandButton.click();
            }
        });
        smallChain = smallChain.then(() => wait(100));
        var touristInsButtons = document.querySelectorAll('div.booking-insurance-services-list__content button.tool-bn');
        if (touristInsButtons) {
            Array.prototype.forEach.call(touristInsButtons, (touristInsButton, index) => {
                smallChain = smallChain.then(() => {
                    touristInsButton.click();
                });
                smallChain = smallChain.then(() => wait(1500));
                smallChain = smallChain.then(() => {
                    var insList = document.querySelector('div.ins-header__list button.dropdown__button');
                    if (insList) {
                        insList.click();
                    }
                });
                smallChain = smallChain.then(() => wait(300));
                smallChain = smallChain.then(() => {
                    var ddItems = document.querySelectorAll('div.dropdown__popper.dropdown__popper--single-select ul.single-select__list li.single-select__item');
                    Array.prototype.forEach.call(ddItems, (ddItem, index) => {
                        var innerDiv = ddItem.querySelector('div.single-select__element div');
                        if (innerDiv) {
                            var innerHtml = innerDiv.innerHTML;
                            if (innerHtml.toUpperCase().indexOf('"ПОЛНОЕ ПОКРЫТИЕ"') != -1) {
                                innerDiv.click();
                            }
                        }
                    });
                });
                smallChain = smallChain.then(() => wait(700));
                smallChain = smallChain.then(() => {
                    var saveButton = document.querySelector('button.save-btn');
                    if (saveButton) {
                        saveButton.click();
                    }
                });
                smallChain = smallChain.then(() => wait(800));
            });
            return smallChain;
        }
    }
    function checkStringForRepeats(a, b) {
        a = a.replace(' ', '');
        if (a === b.repeat(a.length))
            return true;
        return false;
    }
    function checkDocs(tourist) {
        for (var i = 0; i <= 9; i++) {
            if (checkStringForRepeats(tourist.passportNumber || '', i.toString())) {
                return true;
            }
        }
    }
    function findAndClickOnNoContactCheckbox() {
        return new Promise((res, rej) => {
            var divCheckboxes = document.querySelectorAll('form div.checkbox');
            if (divCheckboxes && divCheckboxes.length > 0) {
                divCheckboxes.forEach((checkBox, index) => {
                    var label = checkBox.querySelector('label');
                    if (label && label.innerText && label.innerText.toUpperCase().indexOf('КОНТАКТНЫЕ ДАННЫЕ') !== -1) {
                        if (checkBox.childNodes && checkBox.childNodes.length !== 0 && checkBox.childNodes[0]) {
                            checkBox.childNodes[0].click();
                        }
                    }
                });
            }
            res();
        });
    }
    var touristBlocks = document.querySelectorAll('div.booking-persons-list__content div.booking-persons-list__item');
    var chain = Promise.resolve();
    var isAbhazia = data.countryTo.toUpperCase() === "АБХАЗИЯ" || data.countryTo.toUpperCase() === "РОССИЯ";
    Array.prototype.forEach.call(touristBlocks, (touristBlock, index) => {
        var tourist = data.tourists[index];
        var firstPortionfields = [{
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[data-qa=change-person-last-name]',
                value: isAbhazia ? (tourist.surnameEng || '') : (tourist.surname || '')
            }, {
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[data-qa=change-person-first-name]',
                value: isAbhazia ? (tourist.nameEng || '') : (tourist.name || '')
            }, {
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[data-qa=change-person-middle-name]',
                value: isAbhazia ? (tourist.middleNameEng || '') : (tourist.middlename || '')
            }, {
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[placeholder="Дата рождения"]',
                value: tourist.birthday
            }];
        var passportData = [{
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[data-qa=change-person-passport-number]',
                value: tourist.passportSeries && `${tourist.passportSeries.replace('-', '')}${tourist.passportNumber}`
            }, {
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[placeholder="Документ выдан"]',
                value: tourist.passportDate
            }, {
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[placeholder="Действителен до"]',
                value: tourist.passportExpireDate || '01.01.2030'
            }, {
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[data-qa=travel-document-issuer-input]',
                value: tourist.passportIssueOrg || ''
            }];
        var secondPortionfields = [{
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[data-qa=phone-input]',
                value: tourist.phone || ''
            }, {
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[data-qa=cell-phone-input]',
                value: tourist.phone || ''
            }, {
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[data-qa=email-input]',
                value: tourist.email || ''
            }, {
                htmlElementSelector: 'div#person-edit-dialog___BV_modal_content_ input[data-qa=address-input]',
                value: tourist.address || ''
            }];
        chain = chain.then(() => waitForFormLoad(touristBlock));
        chain = chain.then(() => wait(600));
        chain = chain.then(() => fillTouristFields(firstPortionfields));
        chain = chain.then(() => wait(600));
        chain = chain.then(() => fillSex(tourist));
        chain = chain.then(() => wait(600));
        chain = chain.then(() => setCitizenship(tourist));
        chain = chain.then(() => wait(600));
        if (checkDocs(tourist)) {
            chain = chain.then(() => new Promise((res, rej) => {
                document.querySelector('div#person-edit-dialog___BV_modal_content_ div[data-qa="change-person-travel-document-not-provided"] input').click();
                res();
            }));
            chain = chain.then(() => wait(400));
            chain = chain.then(() => new Promise((res, rej) => {
                document.querySelector('div[data-qa="documents-not-provided-dialog-confirm"] input').click();
                res();
            }));
            chain = chain.then(() => wait(400));
            chain = chain.then(() => new Promise((res, rej) => {
                document.querySelector('button[data-qa="documents-not-provided-dialog-confirm-proceed"]').click();
                res();
            }));
        }
        else {
            chain = chain.then(() => setDocType(tourist, data.countryTo));
            chain = chain.then(() => wait(600));
            chain = chain.then(() => fillTouristFields(passportData));
        }
        chain = chain.then(() => wait(300));
        if (!tourist.phone || tourist.phone === '' || tourist.phone.replace('+7', '') === '') {
            chain = chain.then(() => findAndClickOnNoContactCheckbox());
        }
        else {
            chain = chain.then(() => fillTouristFields(secondPortionfields));
        }
        chain = chain.then(() => wait(600));
        chain = chain.then(() => clickSaveButton());
        chain = chain.then(() => wait(1500));
        //chain = chain.then(() => waitForTouristFormClosing());
    });
    chain = chain.then(() => fillCustomer());
    chain = chain.then(() => insuranceFill());
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_302.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_302.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/moveEvoucherDataToCustomer */ "./src/app/utils/chunks/moveEvoucherDataToCustomer.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _operators_302__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../operators/302 */ "./src/serverScripts/operators/302.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__.removeCookiesForTouroperator)(_operators_302__WEBPACK_IMPORTED_MODULE_13__.Premiera);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_5__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__.startTrackingElement)(tab, _operators_302__WEBPACK_IMPORTED_MODULE_13__.Premiera.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_302__WEBPACK_IMPORTED_MODULE_13__.Premiera.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_3__.wait)(1000);
            data.autoFillerData.customer = (0,_app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_8__.moveEvoucherDataToCustomer)(data.autoFillerData.customer, data);
            const regExp = /samo\.premiera\.travel\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_10__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ claimId: claimNumber, operator: _operators_302__WEBPACK_IMPORTED_MODULE_13__.Premiera, errorText: null });
        }
        catch (e) {
            console.log("SpaceTravel FormFill фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(index, tourist, countryTo) {
            let optionIndex = -1;
            var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function handleTouristFields(block, touristFields) {
            touristFields.forEach(touristField => {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    console.log(touristField.value);
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        ;
        function preparePhone(phone) {
            if (phone) {
                phone = phone.replace(/\D/g, '');
                if (phone && phone.startsWith('7')) {
                    return '+' + phone;
                }
                if (phone && phone.startsWith('8')) {
                    return '+7' + phone.substr(1, phone.length);
                }
            }
            return phone;
        }
        function toUpperCase(input) {
            if (!input || input === '') {
                return '';
            }
            return input.toUpperCase();
        }
        function setCitezenship(index, tourist) {
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenship === option.value) {
                    text = option.innerText;
                }
            });
            if (!text) {
                return;
            }
            var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function setSexRadios(tourist, sexRadios) {
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexRadios[0].checked = true;
                    break;
                case 2:
                case 4:
                case 6:
                    sexRadios[1].checked = true;
                    break;
            }
        }
        function setHuman(index, tourist) {
            // 0 - CHD
            // 1 - MR
            // 2 - MRS
            let humanDdItemIndex = 0;
            switch (tourist.touristType) {
                case 1:
                    humanDdItemIndex = 1;
                    break;
                case 2:
                    humanDdItemIndex = 2;
                    break;
                case 3:
                    humanDdItemIndex = 0;
                    break;
                case 4:
                    humanDdItemIndex = 0;
                    break;
                case 5:
                    humanDdItemIndex = 0;
                    break;
                case 6:
                    humanDdItemIndex = 0;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function getOptionIndexByName(text, optionsSelector) {
            const options = document.querySelectorAll(optionsSelector);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function setCustomerDocumentType(tourist, countryTo) {
            let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
            }
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: `${customer.surnameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: `${customer.nameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: `${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                    value: customer.birthday
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                    value: customer.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                    value: customer.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                    value: customer.passportIssueCode
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(block, fields);
            // setSex(maleRadio, femaleRadio, tourist);
            // setCitezenship(index, tourist);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            setDocumentType(index, tourist, data.countryTo);
            const touristFields = [{
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"], input[name="frm[People][${index + 1}][PHONE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
                }];
            handleTouristFields(block, touristFields);
            const sexRadios = block.querySelectorAll('input[id^="SEX"]');
            setSexRadios(tourist, sexRadios);
            setCitezenship(index, tourist);
            setHuman(index, tourist);
            console.log(index);
        });
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_344.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_344.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_344__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/344 */ "./src/serverScripts/operators/344.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _formFill_344_CanaryNAPI__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./formFill_344_CanaryNAPI */ "./src/serverScripts/formFill/formFill_344_CanaryNAPI.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, } = context;
        let { tourUrl } = context;
        if (tourUrl.indexOf('CanaryNAPI') !== -1) {
            yield (0,_formFill_344_CanaryNAPI__WEBPACK_IMPORTED_MODULE_12__.formFill)(context);
            return;
        }
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_344__WEBPACK_IMPORTED_MODULE_0__.Panteon);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'a.user-login');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__.executeScriptInTabV3)(tab, 
            // @ts-ignore
            () => { document.querySelector('a.user-login').click(); });
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__.wait)(1000);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_11__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_344__WEBPACK_IMPORTED_MODULE_0__.Panteon.packet
            }));
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__.wait)(5 * 1000);
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems
                }]);
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'span[id$="DogovorCode"]', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' });
        }
        catch (e) {
            console.log("Panteon фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('PlanTravel Parser claimFiller');
    var mainChain = Promise.resolve();
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
    })(FieldType || (FieldType = {}));
    function localWait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function dispatchKoEvents(element) {
        element.dispatchEvent(new Event('change'));
        element.dispatchEvent(new Event('input'));
        element.dispatchEvent(new Event('blur'));
        element.dispatchEvent(new Event('keypress'));
    }
    function fillText(touristField, block) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            if (touristField.value) {
                var element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    element.value = touristField.value;
                    dispatchKoEvents(element);
                }
            }
            res();
        }));
        mainChain = mainChain.then(() => localWait(100));
    }
    function fillDatePicker(touristField, block) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            block.querySelector(touristField.htmlElementSelector).dispatchEvent(new FocusEvent('focus', { bubbles: true }));
            if (touristField.value) {
                block.querySelector(touristField.htmlElementSelector).value = touristField.value;
            }
            res();
        }));
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            block.querySelector(touristField.htmlElementSelector).dispatchEvent(new KeyboardEvent('keydown', { bubbles: true, code: "ControlLeft", key: "Control", keyCode: 17 }));
            block.querySelector(touristField.htmlElementSelector).dispatchEvent(new KeyboardEvent('keydown', { bubbles: true, code: "KeyV", key: "v", keyCode: 86 }));
            block.querySelector(touristField.htmlElementSelector).dispatchEvent(new KeyboardEvent('keyup', { bubbles: true, code: "ControlLeft", key: "Control", keyCode: 17 }));
            block.querySelector(touristField.htmlElementSelector).dispatchEvent(new KeyboardEvent('keyup', { bubbles: true, code: "KeyV", key: "v", keyCode: 86 }));
            res();
        }));
        mainChain = mainChain.then(() => localWait(100));
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            document.querySelector('body').dispatchEvent(new MouseEvent('mousedown', { bubbles: true }));
            res();
        }));
        mainChain = mainChain.then(() => localWait(100));
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            dispatchKoEvents(block.querySelector(touristField.htmlElementSelector));
            res();
        }));
        mainChain = mainChain.then(() => localWait(2 * 1000));
    }
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(touristField => {
            switch (touristField.fieldType) {
                case FieldType.Text:
                    fillText(touristField, block);
                    break;
                case FieldType.Sex:
                    fillSex(touristField, block);
                    break;
                case FieldType.DatePicker:
                    fillDatePicker(touristField, block);
                    break;
                case FieldType.Citizenship:
                    fillCitizenship(touristField, block);
                    break;
                default: break;
            }
        });
    }
    function fillCitizenship(touristField, block) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            try {
                // const citizenships = {
                //     '460': {
                //         Key: 460,
                //         Name: "Russia"
                //     },
                //     '375': {
                //         Key: 375,
                //         Name: "Belarus"
                //     },
                //     '5': {
                //         Key: 5,
                //         Name: "Ukraine"
                //     },
                //     '6327': {
                //         Key: 6299,
                //         Name: "Абхазия"
                //     }
                // };
                // if(touristField.value) {
                //     (block!.querySelector(touristField.htmlElementSelector) as HTMLInputElement)!.value = touristField.value as string;
                //     dispatchKoEvents(block!.querySelector(touristField.htmlElementSelector) as HTMLElement);
                // }
                let field = block.querySelector(touristField.htmlElementSelector);
                // let defaultSelectedValueDiv = touristBlock.querySelector(`${touristField.htmlElementSelector} div.true__single-value`) as HTMLDivElement;
                // if(defaultSelectedValueDiv && defaultSelectedValueDiv.innerText) {
                //     console.log(`defaultSelectedValueDiv = ${defaultSelectedValueDiv}`);
                //     console.log(`touristField.value = ${touristField.value}`);
                //     if(defaultSelectedValueDiv.innerText === touristField.value) {
                //         return;
                //     }
                // }
                if (field && field.parentNode) {
                    field.parentNode.style.border = "10px solid red";
                    field.parentNode.style.borderRadius = '20px';
                    let div = document.createElement("div");
                    div.style.textAlign = 'center';
                    div.append(`--> ${touristField.value} <--`);
                    field.parentNode.appendChild(div);
                }
            }
            catch (e) {
                console.dir(e);
                console.dir(touristField);
                console.dir(block);
            }
            res();
        }));
        mainChain = mainChain.then(() => localWait(2 * 1000));
    }
    function fillSex(touristField, block) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            let sex = '';
            switch (touristField.value) {
                case 1:
                case 3:
                case 5:
                    sex = '0';
                    break;
                case 2:
                case 4:
                case 6:
                    sex = '1';
                    break;
            }
            const select = block.querySelector(touristField.htmlElementSelector);
            select.value = sex;
            dispatchKoEvents(select);
            res();
        }));
        mainChain = mainChain.then((() => localWait(100)));
    }
    function doFill(data) {
        const touristBlocks = document.querySelectorAll('#tourists .tourists .list-group .tourist');
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            const fields = [
                {
                    htmlElementSelector: 'select#slSex',
                    value: tourist.touristType,
                    fieldType: FieldType.Sex
                },
                {
                    htmlElementSelector: 'input.ipLastName',
                    value: tourist.surname,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input.ipFirstName',
                    value: tourist.name,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input.ipBirthDate',
                    value: tourist.birthday,
                    fieldType: FieldType.DatePicker
                },
                {
                    htmlElementSelector: 'input.ipPhone',
                    value: tourist.phone,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input.ipEmail',
                    value: tourist.email,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input.ipPassportSeries',
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input.ipPassport',
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                },
                {
                    htmlElementSelector: 'input.ipPassportDateEnd',
                    value: tourist.passportExpireDate,
                    fieldType: FieldType.DatePicker
                },
                {
                    htmlElementSelector: 'input.ipCitizenship',
                    value: tourist.citizenshipName,
                    fieldType: FieldType.Citizenship
                }
            ];
            handleTouristFields(fields, block);
        });
    }
    debugger;
    doFill(data);
}
// function claimFilter(data: FillerParams) {
//     function setSex(tourist: Tourist, index: number) {
//         let sex: number = -1;
//         switch (tourist.touristType) {
//             case 1:
//             case 3:
//             case 5: sex = 0;
//                 break;
//             case 2:
//             case 4:
//             case 6: sex = 1;
//                 break;
//         }
//         const script = document.createElement('script');
//         const code = document.createTextNode(`
//             ko.dataFor($('select#slSex')[${index}]).TouristsViewModel.tourists()[${index}].maleFemaleSex(${sex})
//         `);
//         script.appendChild(code);
//         (document.body || document.head).appendChild(script);
//     }
//     function handleTouristFields(touristFields: TouristFieldElement[], block: HTMLDivElement) {
//         touristFields.forEach(touristItem => {
//             const element = block.querySelector(touristItem.htmlElementSelector) as HTMLInputElement;
//             if (element && touristItem.value) {
//                 const parent = element.parentNode as HTMLElement;
//                 if(parent && parent.style && parent.style.display && parent.style.display === 'none') {
//                     return;
//                 }
//                 element.value = touristItem.value as string;
//                 element.dispatchEvent(new Event('change'));
//                 element.dispatchEvent(new Event('input'));
//             }
//         });
//     }
//     function setCitizenship(tourist: Tourist, block: HTMLElement) {
//         try {
//             const citizenships = {
//                 '460': {
//                     Key: 460,
//                     Name: "Russia"
//                 },
//                 '375': {
//                     Key: 375,
//                     Name: "Belarus"
//                 },
//                 '5': {
//                     Key: 5,
//                     Name: "Ukraine"
//                 },
//                 '6299': {
//                     Key: 6299,
//                     Name: "Абхазия"
//                 }
//             };
//             if(tourist && tourist.citizenship && tourist.citizenship !== null){
//                 // @ts-ignore
//                 (window as any).ko.dataFor(block.querySelector('div.ipCitizenship')).citizenship(citizenships[tourist.citizenship])
//             }
//         } catch(e) {
//             console.dir(e);
//             console.dir(tourist);
//             console.dir(block);
//         }
//     }
//     function setDate(tourist: TouristFieldElement, index: number, block: HTMLDivElement) {
//         const element = block.querySelector(tourist.htmlElementSelector) as HTMLInputElement;
//         if (element === null || tourist.value === null) {
//             return;
//         }
//         const script = document.createElement('script');
//         const code = document.createTextNode(`
//             var blocks = document.querySelectorAll('#tourists .tourists .list-group .tourist');
//             if (blocks.length > 0) {
//                 let container = blocks[${index}].querySelector('${tourist.htmlElementSelector}');
//                 $ = this.jQuery;
//                 $(container).datepicker('setDate', '${tourist.value}');
//                 $(container).datepicker('show');
//                 $(container).datepicker('hide');
//             }
//         `);
//         script.appendChild(code);
//         (document.body || document.head).appendChild(script);
//     }
//     function doFill(tourists: Array<Tourist>,  touristBlocks: NodeListOf<HTMLDivElement>) {
//         Array.prototype.forEach.call(touristBlocks, (block: HTMLDivElement, index: number) => {
//             const tourist = tourists[index];
//             if (!tourist) {
//                 return;
//             }
//             const fields: TouristFieldElement[] = [{
//                 htmlElementSelector: 'input.ipLastName',
//                 value: tourist.surname
//             },
//             {
//                 htmlElementSelector: 'input.ipFirstName',
//                 value: tourist.name
//             },
//             {
//                 htmlElementSelector: 'input.ipLastNameRus',
//                 value: tourist.surnameRus
//             },
//             {
//                 htmlElementSelector: 'input.ipFirstNameRus',
//                 value: tourist.nameRus
//             },
//             // {
//             //     htmlElementSelector: 'input.ipPatronymicRus',
//             //     value: tourist.middleNameRus
//             // },
//             // {
//             //     htmlElementSelector: 'input.ipPatronymic',
//             //     value: tourist.middleNameRus
//             // },
//             {
//                 htmlElementSelector: 'input.ipPhone',
//                 value: tourist.phone
//             },
//             {
//                 htmlElementSelector: 'input.ipEmail',
//                 value: tourist.email
//             },
//             {
//                 htmlElementSelector: 'input.ipPassportSeries',
//                 value: tourist.passportSeries
//             },
//             {
//                 htmlElementSelector: 'input.ipPassport',
//                 value: tourist.passportNumber
//             },
//             {
//                 htmlElementSelector: 'input.ipPassportSeriesRus',
//                 value: tourist.passportSeries
//             },
//             {
//                 htmlElementSelector: 'input.ipPassportRus',
//                 value: tourist.passportNumber
//             }
//         ];
//             const maleDd = block.querySelector('#slSex option[value="0"]') as HTMLOptionElement;
//             const femaleDd = block.querySelector('#slSex option[value="1"]') as HTMLOptionElement;
//             const birthdateElement: TouristFieldElement = {
//                 htmlElementSelector: 'input.ipBirthDate',
//                 value: tourist.birthday
//             };
//             const passportDateEndElement: TouristFieldElement = {
//                 htmlElementSelector: 'input.ipPassportDateEnd',
//                 value: tourist.passportExpireDate
//             }
//             const passportDateEndRusElement: TouristFieldElement = {
//                 htmlElementSelector: 'input.ipPassportDateRus',
//                 value: tourist.passportDate
//             }
//             handleTouristFields(fields, block);
//             setSex(tourist, index);
//             setDate(birthdateElement, index, block);
//             setDate(passportDateEndElement, index, block);
//             setDate(passportDateEndRusElement, index, block);
//             setCitizenship(tourist, block)
//         });
//     }
//     var touristBlocks =  document.querySelectorAll('#tourists .tourists .list-group .tourist') as NodeListOf<HTMLDivElement>;
//     doFill(data.tourists, touristBlocks);
// }


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_344_CanaryNAPI.ts":
/*!***************************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_344_CanaryNAPI.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, } = context;
        let { tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_0__.removeCookies)({
                url: 'https://booking.panteon.ru',
                cookieNames: ['.masterweblight-auth']
            });
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, 'form.login input[type=text]');
            const regExp = /booking\.panteon\.ru\/MasterWeb1\/(OrderInfo|orderInfo)\.aspx\?dg_code=(\S+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_11__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 3) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__.sendIdsToBookingCenter)(claimNumber, parsedUrl[2].toUpperCase())
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_4__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                return true;
            });
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: {
                    loginPath: "form.login input[type=text]",
                    passwordPath: "form.login input[type=password]",
                    submitPath: "form.login div.base-button"
                },
            }));
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_8__.wait)(5 * 1000);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, 'div.treveler-data-block');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems
                }]);
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_5__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'span[id$="DogovorCode"]', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_4__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' });
        }
        catch (e) {
            console.log("Panteon фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_4__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        var _a, _b, _c;
        var touristBlocks = document.querySelectorAll('div.treveler-data-content div.treveler-form-wrap');
        function handleTouristFields(touristFields, htmlFields) {
            touristFields.forEach(touristItem => {
                let element = null;
                let divFiled = null;
                htmlFields.forEach((field) => {
                    var _a;
                    let labelElement = field.querySelector('div.input-label');
                    if (labelElement && ((_a = labelElement.textContent) === null || _a === void 0 ? void 0 : _a.indexOf(touristItem.htmlElementSelector)) !== -1) {
                        divFiled = field;
                    }
                });
                if (divFiled) {
                    element = divFiled.querySelector(touristItem.koFieldName || 'input');
                }
                if (element && touristItem.value) {
                    element.value = touristItem.value;
                    // element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        function wait(timeout) {
            return new Promise((resolve) => {
                setTimeout(() => resolve(), timeout);
            });
        }
        function setCitizenship(tourist, block) {
            var chain = new Promise((res, rej) => res(0));
            let searchRequest = '';
            switch (tourist.citizenshipName) {
                case 'Россия':
                    searchRequest = 'рос';
                    break;
                default: searchRequest = tourist.citizenshipName;
            }
            if (!searchRequest)
                return;
            chain = chain.then(() => new Promise((res, rej) => {
                var _a;
                // @ts-ignore
                (_a = block.querySelector('div.field-wrap.citizenship div.input-label')) === null || _a === void 0 ? void 0 : _a.click();
                res(0);
            }))
                .then(() => wait(1000))
                .then(() => new Promise((res, rej) => {
                // @ts-ignore
                block.querySelector('div.citizenship input').value = searchRequest;
                block.querySelector('div.citizenship input').dispatchEvent(new Event('input'));
                res(0);
            }))
                .then(() => wait(1000))
                .then(() => new Promise((res, rej) => {
                // @ts-ignore
                block.querySelector('div.field-wrap.citizenship').querySelectorAll('div.list div.item')[0].click();
                res(0);
            }));
        }
        function setSex(tourist, htmlFields) {
            let element = null;
            htmlFields.forEach((field) => {
                var _a;
                let labelElement = field.querySelector('div.input-label');
                if (labelElement && ((_a = labelElement.textContent) === null || _a === void 0 ? void 0 : _a.indexOf('Пол')) !== -1) {
                    element = field;
                }
            });
            if (!element)
                return;
            // @ts-ignore
            const genders = element.querySelectorAll('div.list div.item');
            let sex = -1;
            switch (tourist.touristType) {
                case 1:
                case 3:
                // @ts-ignore
                case 5:
                    genders[0].click();
                    break;
                case 2:
                case 4:
                // @ts-ignore
                case 6:
                    genders[1].click();
                    break;
            }
        }
        Array.prototype.forEach.call(touristBlocks, function (block, index) {
            const tourist = data.tourists[index];
            const htmlFields = block.querySelectorAll('div.field-wrap');
            if (!tourist) {
                return;
            }
            const fields = [{
                    htmlElementSelector: 'Фамилия',
                    value: tourist.surname && tourist.surname.replace('ё', 'e').replace('Ё', 'Е')
                },
                {
                    htmlElementSelector: 'Имя',
                    value: tourist.name && tourist.name.replace('ё', 'e').replace('Ё', 'Е')
                },
                {
                    htmlElementSelector: 'Отчество',
                    value: tourist.middlename && tourist.middlename.replace('ё', 'e').replace('Ё', 'Е')
                },
                {
                    htmlElementSelector: 'Дата рождения',
                    value: tourist.birthday
                },
                {
                    htmlElementSelector: 'серия',
                    value: tourist.passportSeries,
                    koFieldName: 'div.input-1 input',
                },
                {
                    htmlElementSelector: 'номер',
                    value: tourist.passportNumber,
                    koFieldName: 'div.input-2 input',
                },
                {
                    htmlElementSelector: 'Действителен',
                    value: tourist.passportExpireDate
                },
                {
                    htmlElementSelector: 'Телефон',
                    value: tourist.phone
                },
                {
                    htmlElementSelector: 'E-mail',
                    value: tourist.email
                }];
            handleTouristFields(fields, htmlFields);
            setSex(tourist, htmlFields);
            setCitizenship(tourist, block);
        });
        const fields = [{
                htmlElementSelector: 'Дата договора с клиентом',
                // @ts-ignore
                value: (_a = data.customer) === null || _a === void 0 ? void 0 : _a.eVoucherContractDate
            },
            {
                htmlElementSelector: 'Номер договора с клиентом',
                // @ts-ignore
                value: (_b = data.customer) === null || _b === void 0 ? void 0 : _b.eVoucherClaimNumber
            },
            {
                htmlElementSelector: 'Сумма договора с клиентом',
                // @ts-ignore
                value: Math.floor((_c = data.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCustomerPriceInPaymentCurrency).toString()
            }];
        handleTouristFields(fields, document.querySelectorAll('div.buyer-form div[originlabel=ContractDate], div.buyer-form div[originlabel=ContractNumber], div.buyer-form div[originlabel=ContractPrice]'));
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_380.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_380.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_380__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/380 */ "./src/serverScripts/operators/380.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_common_orderedNumbersForNoData__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./../../app/utils/chunks/common/orderedNumbersForNoData */ "./src/app/utils/chunks/common/orderedNumbersForNoData.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({
                url: 'https://b2b.fstravel.com',
                cookieNames: ['SAMO']
            });
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createNewTab)(tourUrl);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'form#loginForm');
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_12__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_11__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: {
                    loginPath: "input#login",
                    passwordPath: "input#password",
                    submitPath: "form#loginForm button.button",
                }
            }));
            if (data.countryTo && data.countryTo.trim().toUpperCase() !== 'АРМЕНИЯ') {
                Array.prototype.forEach.call(data.autoFillerData.touristDataItems, (tourist, index) => {
                    //tourist.isNoPassportData = true;
                    return (0,_app_utils_chunks_common_orderedNumbersForNoData__WEBPACK_IMPORTED_MODULE_9__.rundomNumbersForNoData)(tourist, index);
                });
            }
            // @ts-ignore
            (_a = data.autoFillerData.customer) === null || _a === void 0 ? void 0 : _a.eVoucherClaimNumber = data.eVoucherClaimNumber;
            // @ts-ignore
            (_b = data.autoFillerData.customer) === null || _b === void 0 ? void 0 : _b.eVoucherCurrency = data.eVoucherCurrency;
            // @ts-ignore
            (_c = data.autoFillerData.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
            try {
                // @ts-ignore
                (_d = data.autoFillerData.customer) === null || _d === void 0 ? void 0 : _d.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
            }
            catch (e) { }
            var paramas = {
                tourists: data.autoFillerData.touristDataItems,
                customer: data.autoFillerData.customer,
                countryTo: data.countryTo,
                bookingCompanyId: data.bookingCompanyId,
                isAdvanceBooking: data.isAdvanceBooking
            };
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.tourists-tabs fieldset.panel');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [paramas]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: context.claimNumber, operator: _operators_380__WEBPACK_IMPORTED_MODULE_0__.TUInew, errorText: null });
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'span.claim', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(context.claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_10__.wait)(100);
            // await PreventPassportHiding(tab);
        }
        catch (e) {
            console.log("фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__.SendIdsStatus.FAIL, message: e });
        }
    });
}
function claimFiller(data) {
    //(window as any)['addScriptToPageAndRun'](doFill.toString(), data);
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.tourists-tabs fieldset.panel');
        const friendlyCountries = 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия';
        function setSexRadios(index, tourist) {
            let sexTypeIndex = 0;
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexTypeIndex = 2;
                    break;
                case 2:
                case 4:
                case 6:
                    sexTypeIndex = 1;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        const setCitezenship = (index, tourist) => {
            debugger;
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenshipName === option.text) {
                    text = option.text;
                }
            });
            if (!text) {
                return;
            }
            let searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            let dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        };
        const handleTouristFields = (block, touristFields) => {
            touristFields.forEach(touristField => {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        };
        function isInfantTourist(tourist, infantYear = 2) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return Math.abs(ageDate.getUTCFullYear() - 1970) < infantYear;
        }
        const infants = data.tourists.filter(t => isInfantTourist(t));
        if (infants.length > 0) {
            const infantCheckBoxDiv = document.querySelector('.add_inf');
            const infantCheckbox = document.querySelectorAll('input.addinfant_cb')[0];
            if (infantCheckBoxDiv !== null && infantCheckBoxDiv.style['display'] !== 'none' && !infantCheckbox.checked) {
                infantCheckbox.click();
            }
        }
        function preparePhone(phone) {
            if (phone) {
                phone = phone.replace(/\D/g, '');
                if (phone && phone.startsWith('7')) {
                    return phone;
                }
                if (phone && phone.startsWith('8')) {
                    return '7' + phone.substr(1, phone.length);
                }
            }
            return phone;
        }
        function getExpireDate(date, lag = 25) {
            if (!date || date === '') {
                return '';
            }
            const [day, month, year] = date.split('.');
            var expireDate = new Date(parseInt(year, 10) + lag, parseInt(month, 10) - 1, parseInt(day, 10), 0, 0);
            var newDay = expireDate.getDate();
            var newMonth = expireDate.getMonth() + 1;
            var newYear = expireDate.getFullYear();
            return `${newDay < 10 ? '0' + newDay : newDay}.${newMonth < 10 ? '0' + newMonth : newMonth}.${newYear}`;
        }
        function prepareExpireDate(tourist) {
            if (isInfantTourist(tourist, 14)) {
                return getExpireDate(tourist.birthday, 10);
            }
            else {
                const dateNow = new Date(Date.now());
                const dateNowString = `${dateNow.getDate()}.${dateNow.getMonth() + 1}.${dateNow.getFullYear()}`;
                if (!tourist.passportExpireDate || tourist.passportExpireDate === '') {
                    return getExpireDate(dateNowString, 15);
                }
                return getExpireDate(tourist.passportExpireDate, 15);
            }
        }
        function getCustomerOptionIndexByName(text) {
            const options = document.querySelectorAll(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function getOptionIndexByName(text, index) {
            const options = document.querySelectorAll(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(tourist, countryTo, index) {
            let optionIndex = getOptionIndexByName('паспорт', index);
            if (getTouristAge(tourist) < 14 && friendlyCountries.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Свидетельство о рождении', index);
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Паспорт', index);
                }
                else {
                    optionIndex = getOptionIndexByName('Заграничный паспорт', index);
                }
            }
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function setCustomerDocumentType(tourist, countryTo) {
            let optionIndex = getCustomerOptionIndexByName('паспорт'); // сказали пока проставляем просто Паспорт
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: `${customer.surnameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: `${customer.nameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: `${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                    value: customer.birthday
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(block, fields);
            // setSex(maleRadio, femaleRadio, tourist);
            // setCitezenship(index, tourist);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            console.log(tourist);
            var passportType = 'nationalPassport';
            if (getTouristAge(tourist) < 14 && friendlyCountries.toUpperCase().indexOf(data.countryTo.toUpperCase()) !== -1) {
                passportType = 'birthCertificate';
            }
            else {
                if (tourist.isNationalPassport) {
                    passportType = 'nationalPassport';
                }
                else {
                    passportType = 'travelPassport';
                }
            }
            const touristFields = [{
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: tourist.surnameRus
                        ? tourist.surnameRus.toUpperCase()
                        : ''
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: tourist.nameRus
                        ? tourist.nameRus.toUpperCase()
                        : ''
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: tourist.middleNameRus
                        ? tourist.middleNameRus.toUpperCase()
                        : ''
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: tourist.surnameRus
                        ? tourist.surnameRus.toUpperCase()
                        : ''
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: tourist.nameRus
                        ? tourist.nameRus.toUpperCase()
                        : ''
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: block.querySelector(`input[name="frm[People][${index + 1}][LASTLNAME]"]`) ?
                        tourist.surnameEng ? tourist.surnameEng.toUpperCase() : '' :
                        tourist.surname ? tourist.surname.toUpperCase() : ''
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: block.querySelector(`input[name="frm[People][${index + 1}][FIRSTLNAME]"]`) ?
                        tourist.nameEng ? tourist.nameEng.toUpperCase() : '' :
                        tourist.name ? tourist.name.toUpperCase() : ''
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: block.querySelector(`input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`) ?
                        tourist.surnameEng ? tourist.surnameEng.toUpperCase() : '' :
                        tourist.surname ? tourist.surname.toUpperCase() : ''
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: block.querySelector(`input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`) ?
                        tourist.nameEng ? tourist.nameEng.toUpperCase() : '' :
                        tourist.name ? tourist.name.toUpperCase() : ''
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    // @ts-ignore
                    value: tourist[passportType].series
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    // @ts-ignore
                    value: tourist[passportType].number
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    // @ts-ignore
                    value: tourist[passportType].expireDate && tourist[passportType].expireDate !== '' ? tourist[passportType].expireDate : prepareExpireDate(tourist)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    // @ts-ignore
                    value: tourist[passportType].date
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    // @ts-ignore
                    value: tourist[passportType].issueOrg
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][ADDRESS]"]`,
                    value: tourist.address
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PHONE]"]`,
                    value: preparePhone(tourist.phone) || '79587764656'
                }];
            handleTouristFields(block, touristFields);
            setSexRadios(index, tourist);
            setCitezenship(index, tourist);
            setDocumentType(tourist, data.countryTo, index);
        });
        if (data.isAdvanceBooking) {
            const chckbx = document.querySelector('input#CALCULATED_CLAIM');
            if (chckbx) {
                chckbx.click();
            }
            try {
                document.querySelector('td.calculated').style.border = '10px solid red';
            }
            catch (e) { }
        }
        function addPlashka(cbCompanyId) {
            const getBookingCompanyByCBGuid = (guid) => {
                const guidBookingCompany = {
                    '62b8b7e0-c368-4ec0-8fc6-cee8bbcbbe41': { name: 'ООО «АРИЛЬД»', color: '#00875a' },
                    '4016198a-5249-43b7-b3a0-a4cf53b96cd4': { name: 'ООО «ОЦБ»', color: '#ff8b00' },
                    'a284bfd4-08e5-4f7d-a11c-f745c3c8bdc5': { name: 'ООО «ОЦБ K»', color: '#ff8b00' },
                    'a0c2a815-daec-47f1-a558-c921f13482cc': { name: 'ООО «ГорТревел»', color: '#0747a6' },
                    '96c57522-c7b9-43fb-ab7a-15f98d3972d4': { name: 'ООО «Все Туры»', color: '#de350b' },
                    'eee2cd51-5bb0-495b-9067-ec30adfece47': { name: 'ООО «ГорТревел В»', color: '#403294' },
                    '387d946b-82e6-4a9d-bd02-1ebde5ebcd0a': { name: 'ИП Абрамов Денис Дмитриевич', color: '#ffab00' },
                    'd85b47f8-d524-4f85-9dd6-70100983fb49': { name: 'ООО «МСУ Тех»', color: '#66FF00' },
                    '7784c883-fad4-4402-ba0a-07fda56f5edb': { name: 'ООО СолнцеТур', color: '#505f79' }
                };
                return guidBookingCompany[guid] || { name: 'ООО НЕИЗВЕСТНО', color: 'pink' };
            };
            var urLico = getBookingCompanyByCBGuid(cbCompanyId);
            const divToAddParent = document.createElement('div');
            divToAddParent.id = 'urlicocbParent';
            divToAddParent.setAttribute('style', `
                width: 532px;
                height: 50px;
                position: relative;
                border: 10px solid ${urLico.color};
                border-radius: 10px;
                margin-bottom: 25px;
            `);
            const divToAddChild = document.createElement('div');
            divToAddChild.innerHTML = urLico.name;
            divToAddChild.id = 'urlicocbChild';
            divToAddChild.setAttribute('style', `
                margin: 0;
                position: absolute;
                top: 50%;
                left: 50%;
                -ms-transform: translate(-50%, -50%);
                transform: translate(-50%, -50%);
                font-weight: bold;
                font-size: x-large;
            `);
            divToAddParent.appendChild(divToAddChild);
            const priceInfo = document.querySelector('div.PRICEINFO');
            if (priceInfo) {
                priceInfo.prepend(divToAddParent);
            }
        }
        addPlashka(data.bookingCompanyId);
    }
    doFill(data);
}
// const PreventPassportHiding = (tab: chrome.tabs.Tab): Promise<{}> => {
//     const PreventPassportHidingInternal = () => `
//     var blockClearInterval;
//     var blockClearRepeatsCount = 0;
//     blockClearInterval = setInterval(function () {
//         if (blockClearRepeatsCount++ > 4 * 60)
//             clearInterval(blockClearInterval);
//         document.querySelectorAll('.passport').forEach(x => x.classList.remove('passport'));
//         document.querySelectorAll('.passport_block').forEach(x => x.classList.remove('passport_block'));
//     }, 250);
//     `;
//     return startTrackingElement(tab, '.passport_block')
//         .then(() => executeScriptInTab(tab, {code: PreventPassportHidingInternal()}));
// };


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_382.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_382.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_382__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/382 */ "./src/serverScripts/operators/382.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/utils/chunks/moveEvoucherDataToCustomer */ "./src/app/utils/chunks/moveEvoucherDataToCustomer.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_6__.removeCookiesForTouroperator)(_operators_382__WEBPACK_IMPORTED_MODULE_0__.SelfieTravel);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, _operators_382__WEBPACK_IMPORTED_MODULE_0__.SelfieTravel.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_7__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_8__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_382__WEBPACK_IMPORTED_MODULE_0__.SelfieTravel.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__.wait)(1000);
            data.autoFillerData.customer = (0,_app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_13__.moveEvoucherDataToCustomer)(data.autoFillerData.customer, data);
            const regExp = /b2b\.selfietravel\.kz\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_4__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ claimId: claimNumber, operator: _operators_382__WEBPACK_IMPORTED_MODULE_0__.SelfieTravel, errorText: null });
        }
        catch (e) {
            console.log("SelfieTravel фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(index, tourist, countryTo) {
            let optionIndex = -1;
            var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            if (document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`)) {
                document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
                document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            }
        }
        function handleTouristFields(block, touristFields) {
            touristFields.forEach(touristField => {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    console.log(touristField.value);
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        ;
        function preparePhone(phone) {
            if (phone) {
                phone = phone.replace(/\D/g, '');
                if (phone && phone.startsWith('7')) {
                    return '+' + phone;
                }
                if (phone && phone.startsWith('8')) {
                    return '+7' + phone.substr(1, phone.length);
                }
            }
            return phone;
        }
        function toUpperCase(input) {
            if (!input || input === '') {
                return '';
            }
            return input.toUpperCase();
        }
        function setCitezenship(index, tourist) {
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenshipName === option.innerText) {
                    text = option.innerText;
                }
            });
            if (!text) {
                return;
            }
            var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function setSexRadios(tourist, sexRadios) {
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexRadios[0].checked = true;
                    break;
                case 2:
                case 4:
                case 6:
                    sexRadios[1].checked = true;
                    break;
            }
        }
        function setHuman(index, tourist) {
            // 0 - CHD
            // 1 - MR
            // 2 - MRS
            let humanDdItemIndex = 0;
            switch (tourist.touristType) {
                case 1:
                    humanDdItemIndex = 1;
                    break;
                case 2:
                    humanDdItemIndex = 2;
                    break;
                case 3:
                    humanDdItemIndex = 0;
                    break;
                case 4:
                    humanDdItemIndex = 0;
                    break;
                case 5:
                    humanDdItemIndex = 0;
                    break;
                case 6:
                    humanDdItemIndex = 0;
                    break;
            }
            if (document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`)) {
                document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
                document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            }
        }
        ;
        function getOptionIndexByName(text, optionsSelector) {
            const options = document.querySelectorAll(optionsSelector);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function setCustomerDocumentType(tourist, countryTo) {
            let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
            }
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: `${customer.surnameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: `${customer.nameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: `${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                    value: customer.birthday
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                    value: customer.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                    value: customer.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                    value: customer.passportIssueCode
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(block, fields);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            setDocumentType(index, tourist, data.countryTo);
            const touristFields = [{
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru'
                },
                // {
                //     htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                //     value: tourist.passportSeries
                // },
                // {
                //     htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                //     value: `${tourist.passportSeries}${tourist.passportNumber}` 
                // },
                {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
                }];
            handleTouristFields(block, touristFields);
            const sexRadios = block.querySelectorAll('input[id^="SEX"]');
            setSexRadios(tourist, sexRadios);
            setCitezenship(index, tourist);
            setHuman(index, tourist);
            console.log(index);
        });
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_4.ts":
/*!**************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_4.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/4 */ "./src/serverScripts/operators/4.ts");
/* harmony import */ var _app_utils_chunks_common_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/common/emptyForNoDataAndOnes */ "./src/app/utils/chunks/common/emptyForNoDataAndOnes.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_8__.removeCookiesForTouroperator)(_operators_4__WEBPACK_IMPORTED_MODULE_0__.TezTour);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_9__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000 * 3);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, 'form#login-form, form[name=f]');
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_12__.executeLoginScriptInTabV3)(tab, {
                login: data.login,
                password: data.password,
                packet: {
                    loginPath: "#login-edit-0-email, input#j_username",
                    passwordPath: "#login-edit-0-password, input#j_password",
                    submitPath: "form#login-form input[type='submit'], form[name=f] input[name=submit]"
                }
            });
            function preparePhone(phone) {
                if (!phone || phone === '')
                    return '';
                phone = phone.trim().replace('+', '');
                if (phone.startsWith('7')) {
                    phone = phone.replace('7', '');
                }
                return phone;
            }
            Array.prototype.forEach.call(data.autoFillerData.touristDataItems, tourist => {
                tourist.phone = preparePhone(tourist.phone);
                return (0,_app_utils_chunks_common_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_1__.emptyForNoDataAndOnes)(tourist);
            });
            var fillerParams = {
                tourists: data.autoFillerData.touristDataItems,
                customer: data.autoFillerData.customer,
                countryTo: data.countryTo,
                bookingCompanyId: data.bookingCompanyId,
                travelDate: data.travelDate
            };
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__.updateListenerOnSpecificPage)(tab.id, /plus\.tez-tour\.com\/booking\/products\/sign(\S+)/, (tabId, changeInfo, updatedTab) => {
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(updatedTab, 'div.tourists-items')
                    .then(() => (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(updatedTab, claimFiller, [fillerParams]));
                return true;
            });
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__.updateListenerOnSpecificPage)(tab.id, /plus\.tez-tour\.com\/booking\/success\/hash\/(\S+)/, (tabId, changeInfo, updatedTab) => {
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(updatedTab, 'table.table-book-item')
                    .then(() => (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_5__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'table.table-book-item > tbody > tr:nth-child(2) > td:nth-child(1)', claimNumber))
                    .then((response) => (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__.sendIdsToBookingCenter)(claimNumber, response.claimNo))
                    .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                return true;
            });
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_5__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'table.table-book-item > tbody > tr:nth-child(2) > td:nth-child(1)', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' });
        }
        catch (e) {
            console.log("фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('TezTour claimFiller');
    debugger;
    var chain = Promise.resolve();
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
    })(FieldType || (FieldType = {}));
    function doFill(data) {
        console.log('ClaimFiller TezTour');
        debugger;
        let childCount = 0;
        var touristBlocks = document.querySelectorAll('div.tourists-items div.guest-data-box');
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            var isChild = getTouristAgeByTravelStart(tourist, data.travelDate) < 14;
            if (isChild) {
                index = childCount;
            }
            console.log(`fillTourist index = ${index}`);
            //fillTourist(block, index, tourist);
            // ------------------------------------------------------
            const touristFields = [{
                    htmlElementSelector: `select[name=prefix0${index}], select[name=childrenprefix0${index}]`,
                    value: tourist.touristType,
                    fieldType: FieldType.Sex
                }, {
                    htmlElementSelector: `input[name="lastname0${index}"], input[name="childrenlastname0${index}"]`,
                    value: tourist.surnameEng.toUpperCase(),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="name0${index}"], input[name="childrenname0${index}"]`,
                    value: tourist.nameEng.toUpperCase(),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `select[name=id_citizenship0${index}], select[name=childrenid_citizenship0${index}]`,
                    value: tourist.citizenshipName.toUpperCase(),
                    fieldType: FieldType.Citizenship
                }, {
                    htmlElementSelector: `input[name="birthdate0${index}"], input[name="childrenbirthdate0${index}"]`,
                    value: tourist.birthday,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passport_series0${index}"], input[name="childrenpassport_series0${index}"]`,
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passport_number0${index}"], input[name="childrenpassport_number0${index}"]`,
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passport_issue0${index}"], input[name="childrenpassport_issue0${index}"]`,
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passport_expiries0${index}"], input[name="childrenpassport_expiries0${index}"]`,
                    value: tourist.passportExpireDate,
                    fieldType: FieldType.Text
                }];
            handleTouristFields(touristFields, block);
            if (isChild) {
                childCount += 1;
            }
        });
    }
    function localWait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    // console.log(touristBlocks);
    function fillText(field, block) {
        chain = chain.then(() => new Promise((res, rej) => {
            if (field.value) {
                var element = block.querySelector(field.htmlElementSelector);
                if (element) {
                    element.dispatchEvent(new Event('click'));
                    element.value = field.value;
                    element.dispatchEvent(new Event('input'));
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('keyup'));
                }
            }
            res();
        }));
        chain = chain.then(() => localWait(100));
    }
    function fillCitizenship(field, block) {
        chain = chain.then(() => new Promise((res, rej) => {
            var selectElement = block.querySelector(field.htmlElementSelector);
            if (selectElement && selectElement.nextSibling) {
                selectElement.nextSibling.dispatchEvent(new MouseEvent('mousedown', { bubbles: true }));
            }
            res();
        }));
        chain = chain.then(() => localWait(100));
        chain = chain.then(() => new Promise((res, rej) => {
            var selectElement = document.querySelector(field.htmlElementSelector);
            var liToClick = null;
            if (selectElement && selectElement.nextSibling) {
                var lis = selectElement.nextSibling.querySelectorAll('ul.chosen-results li.active-result');
                for (var i = 0; i < lis.length; i++) {
                    var li = lis[i];
                    if (li.innerText.toUpperCase() === field.value.toUpperCase()) {
                        liToClick = li;
                        break;
                    }
                }
                if (liToClick) {
                    // @ts-ignore
                    liToClick.dispatchEvent(new MouseEvent('mouseup', { isTrusted: true, bubbles: true }));
                }
            }
            res();
        }));
        chain = chain.then(() => localWait(100));
    }
    function fillSex(field, block) {
        chain = chain.then(() => new Promise((res, rej) => {
            const htmlElement = block.querySelector(field.htmlElementSelector);
            htmlElement.nextSibling.dispatchEvent(new MouseEvent('mousedown', { bubbles: true }));
            res();
        }));
        chain = chain.then(() => localWait(100));
        chain = chain.then(() => new Promise((res, rej) => {
            var sexSelect = document.querySelector('ul.selectBox-dropdown-menu.selectBox-options.styled-selectBox-dropdown-menu.selectBox-selectBox-dropdown-menu.input-prefix-selectBox-dropdown-menu.selectBox-options-bottom');
            if (sexSelect) {
                var sexes = sexSelect.querySelectorAll('li a');
                switch (field.value) {
                    case 1:
                    case 3:
                    case 5:
                        sexes[1].dispatchEvent(new MouseEvent('mouseup', { bubbles: true, screenX: 1, screenY: 1 }));
                        break;
                    case 2:
                    case 4:
                    case 6:
                        sexes[2].dispatchEvent(new MouseEvent('mouseup', { bubbles: true, screenX: 1, screenY: 1 }));
                        break;
                }
            }
            res();
        }));
        chain = chain.then(() => localWait(100));
    }
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(touristField => {
            switch (touristField.fieldType) {
                case FieldType.Text:
                    fillText(touristField, block);
                    break;
                case FieldType.Sex:
                    fillSex(touristField, block);
                    break;
                case FieldType.Citizenship:
                    fillCitizenship(touristField, block);
                    break;
                default: break;
            }
        });
    }
    function getTouristAgeByTravelStart(tourist, travelStart) {
        if (!travelStart)
            return 100;
        const [startDay, startMonth, startYear] = travelStart.split('.');
        const travelStartDate = new Date(parseInt(startYear, 10), parseInt(startMonth, 10) - 1, parseInt(startDay, 10));
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = travelStartDate.getTime() - new Date(parseInt(year, 10), parseInt(month, 10) - 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function preparePhone(phone) {
        if (!phone || phone === '')
            return '';
        phone = phone.trim().replace('+', '');
        if (phone.startsWith('7')) {
            phone = phone.replace('7', '');
        }
        return phone;
    }
    var contactTourist = null;
    if (data.customer) {
        contactTourist = data.customer;
    }
    else {
        contactTourist = data.tourists[0];
    }
    handleTouristFields([
        {
            htmlElementSelector: `div.guest-data-box input[name=email]`,
            value: contactTourist.email.toUpperCase(),
            fieldType: FieldType.Text
        },
        {
            htmlElementSelector: `div.guest-data-box input[name=phone]`,
            value: preparePhone(contactTourist.phone).toUpperCase(),
            fieldType: FieldType.Text
        }
    ], document);
    let timerId = setInterval(function () {
        console.log('Попытка заполнить кустомера');
        if (document.querySelector('div#purchaser-info-box')) {
            doCustomerFill(data.customer);
            console.log('Кустомер заполнен, интервал обнуляется');
            clearInterval(timerId);
        }
    }, 1000);
    setTimeout(function () {
        clearInterval(timerId);
        console.log('stop');
    }, 10 * 60 * 1000);
    function doCustomerFill(customer) {
        if (!customer)
            return;
        function setCitizenshipSelect(fieldSelector, country) {
            Promise.resolve()
                .then(() => {
                var selectElement = document.querySelector(fieldSelector);
                if (selectElement && selectElement.nextSibling) {
                    selectElement.nextSibling.dispatchEvent(new MouseEvent('mousedown', { bubbles: true }));
                }
                return Promise.resolve();
            })
                .then(() => {
                var selectElement = document.querySelector(fieldSelector);
                var liToClick = null;
                if (selectElement && selectElement.nextSibling) {
                    var lis = selectElement.nextSibling.querySelectorAll('ul.chosen-results li.active-result');
                    for (var i = 0; i < lis.length; i++) {
                        var li = lis[i];
                        if (li.innerText.toUpperCase() === country.toUpperCase()) {
                            liToClick = li;
                            break;
                        }
                    }
                    if (liToClick) {
                        // @ts-ignore
                        liToClick.dispatchEvent(new MouseEvent('mouseup', { isTrusted: true, bubbles: true }));
                    }
                }
            });
        }
        function handleCustomerFields(touristFields) {
            touristFields.forEach(touristField => {
                var _a;
                if (touristField.htmlElement && touristField.value) {
                    touristField.htmlElement.dispatchEvent(new Event('click'));
                    touristField.htmlElement.value = (_a = touristField.value) === null || _a === void 0 ? void 0 : _a.toUpperCase();
                    touristField.htmlElement.dispatchEvent(new Event('input'));
                    touristField.htmlElement.dispatchEvent(new Event('change'));
                    touristField.htmlElement.dispatchEvent(new Event('keyup'));
                }
            });
            return Promise.resolve();
        }
        function setDocType() {
            return Promise.resolve()
                .then(() => {
                // @ts-ignore
                document.querySelector('select[name=extradata_doc_type]').nextSibling.dispatchEvent(new MouseEvent('mousedown', { bubbles: true }));
                return Promise.resolve();
            })
                .then(() => localWait(500))
                .then(() => document.querySelectorAll('ul.doc_type-selectBox-dropdown-menu li a[rel="3"]')[0].dispatchEvent(new MouseEvent('mousedown', { bubbles: true })))
                .then(() => localWait(500))
                .then(() => document.querySelectorAll('ul.doc_type-selectBox-dropdown-menu li a[rel="3"]')[0].dispatchEvent(new MouseEvent('mouseup', { bubbles: true })))
                .then(() => localWait(500))
                .then(() => document.querySelectorAll('ul.doc_type-selectBox-dropdown-menu li a[rel="3"]')[0].dispatchEvent(new MouseEvent('click', { bubbles: true })));
        }
        function fillCustomer(block, customer) {
            const customerFields = [{
                    htmlElement: block.querySelector(`input[name="extradata_lname"]`),
                    value: customer.surnameRus
                }, {
                    htmlElement: block.querySelector(`input[name="extradata_fname"]`),
                    value: customer.nameRus
                }, {
                    htmlElement: block.querySelector(`input[name="extradata_sname"]`),
                    value: customer.middleNameRus
                }, {
                    htmlElement: block.querySelector(`input[name="email"]`),
                    value: customer.email
                }, {
                    htmlElement: block.querySelector(`input[name="extradata_phone"]`),
                    value: preparePhone(customer.phone)
                }, {
                    htmlElement: block.querySelector(`input[name="extradata_pnumber"]`),
                    value: `${customer.passportSeries} ${customer.passportNumber}`
                }, {
                    htmlElement: block.querySelector(`input[name="extradata_address"]`),
                    value: customer.address
                }];
            function preparePhone(phone) {
                if (!phone || phone === '')
                    return '';
                phone = phone.trim().replace('+', '');
                if (phone.startsWith('7')) {
                    phone = phone.replace('7', '');
                }
                return phone;
            }
            handleCustomerFields(customerFields)
                .then(() => setCitizenshipSelect('select[name=extradata_nationality]', 'Россия'))
                .then(() => setDocType());
        }
        debugger;
        fillCustomer(document.querySelector('div#purchaser-info-box'), customer);
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_439.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_439.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_439__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/439 */ "./src/serverScripts/operators/439.ts");
/* harmony import */ var _app_models_chunks_fillerParams__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/models/chunks/fillerParams */ "./src/app/models/chunks/fillerParams.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_models_chunks_emptyFieldFillerType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/models/chunks/emptyFieldFillerType */ "./src/app/models/chunks/emptyFieldFillerType.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        var fillerData = (0,_app_models_chunks_fillerParams__WEBPACK_IMPORTED_MODULE_1__.MapFillerParams)(data, _app_models_chunks_emptyFieldFillerType__WEBPACK_IMPORTED_MODULE_11__.EmptyFieldFillerType.OneForNoData);
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__.removeCookiesForTouroperator)(_operators_439__WEBPACK_IMPORTED_MODULE_0__.Paks);
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__.removeCookies)({
                url: 'https://178.177.4.241',
                cookieNames: _operators_439__WEBPACK_IMPORTED_MODULE_0__.Paks.cookie.auth
            });
            var tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_3__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            const regExp = /newonline\.paks\.ru\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_9__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                return true;
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__.startTrackingElement)(tab, _operators_439__WEBPACK_IMPORTED_MODULE_0__.Paks.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_12__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_13__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_439__WEBPACK_IMPORTED_MODULE_0__.Paks.credentials.packet
            }));
            //await navigateToClaimPageNew(tab, {login: data.login, password: data.password}, Paks.credentials!.packet);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__.startTrackingElement)(tab, '.tourists-tabs');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTabV3)(tab, claimFilter, [fillerData]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ claimId: claimNumber, operator: _operators_439__WEBPACK_IMPORTED_MODULE_0__.Paks, errorText: null });
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_7__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'span.claim', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_9__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' });
        }
        catch (e) {
            console.log("Fatal error Paks");
            console.log(e);
            console.dir(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_9__.SendIdsStatus.FAIL, message: 'Fatal error Paks' });
        }
    });
}
function claimFilter(data) {
    function doFill(data) {
        const touristBlocks = document.querySelectorAll('.tourists-tabs .panel');
        function handleTouristFields(touristFields, block) {
            touristFields.forEach(touristItem => {
                const element = block.querySelector(touristItem.htmlElementSelector);
                if (element && touristItem.value) {
                    element.value = touristItem.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        function setSex(index, tourist) {
            let sexTypeIndex = 0;
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexTypeIndex = 2;
                    break;
                case 2:
                case 4:
                case 6:
                    sexTypeIndex = 1;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function setHuman(index, tourist) {
            let humanDdItemIndex = 0;
            switch (tourist.touristType) {
                case 1:
                    humanDdItemIndex = 2;
                    break;
                case 2:
                    humanDdItemIndex = 3;
                    break;
                case 3:
                    humanDdItemIndex = 1;
                    break;
                case 4:
                    humanDdItemIndex = 1;
                    break;
                case 5:
                    humanDdItemIndex = 1;
                    break;
                case 6:
                    humanDdItemIndex = 1;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        const setCitezenship = (index, tourist) => {
            var _a;
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenship === option.value) {
                    text = option.innerText;
                }
            });
            if (!text) {
                return;
            }
            var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown'));
            (_a = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`)) === null || _a === void 0 ? void 0 : _a.dispatchEvent(new MouseEvent('mouseup', { bubbles: true }));
        };
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function getOptionIndexByName(text, optionsSelector) {
            const options = document.querySelectorAll(optionsSelector);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function setDocumentType(index, tourist, countryTo) {
            let optionIndex = -1;
            var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
            }
            else {
                if (tourist.IsNationalPassport || tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                }
                else {
                    optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                }
            }
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new MouseEvent('mouseup', { bubbles: true }));
        }
        function setCustomerDocumentType(tourist, countryTo) {
            let optionIndex = 3; // сказали пока проставляем просто Паспорт
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new MouseEvent('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: customer.surnameRus
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: customer.nameRus
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: customer.middleNameRus
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(fields, block);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            const fieldIndex = index + 1;
            if (!tourist) {
                return;
            }
            const fields = [{
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][LASTNAME_LNAME]"]`,
                    value: tourist.surnameEng
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][FIRSTNAME_LNAME]"]`,
                    value: tourist.nameEng
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PATRONYMIC_LNAME]"]`,
                    value: tourist.middleNameEng
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][LASTNAME_NAME]"]`,
                    value: tourist.surnameRus
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][FIRSTNAME_NAME]"]`,
                    value: tourist.nameRus
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PATRONYMIC_NAME]"]`,
                    value: tourist.middleNameRus
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PHONE]"]`,
                    value: tourist.phone
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][MOBILE]"]`,
                    value: tourist.phone
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][EMAIL]"]`,
                    value: tourist.email
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PGIVENORG]"]`,
                    value: tourist.passportIssueOrg
                }];
            setHuman(index, tourist);
            setSex(index, tourist);
            setDocumentType(index, tourist, data.countryTo);
            setCitezenship(index, tourist);
            handleTouristFields(fields, block);
        });
        function addPlashka(cbCompanyId) {
            const getBookingCompanyByCBGuid = (guid) => {
                const guidBookingCompany = {
                    '62b8b7e0-c368-4ec0-8fc6-cee8bbcbbe41': { name: 'ООО «АРИЛЬД»', color: '#00875a' },
                    '4016198a-5249-43b7-b3a0-a4cf53b96cd4': { name: 'ООО «ОЦБ»', color: '#ff8b00' },
                    'a284bfd4-08e5-4f7d-a11c-f745c3c8bdc5': { name: 'ООО «ОЦБ K»', color: '#ff8b00' },
                    'a0c2a815-daec-47f1-a558-c921f13482cc': { name: 'ООО «ГорТревел»', color: '#0747a6' },
                    '96c57522-c7b9-43fb-ab7a-15f98d3972d4': { name: 'ООО «Все Туры»', color: '#de350b' },
                    'eee2cd51-5bb0-495b-9067-ec30adfece47': { name: 'ООО «ГорТревел В»', color: '#403294' },
                    '387d946b-82e6-4a9d-bd02-1ebde5ebcd0a': { name: 'ИП Абрамов Денис Дмитриевич', color: '#ffab00' },
                    'd85b47f8-d524-4f85-9dd6-70100983fb49': { name: 'ООО «МСУ Тех»', color: '#66FF00' },
                    '7784c883-fad4-4402-ba0a-07fda56f5edb': { name: 'ООО СолнцеТур', color: '#505f79' }
                };
                return guidBookingCompany[guid] || { name: 'ООО НЕИЗВЕСТНО', color: 'pink' };
            };
            var urLico = getBookingCompanyByCBGuid(cbCompanyId);
            const divToAddParent = document.createElement('div');
            divToAddParent.id = 'urlicocbParent';
            divToAddParent.setAttribute('style', `
                width: 532px;
                height: 50px;
                position: relative;
                border: 10px solid ${urLico.color};
                border-radius: 10px;
                margin-bottom: 10px;
            `);
            const divToAddChild = document.createElement('div');
            divToAddChild.innerHTML = urLico.name;
            divToAddChild.id = 'urlicocbChild';
            divToAddChild.setAttribute('style', `
                margin: 0;
                position: absolute;
                top: 50%;
                left: 50%;
                -ms-transform: translate(-50%, -50%);
                transform: translate(-50%, -50%);
                font-weight: bold;
                font-size: x-large;
            `);
            divToAddParent.appendChild(divToAddChild);
            const priceInfo = document.querySelector('div.PRICEINFO');
            if (priceInfo) {
                priceInfo.prepend(divToAddParent);
            }
        }
        addPlashka(data.bookingCompanyId);
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_449.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_449.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_449__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/449 */ "./src/serverScripts/operators/449.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
/* harmony import */ var _app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/moveEvoucherDataToCustomer */ "./src/app/utils/chunks/moveEvoucherDataToCustomer.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_449__WEBPACK_IMPORTED_MODULE_0__.OneTouchTravel);
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({ url: 'https://online.onetouch.travel', cookieNames: _operators_449__WEBPACK_IMPORTED_MODULE_0__.OneTouchTravel.cookie.auth });
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({ url: 'https://sletat.onetouch.travel', cookieNames: _operators_449__WEBPACK_IMPORTED_MODULE_0__.OneTouchTravel.cookie.auth });
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, _operators_449__WEBPACK_IMPORTED_MODULE_0__.OneTouchTravel.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_449__WEBPACK_IMPORTED_MODULE_0__.OneTouchTravel.credentials.packet
            }));
            const regExp = /online\.onetouch\.travel\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_7__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            data.autoFillerData.customer = (0,_app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_12__.moveEvoucherDataToCustomer)(data.autoFillerData.customer, data);
            var paramas = {
                tourists: data.autoFillerData.touristDataItems,
                customer: data.autoFillerData.customer,
                countryTo: data.countryTo,
                bookingCompanyId: data.bookingCompanyId
            };
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'div.tourists-tabs');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [paramas]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_449__WEBPACK_IMPORTED_MODULE_0__.OneTouchTravel, errorText: null });
        }
        catch (e) {
            console.log("фатальная ошибка заполнение ОТТ");
            console.log(e);
            console.dir(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('ClaimFiller OneTouchTravel');
    var touristBlocks = document.querySelectorAll('.tourists-tabs .panel');
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(touristItem => {
            const element = block.querySelector(touristItem.htmlElementSelector);
            if (element) {
                element.value = touristItem.value;
            }
        });
    }
    function setSexRadios(index, tourist) {
        let sexTypeIndex = 0;
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                sexTypeIndex = 2;
                break;
            case 2:
            case 4:
            case 6:
                sexTypeIndex = 1;
                break;
        }
        document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function setCitezenship(index, tourist) {
        const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
        let text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
            if (tourist.citizenship === option.value) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
        var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
        searchinp.value = text;
        dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
        document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new MouseEvent('mouseup', { bubbles: true }));
    }
    ;
    function doFill(touristBlocks, tourists) {
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = tourists[index];
            const fieldIndex = index + 1;
            if (!tourist) {
                return;
            }
            const fields = [{
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][LASTLNAME]"]`,
                    value: tourist.surname
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][LASTNAME_LNAME]"]`,
                    value: tourist.surnameEng
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][FIRSTLNAME]"]`,
                    value: tourist.name
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][FIRSTNAME_LNAME]"]`,
                    value: tourist.nameEng
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][EMAIL]"]`,
                    value: tourist.email
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][PGIVENORG]"]`,
                    value: tourist.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="frm[People][${fieldIndex}][MOBILE]"]`,
                    value: tourist.phone ? '+7' + tourist.phone.slice(2) : ''
                }];
            handleTouristFields(fields, block);
            setSexRadios(index, tourist);
            setCitezenship(index, tourist);
        });
    }
    function addPlashka(cbCompanyId) {
        const getBookingCompanyByCBGuid = (guid) => {
            const guidBookingCompany = {
                '62b8b7e0-c368-4ec0-8fc6-cee8bbcbbe41': { name: 'ООО «АРИЛЬД»', color: '#00875a' },
                '4016198a-5249-43b7-b3a0-a4cf53b96cd4': { name: 'ООО «ОЦБ»', color: '#ff8b00' },
                'a284bfd4-08e5-4f7d-a11c-f745c3c8bdc5': { name: 'ООО «ОЦБ K»', color: '#ff8b00' },
                'a0c2a815-daec-47f1-a558-c921f13482cc': { name: 'ООО «ГорТревел»', color: '#0747a6' },
                '96c57522-c7b9-43fb-ab7a-15f98d3972d4': { name: 'ООО «Все Туры»', color: '#de350b' },
                'eee2cd51-5bb0-495b-9067-ec30adfece47': { name: 'ООО «ГорТревел В»', color: '#403294' },
                '387d946b-82e6-4a9d-bd02-1ebde5ebcd0a': { name: 'ИП Абрамов Денис Дмитриевич', color: '#ffab00' },
                'd85b47f8-d524-4f85-9dd6-70100983fb49': { name: 'ООО «МСУ Тех»', color: '#66FF00' },
                '7784c883-fad4-4402-ba0a-07fda56f5edb': { name: 'ООО СолнцеТур', color: '#505f79' }
            };
            return guidBookingCompany[guid] || { name: 'ООО НЕИЗВЕСТНО', color: 'pink' };
        };
        var urLico = getBookingCompanyByCBGuid(cbCompanyId);
        const divToAddParent = document.createElement('div');
        divToAddParent.id = 'urlicocbParent';
        divToAddParent.setAttribute('style', `
            width: 532px;
            height: 50px;
            position: relative;
            border: 10px solid ${urLico.color};
            border-radius: 10px;
            margin-bottom: 25px;
        `);
        const divToAddChild = document.createElement('div');
        divToAddChild.innerHTML = urLico.name;
        divToAddChild.id = 'urlicocbChild';
        divToAddChild.setAttribute('style', `
            margin: 0;
            position: absolute;
            top: 50%;
            left: 50%;
            -ms-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            font-weight: bold;
            font-size: x-large;
        `);
        divToAddParent.appendChild(divToAddChild);
        const priceInfo = document.querySelector('div.PRICEINFO');
        if (priceInfo) {
            priceInfo.prepend(divToAddParent);
        }
    }
    doFill(touristBlocks, data.tourists);
    function fillCustomer(customer, countryTo) {
        var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
        if (!block)
            return;
        const fields = [{
                htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                value: `${customer.surnameRus}`
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                value: `${customer.nameRus}`
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                value: `${customer.middleNameRus}`
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                value: customer.address
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                value: customer.birthday
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                value: customer.passportSeries
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                value: customer.passportNumber
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                value: customer.passportDate
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                value: customer.passportIssueOrg
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                value: customer.passportIssueCode
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                value: customer.phone
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                value: customer.email
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                value: customer.eVoucherContractDate
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                value: customer.eVoucherClaimNumber
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                value: customer.eVoucherCustomerPriceInPaymentCurrency
            }];
        setCustomerDocumentType(customer, countryTo);
        handleTouristFields(fields, block);
        // setSex(maleRadio, femaleRadio, tourist);
        // setCitezenship(index, tourist);
    }
    function getOptionIndexByName(text, optionsSelector) {
        const options = document.querySelectorAll(optionsSelector);
        for (var i = 0; i < options.length; i++) {
            var option = options[i];
            if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                return i;
            }
        }
        return 0;
    }
    function setCustomerDocumentType(tourist, countryTo) {
        let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
        if (optionIndex === 0) {
            optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
        }
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    if (data.customer) {
        fillCustomer(data.customer, data.countryTo);
    }
    addPlashka(data.bookingCompanyId);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_452.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_452.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _operators_452__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../operators/452 */ "./src/serverScripts/operators/452.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};









function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, } = context;
        const loginUrl = 'https://lk.d2insur.ru/sales/';
        try {
            var tab = yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_4__.removeCookiesCreateTabAndLogin)({
                operator: _operators_452__WEBPACK_IMPORTED_MODULE_8__.D2,
                newTabUrl: loginUrl,
                login: data.login,
                password: data.password
            });
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_7__.updateListener)(tab.id, (tabId, changeInfo, updatedTab) => {
                if (changeInfo.status === 'complete' && tabId === tab.id) {
                    console.log('updateListener complete');
                    //https://lk.d2insur.ru/sales
                    if (/https:\/\/lk\.d2insur\.ru\/sales\/(canceltrip|T4collective)\/\?id=\d+$/gm.test(updatedTab.url)) {
                        console.log('canceltrip|T4collective');
                        (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(updatedTab, 'form#protection-form')
                            .then(() => (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(updatedTab, claimFillerNew, [{
                                tourists: data.autoFillerData.touristDataItems,
                                customer: data.autoFillerData.customer,
                                travelDate: data.travelDate,
                                travelDateEnd: data.travelDateEnd
                            }]));
                    }
                    //https://lk.d2insur.ru/sales
                    if (/https:\/\/lk\.d2insur\.ru\/sales\/vzr\/\?id=\d+$/gm.test(updatedTab.url)) {
                        console.log('vzr');
                        (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(updatedTab, 'form#protection-form')
                            .then(() => (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(updatedTab, claimFillerNewVzr, [{
                                tourists: data.autoFillerData.touristDataItems,
                                customer: data.autoFillerData.customer,
                                travelDate: data.travelDate,
                                travelDateEnd: data.travelDateEnd
                            }]));
                    }
                    if (/https:\/\/lk\.d2insur\.ru\/sales\/(canceltrip|T4collective)\S+(key)/gm.test(updatedTab.url)) { // а тут отправка номер ТО
                        (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__.startTrackingIdSelectorWithClaimNumberValidation)(updatedTab, 'table#payment-tbl td.tdp-id', claimNumber)
                            .then((response) => (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_1__.sendIdsToBookingCenter)(claimNumber, response.claimNo && response.claimNo.trim()));
                    }
                }
                return true;
            });
        }
        catch (e) {
            console.log("D2 фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_2__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
// export function formFill2(context: IClaimFillerContext): Promise<void> {
//     const {
//         data,
//         secretField,
//         claimNumber,
//         sourceId,
//     } = context;
//     const loginUrl: string = 'https://lk.d2insur.ru/sales/';
//     let { tourUrl } = context;
//     let navigateUrl = '';
//     let claimDetails: ClaimDetails;
//     let sourceTab: chrome.tabs.Tab;
//     return Promise.resolve()
//         .then(() => new Promise( (resolve) => {
//             chrome.tabs.query({active: true, lastFocusedWindow: true}, (tabs: chrome.tabs.Tab[]) => {
//                 sourceTab = tabs[0];
//                 resolve();
//             });
//         }))
//         .then(() => {
//             claimDetails = {
//                 cityFrom: data.cityFrom,
//                 countryTo: data.countryTo,
//                 hotelName: data.hotelName,
//                 duration: data.duration,
//                 resort: data.resort,
//                 travelDate: data.travelDate
//             };
//             navigateUrl = tourUrl = handleNavigateUrl(tourUrl, D2);
//             if (! /^(http|https):\/\/.*$/.test(navigateUrl) ) {
//                 navigateUrl = `http://${navigateUrl}`;
//             }
//             D2.credentials!.login = data.login;
//             D2.credentials!.password = data.password;
//             switch (D2.authType) {
//                 case AuthTypes.BASIC:
//                     navigateUrl = insertUrlCreds(tourUrl, {
//                         username: D2.credentials!.login,
//                         password: D2.credentials!.password
//                     });
//                     break;
//                 case AuthTypes.FORMS:
//                     break;
//             }
//             let promise: Promise<void>;
//             if (D2.cookie.userInfo) {
//                 promise = checkCookie({
//                     url: loginUrl,
//                     cookieName: D2.cookie.userInfo,
//                     searchValue: D2.credentials!.login as string
//                 });
//             } else {
//                 promise = Promise.reject('');
//             }
//             return promise.then(
//                 () => console.log('Уже авторизованы под нужным пользователем.'),
//                 () => removeCookies({
//                     url: loginUrl,
//                     cookieNames: D2.cookie.auth
//                 })).then(() => createTab({
//                     active: true,
//                     url: loginUrl,
//                     windowId: chrome.windows.WINDOW_ID_CURRENT
//             }));
//         })
//         .then((tab: chrome.tabs.Tab) => {
//             const autofillData = {
//                 behaviorType: 'form_fill',
//                 token: secretField,
//                 claimNumber: claimNumber,
//                 operatorId: sourceId,
//                 bookingCompanyId: data.bookingCompanyId,
//             };
//             const t = tab;
//             const listener = (tabId: number, info: any) => {
//                 if (t && info.status === 'complete' && tabId === t.id) {
//                     setSessionStorageKeyInTab(t, 'autofill-data', JSON.stringify(autofillData));
//                     chrome.tabs.onUpdated.removeListener(listener);
//                 }
//             };
//             chrome.tabs.onUpdated.addListener(listener);
//             const fillerContext = {
//                 tab: tab,
//                 data: data.autoFillerData,
//                 claimNumber: claimNumber,
//                 sourceId: sourceId,
//                 navigateUrl: navigateUrl,
//                 autofillData: autofillData,
//                 claimDetails: claimDetails,
//                 sourceTab: sourceTab,
//             };
//             return navigateToClaimPage(tab, D2, D2.credentials!.packet)
//                 .then(() => waitForTabLoad(tab.id))
//                 .then(() => delay(2 * 1000))
//                 .then(() => new Promise((resolve, reject) => {
//                     const updatedLiscener = (tabId: number, changeInfo: any, tab: chrome.tabs.Tab) => {
//                         debugger;
//                         if (changeInfo.status === 'complete' && tabId === tab.id) {
//                             //https://lk.d2insur.ru/sales
//                             if (/https:\/\/lk\.d2insur\.ru\/sales\/(canceltrip|T4collective)\/\?id=\d+$/gm.test(tab.url as string)) {
//                                 startTrackingElement(tab, 'form#protection-form')
//                                 .then(() => executeScriptInTab(tab, {
//                                     code: stringifyFn(claimFillerNew, context.data )
//                                 }))
//                                 .then(() => resolve());
//                             }
//                             //https://lk.d2insur.ru/sales
//                             if (/https:\/\/lk\.d2insur\.ru\/sales\/vzr\/\?id=\d+$/gm.test(tab.url as string)) {
//                                 startTrackingElement(tab, 'form#protection-form')
//                                 .then(() => executeScriptInTab(tab, {
//                                     code: stringifyFn(claimFillerNewVzr, context.data )
//                                 }))
//                                 .then(() => resolve());
//                             }
//                             if (/https:\/\/lk\.d2insur\.ru\/sales\/(canceltrip|T4collective)\S+(key)/gm.test(tab.url as string)) { // а тут отправка номер ТО
//                                 startTrackingIdSelectorWithClaimNumberValidation(tab, 'table#payment-tbl td.tdp-id', fillerContext.claimNumber)
//                                 .then((response: any) => sendIdsToBookingCenter(fillerContext.claimNumber, response.claimNo && response.claimNo.trim()))
//                             }
//                         }
//                     };
//                     chrome.tabs.onUpdated.addListener(updatedLiscener)
//                     const removedLiscener = (tabId: number, removeInfo: chrome.tabs.TabRemoveInfo) => {
//                         if (tabId === tab.id) {
//                             chrome.tabs.onUpdated.removeListener(updatedLiscener);
//                             chrome.tabs.onRemoved.removeListener(removedLiscener);
//                         }
//                     };
//                     chrome.tabs.onRemoved.addListener(removedLiscener);
//                 }))
//                 .then(() => createPushNotification({ status: SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }))
//                 .catch((error: Error) => createPushNotification({ status: SendIdsStatus.FAIL, message: error.message }));
//         });
// }
function claimFillerNew(data) {
    // const buttonTeg: HTMLButtonElement = document.createElement('button') as HTMLButtonElement;
    // buttonTeg.id = 'autoFillButton';
    // buttonTeg.setAttribute('onClick', 'doFillScript()');
    // document.body.appendChild(buttonTeg);
    // const scriptTeg: HTMLScriptElement = document.createElement('script') as HTMLScriptElement;
    // scriptTeg.id = 'autoFillScript';
    // scriptTeg.innerHTML = `
    //     function doFillScript() {
    //         debugger;
    //         var data = ${JSON.stringify(data)};
    //         ${doFill.toString()}
    //         ${delay.toString()}
    //         ${fillField.toString()}
    //         ${handleTouristFields.toString()}
    //         ${doInsurantFill.toString()}
    //         ${doTouristFill.toString()}
    //         doFill(data)
    //         .then(
    //             () => console.log('done'),
    //             () => console.log('done with reject')
    //         );
    //     }
    // `;
    // document.body.appendChild(scriptTeg);
    // (document.querySelector('#autoFillButton') as HTMLButtonElement).click();
    function doFill(data) {
        debugger;
        let chain = new Promise(resolse => resolse());
        var touristCountSelector = document.querySelectorAll('div.filter div.filter-tabs a.one-tab');
        const allowedTouristsCount = parseInt(touristCountSelector[touristCountSelector.length - 1].textContent || '', 10);
        const touristsCount = data.tourists.length;
        if (touristsCount > allowedTouristsCount) {
            alert(`К огромному сожалению туристов(${touristsCount}) больше чем можно оформить в данном полисе(${allowedTouristsCount}). Дальше придется все делать лапками.`);
            return chain = chain.then(() => new Promise((resolve, reject) => reject()));
        }
        touristCountSelector[touristsCount - 1].click();
        document.querySelectorAll('div.filter div.filter-tabs a.one-tab2')[1].click(); // Клиент и Застрахованный №1 совпадают: "Нет"
        let insurant = data.customer;
        if (!insurant) {
            for (let i = 0; i < data.tourists.length; i++) {
                const tourist = data.tourists[i];
                if (tourist.phone && tourist.phone !== '') {
                    insurant = tourist;
                    break;
                }
            }
        }
        if (!insurant) {
            insurant = data.tourists[0]; // если ни одного туриста с телефоном не нашли, тогда первого
        }
        const formElement = document.querySelector('form#protection-form');
        chain = chain.then(() => fillField(formElement, {
            htmlElementSelector: 'input#BEGIN_DATE_FIELD',
            value: data.travelDate || null
        }));
        chain = chain.then(() => fillField(formElement, {
            htmlElementSelector: 'input#END_DATE_FIELD',
            value: data.travelDateEnd || null
        }));
        chain = chain.then(() => NotFilledField('div.formSelect2List'));
        chain = chain.then(() => doInsurantFill(formElement, insurant));
        Array.prototype.forEach.call(data.tourists, (tourist, index) => {
            // if(index === 0) {
            //     chain.then(() => new Promise<void>(resolve => resolve()));
            //     return;
            // }
            if (!tourist) {
                chain = chain.then(() => new Promise((resolve, reject) => reject()));
            }
            chain = chain.then(() => doTouristFill(formElement, tourist, index));
        });
        return chain.then(() => new Promise(resolve => resolve()));
    }
    function NotFilledField(htmlSelector) {
        let block = document.querySelector(htmlSelector);
        block.style.border = "10px solid red";
        block.style.borderRadius = '20px';
        // let defaultSelectedValueDiv = document.querySelector(`${touristField.htmlElementSelector} span.filter-option`) as HTMLDivElement;
        // if(defaultSelectedValueDiv && defaultSelectedValueDiv.innerText) {
        //     console.log(`defaultSelectedValueDiv = ${defaultSelectedValueDiv && defaultSelectedValueDiv.innerText}`);
        //     console.log(`touristField.value = ${touristField.value}`);
        //     if(defaultSelectedValueDiv.innerText === touristField.value) {
        //         return;
        //     }
        // }
        // if(block) {
        //     (block as HTMLDivElement).style!.border = "10px solid red";
        //     (block as HTMLDivElement).style!.borderRadius = '20px';
        //     if(touristField.value) {
        //         let div = document.createElement("div");
        //         div.style.textAlign = 'center';
        //         div.append(`--> ${touristField.value} <--`);
        //         (block as HTMLDivElement).appendChild(div);
        //     }
        // }
    }
    function delay(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function fillField(block, touristField) {
        return new Promise((resolve, reject) => {
            const element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.dispatchEvent(new Event('focus', { bubbles: true }));
                element.value = touristField.value;
                element.dispatchEvent(new Event('input', { bubbles: true }));
                element.dispatchEvent(new Event('change', { bubbles: true }));
                element.dispatchEvent(new Event('keyup', { bubbles: true }));
            }
            resolve();
        })
            .then(() => delay(touristField.delay || 500));
    }
    function handleTouristFields(touristFields, block) {
        let chain = new Promise(resolse => resolse());
        touristFields.forEach(touristItem => {
            chain = chain.then(() => fillField(block, touristItem));
        });
        return chain;
    }
    function doTouristFill(block, tourist, index) {
        const fields = [{
                htmlElementSelector: `input#INSURED_SURNAME${index + 1}`,
                value: tourist.surnameRus
            }, {
                htmlElementSelector: `input#INSURED_FIRSTNAME${index + 1}`,
                value: tourist.nameRus
            }, {
                htmlElementSelector: `input#INSURED_LASTNAME${index + 1}`,
                value: tourist.middleNameRus
            }, {
                htmlElementSelector: `input#INSURED_BIRTHDAY${index + 1}`,
                value: tourist.birthday,
                delay: 1000
            }, {
                htmlElementSelector: `input#INSURED_OWNERKIN${index + 1}`,
                value: (tourist.passportSeries || '') + (tourist.passportNumber || '')
            }];
        return handleTouristFields(fields, block);
    }
    function doInsurantFill(block, tourist) {
        if (!tourist) {
            return new Promise((resolve, reject) => resolve());
        }
        const fields = [{
                htmlElementSelector: `input#INSURER_SURNAME`,
                value: tourist.surnameRus
            }, {
                htmlElementSelector: `input#INSURER_FIRSTNAME`,
                value: tourist.nameRus
            }, {
                htmlElementSelector: `input#INSURER_LASTNAME`,
                value: tourist.middleNameRus
            }, {
                htmlElementSelector: `input#INSURER_ADDRESS`,
                value: tourist.address
            }, {
                htmlElementSelector: `input#INSURER_BIRTHDAY`,
                value: tourist.birthday,
                delay: 1000
            }, {
                htmlElementSelector: `input#INSURER_PHONE`,
                value: tourist.phone
            }, {
                htmlElementSelector: `input#PASSPORT_NUMBER`,
                value: (tourist.passportSeries || '') + (tourist.passportNumber || '')
            }, {
                htmlElementSelector: `input#INSURER_EMAIL`,
                value: tourist.email || ''
            }];
        return handleTouristFields(fields, block);
    }
    doFill(data);
}
function claimFillerNewVzr(data) {
    // const buttonTeg: HTMLButtonElement = document.createElement('button') as HTMLButtonElement;
    // buttonTeg.id = 'autoFillButton';
    // buttonTeg.setAttribute('onClick', 'doFillScript()');
    // document.body.appendChild(buttonTeg);
    // const scriptTeg: HTMLScriptElement = document.createElement('script') as HTMLScriptElement;
    // scriptTeg.id = 'autoFillScript';
    // scriptTeg.innerHTML = `
    //     function doFillScript() {
    //         debugger;
    //         var data = ${JSON.stringify(data)};
    //         ${doFill.toString()}
    //         ${delay.toString()}
    //         ${fillField.toString()}
    //         ${handleTouristFields.toString()}
    //         ${doInsurantFill.toString()}
    //         ${doTouristFill.toString()}
    //         doFill(data)
    //         .then(
    //             () => console.log('done'),
    //             () => console.log('done with reject')
    //         );
    //     }
    // `;
    // document.body.appendChild(scriptTeg);
    // (document.querySelector('#autoFillButton') as HTMLButtonElement).click();
    function doFill(data) {
        debugger;
        let chain = new Promise(resolse => resolse());
        chain = chain.then(() => fillField(document.querySelector('div.insurance-param__item-inputs_number'), {
            htmlElementSelector: 'input[name=insurance-number-adult]',
            value: data.tourists.length
        }));
        let insurant = data.customer;
        if (!insurant) {
            for (let i = 0; i < data.tourists.length; i++) {
                const tourist = data.tourists[i];
                if (tourist.phone && tourist.phone !== '') {
                    insurant = tourist;
                    break;
                }
            }
        }
        if (!insurant) {
            insurant = data.tourists[0]; // если ни одного туриста с телефоном не нашли, тогда первого
        }
        const formElement = document.querySelector('form#protection-form');
        chain = chain.then(() => fillField(formElement, {
            htmlElementSelector: 'input#BEGIN_DATE',
            value: data.travelDate || ''
        }));
        chain = chain.then(() => fillField(formElement, {
            htmlElementSelector: 'input#END_DATE',
            value: data.travelDateEnd || ''
        }));
        chain = chain.then(() => NotFilledField('div.insurer-group select#INSURER_COUNTRY'));
        chain = chain.then(() => doInsurantFill(formElement, insurant));
        function NotFilledField(htmlSelector) {
            let block = document.querySelector(htmlSelector);
            block.parentNode.style.border = "10px solid red";
            block.parentNode.style.borderRadius = '20px';
            // let defaultSelectedValueDiv = document.querySelector(`${touristField.htmlElementSelector} span.filter-option`) as HTMLDivElement;
            // if(defaultSelectedValueDiv && defaultSelectedValueDiv.innerText) {
            //     console.log(`defaultSelectedValueDiv = ${defaultSelectedValueDiv && defaultSelectedValueDiv.innerText}`);
            //     console.log(`touristField.value = ${touristField.value}`);
            //     if(defaultSelectedValueDiv.innerText === touristField.value) {
            //         return;
            //     }
            // }
            // if(block) {
            //     (block as HTMLDivElement).style!.border = "10px solid red";
            //     (block as HTMLDivElement).style!.borderRadius = '20px';
            //     if(touristField.value) {
            //         let div = document.createElement("div");
            //         div.style.textAlign = 'center';
            //         div.append(`--> ${touristField.value} <--`);
            //         (block as HTMLDivElement).appendChild(div);
            //     }
            // }
        }
        Array.prototype.forEach.call(data.tourists, (tourist, index) => {
            // if(index === 0) {
            //     chain.then(() => new Promise<void>(resolve => resolve()));
            //     return;
            // }
            if (!tourist) {
                chain = chain.then(() => new Promise((resolve, reject) => reject()));
            }
            chain = chain.then(() => doTouristFill(formElement, tourist, index));
        });
        return chain.then(() => new Promise(resolve => resolve()));
    }
    function delay(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function fillField(block, touristField) {
        return new Promise((resolve, reject) => {
            const element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.dispatchEvent(new Event('focus', { bubbles: true }));
                element.value = touristField.value;
                element.dispatchEvent(new Event('input', { bubbles: true }));
                element.dispatchEvent(new Event('change', { bubbles: true }));
                element.dispatchEvent(new Event('keyup', { bubbles: true }));
            }
            resolve();
        })
            .then(() => delay(touristField.delay || 500));
    }
    function handleTouristFields(touristFields, block) {
        let chain = new Promise(resolse => resolse());
        touristFields.forEach(touristItem => {
            chain = chain.then(() => fillField(block, touristItem));
        });
        return chain;
    }
    function doTouristFill(block, tourist, index) {
        const fields = [{
                htmlElementSelector: `input#INSURED${index + 1}`,
                value: `${tourist.surnameEng} ${tourist.nameEng} ${tourist.middleNameEng}`
            }, {
                htmlElementSelector: `input#INSURED_BIRTHDAY${index + 1}`,
                value: tourist.birthday,
                delay: 1000
            }, {
                htmlElementSelector: `input#INSURED_PASSPORT${index + 1}`,
                value: `${tourist.passportSeries} ${tourist.passportNumber}`
            }];
        return handleTouristFields(fields, block);
    }
    function doInsurantFill(block, tourist) {
        if (!tourist) {
            return new Promise((resolve, reject) => resolve());
        }
        const fields = [{
                htmlElementSelector: `input#INSURER_SURNAME`,
                value: tourist.surnameEng
            }, {
                htmlElementSelector: `input#INSURER_FIRSTNAME`,
                value: tourist.nameEng
            }, {
                htmlElementSelector: `input#INSURER_LASTNAME`,
                value: tourist.middleNameEng
            }, {
                htmlElementSelector: `input#INSURER_ADDRESS`,
                value: tourist.address
            }, {
                htmlElementSelector: `input#INSURER_BIRTHDAY`,
                value: tourist.birthday,
                delay: 1000
            }, {
                htmlElementSelector: `input#INSURER_PHONE`,
                value: tourist.phone
            }, {
                htmlElementSelector: `input#PASSPORT_NUMBER`,
                value: `${tourist.passportSeries} ${tourist.passportNumber}`
            }, {
                htmlElementSelector: `input#INSURER_EMAIL`,
                value: tourist.email
            }];
        return handleTouristFields(fields, block);
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_454.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_454.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/moveEvoucherDataToCustomer */ "./src/app/utils/chunks/moveEvoucherDataToCustomer.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _operators_454__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../operators/454 */ "./src/serverScripts/operators/454.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__.removeCookiesForTouroperator)(_operators_454__WEBPACK_IMPORTED_MODULE_13__.IziTour);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_5__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__.startTrackingElement)(tab, _operators_454__WEBPACK_IMPORTED_MODULE_13__.IziTour.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_454__WEBPACK_IMPORTED_MODULE_13__.IziTour.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_3__.wait)(1000);
            data.autoFillerData.customer = (0,_app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_8__.moveEvoucherDataToCustomer)(data.autoFillerData.customer, data);
            const regExp = /online\.izi\.tours\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_10__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ claimId: claimNumber, operator: _operators_454__WEBPACK_IMPORTED_MODULE_13__.IziTour, errorText: null });
        }
        catch (e) {
            console.log("Loti фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(index, tourist, countryTo) {
            let optionIndex = -1;
            var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function handleTouristFields(block, touristFields) {
            touristFields.forEach(touristField => {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    console.log(touristField.value);
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        ;
        function preparePhone(phone) {
            if (phone) {
                phone = phone.replace(/\D/g, '');
                if (phone && phone.startsWith('7')) {
                    return '+' + phone;
                }
                if (phone && phone.startsWith('8')) {
                    return '+7' + phone.substr(1, phone.length);
                }
            }
            return phone;
        }
        function toUpperCase(input) {
            if (!input || input === '') {
                return '';
            }
            return input.toUpperCase();
        }
        function setCitezenship(index, tourist) {
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenship === option.value) {
                    text = option.innerText;
                }
            });
            if (!text) {
                return;
            }
            var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function setSexRadios(tourist, sexRadios) {
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexRadios[0].checked = true;
                    break;
                case 2:
                case 4:
                case 6:
                    sexRadios[1].checked = true;
                    break;
            }
        }
        function setHuman(index, tourist) {
            // 0 - CHD
            // 1 - MR
            // 2 - MRS
            let humanDdItemIndex = 0;
            switch (tourist.touristType) {
                case 1:
                    humanDdItemIndex = 1;
                    break;
                case 2:
                    humanDdItemIndex = 2;
                    break;
                case 3:
                    humanDdItemIndex = 0;
                    break;
                case 4:
                    humanDdItemIndex = 0;
                    break;
                case 5:
                    humanDdItemIndex = 0;
                    break;
                case 6:
                    humanDdItemIndex = 0;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function getOptionIndexByName(text, optionsSelector) {
            const options = document.querySelectorAll(optionsSelector);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function setCustomerDocumentType(tourist, countryTo) {
            let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
            }
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: `${customer.surnameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: `${customer.nameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: `${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                    value: customer.birthday
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                    value: customer.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                    value: customer.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                    value: customer.passportIssueCode
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(block, fields);
            // setSex(maleRadio, femaleRadio, tourist);
            // setCitezenship(index, tourist);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            setDocumentType(index, tourist, data.countryTo);
            const touristFields = [{
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
                }];
            handleTouristFields(block, touristFields);
            const sexRadios = block.querySelectorAll('input[id^="SEX"]');
            setSexRadios(tourist, sexRadios);
            setCitezenship(index, tourist);
            setHuman(index, tourist);
            console.log(index);
        });
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_457.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_457.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/moveEvoucherDataToCustomer */ "./src/app/utils/chunks/moveEvoucherDataToCustomer.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _operators_457__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../operators/457 */ "./src/serverScripts/operators/457.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__.removeCookiesForTouroperator)(_operators_457__WEBPACK_IMPORTED_MODULE_13__.FunSunKz);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_5__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__.startTrackingElement)(tab, _operators_457__WEBPACK_IMPORTED_MODULE_13__.FunSunKz.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_457__WEBPACK_IMPORTED_MODULE_13__.FunSunKz.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_3__.wait)(2 * 1000);
            data.autoFillerData.customer = (0,_app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_8__.moveEvoucherDataToCustomer)(data.autoFillerData.customer, data);
            const regExp = /online\.izi\.tours\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_2__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_11__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_10__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_7__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ claimId: claimNumber, operator: _operators_457__WEBPACK_IMPORTED_MODULE_13__.FunSunKz, errorText: null });
        }
        catch (e) {
            console.log("FunSunKz фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('ClaimFiller FunSunKz');
    debugger;
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
        FieldType[FieldType["Human"] = 6] = "Human";
    })(FieldType || (FieldType = {}));
    function localWait(timeout, optionIndex) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(optionIndex), timeout);
        });
    }
    var mainChain = new Promise((res, rej) => res());
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function fillDocType(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            let optionIndex = -1;
            var optionsSelector = `${touristField.htmlElementSelector} option`;
            if (getTouristAge(touristField.value) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(data.countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (touristField.value.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            res(optionIndex);
        }))
            .then((optionIndex) => new Promise((res, rej) => {
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            res(optionIndex);
        }))
            .then((optionIndex) => localWait(250, optionIndex))
            .then((optionIndex) => new Promise((res, rej) => {
            try {
                block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            }
            catch (e) {
                console.log('fillDocType fail');
                console.log(e);
                console.dir(e);
            }
            res();
        }));
    }
    function fillText(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            const element = block.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                element.value = touristField.value;
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
            res();
        }));
    }
    function fillHuman(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            // 0 - CHD
            // 1 - MR
            // 2 - MRS
            let humanDdItemIndex = 0;
            switch (touristField.value) {
                case 1:
                    humanDdItemIndex = 2;
                    break;
                case 2:
                    humanDdItemIndex = 3;
                    break;
                case 3:
                    humanDdItemIndex = 1;
                    break;
                case 4:
                    humanDdItemIndex = 1;
                    break;
                case 5:
                    humanDdItemIndex = 1;
                    break;
                case 6:
                    humanDdItemIndex = 1;
                    break;
            }
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            res();
        }));
    }
    function fillSex(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            let sexTypeIndex = 0;
            switch (touristField.value) {
                case 1:
                case 3:
                case 5:
                    sexTypeIndex = 2;
                    break;
                case 2:
                case 4:
                case 6:
                    sexTypeIndex = 1;
                    break;
            }
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            res();
        }));
    }
    function fillCitizenship(block, touristField) {
        const select = block.querySelector(touristField.htmlElementSelector);
        let text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
            if (touristField.value === option.innerText) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var searchinp = document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container input`);
        var dropdown = document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`);
        searchinp.value = text;
        dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
        document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    ;
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(touristField => {
            switch (touristField.fieldType) {
                case FieldType.Human:
                    fillHuman(block, touristField);
                    break;
                case FieldType.Sex:
                    fillSex(block, touristField);
                    break;
                case FieldType.Text:
                    fillText(block, touristField);
                    break;
                case FieldType.Citizenship:
                    fillCitizenship(block, touristField);
                    break;
                case FieldType.Select:
                    fillDocType(block, touristField);
                    break;
                default: break;
            }
            mainChain = mainChain.then(() => localWait(touristField.delay || 250, 0));
        });
    }
    ;
    function preparePhone(phone) {
        if (phone) {
            phone = phone.replace(/\D/g, '');
            if (phone && phone.startsWith('7')) {
                return '+' + phone;
            }
            if (phone && phone.startsWith('8')) {
                return '+7' + phone.substr(1, phone.length);
            }
        }
        return phone;
    }
    function toUpperCase(input) {
        if (!input || input === '') {
            return '';
        }
        return input.toUpperCase();
    }
    function getOptionIndexByName(text, optionsSelector) {
        const options = document.querySelectorAll(optionsSelector);
        for (var i = 0; i < options.length; i++) {
            var option = options[i];
            if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                return i;
            }
        }
        return 0;
    }
    function fillCustomer(customer, countryTo) {
        var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
        if (!block)
            return;
        const fields = [{
                htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                value: `${customer.surnameRus}`,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                value: `${customer.nameRus}`,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                value: `${customer.middleNameRus}`,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                value: customer.address,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                value: customer.birthday,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                value: customer.passportSeries,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                value: customer.passportNumber,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                value: customer.passportDate,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                value: customer.passportIssueOrg,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                value: customer.passportIssueCode,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                value: customer.phone,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                value: customer.email,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                value: customer.eVoucherContractDate,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                value: customer.eVoucherClaimNumber,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                value: customer.eVoucherCustomerPriceInPaymentCurrency,
                fieldType: FieldType.Text
            }];
        setCustomerDocumentType(customer, countryTo);
        handleTouristFields(block, fields);
        // setSex(maleRadio, femaleRadio, tourist);
        // setCitezenship(index, tourist);
    }
    function setCustomerDocumentType(tourist, countryTo) {
        let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
        if (optionIndex === 0) {
            optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
        }
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            //setDocumentType(index, tourist, data.countryTo);
            const touristFields = [
                {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][HUMAN]"]`,
                    value: tourist.touristType,
                    fieldType: FieldType.Human
                }, {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][MALE]"]`,
                    value: tourist.touristType,
                    fieldType: FieldType.Sex
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday,
                    fieldType: FieldType.Text,
                    delay: 2 * 1000
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"], input[name="frm[People][${index + 1}][PHONE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru',
                    fieldType: FieldType.Text
                },
                // {
                //     htmlElementSelector: `input[name="frm[People][${index + 1}][INN]"]`,
                //     value: tourist.email || 'ocb@corp.sletat.ru',
                //     fieldType: FieldType.Text
                // },
                {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][NATIONALITY]"]`,
                    value: tourist.citizenshipName,
                    fieldType: FieldType.Citizenship,
                    delay: 2 * 1000
                }, {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"]`,
                    value: tourist,
                    fieldType: FieldType.Select,
                    delay: 5 * 1000
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase(),
                    fieldType: FieldType.Text
                }
            ];
            handleTouristFields(document.querySelector('div.samo_container'), touristFields);
            // const sexRadios = block.querySelectorAll('input[id^="SEX"]') as NodeListOf<HTMLInputElement>;
            // setSexRadios(tourist, sexRadios);
            // setCitezenship(index, tourist);
            // setHuman(index, tourist);
            // console.log(index);
        });
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_51.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_51.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_51__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/51 */ "./src/serverScripts/operators/51.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/common/oneForNoData */ "./src/app/utils/chunks/common/oneForNoData.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_51__WEBPACK_IMPORTED_MODULE_0__.Ambotis);
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({ url: 'https://online2.ambotis.ru', cookieNames: _operators_51__WEBPACK_IMPORTED_MODULE_0__.Ambotis.cookie.auth });
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            Array.prototype.forEach.call(data.autoFillerData.touristDataItems, tourist => {
                return (0,_app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_10__.oneForNoData)(tourist);
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, _operators_51__WEBPACK_IMPORTED_MODULE_0__.Ambotis.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_8__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_9__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_51__WEBPACK_IMPORTED_MODULE_0__.Ambotis.credentials.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000);
            // const regExp: RegExp = /(online|online2)\.ambotis\.ru\/cl_refer\?CLAIM=(\d+)/;
            // @ts-ignore
            (_a = data.autoFillerData.customer) === null || _a === void 0 ? void 0 : _a.eVoucherClaimNumber = data.eVoucherClaimNumber;
            // @ts-ignore
            (_b = data.autoFillerData.customer) === null || _b === void 0 ? void 0 : _b.eVoucherCurrency = data.eVoucherCurrency;
            // @ts-ignore
            (_c = data.autoFillerData.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
            try {
                // @ts-ignore
                (_d = data.autoFillerData.customer) === null || _d === void 0 ? void 0 : _d.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
            }
            catch (e) { }
            // updateListenerOnSpecificPage(
            //     tab.id,
            //     regExp,
            //     (tabId: number, changeInfo: any, updatedTab: chrome.tabs.Tab) => {
            //         const parsedUrl = updatedTab!.url!.match(regExp);
            //         if(parsedUrl && parsedUrl.length >= 2) {
            //             sendIdsToBookingCenter(claimNumber, parsedUrl[1])
            //             .then(() => createPushNotification({ status: SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
            //         }
            //         startTrackingElement(updatedTab, 'div.orders')
            //         .then(() => removeSamoPassportBlur(updatedTab))
            //         return true;
            //     }
            // );
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            var response = yield (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_12__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'span.claim', claimNumber);
            yield (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_51__WEBPACK_IMPORTED_MODULE_0__.Ambotis, errorText: null });
        }
        catch (e) {
            console.log("Ambotis фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(index, tourist, countryTo) {
            let optionIndex = -1;
            var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function handleTouristFields(block, touristFields) {
            touristFields.forEach(touristField => {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    console.log(touristField.value);
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        ;
        function preparePhone(phone) {
            if (phone) {
                phone = phone.replace(/\D/g, '');
                if (phone && phone.startsWith('7')) {
                    return '+' + phone;
                }
                if (phone && phone.startsWith('8')) {
                    return '+7' + phone.substr(1, phone.length);
                }
            }
            return phone;
        }
        function toUpperCase(input) {
            if (!input || input === '') {
                return '';
            }
            return input.toUpperCase();
        }
        function setCitezenship(index, tourist) {
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenship === option.value) {
                    text = option.innerText;
                }
            });
            if (!text) {
                return;
            }
            var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function setSex(index, tourist) {
            let sexTypeIndex = 0;
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexTypeIndex = 2;
                    break;
                case 2:
                case 4:
                case 6:
                    sexTypeIndex = 1;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function setHuman(index, tourist) {
            let humanDdItemIndex = 0;
            switch (tourist.touristType) {
                case 1:
                    humanDdItemIndex = 2;
                    break;
                case 2:
                    humanDdItemIndex = 3;
                    break;
                case 3:
                    humanDdItemIndex = 1;
                    break;
                case 4:
                    humanDdItemIndex = 1;
                    break;
                case 5:
                    humanDdItemIndex = 1;
                    break;
                case 6:
                    humanDdItemIndex = 1;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            if (document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`)) {
                document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            }
        }
        ;
        function getOptionIndexByName(text, optionsSelector) {
            const options = document.querySelectorAll(optionsSelector);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function setCustomerDocumentType(tourist, countryTo) {
            let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
            }
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: `${customer.surnameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: `${customer.nameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: `${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                    value: customer.birthday
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                    value: customer.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                    value: customer.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                    value: customer.passportIssueCode
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(block, fields);
            // setSex(maleRadio, femaleRadio, tourist);
            // setCitezenship(index, tourist);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            setDocumentType(index, tourist, data.countryTo);
            const touristFields = [{
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
                }];
            setHuman(index, tourist);
            setSex(index, tourist);
            setCitezenship(index, tourist);
            handleTouristFields(block, touristFields);
            console.log(index);
        });
    }
    doFill(data);
}
// function claimFiller(data: FillerParams) {
//     const buttonTeg: HTMLButtonElement = document.createElement('button') as HTMLButtonElement;
//     buttonTeg.id = 'autoFillButton';
//     buttonTeg.setAttribute('onClick', 'doFillScript()');
//     document.body.appendChild(buttonTeg);
//     const scriptTeg: HTMLScriptElement = document.createElement('script') as HTMLScriptElement;
//     scriptTeg.id = 'autoFillScript';
//     scriptTeg.innerHTML = `
//         function doFillScript() {
//             debugger;
//             var touristBlocks = document.querySelectorAll('.tourists-tabs .panel');
//             var data = ${JSON.stringify(data)};
//             ${doFill.toString()}
//             doFill(touristBlocks, data);
//         }
//     `;
//     document.body.appendChild(scriptTeg);
//     (document.querySelector('#autoFillButton') as HTMLButtonElement).click();
//     const touristBlocks = document.querySelectorAll('.tourists-tabs .panel') as NodeListOf<HTMLDivElement>;
//     function doFill(touristBlocks: NodeListOf<HTMLDivElement>, data: FillerParams) {
//         function getOptionIndexByName(text: string, optionsSelector: string): number {
//             const options = document.querySelectorAll(optionsSelector) as NodeListOf<HTMLOptionElement>;
//             for(var i = 0; i < options.length; i++) {
//                 var option = options[i];
//                 if(option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
//                     return i;
//                 }
//             }
//             return 0;
//         }
//         function getTouristAge(tourist: Tourist): number {
//             const [ day, month, year ] = tourist.birthday!.split('.');
//             const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
//             const ageDate = new Date(ageDiffMs);
//             return ageDate.getUTCFullYear() - 1970;
//         }
//         function setDocumentType(index: number, tourist: Tourist, countryTo: string) {
//             let optionIndex: number = -1;
//             var optionsSelector: string = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`
//             if(getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
//                 optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
//                 if(optionIndex === 0) {
//                     optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
//                 }
//             } else {
//                 if(tourist.isNationalPassport) {
//                     optionIndex = getOptionIndexByName('Passport', optionsSelector);
//                     if(optionIndex === 0) {
//                         optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
//                     }
//                 } else {
//                     optionIndex = getOptionIndexByName('International passport', optionsSelector);
//                     if(optionIndex === 0) {
//                         optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
//                     }
//                 }
//             }
//             const script = document.createElement('script');
//             const code = document.createTextNode(`
//                 document.querySelector('select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container').dispatchEvent(new Event('mousedown'));
//                 $ = samo.jQuery;
//                 $('select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]').mouseup();
//             `);
//             script.appendChild(code);
//             (document.body || document.head).appendChild(script);
//         }
//         const setCitezenship = (index: number, tourist: Tourist) => {
//             const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`) as HTMLSelectElement;
//             let text = undefined;
//             Array.prototype.forEach.call(select.querySelectorAll('option'), (option: HTMLOptionElement) => {
//                 if (tourist.citizenship === option.value) {
//                     text = option.innerText;
//                 }
//             });
//             if (!text) { return; }
//             const script = document.createElement('script');
//             const code = document.createTextNode(`
//                 var searchinp = document.querySelector('select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input')
//                 var dropdown = document.querySelector('select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container');
//                 searchinp.value = "${text}";
//                 dropdown.dispatchEvent(new Event('mousedown'));
//                 $ = samo.jQuery;
//                 $('select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted').mouseup()
//             `);
//             script.appendChild(code);
//             (document.body || document.head).appendChild(script);
//         };
//         const setSexSelect = (select: HTMLSelectElement, maleRadio: HTMLInputElement, femaleRadio: HTMLInputElement,  tourist: Tourist) => {
//             switch (tourist.touristType) {
//                 case 1:
//                 case 3:
//                 case 5:
//                     maleRadio.click();
//                     break;
//                 case 2:
//                 case 4:
//                 case 6:
//                     femaleRadio.click();
//                     break;
//             }
//             // 0 -- CHD
//             // 1 -- MR
//             // 2 -- MRS
//             // maleGrown = 1,
//             // femaleGrown = 2,
//             // maleChild = 3,
//             // femaleChild = 4,
//             // maleInfant = 5,
//             // femaleInfant = 6
//             switch (tourist.touristType) {
//                 case 3:
//                 case 4:
//                     select.options[0].selected = true;
//                     break;
//                 case 5:
//                 case 6:
//                     break;
//                 case 1:
//                     select.options[1].selected = true;
//                     break;
//                 case 2:
//                     select.options[2].selected = true;
//                     break;
//             }
//         };
//         function handleTouristFields(touristFields: TouristFieldElement[], block: HTMLDivElement) {
//             touristFields.forEach(touristItem => {
//                 const element = block.querySelector(touristItem.htmlElementSelector) as HTMLInputElement;
//                 if (element) {
//                     element.value = touristItem.value as string;
//                 }
//             });
//         }
//         Array.prototype.forEach.call(touristBlocks, (block: HTMLDivElement, index: number) => {
//             const tourist = data.tourists[index];
//             const fieldIndex = index + 1;
//             if (!tourist) {return; }
//             const fields: TouristFieldElement[] = [{
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][LASTLNAME]"]`,
//                 value: tourist.surname
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][LASTNAME_LNAME]"]`,
//                 value: tourist.surnameEng
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][FIRSTLNAME]"]`,
//                 value: tourist.name
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][FIRSTNAME_LNAME]"]`,
//                 value: tourist.nameEng
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][BORN]"]`,
//                 value: tourist.birthday
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][EMAIL]"]`,
//                 value: tourist.email
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][PSERIE]"]`,
//                 value: tourist.passportSeries
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][PNUMBER]"]`,
//                 value: tourist.passportNumber
//             },  {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][PVALID]"]`,
//                 value: tourist.passportExpireDate
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][PGIVEN]"]`,
//                 value: tourist.passportDate
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][PGIVENORG]"]`,
//                 value: tourist.passportIssueOrg
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${fieldIndex}][MOBILE]"]`,
//                 value: tourist.phone ? '+7' + tourist.phone.slice(2) : ''
//             }];
//             const sexSelect = block.querySelector(`select[name="frm[People][${fieldIndex}][HUMAN]"]`) as HTMLSelectElement;
//             const maleradio = block.querySelector(`#SEX_M_${fieldIndex}`) as HTMLInputElement;
//             const femaleradio = block.querySelector(`#SEX_F_${fieldIndex}`) as HTMLInputElement;
//             const citizenshipSelect = block.querySelector(`select[name="frm[People][${fieldIndex}][NATIONALITY]"]`) as HTMLSelectElement;
//             const citizenshipContainer = block.querySelector(`select[name="frm[People][${fieldIndex}][NATIONALITY]"] ~ .chosen-container`) as HTMLDivElement;
//             handleTouristFields(fields, block);
//             setSexSelect(sexSelect, maleradio, femaleradio, tourist);
//             setCitezenship(index, tourist);
//             setDocumentType(index, tourist, data.countryTo);
//         });
//     }
// }


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_54.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_54.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _operators_54__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../operators/54 */ "./src/serverScripts/operators/54.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/oneForNoData */ "./src/app/utils/chunks/common/oneForNoData.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};















function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            function getInvoiceEmailByCBCompany(bookingCompanyId) {
                switch (bookingCompanyId.toUpperCase()) {
                    case '62B8B7E0-C368-4EC0-8FC6-CEE8BBCBBE41': return 'Aryld@corp.sletat.ru';
                    case '4016198A-5249-43B7-B3A0-A4CF53B96CD4': return 'ocb@corp.sletat.ru'; // ну 2 ОЦБ, ну что поделать
                    case 'A284BFD4-08E5-4F7D-A11C-F745C3C8BDC5': return 'ocb@corp.sletat.ru'; // жизнь такая
                    case 'A0C2A815-DAEC-47F1-A558-C921F13482CC': return 'mgt@corp.sletat.ru'; // Гор
                    default: return "";
                }
            }
            Array.prototype.forEach.call(data.autoFillerData.touristDataItems, tourist => {
                tourist.email = getInvoiceEmailByCBCompany(data.bookingCompanyId);
                return (0,_app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_11__.oneForNoData)(tourist);
            });
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_0__.removeCookiesForTouroperator)(_operators_54__WEBPACK_IMPORTED_MODULE_7__.Sunmar);
            var tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_8__.createTab)({
                active: true,
                url: _operators_54__WEBPACK_IMPORTED_MODULE_7__.Sunmar.link(),
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, 'div[data-target="#sign-in"]');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(tab, () => { document.querySelector('div[data-target="#sign-in"]').click(); });
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_10__.wait)(1000);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_14__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_13__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_54__WEBPACK_IMPORTED_MODULE_7__.Sunmar.packet
            }));
            const basicTabId = tab.id;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__.updateListenerOnSpecificPage)(tab.id, /sunmaragency\.ru\/reservation\/tourpackage\/tourists.*$/, (tabId, changeInfo, updatedTab) => {
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, 'div[id^=tourist-form]')
                    .then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_10__.wait)(1000 * 2))
                    .then(() => (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(tab, claimFillerNewTour, [{
                        tourists: context.data.autoFillerData.touristDataItems,
                        customer: context.data.autoFillerData.customer,
                        travelDateEnd: context.data.travelDateEnd
                    }]))
                    .then(() => (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, 'input#closed1'))
                    .then(() => {
                    if (data.isAdvanceBooking) {
                        (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(tab, () => { document.querySelector('input#closed1').click(); });
                    }
                    return Promise.resolve();
                });
                return true;
            });
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__.updateListenerOnSpecificPage)(tab.id, /sunmaragency\.ru\/reservation\/onlyhotel\/tourists.*$/, (tabId, changeInfo, updatedTab) => {
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, 'div[id^=tourist-form]')
                    .then(() => (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(tab, claimFillerNewHotels, [{
                        tourists: context.data.autoFillerData.touristDataItems,
                        customer: context.data.autoFillerData.customer,
                        travelDateEnd: context.data.travelDateEnd
                    }]))
                    .then(() => (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, 'input#closed1'))
                    .then(() => {
                    if (data.isAdvanceBooking) {
                        (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(tab, () => { document.querySelector('input#closed1').click(); });
                    }
                    return Promise.resolve();
                });
                return true;
            });
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_12__.updateListenerOnSpecificPage)(tab.id, /sunmaragency\.ru\/reservation\/search.*$/, (tabId, changeInfo, updatedTab) => {
                (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_4__.startTrackingIdSelectorWithClaimNumberValidation)(tab, 'div.reservation-list div.box span.reservation-no', claimNumber)
                    .then((response) => (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_9__.sendIdsToBookingCenter)(claimNumber, response.claimNo.match(/\d+/)[0]))
                    .then((response) => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                return true;
            });
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_10__.wait)(1000);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, 'span.icon-Profile-Menu');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_10__.wait)(2000);
            yield (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_1__.updateTabUrl)(tab, tourUrl);
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_10__.wait)(2 * 1000);
        }
        catch (e) {
            console.log("Sunmar фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFillerNewHotels(data) {
    const buttonTeg = document.createElement('button');
    buttonTeg.id = 'autoFillButton';
    buttonTeg.setAttribute('onClick', 'doFillScript("tourist")');
    document.body.appendChild(buttonTeg);
    const custButtonDiv = document.createElement('div');
    custButtonDiv.classList.add('col-md-12');
    custButtonDiv.classList.add('no-print');
    const custButtonTeg = document.createElement('button');
    custButtonTeg.id = 'autoFillButtonCust';
    custButtonTeg.textContent = 'Заполнить заказчика';
    custButtonTeg.classList.add('btn');
    custButtonTeg.classList.add('btn-danger');
    custButtonTeg.setAttribute('onClick', 'doFillScript("customer")');
    custButtonDiv.appendChild(custButtonTeg);
    document.querySelector('div.main-header div.container').appendChild(custButtonDiv);
    const scriptTeg = document.createElement('script');
    scriptTeg.id = 'autoFillScript';
    scriptTeg.innerHTML = `
        function doFillScript(type) {
            debugger;

            ${doTouristsFill.toString()}

            var tourists = ${JSON.stringify(data.tourists)};
            var touristBlocks = document.querySelectorAll('div[id^=tourist-form] form.form-custom');

            if(type === 'tourist') {
                if(touristBlocks.length > 0) {
                    doTouristsFill(tourists, touristBlocks);
                    return;
                } else {
                    console.log('touristBlocks пустоват');
                }
            }

            ${doCustomerFill.toString()}
            
            var customer = ${JSON.stringify(data.customer)}; 
            var customerBlocks = document.querySelectorAll('span.customer-text');

            if(type === 'customer') {
                if(customerBlocks.length > 0) {
                    doCustomerFill(customer, customerBlocks);
                } else {
                    console.log('customerBlocks пустоват');
                }
            }
        }
    `;
    document.body.appendChild(scriptTeg);
    document.querySelector('#autoFillButton').click();
    function doCustomerFill(tourist) {
        debugger;
        function wait(timeout) {
            return new Promise((resolve) => {
                setTimeout(() => resolve(), timeout);
            });
        }
        function SetReactValue(touristBlock, touristField) {
            var element = touristBlock.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value && touristField.value != '') {
                var previousValue = element.value;
                element.value = touristField.value;
                element.defaultValue = touristField.value;
                if (element._valueTracker) {
                    element._valueTracker.setValue(previousValue);
                }
                var event = new Event('input', { bubbles: true });
                element.dispatchEvent(event);
            }
        }
        let chain = new Promise(resolse => resolse());
        const fields = [{
                htmlElementSelector: `input[name="surname"]`,
                value: tourist.surnameRus
            }, {
                htmlElementSelector: `input[name="name"]`,
                value: tourist.nameRus
            }, {
                htmlElementSelector: `input[name="patronymic"]`,
                value: tourist.middleNameRus
            }, {
                htmlElementSelector: `input[name="birthday"]`,
                value: tourist.birthday
            }, {
                htmlElementSelector: `input[name="address"]`,
                value: tourist.address
            }, {
                htmlElementSelector: `input[name="documentSeries"]`,
                value: tourist.passportSeries
            }, {
                htmlElementSelector: `input[name="documentNumber"]`,
                value: tourist.passportNumber
            }, {
                htmlElementSelector: `input[name="mobilePhone"]`,
                value: tourist.phone
            }, {
                htmlElementSelector: `input[name="email"]`,
                value: tourist.email
            }];
        chain = chain.then(() => {
            var custText = document.querySelector('span.customer-text');
            if (custText && custText.nextElementSibling) {
                custText.nextElementSibling.click();
            }
        });
        chain = chain.then(() => wait(1000));
        var customerBlock = document.querySelector('div#modalBody form.payer-modal-form');
        if (!customerBlock) {
            console.log('customerBlock не нашелся');
            return;
        }
        fields.forEach((f, i) => {
            chain = chain.then(() => SetReactValue(customerBlock, f));
            chain = chain.then(() => wait(500));
        });
    }
    function doTouristsFill(tourists, touristBlocks) {
        function getExpireDate(date, lag = 25) {
            if (!date || date === '') {
                return '';
            }
            const [day, month, year] = date.split('.');
            var expireDate = new Date(parseInt(year, 10) + lag, parseInt(month, 10) - 1, parseInt(day, 10), 0, 0);
            var newDay = expireDate.getDate();
            var newMonth = expireDate.getMonth() + 1;
            var newYear = expireDate.getFullYear();
            return `${newDay < 10 ? '0' + newDay : newDay}.${newMonth < 10 ? '0' + newMonth : newMonth}.${newYear}`;
        }
        function prepareExpireDate(tourist) {
            const dateNow = new Date(Date.now());
            const dateNowString = `${dateNow.getDate()}.${dateNow.getMonth() + 1}.${dateNow.getFullYear()}`;
            if (!tourist.passportExpireDate || tourist.passportExpireDate === '') {
                return getExpireDate(dateNowString, 15);
            }
            return getExpireDate(tourist.passportExpireDate, 15);
        }
        function wait(timeout) {
            return new Promise((resolve) => {
                setTimeout(() => resolve(), timeout);
            });
        }
        function SetReactValue(touristBlock, touristField) {
            var element = touristBlock.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value && touristField.value != '') {
                var previousValue = element.value;
                element.value = touristField.value;
                element.defaultValue = touristField.value;
                if (element._valueTracker) {
                    element._valueTracker.setValue(previousValue);
                }
                var event = new Event('input', { bubbles: true });
                element.dispatchEvent(event);
            }
        }
        function SetSex(tourist, touristBlock) {
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    touristBlock.querySelector('input[value="0"]').click();
                    break;
                case 2:
                case 4:
                case 6:
                    touristBlock.querySelector('input[value="1"]').click();
                    break;
            }
        }
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        debugger;
        let chain = new Promise(resolse => resolse());
        // сортируем детей по возрасту в порядке позрастания, потому что Интурист альтернативно одаренный
        var tmpTouristsArray = [];
        var tmpChildTouristsArray = [];
        for (var i = 0; i < tourists.length; i++) {
            var tourist = tourists[i];
            if (getTouristAge(tourist) < 14) {
                tmpChildTouristsArray.push(tourist);
            }
            else {
                tmpTouristsArray[i] = tourist;
            }
        }
        tmpChildTouristsArray = tmpChildTouristsArray.reverse();
        tourists = tmpTouristsArray.concat(tmpChildTouristsArray);
        Array.prototype.forEach.call(tourists, (tourist, touristIndex) => {
            const touristFields = [
                {
                    htmlElementSelector: `input[name="gender"]`,
                    value: tourist.nameEng,
                    fieldType: 'sex'
                }, {
                    htmlElementSelector: `input[name="name"]`,
                    value: tourist.nameEng
                }, {
                    htmlElementSelector: `input[name="surName"]`,
                    value: tourist.surnameEng
                }, {
                    htmlElementSelector: `input[name="middleName"]`,
                    value: tourist.middleNameEng
                }, {
                    htmlElementSelector: `input[name="birthDate"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="passportGivenDate"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="passportValidThru"]`,
                    value: tourist.passportExpireDate && tourist.passportExpireDate !== '' ? tourist.passportExpireDate : prepareExpireDate(tourist)
                }, {
                    htmlElementSelector: `input[name="passportSerie"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="passportNumber"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="issuedby"]`,
                    value: tourist.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="phoneNumber"]`,
                    value: tourist.phone
                }, {
                    htmlElementSelector: `input[name="address"]`,
                    value: tourist.address
                }, {
                    htmlElementSelector: `input[name="invoiceMail"]`,
                    value: tourist.email
                }
            ];
            var touristBlock = touristBlocks[touristIndex];
            console.dir(touristFields);
            touristFields.forEach(touristField => {
                switch (touristField.fieldType) {
                    case 'sex':
                        chain = chain.then(() => SetSex(tourist, touristBlock));
                        chain = chain.then(() => wait(500));
                        break;
                    default:
                        chain = chain.then(() => SetReactValue(touristBlock, touristField));
                        chain = chain.then(() => wait(500));
                        break;
                }
            });
        });
    }
}
function claimFillerNewTour(data) {
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
        FieldType[FieldType["Human"] = 6] = "Human";
        FieldType[FieldType["NotFilled"] = 7] = "NotFilled";
    })(FieldType || (FieldType = {}));
    function doCustomerFill(tourist) {
        debugger;
        function wait(timeout) {
            return new Promise((resolve) => {
                setTimeout(() => resolve(), timeout);
            });
        }
        function SetReactValue(touristBlock, touristField) {
            var element = touristBlock.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value && touristField.value != '') {
                var previousValue = element.value;
                element.value = touristField.value;
                element.defaultValue = touristField.value;
                if (element._valueTracker) {
                    element._valueTracker.setValue(previousValue);
                }
                var event = new Event('input', { bubbles: true });
                element.dispatchEvent(event);
            }
        }
        let chain = new Promise(resolse => resolse());
        const fields = [{
                htmlElementSelector: `input[name="surname"]`,
                value: tourist.surnameRus
            }, {
                htmlElementSelector: `input[name="name"]`,
                value: tourist.nameRus
            }, {
                htmlElementSelector: `input[name="patronymic"]`,
                value: tourist.middleNameRus
            }, {
                htmlElementSelector: `input[name="birthday"]`,
                value: tourist.birthday
            }, {
                htmlElementSelector: `input[name="address"]`,
                value: tourist.address
            }, {
                htmlElementSelector: `input[name="documentSeries"]`,
                value: tourist.passportSeries
            }, {
                htmlElementSelector: `input[name="documentNumber"]`,
                value: tourist.passportNumber
            }, {
                htmlElementSelector: `input[name="mobilePhone"]`,
                value: tourist.phone
            }, {
                htmlElementSelector: `input[name="email"]`,
                value: tourist.email
            }];
        chain = chain.then(() => {
            var custText = document.querySelector('span.customer-text');
            if (custText && custText.nextElementSibling) {
                custText.nextElementSibling.click();
            }
        });
        chain = chain.then(() => wait(1000));
        var customerBlock = document.querySelector('div#modalBody form.payer-modal-form');
        if (!customerBlock) {
            console.log('customerBlock не нашелся');
            return;
        }
        fields.forEach((f, i) => {
            chain = chain.then(() => SetReactValue(customerBlock, f));
            chain = chain.then(() => wait(500));
        });
    }
    function getExpireDate(date, lag = 25) {
        if (!date || date === '') {
            return '';
        }
        const [day, month, year] = date.split('.');
        var expireDate = new Date(parseInt(year, 10) + lag, parseInt(month, 10) - 1, parseInt(day, 10), 0, 0);
        var newDay = expireDate.getDate();
        var newMonth = expireDate.getMonth() + 1;
        var newYear = expireDate.getFullYear();
        return `${newDay < 10 ? '0' + newDay : newDay}.${newMonth < 10 ? '0' + newMonth : newMonth}.${newYear}`;
    }
    function prepareExpireDate(tourist) {
        const dateNow = new Date(Date.now());
        const dateNowString = `${dateNow.getDate()}.${dateNow.getMonth() + 1}.${dateNow.getFullYear()}`;
        if (!tourist.passportExpireDate || tourist.passportExpireDate === '') {
            return getExpireDate(dateNowString, 15);
        }
        return getExpireDate(tourist.passportExpireDate, 15);
    }
    function wait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function SetReactValue(touristBlock, touristField) {
        var element = touristBlock.querySelector(touristField.htmlElementSelector);
        if (element && touristField.value && touristField.value != '') {
            element.dispatchEvent(new FocusEvent('focusin', { bubbles: true }));
            element.value = touristField.value;
            element.dispatchEvent(new Event('input', { bubbles: true }));
            element.dispatchEvent(new FocusEvent('focusout', { bubbles: true }));
        }
    }
    function SetSex(tourist, touristBlock) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                touristBlock.querySelector('input[value="0"]').click();
                break;
            case 2:
            case 4:
            case 6:
                touristBlock.querySelector('input[value="1"]').click();
                break;
        }
    }
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function NotFilledField(touristBlock, touristField) {
        let block = touristBlock.querySelector(touristField.htmlElementSelector);
        let defaultSelectedValueDiv = touristBlock.querySelector(`${touristField.htmlElementSelector} div.true__single-value`);
        if (defaultSelectedValueDiv && defaultSelectedValueDiv.innerText) {
            console.log(`defaultSelectedValueDiv = ${defaultSelectedValueDiv}`);
            console.log(`touristField.value = ${touristField.value}`);
            if (defaultSelectedValueDiv.innerText === touristField.value) {
                return;
            }
        }
        if (block && block.parentNode && block.parentNode.parentNode && block.parentNode.parentNode.parentNode) {
            block.parentNode.parentNode.parentNode.style.border = "10px solid red";
            block.parentNode.parentNode.parentNode.style.borderRadius = '20px';
            let div = document.createElement("div");
            div.style.textAlign = 'center';
            div.append(`--> ${touristField.value} <--`);
            block.parentNode.parentNode.parentNode.appendChild(div);
        }
    }
    function doTouristsFill(tourists, touristBlocks) {
        debugger;
        let chain = new Promise(resolse => resolse());
        // сортируем детей по возрасту в порядке позрастания, потому что Интурист альтернативно одаренный
        var tmpTouristsArray = [];
        var tmpChildTouristsArray = [];
        for (var i = 0; i < tourists.length; i++) {
            var tourist = tourists[i];
            if (getTouristAge(tourist) < 14) {
                tmpChildTouristsArray.push(tourist);
            }
            else {
                tmpTouristsArray[i] = tourist;
            }
        }
        tmpChildTouristsArray = tmpChildTouristsArray.reverse();
        tourists = tmpTouristsArray.concat(tmpChildTouristsArray);
        Array.prototype.forEach.call(tourists, (tourist, touristIndex) => {
            const touristFields = [
                {
                    htmlElementSelector: `input[name="gender"]`,
                    value: tourist.nameEng,
                    fieldType: FieldType.Sex
                }, {
                    htmlElementSelector: `input[name="name"]`,
                    value: tourist.nameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="surName"]`,
                    value: tourist.surnameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="patronymic"],  input[name="middleName"]`,
                    value: tourist.middleNameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="birthDate"]`,
                    value: tourist.birthday,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportGivenDate"]`,
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportValidThru"]`,
                    value: tourist.passportExpireDate && tourist.passportExpireDate !== '' ? tourist.passportExpireDate : prepareExpireDate(tourist),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportSerie"]`,
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportNumber"]`,
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="issuedby"]`,
                    value: tourist.passportIssueOrg,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="phoneNumber"]`,
                    value: tourist.phone,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="invoiceMail"]`,
                    value: tourist.email,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `div#nationality`,
                    value: tourist.citizenshipName,
                    fieldType: FieldType.NotFilled
                }, {
                    htmlElementSelector: `input[name="address"]`,
                    value: tourist.address,
                    fieldType: FieldType.Text
                }
            ];
            var touristBlock = touristBlocks[touristIndex];
            touristFields.forEach(touristField => {
                switch (touristField.fieldType) {
                    case FieldType.Sex:
                        chain = chain.then(() => SetSex(tourist, touristBlock));
                        break;
                    case FieldType.Text:
                        chain = chain.then(() => SetReactValue(touristBlock, touristField));
                        break;
                    case FieldType.NotFilled:
                        chain = chain.then(() => NotFilledField(touristBlock, touristField));
                        break;
                    default:
                        break;
                }
                chain = chain.then(() => wait(500));
            });
        });
    }
    doTouristsFill(data.tourists, document.querySelectorAll('div[id^=tourist-form] form.form-custom'));
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_6.ts":
/*!**************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_6.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contentCoralFill: () => (/* binding */ contentCoralFill),
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_6__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/6 */ "./src/serverScripts/operators/6.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/common/oneForNoData */ "./src/app/utils/chunks/common/oneForNoData.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_common_executeContentScript__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/utils/chunks/common/executeContentScript */ "./src/app/utils/chunks/common/executeContentScript.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, tourUrl } = context;
        try {
            function getInvoiceEmailByCBCompany(bookingCompanyId) {
                switch (bookingCompanyId.toUpperCase()) {
                    case '62B8B7E0-C368-4EC0-8FC6-CEE8BBCBBE41': return 'Aryld@corp.sletat.ru';
                    case '4016198A-5249-43B7-B3A0-A4CF53B96CD4': return 'ocb@corp.sletat.ru'; // ну 2 ОЦБ, ну что поделать
                    case 'A284BFD4-08E5-4F7D-A11C-F745C3C8BDC5': return 'ocb@corp.sletat.ru'; // жизнь такая
                    case 'A0C2A815-DAEC-47F1-A558-C921F13482CC': return 'mgt@corp.sletat.ru'; // Гор
                    default: return "";
                }
            }
            Array.prototype.forEach.call(data.autoFillerData.touristDataItems, tourist => {
                tourist.email = getInvoiceEmailByCBCompany(data.bookingCompanyId);
                return (0,_app_utils_chunks_common_oneForNoData__WEBPACK_IMPORTED_MODULE_9__.oneForNoData)(tourist);
            });
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__.removeCookiesForTouroperator)(_operators_6__WEBPACK_IMPORTED_MODULE_0__.Coral);
            var tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({
                active: true,
                url: _operators_6__WEBPACK_IMPORTED_MODULE_0__.Coral.link(),
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, 'div[data-target="#sign-in"]');
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__.executeScriptInTabV3)(tab, () => { document.querySelector('div[data-target="#sign-in"]').click(); });
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_6__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_7__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_6__WEBPACK_IMPORTED_MODULE_0__.Coral.packet
            }));
            var tourpackageRegex = /coralagency\.ru\/reservation\/tourpackage\/tourists.*$/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_10__.updateListenerOnSpecificPage)(tab.id, tourpackageRegex, (tabId, changeInfo, updatedTab) => {
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, 'div[id^=tourist-form]')
                    .then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000 * 2))
                    .then(() => {
                    (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__.executeScriptInTabV3)(tab, claimFillerNewTour, [{
                            tourists: context.data.autoFillerData.touristDataItems,
                            customer: context.data.autoFillerData.customer
                        }]);
                    data.scriptKey = 'coralFill';
                    (0,_app_utils_chunks_common_executeContentScript__WEBPACK_IMPORTED_MODULE_13__.executeContentScript)(tab, data);
                })
                    .then(() => (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, 'input#closed1'))
                    .then(() => {
                    if (data.isAdvanceBooking) {
                        (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_12__.executeScriptInTabV3)(tab, () => { document.querySelector('input#closed1').click(); });
                    }
                });
                return true;
            });
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000);
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, 'span.icon-Profile-Menu');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(2000);
            yield (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_8__.updateTabUrl)(tab, tourUrl);
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(2 * 1000);
        }
        catch (e) {
            console.log("Coral фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_1__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFillerNewTour(data) {
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
        FieldType[FieldType["Human"] = 6] = "Human";
        FieldType[FieldType["NotFilled"] = 7] = "NotFilled";
    })(FieldType || (FieldType = {}));
    function doCustomerFill(tourist) {
        debugger;
        function wait(timeout) {
            return new Promise((resolve) => {
                setTimeout(() => resolve(), timeout);
            });
        }
        function SetReactValue(touristBlock, touristField) {
            var element = touristBlock.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value && touristField.value != '') {
                // @ts-ignore
                var previousValue = element.value;
                // @ts-ignore
                element.value = touristField.value;
                // @ts-ignore
                element._valueTracker.setValue(previousValue);
                var event = new Event('input', { bubbles: true });
                element.dispatchEvent(event);
            }
        }
        let chain = new Promise(resolse => resolse());
        const fields = [{
                htmlElementSelector: `input[name="surname"]`,
                value: tourist.surnameRus
            }, {
                htmlElementSelector: `input[name="name"]`,
                value: tourist.nameRus
            }, {
                htmlElementSelector: `input[name="patronymic"],  input[name="middleName"]`,
                value: tourist.middleNameRus
            }, {
                htmlElementSelector: `input[name="birthday"]`,
                value: tourist.birthday
            }, {
                htmlElementSelector: `input[name="address"]`,
                value: tourist.address
            }, {
                htmlElementSelector: `input[name="documentSeries"]`,
                value: tourist.passportSeries
            }, {
                htmlElementSelector: `input[name="documentNumber"]`,
                value: tourist.passportNumber
            }, {
                htmlElementSelector: `input[name="mobilePhone"]`,
                value: tourist.phone
            }, {
                htmlElementSelector: `input[name="email"]`,
                value: tourist.email
            }];
        chain = chain.then(() => {
            var custText = document.querySelector('span.customer-text');
            if (custText && custText.nextElementSibling) {
                // @ts-ignore
                custText.nextElementSibling.click();
            }
        });
        chain = chain.then(() => wait(1000));
        var customerBlock = document.querySelector('div#modalBody form.payer-modal-form');
        if (!customerBlock) {
            console.log('customerBlock не нашелся');
            return;
        }
        fields.forEach((f, i) => {
            chain = chain.then(() => SetReactValue(customerBlock, f));
            chain = chain.then(() => wait(500));
        });
    }
    function getExpireDate(date, lag = 25) {
        if (!date || date === '') {
            return '';
        }
        const [day, month, year] = date.split('.');
        var expireDate = new Date(parseInt(year, 10) + lag, parseInt(month, 10) - 1, parseInt(day, 10), 0, 0);
        var newDay = expireDate.getDate();
        var newMonth = expireDate.getMonth() + 1;
        var newYear = expireDate.getFullYear();
        return `${newDay < 10 ? '0' + newDay : newDay}.${newMonth < 10 ? '0' + newMonth : newMonth}.${newYear}`;
    }
    function prepareExpireDate(tourist) {
        const dateNow = new Date(Date.now());
        const dateNowString = `${dateNow.getDate()}.${dateNow.getMonth() + 1}.${dateNow.getFullYear()}`;
        if (!tourist.passportExpireDate || tourist.passportExpireDate === '') {
            return getExpireDate(dateNowString, 15);
        }
        return getExpireDate(tourist.passportExpireDate, 15);
    }
    function wait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function SetReactValue(touristBlock, touristField) {
        var element = touristBlock.querySelector(touristField.htmlElementSelector);
        if (element && touristField.value && touristField.value != '') {
            element.dispatchEvent(new FocusEvent('focusin', { bubbles: true }));
            element.value = touristField.value;
            element.dispatchEvent(new Event('input', { bubbles: true }));
            element.dispatchEvent(new FocusEvent('focusout', { bubbles: true }));
        }
    }
    function SetSex(tourist, touristBlock) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                // @ts-ignore
                touristBlock.querySelector('input[value="0"]').click();
                break;
            case 2:
            case 4:
            case 6:
                // @ts-ignore
                touristBlock.querySelector('input[value="1"]').click();
                break;
        }
    }
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function NotFilledField(touristBlock, touristField) {
        let block = touristBlock.querySelector(touristField.htmlElementSelector);
        let defaultSelectedValueDiv = touristBlock.querySelector(`${touristField.htmlElementSelector} div.true__single-value`);
        if (defaultSelectedValueDiv && defaultSelectedValueDiv.innerText) {
            console.log(`defaultSelectedValueDiv = ${defaultSelectedValueDiv}`);
            console.log(`touristField.value = ${touristField.value}`);
            if (defaultSelectedValueDiv.innerText === touristField.value) {
                return;
            }
        }
        if (block && block.parentNode && block.parentNode.parentNode && block.parentNode.parentNode.parentNode) {
            block.parentNode.parentNode.parentNode.style.border = "10px solid red";
            block.parentNode.parentNode.parentNode.style.borderRadius = '20px';
            let div = document.createElement("div");
            div.style.textAlign = 'center';
            div.append(`--> ${touristField.value} <--`);
            block.parentNode.parentNode.parentNode.appendChild(div);
        }
    }
    function doTouristsFill(tourists, touristBlocks) {
        debugger;
        let chain = new Promise(resolse => resolse());
        // сортируем детей по возрасту в порядке позрастания, потому что Интурист альтернативно одаренный
        var tmpTouristsArray = [];
        var tmpChildTouristsArray = [];
        for (var i = 0; i < tourists.length; i++) {
            var tourist = tourists[i];
            if (getTouristAge(tourist) < 14) {
                tmpChildTouristsArray.push(tourist);
            }
            else {
                tmpTouristsArray[i] = tourist;
            }
        }
        tmpChildTouristsArray = tmpChildTouristsArray.reverse();
        tourists = tmpTouristsArray.concat(tmpChildTouristsArray);
        Array.prototype.forEach.call(tourists, (tourist, touristIndex) => {
            const touristFields = [
                {
                    htmlElementSelector: `input[name="gender"]`,
                    value: tourist.nameEng,
                    fieldType: FieldType.Sex
                }, {
                    htmlElementSelector: `input[name="name"]`,
                    value: tourist.nameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="surName"]`,
                    value: tourist.surnameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="patronymic"],  input[name="middleName"]`,
                    value: tourist.middleNameEng,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="birthDate"]`,
                    value: tourist.birthday,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportGivenDate"]`,
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportValidThru"]`,
                    value: tourist.passportExpireDate && tourist.passportExpireDate !== '' ? tourist.passportExpireDate : prepareExpireDate(tourist),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportSerie"]`,
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="passportNumber"]`,
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="issuedby"]`,
                    value: tourist.passportIssueOrg,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="phoneNumber"]`,
                    value: tourist.phone,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="invoiceMail"]`,
                    value: tourist.email,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `div#nationality`,
                    value: tourist.citizenshipName,
                    fieldType: FieldType.NotFilled
                }, {
                    htmlElementSelector: `input[name="address"]`,
                    value: tourist.address,
                    fieldType: FieldType.Text
                }
            ];
            var touristBlock = touristBlocks[touristIndex];
            touristFields.forEach(touristField => {
                switch (touristField.fieldType) {
                    case FieldType.Sex:
                        chain = chain.then(() => SetSex(tourist, touristBlock));
                        break;
                    case FieldType.Text:
                        chain = chain.then(() => SetReactValue(touristBlock, touristField));
                        break;
                    case FieldType.NotFilled:
                        chain = chain.then(() => NotFilledField(touristBlock, touristField));
                        break;
                    default:
                        break;
                }
                chain = chain.then(() => wait(500));
            });
        });
    }
    doTouristsFill(data.tourists, document.querySelectorAll('div[id^=tourist-form] form.form-custom'));
}
function contentCoralFill(data) {
    console.log('Content EXECUTE_CONTENT_SCRIPT');
    let forms = document.querySelectorAll('div[id^=tourist-form] form.form-custom');
    Array.prototype.forEach.call(forms, (form, formIndex) => {
        let row = document.createElement('div');
        Array.prototype.forEach.call(data.autoFillerData.touristDataItems, (tourist, touristIndex) => {
            let button = document.createElement('button');
            button.innerText = `${tourist.name} ${tourist.surname}`;
            button.style.marginRight = '1em';
            button.style.backgroundColor = '#e03997';
            button.style.color = '#fff';
            button.style.borderColor = '#fff';
            button.style.borderRadius = '5px';
            button.addEventListener('click', (e) => {
                debugger;
                e.preventDefault();
                console.log(`button.addEventListener ${formIndex}${touristIndex}, ${tourist.name} ${tourist.surname}`);
                //@ts-ignore
                fillTourist(e.target.parentNode.parentNode, tourist);
            });
            row.appendChild(button);
        });
        if (form) {
            form.appendChild(row);
        }
    });
}
function fillTourist(block, tourist) {
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
        FieldType[FieldType["Human"] = 6] = "Human";
        FieldType[FieldType["NotFilled"] = 7] = "NotFilled";
    })(FieldType || (FieldType = {}));
    function prepareExpireDate(tourist) {
        const dateNow = new Date(Date.now());
        const dateNowString = `${dateNow.getDate()}.${dateNow.getMonth() + 1}.${dateNow.getFullYear()}`;
        if (!tourist.passportExpireDate || tourist.passportExpireDate === '') {
            return getExpireDate(dateNowString, 15);
        }
        return getExpireDate(tourist.passportExpireDate, 15);
    }
    function getExpireDate(date, lag = 25) {
        if (!date || date === '') {
            return '';
        }
        const [day, month, year] = date.split('.');
        var expireDate = new Date(parseInt(year, 10) + lag, parseInt(month, 10) - 1, parseInt(day, 10), 0, 0);
        var newDay = expireDate.getDate();
        var newMonth = expireDate.getMonth() + 1;
        var newYear = expireDate.getFullYear();
        return `${newDay < 10 ? '0' + newDay : newDay}.${newMonth < 10 ? '0' + newMonth : newMonth}.${newYear}`;
    }
    function NotFilledField(touristBlock, touristField) {
        let block = touristBlock.querySelector(touristField.htmlElementSelector);
        let defaultSelectedValueDiv = touristBlock.querySelector(`${touristField.htmlElementSelector} div.true__single-value`);
        if (defaultSelectedValueDiv && defaultSelectedValueDiv.innerText) {
            console.log(`defaultSelectedValueDiv = ${defaultSelectedValueDiv}`);
            console.log(`touristField.value = ${touristField.value}`);
            if (defaultSelectedValueDiv.innerText === touristField.value) {
                return;
            }
        }
        if (block && block.parentNode && block.parentNode.parentNode && block.parentNode.parentNode.parentNode) {
            block.parentNode.parentNode.parentNode.style.border = "10px solid red";
            block.parentNode.parentNode.parentNode.style.borderRadius = '20px';
            let div = document.createElement("div");
            div.style.textAlign = 'center';
            div.append(`--> ${touristField.value} <--`);
            block.parentNode.parentNode.parentNode.appendChild(div);
        }
    }
    function SetSex(touristBlock, tourist) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                // @ts-ignore
                touristBlock.querySelector('input[value="0"]').click();
                break;
            case 2:
            case 4:
            case 6:
                // @ts-ignore
                touristBlock.querySelector('input[value="1"]').click();
                break;
        }
    }
    function SetReactValue(touristBlock, touristField) {
        var element = touristBlock.querySelector(touristField.htmlElementSelector);
        if (element && touristField.value && touristField.value != '') {
            element.dispatchEvent(new FocusEvent('focusin', { bubbles: true }));
            element.value = touristField.value;
            element.dispatchEvent(new Event('input', { bubbles: true }));
            element.dispatchEvent(new FocusEvent('focusout', { bubbles: true }));
        }
    }
    let chain = Promise.resolve();
    const touristFields = [
        {
            htmlElementSelector: `input[name="gender"]`,
            value: tourist.nameEng,
            fieldType: FieldType.Sex
        }, {
            htmlElementSelector: `input[name="name"]`,
            value: tourist.nameEng,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="surName"]`,
            value: tourist.surnameEng,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="patronymic"],  input[name="middleName"]`,
            value: tourist.middleNameEng,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="birthDate"]`,
            value: tourist.birthday,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="passportGivenDate"]`,
            value: tourist.passportDate,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="passportValidThru"]`,
            value: tourist.passportExpireDate && tourist.passportExpireDate !== '' ? tourist.passportExpireDate : prepareExpireDate(tourist),
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="passportSerie"]`,
            value: tourist.passportSeries,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="passportNumber"]`,
            value: tourist.passportNumber,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="issuedby"]`,
            value: tourist.passportIssueOrg,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="phoneNumber"]`,
            value: tourist.phone,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `input[name="invoiceMail"]`,
            value: tourist.email,
            fieldType: FieldType.Text
        }, {
            htmlElementSelector: `div#nationality`,
            value: tourist.citizenshipName,
            fieldType: FieldType.NotFilled
        }, {
            htmlElementSelector: `input[name="address"]`,
            value: tourist.address,
            fieldType: FieldType.Text
        }
    ];
    touristFields.forEach(touristField => {
        switch (touristField.fieldType) {
            case FieldType.Sex:
                chain = chain.then(() => SetSex(block, tourist));
                break;
            case FieldType.Text:
                chain = chain.then(() => SetReactValue(block, touristField));
                break;
            case FieldType.NotFilled:
                chain = chain.then(() => NotFilledField(block, touristField));
                break;
            default:
                break;
        }
        chain = chain.then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(500));
    });
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_7.ts":
/*!**************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_7.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   claimFillerNew: () => (/* binding */ claimFillerNew),
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_7__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/7 */ "./src/serverScripts/operators/7.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_services_chunks_sendIdAndAnotherIdToBookingCenter__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/services/chunks/sendIdAndAnotherIdToBookingCenter */ "./src/app/services/chunks/sendIdAndAnotherIdToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _app_utils_chunks_common_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/common/emptyForNoDataAndOnes */ "./src/app/utils/chunks/common/emptyForNoDataAndOnes.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












const bgAuthUrl = 'https://login.bgoperator.ru/';
const bgOperatorBaseLink = 'https://www.bgoperator.ru/';
const bgOperatorAuthCookieName = 'A1';
function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, secretField, claimNumber, sourceId, } = context;
        let { tourUrl } = context;
        let authUrl = `https://${data.login}:${data.password}@www.bgoperator.ru/personal.jsp`;
        let curTab;
        return Promise.resolve()
            .then(() => {
            Array.prototype.forEach.call(data.autoFillerData.touristDataItems, tourist => {
                return (0,_app_utils_chunks_common_emptyForNoDataAndOnes__WEBPACK_IMPORTED_MODULE_8__.emptyForNoDataAndOnes)(tourist);
            });
            return (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_10__.createTab)({ active: true, url: authUrl, windowId: chrome.windows.WINDOW_ID_CURRENT })
                .then((tab) => {
                curTab = tab;
            })
                .then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__.wait)(1000))
                .then(() => (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_11__.updateTabUrl)(curTab, tourUrl))
                .then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__.wait)(2000))
                .then(() => (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_1__.startTrackingElement)(curTab, 'body.zayavka'))
                .then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__.wait)(2000))
                .then(() => {
                const autofillingListener = getAutofillingListener(curTab.id);
                function getAutofillingListener(currentTabId) {
                    if (currentTabId) {
                        return function (tabId, changeInfo, updatedTab) {
                            const regExp = /bgoperator\.ru\/(tozaya|zaya)\?idTour=(\d+)&find=yes/;
                            if (changeInfo.status && changeInfo.status.toLowerCase() === 'complete'
                                && tabId === currentTabId
                                && updatedTab.url
                                && regExp.test(updatedTab.url)) {
                                let claimNo = '';
                                (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_7__.startTrackingIdSelectorWithClaimNumberValidation)(updatedTab, 'font.title span.claim_no', context.claimNumber)
                                    .then((response) => {
                                    if (autofillingListener) {
                                        if (chrome.tabs.onUpdated.hasListener(autofillingListener)) {
                                            chrome.tabs.onUpdated.removeListener(autofillingListener);
                                        }
                                    }
                                    claimNo = response.claimNo;
                                    return (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_4__.sendIdsToBookingCenter)(claimNumber, response.claimNo);
                                })
                                    .then(() => (0,_app_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_7__.startTrackingElementValue)(updatedTab, 'input#idTour'))
                                    .then((response) => {
                                    debugger;
                                    if (response && response.claimNoElement && response.claimNoValue) {
                                        return (0,_app_services_chunks_sendIdAndAnotherIdToBookingCenter__WEBPACK_IMPORTED_MODULE_5__.sendIdAndAnotherIdToBookingCenter)(claimNumber, claimNo, response.claimNoValue);
                                    }
                                })
                                    .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                            }
                        };
                    }
                    else {
                        return null;
                    }
                }
                if (autofillingListener) {
                    chrome.tabs.onUpdated.addListener(autofillingListener);
                    const removedListener = (tabId, removeInfo) => {
                        if (tabId === curTab.id) {
                            if (chrome.tabs.onUpdated.hasListener(autofillingListener)) {
                                chrome.tabs.onUpdated.removeListener(autofillingListener);
                            }
                            chrome.tabs.onRemoved.removeListener(removedListener);
                        }
                    };
                    chrome.tabs.onRemoved.addListener(removedListener);
                }
                return (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_1__.startTrackingElement)(curTab, '#Form .form-block.passengers');
            })
                .then(() => (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTabV3)(curTab, claimFillerNew, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    bookingCompanyId: data.bookingCompanyId
                }]))
                .then(() => (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__.wait)(1000))
                .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ claimId: claimNumber, operator: _operators_7__WEBPACK_IMPORTED_MODULE_0__.BiblioGlobus, errorText: null }))
                .catch((error) => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_3__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.FAIL, message: error.message }));
        });
    });
}
function claimFillerNew(data) {
    console.log('BG claimFillerNew');
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
    })(FieldType || (FieldType = {}));
    function hintChildInfant(type, date) {
        const [day, month, year] = date.split('.');
        const birthDate = new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10));
        const yearDiff = new Date(Date.now() - birthDate.valueOf()).getFullYear() - 1970;
        return yearDiff >= 2 ? type - 2 : type;
    }
    ;
    function setTouristType(tourist, titulSelectOptions, sexSelectOptions) {
        const { touristType, birthday } = tourist;
        switch (touristType) {
            case 1:
                titulSelectOptions[0].selected = true;
                sexSelectOptions[0].selected = true;
                break;
            case 2:
                titulSelectOptions[1].selected = true;
                sexSelectOptions[1].selected = true;
                break;
            case 3:
                titulSelectOptions[2].selected = true;
                sexSelectOptions[0].selected = true;
                break;
            case 4:
                titulSelectOptions[2].selected = true;
                sexSelectOptions[1].selected = true;
                break;
            case 5:
                if (touristType - hintChildInfant(touristType, birthday) === 2) {
                    titulSelectOptions[2].selected = true;
                }
                else {
                    titulSelectOptions[3].selected = true;
                }
                sexSelectOptions[0].selected = true;
                break;
            case 6:
                if (touristType - hintChildInfant(touristType, birthday) === 2) {
                    titulSelectOptions[2].selected = true;
                }
                else {
                    titulSelectOptions[3].selected = true;
                }
                sexSelectOptions[1].selected = true;
                break;
            default:
                break;
        }
    }
    ;
    function handleTouristFields(touristFields) {
        touristFields.forEach(touristField => {
            const element = document.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                // if(touristField.fieldType && touristField.fieldType === FieldType.DatePicker) {
                //     element.dispatchEvent(new FocusEvent('focus'));
                // }
                if (touristField.fieldType && touristField.fieldType === FieldType.DatePicker) {
                    //element.dispatchEvent(new FocusEvent('blur'));
                    // @ts-ignore
                    //jQuery(touristField.htmlElementSelector).val(touristField.value)
                    // element.dispatchEvent(new FocusEvent("focus", { bubbles: true }));
                    element.value = touristField.value;
                    //element.dispatchEvent(new InputEvent("input", { bubbles: true }));
                    //element.dispatchEvent(new InputEvent("keyup", { bubbles: true }));
                    element.dispatchEvent(new InputEvent("blur", { bubbles: true }));
                    //element.dispatchEvent(new Event("change", { bubbles: true }));
                    //element.click();
                }
                else {
                    element.value = touristField.value;
                    element.dispatchEvent(new FocusEvent("focus", { bubbles: true }));
                    element.dispatchEvent(new InputEvent("input", { bubbles: true }));
                    element.dispatchEvent(new InputEvent("keyup", { bubbles: true }));
                    element.dispatchEvent(new Event("change", { bubbles: true }));
                }
            }
        });
    }
    function addPlashka(bookingCompanyId) {
        const getBookingCompanyByCBGuid = (guid) => {
            const guidBookingCompany = {
                '62b8b7e0-c368-4ec0-8fc6-cee8bbcbbe41': { name: 'ООО «АРИЛЬД»', color: '#00875a' },
                '4016198a-5249-43b7-b3a0-a4cf53b96cd4': { name: 'ООО «ОЦБ»', color: '#ff8b00' },
                'a284bfd4-08e5-4f7d-a11c-f745c3c8bdc5': { name: 'ООО «ОЦБ K»', color: '#ff8b00' },
                'a0c2a815-daec-47f1-a558-c921f13482cc': { name: 'ООО «ГорТревел»', color: '#0747a6' },
                '96c57522-c7b9-43fb-ab7a-15f98d3972d4': { name: 'ООО «Все Туры»', color: '#de350b' },
                'eee2cd51-5bb0-495b-9067-ec30adfece47': { name: 'ООО «ГорТревел В»', color: '#403294' },
                '387d946b-82e6-4a9d-bd02-1ebde5ebcd0a': { name: 'ИП Абрамов Денис Дмитриевич', color: '#ffab00' },
                'd85b47f8-d524-4f85-9dd6-70100983fb49': { name: 'ООО «МСУ Тех»', color: '#66FF00' },
                '7784c883-fad4-4402-ba0a-07fda56f5edb': { name: 'ООО СолнцеТур', color: '#505f79' }
            };
            return guidBookingCompany[guid] || { name: 'ООО НЕИЗВЕСТНО', color: 'pink' };
        };
        var urLico = getBookingCompanyByCBGuid(bookingCompanyId);
        const divToAddParent = document.createElement('div');
        divToAddParent.id = 'urlicocbParent';
        divToAddParent.setAttribute('style', `
            height: 50px;
            position: relative;
            border: 10px solid ${urLico.color};
            border-radius: 10px;
        `);
        const divToAddChild = document.createElement('div');
        divToAddChild.innerHTML = `Под Юр лицом ${urLico.name}`;
        divToAddChild.id = 'urlicocbChild';
        divToAddChild.setAttribute('style', `
            margin: 0;
            position: absolute;
            top: 50%;
            left: 50%;
            -ms-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            font-weight: bold;
            font-size: x-large;
        `);
        divToAddParent.appendChild(divToAddChild);
        const priceInfo = document.querySelector('div.form-block.passengers div.form-block.passengers');
        if (priceInfo) {
            priceInfo.appendChild(divToAddParent);
        }
    }
    function doFill(tourists, customer) {
        function FillCustomer(customer) {
            const citizenshipSelect = document.querySelector(`select[name="t_1000333_0"]`);
            const citizenshipSelectOptions = citizenshipSelect.querySelectorAll('option');
            Array.prototype.forEach.call(citizenshipSelectOptions, (option, index) => {
                if (option.value === customer.citizenship) {
                    option.selected = true;
                }
            });
            var suffics = 'Rus';
            if (customer && customer.citizenshipName && customer.citizenshipName.trim().toLocaleUpperCase() !== 'РОССИЯ') {
                suffics = 'Eng';
            }
            const touristFields = [{
                    htmlElementSelector: `input[name="t_1000144_0"]`,
                    // @ts-ignore
                    value: customer['surname' + suffics]
                }, {
                    htmlElementSelector: `input[name="t_1000146_0"]`,
                    // @ts-ignore
                    value: customer['name' + suffics]
                }, {
                    htmlElementSelector: `input[name="t_1000147_0"]`,
                    value: customer.middleNameRus
                }, {
                    htmlElementSelector: `input[name="t_1000153_0"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="t_1000156_0"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="t_1001446_0"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="t_1001447_0"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="t_1001195_0"]`,
                    value: customer.address
                }];
            handleTouristFields(touristFields);
        }
        function prepareValue(value) {
            if (!value)
                return value;
            // @ts-ignore
            value = value.replaceAll(' ', '');
            for (var i = 0; i < 10; i++) {
                // @ts-ignore
                if (value.split(i.toString()).length - 1 == (value === null || value === void 0 ? void 0 : value.length)) {
                    return '';
                }
            }
            return value;
        }
        try {
            if (customer) {
                FillCustomer(customer);
            }
            Array.prototype.forEach.call(tourists, (tourist, index) => {
                const indexInc = index + 1;
                const titulSelect = document.querySelector(`select[name=t_1000151_${indexInc}]`);
                const titulSelectOptions = titulSelect.querySelectorAll('option');
                const sexSelect = document.querySelector(`select[name=t_1023101073_${indexInc}]`);
                const sexSelectOptions = sexSelect.querySelectorAll('option');
                const citizenshipSelect = document.querySelector(`select[name="t_1000333_${indexInc}"]`);
                const citizenshipSelectOptions = citizenshipSelect.querySelectorAll('option');
                setTouristType(tourist, titulSelectOptions, sexSelectOptions);
                // диспатчим ивенты на селекте, чтобы выбранная опция успешно сохранялась
                if (titulSelect) {
                    titulSelect.dispatchEvent(new Event('change'));
                    titulSelect.dispatchEvent(new Event('input'));
                }
                if (sexSelect) {
                    sexSelect.dispatchEvent(new Event('change'));
                    sexSelect.dispatchEvent(new Event('input'));
                }
                Array.prototype.forEach.call(citizenshipSelectOptions, (option, index) => {
                    if (option.value === tourist.citizenship) {
                        option.selected = true;
                    }
                });
                var suffics = '';
                if (tourist && tourist.citizenshipName && tourist.citizenshipName.trim().toLocaleUpperCase() !== 'РОССИЯ') {
                    suffics = 'Eng';
                }
                if (prepareValue(tourist.passportNumber) === '') {
                    tourist.passportSeries = '',
                        tourist.passportNumber = '';
                }
                const touristFields = [{
                        htmlElementSelector: `input[name="t_1000152_${indexInc}"]`,
                        value: tourist.birthday,
                        fieldType: FieldType.DatePicker
                    }, {
                        htmlElementSelector: `input[name="t_1000144_${indexInc}"]`,
                        // @ts-ignore
                        value: tourist['surname' + suffics]
                    }, {
                        htmlElementSelector: `input[name="t_1000146_${indexInc}"]`,
                        // @ts-ignore
                        value: tourist['name' + suffics]
                    }, {
                        htmlElementSelector: `input[name="t_1000147_${indexInc}"]`,
                        // @ts-ignore
                        value: tourist['middlename' + suffics]
                    }, {
                        htmlElementSelector: `input[name="t_1000153_${indexInc}"]`,
                        value: tourist.phone && tourist.phone !== '' && tourist.phone.length > 3 ? tourist.phone : (customer && customer.phone !== '' ? customer.phone : '')
                    }, {
                        htmlElementSelector: `input[name="t_1000156_${indexInc}"]`,
                        value: tourist.email && tourist.email !== '' && tourist.email.length > 3 ? tourist.email : (customer && customer.email !== '' ? customer.email : '')
                    }, {
                        htmlElementSelector: `input[name="t_1001446_${indexInc}"]`,
                        value: tourist.passportSeries
                    }, {
                        htmlElementSelector: `input[name="t_1001447_${indexInc}"]`,
                        value: tourist.passportNumber
                    }, {
                        htmlElementSelector: `input[name="t_1001449_${indexInc}"]`,
                        value: tourist.passportExpireDate,
                        fieldType: FieldType.DatePicker
                    }];
                handleTouristFields(touristFields);
            });
        }
        catch (e) {
            console.log(e);
        }
        finally {
            setTimeout(function () {
                document.querySelector('input#submit').style.display = 'inline-block';
                document.querySelector('div.accommodation div.rgt-r').style.display = 'block';
            }, 5 * 1000);
        }
    }
    doFill(data.tourists, data.customer);
    addPlashka(data.bookingCompanyId);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_743.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_743.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_743__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/743 */ "./src/serverScripts/operators/743.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_743__WEBPACK_IMPORTED_MODULE_0__.Loti);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, _operators_743__WEBPACK_IMPORTED_MODULE_0__.Loti.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_743__WEBPACK_IMPORTED_MODULE_0__.Loti.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000);
            const regExp = /online\.loti\.ru\/cl_refer\?CLAIM=(\d+)/;
            // @ts-ignore
            (_a = data.autoFillerData.customer) === null || _a === void 0 ? void 0 : _a.eVoucherClaimNumber = data.eVoucherClaimNumber;
            // @ts-ignore
            (_b = data.autoFillerData.customer) === null || _b === void 0 ? void 0 : _b.eVoucherCurrency = data.eVoucherCurrency;
            // @ts-ignore
            (_c = data.autoFillerData.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
            try {
                // @ts-ignore
                (_d = data.autoFillerData.customer) === null || _d === void 0 ? void 0 : _d.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
            }
            catch (e) { }
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_7__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_12__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_743__WEBPACK_IMPORTED_MODULE_0__.Loti, errorText: null });
        }
        catch (e) {
            console.log("Loti фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(index, tourist, countryTo) {
            let optionIndex = -1;
            var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function handleTouristFields(block, touristFields) {
            touristFields.forEach(touristField => {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    console.log(touristField.value);
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        ;
        function preparePhone(phone) {
            if (phone) {
                phone = phone.replace(/\D/g, '');
                if (phone && phone.startsWith('7')) {
                    return '+' + phone;
                }
                if (phone && phone.startsWith('8')) {
                    return '+7' + phone.substr(1, phone.length);
                }
            }
            return phone;
        }
        function toUpperCase(input) {
            if (!input || input === '') {
                return '';
            }
            return input.toUpperCase();
        }
        function setCitezenship(index, tourist) {
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenship === option.value) {
                    text = option.innerText;
                }
            });
            if (!text) {
                return;
            }
            var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function setSexRadios(tourist, sexRadios) {
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexRadios[0].checked = true;
                    break;
                case 2:
                case 4:
                case 6:
                    sexRadios[1].checked = true;
                    break;
            }
        }
        function setHuman(index, tourist) {
            // 0 - CHD
            // 1 - MR
            // 2 - MRS
            let humanDdItemIndex = 0;
            switch (tourist.touristType) {
                case 1:
                    humanDdItemIndex = 1;
                    break;
                case 2:
                    humanDdItemIndex = 2;
                    break;
                case 3:
                    humanDdItemIndex = 0;
                    break;
                case 4:
                    humanDdItemIndex = 0;
                    break;
                case 5:
                    humanDdItemIndex = 0;
                    break;
                case 6:
                    humanDdItemIndex = 0;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function getOptionIndexByName(text, optionsSelector) {
            const options = document.querySelectorAll(optionsSelector);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function setCustomerDocumentType(tourist, countryTo) {
            let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
            }
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: `${customer.surnameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: `${customer.nameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: `${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                    value: customer.birthday
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                    value: customer.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                    value: customer.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                    value: customer.passportIssueCode
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(block, fields);
            // setSex(maleRadio, femaleRadio, tourist);
            // setCitezenship(index, tourist);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            setDocumentType(index, tourist, data.countryTo);
            const touristFields = [{
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
                }];
            handleTouristFields(block, touristFields);
            const sexRadios = block.querySelectorAll('input[id^="SEX"]');
            setSexRadios(tourist, sexRadios);
            setCitezenship(index, tourist);
            setHuman(index, tourist);
            console.log(index);
        });
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_768.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_768.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_768__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/768 */ "./src/serverScripts/operators/768.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/services/chunks/getAndSendSamoTONumber */ "./src/app/services/chunks/getAndSendSamoTONumber.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_768__WEBPACK_IMPORTED_MODULE_0__.Mercury);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            const regExp = /(samo|samo2)\.mercury\-europe\.ru\/cl_refer\?CLAIM=(\d+)/;
            // @ts-ignore
            (_a = data.autoFillerData.customer) === null || _a === void 0 ? void 0 : _a.eVoucherClaimNumber = data.eVoucherClaimNumber;
            // @ts-ignore
            (_b = data.autoFillerData.customer) === null || _b === void 0 ? void 0 : _b.eVoucherCurrency = data.eVoucherCurrency;
            // @ts-ignore
            (_c = data.autoFillerData.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
            try {
                // @ts-ignore
                (_d = data.autoFillerData.customer) === null || _d === void 0 ? void 0 : _d.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
            }
            catch (e) { }
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_8__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 3) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, parsedUrl[2])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, _operators_768__WEBPACK_IMPORTED_MODULE_0__.Mercury.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_9__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_10__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_768__WEBPACK_IMPORTED_MODULE_0__.Mercury.credentials.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_12__.wait)(1000);
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_13__.getAndSendSamoTONumber)(tab, claimNumber);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_768__WEBPACK_IMPORTED_MODULE_0__.Mercury, errorText: null });
        }
        catch (e) {
            console.log("OneClickTravel фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(index, tourist, countryTo) {
            let optionIndex = -1;
            var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function handleTouristFields(block, touristFields) {
            touristFields.forEach(touristField => {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    console.log(touristField.value);
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        ;
        function preparePhone(phone) {
            if (phone) {
                phone = phone.replace(/\D/g, '');
                if (phone && phone.startsWith('7')) {
                    return '+' + phone;
                }
                if (phone && phone.startsWith('8')) {
                    return '+7' + phone.substr(1, phone.length);
                }
            }
            return phone;
        }
        function toUpperCase(input) {
            if (!input || input === '') {
                return '';
            }
            return input.toUpperCase();
        }
        function setCitezenship(index, tourist) {
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenship === option.value) {
                    text = option.innerText;
                }
            });
            if (!text) {
                return;
            }
            var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function setSexRadios(tourist, sexRadios) {
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexRadios[0].checked = true;
                    break;
                case 2:
                case 4:
                case 6:
                    sexRadios[1].checked = true;
                    break;
            }
        }
        function setHuman(index, tourist) {
            // 0 - CHD
            // 1 - MR
            // 2 - MRS
            let humanDdItemIndex = 0;
            switch (tourist.touristType) {
                case 1:
                    humanDdItemIndex = 1;
                    break;
                case 2:
                    humanDdItemIndex = 2;
                    break;
                case 3:
                    humanDdItemIndex = 0;
                    break;
                case 4:
                    humanDdItemIndex = 0;
                    break;
                case 5:
                    humanDdItemIndex = 0;
                    break;
                case 6:
                    humanDdItemIndex = 0;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function getOptionIndexByName(text, optionsSelector) {
            const options = document.querySelectorAll(optionsSelector);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function setCustomerDocumentType(tourist, countryTo) {
            let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
            }
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: `${customer.surnameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: `${customer.nameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: `${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                    value: customer.birthday
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                    value: customer.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                    value: customer.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                    value: customer.passportIssueCode
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(block, fields);
            // setSex(maleRadio, femaleRadio, tourist);
            // setCitezenship(index, tourist);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            setDocumentType(index, tourist, data.countryTo);
            const touristFields = [{
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
                }];
            handleTouristFields(block, touristFields);
            const sexRadios = block.querySelectorAll('input[id^="SEX"]');
            setSexRadios(tourist, sexRadios);
            setCitezenship(index, tourist);
            setHuman(index, tourist);
            console.log(index);
        });
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_81.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_81.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_81__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/81 */ "./src/serverScripts/operators/81.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













// export async function formFill(context: IClaimFillerContext): Promise<void> {
//     const {
//         data,
//         claimNumber,
//         tourUrl
//     } = context;
//     try {
//         await removeCookies({
//             url: 'https://online.spectrum.ru',
//             cookieNames: ['SAMO']
//         });
//         let tab: chrome.tabs.Tab = await createTab({
//             active: true,
//             url: tourUrl,
//             windowId: chrome.windows.WINDOW_ID_CURRENT
//         });
//         await startTrackingElement(tab, 'div#loginbox');
//         await executeScriptInTab(tab, {
//             code:  loginFormCode(new PageSelectors({
//                 login: data.login,
//                 password: data.password,
//                 packet:  {
//                     loginPath: "#loginForm #login",
//                     passwordPath: "#loginForm #password",
//                     submitPath: "#loginForm button"
//                 }
//             }))
//         });
//         const regExp: RegExp = /online\.spectrum\.ru\/cl_refer\?CLAIM=(\d+)/;
//         data.autoFillerData.customer?.eVoucherClaimNumber = data.eVoucherClaimNumber;
//         data.autoFillerData.customer?.eVoucherCurrency = data.eVoucherCurrency;
//         data.autoFillerData.customer?.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
//         try {
//             data.autoFillerData.customer?.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
//         } catch(e) {}
//         updateListenerOnSpecificPage(
//             tab.id,
//             regExp,
//             (tabId: number, changeInfo: any, updatedTab: chrome.tabs.Tab) => {
//                 const parsedUrl = updatedTab.url.match(regExp);
//                 if(parsedUrl && parsedUrl.length >= 2) {
//                     sendIdsToBookingCenter(claimNumber, parsedUrl[1])
//                     .then(() => createPushNotification({ status: SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
//                 }
//                 startTrackingElement(updatedTab, 'div.orders')
//                 .then(() => PreventPassportHiding(updatedTab))
//                 return true;
//             }
//         );
//         await startTrackingElement(tab, 'div.tourists-tabs');
//         var fillerParams: FillerParams = {
//             tourists: data.autoFillerData.touristDataItems,
//             customer: data.autoFillerData.customer,
//             countryTo: data.countryTo,
//             bookingCompanyId: data.bookingCompanyId
//         };
//         await executeScriptInTab(tab, {
//             code: stringifyFn(claimFiller, fillerParams)
//         });
//         await createPushNotification({ claimId: claimNumber, operator: Spectrum, errorText: null})
//     } catch(e) {
//         console.log("фатальная ошибка");
//         console.log(e);
//         await createPushNotification({ status: SendIdsStatus.FAIL, message: e.message })
//     }
// }
// const PreventPassportHiding = (tab: chrome.tabs.Tab): Promise<{}> => {
//     const PreventPassportHidingInternal = () => `
//         document.querySelectorAll('.passport_data').forEach(x => x.classList.remove('blur'));
//     `;
//     return startTrackingElement(tab, '.passport_data')
//         .then(() => executeScriptInTab(tab, {code: PreventPassportHidingInternal()}));
// };
// function claimFiller(data: FillerParams){
//     addScriptToPageAndRun(doFill.toString(), data);
//     function doFill(data: FillerParams) {
//         var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
//         // Иной документ - 0
//         // Паспорт - 1
//         // Свидетельство о рождении - 2
//         // Заграничный паспорт - 3 
//         // ID карта - 4
//         // Дипломатический паспорт - 5
//         // Служебный паспорт - 6
//         function getTouristAge(tourist: Tourist): number {
//             const [ day, month, year ] = tourist.birthday!.split('.');
//             const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
//             const ageDate = new Date(ageDiffMs);
//             return ageDate.getUTCFullYear() - 1970;
//         }
//         function getOptionIndexByName(text: string, optionsSelector: string): number {
//             const options = document.querySelectorAll(optionsSelector) as NodeListOf<HTMLOptionElement>;
//             for(var i = 0; i < options.length; i++) {
//                 var option = options[i];
//                 if(option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
//                     return i;
//                 }
//             }
//             return 0;
//         }
//         function setDocumentType(index: number, tourist: Tourist, countryTo: string) {
//             let optionIndex: number = -1;
//             var optionsSelector: string = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`
//             if(getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
//                 optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
//                     if(optionIndex === 0) {
//                         optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
//                     }
//             } else {
//                 if(tourist.isNationalPassport) {
//                     optionIndex = getOptionIndexByName('Passport', optionsSelector);
//                         if(optionIndex === 0) {
//                             optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
//                         }
//                 } else {
//                     optionIndex = getOptionIndexByName('International passport', optionsSelector);
//                         if(optionIndex === 0) {
//                             optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
//                         }
//                 }
//             }
//             const script = document.createElement('script');
//             const code = document.createTextNode(`
//                 document.querySelector('select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container').dispatchEvent(new Event('mousedown'));
//                 $ = samo.jQuery;
//                 $('select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]').mouseup();
//             `);
//             script.appendChild(code);
//             (document.body || document.head).appendChild(script);
//         }
//         function handleTouristFields (block: HTMLDivElement, touristFields: TouristFieldElement[]) {
//             touristFields.forEach(touristField => {
//                 const element = block.querySelector(touristField.htmlElementSelector) as HTMLInputElement;
//                 if (element && touristField.value) {
//                     console.log(touristField.value as string);
//                     element.value = touristField.value as string;
//                     element.dispatchEvent(new Event('change'));
//                     element.dispatchEvent(new Event('input'));
//                 }
//             });
//         };
//         function preparePhone(phone: string | null) {
//             if(phone) {
//                 phone = (phone as any).replace(/\D/g, '');
//                 if(phone && phone.startsWith('7')) {
//                     return '+' + phone;
//                 }
//                 if(phone && phone.startsWith('8')) {
//                     return '+7' + phone.substr(1, phone.length)
//                 }
//             }
//             return phone;
//         }
//         function toUpperCase(input: string | null) {
//             if(!input || input === '') {
//                 return '';
//             }
//             return input.toUpperCase();
//         }
//         function setCitezenship (index: number, tourist: Tourist) {
//             const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`) as HTMLSelectElement;
//             let text = undefined;
//             Array.prototype.forEach.call(select.querySelectorAll('option'), (option: HTMLOptionElement) => {
//                 if (tourist.citizenship === option.value) {
//                     text = option.innerText;
//                 }
//             });
//             if (!text) { return; }
//             const script = document.createElement('script');
//             const code = document.createTextNode(`
//                 var searchinp = document.querySelector('select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input')
//                 var dropdown = document.querySelector('select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container');
//                 searchinp.value = "${text}";
//                 dropdown.dispatchEvent(new Event('mousedown'));
//                 $ = samo.jQuery;
//                 $('select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted').mouseup()
//             `);
//             script.appendChild(code);
//             (document.body || document.head).appendChild(script);
//         };
//         function setSexRadios(tourist: Tourist, sexRadios: NodeListOf<HTMLInputElement>) {
//             switch (tourist.touristType) {
//                 case 1:
//                 case 3:
//                 case 5:
//                     sexRadios[0].checked = true;
//                     break;
//                 case 2:
//                 case 4:
//                 case 6:
//                     sexRadios[1].checked = true;
//                     break;
//             }
//         }
//         function setHuman(index: number, tourist: Tourist) {
//             // 0 - CHD
//             // 1 - MR
//             // 2 - MRS
//             let humanDdItemIndex: number = 0;
//             switch (tourist.touristType) {
//                 case 1: humanDdItemIndex = 1;
//                     break;
//                 case 2: humanDdItemIndex = 2;
//                     break;
//                 case 3: humanDdItemIndex = 0;
//                     break;
//                 case 4: humanDdItemIndex = 0;
//                     break;
//                 case 5: humanDdItemIndex = 0;
//                     break;
//                 case 6: humanDdItemIndex = 0;
//                     break;
//             }
//             const script = document.createElement('script');
//             const code = document.createTextNode(`
//                 document.querySelector('select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container').dispatchEvent(new Event('mousedown'));
//                 $ = samo.jQuery;
//                 $('select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]').mouseup()
//             `);
//             script.appendChild(code);
//             (document.body || document.head).appendChild(script);
//         };
//         function getCustomerOptionIndexByName(text: string): number {
//             const options = document.querySelectorAll(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`) as NodeListOf<HTMLOptionElement>;
//             for(var i = 0; i < options.length; i++) {
//                 var option = options[i];
//                 if(option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
//                     return i;
//                 }
//             }
//             return 0;
//         }
//         function setCustomerDocumentType(tourist: Tourist, countryTo: string) {
//             let optionIndex: number = getCustomerOptionIndexByName('паспорт') // сказали пока проставляем просто Паспорт
//             const script = document.createElement('script');
//             const code = document.createTextNode(`
//                 document.querySelector('select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container').dispatchEvent(new Event('mousedown'));
//                 $ = samo.jQuery;
//                 $('select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]').mouseup();
//             `);
//             script.appendChild(code);
//             (document.body || document.head).appendChild(script);
//         }
//         function fillCustomer(customer: Tourist | null, countryTo: string) {
//             if(!customer) return;
//             var block = document.querySelector('div.CLAIMINFO.WITHBUYER') as HTMLDivElement;
//             if(!block) return;
//             const fields: TouristFieldElement[] = [{
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
//                 value: `${customer.surnameRus}`
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
//                 value: `${customer.nameRus}`
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
//                 value: `${customer.middleNameRus}`
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
//                 value: customer.address
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
//                 value: customer.birthday
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
//                 value: customer.passportSeries
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
//                 value: customer.passportNumber
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
//                 value: customer.phone
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
//                 value: customer.email
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
//                 value: customer.eVoucherContractDate
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
//                 value: customer.eVoucherClaimNumber
//             }, {
//                 htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
//                 value: customer.eVoucherCustomerPriceInPaymentCurrency
//             }];
//             setCustomerDocumentType(customer, countryTo);
//             handleTouristFields(block, fields);
//             // setSex(maleRadio, femaleRadio, tourist);
//             // setCitezenship(index, tourist);
//         }
//         fillCustomer(data.customer, data.countryTo);
//         Array.prototype.forEach.call(touristBlocks, (block: HTMLDivElement, index: number) => {
//             const tourist = data.tourists[index];
//             if (!tourist) { return; }
//             setDocumentType(index, tourist, data.countryTo);
//             const touristFields: TouristFieldElement[] = [{
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
//                 value: toUpperCase(tourist.surnameEng)
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
//                 value: toUpperCase(tourist.surname)
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
//                 value: toUpperCase(tourist.nameEng)
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
//                 value: toUpperCase(tourist.name)
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
//                 value: toUpperCase(tourist.nameRus)
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
//                 value: toUpperCase(tourist.surname)
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
//                 value: toUpperCase(tourist.surnameRus)
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
//                 value: toUpperCase(tourist.middleNameRus)
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
//                 value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
//                 value: tourist.birthday
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
//                 value: preparePhone(tourist.phone) || '+79587764656'
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
//                 value: tourist.email || 'ocb@corp.sletat.ru'
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
//                 value: tourist.passportSeries
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
//                 value: tourist.passportNumber
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
//                 value: tourist.passportExpireDate
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
//                 value: tourist.passportDate
//             }, {
//                 htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
//                 value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
//             }];
//             handleTouristFields(block, touristFields);
//             const sexRadios = block.querySelectorAll('input[id^="SEX"]') as NodeListOf<HTMLInputElement>;
//             setSexRadios(tourist, sexRadios);
//             setCitezenship(index, tourist);
//             setHuman(index, tourist);
//             console.log(index);
//         });
//         // function addPlashka(cbCompanyId: string) {
//         //     const getBookingCompanyByCBGuid = (guid: string): any => {
//         //         const guidBookingCompany: { [id: string]: any } = {
//         //             '62b8b7e0-c368-4ec0-8fc6-cee8bbcbbe41': { name: 'ООО «АРИЛЬД»', color: '#00875a'},
//         //             '4016198a-5249-43b7-b3a0-a4cf53b96cd4': { name: 'ООО «ОЦБ»', color: '#ff8b00'},
//         //             'a284bfd4-08e5-4f7d-a11c-f745c3c8bdc5': { name: 'ООО «ОЦБ K»', color: '#ff8b00'},
//         //             'a0c2a815-daec-47f1-a558-c921f13482cc': { name: 'ООО «ГорТревел»', color: '#0747a6'},
//         //             '96c57522-c7b9-43fb-ab7a-15f98d3972d4': { name: 'ООО «Все Туры»', color: '#de350b'},
//         //             'eee2cd51-5bb0-495b-9067-ec30adfece47': { name: 'ООО «ГорТревел В»', color: '#403294'},
//         //             '387d946b-82e6-4a9d-bd02-1ebde5ebcd0a': { name: 'ИП Абрамов Денис Дмитриевич', color: '#ffab00'},
//         //             '7784c883-fad4-4402-ba0a-07fda56f5edb': { name: 'ООО СолнцеТур', color: '#505f79'}
//         //         };
//         //         return guidBookingCompany[guid] || { name: 'ООО НЕИЗВЕСТНО', color: 'pink'};
//         //     };
//         //     var urLico = getBookingCompanyByCBGuid(cbCompanyId);
//         //     const divToAddParent = document.createElement('div') as HTMLElement;
//         //     divToAddParent.id = 'urlicocbParent';
//         //     divToAddParent.setAttribute('style', `
//         //         width: 532px;
//         //         height: 50px;
//         //         position: relative;
//         //         border: 10px solid ${urLico.color};
//         //         border-radius: 10px;
//         //         margin-bottom: 25px;
//         //     `);
//         //     const divToAddChild = document.createElement('div') as HTMLElement;
//         //     divToAddChild.innerHTML = urLico.name;
//         //     divToAddChild.id = 'urlicocbChild';
//         //     divToAddChild.setAttribute('style', `
//         //         margin: 0;
//         //         position: absolute;
//         //         top: 50%;
//         //         left: 50%;
//         //         -ms-transform: translate(-50%, -50%);
//         //         transform: translate(-50%, -50%);
//         //         font-weight: bold;
//         //         font-size: x-large;
//         //     `);
//         //     divToAddParent.appendChild(divToAddChild);
//         //     const priceInfo = document.querySelector('div.PRICEINFO');
//         //     if(priceInfo) {
//         //         priceInfo.prepend(divToAddParent);
//         //     }
//         // }
//         // addPlashka(data.bookingCompanyId);
//     }
// }
function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__.removeCookiesForTouroperator)(_operators_81__WEBPACK_IMPORTED_MODULE_0__.Spectrum);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, _operators_81__WEBPACK_IMPORTED_MODULE_0__.Spectrum.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_8__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_81__WEBPACK_IMPORTED_MODULE_0__.Spectrum.credentials.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_11__.wait)(1000);
            const regExp = /online\.spectrum\.ru\/cl_refer\?CLAIM=(\d+)/;
            // @ts-ignore
            (_a = data.autoFillerData.customer) === null || _a === void 0 ? void 0 : _a.eVoucherClaimNumber = data.eVoucherClaimNumber;
            // @ts-ignore
            (_b = data.autoFillerData.customer) === null || _b === void 0 ? void 0 : _b.eVoucherCurrency = data.eVoucherCurrency;
            // @ts-ignore
            (_c = data.autoFillerData.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
            try {
                // @ts-ignore
                (_d = data.autoFillerData.customer) === null || _d === void 0 ? void 0 : _d.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
            }
            catch (e) { }
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_9__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_6__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_2__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_12__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_81__WEBPACK_IMPORTED_MODULE_0__.Spectrum, errorText: null });
        }
        catch (e) {
            console.log("Spectrum фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(index, tourist, countryTo) {
            let optionIndex = -1;
            var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function handleTouristFields(block, touristFields) {
            touristFields.forEach(touristField => {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    console.log(touristField.value);
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        ;
        function preparePhone(phone) {
            if (phone) {
                phone = phone.replace(/\D/g, '');
                if (phone && phone.startsWith('7')) {
                    return '+' + phone;
                }
                if (phone && phone.startsWith('8')) {
                    return '+7' + phone.substr(1, phone.length);
                }
            }
            return phone;
        }
        function toUpperCase(input) {
            if (!input || input === '') {
                return '';
            }
            return input.toUpperCase();
        }
        function setCitezenship(index, tourist) {
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenship === option.value) {
                    text = option.innerText;
                }
            });
            if (!text) {
                return;
            }
            var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function setSexRadios(tourist, sexRadios) {
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexRadios[0].checked = true;
                    break;
                case 2:
                case 4:
                case 6:
                    sexRadios[1].checked = true;
                    break;
            }
        }
        function setHuman(index, tourist) {
            // 0 - CHD
            // 1 - MR
            // 2 - MRS
            let humanDdItemIndex = 0;
            switch (tourist.touristType) {
                case 1:
                    humanDdItemIndex = 1;
                    break;
                case 2:
                    humanDdItemIndex = 2;
                    break;
                case 3:
                    humanDdItemIndex = 0;
                    break;
                case 4:
                    humanDdItemIndex = 0;
                    break;
                case 5:
                    humanDdItemIndex = 0;
                    break;
                case 6:
                    humanDdItemIndex = 0;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function getOptionIndexByName(text, optionsSelector) {
            const options = document.querySelectorAll(optionsSelector);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function setCustomerDocumentType(tourist, countryTo) {
            let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
            }
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: `${customer.surnameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: `${customer.nameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: `${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                    value: customer.birthday
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                    value: customer.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                    value: customer.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                    value: customer.passportIssueCode
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(block, fields);
            // setSex(maleRadio, femaleRadio, tourist);
            // setCitezenship(index, tourist);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            setDocumentType(index, tourist, data.countryTo);
            const touristFields = [{
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
                }];
            handleTouristFields(block, touristFields);
            const sexRadios = block.querySelectorAll('input[id^="SEX"]');
            setSexRadios(tourist, sexRadios);
            setCitezenship(index, tourist);
            //setHuman(index, tourist);
            console.log(index);
        });
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_820.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_820.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_rusExpress__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/rusExpress */ "./src/serverScripts/operators/rusExpress.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/services/chunks/getAndSendSamoTONumber */ "./src/app/services/chunks/getAndSendSamoTONumber.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_rusExpress__WEBPACK_IMPORTED_MODULE_0__.RusExpress);
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({
                url: 'https://search.r-express.ru',
                cookieNames: ['SAMO']
            });
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, _operators_rusExpress__WEBPACK_IMPORTED_MODULE_0__.RusExpress.credentials.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_11__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_rusExpress__WEBPACK_IMPORTED_MODULE_0__.RusExpress.credentials.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_13__.wait)(1000);
            // @ts-ignore
            (_a = data.autoFillerData.customer) === null || _a === void 0 ? void 0 : _a.eVoucherClaimNumber = data.eVoucherClaimNumber;
            // @ts-ignore
            (_b = data.autoFillerData.customer) === null || _b === void 0 ? void 0 : _b.eVoucherCurrency = data.eVoucherCurrency;
            // @ts-ignore
            (_c = data.autoFillerData.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
            try {
                // @ts-ignore
                (_d = data.autoFillerData.customer) === null || _d === void 0 ? void 0 : _d.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
            }
            catch (e) { }
            const regExp = /(search|online)\.r\-express\.ru\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_9__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 3) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, parsedUrl[2])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_12__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_8__.getAndSendSamoTONumber)(tab, claimNumber);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_rusExpress__WEBPACK_IMPORTED_MODULE_0__.RusExpress, errorText: null });
        }
        catch (e) {
            console.log("RusExpress фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_6__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        function getTouristAge(tourist) {
            const [day, month, year] = tourist.birthday.split('.');
            const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
            const ageDate = new Date(ageDiffMs);
            return ageDate.getUTCFullYear() - 1970;
        }
        function setDocumentType(index, tourist, countryTo) {
            let optionIndex = -1;
            var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
            if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (tourist.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function handleTouristFields(block, touristFields) {
            touristFields.forEach(touristField => {
                const element = block.querySelector(touristField.htmlElementSelector);
                if (element && touristField.value) {
                    console.log(touristField.value);
                    element.value = touristField.value;
                    element.dispatchEvent(new Event('change'));
                    element.dispatchEvent(new Event('input'));
                }
            });
        }
        ;
        function preparePhone(phone) {
            if (phone) {
                phone = phone.replace(/\D/g, '');
                if (phone && phone.startsWith('7')) {
                    return '+' + phone;
                }
                if (phone && phone.startsWith('8')) {
                    return '+7' + phone.substr(1, phone.length);
                }
            }
            return phone;
        }
        function toUpperCase(input) {
            if (!input || input === '') {
                return '';
            }
            return input.toUpperCase();
        }
        function setCitezenship(index, tourist) {
            const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
            let text = undefined;
            Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
                if (tourist.citizenship === option.value) {
                    text = option.innerText;
                }
            });
            if (!text) {
                return;
            }
            var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
            var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
            searchinp.value = text;
            dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        ;
        function setSex(index, tourist) {
            let sexTypeIndex = 0;
            switch (tourist.touristType) {
                case 1:
                case 3:
                case 5:
                    sexTypeIndex = 2;
                    break;
                case 2:
                case 4:
                case 6:
                    sexTypeIndex = 1;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function setHuman(index, tourist) {
            // 0 ----
            // 1 - CHD
            // 2 - MR
            // 3 - MRS
            // maleGrown = 1,
            // femaleGrown,
            // maleChild,
            // femaleChild,
            // maleInfant,
            // femaleInfant
            let humanDdItemIndex = 0;
            switch (tourist.touristType) {
                case 1:
                    humanDdItemIndex = 2;
                    break;
                case 2:
                    humanDdItemIndex = 3;
                    break;
                case 3:
                    humanDdItemIndex = 1;
                    break;
                case 4:
                    humanDdItemIndex = 1;
                    break;
                case 5:
                    humanDdItemIndex = 1;
                    break;
                case 6:
                    humanDdItemIndex = 1;
                    break;
            }
            document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            if (document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`)) {
                document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            }
        }
        ;
        function getOptionIndexByName(text, optionsSelector) {
            const options = document.querySelectorAll(optionsSelector);
            for (var i = 0; i < options.length; i++) {
                var option = options[i];
                if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                    return i;
                }
            }
            return 0;
        }
        function setCustomerDocumentType(tourist, countryTo) {
            if (!document.querySelector('select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"]'))
                return;
            let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
            }
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
        function fillCustomer(customer, countryTo) {
            var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
            if (!block)
                return;
            const fields = [{
                    htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                    value: `${customer.surnameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                    value: `${customer.nameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                    value: `${customer.middleNameRus}`
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                    value: customer.address
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                    value: customer.birthday
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                    value: customer.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                    value: customer.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                    value: customer.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                    value: customer.passportIssueOrg
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                    value: customer.passportIssueCode
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                    value: customer.phone
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                    value: customer.email
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                    value: customer.eVoucherContractDate
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                    value: customer.eVoucherClaimNumber
                }, {
                    htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                    value: customer.eVoucherCustomerPriceInPaymentCurrency
                }];
            setCustomerDocumentType(customer, countryTo);
            handleTouristFields(block, fields);
            // setSex(maleRadio, femaleRadio, tourist);
            // setCitezenship(index, tourist);
        }
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            setHuman(index, tourist);
            setSex(index, tourist);
            setCitezenship(index, tourist);
            setDocumentType(index, tourist, data.countryTo);
            const touristFields = [{
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus)
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru'
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
                }];
            handleTouristFields(block, touristFields);
            console.log(index);
        });
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_artTour.ts":
/*!********************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_artTour.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/services/chunks/getAndSendSamoTONumber */ "./src/app/services/chunks/getAndSendSamoTONumber.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/moveEvoucherDataToCustomer */ "./src/app/utils/chunks/moveEvoucherDataToCustomer.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _operators_artTour__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../operators/artTour */ "./src/serverScripts/operators/artTour.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};















function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_10__.removeCookiesForTouroperator)(_operators_artTour__WEBPACK_IMPORTED_MODULE_14__.ArtTour);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_6__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__.startTrackingElement)(tab, _operators_artTour__WEBPACK_IMPORTED_MODULE_14__.ArtTour.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_7__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_artTour__WEBPACK_IMPORTED_MODULE_14__.ArtTour.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__.wait)(2 * 1000);
            data.autoFillerData.customer = (0,_app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_9__.moveEvoucherDataToCustomer)(data.autoFillerData.customer, data);
            const regExp = /online\.arttour\.ru\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_13__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_3__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_2__.getAndSendSamoTONumber)(tab, claimNumber);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_artTour__WEBPACK_IMPORTED_MODULE_14__.ArtTour, errorText: null });
        }
        catch (e) {
            console.log("ArtTour фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('ClaimFiller ArtTour');
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
        FieldType[FieldType["Human"] = 6] = "Human";
    })(FieldType || (FieldType = {}));
    function localWait(timeout, optionIndex) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(optionIndex), timeout);
        });
    }
    var mainChain = new Promise((res, rej) => res());
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function fillDocType(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            let optionIndex = -1;
            var optionsSelector = `${touristField.htmlElementSelector} option`;
            if (getTouristAge(touristField.value) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(data.countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (touristField.value.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            res(optionIndex);
        }))
            .then((optionIndex) => new Promise((res, rej) => {
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            res(optionIndex);
        }))
            .then((optionIndex) => localWait(250, optionIndex))
            .then((optionIndex) => new Promise((res, rej) => {
            try {
                block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            }
            catch (e) {
                console.log('fillDocType fail');
                console.log(e);
                console.dir(e);
            }
            res();
        }));
    }
    function fillText(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            const element = block.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                element.value = touristField.value;
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
            res();
        }));
    }
    function fillHuman(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            // 0 - CHD
            // 1 - MR
            // 2 - MRS
            let humanDdItemIndex = 0;
            switch (touristField.value) {
                case 1:
                    humanDdItemIndex = 1;
                    break;
                case 2:
                    humanDdItemIndex = 2;
                    break;
                case 3:
                    humanDdItemIndex = 0;
                    break;
                case 4:
                    humanDdItemIndex = 0;
                    break;
                case 5:
                    humanDdItemIndex = 0;
                    break;
                case 6:
                    humanDdItemIndex = 0;
                    break;
            }
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            res();
        }));
    }
    function fillSex(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            let sexTypeIndex = 0;
            switch (touristField.value) {
                case 1:
                case 3:
                case 5:
                    sexTypeIndex = 2;
                    break;
                case 2:
                case 4:
                case 6:
                    sexTypeIndex = 1;
                    break;
            }
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            res();
        }));
    }
    function fillCitizenship(block, touristField) {
        const select = block.querySelector(touristField.htmlElementSelector);
        let text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
            if (touristField.value === option.innerText) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var searchinp = document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container input`);
        var dropdown = document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`);
        searchinp.value = text;
        dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
        document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    ;
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(touristField => {
            switch (touristField.fieldType) {
                case FieldType.Human:
                    fillHuman(block, touristField);
                    break;
                case FieldType.Sex:
                    fillSex(block, touristField);
                    break;
                case FieldType.Text:
                    fillText(block, touristField);
                    break;
                case FieldType.Citizenship:
                    fillCitizenship(block, touristField);
                    break;
                case FieldType.Select:
                    fillDocType(block, touristField);
                    break;
                default: break;
            }
            mainChain = mainChain.then(() => localWait(touristField.delay || 250, 0));
        });
    }
    ;
    function preparePhone(phone) {
        if (phone) {
            phone = phone.replace(/\D/g, '');
            if (phone && phone.startsWith('7')) {
                return '+' + phone;
            }
            if (phone && phone.startsWith('8')) {
                return '+7' + phone.substr(1, phone.length);
            }
        }
        return phone;
    }
    function toUpperCase(input) {
        if (!input || input === '') {
            return '';
        }
        return input.toUpperCase();
    }
    function getOptionIndexByName(text, optionsSelector) {
        const options = document.querySelectorAll(optionsSelector);
        for (var i = 0; i < options.length; i++) {
            var option = options[i];
            if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                return i;
            }
        }
        return 0;
    }
    function fillCustomer(customer, countryTo) {
        var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
        if (!block)
            return;
        const fields = [{
                htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                value: `${customer.surnameRus}`,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                value: `${customer.nameRus}`,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                value: `${customer.middleNameRus}`,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                value: customer.address,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                value: customer.birthday,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                value: customer.passportSeries,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                value: customer.passportNumber,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                value: customer.passportDate,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                value: customer.passportIssueOrg,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                value: customer.passportIssueCode,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                value: customer.phone,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                value: customer.email,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                value: customer.eVoucherContractDate,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                value: customer.eVoucherClaimNumber,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                value: customer.eVoucherCustomerPriceInPaymentCurrency,
                fieldType: FieldType.Text
            }];
        setCustomerDocumentType(customer, countryTo);
        handleTouristFields(block, fields);
        // setSex(maleRadio, femaleRadio, tourist);
        // setCitezenship(index, tourist);
    }
    function setCustomerDocumentType(tourist, countryTo) {
        let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
        if (optionIndex === 0) {
            optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
        }
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            //setDocumentType(index, tourist, data.countryTo);
            const touristFields = [
                // {
                //     htmlElementSelector: `select[name="frm[People][${index + 1}][HUMAN]"]`,
                //     value: tourist.touristType,
                //     fieldType: FieldType.Human
                // },
                {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][MALE]"]`,
                    value: tourist.touristType,
                    fieldType: FieldType.Sex
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday,
                    fieldType: FieldType.Text,
                    delay: 2 * 1000
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"], input[name="frm[People][${index + 1}][PHONE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru',
                    fieldType: FieldType.Text
                },
                // {
                //     htmlElementSelector: `input[name="frm[People][${index + 1}][INN]"]`,
                //     value: tourist.email || 'ocb@corp.sletat.ru',
                //     fieldType: FieldType.Text
                // },
                {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][NATIONALITY]"]`,
                    value: tourist.citizenshipName,
                    fieldType: FieldType.Citizenship,
                    delay: 2 * 1000
                }, {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"]`,
                    value: tourist,
                    fieldType: FieldType.Select,
                    delay: 5 * 1000
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase(),
                    fieldType: FieldType.Text
                }
            ];
            handleTouristFields(document.querySelector('div.samo_container'), touristFields);
        });
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_evroport.ts":
/*!*********************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_evroport.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/services/chunks/getAndSendSamoTONumber */ "./src/app/services/chunks/getAndSendSamoTONumber.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/moveEvoucherDataToCustomer */ "./src/app/utils/chunks/moveEvoucherDataToCustomer.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _operators_evroport__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../operators/evroport */ "./src/serverScripts/operators/evroport.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};















function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_10__.removeCookiesForTouroperator)(_operators_evroport__WEBPACK_IMPORTED_MODULE_14__.Evroport);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_6__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__.startTrackingElement)(tab, _operators_evroport__WEBPACK_IMPORTED_MODULE_14__.Evroport.packet.loginPath);
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_7__.executeLoginScriptInTabV3)(tab, new _app_messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: data.login,
                password: data.password,
                packet: _operators_evroport__WEBPACK_IMPORTED_MODULE_14__.Evroport.packet
            }));
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel');
            yield (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__.wait)(2 * 1000);
            data.autoFillerData.customer = (0,_app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_9__.moveEvoucherDataToCustomer)(data.autoFillerData.customer, data);
            const regExp = /samo\.evroport\.ru\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_13__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_3__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__.startTrackingElement)(updatedTab, 'div.orders')
                    .then(() => (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__.removeSamoPassportBlur)(updatedTab));
                return true;
            });
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__.executeScriptInTabV3)(tab, claimFiller, [{
                    tourists: data.autoFillerData.touristDataItems,
                    customer: data.autoFillerData.customer,
                    countryTo: data.countryTo,
                }]);
            yield (0,_app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_2__.getAndSendSamoTONumber)(tab, claimNumber);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_evroport__WEBPACK_IMPORTED_MODULE_14__.Evroport, errorText: null });
        }
        catch (e) {
            console.log("Evroport фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_1__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('ClaimFiller Evroport');
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
        FieldType[FieldType["Human"] = 6] = "Human";
    })(FieldType || (FieldType = {}));
    function localWait(timeout, optionIndex) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(optionIndex), timeout);
        });
    }
    var mainChain = new Promise((res, rej) => res());
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function fillDocType(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            let optionIndex = -1;
            var optionsSelector = `${touristField.htmlElementSelector} option`;
            if (getTouristAge(touristField.value) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(data.countryTo.toUpperCase()) !== -1) {
                optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
                }
            }
            else {
                if (touristField.value.isNationalPassport) {
                    optionIndex = getOptionIndexByName('Passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                    }
                }
                else {
                    optionIndex = getOptionIndexByName('International passport', optionsSelector);
                    if (optionIndex === 0) {
                        optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                    }
                }
            }
            res(optionIndex);
        }))
            .then((optionIndex) => new Promise((res, rej) => {
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            res(optionIndex);
        }))
            .then((optionIndex) => localWait(250, optionIndex))
            .then((optionIndex) => new Promise((res, rej) => {
            try {
                block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            }
            catch (e) {
                console.log('fillDocType fail');
                console.log(e);
                console.dir(e);
            }
            res();
        }));
    }
    function fillText(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            const element = block.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                element.value = touristField.value;
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
            res();
        }));
    }
    function fillHuman(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            // 0 - CHD
            // 1 - MR
            // 2 - MRS
            let humanDdItemIndex = 0;
            switch (touristField.value) {
                case 1:
                    humanDdItemIndex = 1;
                    break;
                case 2:
                    humanDdItemIndex = 2;
                    break;
                case 3:
                    humanDdItemIndex = 0;
                    break;
                case 4:
                    humanDdItemIndex = 0;
                    break;
                case 5:
                    humanDdItemIndex = 0;
                    break;
                case 6:
                    humanDdItemIndex = 0;
                    break;
            }
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
            block.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
            res();
        }));
    }
    function fillSex(block, touristField) {
        mainChain = mainChain.then(() => new Promise((res, rej) => {
            let sexTypeIndex = 0;
            switch (touristField.value) {
                case 1:
                case 3:
                case 5:
                    sexTypeIndex = 0;
                    break;
                case 2:
                case 4:
                case 6:
                    sexTypeIndex = 1;
                    break;
            }
            let radios = block.querySelectorAll(touristField.htmlElementSelector);
            if (radios) {
                if (radios[sexTypeIndex]) {
                    radios[sexTypeIndex].click();
                }
            }
            res();
        }));
    }
    function fillCitizenship(block, touristField) {
        const select = block.querySelector(touristField.htmlElementSelector);
        let text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
            if (touristField.value === option.innerText) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var searchinp = document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container input`);
        var dropdown = document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`);
        searchinp.value = text;
        dropdown.dispatchEvent(new Event('mousedown', { bubbles: true }));
        document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    ;
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(touristField => {
            switch (touristField.fieldType) {
                case FieldType.Human:
                    fillHuman(block, touristField);
                    break;
                case FieldType.Sex:
                    fillSex(block, touristField);
                    break;
                case FieldType.Text:
                    fillText(block, touristField);
                    break;
                case FieldType.Citizenship:
                    fillCitizenship(block, touristField);
                    break;
                case FieldType.Select:
                    fillDocType(block, touristField);
                    break;
                default: break;
            }
            mainChain = mainChain.then(() => localWait(touristField.delay || 250, 0));
        });
    }
    ;
    function preparePhone(phone) {
        if (phone) {
            phone = phone.replace(/\D/g, '');
            if (phone && phone.startsWith('7')) {
                return '+' + phone;
            }
            if (phone && phone.startsWith('8')) {
                return '+7' + phone.substr(1, phone.length);
            }
        }
        return phone;
    }
    function toUpperCase(input) {
        if (!input || input === '') {
            return '';
        }
        return input.toUpperCase();
    }
    function getOptionIndexByName(text, optionsSelector) {
        const options = document.querySelectorAll(optionsSelector);
        for (var i = 0; i < options.length; i++) {
            var option = options[i];
            if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                return i;
            }
        }
        return 0;
    }
    function fillCustomer(customer, countryTo) {
        var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
        if (!block)
            return;
        const fields = [{
                htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                value: `${customer.surnameRus}`,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                value: `${customer.nameRus}`,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                value: `${customer.middleNameRus}`,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                value: customer.address,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                value: customer.birthday,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                value: customer.passportSeries,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                value: customer.passportNumber,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVEN]"]`,
                value: customer.passportDate,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENORG]"]`,
                value: customer.passportIssueOrg,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PGIVENCODE]"]`,
                value: customer.passportIssueCode,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                value: customer.phone,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                value: customer.email,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                value: customer.eVoucherContractDate,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                value: customer.eVoucherClaimNumber,
                fieldType: FieldType.Text
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                value: customer.eVoucherCustomerPriceInPaymentCurrency,
                fieldType: FieldType.Text
            }];
        setCustomerDocumentType(customer, countryTo);
        handleTouristFields(block, fields);
        // setSex(maleRadio, femaleRadio, tourist);
        // setCitezenship(index, tourist);
    }
    function setCustomerDocumentType(tourist, countryTo) {
        let optionIndex = getOptionIndexByName('Passport', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`); // сказали пока проставляем просто Паспорт
        if (optionIndex === 0) {
            optionIndex = getOptionIndexByName('Паспорт', `select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
        }
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown', { bubbles: true }));
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function doFill(data) {
        var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
        Array.prototype.forEach.call(touristBlocks, (block, index) => {
            const tourist = data.tourists[index];
            if (!tourist) {
                return;
            }
            //setDocumentType(index, tourist, data.countryTo);
            const touristFields = [
                {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][HUMAN]"]`,
                    value: tourist.touristType,
                    fieldType: FieldType.Human
                },
                {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MALE]"]`,
                    value: tourist.touristType,
                    fieldType: FieldType.Sex
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.surnameEng),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                    value: toUpperCase(tourist.surname),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                    value: toUpperCase(tourist.nameEng),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                    value: toUpperCase(tourist.name),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                    value: toUpperCase(tourist.nameRus),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                    value: toUpperCase(tourist.surname),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                    value: toUpperCase(tourist.surnameRus),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                    value: toUpperCase(tourist.middleNameRus),
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                    value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                    value: tourist.birthday,
                    fieldType: FieldType.Text,
                    delay: 2 * 1000
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"], input[name="frm[People][${index + 1}][PHONE]"]`,
                    value: preparePhone(tourist.phone) || '+79587764656',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                    value: tourist.email || 'ocb@corp.sletat.ru',
                    fieldType: FieldType.Text
                },
                // {
                //     htmlElementSelector: `input[name="frm[People][${index + 1}][INN]"]`,
                //     value: tourist.email || 'ocb@corp.sletat.ru',
                //     fieldType: FieldType.Text
                // },
                {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][NATIONALITY]"]`,
                    value: tourist.citizenshipName,
                    fieldType: FieldType.Citizenship,
                    delay: 2 * 1000
                }, {
                    htmlElementSelector: `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"]`,
                    value: tourist,
                    fieldType: FieldType.Select,
                    delay: 5 * 1000
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                    value: tourist.passportSeries,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                    value: tourist.passportNumber,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                    value: tourist.passportExpireDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                    value: tourist.passportDate,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                    value: (tourist.passportIssueOrg || 'FMS').toUpperCase(),
                    fieldType: FieldType.Text
                }
            ];
            handleTouristFields(document.querySelector('div.samo_container'), touristFields);
        });
        if (data.customer) {
            fillCustomer(data.customer, data.countryTo);
        }
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_intourist_Samo.ts":
/*!***************************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_intourist_Samo.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_inturist__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/inturist */ "./src/serverScripts/operators/inturist.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/services/chunks/getAndSendSamoTONumber */ "./src/app/services/chunks/getAndSendSamoTONumber.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e;
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__.removeCookiesForTouroperator)(_operators_inturist__WEBPACK_IMPORTED_MODULE_0__.Intourist);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, 'div#loginbox');
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__.executeLoginScriptInTabV3)(tab, {
                login: data.login,
                password: data.password,
                packet: (_a = _operators_inturist__WEBPACK_IMPORTED_MODULE_0__.Intourist.credentials) === null || _a === void 0 ? void 0 : _a.packet
            });
            // https://searchtour.intourist.ru/cl_refer?CLAIM=5955944
            const regExp = /searchtour\.intourist\.ru\/cl_refer\?CLAIM=(\d+)/;
            // @ts-ignore
            (_b = data.autoFillerData.customer) === null || _b === void 0 ? void 0 : _b.eVoucherClaimNumber = data.eVoucherClaimNumber;
            // @ts-ignore
            (_c = data.autoFillerData.customer) === null || _c === void 0 ? void 0 : _c.eVoucherCurrency = data.eVoucherCurrency;
            // @ts-ignore
            (_d = data.autoFillerData.customer) === null || _d === void 0 ? void 0 : _d.eVoucherCustomerPriceInPaymentCurrency = data.eVoucherCustomerPriceInPaymentCurrency;
            try {
                // @ts-ignore
                (_e = data.autoFillerData.customer) === null || _e === void 0 ? void 0 : _e.eVoucherContractDate = new Date(Date.parse(data.eVoucherContractDate)).toLocaleDateString('ru-RU');
            }
            catch (e) { }
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_4__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                // @ts-ignore
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_7__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                // startTrackingElement(updatedTab, 'div.orders')
                // .then(() => PreventPassportHiding(updatedTab))
                return true;
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, 'div.tourists-tabs');
            var fillerParams = {
                tourists: data.autoFillerData.touristDataItems,
                customer: data.autoFillerData.customer,
                countryTo: data.countryTo,
                bookingCompanyId: data.bookingCompanyId
            };
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(tab, claimFiller, [fillerParams]);
            yield (0,_app_services_chunks_getAndSendSamoTONumber__WEBPACK_IMPORTED_MODULE_8__.getAndSendSamoTONumber)(tab, claimNumber);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: claimNumber, operator: _operators_inturist__WEBPACK_IMPORTED_MODULE_0__.Intourist, errorText: null });
        }
        catch (e) {
            console.log("formFill фатальная ошибка Intourist");
            console.log(e);
            console.dir(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
    // Иной документ - 0
    // Паспорт - 1
    // Свидетельство о рождении - 2
    // Заграничный паспорт - 3 
    // ID карта - 4
    // Дипломатический паспорт - 5
    // Служебный паспорт - 6
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function getOptionIndexByName(text, optionsSelector) {
        const options = document.querySelectorAll(optionsSelector);
        for (var i = 0; i < options.length; i++) {
            var option = options[i];
            if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                return i;
            }
        }
        return 0;
    }
    function setDocumentType(index, tourist, countryTo) {
        let optionIndex = -1;
        var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
        if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
            optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
            }
        }
        else {
            if (tourist.isNationalPassport) {
                optionIndex = getOptionIndexByName('Passport', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                }
            }
            else {
                optionIndex = getOptionIndexByName('International passport', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Заграничный паспорт', optionsSelector);
                }
            }
        }
        document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(touristField => {
            const element = block.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                console.log(touristField.value);
                element.value = touristField.value;
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
        });
    }
    ;
    function preparePhone(phone) {
        if (phone) {
            phone = phone.replace(/\D/g, '');
            if (phone && phone.startsWith('7')) {
                return '+' + phone;
            }
            if (phone && phone.startsWith('8')) {
                return '+7' + phone.substr(1, phone.length);
            }
        }
        return phone;
    }
    function toUpperCase(input) {
        if (!input || input === '') {
            return '';
        }
        return input.toUpperCase();
    }
    function setCitezenship(index, tourist) {
        debugger;
        const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
        let text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
            var _a, _b;
            if (((_a = tourist.citizenshipName) === null || _a === void 0 ? void 0 : _a.toUpperCase()) === ((_b = option.text) === null || _b === void 0 ? void 0 : _b.toUpperCase())) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
        var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
        searchinp.value = text;
        dropdown.dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    ;
    function setSexRadios(index, tourist) {
        // maleGrown = 1,
        // femaleGrown = 2,
        // maleChild = 3,
        // femaleChild = 4,
        // maleInfant = 5,
        // femaleInfant = 6
        let sexTypeIndex = 0;
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                sexTypeIndex = 2;
                break;
            case 2:
            case 4:
            case 6:
                sexTypeIndex = 1;
                break;
        }
        document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][MALE]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function setHuman(index, tourist) {
        // 0 - CHD
        // 1 - MR
        // 2 - MRS
        let humanDdItemIndex = 0;
        switch (tourist.touristType) {
            case 1:
                humanDdItemIndex = 2;
                break;
            case 2:
                humanDdItemIndex = 3;
                break;
            case 3:
                humanDdItemIndex = 1;
                break;
            case 4:
                humanDdItemIndex = 1;
                break;
            case 5:
                humanDdItemIndex = 1;
                break;
            case 6:
                humanDdItemIndex = 1;
                break;
        }
        document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    ;
    function getCustomerOptionIndexByName(text) {
        const options = document.querySelectorAll(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
        for (var i = 0; i < options.length; i++) {
            var option = options[i];
            if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                return i;
            }
        }
        return 0;
    }
    function setCustomerDocumentType(tourist, countryTo) {
        let optionIndex = getCustomerOptionIndexByName('паспорт'); // сказали пока проставляем просто Паспорт
        if (document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"]`)) {
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
            document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
        }
    }
    function fillCustomer(customer, countryTo) {
        if (!customer)
            return;
        var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
        if (!block)
            return;
        const fields = [{
                htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                value: `${customer.surnameRus}`
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                value: `${customer.nameRus}`
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                value: `${customer.middleNameRus}`
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                value: customer.address
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                value: customer.birthday
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                value: customer.passportSeries
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                value: customer.passportNumber
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                value: customer.phone
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                value: customer.email
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                value: customer.eVoucherContractDate
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                value: customer.eVoucherClaimNumber
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                value: customer.eVoucherCustomerPriceInPaymentCurrency
            }];
        setCustomerDocumentType(customer, countryTo);
        handleTouristFields(block, fields);
        // setSex(maleRadio, femaleRadio, tourist);
        // setCitezenship(index, tourist);
    }
    fillCustomer(data.customer, data.countryTo);
    Array.prototype.forEach.call(touristBlocks, (block, index) => {
        const tourist = data.tourists[index];
        if (!tourist) {
            return;
        }
        setDocumentType(index, tourist, data.countryTo);
        const touristFields = [{
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                value: toUpperCase(tourist.surnameEng)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                value: toUpperCase(tourist.surname)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                value: toUpperCase(tourist.nameEng)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                value: toUpperCase(tourist.name)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                value: toUpperCase(tourist.nameRus)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                value: toUpperCase(tourist.surname)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                value: toUpperCase(tourist.surnameRus)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                value: toUpperCase(tourist.middleNameRus)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                value: tourist.birthday
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                value: preparePhone(tourist.phone) || '+79587764656'
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                value: tourist.email || 'ocb@corp.sletat.ru'
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                value: tourist.passportSeries
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                value: tourist.passportNumber
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                value: tourist.passportExpireDate
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                value: tourist.passportDate
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
            }];
        handleTouristFields(block, touristFields);
        setSexRadios(index, tourist);
        setCitezenship(index, tourist);
        setHuman(index, tourist);
        console.log(index);
    });
    function addPlashka(cbCompanyId) {
        const getBookingCompanyByCBGuid = (guid) => {
            const guidBookingCompany = {
                '62b8b7e0-c368-4ec0-8fc6-cee8bbcbbe41': { name: 'ООО «АРИЛЬД»', color: '#00875a' },
                '4016198a-5249-43b7-b3a0-a4cf53b96cd4': { name: 'ООО «ОЦБ»', color: '#ff8b00' },
                'a284bfd4-08e5-4f7d-a11c-f745c3c8bdc5': { name: 'ООО «ОЦБ K»', color: '#ff8b00' },
                'a0c2a815-daec-47f1-a558-c921f13482cc': { name: 'ООО «ГорТревел»', color: '#0747a6' },
                '96c57522-c7b9-43fb-ab7a-15f98d3972d4': { name: 'ООО «Все Туры»', color: '#de350b' },
                'eee2cd51-5bb0-495b-9067-ec30adfece47': { name: 'ООО «ГорТревел В»', color: '#403294' },
                'd85b47f8-d524-4f85-9dd6-70100983fb49': { name: 'ООО «МСУ Тех»', color: '#66FF00' },
                '387d946b-82e6-4a9d-bd02-1ebde5ebcd0a': { name: 'ИП Абрамов Денис Дмитриевич', color: '#ffab00' },
                '7784c883-fad4-4402-ba0a-07fda56f5edb': { name: 'ООО СолнцеТур', color: '#505f79' }
            };
            return guidBookingCompany[guid] || { name: 'ООО НЕИЗВЕСТНО', color: 'pink' };
        };
        var urLico = getBookingCompanyByCBGuid(cbCompanyId);
        const divToAddParent = document.createElement('div');
        divToAddParent.id = 'urlicocbParent';
        divToAddParent.setAttribute('style', `
            width: 532px;
            height: 50px;
            position: relative;
            border: 10px solid ${urLico.color};
            border-radius: 10px;
            margin-bottom: 25px;
        `);
        const divToAddChild = document.createElement('div');
        divToAddChild.innerHTML = urLico.name;
        divToAddChild.id = 'urlicocbChild';
        divToAddChild.setAttribute('style', `
            margin: 0;
            position: absolute;
            top: 50%;
            left: 50%;
            -ms-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            font-weight: bold;
            font-size: x-large;
        `);
        divToAddParent.appendChild(divToAddChild);
        const priceInfo = document.querySelector('div.PRICEINFO');
        if (priceInfo) {
            priceInfo.prepend(divToAddParent);
        }
    }
    addPlashka(data.bookingCompanyId);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_kazunion_kz.ts":
/*!************************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_kazunion_kz.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_kazunion_kz__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/kazunion_kz */ "./src/serverScripts/operators/kazunion_kz.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};










function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookiesForTouroperator)(_operators_kazunion_kz__WEBPACK_IMPORTED_MODULE_0__.KazunionKz);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                active: true,
                url: 'https://uae.kazunion.com',
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            // await startTrackingElement(tab, 'form.log-in-form');
            // await executeKazunionLoginScriptInTabV3(
            //     tab,
            //     {
            //         login: data.login,
            //         password: data.password,
            //         packet: KazunionKz.packet
            //     }
            // );
            // await startTrackingElement(tab, 'form.log-in-form');
            //  await executeScriptInTab(tab, {
            //             code:  loginFormCode(new PageSelectors({
            //                 login: data.login,
            //                 password: data.password,
            //                 packet:  {
            //                     loginPath: "form.log-in-form input#username",
            //                     passwordPath: "form.log-in-form input#password",
            //                     submitPath: "form.log-in-form span.mdc-button__label"
            //                 }
            //             }))
            //         });
            const regExp1 = /\S+\.kazunion\.com\/log-in/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_6__.updateListenerOnSpecificPage)(tab.id, regExp1, (tabId, changeInfo, updatedTab) => {
                (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_7__.executeLoginScriptInTabV3)(tab, {
                    login: data.login,
                    password: data.password,
                    packet: _operators_kazunion_kz__WEBPACK_IMPORTED_MODULE_0__.KazunionKz.packet
                });
                return true;
            });
            var fillerParams = {
                tourists: data.autoFillerData.touristDataItems,
                customer: data.autoFillerData.customer,
                countryTo: data.countryTo,
                bookingCompanyId: data.bookingCompanyId
            };
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_6__.updateListenerOnSpecificPage)(tab.id, /uae\.kazunion\.com\/checkout/, (tabId, changeInfo, updatedTab) => {
                console.log('Дождались https://uae.kazunion.com/checkout');
                (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(updatedTab, 'form app-panel-box')
                    .then(() => {
                    console.log('Дождались form app-panel-box');
                    return (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_9__.wait)(1000 * 4);
                })
                    .then(() => {
                    console.log('Дождались 4сек');
                    (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__.executeScriptInTabV3)(updatedTab, claimFiller, [fillerParams]);
                });
                return true;
            });
        }
        catch (e) {
            console.log("фатальная ошибка");
            console.log(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_5__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    console.log('ClaimFiller Kazunion');
    debugger;
    console.log('Изо всех пытаюсь что-то заполнить!');
    if (!data || !data.tourists || data.tourists.length === 0) {
        console.log('Туристов неть');
        return;
    }
    let mainChain = Promise.resolve();
    let FieldType;
    (function (FieldType) {
        FieldType[FieldType["Text"] = 0] = "Text";
        FieldType[FieldType["Select"] = 1] = "Select";
        FieldType[FieldType["DatePicker"] = 2] = "DatePicker";
        FieldType[FieldType["Radio"] = 3] = "Radio";
        FieldType[FieldType["Sex"] = 4] = "Sex";
        FieldType[FieldType["Citizenship"] = 5] = "Citizenship";
    })(FieldType || (FieldType = {}));
    function setText(block, touristField) {
        mainChain = mainChain.then(() => {
            var input = block.querySelector(touristField.htmlElementSelector);
            if (input && touristField.value) {
                input.dispatchEvent(new Event('focus', { bubbles: true }));
                input.value = touristField.value;
                input.dispatchEvent(new Event('input', { bubbles: true }));
                input.dispatchEvent(new Event('keypress', { bubbles: true }));
                input.dispatchEvent(new Event('change', { bubbles: true }));
                input.dispatchEvent(new Event('blur', { bubbles: true }));
            }
        });
        mainChain = mainChain.then(() => localWait(touristField.delay || 100));
    }
    function localWait(timeout) {
        return new Promise((resolve) => {
            setTimeout(() => resolve(), timeout);
        });
    }
    function setSex(block, touristField) {
        mainChain = mainChain.then(() => {
            var _a;
            (_a = block.querySelector(touristField.htmlElementSelector)) === null || _a === void 0 ? void 0 : _a.click();
        });
        mainChain = mainChain.then(() => localWait(100));
        mainChain = mainChain.then(() => {
            var options = document.querySelectorAll('div.cdk-overlay-container div.overflow-y-auto div[aria-hidden=true]');
            if (options.length == 2) {
                switch (touristField.value) {
                    case 1:
                    case 3:
                    case 5:
                        options[0].click();
                        break;
                    case 2:
                    case 4:
                    case 6:
                        options[1].click();
                }
            }
        });
        mainChain = mainChain.then(() => localWait(100));
    }
    function setCitizenship(block, touristField) {
        mainChain = mainChain.then(() => {
            let field = block.querySelector(touristField.htmlElementSelector);
            if (field && field.parentNode) {
                field.parentNode.style.border = "10px solid red";
                field.parentNode.style.borderRadius = '20px';
                let div = document.createElement("div");
                div.style.textAlign = 'center';
                div.append(`--> ${touristField.value} <--`);
                field.parentNode.appendChild(div);
            }
        });
        mainChain = mainChain.then(() => localWait(100));
    }
    function doFill(data) {
        Array.prototype.forEach.call(data.tourists, (tourist, index) => {
            const touristFields = [
                {
                    htmlElementSelector: `select#isMale_${index}`,
                    value: tourist.touristType,
                    fieldType: FieldType.Sex,
                    delay: 500
                }, {
                    htmlElementSelector: `input#firstName_${index}`,
                    value: tourist.name,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#lastName_${index}`,
                    value: tourist.surname,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#birthDate_${index}`,
                    value: tourist.birthday ? tourist.birthday.split('.')[0] : '',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#birthDate_${index}_month`,
                    value: tourist.birthday ? tourist.birthday.split('.')[1] : '',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#birthDate_${index}_year`,
                    value: tourist.birthday ? tourist.birthday.split('.')[2] : '',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `label[for=citizenship_${index}]`,
                    value: tourist.citizenshipName,
                    fieldType: FieldType.Citizenship
                }, {
                    htmlElementSelector: `input#passportNumber_${index}`,
                    value: `${tourist.passportSeries} ${tourist.passportNumber}`,
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#passportIssue_${index}`,
                    value: tourist.passportDate ? tourist.passportDate.split('.')[0] : '',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#passportIssue_${index}_month`,
                    value: tourist.passportDate ? tourist.passportDate.split('.')[1] : '',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#passportIssue_${index}_year`,
                    value: tourist.passportDate ? tourist.passportDate.split('.')[2] : '',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#passportExpiry_${index}`,
                    value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[0] : '',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#passportExpiry_${index}_month`,
                    value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[1] : '',
                    fieldType: FieldType.Text
                }, {
                    htmlElementSelector: `input#passportExpiry_${index}_year`,
                    value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[2] : '',
                    fieldType: FieldType.Text
                },
            ];
            let block = document.querySelector('form');
            if (!block) {
                console.log('Ни одной формы на странице');
                return;
            }
            touristFields.forEach(touristItem => {
                switch (touristItem.fieldType) {
                    case FieldType.Text:
                        setText(block, touristItem);
                        break;
                    case FieldType.Sex:
                        setSex(block, touristItem);
                        break;
                    case FieldType.Citizenship:
                        setCitizenship(block, touristItem);
                        break;
                    default: break;
                }
            });
        });
    }
    doFill(data);
}


/***/ }),

/***/ "./src/serverScripts/formFill/formFill_kazunion_samo.ts":
/*!**************************************************************!*\
  !*** ./src/serverScripts/formFill/formFill_kazunion_samo.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formFill: () => (/* binding */ formFill)
/* harmony export */ });
/* harmony import */ var _operators_kazunion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/kazunion */ "./src/serverScripts/operators/kazunion.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/moveEvoucherDataToCustomer */ "./src/app/utils/chunks/moveEvoucherDataToCustomer.ts");
/* harmony import */ var _app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/updateListener */ "./src/app/utils/chunks/updateListener.ts");
/* harmony import */ var _app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../app/services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../app/utils/chunks/executeLoginScriptInTabV3 */ "./src/app/utils/chunks/executeLoginScriptInTabV3.ts");
/* harmony import */ var _app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../app/utils/chunks/removeSamoPassportBlur */ "./src/app/utils/chunks/removeSamoPassportBlur.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};












function formFill(context) {
    return __awaiter(this, void 0, void 0, function* () {
        const { data, claimNumber, tourUrl } = context;
        try {
            yield (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_9__.removeCookiesForTouroperator)(_operators_kazunion__WEBPACK_IMPORTED_MODULE_0__.Kazunion);
            let tab = yield (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__.createTab)({
                active: true,
                url: tourUrl,
                windowId: chrome.windows.WINDOW_ID_CURRENT
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_7__.startTrackingElement)(tab, 'div#loginbox');
            yield (0,_app_utils_chunks_executeLoginScriptInTabV3__WEBPACK_IMPORTED_MODULE_10__.executeLoginScriptInTabV3)(tab, {
                login: data.login,
                password: data.password,
                packet: _operators_kazunion__WEBPACK_IMPORTED_MODULE_0__.Kazunion.packet
            });
            data.autoFillerData.customer = (0,_app_utils_chunks_moveEvoucherDataToCustomer__WEBPACK_IMPORTED_MODULE_4__.moveEvoucherDataToCustomer)(data.autoFillerData.customer, data);
            const regExp = /online\.kazunion\.com\/cl_refer\?CLAIM=(\d+)/;
            (0,_app_utils_chunks_updateListener__WEBPACK_IMPORTED_MODULE_5__.updateListenerOnSpecificPage)(tab.id, regExp, (tabId, changeInfo, updatedTab) => {
                // @ts-ignore
                const parsedUrl = updatedTab.url.match(regExp);
                if (parsedUrl && parsedUrl.length >= 2) {
                    (0,_app_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__.sendIdsToBookingCenter)(claimNumber, parsedUrl[1])
                        .then(() => (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }));
                }
                (0,_app_utils_chunks_removeSamoPassportBlur__WEBPACK_IMPORTED_MODULE_11__.removeSamoPassportBlur)(updatedTab);
                return true;
            });
            yield (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_7__.startTrackingElement)(tab, 'div.tourists-tabs');
            var fillerParams = {
                tourists: data.autoFillerData.touristDataItems,
                customer: data.autoFillerData.customer,
                countryTo: data.countryTo,
                bookingCompanyId: data.bookingCompanyId
            };
            yield (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_3__.executeScriptInTabV3)(tab, claimFiller, [fillerParams]);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ claimId: claimNumber, operator: _operators_kazunion__WEBPACK_IMPORTED_MODULE_0__.Kazunion, errorText: null });
        }
        catch (e) {
            console.log("formFill фатальная ошибка Intourist");
            console.log(e);
            console.dir(e);
            yield (0,_app_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ status: _app_models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.FAIL, message: e.message });
        }
    });
}
function claimFiller(data) {
    var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
    // Иной документ - 0
    // Паспорт - 1
    // Свидетельство о рождении - 2
    // Заграничный паспорт - 3 
    // ID карта - 4
    // Дипломатический паспорт - 5
    // Служебный паспорт - 6
    function getTouristAge(tourist) {
        const [day, month, year] = tourist.birthday.split('.');
        const ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10) + 1, parseInt(day, 10)).getTime();
        const ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function getOptionIndexByName(text, optionsSelector) {
        const options = document.querySelectorAll(optionsSelector);
        for (var i = 0; i < options.length; i++) {
            var option = options[i];
            if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                return i;
            }
        }
        return 0;
    }
    function setDocumentType(index, tourist, countryTo) {
        let optionIndex = -1;
        var optionsSelector = `select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] option`;
        if (getTouristAge(tourist) < 14 && 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия'.toUpperCase().indexOf(countryTo.toUpperCase()) !== -1) {
            optionIndex = getOptionIndexByName('Birth certificate', optionsSelector);
            if (optionIndex === 0) {
                optionIndex = getOptionIndexByName('Свидетельство о рождении', optionsSelector);
            }
        }
        else {
            if (tourist.isNationalPassport) {
                optionIndex = getOptionIndexByName('Passport', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Паспорт', optionsSelector);
                }
            }
            else {
                optionIndex = getOptionIndexByName('Other ID', optionsSelector);
                if (optionIndex === 0) {
                    optionIndex = getOptionIndexByName('Иной документ', optionsSelector);
                }
            }
        }
        document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(touristField => {
            const element = block.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                console.log(touristField.value);
                element.value = touristField.value;
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
        });
    }
    ;
    function preparePhone(phone) {
        if (phone) {
            phone = phone.replace(/\D/g, '');
            if (phone && phone.startsWith('7')) {
                return '+' + phone;
            }
            if (phone && phone.startsWith('8')) {
                return '+7' + phone.substr(1, phone.length);
            }
        }
        return phone;
    }
    function toUpperCase(input) {
        if (!input || input === '') {
            return '';
        }
        return input.toUpperCase();
    }
    function setCitezenship(index, tourist) {
        debugger;
        const select = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"]`);
        let text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), (option) => {
            var _a, _b;
            if (((_a = tourist.citizenshipName) === null || _a === void 0 ? void 0 : _a.toUpperCase()) === ((_b = option.text) === null || _b === void 0 ? void 0 : _b.toUpperCase())) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var searchinp = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container input`);
        var dropdown = document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container`);
        searchinp.value = text;
        dropdown.dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][${index + 1}][NATIONALITY]"] ~ div.chosen-container li.highlighted`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    ;
    function fillSex(touristField) {
        let sexTypeIndex = 0;
        switch (touristField.value) {
            case 1:
            case 3:
            case 5:
                sexTypeIndex = 2;
                break;
            case 2:
            case 4:
            case 6:
                sexTypeIndex = 1;
                break;
        }
        document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`${touristField.htmlElementSelector} ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${sexTypeIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function setHuman(index, tourist) {
        // 0 - CHD
        // 1 - MR
        // 2 - MRS
        let humanDdItemIndex = 0;
        switch (tourist.touristType) {
            case 1:
                humanDdItemIndex = 1;
                break;
            case 2:
                humanDdItemIndex = 2;
                break;
            case 3:
                humanDdItemIndex = 0;
                break;
            case 4:
                humanDdItemIndex = 0;
                break;
            case 5:
                humanDdItemIndex = 0;
                break;
            case 6:
                humanDdItemIndex = 0;
                break;
        }
        document.querySelector(`select[name="frm[People][-${index + 1}][HUMAN]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[People][-${index + 1}][HUMAN]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${humanDdItemIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    ;
    function getCustomerOptionIndexByName(text) {
        const options = document.querySelectorAll(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] option`);
        for (var i = 0; i < options.length; i++) {
            var option = options[i];
            if (option && option.innerText && option.innerText.trim().toUpperCase() === text.toLocaleUpperCase()) {
                return i;
            }
        }
        return 0;
    }
    function setCustomerDocumentType(tourist, countryTo) {
        let optionIndex = getCustomerOptionIndexByName('паспорт'); // сказали пока проставляем просто Паспорт
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container`).dispatchEvent(new Event('mousedown'));
        document.querySelector(`select[name="frm[phys_byer][-1][IDENTITY_DOCUMENT]"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index="${optionIndex}"]`).dispatchEvent(new Event('mouseup', { bubbles: true }));
    }
    function fillCustomer(customer, countryTo) {
        if (!customer)
            return;
        var block = document.querySelector('div.CLAIMINFO.WITHBUYER');
        if (!block)
            return;
        const fields = [{
                htmlElementSelector: `input[name="frm[phys_byer][-1][LASTNAME_NAME]"]`,
                value: `${customer.surnameRus}`
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][FIRSTNAME_NAME]"]`,
                value: `${customer.nameRus}`
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PATRONYMIC_NAME]"]`,
                value: `${customer.middleNameRus}`
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][ADDRESS]"]`,
                value: customer.address
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][BORN]"]`,
                value: customer.birthday
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PSERIE]"]`,
                value: customer.passportSeries
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][PNUMBER]"]`,
                value: customer.passportNumber
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][MOBILE]"]`,
                value: customer.phone
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][EMAIL]"]`,
                value: customer.email
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCDATE]"]`,
                value: customer.eVoucherContractDate
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCNUMBER]"]`,
                value: customer.eVoucherClaimNumber
            }, {
                htmlElementSelector: `input[name="frm[phys_byer][-1][AGENCY_DOCSUM]"]`,
                value: customer.eVoucherCustomerPriceInPaymentCurrency
            }];
        setCustomerDocumentType(customer, countryTo);
        handleTouristFields(block, fields);
        // setSex(maleRadio, femaleRadio, tourist);
        // setCitezenship(index, tourist);
    }
    fillCustomer(data.customer, data.countryTo);
    Array.prototype.forEach.call(touristBlocks, (block, index) => {
        const tourist = data.tourists[index];
        if (!tourist) {
            return;
        }
        setDocumentType(index, tourist, data.countryTo);
        const touristFields = [{
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_LNAME]"]`,
                value: toUpperCase(tourist.surnameEng)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTLNAME]"]`,
                value: toUpperCase(tourist.surname)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_LNAME]"]`,
                value: toUpperCase(tourist.nameEng)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTLNAME]"]`,
                value: toUpperCase(tourist.name)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME_NAME]"]`,
                value: toUpperCase(tourist.nameRus)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME]"]`,
                value: toUpperCase(tourist.surname)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][LASTNAME_NAME]"]`,
                value: toUpperCase(tourist.surnameRus)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PATRONYMIC_NAME]"]`,
                value: toUpperCase(tourist.middleNameRus)
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][FIRSTNAME]"]`,
                value: `${toUpperCase(tourist.name)} ${toUpperCase(tourist.middlename)}`
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][BORN]"]`,
                value: tourist.birthday
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][MOBILE]"]`,
                value: preparePhone(tourist.phone) || '+79587764656'
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][EMAIL]"]`,
                value: tourist.email || 'ocb@corp.sletat.ru'
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PSERIE]"]`,
                value: tourist.passportSeries
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PNUMBER]"]`,
                value: `${tourist.passportSeries} ${tourist.passportNumber}`
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PVALID]"]`,
                value: tourist.passportExpireDate
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVEN]"]`,
                value: tourist.passportDate
            }, {
                htmlElementSelector: `input[name="frm[People][${index + 1}][PGIVENORG]"]`,
                value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
            }];
        handleTouristFields(block, touristFields);
        fillSex({
            htmlElementSelector: `select[name="frm[People][${index + 1}][MALE]"]`,
            value: tourist.touristType
        });
        setCitezenship(index, tourist);
        //setHuman(index, tourist);
        console.log(index);
    });
    function addPlashka(cbCompanyId) {
        const getBookingCompanyByCBGuid = (guid) => {
            const guidBookingCompany = {
                '62b8b7e0-c368-4ec0-8fc6-cee8bbcbbe41': { name: 'ООО «АРИЛЬД»', color: '#00875a' },
                '4016198a-5249-43b7-b3a0-a4cf53b96cd4': { name: 'ООО «ОЦБ»', color: '#ff8b00' },
                'a284bfd4-08e5-4f7d-a11c-f745c3c8bdc5': { name: 'ООО «ОЦБ K»', color: '#ff8b00' },
                'a0c2a815-daec-47f1-a558-c921f13482cc': { name: 'ООО «ГорТревел»', color: '#0747a6' },
                '96c57522-c7b9-43fb-ab7a-15f98d3972d4': { name: 'ООО «Все Туры»', color: '#de350b' },
                'eee2cd51-5bb0-495b-9067-ec30adfece47': { name: 'ООО «ГорТревел В»', color: '#403294' },
                'd85b47f8-d524-4f85-9dd6-70100983fb49': { name: 'ООО «МСУ Тех»', color: '#66FF00' },
                '387d946b-82e6-4a9d-bd02-1ebde5ebcd0a': { name: 'ИП Абрамов Денис Дмитриевич', color: '#ffab00' },
                '7784c883-fad4-4402-ba0a-07fda56f5edb': { name: 'ООО СолнцеТур', color: '#505f79' }
            };
            return guidBookingCompany[guid] || { name: 'ООО НЕИЗВЕСТНО', color: 'pink' };
        };
        var urLico = getBookingCompanyByCBGuid(cbCompanyId);
        const divToAddParent = document.createElement('div');
        divToAddParent.id = 'urlicocbParent';
        divToAddParent.setAttribute('style', `
            width: 532px;
            height: 50px;
            position: relative;
            border: 10px solid 