/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/app/chunks/createTabAndDeleteCookies.ts":
/*!*****************************************************!*\
  !*** ./src/app/chunks/createTabAndDeleteCookies.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTabAndDeleteCookies: () => (/* binding */ createTabAndDeleteCookies)
/* harmony export */ });
/* harmony import */ var _handleNavigateUrl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./handleNavigateUrl */ "./src/app/chunks/handleNavigateUrl.ts");
/* harmony import */ var _models_chunks_authTypes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../models/chunks/authTypes */ "./src/app/models/chunks/authTypes.ts");
/* harmony import */ var _utils_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/url */ "./src/app/utils/url.ts");
/* harmony import */ var _utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _utils_chunks_checkCookie__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/checkCookie */ "./src/app/utils/chunks/checkCookie.ts");






var createTabAndDeleteCookies = function (operator, tourUrl, Creditans) { return new Promise(function (resolve, reject) {
    var navigateUrl = tourUrl = (0,_handleNavigateUrl__WEBPACK_IMPORTED_MODULE_0__.handleNavigateUrl)(tourUrl, operator);
    operator.credentials.login = Creditans.login;
    operator.credentials.password = Creditans.password;
    switch (operator.authType) {
        case _models_chunks_authTypes__WEBPACK_IMPORTED_MODULE_1__.AuthTypes.BASIC:
            navigateUrl = (0,_utils_url__WEBPACK_IMPORTED_MODULE_2__.insertUrlCreds)(tourUrl, {
                username: operator.credentials.login,
                password: operator.credentials.password
            });
            break;
        case _models_chunks_authTypes__WEBPACK_IMPORTED_MODULE_1__.AuthTypes.FORMS:
            break;
    }
    var promise;
    if (operator.cookie.userInfo) {
        promise = (0,_utils_chunks_checkCookie__WEBPACK_IMPORTED_MODULE_5__.checkCookie)({
            url: navigateUrl,
            cookieName: operator.cookie.userInfo,
            searchValue: operator.credentials.login
        });
    }
    else {
        promise = Promise.reject('');
    }
    return promise.then(function () { return console.log('Уже авторизованы под нужным пользователем.'); }, function () { return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__.removeCookies)({
        url: navigateUrl,
        cookieNames: operator.cookie.auth
    }); }).then(function () { return (0,_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({
        active: true,
        url: navigateUrl,
        windowId: chrome.windows.WINDOW_ID_CURRENT
    }).then(function (tab) { return resolve({ tab: tab, navigate_url: navigateUrl }); }); });
}); };


/***/ }),

/***/ "./src/app/chunks/handleNavigateUrl.ts":
/*!*********************************************!*\
  !*** ./src/app/chunks/handleNavigateUrl.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleNavigateUrl: () => (/* binding */ handleNavigateUrl)
/* harmony export */ });
var handleNavigateUrl = function (url, operator) {
    if (operator.token && operator.token.length > 0) {
        return url + operator.token;
    }
    return url;
};


/***/ }),

/***/ "./src/app/messages/chunks/createGetIdsMessage.ts":
/*!********************************************************!*\
  !*** ./src/app/messages/chunks/createGetIdsMessage.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createGetIdsMessage: () => (/* binding */ createGetIdsMessage)
/* harmony export */ });
/* harmony import */ var _messageConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../messageConstants */ "./src/app/messages/messageConstants.ts");

function createGetIdsMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_IDS_MESSAGE,
        payload: payload
    };
}


/***/ }),

/***/ "./src/app/messages/chunks/pageSelectors.ts":
/*!**************************************************!*\
  !*** ./src/app/messages/chunks/pageSelectors.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PageSelectors: () => (/* binding */ PageSelectors)
/* harmony export */ });
var PageSelectors = /** @class */ (function () {
    function PageSelectors(params) {
        var _this = this;
        Object.keys(params).forEach(function (key) {
            _this[key] = params[key];
        });
    }
    return PageSelectors;
}());



/***/ }),

/***/ "./src/app/messages/index.ts":
/*!***********************************!*\
  !*** ./src/app/messages/index.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createErrorMessage: () => (/* binding */ createErrorMessage),
/* harmony export */   createGetClaimButtonMessage: () => (/* binding */ createGetClaimButtonMessage),
/* harmony export */   createGetDocumentReadyStateMessage: () => (/* binding */ createGetDocumentReadyStateMessage),
/* harmony export */   createGetElementMessage: () => (/* binding */ createGetElementMessage),
/* harmony export */   createGetPageLoginFormMessage: () => (/* binding */ createGetPageLoginFormMessage),
/* harmony export */   createGetPageSearchFormMessage: () => (/* binding */ createGetPageSearchFormMessage),
/* harmony export */   createGetTouristLinksMessage: () => (/* binding */ createGetTouristLinksMessage),
/* harmony export */   createStateMessage: () => (/* binding */ createStateMessage),
/* harmony export */   createTabMessage: () => (/* binding */ createTabMessage)
/* harmony export */ });
/* harmony import */ var _messageConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./messageConstants */ "./src/app/messages/messageConstants.ts");

function createTabMessage() {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_PAGE_STATUS,
        payload: null
    };
}
function createStateMessage(isClaimPage, claimNumber, sourceId, secretField, claimId, senderElementId, paymentOperationId, additionalInfo) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.STATE_MESSAGE,
        payload: {
            isClaimPage: isClaimPage,
            claimId: claimId,
            claimNumber: claimNumber,
            sourceId: sourceId,
            secretField: secretField,
            senderElementId: senderElementId,
            paymentOperationId: paymentOperationId,
            additionalInfo: additionalInfo,
        }
    };
}
function createGetDocumentReadyStateMessage() {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_DOCUMENT_STATE
    };
}
function createGetElementMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_ELEMENT_MESSAGE,
        payload: payload
    };
}
function createGetTouristLinksMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_TOURIST_LINKS,
        payload: payload
    };
}
function createGetPageSearchFormMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_PAGE_SEARCH_FORM,
        payload: payload
    };
}
function createGetPageLoginFormMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_PAGE_LOGIN_FORM,
        payload: payload
    };
}
function createGetClaimButtonMessage(payload) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.GET_CLAIM_BUTTON,
        payload: payload
    };
}
function createErrorMessage(error) {
    return {
        type: _messageConstants__WEBPACK_IMPORTED_MODULE_0__.ERROR_MESSAGE,
        error: error,
        payload: null
    };
}


/***/ }),

/***/ "./src/app/messages/messageConstants.ts":
/*!**********************************************!*\
  !*** ./src/app/messages/messageConstants.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ERROR_MESSAGE: () => (/* binding */ ERROR_MESSAGE),
/* harmony export */   GET_CLAIM_BUTTON: () => (/* binding */ GET_CLAIM_BUTTON),
/* harmony export */   GET_DOCUMENT_STATE: () => (/* binding */ GET_DOCUMENT_STATE),
/* harmony export */   GET_ELEMENT_MESSAGE: () => (/* binding */ GET_ELEMENT_MESSAGE),
/* harmony export */   GET_IDS_MESSAGE: () => (/* binding */ GET_IDS_MESSAGE),
/* harmony export */   GET_IDS_MESSAGE_AND_STATUS: () => (/* binding */ GET_IDS_MESSAGE_AND_STATUS),
/* harmony export */   GET_PAGE_LOGIN_FORM: () => (/* binding */ GET_PAGE_LOGIN_FORM),
/* harmony export */   GET_PAGE_SEARCH_FORM: () => (/* binding */ GET_PAGE_SEARCH_FORM),
/* harmony export */   GET_PAGE_STATUS: () => (/* binding */ GET_PAGE_STATUS),
/* harmony export */   GET_TOURIST_LINKS: () => (/* binding */ GET_TOURIST_LINKS),
/* harmony export */   STATE_MESSAGE: () => (/* binding */ STATE_MESSAGE)
/* harmony export */ });
var STATE_MESSAGE = 'STATE MESSAGE';
var ERROR_MESSAGE = 'ERROR MESSAGE';
var GET_PAGE_STATUS = 'GET PAGE STATUS';
var GET_IDS_MESSAGE = 'GET IDS';
var GET_DOCUMENT_STATE = 'GET DOCUMENT STATE';
var GET_ELEMENT_MESSAGE = 'GET ELEMENT';
var GET_TOURIST_LINKS = 'GET TOURIST LINKS';
var GET_PAGE_LOGIN_FORM = 'GET PAGE LOGIN FORM';
var GET_PAGE_SEARCH_FORM = 'GET PAGE SEARCH FORM';
var GET_CLAIM_BUTTON = 'GET CLAIM BUTTON';
var GET_IDS_MESSAGE_AND_STATUS = 'GET IDS MESSAGE AND STATUS';


/***/ }),

/***/ "./src/app/models/chunks/authTypes.ts":
/*!********************************************!*\
  !*** ./src/app/models/chunks/authTypes.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthTypes: () => (/* binding */ AuthTypes)
/* harmony export */ });
var AuthTypes;
(function (AuthTypes) {
    AuthTypes["BASIC"] = "basic";
    AuthTypes["FORMS"] = "forms";
})(AuthTypes || (AuthTypes = {}));


/***/ }),

/***/ "./src/app/models/chunks/bookingCompany.ts":
/*!*************************************************!*\
  !*** ./src/app/models/chunks/bookingCompany.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BookingCompany: () => (/* binding */ BookingCompany)
/* harmony export */ });
var BookingCompany;
(function (BookingCompany) {
    BookingCompany[BookingCompany["VseTyri"] = 0] = "VseTyri";
    BookingCompany[BookingCompany["SletatRu"] = 1] = "SletatRu";
    BookingCompany[BookingCompany["Antares"] = 2] = "Antares";
    BookingCompany[BookingCompany["OCB"] = 3] = "OCB";
    BookingCompany[BookingCompany["GorTravel"] = 4] = "GorTravel";
    BookingCompany[BookingCompany["Aryld"] = 5] = "Aryld";
    BookingCompany[BookingCompany["LetaemZnaem"] = 6] = "LetaemZnaem";
    BookingCompany[BookingCompany["Undefined"] = 7] = "Undefined";
})(BookingCompany || (BookingCompany = {}));


/***/ }),

/***/ "./src/app/models/chunks/createFillFnMessage.ts":
/*!******************************************************!*\
  !*** ./src/app/models/chunks/createFillFnMessage.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createFillFnMessage: () => (/* binding */ createFillFnMessage)
/* harmony export */ });
/* harmony import */ var _notificationBody__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./notificationBody */ "./src/app/models/chunks/notificationBody.ts");

function createFillFnMessage(_a) {
    var claimId = _a.claimId, operator = _a.operator, errorText = _a.errorText;
    return {
        title: errorText === null
            ? _notificationBody__WEBPACK_IMPORTED_MODULE_0__.FillFnMessageTexts.DONE
            : _notificationBody__WEBPACK_IMPORTED_MODULE_0__.FillFnMessageTexts.FAIL,
        body: {
            claimId: claimId,
            operator: operator,
            errorText: errorText
        },
        toString: function () {
            return this.body.errorText
                ? "\n                    \u041E\u0448\u0438\u0431\u043A\u0430: ".concat(this.body.errorText, "\n\n                    T\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440: ").concat(this.body.operator.title, ", \u0417\u0430\u044F\u0432\u043A\u0430 \u2116").concat(this.body.claimId)
                : "T\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440: ".concat(this.body.operator.title, ", \u0417\u0430\u044F\u0432\u043A\u0430 \u2116").concat(this.body.claimId);
        }
    };
}


/***/ }),

/***/ "./src/app/models/chunks/createSendIdsMessage.ts":
/*!*******************************************************!*\
  !*** ./src/app/models/chunks/createSendIdsMessage.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSendIdsMessage: () => (/* binding */ createSendIdsMessage)
/* harmony export */ });
/* harmony import */ var _notificationBody__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./notificationBody */ "./src/app/models/chunks/notificationBody.ts");

function createSendIdsMessage(_a) {
    var status = _a.status, message = _a.message;
    return {
        title: status === _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatus.DONE
            ? _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatusTexts.DONE
            : _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatusTexts.FAIL,
        body: {
            status: status,
            message: message
        },
        toString: function () {
            return this.body.status === _notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatus.FAIL
                ? "\u041E\u0448\u0438\u0431\u043A\u0430 \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0438: ".concat(this.body.message)
                : "\u0423\u0441\u043F\u0435\u0448\u043D\u0430\u044F \u043E\u0442\u043F\u0440\u0430\u0432\u043A\u0430: ".concat(this.body.message);
        }
    };
}


/***/ }),

/***/ "./src/app/models/chunks/notificationBody.ts":
/*!***************************************************!*\
  !*** ./src/app/models/chunks/notificationBody.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FillFnMessageTexts: () => (/* binding */ FillFnMessageTexts),
/* harmony export */   SendIdsStatus: () => (/* binding */ SendIdsStatus),
/* harmony export */   SendIdsStatusTexts: () => (/* binding */ SendIdsStatusTexts)
/* harmony export */ });
var SendIdsStatus;
(function (SendIdsStatus) {
    SendIdsStatus["DONE"] = "DONE";
    SendIdsStatus["FAIL"] = "FAIL";
})(SendIdsStatus || (SendIdsStatus = {}));
var SendIdsStatusTexts;
(function (SendIdsStatusTexts) {
    SendIdsStatusTexts["DONE"] = "\u0418\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u044B \u0443\u0441\u043F\u0435\u0448\u043D\u043E \u043F\u0435\u0440\u0435\u0434\u0430\u043D\u044B \u043D\u0430 \u0441\u0435\u0440\u0432\u0435\u0440!";
    SendIdsStatusTexts["FAIL"] = "\u041F\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0438\u0434\u0435\u043D\u0442\u0438\u0444\u0438\u043A\u0430\u0442\u043E\u0440\u043E\u0432 \u043D\u0435 \u0443\u0434\u0430\u043B\u0430\u0441\u044C";
})(SendIdsStatusTexts || (SendIdsStatusTexts = {}));
var FillFnMessageTexts;
(function (FillFnMessageTexts) {
    FillFnMessageTexts["DONE"] = "\u0417\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u0435 \u0432\u044B\u043F\u043E\u043B\u043D\u0435\u043D\u043E \u0443\u0441\u043F\u0435\u0448\u043D\u043E!";
    FillFnMessageTexts["FAIL"] = "\u0417\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u0435 \u043D\u0435 \u0432\u044B\u043F\u043E\u043B\u043D\u0435\u043D\u043E";
})(FillFnMessageTexts || (FillFnMessageTexts = {}));


/***/ }),

/***/ "./src/app/models/errors.ts":
/*!**********************************!*\
  !*** ./src/app/models/errors.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RequestError: () => (/* binding */ RequestError)
/* harmony export */ });
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RequestError = /** @class */ (function (_super) {
    __extends(RequestError, _super);
    function RequestError(reason) {
        var _this = _super.call(this, reason) || this;
        _this.name = 'RequestError';
        _this.message = 'Ошибка запроса';
        _this.message = "".concat(_this.message, ": ").concat(reason);
        return _this;
    }
    return RequestError;
}(Error));



/***/ }),

/***/ "./src/app/models/index.ts":
/*!*********************************!*\
  !*** ./src/app/models/index.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ClaimConfirmationStatus: () => (/* binding */ ClaimConfirmationStatus),
/* harmony export */   EmptyScript: () => (/* binding */ EmptyScript),
/* harmony export */   ErrorTypes: () => (/* binding */ ErrorTypes),
/* harmony export */   MessageTypes: () => (/* binding */ MessageTypes),
/* harmony export */   PageStatuses: () => (/* binding */ PageStatuses),
/* harmony export */   RequestError: () => (/* reexport safe */ _errors__WEBPACK_IMPORTED_MODULE_0__.RequestError),
/* harmony export */   ScriptType: () => (/* binding */ ScriptType),
/* harmony export */   SenderTypes: () => (/* binding */ SenderTypes)
/* harmony export */ });
/* harmony import */ var _errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./errors */ "./src/app/models/errors.ts");

var ScriptType;
(function (ScriptType) {
    ScriptType[ScriptType["Login"] = 0] = "Login";
    ScriptType[ScriptType["FormFill"] = 1] = "FormFill";
    ScriptType[ScriptType["VisaFill"] = 2] = "VisaFill";
    ScriptType[ScriptType["NavToBookedClaim"] = 3] = "NavToBookedClaim";
})(ScriptType || (ScriptType = {}));
var EmptyScript = {
    scriptId: '',
    tourOperatorId: '',
    sletatId: 0,
    body: '',
    createDateUtc: '',
    type: ScriptType.Login,
    isActive: false,
    version: '',
};
var ClaimConfirmationStatus;
(function (ClaimConfirmationStatus) {
    ClaimConfirmationStatus[ClaimConfirmationStatus["NOT_CONFIRMED"] = 1] = "NOT_CONFIRMED";
    ClaimConfirmationStatus[ClaimConfirmationStatus["WAITING"] = 2] = "WAITING";
    ClaimConfirmationStatus[ClaimConfirmationStatus["CONFIRMED"] = 3] = "CONFIRMED";
})(ClaimConfirmationStatus || (ClaimConfirmationStatus = {}));
var ErrorTypes;
(function (ErrorTypes) {
    ErrorTypes["NO_CLAIM_PAGE"] = "\u0412\u044B \u043D\u0435 \u043D\u0430\u0445\u043E\u0434\u0438\u0442\u0435\u0441\u044C \u043D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0435 \u0437\u0430\u044F\u0432\u043A\u0438";
    ErrorTypes["NO_VISA_NEEDED"] = "\u041E\u0444\u043E\u0440\u043C\u043B\u0435\u043D\u0438\u0435 \u0432\u0438\u0437\u044B \u0434\u043B\u044F \u0434\u0430\u043D\u043D\u043E\u0439 \u0437\u0430\u044F\u0432\u043A\u0438 \u043D\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044F";
    ErrorTypes["NO_TO_ID"] = "\u041F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u0435\u043D. \u041D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0435 \u0426\u0411 \u043D\u0435 \u0443\u043A\u0430\u0437\u0430\u043D id \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430, \u043F\u043E\u043F\u0440\u043E\u0431\u0443\u0439\u0442\u0435 \u043F\u043E\u0437\u0436\u0435.";
    ErrorTypes["NO_CLAIM_ID"] = "\u041F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u0435\u043D. \u041D\u0435 \u043F\u0440\u043E\u0441\u0442\u0430\u0432\u043B\u0435\u043D \u043D\u043E\u043C\u0435\u0440 \u0437\u0430\u044F\u0432\u043A\u0438 \u0442\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430.";
    ErrorTypes["TO_NOT_SUPPORTED"] = "\u0423\u0432\u044B, \u0424\u0438\u043B\u044F \u043F\u043E\u043A\u0430 \u0447\u0442\u043E \u043D\u0435 \u043F\u043E\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u0434\u0430\u043D\u043D\u043E\u0433\u043E \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 :(";
    ErrorTypes["TO_RESTRICTED"] = "\u0414\u0430\u043D\u043D\u044B\u0439 \u0442\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440 \u043D\u0435 \u043F\u0440\u0435\u0434\u043E\u0441\u0442\u0430\u0432\u043B\u044F\u0435\u0442 \u043F\u0440\u044F\u043C\u0443\u044E \u0441\u0441\u044B\u043B\u043A\u0443 \u043D\u0430 \u0442\u0443\u0440, \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0438\u0435 \u0432\u043E\u0437\u043C\u043E\u0436\u043D\u043E \u0442\u043E\u043B\u044C\u043A\u043E \u0432\u0440\u0443\u0447\u043D\u0443\u044E";
    ErrorTypes["CLAIM_ALREADY_BOOKED"] = "\u0414\u0430\u043D\u043D\u0430\u044F \u0437\u0430\u044F\u0432\u043A\u0430 \u0443\u0436\u0435 \u0431\u044B\u043B\u0430 \u0437\u0430\u043F\u043E\u043B\u043D\u0435\u043D\u0430 \u0438 \u0437\u0430\u0431\u0440\u043E\u043D\u0438\u0440\u043E\u0432\u0430\u043D\u0430 \u043D\u0430 \u0441\u0430\u0439\u0442\u0435 \u0442\u0443\u0440\u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430. \u0427\u0442\u043E\u0431\u044B \u043F\u0440\u043E\u0441\u043C\u043E\u0442\u0440\u0435\u0442\u044C \u0435\u0435, \u0432\u043E\u0441\u043F\u043E\u043B\u044C\u0437\u0443\u0439\u0442\u0435\u0441\u044C \u043A\u043D\u043E\u043F\u043A\u043E\u0439 \"\u041B\u0443\u043F\u0430\"";
    ErrorTypes["UNKNOWN"] = "\u041F\u0435\u0440\u0435\u0445\u043E\u0434 \u0432 \u041B\u041A \u043E\u043F\u0435\u0440\u0430\u0442\u043E\u0440\u0430 \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u0435\u043D. \u041D\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043D\u0430\u044F \u043E\u0448\u0438\u0431\u043A\u0430.";
})(ErrorTypes || (ErrorTypes = {}));
var MessageTypes;
(function (MessageTypes) {
    MessageTypes["GET_PAGE_STATUS"] = "GET PAGE STATUS";
    MessageTypes["PASS_TO_CREDS"] = "PASS TO CREDS";
    MessageTypes["ERROR"] = "ERROR";
    MessageTypes["GET_IDS"] = "GET IDS";
    MessageTypes["GET_ELEMENT"] = "GET ELEMENT";
    MessageTypes["GET_TOURIST_LINKS"] = "GET TOURIST LINKS";
    MessageTypes["GET_PAGE_LOGIN_FORM"] = "GET PAGE LOGIN FORM";
    MessageTypes["GET_PAGE_SEARCH_FORM"] = "GET PAGE SEARCH FORM";
    MessageTypes["GET_CLAIM_BUTTON"] = "GET CLAIM BUTTON";
    MessageTypes["GET_DOCUMENT_STATE"] = "GET DOCUMENT STATE";
    MessageTypes["GET_IDS_MESSAGE_AND_STATUS"] = "GET IDS MESSAGE AND STATUS";
})(MessageTypes || (MessageTypes = {}));
var PageStatuses;
(function (PageStatuses) {
    PageStatuses["IS_CLAIM_PAGE"] = "IS_CLAIM_PAGE";
    PageStatuses["IS_OPERATOR_SUPPORTED"] = "IS_OPERATOR_SUPPORTED";
})(PageStatuses || (PageStatuses = {}));
var SenderTypes;
(function (SenderTypes) {
    SenderTypes[SenderTypes["TAB_SENDER"] = 0] = "TAB_SENDER";
    SenderTypes[SenderTypes["EXT_SENDER"] = 1] = "EXT_SENDER";
})(SenderTypes || (SenderTypes = {}));


/***/ }),

/***/ "./src/app/operatorScripts/171.ts":
/*!****************************************!*\
  !*** ./src/app/operatorScripts/171.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaForms: () => (/* binding */ fillVisaForms),
/* harmony export */   navigateToClaimForm: () => (/* binding */ navigateToClaimForm)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/chunks/reloadTab */ "./src/app/utils/chunks/reloadTab.ts");
/* harmony import */ var _services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _utils_chunks_startTrackingElementByProp__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementByProp */ "./src/app/utils/chunks/startTrackingElementByProp.ts");











function navigateToClaimForm(context) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[context.sourceId];
    var tab = context.tab;
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '#ctl00_generalContent_BasketTourists_touristData_dgTourists'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(claimFiller, context.data.touristDataItems) }); })
        .then(function () {
        var t = function () {
            return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '#ctl00_generalContent_UpdateProgress2[style*="display: block;"]')
                .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElementDisappear)(tab, '#ctl00_generalContent_UpdateProgress2[style*="display: block;"]'); })
                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(claimFiller, context.data.touristDataItems) }); })
                .then(function () { return t(); });
        };
        t();
    })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: context.claimNumber, operator: operator, errorText: null }); })
        .then(function () { return (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__.startTrackingIdSelector)(tab, 'body table.int tr:nth-child(3) td:nth-child(2)'); })
        .then(function (response) { return (0,_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_9__.sendIdsToBookingCenter)(context.claimNumber, response.claimNo); })
        .then(function (response) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
        .then(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_8__.reloadTab)(context.sourceTab); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
        .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.FAIL, message: error.message }); });
}
function claimFiller(data) {
    console.log(data);
    window.scrollTo(0, document.body.scrollHeight);
    var touristBlocks = document.querySelectorAll('#ctl00_generalContent_BasketTourists_touristData_dgTourists tr:not(.h1)');
    function setSexSelect(select, tourist) {
        switch (tourist.touristType) {
            case 1:
                select.options[1].selected = true;
                break;
            case 3:
            case 5:
                select.options[3].selected = true;
                break;
            case 2:
                select.options[2].selected = true;
                break;
            case 4:
            case 6:
                select.options[4].selected = true;
                break;
        }
    }
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(function (touristItem) {
            var element = block.querySelector(touristItem.htmlElementSelector);
            if (element) {
                element.value = touristItem.value;
            }
        });
    }
    Array.prototype.forEach.call(touristBlocks, function (block, index) {
        var tourist = data[index];
        var fieldIndex = index + 2;
        var dateFormat = 'DD.MM.YYYY';
        var defaultDate = '01.01.1900';
        if (!tourist) {
            return;
        }
        var fields = [{
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_txtLastName"),
                value: tourist.surname
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_txtFirstName"),
                value: tourist.name
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_sdtBirthDate_txtDay"),
                value: tourist.birthday ? tourist.birthday.split('.')[0] : ''
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_sdtBirthDate_txtMonth"),
                value: tourist.birthday ? tourist.birthday.split('.')[1] : ''
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_sdtBirthDate_txtYear"),
                value: tourist.birthday ? tourist.birthday.split('.')[2] : ''
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_pPassport_txtPassportSeries"),
                value: tourist.passportSeries
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_pPassport_txtPassportNumber"),
                value: tourist.passportNumber
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_sdtPassportDate_txtDay"),
                value: tourist.passportDate ? tourist.passportDate.split('.')[0] : ''
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_sdtPassportDate_txtMonth"),
                value: tourist.passportDate ? tourist.passportDate.split('.')[1] : ''
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_sdtPassportDate_txtYear"),
                value: tourist.passportDate ? tourist.passportDate.split('.')[2] : ''
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_sdtPassportDateEnd_txtDay"),
                value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[0] : ''
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_sdtPassportDateEnd_txtMonth"),
                value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[1] : ''
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_sdtPassportDateEnd_txtYear"),
                value: tourist.passportExpireDate ? tourist.passportExpireDate.split('.')[2] : ''
            }, {
                htmlElementSelector: "#ctl00_generalContent_BasketTourists_touristData_dgTourists_ctl0".concat(fieldIndex, "_txtPhone"),
                value: tourist.phone
            }];
        var sexSelect = block.querySelector("select[name=\"ctl00$generalContent$BasketTourists$touristData$dgTourists$ctl0".concat(fieldIndex, "$ddlSex\"]"));
        handleTouristFields(fields, block);
        setSexSelect(sexSelect, tourist);
    });
}
/*visafill*/
function fillVisaForms(tab, data, claimNumber, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '#ctl00_generalContent_visaformlist')
        .then(function () { return visaFillChain(tab, data.touristDataItems); });
}
var visaFillChain = function (tab, tourists) { return new Promise(function (resolve) { return Promise.all(tourists.map(function (tourist, index) { return new Promise(function (resolve) {
    return openVisaFillForm(tab)
        .then(function (ntab) {
        return selectTourist(ntab, index)
            .then(function () { return (0,_utils_chunks_startTrackingElementByProp__WEBPACK_IMPORTED_MODULE_10__.startTrackingElementByProp)(ntab, '#ctl00_generalContent_VisaFormEditor_tblForm_ctl03_fieldEditor_cmbFieldValue_txtValue', 'value', function (prop) { return prop && prop.trim().toLowerCase() === tourist.surnameEng.trim().toLowerCase(); }); })
            .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(ntab, '#ctl00_generalContent_UpdatePanel1'); })
            .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(ntab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(fillVisaForm, { tourist: tourist }) }); })
            .then(function () { return resolve({}); });
    });
}); })).then(function () { return resolve({}); }); }); };
var resolvedIds = [];
var openVisaFillForm = function (tab) { return new Promise(function (resolve, reject) {
    var openVisaFillFormInternal = "document.querySelector('input[name^=\"ctl00$generalContent$ct\"]').click()";
    var listener = function (tab) {
        if (resolvedIds.indexOf(tab.id) === -1) {
            chrome.tabs.onCreated.removeListener(listener);
            resolvedIds.push(tab.id);
            resolve(tab);
        }
    };
    chrome.tabs.onCreated.addListener(listener);
    chrome.tabs.executeScript(tab.id, { code: openVisaFillFormInternal });
}); };
var selectTourist = function (tab, index) { return new Promise(function (resolve) {
    var selectTouristInternal = function (index) { return "\n        function selectTouristInternal_f () {\n            var sel = document.querySelector('select[name=\"ctl00$generalContent$ddlTourists\"]');\n            sel.selectedIndex = ".concat(index, ";\n            sel.dispatchEvent(new Event('change'));\n        }\n        selectTouristInternal_f()\n    "); };
    (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: selectTouristInternal(index) })
        .then(function () { return resolve(0); });
}); };
var fillVisaForm = function (data) {
    if (!data.tourist) {
        return;
    }
    var visa = data.tourist.visaForm;
    if (!visa) {
        return;
    }
    var block = document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm');
    if (!block) {
        return;
    }
    var concatFullAddress = function (visa) {
        var addr = '';
        if (visa.city && visa.city !== 'NO') {
            addr += "".concat(visa.city, " ");
        }
        if (visa.street && visa.street !== 'NO') {
            addr += "".concat(visa.street, " ");
        }
        if (visa.building && visa.building !== 'NO') {
            addr += "".concat(visa.building, " ");
        }
        if (visa.block && visa.block !== 'NO') {
            addr += "".concat(visa.block, " ");
        }
        if (visa.appartment && visa.appartment !== 'NO') {
            addr += "".concat(visa.appartment, " ");
        }
        return addr;
    };
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = (touristField.value ? touristField.value : '');
            }
        });
    };
    var setMaritalStatus = function (select, visa) {
        if (!select) {
            return;
        }
        switch (visa.maritalStatus) {
            case 1:
                select.selectedIndex = 1;
                break;
            case 2:
                select.selectedIndex = 2;
                break;
            case 3:
                select.selectedIndex = 4;
                break;
            case 4:
                select.selectedIndex = 5;
                break;
        }
        select.dispatchEvent(new Event('change'));
    };
    var setVisaType = function (select, visa) {
        if (!select) {
            return;
        }
        select.selectedIndex = visa.visaRepeatedType === 'Однократная'
            ? 1 : 3;
        select.dispatchEvent(new Event('change'));
    };
    var setHavePreviousVisas = function (select, visa) {
        if (!select) {
            return;
        }
        select.selectedIndex = visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
            ? 2 : 1;
        select.dispatchEvent(new Event('change'));
    };
    var setPreviousVisa = function (fromInput, toInput, index) {
        if (!fromInput || !toInput) {
            return;
        }
        if (!visa.previosVisasInfoList || visa.previosVisasInfoList.length <= index || index < 0) {
            return;
        }
        var pvisa = visa.previosVisasInfoList[index];
        if (!pvisa) {
            return;
        }
        var countryCodes = [
            {
                key: 'греция',
                code: 'GRC'
            }, {
                key: 'франция',
                code: 'FRA'
            }, {
                key: 'австрия',
                code: 'AUT'
            }, {
                key: 'монако',
                code: 'MCO'
            }, {
                key: 'исландия',
                code: 'ISL'
            }, {
                key: 'андорра',
                code: 'AND'
            }, {
                key: 'норвегия',
                code: 'NOW'
            }, {
                key: 'швейцария',
                code: 'CHE'
            }, {
                key: 'латвия',
                code: 'LVA'
            }, {
                key: 'литва',
                code: 'LTU'
            }, {
                key: 'швеция',
                code: 'SWE'
            }, {
                key: 'словакия',
                code: 'SVK'
            }, {
                key: 'чехия',
                code: 'CZE'
            }, {
                key: 'финляндия',
                code: 'FIN'
            }, {
                key: 'польша',
                code: 'POL'
            }, {
                key: 'италия',
                code: 'ITA'
            }, {
                key: 'испания',
                code: 'ESP'
            }, {
                key: 'бельгия',
                code: 'BEL'
            }, {
                key: 'германия',
                code: 'DEU'
            }, {
                key: 'люксембург',
                code: 'LUX'
            }, {
                key: 'мальта',
                code: 'MLT'
            }, {
                key: 'дания',
                code: 'DNK'
            }, {
                key: 'португалия',
                code: 'PRT'
            }, {
                key: 'эстония',
                code: 'EST'
            }, {
                key: 'болгария',
                code: 'BGR'
            }, {
                key: 'нидерланды',
                code: 'NDL'
            },
        ];
        var getCode = function (key) { return countryCodes.filter(function (x) { return x.key === key.toLowerCase(); })[0].code; };
        fromInput.value = pvisa.validFrom.replace(/\./g, '-');
        toInput.value = "".concat(pvisa.validTo.replace(/\./g, '-'), " ").concat(getCode(pvisa.countryName.toLowerCase()));
    };
    var touristFields = [{
            htmlElementSelector: 'input[name*="[Patronymic]"]',
            value: visa.patonomic
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl02_fieldEditor_cmbFieldValue_txtValue',
            value: visa.previosSurname
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl07_fieldEditor_cmbFieldValue_txtValue',
            value: visa.birthPlace
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl17_fieldEditor_cmbFieldValue_txtValue',
            value: concatFullAddress(visa)
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl18_fieldEditor_cmbFieldValue_txtValue',
            value: visa.email
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl19_fieldEditor_cmbFieldValue_txtValue',
            value: visa.mobilePhoneNumber
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl20_fieldEditor_cmbFieldValue_txtValue',
            value: visa.occupation
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl21_fieldEditor_cmbFieldValue_txtValue',
            value: "".concat(visa.employer, " ").concat(visa.jobCompanyAddress, " ").concat(visa.jobPhoneNumber)
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl08_fieldEditor_cmbFieldValue_txtValue',
            value: 'RUS'
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl12_fieldEditor_cmbFieldValue_txtValue',
            value: visa.escortPersonName
        }, {
            htmlElementSelector: '#ctl00_generalContent_VisaFormEditor_tblForm_ctl16_fieldEditor_cmbFieldValue_txtValue',
            value: 'RUS'
        }];
    handleTouristFields(block, touristFields);
    setMaritalStatus(document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm_ctl11_fieldEditor_cmbFieldValue_ddlValue'), visa);
    setVisaType(document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm_ctl23_fieldEditor_cmbFieldValue_ddlValue'), visa);
    setHavePreviousVisas(document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm_ctl25_fieldEditor_cmbFieldValue_ddlValue'), visa);
    setPreviousVisa(document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm_ctl26_fieldEditor_cmbFieldValue_txtValue'), document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm_ctl27_fieldEditor_cmbFieldValue_txtValue'), 0);
    setPreviousVisa(document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm_ctl28_fieldEditor_cmbFieldValue_txtValue'), document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm_ctl29_fieldEditor_cmbFieldValue_txtValue'), 1);
    setPreviousVisa(document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm_ctl30_fieldEditor_cmbFieldValue_txtValue'), document.querySelector('#ctl00_generalContent_VisaFormEditor_tblForm_ctl31_fieldEditor_cmbFieldValue_txtValue'), 2);
};


/***/ }),

/***/ "./src/app/operatorScripts/19.ts":
/*!***************************************!*\
  !*** ./src/app/operatorScripts/19.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaForms: () => (/* binding */ fillVisaForms),
/* harmony export */   navigateToBookedClaimPage: () => (/* binding */ navigateToBookedClaimPage),
/* harmony export */   navigateToClaimForm: () => (/* binding */ navigateToClaimForm)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_delay__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/chunks/delay */ "./src/app/utils/chunks/delay.ts");
/* harmony import */ var _utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/chunks/reloadTab */ "./src/app/utils/chunks/reloadTab.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");












var makeSearchCode = function (_a, claimId) {
    var queryInput = _a.queryInput, searchButton = _a.searchButton;
    return "\n    console.log('input loaded!');\n    document.querySelector('".concat(queryInput, "').value = '").concat(claimId, "';\n    document.querySelector('").concat(searchButton, "').click();\n");
};
var toggleOrdersCode = function (_a) {
    var toggleLink = _a.toggleLink;
    return "\n    document.querySelector('".concat(toggleLink, "').click();\n");
};
function navigateToBookedClaimPage(tab, claimId, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, 'input[name="CLAIMBEGIN"]'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, {
        code: makeSearchCode({
            queryInput: operator.selectors.queryInput,
            searchButton: operator.selectors.searchButton,
        }, claimId)
    }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, '.claim'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: toggleOrdersCode({ toggleLink: '.toggle_orders.link' }) }); })
        .then(function () { return PreventPassportHiding(tab); });
}
var PreventPassportHiding = function (tab) {
    var PreventPassportHidingInternal = function () { return "\n        document.querySelectorAll('.passport_block').forEach(x => x.classList.remove('passport_block'));\n    "; };
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, '.passport_block')
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: PreventPassportHidingInternal() }); });
};
function navigateToClaimForm(context) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[context.sourceId];
    var tab = context.tab;
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, '.peoples .tourists-tabs > .panel'); })
        .then(function () { return (0,_utils_chunks_delay__WEBPACK_IMPORTED_MODULE_3__.delay)(1000); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_6__.stringifyFn)(claimFiller, { tourists: context.data.touristDataItems }) }); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_7__.createPushNotification)({ claimId: context.claimNumber, operator: operator, errorText: null }); })
        .then(function () {
        return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_7__.createPushNotification)({
            claimId: context.claimNumber,
            operator: operator,
            errorText: null
        }).then(function () { return (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_8__.startTrackingIdSelector)(tab, '.claim'); });
    })
        .then(function (response) { return (0,_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_11__.sendIdsToBookingCenter)(context.claimNumber, response.claimNo); })
        .then(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_9__.reloadTab)(context.sourceTab); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_7__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_10__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
        .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_7__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_10__.SendIdsStatus.FAIL, message: error.message }); });
}
function claimFiller(data) {
    console.log(data.tourists);
    window.scroll(document.querySelector('.peoples').offsetLeft, document.querySelector('.peoples').offsetTop);
    var touristBlocks = document.querySelectorAll('.peoples .tourists-tabs > .panel, .peoples .tourists-tabs > .addinfant > .panel');
    function setSexRadios(tourist, sexRadios) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                sexRadios[0].checked = true;
                break;
            case 2:
            case 4:
            case 6:
                sexRadios[1].checked = true;
                break;
        }
    }
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                console.log(touristField.value);
                element.value = touristField.value;
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
        });
    };
    var setHuman = function (index, tourist) {
        // 0 - MR
        // 1 - MRS
        // 2 - CHD
        var humanDdItemIndex = 0;
        switch (tourist.touristType) {
            case 1:
                humanDdItemIndex = 0;
                break;
            case 2:
                humanDdItemIndex = 1;
                break;
            case 3:
                humanDdItemIndex = 2;
                break;
            case 4:
                humanDdItemIndex = 2;
                break;
            case 5:
                humanDdItemIndex = 2;
                break;
            case 6:
                humanDdItemIndex = 2;
                break;
        }
        var script = document.createElement('script');
        var code = document.createTextNode("\n            document.querySelector('select[name=\"frm[People][-".concat(index + 1, "][HUMAN]\"] ~ div.chosen-container').dispatchEvent(new Event('mousedown'));\n            $ = samo.jQuery;\n            $('select[name=\"frm[People][-").concat(index + 1, "][HUMAN]\"] ~ div.chosen-container div.chosen-drop ul.chosen-results li[data-option-array-index=\"").concat(humanDdItemIndex, "\"]').mouseup()\n        "));
        script.appendChild(code);
        (document.body || document.head).appendChild(script);
    };
    var setCitezenship = function (index, tourist) {
        var select = document.querySelector("select[name=\"frm[People][-".concat(index + 1, "][NATIONALITY]\"]"));
        var text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), function (option) {
            if (tourist.citizenship === option.value) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var script = document.createElement('script');
        var code = document.createTextNode("\n            var searchinp = document.querySelector('select[name=\"frm[People][-".concat(index + 1, "][NATIONALITY]\"] ~ div.chosen-container input')\n            var dropdown = document.querySelector('select[name=\"frm[People][-").concat(index + 1, "][NATIONALITY]\"] ~ div.chosen-container');\n            searchinp.value = \"").concat(text, "\";\n            dropdown.dispatchEvent(new Event('mousedown'));\n            $ = samo.jQuery;\n            $('select[name=\"frm[People][-").concat(index + 1, "][NATIONALITY]\"] ~ div.chosen-container li.highlighted').mouseup()\n        "));
        script.appendChild(code);
        (document.body || document.head).appendChild(script);
    };
    var contacts = document.querySelector('input[name=CONTACTS]');
    if (contacts !== null) {
        contacts.value = 'abc@sletat.travel';
    }
    Array.prototype.forEach.call(touristBlocks, function (block, index) {
        var tourist = data.tourists[index];
        if (!tourist) {
            return;
        }
        var touristFields = [{
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][LASTLNAME]\"]"),
                value: tourist.surname.toUpperCase()
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][FIRSTLNAME]\"]"),
                value: tourist.name.toUpperCase()
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][BORN]\"]"),
                value: tourist.birthday
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][MOBILE]\"]"),
                value: (!tourist.phone || tourist.phone === '' || tourist.phone.replace(/\s/g, '') === '') ? '+79043334686' : tourist.phone
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][EMAIL]\"]"),
                value: (!tourist.email || tourist.email === '' || tourist.email.replace(/\s/g, '') === '') ? 'abc@sletat.travel' : tourist.email
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PSERIE]\"]"),
                value: tourist.passportSeries
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PNUMBER]\"]"),
                value: tourist.passportNumber
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PVALID]\"]"),
                value: tourist.passportExpireDate
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PGIVEN]\"]"),
                value: tourist.passportDate
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PGIVENORG]\"]"),
                value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
            }];
        handleTouristFields(block, touristFields);
        var sexRadios = block.querySelectorAll('input[id^="SEX"]');
        setSexRadios(tourist, sexRadios);
        setCitezenship(index, tourist);
        setHuman(index, tourist);
        console.log(index);
    });
}
/*visafill*/
function fillVisaForms(tab, data, claimNumber, sourceId) {
    if (data.countryTo === 'Кипр') {
        return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, '#cl_refer .resultset')
            .then(function () { return visaCyprusFillChain(tab, data.autoFillerData.touristDataItems); });
    }
    else {
        return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(tab, '#cl_refer .resultset')
            .then(function () { return visaSchengenFillChain(tab, data.autoFillerData.touristDataItems); });
    }
}
var visaSchengenFillChain = function (tab, tourists) { return new Promise(function (resolve) {
    return Promise.all(tourists.map(function (tourist, index) { return new Promise(function (resolve) {
        return openVisaFillForm(tab, index)
            .then(function (ntab) { return new Promise(function (resolve) {
            return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(ntab, '#anketa #ANKETA_FORM')
                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(ntab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_6__.stringifyFn)(fillTouristVisaForm, { tourist: tourist }) }); })
                .then(function () { return resolve({}); });
        }); })
            .then(function () { return resolve({}); });
    }); }))
        .then(function () { return resolve({}); });
}); };
var visaCyprusFillChain = function (tab, tourists) { return new Promise(function (resolve) {
    return Promise.all(tourists.map(function (tourist, index) { return new Promise(function (resolve) {
        return openVisaFillForm(tab, index)
            .then(function (ntab) { return new Promise(function (resolve) {
            return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_5__.startTrackingElement)(ntab, '#anketa #ANKETA_FORM')
                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(ntab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_6__.stringifyFn)(fillCyprusVisaForm, { tourist: tourist }) }); })
                .then(function () { return resolve({}); });
        }); })
            .then(function () { return resolve({}); });
    }); }))
        .then(function () { return resolve({}); });
}); };
var openVisaFillForm = function (tab, index) { return new Promise(function (resolve, reject) {
    var openVisaFillFormInternal = function (index) { return "document.querySelector('.resultset .tbl_peoples tbody :nth-child(".concat(index + 1, ") td.p_v_status a').href"); };
    chrome.tabs.executeScript(tab.id, { code: openVisaFillFormInternal(index) }, function (result) {
        if (!result || !result[0]) {
            reject('Failed to get visa form href');
        }
        (0,_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({ url: result[0], active: false })
            .then(function (tab) { return resolve(tab); });
    });
}); };
var fillTouristVisaForm = function (data) {
    if (!data.tourist) {
        return;
    }
    var visa = data.tourist.visaForm;
    if (!visa) {
        return;
    }
    var block = document.querySelector('#ANKETA_FORM');
    if (!block) {
        return;
    }
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = (touristField.value ? touristField.value : '');
            }
        });
    };
    var concatFullAddress = function (visa) {
        var addr = '';
        if (visa.city && visa.city !== 'NO') {
            addr += "".concat(visa.city, " ");
        }
        if (visa.street && visa.street !== 'NO') {
            addr += "".concat(visa.street, " ");
        }
        if (visa.building && visa.building !== 'NO') {
            addr += "".concat(visa.building, " ");
        }
        if (visa.block && visa.block !== 'NO') {
            addr += "".concat(visa.block, " ");
        }
        if (visa.appartment && visa.appartment !== 'NO') {
            addr += "".concat(visa.appartment, " ");
        }
        return addr;
    };
    var setMaritalStatus = function (select, visa) {
        if (!select) {
            return;
        }
        switch (visa.maritalStatus) {
            case 1:
                select.selectedIndex = 0;
                break;
            case 2:
                select.selectedIndex = 1;
                break;
            case 3:
                select.selectedIndex = 3;
                break;
            case 4:
                select.selectedIndex = 4;
                break;
        }
    };
    var setPreviousVisaCountry = function (select, index, visa) {
        if (!select) {
            return;
        }
        if (!visa.previosVisasInfoList || visa.previosVisasInfoList.length < index || index < 0) {
            return;
        }
        var countryName = visa.previosVisasInfoList[index].countryName.toLowerCase();
        Array.prototype.forEach.call(select.options, function (option) {
            if (option.text.toLowerCase() === countryName) {
                option.selected = true;
            }
        });
    };
    var setSponsorInfo = function (select, sponsorInput, visa) {
        if (!select) {
            return;
        }
        if (!sponsorInput) {
            return;
        }
        if (!visa.sponsorPersonName) {
            select.selectedIndex = 0;
            select.dispatchEvent(new Event('change'));
        }
        else {
            select.selectedIndex = 1;
            select.dispatchEvent(new Event('change'));
            sponsorInput.value = visa.sponsorPersonName ? visa.sponsorPersonName : '';
        }
    };
    var setPreviosVisasInput = function (input, visa) {
        if (!input) {
            return;
        }
        var schengenCountriesEngNameDict = [
            {
                key: 'греция',
                name: 'greece'
            }, {
                key: 'франция',
                name: 'france'
            }, {
                key: 'австрия',
                name: 'austria'
            }, {
                key: 'монако',
                name: 'monaco'
            }, {
                key: 'исландия',
                name: 'iceland'
            }, {
                key: 'андорра',
                name: 'andorra'
            }, {
                key: 'норвегия',
                name: 'norway'
            }, {
                key: 'швейцария',
                name: 'switzerland'
            }, {
                key: 'латвия',
                name: 'latvia'
            }, {
                key: 'литва',
                name: 'lithuania'
            }, {
                key: 'швеция',
                name: 'sweden'
            }, {
                key: 'словакия',
                name: 'slovakia'
            }, {
                key: 'чехия',
                name: 'czech republic'
            }, {
                key: 'финляндия',
                name: 'finland'
            }, {
                key: 'польша',
                name: 'poland'
            }, {
                key: 'италия',
                name: 'italy'
            }, {
                key: 'испания',
                name: 'spain'
            }, {
                key: 'бельгия',
                name: 'belgium'
            }, {
                key: 'германия',
                name: 'germany'
            }, {
                key: 'люксембург',
                name: 'luxembourg'
            }, {
                key: 'мальта',
                name: 'malta'
            }, {
                key: 'дания',
                name: 'denmark'
            }, {
                key: 'португалия',
                name: 'portugal'
            }, {
                key: 'эстония',
                name: 'estonia'
            }, {
                key: 'болгария',
                name: 'bulgaria'
            }, {
                key: 'нидерланды',
                name: 'netherlands'
            },
        ];
        var getEngName = function (key) { return schengenCountriesEngNameDict.filter(function (x) { return x.key === key.toLowerCase(); })[0].name; };
        input.value = visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
            ? visa.previosVisasInfoList
                .map(function (visa) { return "".concat(getEngName(visa.countryName), " ").concat(visa.validFrom.replace(/[.]/g, '/'), "-").concat(visa.validTo.replace(/[.]/g, '/')); })
                .reduce(function (x, y) { return x + '; ' + y; })
            : 'NO';
    };
    var touristFields = [{
            htmlElementSelector: 'input[name*="[Patronymic]"]',
            value: visa.patonomic
        }, {
            htmlElementSelector: 'input[name*="[BirthSurName]"]',
            value: visa.previosSurname
        }, {
            htmlElementSelector: 'input[name*="[BirthPlace]"]',
            value: visa.birthPlace
        }, {
            htmlElementSelector: 'input[name*="[Address_town]"]',
            value: visa.city
        }, {
            htmlElementSelector: 'input[name*="[Post]"]',
            value: visa.occupation
        }, {
            htmlElementSelector: 'input[name*="[Address]"]',
            value: concatFullAddress(visa)
        }, {
            htmlElementSelector: 'input[name*="[Phone]"]',
            value: visa.mobilePhoneNumber
        }, {
            htmlElementSelector: 'input[name*="[Email]"]',
            value: visa.email
        }, {
            htmlElementSelector: 'input[name*="[EmployerName]"]',
            value: visa.employer
        }, {
            htmlElementSelector: 'input[name*="[EmployerAddress]"]',
            value: visa.jobCompanyAddress
        }, {
            htmlElementSelector: 'input[name*="[EmployerPhone]"]',
            value: visa.jobPhoneNumber
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenVisaNumber1]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
                ? visa.previosVisasInfoList[0].number
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateFrom1]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
                ? visa.previosVisasInfoList[0].validFrom
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateTo1]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
                ? visa.previosVisasInfoList[0].validTo
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenVisaNumber2]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 1
                ? visa.previosVisasInfoList[1].number
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateFrom2]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 1
                ? visa.previosVisasInfoList[1].validFrom
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateTo2]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 1
                ? visa.previosVisasInfoList[1].validTo
                : ''
        }, {
            htmlElementSelector: 'input[name*="[RPSerie]"]',
            value: visa.passportSeries
        }, {
            htmlElementSelector: 'input[name*="[RPNumber]"]',
            value: visa.passportNumber
        }, {
            htmlElementSelector: 'input[name*="[Anketa_PGiven]"]',
            value: visa.travelPassportIssueBy
        }];
    handleTouristFields(block, touristFields);
    setMaritalStatus(document.querySelector('select[name*="[MaritalStatus]"]'), visa);
    setPreviousVisaCountry(document.querySelector('select[name*="[PreviousShengen_Country]"]'), 0, visa);
    setPreviousVisaCountry(document.querySelector('select[name*="[PreviousShengen1_Country]"]'), 1, visa);
    setSponsorInfo(document.querySelector('select[name*="[WhoPaying]"] , select[name*="[WhoIsPaying]"]'), document.querySelector('input[name*="[eWhoPaying]"] , input[name*="[WhoIsPayingOther]"]'), visa);
    setPreviosVisasInput(document.querySelector('input[name*="[PreviousShengen]"]'), visa);
};
var fillCyprusVisaForm = function (data) {
    if (!data.tourist) {
        return;
    }
    var visa = data.tourist.visaForm;
    if (!visa) {
        return;
    }
    var block = document.querySelector('#ANKETA_FORM');
    if (!block) {
        return;
    }
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = (touristField.value ? touristField.value : '');
            }
        });
    };
    var touristFields = [{
            htmlElementSelector: 'input[name*="[BirthPlace]"]',
            value: visa.birthPlace
        }, {
            htmlElementSelector: 'input[name*="[FatherName]"]',
            value: visa.fatherName
        }, {
            htmlElementSelector: 'input[name*="[MotherName]"]',
            value: visa.motherName
        }, {
            htmlElementSelector: 'input[name*="[Email]"]',
            value: visa.email
        }];
    handleTouristFields(block, touristFields);
};


/***/ }),

/***/ "./src/app/operatorScripts/20.ts":
/*!***************************************!*\
  !*** ./src/app/operatorScripts/20.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaForms: () => (/* binding */ fillVisaForms),
/* harmony export */   navigateToBookedClaimPage: () => (/* binding */ navigateToBookedClaimPage),
/* harmony export */   navigateToClaimForm: () => (/* binding */ navigateToClaimForm)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");









var touristSelector = '.orders a[href*="book/view"]';
function navigateToBookedClaimPage(tab, claimId, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__.navigateToClaimPage)(tab, operator, operator.credentials.packetMagnifier
        ? operator.credentials.packetMagnifier
        : operator.credentials.packet)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, touristSelector); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: clickSurname() }); });
}
var clickSurname = function () { return "\n    document.querySelector('".concat(touristSelector, "').click();\n"); };
function navigateToClaimForm(context) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[context.sourceId];
    var tab = context.tab;
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '#form_id_main'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(claimFiller, context.data.touristDataItems) }); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ claimId: context.claimNumber, operator: operator, errorText: null }); })
        .then(function () { return (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__.startTrackingIdSelector)(tab, ''); })
        .then(function (response) { return (0,_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_8__.sendIdsToBookingCenter)(context.claimNumber, response.claimNo); })
        .then(function (response) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
        .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.FAIL, message: error.message }); });
}
function claimFiller(data) {
    var touristBlocks = document.querySelectorAll('form  div[class="halfTab"]');
    window.scrollTo(0, document.body.scrollHeight);
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(function (touristItem) {
            var element = block.querySelector(touristItem.htmlElementSelector);
            if (element) {
                element.value = touristItem.value;
            }
        });
    }
    function setCitizenshipSelect(select, tourist) {
        if (!select) {
            return;
        }
        var options = Array.apply(null, select.options);
        console.log(options);
        options.forEach(function (option) {
            if (option.value === tourist.citizenship) {
                option.selected = true;
            }
        });
    }
    function setSexSelect(select, tourist) {
        if (!select) {
            return;
        }
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                select.options[1].selected = true;
                break;
            case 2:
            case 4:
            case 6:
                select.options[2].selected = true;
                break;
        }
    }
    Array.prototype.forEach.call(touristBlocks, function (block, index) {
        var tourist = data[index];
        var fieldIndex = index + 1;
        if (!tourist) {
            return;
        }
        var fields = [{
                htmlElementSelector: "input[name=\"l_name".concat(fieldIndex, "\"]"),
                value: tourist.surnameEng
            }, {
                htmlElementSelector: "input[name=\"name".concat(fieldIndex, "\"]"),
                value: tourist.nameEng
            }, {
                htmlElementSelector: "input[name=\"m_name".concat(fieldIndex, "\"]"),
                value: tourist.middleNameEng
            }, {
                htmlElementSelector: "input[name=\"bdate".concat(fieldIndex, "\"]"),
                value: tourist.birthday
            }, {
                htmlElementSelector: "input[name=\"num_passport".concat(fieldIndex, "\"]"),
                value: tourist.passportSeries
            }, {
                htmlElementSelector: "input[name=\"passport".concat(fieldIndex, "\"]"),
                value: tourist.passportNumber
            }, {
                htmlElementSelector: "input[name=\"pass_begins".concat(fieldIndex, "\"]"),
                value: tourist.passportDate
            }, {
                htmlElementSelector: "input[name=\"pass_ends".concat(fieldIndex, "\"]"),
                value: tourist.passportExpireDate
            }];
        var citizenshipSelect = block.querySelector("select[name=\"citizenship".concat(fieldIndex, "\"]"));
        var sexSelect = block.querySelector("select[name=\"gender".concat(fieldIndex, "\"]"));
        handleTouristFields(fields, block);
        setCitizenshipSelect(citizenshipSelect, tourist);
        setSexSelect(sexSelect, tourist);
        var birhdayInput = block.querySelector("input[name=\"bdate".concat(fieldIndex, "\"]"));
        birhdayInput.dispatchEvent(new Event('change'));
    });
}
function fillVisaForms(tab, data, claimNumber, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.hotel_order_clients')
        .then(function () { return visaFillChain(tab, data.touristDataItems); });
}
var visaFillChain = function (tab, tourists) { return new Promise(function (resolve) {
    var chain = new Promise(function (resolve, reject) { return resolve(); });
    tourists.forEach(function (tourist, index) {
        return chain = chain.then(function () { return openVisaFillForm(tab, index); })
            .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.ui-dialog[style*="display: block;"]'); })
            .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(fillCyprusVisaForm, { tourist: tourist }) }); })
            .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElementDisappear)(tab, '.ui-dialog[style*="display: block;"]'); });
    });
    chain.then(function () { return resolve({}); });
}); };
var openVisaFillForm = function (tab, index) {
    var openVisaFillFormInternal = function (index) { return "document.querySelectorAll('.hotel_order_clients .tourists_list .one_tourist')[".concat(index, "].querySelector('.opt_lnk a[onclick*=\"editTouristVisa\"]').click()"); };
    return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: openVisaFillFormInternal(index) });
};
var fillCyprusVisaForm = function (data) {
    var block = document.querySelector('#visa-wnd');
    if (!data.tourist) {
        return;
    }
    var visa = data.tourist.visaForm;
    if (!visa) {
        return;
    }
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = touristField.value;
            }
        });
    }
    var touristFields = [{
            htmlElementSelector: 'input[name^="visa_bcountry"]',
            value: visa.birthPlace,
        }, {
            htmlElementSelector: 'input[name^="visa_mother"]',
            value: visa.motherName,
        }, {
            htmlElementSelector: 'input[name^="visa_father"]',
            value: visa.fatherName,
        }, {
            htmlElementSelector: 'input[name^="visa_pcountry"]',
            value: visa.passportIssueCountry,
        }];
    handleTouristFields(block, touristFields);
};


/***/ }),

/***/ "./src/app/operatorScripts/3.ts":
/*!**************************************!*\
  !*** ./src/app/operatorScripts/3.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaForms: () => (/* binding */ fillVisaForms),
/* harmony export */   navigateToClaimForm: () => (/* binding */ navigateToClaimForm)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/reloadTab */ "./src/app/utils/chunks/reloadTab.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _utils_chunks_unifyTouristIdenify__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/chunks/unifyTouristIdenify */ "./src/app/utils/chunks/unifyTouristIdenify.ts");
/* harmony import */ var _services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");











function navigateToClaimForm(context) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[context.sourceId];
    var tab = context.tab;
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.booking-service-table.tourists tbody tr:not(:first-child) .link-popup.person_popup_link , #masterContent'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(claimFiller, { tourists: context.data.touristDataItems }) }); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(claimCustomerFiller, { customer: context.data.customer }) }); })
        .then(function () { return (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_5__.startTrackingIdSelectorWithClaimNumberValidation)(tab, '.pegasys-order-id', context.claimNumber); })
        .then(function (response) { return (0,_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_10__.sendIdsToBookingCenter)(context.claimNumber, response.claimNo); })
        .then(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_6__.reloadTab)(context.sourceTab); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_7__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_8__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); });
}
function claimCustomerFiller(data) {
    console.log('CUSTOMER ', data.customer);
    var customerFields = [{
            htmlElementSelector: '#customer_LastName , .private-customer-last-name',
            value: data.customer.surnameEng ? data.customer.surnameEng : data.customer.surnameRus
        }, {
            htmlElementSelector: '#customer_FirstName , .private-customer-first-name',
            value: data.customer.nameEng ? data.customer.nameEng : data.customer.nameRus
        }, {
            htmlElementSelector: '#customer_MiddleName , .private-customer-middle-name',
            value: data.customer.middleNameEng ? data.customer.middleNameEng : data.customer.middleNameRus
        }, {
            htmlElementSelector: '#customer_DateOfBirth , .private-customer-date-of-birth',
            value: data.customer.birthday
        }, {
            htmlElementSelector: '#customer_Email , .private-customer-email',
            value: 'ocb@corp.sletat.ru'
        }, {
            htmlElementSelector: '#customer_Phone , .private-customer-phone ',
            value: '89043334686'
        }, {
            htmlElementSelector: '#customer_Address , .private-customer-address',
            value: data.customer.address
        }, {
            htmlElementSelector: '#customer_DocumentNumber , .private-customer-document-number',
            value: "".concat(data.customer.passportSeries ? data.customer.passportSeries.trim() : data.customer.passportSeries).concat(data.customer.passportNumber ? data.customer.passportNumber.trim() : data.customer.passportNumber)
        }, {
            htmlElementSelector: '#customer_DocumentIssuerName , .private-customer-document-issuer-name',
            value: data.customer.passportIssueOrg
        }, {
            htmlElementSelector: '#customer_DocumentIssue , .private-customer-document-issue-date',
            value: data.customer.passportDate
        }, {
            htmlElementSelector: '#customer_DocumentIssuerCode , .private-customer-document-issuer-code',
            value: data.customer.passportIssueCode
        }];
    customerFields.forEach(function (customerField) {
        var element = document.querySelector(customerField.htmlElementSelector);
        if (element) {
            element.value = customerField.value;
        }
    });
}
function claimFiller(data) {
    var selectedTourist = null;
    function setSexRadios(tourist, sexRadios) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                sexRadios[0].checked = true;
                break;
            case 2:
            case 4:
            case 6:
                sexRadios[1].checked = true;
                break;
        }
    }
    function waitForFormLoad(touristRowLink) {
        touristRowLink.click();
        return new Promise(function (resolve, reject) {
            var timer = setInterval(function () {
                if (document.querySelectorAll('input[name="sex"]').length) {
                    clearInterval(timer);
                    resolve({});
                }
            }, 1000);
        });
    }
    function waitForSaving() {
        console.log('s');
        return new Promise(function (resolve, reject) {
            var timer = setInterval(function () {
                if (!document.querySelector('.main-button.save_person , .changePersonDialog[style*="display: block"] .bottom-bar-save-button')) {
                    clearInterval(timer);
                    console.log('f');
                    resolve(true);
                }
            }, 1000);
        });
    }
    function getTouristAge(tourist) {
        var _a = tourist.birthday.split('.'), day = _a[0], month = _a[1], year = _a[2];
        var ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
        var ageDate = new Date(ageDiffMs);
        return ageDate.getUTCFullYear() - 1970;
    }
    function getPopUpScript() {
        return "\n            function setSelectedTourist(i, e) {\n                console.dir(arguments);\n\n                document.querySelector('#hiddenSelectedTourist').value = i;\n            }\n\n            function closeAutofillPopup() {\n                document.querySelector('#autofillpopupdiv').style.display = 'none';\n            }\n        ";
    }
    function getPopupStyles() {
        return "\n                /* Modal Content */\n                .modal-content {\n                    position: relative;\n                    background-color: #fefefe;\n                    margin: 1em;\n                    padding: 0;\n                    border: 1px solid #888;\n                    width: 20%;\n                    box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2),0 6px 20px 0 rgba(0,0,0,0.19);\n                    -webkit-animation-name: animatetop;\n                    -webkit-animation-duration: 0.4s;\n                    animation-name: animatetop;\n                    animation-duration: 0.4s\n                }\n\n                .list-group-item.disabled, .list-group-item:disabled {\n                    color: #6c757d;\n                    background-color: #fff;\n                    cursor: default;\n                }\n\n                /* Add Animation */\n                @-webkit-keyframes animatetop {\n                    from {top:-300px; opacity:0}\n                    to {top:0; opacity:1}\n                }\n\n                @keyframes animatetop {\n                    from {top:-300px; opacity:0}\n                    to {top:0; opacity:1}\n                }\n\n                /* The Close Button */\n                .closeAutofill {\n                    color: white;\n                    float: right;\n                    font-size: 28px;\n                    font-weight: bold;\n                }\n\n                .closeAutofill:hover, .closeAutofill:focus {\n                    color: #000;\n                    text-decoration: none;\n                    cursor: pointer;\n                }\n\n                .modal-header {\n                    padding: 2px 16px;\n                    background-color: #5cb85c;\n                    color: white;\n                }\n\n                <!-- .modal-body {padding: 2px 16px;} -->\n\n                .modal-footer {\n                    padding: 2px 16px;\n                    background-color: #5cb85c;\n                    color: white;\n                }\n\n                .list-group {\n                    <!-- max-width: 400px; -->\n                    <!-- width: 100%; -->\n                    display: flex;\n                    -webkit-box-orient: vertical;\n                    -webkit-box-direction: normal;\n                    flex-direction: column;\n                    padding-left: 0;\n                    margin-bottom: 0;\n                }\n\n                .list-group-item.active {\n                    z-index: 2;\n                    color: #fff;\n                    background-color: #007bff;\n                    border-color: #007bff;\n                }\n\n                .list-group-item:first-child {\n                    border-top-left-radius: .25rem;\n                    border-top-right-radius: .25rem;\n                }\n\n                .list-group-item {\n                    position: relative;\n                    display: block;\n                    padding: .75rem 1.25rem;\n                    margin-bottom: -1px;\n                    background-color: #fff;\n                    border: 1px solid rgba(0,0,0,.125);\n                }\n\n                .list-group-item-action {\n                    <!-- width: 100%; -->\n                    color: #495057;\n                    text-align: inherit;\n                    text-decoration: none;\n                }\n        ";
    }
    function getPopUpHtml(tourists) {
        var touristList = tourists.map(function (t, i) {
            var filledClass = t.isFilled ? 'disabled' : '';
            return "<a href=\"#\" onClick=\"setSelectedTourist(".concat(i, ")\" class=\"list-group-item list-group-item-action ").concat(filledClass, "\">").concat(t.surnameEng, " ").concat(t.nameEng, " ").concat(t.middleNameEng, " (").concat(getTouristAge(t), ")</a>");
        });
        return "\n            <div class=\"modal-header\">\n                <span class=\"closeAutofill\" onClick=\"closeAutofillPopup()\">&times;</span>\n                    <h2>\u041A\u0430\u043A\u043E\u0433\u043E \u0442\u0443\u0440\u0438\u0441\u0442\u0430 \u0437\u0430\u043F\u043E\u043B\u043D\u044F\u0435\u043C?</h2>\n            </div>\n            <div class=\"list-group\">\n                ".concat(touristList.join(' '), "\n            </div>\n        ");
    }
    function waitForTouristSelect() {
        return new Promise(function (resolve, reject) {
            var timer = setInterval(function () {
                var hiddenInput = document.querySelector('#hiddenSelectedTourist');
                if (hiddenInput && hiddenInput.value) {
                    var touristIndex = parseInt(hiddenInput.value, 10);
                    // @ts-ignore
                    if (touristIndex !== NaN) {
                        if (touristIndex > data.tourists.length) {
                            console.log("\u0412\u044B\u0431\u0440\u0430\u043D\u043D\u044B\u0439 \u0438\u043D\u0434\u0435\u043A\u0441 ".concat(touristIndex, ", \u0430 \u0442\u0443\u0440\u0438\u0441\u0442\u043E\u0432 \u0432\u0441\u0435\u0433\u043E ").concat(data.tourists.length));
                            reject();
                        }
                        // проставляем выбранного туриста по индексу
                        selectedTourist = data.tourists[touristIndex];
                        data.tourists[touristIndex].isFilled = true;
                        console.log('Selected tourist');
                        console.dir(selectedTourist);
                        clearInterval(timer);
                        resolve();
                    }
                }
            }, 1000);
        });
    }
    function fillTourist(link, tourist, useSelectedTourist) {
        if (useSelectedTourist === void 0) { useSelectedTourist = false; }
        return waitForFormLoad(link)
            .then(function () {
            if (useSelectedTourist) {
                /*************************/
                var popUpDiv = document.createElement('div');
                popUpDiv.id = 'autofillpopupdiv';
                popUpDiv.className = 'modal-content';
                // глобальные переменные -- это плохо
                popUpDiv.innerHTML = getPopUpHtml(data.tourists);
                var pegasPopUp = document.querySelector('.popup_wrapper');
                pegasPopUp.appendChild(popUpDiv);
                /*************************/
                return waitForTouristSelect();
            }
            else {
                return Promise.resolve();
            }
        })
            .then(function () {
            if (useSelectedTourist) {
                tourist = selectedTourist;
            }
            if (tourist) {
                var touristFields = [{
                        htmlElementSelector: '#surname , #change-person-last-name',
                        value: tourist.surnameEng
                    }, {
                        htmlElementSelector: '#name , #change-person-first-name',
                        value: tourist.nameEng
                    }, {
                        htmlElementSelector: '#birthdate , #change-person-birth-date',
                        value: tourist.birthday
                    }, {
                        htmlElementSelector: '#passport_number , #change-person-passport-number',
                        value: "".concat(tourist.passportSeries ? tourist.passportSeries.trim() : tourist.passportSeries).concat(tourist.passportNumber ? tourist.passportNumber.trim() : tourist.passportNumber)
                    }, {
                        htmlElementSelector: '#passport_due , #change-person-passport-expiration-date',
                        value: tourist.passportExpireDate
                    }, {
                        htmlElementSelector: '#passport_where , #change-person-passport-issue-date',
                        value: tourist.passportDate
                    }, {
                        htmlElementSelector: '#passport_who , #change-person-passport-issuer',
                        value: tourist.passportIssueOrg || 'FMS'
                    }, {
                        htmlElementSelector: '#phone , #change-person-phone',
                        value: tourist.phone
                    }, {
                        htmlElementSelector: '#phone_mobile , #change-person-mobile-phone',
                        value: tourist.phone
                    }, {
                        htmlElementSelector: '#email , #change-person-email',
                        value: tourist.email
                    }, {
                        htmlElementSelector: '#address , #change-person-address',
                        value: tourist.address
                    }];
                var touristForm_1 = document.querySelector('.person_form , .changePersonDialog');
                var header = touristForm_1.querySelector('div.row.header span.simple-text');
                var headerText = '';
                if (header && header.textContent) {
                    headerText = header.textContent.trim();
                }
                touristFields.forEach(function (touristField) {
                    var element = touristForm_1.querySelector(touristField.htmlElementSelector);
                    if (element && touristField.value) {
                        element.value = touristField.value;
                    }
                });
                var sexRadiosInputs = touristForm_1.querySelectorAll('input[name="sex"]');
                setSexRadios(tourist, sexRadiosInputs);
                var saveButton = touristForm_1.querySelector('.main-button.save_person');
                if (saveButton) {
                    saveButton.click();
                }
            }
            if (useSelectedTourist) {
                // за собой нужно убирать :)
                var popUpDiv = document.querySelector('#autofillpopupdiv');
                if (popUpDiv) {
                    popUpDiv.remove();
                }
                selectedTourist = null;
                var hiddenInput = document.querySelector('#hiddenSelectedTourist');
                if (hiddenInput) {
                    hiddenInput.value = '';
                }
            }
            return waitForSaving();
        }, function () { return console.log('Все очень плохо'); });
    }
    var chain = Promise.resolve();
    var touristRowLinksSelector = '.booking-service-table.tourists tbody tr:not(:first-child) .link-popup.person_popup_link , .tourists tbody .name a';
    var childrenCount = data.tourists.filter(function (t) {
        var touristAge = getTouristAge(t);
        return 2 < touristAge && touristAge <= 14;
    }).length;
    console.log("\u041A\u043E\u043B\u0438\u0447\u0435\u0441\u0442\u0432\u043E \u0434\u0435\u0442\u0435\u0439: ".concat(childrenCount));
    if (childrenCount <= 1) {
        data.tourists.forEach(function (tourist, index) {
            chain = chain.then(function (prev) {
                // Так как меняется дом после добавления туриста, ищем ссылки на формы заполнения каждый раз заново
                var links = document.querySelectorAll(touristRowLinksSelector);
                if (links && links[index]) {
                    return fillTourist(links[index], tourist);
                }
                else {
                    return Promise.resolve();
                }
            });
        });
    }
    else {
        // добавляем скрипты для попапчика
        var scriptsAutofill = document.createElement('script');
        scriptsAutofill.id = 'autofillScript';
        scriptsAutofill.innerHTML = getPopUpScript();
        document.body.appendChild(scriptsAutofill);
        // добавляем стили для нашего попапчика
        var styleToAdd = document.createElement('style');
        styleToAdd.id = 'autofillPopupStyle';
        styleToAdd.innerHTML = getPopupStyles();
        document.body.appendChild(styleToAdd);
        // добавляем интуп для хранения выбранного туриста
        var hiddenInput = document.createElement('input');
        hiddenInput.type = 'hidden';
        hiddenInput.id = 'hiddenSelectedTourist';
        document.body.appendChild(hiddenInput);
        var linksLength = document.querySelectorAll(touristRowLinksSelector).length;
        var _loop_1 = function (i) {
            chain = chain.then(function (prev) {
                // Так как меняется дом после добавления туриста, ищем ссылки на формы заполнения каждый раз заново
                var links = document.querySelectorAll(touristRowLinksSelector);
                if (links && links[i]) {
                    return fillTourist(links[i], null, true);
                }
                else {
                    return Promise.resolve();
                }
            });
        };
        for (var i = 0; i < linksLength; i++) {
            _loop_1(i);
        }
    }
    return chain;
}
/*visa*/
function fillVisaForms(tab, data, claimNumber, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    if (data.countryTo === 'Кипр') {
        return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.pegasys-order-info .block i.visa , #masterContent')
            .then(function () { return visaCyprusFillChain(tab, data.autoFillerData.touristDataItems); });
    }
    else {
        return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.pegasys-order-info .block i.visa , #masterContent')
            .then(function () { return visaSchengenFillChain(tab, data.autoFillerData.touristDataItems); });
    }
}
var visaSchengenFillChain = function (tab, tourists) {
    return new Promise(function (resolve) {
        var chain = new Promise(function (resolve, reject) { return resolve(); });
        tourists.forEach(function (tourist, index) {
            chrome.tabs.executeScript(tab.id, { code: hasVisaFillLink(index) }, function (result) {
                if (result[0] && tourist.visaForm !== null) {
                    chain = chain
                        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(openVisaForm, { index: index }) }); })
                        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '#content_wrapper .visa-docs__form , .changeVisaDocumentsDialog[style*="display: block"] .container > .document.form'); })
                        .then(function () { return identifyTourist(tourists, tab); })
                        .then(function (idTourist) {
                        if (idTourist) {
                            (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(setPreviousSurnameSelect, { tourist: idTourist }) })
                                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(setMaritalStatus, { tourist: idTourist }) }); })
                                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(setPreviousVisas, { tourist: idTourist }) }); })
                                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(setSponsorInfo, { tourist: idTourist }) }); })
                                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(fillVisaData, { tourist: idTourist }) }); });
                        }
                    })
                        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElementDisappear)(tab, '#content_wrapper .visa-docs__form , .changeVisaDocumentsDialog[style*="display: block"] .container > .document.form'); });
                }
            });
        });
        chain = chain.then(function () { return resolve({}); }).then();
    });
};
var visaCyprusFillChain = function (tab, tourists) {
    return new Promise(function (resolve) {
        var chain = new Promise(function (resolve, reject) { return resolve(); });
        tourists.forEach(function (tourist, index) {
            chrome.tabs.executeScript(tab.id, { code: hasVisaFillLink(index) }, function (result) {
                if (result[0] && tourist.visaForm !== null) {
                    chain = chain
                        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(openVisaForm, { index: index }) }); })
                        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '#content_wrapper .visa-docs__form , .changeVisaDocumentsDialog[style*="display: block"] .container > .document.form'); })
                        .then(function () { return identifyTourist(tourists, tab); })
                        .then(function (idTourist) { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_4__.stringifyFn)(fillCyprusVisaData, { tourist: idTourist }) }); })
                        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElementDisappear)(tab, '#content_wrapper .visa-docs__form , .changeVisaDocumentsDialog[style*="display: block"] .container > .document.form'); });
                }
            });
        });
    });
};
var getTouristVisaInfo = function (tab) { return new Promise(function (resolve, reject) {
    var getTouristFied = function (fieldname) { return "\n        Array.prototype.filter.call(document.querySelector('#content_wrapper .visa-docs__form , #changeVisaDocuments .container > .document.form').querySelectorAll('label'), function (x) {return x.innerText.toLowerCase().indexOf('".concat(fieldname, "') !== -1;})[0].parentElement.parentElement.querySelector('input').value;\n    "); };
    chrome.tabs.executeScript(tab.id, { code: getTouristFied('имя') }, function (result) {
        var name = result[0];
        chrome.tabs.executeScript(tab.id, { code: getTouristFied('фамилия') }, function (result) {
            var surname = result[0];
            chrome.tabs.executeScript(tab.id, { code: getTouristFied('дата рождения') }, function (result) {
                var birtdate = result[0];
                resolve({
                    name: name,
                    surname: surname,
                    dateOfBirth: birtdate,
                });
            });
        });
    });
}); };
var identifyTourist = function (tourists, tab) { return new Promise(function (resolve, reject) {
    return getTouristVisaInfo(tab)
        .then(function (idInfo) { return (0,_utils_chunks_unifyTouristIdenify__WEBPACK_IMPORTED_MODULE_9__.unifyTouristIdenify)(tourists, idInfo); })
        .then(function (tourist) { return resolve(tourist); });
}); };
var openVisaForm = function (data) {
    var l = document.querySelectorAll('.service-descriptions .visa-status-description a')[data.index];
    if (l) {
        l.click();
        return;
    }
    var visablock = document.querySelector('.pegasys-order-info .block .block-header .visa');
    if (!visablock) {
        return;
    }
    var block = visablock.parentElement.parentElement;
    if (!block) {
        return;
    }
    var rows = block.querySelectorAll('.block-contents .row');
    if (rows.length <= data.index) {
        return;
    }
    var row = rows[data.index];
    var lnk = row.querySelector('div.js-visa-person');
    if (!lnk) {
        return;
    }
    lnk.click();
};
var setPreviousSurnameSelect = function (data) {
    var visablock = document.querySelector('#content_wrapper .visa-docs__form , #changeVisaDocuments .container > .document.form');
    var visa = data.tourist.visaForm;
    var contains = function (selector, text) {
        var elements = visablock.querySelectorAll(selector);
        return [].filter.call(elements, function (element) {
            return RegExp(text).test("".concat(element.textContent));
        });
    };
    var select = contains('label , span', 'У туриста были предыдущие фамилии')[0].parentElement.parentElement.querySelector('select');
    if (visa.previosSurname && visa.previosSurname !== 'NO') {
        select.selectedIndex = 1;
        select.dispatchEvent(new Event('input'));
        var intervalId_1 = 0;
        var fillSurname = function () {
            var inps = contains('label', 'Фамилия при рождении');
            if (inps.length > 0) {
                clearInterval(intervalId_1);
                var inp = inps[0].parentElement.parentElement.querySelector('input');
                inp.value = visa.previosSurname;
                inp.dispatchEvent(new Event('change'));
                inp.dispatchEvent(new Event('input'));
            }
        };
        var timer = setInterval(fillSurname, 100);
    }
    else {
        select.selectedIndex = 2;
        select.dispatchEvent(new Event('input'));
    }
};
var setMaritalStatus = function (data) {
    var visablock = document.querySelector('#content_wrapper .visa-docs__form , #changeVisaDocuments .container > .document.form');
    var visa = data.tourist.visaForm;
    var contains = function (selector, text) {
        var elements = visablock.querySelectorAll(selector);
        return [].filter.call(elements, function (element) {
            return RegExp(text).test("".concat(element.textContent));
        });
    };
    var select = contains('label , span', 'Супружеский статус')[0].parentElement.parentElement.querySelector('select');
    console.log(visa.maritalStatus);
    switch (visa.maritalStatus) {
        case 0:
            select.selectedIndex = 0;
            break;
        case 1:
            select.selectedIndex = 1;
            break;
        case 2:
            select.selectedIndex = 2;
            break;
        case 3:
            select.selectedIndex = 4;
            break;
        case 4:
            select.selectedIndex = 5;
            break;
    }
    select.dispatchEvent(new Event('input'));
};
var setPreviousVisas = function (data) {
    var visablock = document.querySelector('#content_wrapper .visa-docs__form , #changeVisaDocuments .container > .document.form');
    var visa = data.tourist.visaForm;
    var contains = function (selector, text) {
        var elements = visablock.querySelectorAll(selector);
        return [].filter.call(elements, function (element) {
            return RegExp(text).test("".concat(element.textContent));
        });
    };
    var select = contains('label , span', 'Имеются ли у туриста шенгенские визы за последние 3 года')[0].parentElement.parentElement.querySelector('select');
    if (visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0) {
        select.selectedIndex = 1;
        select.dispatchEvent(new Event('input'));
        var intervalId_2 = 0;
        var fillPrevVisas_1 = function () {
            var inps = contains('label , span', 'Страны Шенгенского соглашения, посещенные за последние три года');
            if (inps.length > 0) {
                clearInterval(intervalId_2);
                var prevInp = inps[0].parentElement.parentElement.querySelector('input');
                var val_1 = '';
                visa.previosVisasInfoList.forEach(function (pvisa, index) {
                    val_1 += "".concat(pvisa.countryName, " ").concat(pvisa.validFrom, " - ").concat(pvisa.validTo, " ");
                });
                prevInp.value = val_1;
                prevInp.dispatchEvent(new Event('change'));
                prevInp.dispatchEvent(new Event('input'));
            }
        };
        var fillCnt = function () {
            var cnts = contains('label , span', 'Количество стран Шенгенского соглашения, посещенных за последние три года');
            if (cnts.length > 0) {
                clearInterval(intervalId_2);
                var cntSelect = cnts[0].parentElement.parentElement.querySelector('select');
                switch (visa.previosVisasInfoList.length) {
                    case 1:
                        cntSelect.selectedIndex = 1;
                        break;
                    case 2:
                        cntSelect.selectedIndex = 2;
                        break;
                    default:
                        cntSelect.selectedIndex = 3;
                        break;
                }
                cntSelect.dispatchEvent(new Event('input'));
                var timer_1 = setInterval(fillPrevVisas_1, 100);
            }
        };
        var timer = setInterval(fillCnt, 100);
    }
    else {
        select.selectedIndex = 2;
        select.dispatchEvent(new Event('input'));
    }
};
var setSponsorInfo = function (data) {
    var visablock = document.querySelector('#content_wrapper .visa-docs__form , #changeVisaDocuments .container > .document.form');
    var visa = data.tourist.visaForm;
    var contains = function (selector, text) {
        var elements = visablock.querySelectorAll(selector);
        return [].filter.call(elements, function (element) {
            return RegExp(text).test("".concat(element.textContent));
        });
    };
    var select = contains('label , span', 'Плательщик')[0].parentElement.parentElement.querySelector('select');
    if (visa.sponsorPersonName && visa.sponsorPersonName !== 'NO') {
        select.selectedIndex = 2;
        select.dispatchEvent(new Event('input'));
        var intervalId_3 = 0;
        var fillSponsorName = function () {
            var inps = contains('label , span', 'Спонсор');
            if (inps.length > 0) {
                clearInterval(intervalId_3);
                var inp = inps[0].parentElement.parentElement.querySelector('input');
                inp.value = visa.sponsorPersonName;
                inp.dispatchEvent(new Event('change'));
                inp.dispatchEvent(new Event('input'));
            }
        };
        var timer = setInterval(fillSponsorName, 100);
    }
    else {
        select.selectedIndex = 1;
        select.dispatchEvent(new Event('input'));
    }
};
var fillVisaData = function (data) {
    var visablock = document.querySelector('#content_wrapper .visa-docs__form , #changeVisaDocuments .container > .document.form');
    var visa = data.tourist.visaForm;
    if (!visa) {
        return;
    }
    var getSchengenFields = function () {
        var contains = function (selector, text) {
            var elements = visablock.querySelectorAll(selector);
            return [].filter.call(elements, function (element) {
                return RegExp(text).test("".concat(element.textContent));
            });
        };
        var concatFullAddress = function (visa) {
            var addr = '';
            if (visa.city && visa.city !== 'NO') {
                addr += "".concat(visa.city, " ");
            }
            if (visa.street && visa.street !== 'NO') {
                addr += "".concat(visa.street, " ");
            }
            if (visa.building && visa.building !== 'NO') {
                addr += "".concat(visa.building, " ");
            }
            if (visa.block && visa.block !== 'NO') {
                addr += "".concat(visa.block, " ");
            }
            if (visa.appartment && visa.appartment !== 'NO') {
                addr += "".concat(visa.appartment, " ");
            }
            return addr;
        };
        return [
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Место рождения')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.birthPlace
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Страна рождения')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.citizenship
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Фактический адрес проживания туриста')[0].parentElement.parentElement.querySelector('input'); },
                value: concatFullAddress(visa)
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Контактный телефон')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.mobilePhoneNumber
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Электронный адрес туриста')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.email
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Название организации, в которой работает или учится турист')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.employer
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Адрес организации, в которой работает или учится турист')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.jobCompanyAddress
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Телефон организации, в которой работает или учится турист')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.jobPhoneNumber
            },
        ];
    };
    var fields = getSchengenFields();
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(function (touristItem) {
            var element = touristItem.htmlElementSelectorFunc();
            if (element && touristItem.value) {
                element.value = touristItem.value;
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
        });
    }
    handleTouristFields(fields, visablock);
};
var fillCyprusVisaData = function (data) {
    var visablock = document.querySelector('#content_wrapper .visa-docs__form , #changeVisaDocuments .container > .document.form');
    var visa = data.tourist.visaForm;
    if (!visa) {
        return;
    }
    var getCyprusFields = function () {
        var contains = function (selector, text) {
            var elements = visablock.querySelectorAll(selector);
            return [].filter.call(elements, function (element) {
                return RegExp(text).test("".concat(element.textContent));
            });
        };
        var concatFullAddress = function (visa) {
            var addr = '';
            if (visa.city && visa.city !== 'NO') {
                addr += "".concat(visa.city, " ");
            }
            if (visa.street && visa.street !== 'NO') {
                addr += "".concat(visa.street, " ");
            }
            if (visa.building && visa.building !== 'NO') {
                addr += "".concat(visa.building, " ");
            }
            if (visa.block && visa.block !== 'NO') {
                addr += "".concat(visa.block, " ");
            }
            if (visa.appartment && visa.appartment !== 'NO') {
                addr += "".concat(visa.appartment, " ");
            }
            return addr;
        };
        return [
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Место рождения')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.birthPlace
                    ? visa.birthPlace.toUpperCase() : ''
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Имя отца')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.fatherName
                    ? visa.fatherName.toUpperCase() : ''
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Имя матери')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.motherName
                    ? visa.motherName.toUpperCase() : ''
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Профессия или занятие')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.occupation
                    ? visa.occupation.toUpperCase() : ''
            },
            {
                htmlElementSelectorFunc: function () { return contains('label', 'Номер телефона')[0].parentElement.parentElement.querySelector('input'); },
                value: visa.mobilePhoneNumber
                    ? visa.mobilePhoneNumber : ''
            },
        ];
    };
    var fields = getCyprusFields();
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(function (touristItem) {
            var element = touristItem.htmlElementSelectorFunc();
            if (element && touristItem.value) {
                element.value = touristItem.value;
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
        });
    }
    handleTouristFields(fields, visablock);
};
var hasVisaFillLink = function (index) { return "\n    document.querySelectorAll('.service-descriptions .visa-status-description a')[".concat(index, "]\n        ? document.querySelectorAll('.service-descriptions .visa-status-description a')[").concat(index, "]\n        : document.querySelector('.pegasys-order-info .block .block-header .visa')\n            .parentElement.parentElement.querySelectorAll('.block-contents .row')[").concat(index, "]\n            .querySelector('div.js-visa-person');\n"); };


/***/ }),

/***/ "./src/app/operatorScripts/380.ts":
/*!****************************************!*\
  !*** ./src/app/operatorScripts/380.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaForms: () => (/* binding */ fillVisaForms),
/* harmony export */   navigateToBookedClaimPage: () => (/* binding */ navigateToBookedClaimPage),
/* harmony export */   navigateToClaimForm: () => (/* binding */ navigateToClaimForm)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/chunks/reloadTab */ "./src/app/utils/chunks/reloadTab.ts");
/* harmony import */ var _services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");










var makeSearchCode = function (_a, claimId) {
    var queryInput = _a.queryInput, searchButton = _a.searchButton;
    return "\n    console.log('input loaded!');\n    document.querySelector('".concat(queryInput, "').value = '").concat(claimId, "';\n    document.querySelector('").concat(searchButton, "').click();\n");
};
var toggleOrdersCode = function (_a) {
    var toggleLink = _a.toggleLink;
    return "\n    document.querySelector('".concat(toggleLink, "').click();\n");
};
function navigateToBookedClaimPage(tab, claimId, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
        .then(function () { return PreventPassportHiding(tab); });
}
var PreventPassportHiding = function (tab) {
    var PreventPassportHidingInternal = function () { return "\n        document.querySelectorAll('.passport').forEach(x => x.classList.remove('passport'));\n        document.querySelectorAll('.passport_block').forEach(x => x.classList.remove('passport_block'));\n    "; };
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.passport_block')
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: PreventPassportHidingInternal() }); });
};
function navigateToClaimForm(context) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[context.sourceId];
    var tab = context.tab;
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_1__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, '.tourists-tabs fieldset.panel'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_5__.stringifyFn)(claimFiller, context.data.touristDataItems) }); })
        .then(function () { return PreventPassportHiding(tab); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ claimId: context.claimNumber, operator: operator, errorText: null }); })
        .then(function () { return (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_6__.startTrackingIdSelector)(tab, '.claim'); })
        .then(function (response) { return (0,_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_9__.sendIdsToBookingCenter)(context.claimNumber, response.claimNo.replace(/(Заказ\s№)/, '')); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
        .then(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_8__.reloadTab)(context.sourceTab); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
        .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_4__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.FAIL, message: error.message }); });
}
function claimFiller(data) {
    console.log(data);
    window.scrollTo(document.querySelector('.tourists-tabs').offsetLeft, document.querySelector('.tourists-tabs').offsetTop);
    var touristBlocks = document.querySelectorAll('.tourists-tabs fieldset.panel');
    function setSexRadios(tourist, sexRadios) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                sexRadios[0].checked = true;
                break;
            case 2:
            case 4:
            case 6:
                sexRadios[1].checked = true;
                break;
        }
    }
    var setCitezenship = function (index, tourist) {
        var select = document.querySelector("select[name=\"frm[People][-".concat(index + 1, "][NATIONALITY]\"]"));
        var text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), function (option) {
            if (tourist.citizenship === option.value) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var script = document.createElement('script');
        var code = document.createTextNode("\n            var searchinp = document.querySelector('select[name=\"frm[People][-".concat(index + 1, "][NATIONALITY]\"] ~ div.chosen-container input')\n            var dropdown = document.querySelector('select[name=\"frm[People][-").concat(index + 1, "][NATIONALITY]\"] ~ div.chosen-container');\n            searchinp.value = \"").concat(text, "\";\n            dropdown.dispatchEvent(new Event('mousedown'));\n            $ = samo.jQuery;\n            $('select[name=\"frm[People][-").concat(index + 1, "][NATIONALITY]\"] ~ div.chosen-container li.highlighted').mouseup()\n        "));
        script.appendChild(code);
        (document.body || document.head).appendChild(script);
    };
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                element.value = touristField.value;
            }
        });
    };
    function isInfantTourist(tourist) {
        var _a = tourist.birthday.split('.'), day = _a[0], month = _a[1], year = _a[2];
        var ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
        var ageDate = new Date(ageDiffMs);
        return Math.abs(ageDate.getUTCFullYear() - 1970) < 2;
    }
    var infants = data.filter(function (t) { return isInfantTourist(t); });
    if (infants.length > 0) {
        var infantCheckBoxDiv = document.querySelector('.add_inf');
        var infantCheckbox = document.querySelectorAll('input.addinfant_cb')[0];
        if (infantCheckBoxDiv !== null && infantCheckBoxDiv.style['display'] !== 'none' && !infantCheckbox.checked) {
            infantCheckbox.click();
        }
    }
    Array.prototype.forEach.call(touristBlocks, function (block, index) {
        var tourist = data[index];
        if (!tourist) {
            return;
        }
        console.log(tourist);
        var touristFields = [{
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][LASTNAME]\"]"),
                value: tourist.surnameRus
                    ? tourist.surnameRus.toUpperCase()
                    : ''
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][FIRSTNAME]\"]"),
                value: tourist.nameRus
                    ? tourist.nameRus.toUpperCase()
                    : ''
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][LASTLNAME]\"]"),
                value: block.querySelector("input[name=\"frm[People][-".concat(index + 1, "][LASTNAME]\"]")) ?
                    tourist.surnameEng ? tourist.surnameEng.toUpperCase() : '' :
                    tourist.surname ? tourist.surname.toUpperCase() : ''
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][FIRSTLNAME]\"]"),
                value: block.querySelector("input[name=\"frm[People][-".concat(index + 1, "][FIRSTNAME]\"]")) ?
                    tourist.nameEng ? tourist.nameEng.toUpperCase() : '' :
                    tourist.name ? tourist.name.toUpperCase() : ''
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][BORN]\"]"),
                value: tourist.birthday
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PSERIE]\"]"),
                value: tourist.passportSeries
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PNUMBER]\"]"),
                value: tourist.passportNumber
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PVALID]\"]"),
                value: tourist.passportExpireDate
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PGIVEN]\"]"),
                value: tourist.passportDate
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][PGIVENORG]\"]"),
                value: tourist.passportIssueOrg
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][ADDRESS]\"]"),
                value: tourist.address
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][EMAIL]\"]"),
                value: tourist.email
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(index + 1, "][MOBILE]\"]"),
                value: tourist.phone
            }];
        handleTouristFields(block, touristFields);
        var sexRadios = block.querySelectorAll("input[name=\"frm[People][-".concat(index + 1, "][MALE]\"]"));
        setSexRadios(tourist, sexRadios);
        setCitezenship(index, tourist);
    });
}
function fillVisaForms(tab, data, claimNumber, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return fillVisaChain(tab, data.touristDataItems);
}
var fillVisaChain = function (tab, tourists) { return new Promise(function (resolve, reject) {
    return Promise.all(tourists.map(function (tourist, index) {
        return openVisaFillTab(tab, index)
            .then(function (ntab) {
            return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(ntab, '#ANKETA_FORM')
                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(ntab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_5__.stringifyFn)(fillCyprusVisa, { tourist: tourist }) }); });
        });
    })).then(function () { return resolve(0); });
}); };
var openVisaFillTab = function (tab, index) { return new Promise(function (resolve, reject) {
    var getVisaFillLink = function (index) { return "document.querySelectorAll('.tbl_peoples tr[id*=\"people\"]')[".concat(index, "].querySelector('.p_v_status a').href"); };
    chrome.tabs.executeScript(tab.id, { code: getVisaFillLink(index) }, function (result) {
        if (!result || !result[0]) {
            reject('Failed to get visafill link');
        }
        chrome.tabs.create({ url: result[0], active: false }, function (ntab) { return resolve(ntab); });
    });
}); };
var fillCyprusVisa = function (data) {
    var tourist = data.tourist;
    if (!tourist) {
        return;
    }
    var visa = tourist.visaForm;
    if (!visa) {
        return;
    }
    var block = document.querySelector('#ANKETA_FORM');
    if (!block) {
        return;
    }
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = touristField.value;
            }
        });
    };
    var touristFields = [{
            htmlElementSelector: "input[name*=\"[BirthPlace]\"]",
            value: visa.birthPlace
        }, {
            htmlElementSelector: "input[name*=\"[FatherName]\"]",
            value: visa.fatherName
        }, {
            htmlElementSelector: "input[name*=\"[MotherName]\"]",
            value: visa.motherName
        }];
    handleTouristFields(block, touristFields);
};


/***/ }),

/***/ "./src/app/operatorScripts/51.ts":
/*!***************************************!*\
  !*** ./src/app/operatorScripts/51.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaForms: () => (/* binding */ fillVisaForms),
/* harmony export */   navigateToBookedClaimPage: () => (/* binding */ navigateToBookedClaimPage),
/* harmony export */   navigateToClaimForm: () => (/* binding */ navigateToClaimForm)
/* harmony export */ });
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");










function navigateToBookedClaimPage(tab, claimId, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_3__.OPERATORS[sourceId];
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_0__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
        .then(function () { return PreventPassportHiding(tab); });
}
var PreventPassportHiding = function (tab) {
    var PreventPassportHidingInternal = function () { return "\n        document.querySelectorAll('.passport').forEach(x => x.classList.remove('passport'));\n        document.querySelectorAll('.passport_block').forEach(x => x.classList.remove('passport_block'));\n    "; };
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__.startTrackingElement)(tab, '.passport_block')
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__.executeScriptInTab)(tab, { code: PreventPassportHidingInternal() }); });
};
function navigateToClaimForm(context) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_3__.OPERATORS[context.sourceId];
    var tab = context.tab;
    return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_0__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__.startTrackingElement)(tab, '.peoples'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_5__.stringifyFn)(claimFiller, context.data.touristDataItems) }); })
        .then(function () { return PreventPassportHiding(tab); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ claimId: context.claimNumber, operator: operator, errorText: null }); })
        .then(function () { return (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_8__.startTrackingIdSelector)(tab, ''); })
        .then(function (response) { return (0,_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_9__.sendIdsToBookingCenter)(context.claimNumber, response.claimNo); })
        .then(function (response) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
        .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_6__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_7__.SendIdsStatus.FAIL, message: error.message }); });
}
function claimFiller(data) {
    var touristBlocks = document.querySelectorAll('.tourists-tabs .panel');
    window.scrollTo(0, 600);
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(function (touristItem) {
            var element = block.querySelector(touristItem.htmlElementSelector);
            if (element) {
                element.value = touristItem.value;
            }
        });
    }
    var setSexSelect = function (select, maleRadio, femaleRadio, tourist) {
        if (!select ||
            !maleRadio ||
            !femaleRadio ||
            select.options.length !== 3) {
            return;
        }
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                maleRadio.click();
                break;
            case 2:
            case 4:
            case 6:
                femaleRadio.click();
                break;
        }
        switch (tourist.touristType) {
            case 3:
            case 4:
                select.options[2].selected = true;
                break;
            case 5:
            case 6:
                break;
            case 1:
                select.options[0].selected = true;
                break;
            case 2:
                select.options[1].selected = true;
                break;
        }
    };
    var setCitezenship = function (index, tourist) {
        var select = document.querySelector("select[name=\"frm[People][-".concat(index + 1, "][NATIONALITY]\"]"));
        var text = undefined;
        Array.prototype.forEach.call(select.querySelectorAll('option'), function (option) {
            if (tourist.citizenship === option.value) {
                text = option.innerText;
            }
        });
        if (!text) {
            return;
        }
        var script = document.createElement('script');
        var code = document.createTextNode("\n            var searchinp = document.querySelector('select[name=\"frm[People][-".concat(index + 1, "][NATIONALITY]\"] ~ div.chosen-container input')\n            var dropdown = document.querySelector('select[name=\"frm[People][-").concat(index + 1, "][NATIONALITY]\"] ~ div.chosen-container');\n            searchinp.value = \"").concat(text, "\";\n            dropdown.dispatchEvent(new Event('mousedown'));\n            $ = samo.jQuery;\n            $('select[name=\"frm[People][-").concat(index + 1, "][NATIONALITY]\"] ~ div.chosen-container li.highlighted').mouseup()\n        "));
        script.appendChild(code);
        (document.body || document.head).appendChild(script);
    };
    Array.prototype.forEach.call(touristBlocks, function (block, index) {
        var tourist = data[index];
        var fieldIndex = index + 1;
        if (!tourist) {
            return;
        }
        var fields = [{
                htmlElementSelector: "input[name=\"frm[People][-".concat(fieldIndex, "][LASTLNAME]\"]"),
                value: tourist.surname
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(fieldIndex, "][FIRSTLNAME]\"]"),
                value: tourist.name
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(fieldIndex, "][BORN]\"]"),
                value: tourist.birthday
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(fieldIndex, "][PSERIE]\"]"),
                value: tourist.passportSeries
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(fieldIndex, "][PNUMBER]\"]"),
                value: tourist.passportNumber
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(fieldIndex, "][PVALID]\"]"),
                value: tourist.passportExpireDate
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(fieldIndex, "][PGIVEN]\"]"),
                value: tourist.passportDate
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(fieldIndex, "][PGIVENORG]\"]"),
                value: tourist.passportIssueOrg
            }, {
                htmlElementSelector: "input[name=\"frm[People][-".concat(fieldIndex, "][MOBILE]\"]"),
                value: tourist.phone ? '+7' + tourist.phone.slice(2) : ''
            }];
        var sexSelect = block.querySelector("select[name=\"frm[People][-".concat(fieldIndex, "][HUMAN]\"]"));
        var maleradio = block.querySelector("#SEX_M_-".concat(fieldIndex));
        var femaleradio = block.querySelector("#SEX_F_-".concat(fieldIndex));
        var citizenshipSelect = block.querySelector("select[name=\"frm[People][-".concat(fieldIndex, "][NATIONALITY]\"]"));
        var citizenshipContainer = block.querySelector("select[name=\"frm[People][-".concat(fieldIndex, "][NATIONALITY]\"] ~ .chosen-container"));
        handleTouristFields(fields, block);
        setSexSelect(sexSelect, maleradio, femaleradio, tourist);
        setCitezenship(index, tourist);
    });
}
/*visafill*/
function fillVisaForms(tab, data, claimNumber, sourceId) {
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__.startTrackingElement)(tab, '#cl_refer .resultset')
        .then(function () { return visaFillChain(tab, data.touristDataItems); });
}
var visaFillChain = function (tab, tourists) { return new Promise(function (resolve) {
    return Promise.all(tourists.map(function (tourist, index) { return new Promise(function (resolve) {
        return openVisaFillForm(tab, index)
            .then(function (ntab) { return new Promise(function (resolve) {
            return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__.startTrackingElement)(ntab, '#anketa #ANKETA_FORM')
                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__.executeScriptInTab)(ntab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_5__.stringifyFn)(fillTouristVisaForm, { tourist: tourist }) }); })
                .then(function () { return resolve({}); });
        }); })
            .then(function () { return resolve({}); });
    }); }))
        .then(function () { return resolve({}); });
}); };
var openVisaFillForm = function (tab, index) { return new Promise(function (resolve, reject) {
    var openVisaFillFormInternal = function (index) { return "document.querySelector('.resultset .tbl_peoples tbody :nth-child(".concat(index + 1, ") td.p_v_status a').href"); };
    chrome.tabs.executeScript(tab.id, { code: openVisaFillFormInternal(index) }, function (result) {
        if (!result || !result[0]) {
            reject('Failed to get visa form href');
        }
        (0,_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({ url: result[0], active: false })
            .then(function (tab) { return resolve(tab); });
    });
}); };
var fillTouristVisaForm = function (data) {
    if (!data.tourist) {
        return;
    }
    var visa = data.tourist.visaForm;
    if (!visa) {
        return;
    }
    var block = document.querySelector('#ANKETA_FORM');
    if (!block) {
        return;
    }
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = (touristField.value ? touristField.value : '');
            }
        });
    };
    var concatFullAddress = function (visa) {
        var addr = '';
        if (visa.city && visa.city !== 'NO') {
            addr += "".concat(visa.city, " ");
        }
        if (visa.street && visa.street !== 'NO') {
            addr += "".concat(visa.street, " ");
        }
        if (visa.building && visa.building !== 'NO') {
            addr += "".concat(visa.building, " ");
        }
        if (visa.block && visa.block !== 'NO') {
            addr += "".concat(visa.block, " ");
        }
        if (visa.appartment && visa.appartment !== 'NO') {
            addr += "".concat(visa.appartment, " ");
        }
        return addr;
    };
    var setMaritalStatus = function (select, visa) {
        if (!select) {
            return;
        }
        switch (visa.maritalStatus) {
            case 1:
                select.selectedIndex = 0;
                break;
            case 2:
                select.selectedIndex = 1;
                break;
            case 3:
                select.selectedIndex = 3;
                break;
            case 4:
                select.selectedIndex = 4;
                break;
        }
    };
    var setPreviousVisaCountry = function (select, index, visa) {
        if (!select) {
            return;
        }
        if (!visa.previosVisasInfoList || visa.previosVisasInfoList.length < index || index < 0) {
            return;
        }
        var countryName = visa.previosVisasInfoList[index].countryName.toLowerCase();
        Array.prototype.forEach.call(select.options, function (option) {
            if (option.text.toLowerCase() === countryName) {
                option.selected = true;
            }
        });
    };
    var setSponsorInfo = function (select, sponsorInput, visa) {
        if (!select) {
            return;
        }
        if (!sponsorInput) {
            return;
        }
        if (!visa.sponsorPersonName) {
            select.selectedIndex = 0;
            select.dispatchEvent(new Event('change'));
        }
        else {
            select.selectedIndex = 1;
            select.dispatchEvent(new Event('change'));
            sponsorInput.value = visa.sponsorPersonName ? visa.sponsorPersonName : '';
        }
    };
    var setPreviosVisasInput = function (input, visa) {
        if (!input) {
            return;
        }
        var schengenCountriesEngNameDict = [
            {
                key: 'греция',
                name: 'greece'
            }, {
                key: 'франция',
                name: 'france'
            }, {
                key: 'австрия',
                name: 'austria'
            }, {
                key: 'монако',
                name: 'monaco'
            }, {
                key: 'исландия',
                name: 'iceland'
            }, {
                key: 'андорра',
                name: 'andorra'
            }, {
                key: 'норвегия',
                name: 'norway'
            }, {
                key: 'швейцария',
                name: 'switzerland'
            }, {
                key: 'латвия',
                name: 'latvia'
            }, {
                key: 'литва',
                name: 'lithuania'
            }, {
                key: 'швеция',
                name: 'sweden'
            }, {
                key: 'словакия',
                name: 'slovakia'
            }, {
                key: 'чехия',
                name: 'czech republic'
            }, {
                key: 'финляндия',
                name: 'finland'
            }, {
                key: 'польша',
                name: 'poland'
            }, {
                key: 'италия',
                name: 'italy'
            }, {
                key: 'испания',
                name: 'spain'
            }, {
                key: 'бельгия',
                name: 'belgium'
            }, {
                key: 'германия',
                name: 'germany'
            }, {
                key: 'люксембург',
                name: 'luxembourg'
            }, {
                key: 'мальта',
                name: 'malta'
            }, {
                key: 'дания',
                name: 'denmark'
            }, {
                key: 'португалия',
                name: 'portugal'
            }, {
                key: 'эстония',
                name: 'estonia'
            }, {
                key: 'болгария',
                name: 'bulgaria'
            }, {
                key: 'нидерланды',
                name: 'netherlands'
            },
        ];
        var getEngName = function (key) { return schengenCountriesEngNameDict.filter(function (x) { return x.key === key.toLowerCase(); })[0].name; };
        input.value = visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
            ? visa.previosVisasInfoList
                .map(function (visa) { return "".concat(getEngName(visa.countryName), " ").concat(visa.validFrom.replace(/[.]/g, '/'), "-").concat(visa.validTo.replace(/[.]/g, '/')); })
                .reduce(function (x, y) { return x + '; ' + y; })
            : 'NO';
    };
    var touristFields = [{
            htmlElementSelector: 'input[name*="[Patronymic]"]',
            value: visa.patonomic
        }, {
            htmlElementSelector: 'input[name*="[BirthSurName]"]',
            value: visa.previosSurname
        }, {
            htmlElementSelector: 'input[name*="[BirthPlace]"]',
            value: visa.birthPlace
        }, {
            htmlElementSelector: 'input[name*="[Address_town]"]',
            value: visa.city
        }, {
            htmlElementSelector: 'input[name*="[Post]"]',
            value: visa.occupation
        }, {
            htmlElementSelector: 'input[name*="[Address]"]',
            value: concatFullAddress(visa)
        }, {
            htmlElementSelector: 'input[name*="[Phone]"]',
            value: visa.mobilePhoneNumber
        }, {
            htmlElementSelector: 'input[name*="[Email]"]',
            value: visa.email
        }, {
            htmlElementSelector: 'input[name*="[EmployerName]"]',
            value: visa.employer
        }, {
            htmlElementSelector: 'input[name*="[EmployerAddress]"]',
            value: visa.jobCompanyAddress
        }, {
            htmlElementSelector: 'input[name*="[EmployerPhone]"]',
            value: visa.jobPhoneNumber
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenVisaNumber1]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
                ? visa.previosVisasInfoList[0].number
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateFrom1]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
                ? visa.previosVisasInfoList[0].validFrom
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateTo1]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
                ? visa.previosVisasInfoList[0].validTo
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenVisaNumber2]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 1
                ? visa.previosVisasInfoList[1].number
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateFrom2]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 1
                ? visa.previosVisasInfoList[1].validFrom
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateTo2]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 1
                ? visa.previosVisasInfoList[1].validTo
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenVisaNumber3]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 2
                ? visa.previosVisasInfoList[2].number
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateFrom3]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 2
                ? visa.previosVisasInfoList[2].validFrom
                : ''
        }, {
            htmlElementSelector: 'input[name*="[PreviousShengenDateTo3]"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length > 2
                ? visa.previosVisasInfoList[2].validTo
                : ''
        }, {
            htmlElementSelector: 'input[name*="[RPSerie]"]',
            value: visa.passportSeries
        }, {
            htmlElementSelector: 'input[name*="[RPNumber]"]',
            value: visa.passportNumber
        }];
    handleTouristFields(block, touristFields);
    setMaritalStatus(document.querySelector('select[name*="[MaritalStatus]"]'), visa);
    setPreviousVisaCountry(document.querySelector('select[name*="[PreviousShengen_Country]"]'), 0, visa);
    setPreviousVisaCountry(document.querySelector('select[name*="[PreviousShengen1_Country]"]'), 1, visa);
    setPreviousVisaCountry(document.querySelector('select[name*="[PreviousShengen2_Country]"]'), 2, visa);
    setSponsorInfo(document.querySelector('select[name*="[WhoPaying]"] , select[name*="[WhoIsPaying]"]'), document.querySelector('input[name*="[eWhoPaying]"] , input[name*="[WhoIsPayingOther]"]'), visa);
    setPreviosVisasInput(document.querySelector('input[name*="[PreviousShengen]"]'), visa);
};


/***/ }),

/***/ "./src/app/operatorScripts/6.ts":
/*!**************************************!*\
  !*** ./src/app/operatorScripts/6.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaForms: () => (/* binding */ fillVisaForms),
/* harmony export */   navigateToBookedClaimPage: () => (/* binding */ navigateToBookedClaimPage),
/* harmony export */   navigateToClaimForm: () => (/* binding */ navigateToClaimForm)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _utils_tabs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/reloadTab */ "./src/app/utils/chunks/reloadTab.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _utils_chunks_unifyTouristIdenify__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/chunks/unifyTouristIdenify */ "./src/app/utils/chunks/unifyTouristIdenify.ts");












var makeSearchCode = function (_a, claimId) {
    var queryInput = _a.queryInput, searchButton = _a.searchButton;
    return "\n    console.log('input loaded!');\n    document.querySelector('".concat(queryInput, "').value = '").concat(claimId, "';\n    document.querySelector('").concat(searchButton, "').click();\n");
};
var toggleOrdersCode = function (_a) {
    var toggleLink = _a.toggleLink;
    return "\n    document.querySelector('".concat(toggleLink, "').click();\n");
};
function navigateToBookedClaimPage(tab, claimId, sourceId, navigateUrl) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    var sourceUrl = tab.url;
    return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({ url: 'http://auth.coral.ru/', cookieNames: ['AUTHENTICATION_COOKIE'] })
        .then(function () { return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({ url: 'https://online.coral.ru', cookieNames: ['userInfo', 'ASP.NET_SessionId', 'BIGipServeronline_coral.app~online_coral_pool'] }); })
        .then(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_5__.reloadTab)(tab); })
        .then(function () { return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPage)(tab, operator, operator.credentials.packet); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, '#menuTD .eeo :nth-child(4) li a'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, { code: 'document.querySelector(\'#menuTD .eeo :nth-child(4) li a\').click()' }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, '#ctl00_ContentPlaceHolder1_txtVoucherNo_I'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, {
        code: makeSearchCode({
            queryInput: operator.selectors.queryInput,
            searchButton: operator.selectors.searchButton
        }, claimId)
    }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, "#col_ID_".concat(claimId)); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, { code: toggleOrdersCode({ toggleLink: "img[onclick*=\"".concat(claimId, "\"]") }) }); });
}
function navigateToClaimForm(context) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[context.sourceId];
    var tab = context.tab;
    var sourceUrl = tab.url;
    if (tab.url && tab.url.toLowerCase().indexOf('search.aspx') !== -1) {
        return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({ url: 'http://auth.coral.ru/', cookieNames: ['AUTHENTICATION_COOKIE'] })
            .then(function () { return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({ url: 'https://online.coral.ru', cookieNames: ['userInfo', 'ASP.NET_SessionId', 'BIGipServeronline_coral.app~online_coral_pool'] }); })
            .then(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_5__.reloadTab)(tab); })
            .then(function () { return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPage)(tab, operator, operator.credentials.packet); })
            .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, '#packageSearchTR'); })
            .then(function () { return (0,_utils_tabs__WEBPACK_IMPORTED_MODULE_2__.updateTab)(tab.id, { url: sourceUrl }); })
            .then(function () { return new Promise(function (resolve, reject) {
            var sourceTab = tab;
            var updatedLiscener = function (tabId, changeInfo, tab) {
                if (changeInfo.status === 'complete' && tabId !== sourceTab.id && sourceTab.id === tab.openerTabId) {
                    if (/^.*online\.coral\.ru\/UI\/Package\/Reservation.*$/gm.test(tab.url)) {
                        (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, '#resTable')
                            .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_7__.stringifyFn)(claimFiller, { tourists: context.data.touristDataItems }) }); })
                            .then(function () { return (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_8__.startTrackingIdSelector)(tab, 'body table.int tr:nth-child(3) td:nth-child(2)'); })
                            .then(function () { return resolve(0); });
                    }
                }
            };
            chrome.tabs.onUpdated.addListener(updatedLiscener);
            var removedLiscener = function (tabId, removeInfo) {
                if (tabId === sourceTab.id) {
                    chrome.tabs.onUpdated.removeListener(updatedLiscener);
                    chrome.tabs.onRemoved.removeListener(removedLiscener);
                }
            };
            chrome.tabs.onRemoved.addListener(removedLiscener);
        }); })
            .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_9__.createPushNotification)({ claimId: context.claimNumber, operator: operator, errorText: null }); })
            .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_9__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_10__.SendIdsStatus.FAIL, message: error.message }); });
    }
    if (tab.url && tab.url.toLowerCase().indexOf('reservation.aspx') !== -1) {
        return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPage)(tab, operator, operator.credentials.packet)
            .then(function () { return (0,_utils_tabs__WEBPACK_IMPORTED_MODULE_2__.updateTab)(tab.id, { url: sourceUrl }); })
            .then(function () { return new Promise(function (resolve, reject) {
            var sourceTab = tab;
            var updatedLiscener = function (tabId, changeInfo, tab) {
                if (changeInfo.status === 'complete' && sourceTab.id === tab.id) {
                    if (/^.*online\.coral\.ru\/UI\/Package\/Reservation.*$/gm.test(tab.url)) {
                        (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, '#resTable')
                            .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_7__.stringifyFn)(claimFiller, { tourists: context.data.touristDataItems }) }); })
                            .then(function () { return (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_8__.startTrackingIdSelector)(tab, 'body table.int tr:nth-child(3) td:nth-child(2)'); })
                            .then(function () { return resolve(0); });
                    }
                }
            };
            chrome.tabs.onUpdated.addListener(updatedLiscener);
            var removedLiscener = function (tabId, removeInfo) {
                if (tabId === sourceTab.id) {
                    chrome.tabs.onUpdated.removeListener(updatedLiscener);
                    chrome.tabs.onRemoved.removeListener(removedLiscener);
                }
            };
            chrome.tabs.onRemoved.addListener(removedLiscener);
        }); })
            .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_9__.createPushNotification)({ claimId: context.claimNumber, operator: operator, errorText: null }); })
            .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_9__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_10__.SendIdsStatus.FAIL, message: error.message }); });
    }
    return new Promise(function (resolve, reject) { return resolve(); });
}
function claimFiller(data) {
    console.log(data.tourists);
    window.scroll(document.querySelector('#resTable').clientHeight / 2, document.querySelector('#resTable').clientHeight / 2);
    var touristBlocks = document.querySelectorAll('.resTouristAdultTable, .resTouristChildTable');
    function setSexRadios(tourist, sexRadios) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                sexRadios[1].checked = true;
                break;
            case 2:
            case 4:
            case 6:
                sexRadios[0].checked = true;
                break;
        }
    }
    console.log(touristBlocks);
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = touristField.value;
            }
        });
    }
    Array.prototype.forEach.call(touristBlocks, function (block, index) {
        var tourist = data.tourists[index];
        if (!tourist) {
            return;
        }
        var touristFields = [{
                htmlElementSelector: 'input[id*="_surname"]',
                value: tourist.surname.toUpperCase()
            }, {
                htmlElementSelector: 'input[id*="_name"]',
                value: tourist.name.toUpperCase()
            }, {
                htmlElementSelector: 'input[id*="_birthday"]',
                value: tourist.birthday
            }, {
                htmlElementSelector: 'input[id*="_phoneNumber"]',
                value: tourist.phone
            }, {
                htmlElementSelector: 'input[id*="_passportSerialNumber',
                value: tourist.passportSeries
            }, {
                htmlElementSelector: 'input[id*="_passportNo',
                value: tourist.passportNumber
            }, {
                htmlElementSelector: 'input[id*="_passportExpiryDate',
                value: tourist.passportExpireDate
            }, {
                htmlElementSelector: 'input[id*="_passportBeginDate',
                value: tourist.passportDate
            }, {
                htmlElementSelector: 'input[id*="_passportGivenBy',
                value: (tourist.passportIssueOrg || 'FMS').toUpperCase()
            }, {
                htmlElementSelector: 'input[id*="_addressInfo"]',
                value: tourist.address
            }];
        handleTouristFields(block, touristFields);
        var sexRadios = block.querySelectorAll('input[id*="_gender"]');
        setSexRadios(tourist, sexRadios);
        var citizeshipSelect = block.querySelector("select[id*=\"_nationality_SEL");
        Array.prototype.forEach.call(citizeshipSelect.querySelectorAll('option'), function (option) {
            if (tourist.citizenship && tourist.citizenship.toLowerCase() === option.value.toLowerCase()) {
                option.selected = true;
            }
        });
    });
}
/*visa*/
function fillVisaForms(tab, data, claimNumber, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, 'td[data-columnname="visaStatus"] a')
        .then(function () { return visaFillChain(tab, data.touristDataItems); });
}
var visaFillChain = function (tab, tourists) {
    return new Promise(function (resolve) {
        var chain = new Promise(function (resolve, reject) { return resolve(); });
        tourists.forEach(function (tourist, index) {
            if (tourist.visaForm !== null) {
                chain = chain
                    .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_7__.stringifyFn)(openVisaTab, []) }); })
                    .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, '#tab2', '#eaglePopupWindow-wrap iframe'); })
                    .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_7__.stringifyFn)(openVisaRequestTab, []) }); })
                    .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, 'tr[id^="VisaSchengenList"]', '#eaglePopupWindow-wrap iframe'); })
                    .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_7__.stringifyFn)(openVisaForm, { index: index }) }); })
                    .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, 'form[name="form1"]', '#eaglePopupWindow-wrap iframe'); })
                    .then(function () { return identifyTourist(tourists, tab); })
                    .then(function (idTourist) { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_7__.stringifyFn)(fillVisaForm, { tourist: idTourist }) }); })
                    .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElementDisappear)(tab, '#eaglePopupWindow-outer'); });
            }
        });
    });
};
var getTouristVisaInfo = function (tab) { return new Promise(function (resolve, reject) {
    var getTouristField = function (fieldname) { return "\n        document.querySelector('#eaglePopupWindowFrame').contentWindow.document.body.querySelector('#".concat(fieldname, "').innerText\n    "); };
    chrome.tabs.executeScript(tab.id, { code: getTouristField('TouristInfoSurname') }, function (result) {
        var surname = result[0];
        chrome.tabs.executeScript(tab.id, { code: getTouristField('TouristInfoName') }, function (result) {
            var name = result[0];
            chrome.tabs.executeScript(tab.id, { code: getTouristField('TouristInfoBirthday') }, function (result) {
                var birthdate = result[0];
                resolve({
                    name: name,
                    surname: surname,
                    dateOfBirth: birthdate,
                });
            });
        });
    });
}); };
var identifyTourist = function (tourists, tab) { return new Promise(function (resolve, reject) {
    return getTouristVisaInfo(tab)
        .then(function (idInfo) { return (0,_utils_chunks_unifyTouristIdenify__WEBPACK_IMPORTED_MODULE_11__.unifyTouristIdenify)(tourists, idInfo); })
        .then(function (tourist) { return resolve(tourist); });
}); };
var openVisaTab = function () {
    var visaLnk = document.querySelector('td[data-columnname="visaStatus"] a');
    if (!visaLnk) {
        return;
    }
    visaLnk.click();
};
var openVisaRequestTab = function () {
    var frm = document.querySelector('#eaglePopupWindow-wrap iframe');
    if (!frm) {
        return;
    }
    var tab = frm.contentWindow.document.body.querySelector('#updTabs #tab2');
    if (!tab) {
        return;
    }
    tab.click();
};
var openVisaForm = function (data) {
    var frm = document.querySelector('#eaglePopupWindow-wrap iframe');
    if (!frm) {
        return;
    }
    var trs = frm.contentWindow.document.body.querySelectorAll('#cbpContent2_cbpContent2_result tr[class^="dxgvDataRow"]');
    if (trs.length <= data.index) {
        return;
    }
    var tr = trs[data.index];
    var lnk = tr.querySelector('td[id^="col_hasSchengen"] a');
    if (!lnk) {
        return;
    }
    lnk.click();
};
var fillVisaForm = function (data) {
    var tourist = data.tourist;
    var visa = tourist.visaForm;
    if (!visa) {
        return;
    }
    var frm = document.querySelector('#eaglePopupWindow-wrap iframe');
    if (!frm) {
        return;
    }
    var block = frm.contentWindow.document.body.querySelector('form[name="form1"]');
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = touristField.value;
                element.dispatchEvent(new Event('change'));
            }
        });
    }
    var concatFullAddress = function (visa) {
        var addr = '';
        if (visa.city && visa.city !== 'NO') {
            addr += "".concat(visa.city, " ");
        }
        if (visa.street && visa.street !== 'NO') {
            addr += "".concat(visa.street, " ");
        }
        if (visa.building && visa.building !== 'NO') {
            addr += "".concat(visa.building, " ");
        }
        if (visa.block && visa.block !== 'NO') {
            addr += "".concat(visa.block, " ");
        }
        if (visa.appartment && visa.appartment !== 'NO') {
            addr += "".concat(visa.appartment, " ");
        }
        return addr;
    };
    var setMaritalStatus = function (select) {
        if (!select) {
            return;
        }
        switch (visa.maritalStatus) {
            case 1:
                select.selectedIndex = 0;
                break;
            case 2:
                select.selectedIndex = 1;
                break;
            case 3:
                select.selectedIndex = 2;
                break;
            case 4:
                select.selectedIndex = 3;
                break;
            default: break;
        }
    };
    var setVisaType = function (select) {
        if (!select) {
            return;
        }
        if (!visa.visaRepeatedType) {
            return;
        }
        if (visa.visaRepeatedType.toLowerCase() === 'однократная') {
            select.selectedIndex = 1;
        }
        else {
            select.selectedIndex = 2;
        }
    };
    var setBiometryTake = function (yOption, nOption) {
        if (!yOption) {
            return;
        }
        if (!nOption) {
            return;
        }
        if (visa.biometryTakedate) {
            yOption.click();
        }
        else {
            nOption.click();
        }
    };
    var setPreviousVisa = function (countySelect, yearSelect, pvisa) {
        if (!visa.previosVisasInfoList) {
            return;
        }
        if (!pvisa) {
            return;
        }
        // filter visas older 3yrs
        var year = parseInt(pvisa.validFrom.split('.').slice(-1)[0], 10);
        if ((new Date()).getFullYear() - year > 3) {
            return;
        }
        Array.prototype.forEach.call(countySelect.options, function (option, index) {
            console.log("".concat(option.text.toLowerCase(), " - ").concat(pvisa.countryName.toLowerCase()));
            if (option.text.toLowerCase() === pvisa.countryName.toLowerCase()) {
                option.selected = true;
            }
        });
        Array.prototype.forEach.call(yearSelect.options, function (option, index) {
            if (option.value.toLowerCase() === year.toString().toLowerCase()) {
                option.selected = true;
            }
        });
    };
    var touristFields = [{
            htmlElementSelector: '#cbMaidenName',
            value: visa.previosSurname,
        }, {
            htmlElementSelector: '#cbBirthPlace',
            value: visa.birthPlace,
        }, {
            htmlElementSelector: '#txtWorkAddress',
            value: visa.jobCompanyAddress,
        }, {
            htmlElementSelector: '#cbHomeAddress',
            value: concatFullAddress(visa),
        }, {
            htmlElementSelector: '#cbPhoneNumber',
            value: visa.mobilePhoneNumber,
        }, {
            htmlElementSelector: '#cbCompanyName',
            value: visa.employer,
        }, {
            htmlElementSelector: '#cbCompanyPlace',
            value: visa.jobCompanyAddress,
        }, {
            htmlElementSelector: '#cbCompanyPhone',
            value: visa.jobPhoneNumber,
        }, {
            htmlElementSelector: '#txtPayer',
            value: visa.escortPersonName,
        }, {
            htmlElementSelector: '#txtPalceCity',
            value: visa.city,
        }, {
            htmlElementSelector: '#cbFatherName',
            value: visa.fatherName,
        }, {
            htmlElementSelector: '#cbMotherName',
            value: visa.motherName,
        }, {
            htmlElementSelector: '#cbCompanyNameAndPosition',
            value: "".concat(visa.employer, " ").concat(visa.occupation),
        },];
    handleTouristFields(block, touristFields);
    setMaritalStatus(block.querySelector('#cbMaritalStatus_SEL'));
    setVisaType(block.querySelector('#VisaEntryType_SEL'));
    setBiometryTake(block.querySelector('#cbFingerprintSuppliedBefore_0'), block.querySelector('#cbFingerprintSuppliedBefore_1'));
    if (visa.previosVisasInfoList) {
        visa.previosVisasInfoList.forEach(function (pvisa, index) {
            setPreviousVisa(block.querySelector("#cbLatestSchengenVisas".concat(index + 1, "country select")), block.querySelector("#cbLatestSchengenVisas".concat(index + 1, "year select")), pvisa);
        });
    }
};


/***/ }),

/***/ "./src/app/operatorScripts/7.ts":
/*!**************************************!*\
  !*** ./src/app/operatorScripts/7.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaForms: () => (/* binding */ fillVisaForms),
/* harmony export */   navigateToBookedClaimPage: () => (/* binding */ navigateToBookedClaimPage),
/* harmony export */   navigateToClaimForm: () => (/* binding */ navigateToClaimForm)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _utils_cookie__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/cookie */ "./src/app/utils/cookie.ts");
/* harmony import */ var _utils_tourist__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/tourist */ "./src/app/utils/tourist.ts");
/* harmony import */ var _utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_injectFunctionIntoPage__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/chunks/injectFunctionIntoPage */ "./src/app/utils/chunks/injectFunctionIntoPage.ts");
/* harmony import */ var _utils_tabs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../utils/chunks/reloadTab */ "./src/app/utils/chunks/reloadTab.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _utils_chunks_unifyTouristIdenify__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../utils/chunks/unifyTouristIdenify */ "./src/app/utils/chunks/unifyTouristIdenify.ts");
/* harmony import */ var _utils_executives__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../utils/executives */ "./src/app/utils/executives.ts");
/* harmony import */ var _services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");
/* harmony import */ var _utils_chunks_setSessionStorageKeyInTab__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../utils/chunks/setSessionStorageKeyInTab */ "./src/app/utils/chunks/setSessionStorageKeyInTab.ts");
/* harmony import */ var _utils_chunks_startTrackingElementByProp__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementByProp */ "./src/app/utils/chunks/startTrackingElementByProp.ts");
/* harmony import */ var _models_chunks_bookingCompany__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../models/chunks/bookingCompany */ "./src/app/models/chunks/bookingCompany.ts");




















var bgAuthUrl = 'https://login.bgoperator.ru/';
function removeCookieAuthAndNavigate(navigateUrl, operator) {
    var curTab;
    return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_3__.removeCookies)({ url: bgAuthUrl, cookieNames: operator.cookie.auth })
        .then(function () { return (0,_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({ active: true, url: bgAuthUrl, windowId: chrome.windows.WINDOW_ID_CURRENT }); })
        .then(function (createdTab) {
        curTab = createdTab;
        return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_5__.navigateToClaimPage)(curTab, operator, operator.credentials.packet);
    })
        .then(function () { return (0,_utils_cookie__WEBPACK_IMPORTED_MODULE_1__.startTrackingCookie)({ url: bgAuthUrl, cookieName: 'L' }); })
        .then(function () { return (0,_utils_tabs__WEBPACK_IMPORTED_MODULE_8__.updateTab)(curTab.id, { url: navigateUrl }); })
        .then(function () { return Promise.resolve(curTab); });
}
function navigateToBookedClaimPage(tab, claimId, sourceId, navigateUrl, autofillData, claimDetails) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    var curTab;
    var innerBgClaimId = null;
    return removeCookieAuthAndNavigate(navigateUrl, operator)
        .then(function (tab) {
        curTab = tab;
        return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(curTab, '#reqlist');
    })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(curTab, '#rcmrow1>td'); })
        .then(function (response) {
        var div = document.createElement('div');
        div.innerHTML = response.innerHTML;
        var a = div.querySelector('a');
        if (a !== null) {
            if (a.text !== '' && a.text === claimId) {
                if (a.href && a.href !== '') {
                    var regResult = a.href.match(/tozaya\?idTour=(\d*)/);
                    if (regResult !== null && regResult.length >= 1) {
                        innerBgClaimId = regResult[1];
                    }
                }
            }
        }
        return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(curTab, {
            code: "\n                    var link = document.querySelector(\"#rcmrow1 a\");\n                    if(link !== null) {\n                        link.removeAttribute(\"target\");\n                        link.click();\n                    }\n                "
        });
    })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(curTab, '#Form'); })
        .then(function (response) {
        var div = document.createElement('div');
        div.innerHTML = response.innerHTML;
        var hiddenIdTour = div.querySelector('#idTour');
        // весь этот ад ради hiddenIdTour.value === innerBgClaimId, чтобы точно знать что мы на правильной странице правильной заявки
        if (innerBgClaimId && hiddenIdTour && hiddenIdTour.value === innerBgClaimId) {
            return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(curTab, {
                code: "\n                        (".concat(insertViewInListToDOM, ")(").concat(claimId, ", ").concat(getNBlock(claimDetails.travelDate), ");\n                        ").concat((0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__.stringifyFn)(fixPdfReportsLinks, []), "\n                    ")
            });
        }
        else {
            return new Promise(function (resolve, reject) { return reject(); });
        }
    })
        .then(function () {
        return (0,_utils_chunks_setSessionStorageKeyInTab__WEBPACK_IMPORTED_MODULE_17__.setSessionStorageKeyInTab)(curTab, 'autofill-data', JSON.stringify(autofillData));
    });
}
// Поправляем ссылки на пдф документы по заявке с относительных на абсолютные
// В противном случае хром блокирет загрузку документов
var fixPdfReportsLinks = function () {
    var elements = document.querySelectorAll('a.tour_is_ready-btn');
    Array.prototype.forEach.call(elements, function (el) {
        var href = el.getAttribute('href');
        el.setAttribute('href', "https://www.bgoperator.ru/".concat(href));
    });
};
// Устанавливает на страницу БГ кнопку просмотра заявки в списке
var insertViewInListToDOM = function (claimId, block) {
    // проверка, чтобы не добавить кнопку дважды
    if (!document.querySelector('#autofillViewClaimInList')) {
        var parent_1 = document.querySelector('#tourtype');
        var target = parent_1.parentElement;
        target.innerHTML += "\n            <div id=\"autofillViewClaimInList\" style=\"display:inline-block; margin-left: 10px; cursor:pointer\">\n                <a style=\"background-color:#0984e3; color:#dfe6e9; padding: 8px; border: 0; border-radius:5px; cursor: pointer;\"\n                    href=\"/spis?block=".concat(block, "&nrequest=").concat(claimId, "\">\n                    <b>\u0412 \u0441\u043F\u0438\u0441\u043A\u0435 \u0437\u0430\u044F\u0432\u043E\u043A</b>\n                </a>\n            </div>\n        ");
    }
};
// формирует номер блока (расчетного) периода в формате YYMMDD, возвращает 0 для текущего блока
var getNBlock = function (date) {
    var formatNumberLength = function (num, length) {
        var r = num.toString();
        while (r.length < length) {
            r = '0' + r;
        }
        return r;
    };
    var month = parseInt(date.match(/[0-9]+\.([0-9]+)\.[0-9]+/i)[1], 10);
    var year = parseInt(date.match(/[0-9]+\.[0-9]+\.([0-9]+)/i)[1], 10);
    var now = new Date();
    var nowYear = now.getFullYear();
    var nowMonth = now.getMonth();
    return nowYear >= year && nowMonth >= month
        ? "".concat(year.toString().substr(2, 2)).concat(formatNumberLength(month, 2), "01")
        : '0';
};
function navigateToClaimForm(context) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[context.sourceId];
    var curTab;
    return removeCookieAuthAndNavigate(context.navigateUrl, operator)
        .then(function (tab) {
        curTab = tab;
        return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(curTab, '#Form .form-block.passengers');
    })
        .then(function () { return (0,_utils_chunks_setSessionStorageKeyInTab__WEBPACK_IMPORTED_MODULE_17__.setSessionStorageKeyInTab)(curTab, 'autofill-data', JSON.stringify(context.autofillData)); })
        .then(function () { return createAccountWarning(curTab); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(curTab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__.stringifyFn)(claimFiller, { tourists: context.data.touristDataItems }) }); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_11__.createPushNotification)({ claimId: context.claimNumber, operator: operator, errorText: null }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementByProp__WEBPACK_IMPORTED_MODULE_18__.startTrackingElementByProp)(curTab, '.claim_no', 'innerText', function (prop) { return prop && prop[0] === '1'; }); })
        .then(function (claimNo) { return (0,_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_16__.sendIdsToBookingCenter)(context.claimNumber, claimNo); })
        .then(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_12__.reloadTab)(context.sourceTab); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_11__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_13__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
        .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_11__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_13__.SendIdsStatus.FAIL, message: error.message }); });
}
function claimFiller(data) {
    var touristsBlock = document.querySelector('#Form .form-block.passengers');
    console.log('TOURISTS?', touristsBlock);
    var touristSets = touristsBlock.querySelectorAll('table tbody tr');
    console.log('SETS?', touristSets);
    var hintChildInfant = function (type, date) {
        var _a = date.split('.'), day = _a[0], month = _a[1], year = _a[2];
        var birthDate = new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10));
        var yearDiff = new Date(Date.now() - birthDate.valueOf()).getFullYear() - 1970;
        return yearDiff > 2 ? type - 2 : type;
    };
    var setTouristType = function (tourist, titulSelectOptions, sexSelectOptions) {
        var touristType = tourist.touristType, birthday = tourist.birthday;
        switch (touristType) {
            case 1:
                titulSelectOptions[0].selected = true;
                sexSelectOptions[0].selected = true;
                break;
            case 2:
                titulSelectOptions[1].selected = true;
                sexSelectOptions[1].selected = true;
                break;
            case 3:
                titulSelectOptions[2].selected = true;
                sexSelectOptions[0].selected = true;
                break;
            case 4:
                titulSelectOptions[2].selected = true;
                sexSelectOptions[1].selected = true;
                break;
            case 5:
                if (touristType - hintChildInfant(touristType, birthday) === 2) {
                    titulSelectOptions[2].selected = true;
                }
                else {
                    titulSelectOptions[3].selected = true;
                }
                sexSelectOptions[0].selected = true;
                break;
            case 6:
                if (touristType - hintChildInfant(touristType, birthday) === 2) {
                    titulSelectOptions[2].selected = true;
                }
                else {
                    titulSelectOptions[3].selected = true;
                }
                sexSelectOptions[1].selected = true;
                break;
            default:
                break;
        }
    };
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element && touristField.value) {
                element.value = touristField.value;
            }
        });
    }
    Array.prototype.forEach.call(touristSets, function (set, index) {
        var indexInc = index + 1;
        var tourist = data.tourists[index];
        var titulSelect = set.querySelector("#titul".concat(indexInc));
        var titulSelectOptions = titulSelect.querySelectorAll('option');
        var sexSelect = set.querySelector("#sex".concat(indexInc));
        var sexSelectOptions = sexSelect.querySelectorAll('option');
        var citizenshipSelect = set.querySelector("select[name=\"t_1000333_".concat(indexInc, "\"]"));
        var citizenshipSelectOptions = citizenshipSelect.querySelectorAll('option');
        setTouristType(tourist, titulSelectOptions, sexSelectOptions);
        // диспатчим ивенты на селекте, чтобы выбранная опция успешно сохранялась
        if (titulSelect) {
            titulSelect.dispatchEvent(new Event('change'));
            titulSelect.dispatchEvent(new Event('input'));
        }
        if (sexSelect) {
            sexSelect.dispatchEvent(new Event('change'));
            sexSelect.dispatchEvent(new Event('input'));
        }
        Array.prototype.forEach.call(citizenshipSelectOptions, function (option, index) {
            if (option.value === tourist.citizenship) {
                option.selected = true;
            }
        });
        var touristFields = [{
                htmlElementSelector: "input[name=\"t_1000152_".concat(indexInc, "\"]"),
                value: tourist.birthday
            }, {
                htmlElementSelector: "input[name=\"t_1000144_".concat(indexInc, "\"]"),
                value: tourist.surname
            }, {
                htmlElementSelector: "input[name=\"t_1000146_".concat(indexInc, "\"]"),
                value: tourist.name
            }, {
                htmlElementSelector: "input[name=\"t_1000147_".concat(indexInc, "\"]"),
                value: tourist.middlename
            }, {
                htmlElementSelector: "input[name=\"t_1000153_".concat(indexInc, "\"]"),
                value: tourist.phone
            }, {
                htmlElementSelector: "input[name=\"t_1000156_".concat(indexInc, "\"]"),
                value: tourist.email
            }, {
                htmlElementSelector: "input[name=\"t_1001446_".concat(indexInc, "\"]"),
                value: tourist.passportSeries
            }, {
                htmlElementSelector: "input[name=\"t_1001447_".concat(indexInc, "\"]"),
                value: tourist.passportNumber
            }, {
                htmlElementSelector: "input[name=\"t_1001449_".concat(indexInc, "\"]"),
                value: tourist.passportExpireDate
            }];
        handleTouristFields(set, touristFields);
    });
}
function fillVisaForms(tab, data, claimNumber, sourceId) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    if (data.countryTo === 'Кипр') {
        return fillCyprusVisaForms(tab, data, claimNumber, sourceId);
    }
    else if (data.countryTo === 'Болгария') {
        return fillBulgariaVisaForms(tab, data);
    }
    else {
        return fillSchengenVisaForms(tab, data, claimNumber, sourceId);
    }
}
var fillSchengenVisaForms = function (tab, data, claimNumber, sourceId) {
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, '#Form')
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__.stringifyFn)(openSchengenBlank, []) }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, '#Form > .aCenter'); })
        .then(function () { return visaSchengenFillChain(tab, (0,_utils_tourist__WEBPACK_IMPORTED_MODULE_2__.GetAllTouristsInPackage)(data)); });
};
var openSchengenBlank = function () {
    var btn = document.querySelector('.buttons a.tour_is_ready-btn[target="_self"]');
    if (!btn) {
        return;
    }
    btn.click();
};
var visaSchengenFillChain = function (tab, tourists) {
    return new Promise(function (resolve) {
        getAllVisaFormsLinks(tab)
            .then(function (links) {
            links.forEach(function (lnk) {
                (0,_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({ active: false, url: lnk })
                    .then(function (tab) {
                    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, 'form tbody')
                        .then(function () { return identifyTouristSchengen(tourists, tab); })
                        .then(function (idTourist) { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__.stringifyFn)(fillSchengenVisa, { tourist: idTourist }) }); });
                });
            });
        }).then(function () { return resolve(0); });
    });
};
var getAllVisaFormsLinks = function (tab) { return new Promise(function (resolve, reject) {
    var getAllVisaFormsLinksInternal = function () { return "\n        Array.prototype.map.call(Array.prototype.filter.call(document.querySelectorAll('tr.lGray ~ tr td a , #Form table[rules=\"none\"] td a'), function(x) { return ['\u043F\u0440\u043E\u0441\u043C\u043E\u0442\u0440', '\u0437\u0430\u043F\u043E\u043B\u043D\u0438\u0442\u044C \u0430\u043D\u043A\u0435\u0442\u0443'].indexOf(x.innerText.toLowerCase()) !== -1;}), function (x) { return x.href} );\n    "; };
    chrome.tabs.executeScript(tab.id, { code: getAllVisaFormsLinksInternal() }, function (result) {
        if (!result[0]) {
            reject('Error to get visa form links');
            return;
        }
        resolve(result[0]);
    });
}); };
var getTouristVisaInfo = function (tab) { return new Promise(function (resolve, reject) {
    var getTouristField = function (fieldname, fieldnameEng) { return "\n        var s = Array.prototype.filter.call(document.querySelectorAll('td'), function(x) {return x.innerText.toLowerCase().indexOf('".concat(fieldname, "') !== -1;})[0];\n        var inp = document.querySelector('input[name=\"").concat(fieldnameEng, "\"]');\n        if (inp) {\n            inp.value\n        } else {\n            s.parentElement.querySelector(':nth-child(2)').innerText\n        }\n    "); };
    chrome.tabs.executeScript(tab.id, { code: getTouristField('фамилия', 'surname') }, function (result) {
        var surname = result[0];
        chrome.tabs.executeScript(tab.id, { code: getTouristField('имя', 'name') }, function (result) {
            var name = result[0];
            chrome.tabs.executeScript(tab.id, { code: getTouristField('дата рождения', 'birthDate') }, function (result) {
                var birthdate = result[0];
                resolve({
                    name: name,
                    surname: surname,
                    dateOfBirth: birthdate,
                });
            });
        });
    });
}); };
var identifyTouristSchengen = function (tourists, tab) { return new Promise(function (resolve, reject) {
    return getTouristVisaInfo(tab)
        .then(function (idInfo) { return (0,_utils_chunks_unifyTouristIdenify__WEBPACK_IMPORTED_MODULE_14__.unifyTouristIdenify)(tourists, idInfo); })
        .then(function (tourist) { return resolve(tourist); });
}); };
var getSchengenBlankLink = function (data) { return "\n    document.querySelectorAll('#Form table tr.lGray ~ tr')[".concat(data.index, "].querySelector('td a').href;\n"); };
var fillSchengenVisa = function (data) {
    var tourist = data.tourist;
    if (!tourist) {
        return;
    }
    var visa = tourist.visaForm;
    if (!visa) {
        return;
    }
    var block = document.querySelector('form tbody');
    var SchengenCountries = {
        'греция': 'GRC',
        'франция': 'FRA',
        'австрия': 'AUT',
        'сан марино': 'SMR',
        'монако': 'MCO',
        'исландия': 'ISL',
        'андорра': 'AND',
        'норвегия': 'NOR',
        'швейцария': 'CHE',
        'латвия': 'LVA',
        'литва': 'LTU',
        'швеция': 'SWE',
        'словакия': 'SVK',
        'чехия': 'CZE',
        'финляндия': 'FIN',
        'польша': 'POL',
        'италия': 'ITA',
        'испания': 'ESP',
        'бельгия': 'BEL',
        'германия': 'DEU',
        'люксембург': 'LUX',
        'мальта': 'MLT',
        'дания': 'DNK',
        'португалия': 'PRT',
        'эстония': 'EST',
        'болгария': 'HUN',
        'нидерланды': 'NLD',
    };
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = (touristField.value ? touristField.value : '');
                element.dispatchEvent(new Event('change'));
                element.dispatchEvent(new Event('input'));
            }
        });
    };
    var setMaritalStatus = function (select, visa) {
        if (!select) {
            return;
        }
        switch (visa.maritalStatus) {
            case 1:
                select.selectedIndex = 0;
                break;
            case 2:
                select.selectedIndex = 1;
                break;
            case 3:
                select.selectedIndex = 3;
                break;
            case 4:
                select.selectedIndex = 4;
                break;
        }
    };
    var setVisaType = function (select, visa) {
        if (!select) {
            return;
        }
        if (!visa.visaRepeatedType) {
            return;
        }
        Array.prototype.forEach.call(select.options, function (option) {
            if (option.text.toLowerCase().trim() === visa.visaRepeatedType.toLowerCase().trim()) {
                option.selected = true;
            }
        });
    };
    var setPreviosVisas = function (checkboxes) {
        if (!visa.previosVisasInfoList) {
            return;
        }
        if (!checkboxes || checkboxes.length === 0) {
            return;
        }
        visa.previosVisasInfoList.forEach(function (x) {
            try {
                var code_1 = SchengenCountries[x.countryName.toLowerCase()];
                var labels = document.querySelectorAll('#rowcountrysOldShengenVisa label');
                var matchingLabels = Array.prototype.filter.call(labels, function (label) {
                    return /(.*) - .*/gm.exec(label.textContent)[1].toLowerCase() === code_1.toLowerCase();
                });
                var target = document.querySelector("#".concat(matchingLabels[0].htmlFor));
                target.checked = true;
            }
            catch (ex) {
                window.createPagePanel(window.createErrorPanel('Не удалось заполнить пред. визу', "<p>\u0421\u0442\u0440\u0430\u043D\u0430: ".concat(x.countryName, "</p><p>\u0414\u0430\u0442\u0430: ").concat(x.validFrom, " - ").concat(x.validTo, "</p><p>\u041D\u043E\u043C\u0435\u0440: ").concat(x.number, "</p>")));
            }
        });
    };
    var concatFullAddress = function (visa) {
        var addr = '';
        if (visa.city && visa.city !== 'NO') {
            addr += "".concat(visa.city, " ");
        }
        if (visa.street && visa.street !== 'NO') {
            addr += "".concat(visa.street, " ");
        }
        if (visa.building && visa.building !== 'NO') {
            addr += "".concat(visa.building, " ");
        }
        if (visa.block && visa.block !== 'NO') {
            addr += "".concat(visa.block, " ");
        }
        if (visa.appartment && visa.appartment !== 'NO') {
            addr += "".concat(visa.appartment, " ");
        }
        return addr;
    };
    var setBiometryInfo = function (yesBt, noBt, dateField, visa) {
        if (!visa) {
            return;
        }
        if (!yesBt || !noBt || !dateField) {
            return;
        }
        if (!visa.biometryTakedate) {
            noBt.click();
        }
        else {
            yesBt.click();
            dateField.value = visa.biometryTakedate;
        }
    };
    var touristFields = [{
            htmlElementSelector: 'input[name="middleName"]',
            value: visa.patonomic
        }, {
            htmlElementSelector: 'input[name="birthPlace"]',
            value: visa.birthPlace
        }, {
            htmlElementSelector: 'input[name="birthSurname"]',
            value: visa.previosSurname === 'NO'
                ? ''
                : visa.previosSurname
        }, {
            htmlElementSelector: 'input[name="parentName"]',
            value: visa.escortPersonName
        }, {
            htmlElementSelector: 'input[name="InternationalPassportOrganization"]',
            value: visa.travelPassportIssueBy
        }, {
            htmlElementSelector: 'input[name="seriesOfInvatePassport"]',
            value: visa.passportSeries
        }, {
            htmlElementSelector: 'input[name="numberOfInvatePassport"]',
            value: visa.passportNumber
        }, {
            htmlElementSelector: 'input[name="homeAdress"]',
            value: concatFullAddress(visa)
        }, {
            htmlElementSelector: 'input[name="phone"]',
            value: visa.mobilePhoneNumber
        }, {
            htmlElementSelector: 'input[name="employerName"]',
            value: visa.employer
        }, {
            htmlElementSelector: 'input[name="employerAdress"]',
            value: visa.jobCompanyAddress
        }, {
            htmlElementSelector: 'input[name="employerPhone"]',
            value: visa.jobPhoneNumber
        }, {
            htmlElementSelector: 'input[name="touristEmail"]',
            value: visa.email
        }, {
            htmlElementSelector: 'input[name="livePlace"]',
            value: visa.city
        }, {
            htmlElementSelector: 'input[name="remarkBirthPlace"]',
            value: visa.city
        }, {
            htmlElementSelector: 'input[name="dateStartOldShengenVisa"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length >= 1
                ? visa.previosVisasInfoList[0].validFrom
                : ''
        }, {
            htmlElementSelector: 'input[name="dateEndOldShengenVisa"]',
            value: visa.previosVisasInfoList && visa.previosVisasInfoList.length >= 1
                ? visa.previosVisasInfoList[0].validTo
                : ''
        }, {
            htmlElementSelector: 'input[name="beforShengen"]',
            value: visa.previosVisasInfoList
                ? visa.previosVisasInfoList.map(function (x) { return "".concat(x.countryName ? SchengenCountries[x.countryName.toLowerCase()] : '', " ").concat(x.validFrom, "-").concat(x.validTo, " "); }).reduce(function (x, y) { return x + y; })
                : ''
        }];
    handleTouristFields(block, touristFields);
    setPreviosVisas(block.querySelectorAll('#rowcountrysOldShengenVisa td[align="right"] ~ td input'));
    setMaritalStatus(block.querySelector('select[name="familyStatus"]'), visa);
    setVisaType(block.querySelector('select[name="multiVisa"]'), visa);
    setBiometryInfo(document.querySelector('#fingerYes'), document.querySelector('#fingerNo'), document.querySelector('#fingerDate'), visa);
};
var fillCyprusVisaForms = function (tab, data, claimNumber, sourceId) {
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, '#Form')
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__.stringifyFn)(openCypusBlank, []) }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, '#Form input[name="task"]'); })
        .then(function () { return (0,_utils_chunks_injectFunctionIntoPage__WEBPACK_IMPORTED_MODULE_7__.injectFunctionIntoPage)(tab, _utils_chunks_unifyTouristIdenify__WEBPACK_IMPORTED_MODULE_14__.unifyTouristIdenify); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__.stringifyFn)(fillCyprusTouristsVisas, { tourists: (0,_utils_tourist__WEBPACK_IMPORTED_MODULE_2__.GetAllTouristsInPackage)(data) }) }); })
        .catch(function (error) { return console.log(error); });
};
var openCypusBlank = function () {
    var btn = document.querySelector('.buttons a.tour_is_ready-btn[target="_self"]');
    if (!btn) {
        return;
    }
    btn.click();
};
var fillCyprusTouristsVisas = function (data) {
    console.log(window['unifyTouristIdenify']);
    var touristBlocks = document.querySelectorAll('#Form table[rules="none"]');
    function handleTouristFields(block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = touristField.value;
                element.dispatchEvent(new Event("change"));
                element.dispatchEvent(new Event("input"));
            }
        });
    }
    var concatFullAddress = function (visa) {
        var addr = '';
        if (visa.city && visa.city !== 'NO') {
            addr += "".concat(visa.city, " ");
        }
        if (visa.street && visa.street !== 'NO') {
            addr += "".concat(visa.street, " ");
        }
        if (visa.building && visa.building !== 'NO') {
            addr += "".concat(visa.building, " ");
        }
        if (visa.block && visa.block !== 'NO') {
            addr += "".concat(visa.block, " ");
        }
        if (visa.appartment && visa.appartment !== 'NO') {
            addr += "".concat(visa.appartment, " ");
        }
        return addr;
    };
    var getTouristField = function (block, fieldname) {
        var fieldCapture = Array.prototype.filter.call(block.querySelectorAll('td'), function (x) { return x.innerHTML.toLowerCase().indexOf(fieldname) !== -1; })[0];
        if (!fieldCapture) {
            return undefined;
        }
        return fieldCapture.parentElement.querySelector(':nth-child(2)').innerText;
    };
    Array.prototype.forEach.call(touristBlocks, function (block, index) {
        (window['unifyTouristIdenify'])(data.tourists, {
            name: getTouristField(block, 'имя'),
            surname: getTouristField(block, 'фамилия'),
            dateOfBirth: getTouristField(block, 'дата рождения'),
        })
            .then(function (tourist) {
            console.log(tourist);
            if (!tourist) {
                return;
            }
            var visa = tourist.visaForm;
            if (!visa) {
                return;
            }
            var touristFields = [{
                    htmlElementSelector: 'input[name^="nameFather"]',
                    value: visa.fatherName
                }, {
                    htmlElementSelector: 'input[name^="nameMother"]',
                    value: visa.motherName
                }, {
                    htmlElementSelector: 'input[name^="address"]',
                    value: concatFullAddress(visa)
                },];
            handleTouristFields(block, touristFields);
        })
            .catch(function (error) { return console.log(error); });
    });
};
var fillBulgariaVisaForms = function (tab, data) {
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, '#Form .buttons')
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__.stringifyFn)(openBulgariaBlank, []) }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, '#Form > h1'); })
        .then(function () { return visaBulgariaFillChain(tab, (0,_utils_tourist__WEBPACK_IMPORTED_MODULE_2__.GetAllTouristsInPackage)(data)); });
};
var openBulgariaBlank = function () {
    var btn = document.querySelector('#Form .buttons a.tour_is_ready-btn[target="_self"]');
    if (!btn) {
        return;
    }
    btn.click();
};
var visaBulgariaFillChain = function (tab, tourists) { return new Promise(function (resolve) {
    getAllVisaFormsLinks(tab)
        .then(function (links) {
        links.forEach(function (lnk) {
            (0,_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({ active: false, url: lnk })
                .then(function (tab) {
                return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, 'form tbody')
                    .then(function () { return identifyTouristSchengen(tourists, tab); })
                    .then(function (idTourist) { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__.stringifyFn)(fillSchengenVisa, { tourist: idTourist }) }); });
            });
        });
    }).then(function () { return resolve(0); });
}); };
var openBulgariaVisaForm = function (tab, index) { return new Promise(function (resolve, reject) {
    var openBulgariaVisaFormInternal_href = function (index) { return "document.querySelectorAll('#Form table tr')[".concat(index, "].querySelector('a').href"); };
    chrome.tabs.executeScript(tab.id, { code: openBulgariaVisaFormInternal_href(index) }, function (result) {
        if (!result || !result[0]) {
            reject('Failed to get visa form gref');
        }
        chrome.tabs.create({ url: result[0], active: false }, function (ntab) { return resolve(ntab); });
    });
}); };
var fillBulgariaVisa = function (data) {
    if (!data.tourist) {
        return;
    }
    var visa = data.tourist.visaForm;
    if (!visa) {
        return;
    }
    var block = document.querySelector('#Form');
    var SchengenCountries = {
        'Греция': 'GRC',
        'Франция': 'FRA',
        'Австрия': 'AUT',
        'Сан Марино': 'SMR',
        'Монако': 'MCO',
        'Исландия': 'ISL',
        'Андорра': 'AND',
        'Норвегия': 'NOR',
        'Швейцария': 'CHE',
        'Латвия': 'LVA',
        'Литва': 'LTU',
        'Швеция': 'SWE',
        'Словакия': 'SVK',
        'Чехия': 'CZE',
        'Финляндия': 'FIN',
        'Польша': 'POL',
        'Италия': 'ITA',
        'Испания': 'ESP',
        'Бельгия': 'BEL',
        'Германия': 'DEU',
        'Люксембург': 'LUX',
        'Мальта': 'MLT',
        'Дания': 'DNK',
        'Португалия': 'PRT',
        'Эстония': 'EST',
        'Болгария': 'HUN',
        'Нидерланды': 'NLD',
    };
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = touristField.value;
                element.dispatchEvent(new Event("change"));
                element.dispatchEvent(new Event("input"));
            }
        });
    };
    var setMaritalStatus = function (select, visa) {
        if (!select) {
            return;
        }
        switch (visa.maritalStatus) {
            case 1:
                select.selectedIndex = 0;
                break;
            case 2:
                select.selectedIndex = 1;
                break;
            case 3:
                select.selectedIndex = 3;
                break;
            case 4:
                select.selectedIndex = 4;
                break;
        }
    };
    var setPreviousBulgariaVisas = function (inp, visa) {
        if (!visa.previosVisasInfoList || visa.previosVisasInfoList.length === 0) {
            return;
        }
        inp.value = visa.previosVisasInfoList
            .filter(function (pv) { return pv.countryName === 'Болгария'; })
            .map(function (pv) { return "".concat(pv.number, " ").concat(pv.validFrom, "-").concat(pv.validTo); })
            .reduce(function (x, y) { return x + ', ' + y; });
    };
    var setPreviousSchengenVisas = function (inp, visa) {
        if (!visa.previosVisasInfoList || visa.previosVisasInfoList.length === 0) {
            return;
        }
        inp.value = visa.previosVisasInfoList
            .filter(function (pv) { return SchengenCountries[pv.countryName.toLowerCase()]; })
            .map(function (pv) { return "".concat(pv.countryName, " ").concat(pv.validFrom, "-").concat(pv.validTo); })
            .reduce(function (x, y) { return x + ', ' + y; });
    };
    var touristFields = [{
            htmlElementSelector: "input[name=\"initialSurname\"]",
            value: visa.previosSurname
        }, {
            htmlElementSelector: "input[name=\"placeOfBirth\"]",
            value: visa.birthPlace
        }, {
            htmlElementSelector: "textarea[name=\"parentOrRepData\"]",
            value: visa.escortPersonName
        }, {
            htmlElementSelector: "input[name=\"placeOfPassportIssue\"]",
            value: visa.travelPassportIssueBy
        }, {
            htmlElementSelector: "input[name=\"address_0\"]",
            value: visa.city
        }, {
            htmlElementSelector: "input[name=\"address_1\"]",
            value: visa.street
        }, {
            htmlElementSelector: "input[name=\"address_2\"]",
            value: visa.building
        }, {
            htmlElementSelector: "input[name=\"address_3\"]",
            value: visa.block
        }, {
            htmlElementSelector: "input[name=\"address_4\"]",
            value: visa.appartment
        }, {
            htmlElementSelector: "input[name=\"phone\"]",
            value: visa.mobilePhoneNumber
        }, {
            htmlElementSelector: "input[name=\"employer_0\"]",
            value: visa.employer
        }, {
            htmlElementSelector: "input[name=\"employer_6\"]",
            value: visa.jobPhoneNumber
        },];
    handleTouristFields(block, touristFields);
    setMaritalStatus(document.querySelector('select[name="familyRelStatus"]'), visa);
    setPreviousSchengenVisas(document.querySelector('textarea[name="prevShengenVisas"]'), visa);
    setPreviousBulgariaVisas(document.querySelector('textarea[name="prevBulgarianVisas"]'), visa);
};
var bgOperatorBaseLink = 'https://www.bgoperator.ru/';
var bgOperatorAuthCookieName = 'A1';
var createAccountWarning = function (tab) { return new Promise(function (resolve, reject) {
    var getAccountIdFromCookie = function (cookieVal) {
        var match = cookieVal.match(/(.*)\$/);
        return match ? match[1] || null : null;
    };
    var getBookingCompany = function (accountId) {
        var accountIdToCompany = {
            '5098780': _models_chunks_bookingCompany__WEBPACK_IMPORTED_MODULE_19__.BookingCompany.OCB,
            '1035474': _models_chunks_bookingCompany__WEBPACK_IMPORTED_MODULE_19__.BookingCompany.SletatRu,
            '1000126': _models_chunks_bookingCompany__WEBPACK_IMPORTED_MODULE_19__.BookingCompany.Aryld,
        };
        return accountIdToCompany[accountId] || _models_chunks_bookingCompany__WEBPACK_IMPORTED_MODULE_19__.BookingCompany.Undefined;
    };
    var getBookingCompanyByCBGuid = function (guid) {
        var guidToCompany = {
            '4016198a-5249-43b7-b3a0-a4cf53b96cd4': _models_chunks_bookingCompany__WEBPACK_IMPORTED_MODULE_19__.BookingCompany.OCB,
            '75198cad-4259-4004-a54f-1b8779231839': _models_chunks_bookingCompany__WEBPACK_IMPORTED_MODULE_19__.BookingCompany.SletatRu,
            '62b8b7e0-c368-4ec0-8fc6-cee8bbcbbe41': _models_chunks_bookingCompany__WEBPACK_IMPORTED_MODULE_19__.BookingCompany.Aryld,
        };
        return guidToCompany[guid] || _models_chunks_bookingCompany__WEBPACK_IMPORTED_MODULE_19__.BookingCompany.Undefined;
    };
    var createAccountIndicator = function (tab, currentCompany, claimCompany) {
        var createAccountIndicatorInternal = function (data) {
            var el = document.querySelector('#Autofill-account_indicator');
            if (el) {
                el.remove();
            }
            var bookingCompanyNames = {
                1: 'ООО "ОЦБ"',
                2: 'ООО "Слетать.ру"',
                3: 'ООО "Арильд"',
            };
            var bookingCompanyName = bookingCompanyNames[data.currentCompany] || 'Неизвестно';
            var claimCompanyName = bookingCompanyNames[data.claimCompany] || 'Неизвестно';
            var isOk = data.currentCompany === data.claimCompany;
            var parent = document.querySelector('.buttons');
            var ind = document.createElement('div');
            ind.setAttribute('style', "\n                margin-bottom:-15px;\n                margin-top: 15px;\n                min-width: 250px;\n                max-width: 400px;\n                margin-left: auto\n                margin-right:auto;\n                font-size:12pt;\n                ".concat(isOk
                ? "\n                    background-color:white;\n                    border: 2px solid #2ed573;\n                    color: #2f3542;\n                    "
                : "\n                    background-color:#c23616;\n                    border: 2px solid ##c23616;\n                    color: white;\n                    ", "\n                line-height:10px;\n                border-radius: 8px;\n                padding: 8px;\n            "));
            ind.setAttribute('id', 'Autofill-account_indicator');
            if (isOk) {
                ind.setAttribute('title', 'Вход произведен под правильным юрлицом');
            }
            else {
                ind.setAttribute('title', "\u0412\u0445\u043E\u0434 \u0434\u043E\u043B\u0436\u0435\u043D \u0431\u044B\u0442\u044C \u043F\u0440\u043E\u0438\u0437\u0432\u0435\u0434\u0435\u043D \u043F\u043E\u0434 ".concat(claimCompanyName));
            }
            var txtMain = document.createElement('div');
            txtMain.innerText = "\u041F\u043E\u0434 \u042E\u0440 \u043B\u0438\u0446\u043E\u043C ".concat(bookingCompanyName);
            ind.appendChild(txtMain);
            parent.insertBefore(ind, parent.firstChild);
        };
        return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_10__.stringifyFn)(createAccountIndicatorInternal, { currentCompany: currentCompany, claimCompany: claimCompany }) });
    };
    var updateIndicator = function () {
        chrome.cookies.get({ url: bgOperatorBaseLink, name: bgOperatorAuthCookieName }, function (cookie) {
            var accountId = getAccountIdFromCookie(cookie.value);
            var bookingCompany = getBookingCompany(accountId);
            (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_9__.startTrackingElement)(tab, '.buttons')
                .then(function () { return (0,_utils_executives__WEBPACK_IMPORTED_MODULE_15__.getAutofillSessoinStorageData)(tab); })
                .then(function (data) {
                if (data.bookingCompanyId) {
                    var claimCompany = getBookingCompanyByCBGuid(data.bookingCompanyId);
                    createAccountIndicator(tab, bookingCompany, claimCompany);
                }
            });
        });
    };
    updateIndicator();
    var listener = function (tabId, selectionInfo) { return updateIndicator(); };
    chrome.tabs.onSelectionChanged.addListener(listener);
    var t = tab;
    chrome.tabs.onRemoved.addListener(function (tabId, removeInfo) {
        if (t.id === tabId) {
            chrome.tabs.onSelectionChanged.removeListener(listener);
        }
    });
    resolve();
}); };


/***/ }),

/***/ "./src/app/operatorScripts/9.ts":
/*!**************************************!*\
  !*** ./src/app/operatorScripts/9.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaForms: () => (/* binding */ fillVisaForms),
/* harmony export */   navigateToBookedClaimPage: () => (/* binding */ navigateToBookedClaimPage),
/* harmony export */   navigateToClaimForm: () => (/* binding */ navigateToClaimForm),
/* harmony export */   navigateToClaimRefundPage: () => (/* binding */ navigateToClaimRefundPage),
/* harmony export */   navigateToClaimTransferPage: () => (/* binding */ navigateToClaimTransferPage)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators */ "./src/app/operators.ts");
/* harmony import */ var _services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../services */ "./src/app/services/index.ts");
/* harmony import */ var _utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_tabs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _utils_cookie__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/cookie */ "./src/app/utils/cookie.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/chunks/trackingIdSelector */ "./src/app/utils/chunks/trackingIdSelector.ts");
/* harmony import */ var _utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/chunks/reloadTab */ "./src/app/utils/chunks/reloadTab.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../services/chunks/sendIdsToBookingCenter */ "./src/app/services/chunks/sendIdsToBookingCenter.ts");















var createOperationPromiseChaining = function (tab, data, func) {
    return new Promise(function (resolve) {
        var chain = new Promise(function (resolve, reject) { return resolve(); });
        data.touristDataItems.forEach(function (tourist, index) {
            chain = chain
                .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_9__.stringifyFn)(func, { tourists: data.touristDataItems, index: index }) }); })
                .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, '#shadow[style="display: none;"]'); });
        });
        chain.then(function () { return resolve(); });
    });
};
var intAuthUrl = 'https://intourist.ru/';
function navigateToBookedClaimPage(tab, claimId, sourceId, navigateUrl) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__.removeCookies)({ url: intAuthUrl, cookieNames: operator.cookie.auth })
        .then(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_11__.reloadTab)(tab); })
        .then(function () { return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPage)(tab, operator, operator.credentials.packet); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, 'input[name="dg"]'); })
        .then(function () { return pageUtils(tab).HideMessagesWindow(); })
        .then(function () { return pageUtils(tab).SetSearchClaimNumber(claimId); })
        .then(function () { return pageUtils(tab).ClickSerachButton(); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElementDisappear)(tab, 'tr.orderlist', undefined, 10); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, 'tr.orderlist', undefined, 10); })
        .then(function () { return pageUtils(tab).GetSearchResultLink(0); })
        .then(function (link) { return (0,_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({ active: true, url: link }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElementDisappear)(tab, '.ui-dialog[style*="display: none"]'); })
        .then(function () { return pageUtils(tab).HideMessagesWindow(); });
}
var pageUtils = function (tab) {
    return {
        HideMessagesWindow: function () {
            var HideMessagesWindowInternal = function () { return "$('#MessageFormDialog').dialog('close');"; };
            return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: HideMessagesWindowInternal() });
        },
        SetSearchClaimNumber: function (number) {
            var SetSearchClaimNumberInner = function () { return "document.querySelector('input[name=\"dg\"]').value = \"".concat(number, "\";"); };
            return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: SetSearchClaimNumberInner() });
        },
        ClickSerachButton: function () {
            var ClickSerachButtonInternal = function () { return "document.querySelector('input[value=\"\u041F\u043E\u0438\u0441\u043A\"]').click();"; };
            return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: ClickSerachButtonInternal() });
        },
        GetSearchResultLink: function (index) { return new Promise(function (resolve, reject) {
            var GetSearchResultLinkInternal = function () { return "document.querySelectorAll('tr.orderlist')[".concat(index, "].querySelector('td a').href"); };
            chrome.tabs.executeScript(tab.id, { code: GetSearchResultLinkInternal() }, function (result) {
                if (!result[0]) {
                    reject("unable to obtain search result with index ".concat(index));
                }
                resolve(result[0]);
            });
        }); },
    };
};
var intNewAuthUrl = 'https://intourist.ru/MasterWebStandard/login.aspx/';
function removeCookieAuthAndNavigate(navigateUrl, operator) {
    var curTab;
    return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__.removeCookies)({ url: intNewAuthUrl, cookieNames: operator.cookie.auth })
        .then(function () { return (0,_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_4__.createTab)({ active: true, url: intNewAuthUrl, windowId: chrome.windows.WINDOW_ID_CURRENT }); })
        .then(function (createdTab) {
        curTab = createdTab;
        return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPage)(curTab, operator, operator.credentials.packet);
    })
        .then(function () { return (0,_utils_cookie__WEBPACK_IMPORTED_MODULE_8__.startTrackingCookie)({ url: intNewAuthUrl, cookieName: '.ntkauth100316' }); })
        .then(function () { return (0,_utils_tabs__WEBPACK_IMPORTED_MODULE_7__.updateTab)(curTab.id, { url: navigateUrl }); })
        .then(function () { return Promise.resolve(curTab); });
}
function navigateToClaimForm(context) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[context.sourceId];
    var curTab = context.tab;
    return removeCookieAuthAndNavigate(context.navigateUrl, operator)
        .then(function (tab) {
        curTab = tab;
        return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(curTab, '#shadow[style="display: none;"]');
    })
        // .then(() => startTrackingElement(curTab, '#shadow[style="display: none;"]'))
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElementDisappear)(curTab, '#OnlineUserBlock span'); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(curTab, '#shadow[style="display: none;"]'); })
        .then(function () { return new Promise(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_11__.reloadTab)(curTab); }); })
        .then(function () { return new Promise(function (resolve) {
        var t = curTab;
        var listener = function (tabId, changeInfo, ntab) {
            if (tabId === t.id) {
                chrome.tabs.onUpdated.removeListener(listener);
                resolve({});
            }
        };
        chrome.tabs.onUpdated.addListener(listener);
    }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(curTab, '#shadow[style="display: none;"]'); })
        .then(function () { return createOperationPromiseChaining(curTab, context.data, setSexSelect); })
        .then(function () { return createOperationPromiseChaining(curTab, context.data, setCitizenshipSelect); })
        .then(function () { return createOperationPromiseChaining(curTab, context.data, setBirthDate); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(curTab, '#shadow[style="display: none;"]'); })
        .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(curTab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_9__.stringifyFn)(claimFiller, context.data.touristDataItems) }); })
        .then(function () {
        return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_13__.createPushNotification)({
            claimId: context.claimNumber,
            operator: operator,
            errorText: null
        }).then(function () { return (0,_utils_chunks_trackingIdSelector__WEBPACK_IMPORTED_MODULE_10__.startTrackingIdSelector)(curTab, 'body table.int tr:nth-child(4) td:nth-child(2)'); });
    })
        .then(function (response) { return (0,_services_chunks_sendIdsToBookingCenter__WEBPACK_IMPORTED_MODULE_14__.sendIdsToBookingCenter)(context.claimNumber, response.claimNo); })
        .then(function () { return (0,_utils_chunks_reloadTab__WEBPACK_IMPORTED_MODULE_11__.reloadTab)(context.sourceTab); })
        .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_13__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_12__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
        .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_13__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_12__.SendIdsStatus.FAIL, message: error.message }); });
}
var claimFiller = function (data) {
    window.scrollTo(document.getElementById('TouristBlock').offsetLeft, document.getElementById('TouristBlock').offsetTop);
    var touristBlocks = document.querySelectorAll('#TouristBlock .TouristBackground');
    function handleTouristFields(touristFields, block) {
        touristFields.forEach(function (touristItem) {
            var element = block.querySelector(touristItem.htmlElementSelector);
            if (element && element.value === '') {
                element.value = touristItem.value;
                element.dispatchEvent(new Event('change'));
            }
        });
    }
    Array.prototype.forEach.call(touristBlocks, function (block, index) {
        var tourist = data[index];
        if (!tourist) {
            return;
        }
        var fields = [{
                htmlElementSelector: '#sNameRus',
                value: tourist.surnameRus
            }, {
                htmlElementSelector: '#fNameRus',
                value: tourist.nameRus
            }, {
                htmlElementSelector: '#sNameLat',
                value: tourist.surnameEng
            }, {
                htmlElementSelector: '#fNameLat',
                value: tourist.nameEng
            }, {
                htmlElementSelector: '#pNameRus',
                value: tourist.middleNameRus
            }, {
                htmlElementSelector: 'input[name="dSerial"]',
                value: tourist.passportSeries
            }, {
                htmlElementSelector: 'input[name="dNumber"]',
                value: tourist.passportNumber
            }, {
                htmlElementSelector: 'input[name="dExpires"]',
                value: tourist.passportExpireDate
            }];
        handleTouristFields(fields, block);
    });
};
var setSexSelect = function (data) {
    window.scrollTo(document.getElementById('TouristBlock').offsetLeft, document.getElementById('TouristBlock').offsetTop);
    var tourist = data.tourists[data.index];
    if (!tourist) {
        return;
    }
    var touristBlocks = document.querySelectorAll('#TouristBlock .TouristBackground');
    var block = touristBlocks[data.index];
    function setSexSelect(select, tourist) {
        switch (tourist.touristType) {
            case 1:
            case 3:
            case 5:
                select.options[0].selected = true;
                break;
            case 2:
            case 4:
            case 6:
                select.options[1].selected = true;
        }
        select.dispatchEvent(new Event('change'));
    }
    var sexSelect = block.querySelector('#Sex');
    setSexSelect(sexSelect, tourist);
};
var setCitizenshipSelect = function (data) {
    console.log(data.index);
    window.scrollTo(document.getElementById('TouristBlock').offsetLeft, document.getElementById('TouristBlock').offsetTop);
    var tourist = data.tourists[data.index];
    if (!tourist) {
        return;
    }
    var touristBlocks = document.querySelectorAll('#TouristBlock .TouristBackground');
    var block = touristBlocks[data.index];
    function setCitizenship(select, tourist) {
        if (!tourist.citizenshipName) {
            return;
        }
        Array.prototype.forEach.call(select.options, function (el) {
            if (el.innerText.toLowerCase() === tourist.citizenshipName.toLowerCase()) {
                el.selected = true;
            }
        });
        select.dispatchEvent(new Event('change'));
    }
    var citizenshipSelect = block.querySelector('select[name="CitizenKey"]');
    setCitizenship(citizenshipSelect, tourist);
};
var setBirthDate = function (data) {
    console.log(data.index);
    window.scrollTo(document.getElementById('TouristBlock').offsetLeft, document.getElementById('TouristBlock').offsetTop);
    var tourist = data.tourists[data.index];
    if (!tourist) {
        return;
    }
    var touristBlocks = document.querySelectorAll('#TouristBlock .TouristBackground');
    var block = touristBlocks[data.index];
    var birthdateInput = block.querySelector('input[name="DateOfBirth"]');
    if (birthdateInput) {
        birthdateInput.value = tourist.birthday;
        birthdateInput.dispatchEvent(new Event('change'));
    }
};
/*visafill*/
function fillVisaForms(tab, data, claimNumber, sourceId) {
    return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, '#main-wrap .inner-page__text > table.int')
        .then(function () { return visaFillChain(tab, data.touristDataItems); });
}
var visaFillChain = function (tab, tourists) { return new Promise(function (resolve, reject) {
    var chain = new Promise(function (resolve) { return resolve({}); });
    tourists.forEach(function (tourist, index) {
        chain = chain
            .then(function () { return openVisaFillBlank(tab, index); })
            .then(function (ntab) { return new Promise(function (resolve) {
            return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(ntab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_9__.stringifyFn)(fillVisaForm, { tourist: tourist }) })
                .then(function () { return startTrackingTabWindowClosing(ntab); })
                .then(function () { return resolve({}); });
        }); });
    });
    chain = chain
        .then(function () { return resolve({}); })
        .then();
}); };
var openVisaFillBlank = function (tab, index) { return new Promise(function (resolve, reject) {
    var openVisaFillBlankInternal = function (index) { return "\n        document.querySelectorAll('#main-wrap .inner-page__text > table.int tbody tr')[".concat(index + 1, "].querySelector(':nth-child(5) a').click();\n    "); };
    var getOpenVisaLink = function (index) { return "\n        document.querySelectorAll('#main-wrap .inner-page__text > table.int tbody tr')[".concat(index + 1, "].querySelector(':nth-child(5) a').href;\n    "); };
    var getTu_keyFromUrl = function (url) {
        var match = url.match(/tu_key=([0-9]+)/i);
        return match && match[1]
            ? match[1]
            : '';
    };
    chrome.tabs.executeScript(tab.id, { code: getOpenVisaLink(index) }, function (result) {
        var href = result[0];
        var tu_key = getTu_keyFromUrl(href);
        var listener = function (window) {
            chrome.windows.onCreated.removeListener(listener);
            chrome.tabs.query({ windowId: window.id }, function (tabs) {
                var tabListener = function (tabId, changeInfo) {
                    if (changeInfo.url) {
                        var tabKey = getTu_keyFromUrl(changeInfo.url);
                        chrome.tabs.onUpdated.removeListener(tabListener);
                        if (tabKey === tu_key) {
                            chrome.windows.onCreated.removeListener(listener);
                            resolve(tabs[0]);
                        }
                    }
                };
                chrome.tabs.onUpdated.addListener(tabListener);
            });
        };
        chrome.windows.onCreated.addListener(listener);
        (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: openVisaFillBlankInternal(index) });
    });
}); };
var startTrackingTabWindowClosing = function (tab) { return new Promise(function (resolve) {
    var listener = function (windowId) {
        if (windowId === tab.windowId) {
            chrome.tabs.onRemoved.removeListener(listener);
            resolve({});
        }
    };
    chrome.windows.onRemoved.addListener(listener);
}); };
var fillVisaForm = function (data) {
    if (!data.tourist) {
        return;
    }
    var visa = data.tourist.visaForm;
    if (!visa) {
        return;
    }
    var block = document.querySelector('#f1');
    if (!block) {
        return;
    }
    var handleTouristFields = function (block, touristFields) {
        touristFields.forEach(function (touristField) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                element.value = (touristField.value ? touristField.value : '');
            }
        });
    };
    var concatFullAddress = function (visa) {
        var addr = '';
        if (visa.city && visa.city !== 'NO') {
            addr += "".concat(visa.city, " ");
        }
        if (visa.street && visa.street !== 'NO') {
            addr += "".concat(visa.street, " ");
        }
        if (visa.building && visa.building !== 'NO') {
            addr += "".concat(visa.building, " ");
        }
        if (visa.block && visa.block !== 'NO') {
            addr += "".concat(visa.block, " ");
        }
        if (visa.appartment && visa.appartment !== 'NO') {
            addr += "".concat(visa.appartment, " ");
        }
        return addr;
    };
    var setMaritalStatus = function (select, visa) {
        if (!select) {
            return;
        }
        switch (visa.maritalStatus) {
            case 1:
                select.selectedIndex = 0;
                break;
            case 2:
                select.selectedIndex = 1;
                break;
            case 3:
                select.selectedIndex = 2;
                break;
            case 4:
                select.selectedIndex = 4;
                break;
        }
    };
    var setVisaType = function (select, visa) {
        if (!select) {
            return;
        }
        select.selectedIndex = visa.visaRepeatedType === 'Однократная'
            ? 0 : 1;
    };
    var setHasPreviousVisas = function (select, visa) {
        if (!select) {
            return;
        }
        select.selectedIndex = visa.previosVisasInfoList && visa.previosVisasInfoList.length > 0
            ? 0 : 1;
    };
    var setPreviosSchengenVisa = function (startDateIntput, endDateInput, numberInput, index) {
        if (!visa.previosVisasInfoList || visa.previosVisasInfoList.length < index || index < 0) {
            return;
        }
        var pvisa = visa.previosVisasInfoList[index];
        if (!pvisa) {
            return;
        }
        if (startDateIntput) {
            startDateIntput.value = pvisa.validFrom ? pvisa.validFrom : '';
        }
        if (endDateInput) {
            endDateInput.value = pvisa.validTo ? pvisa.validTo : '';
        }
        if (numberInput) {
            numberInput.value = pvisa.number ? pvisa.number : '';
        }
    };
    var setBiometryTakedate = function (select, dateInput, visa) {
        if (!select || !dateInput) {
            return;
        }
        if (visa.biometryTakedate) {
            select.selectedIndex = 1;
            dateInput.value = visa.biometryTakedate;
        }
        else {
            select.selectedIndex = 0;
        }
    };
    var touristFields = [{
            htmlElementSelector: '#inp483',
            value: visa.previosSurname
        }, {
            htmlElementSelector: '#inp484',
            value: visa.birthPlace
        }, {
            htmlElementSelector: '#inp486',
            value: visa.citizenship
        }, {
            htmlElementSelector: '#inp489',
            value: visa.escortPersonName
        }, {
            htmlElementSelector: '#inp490',
            value: "".concat(visa.passportSeries, " ").concat(visa.passportNumber)
        }, {
            htmlElementSelector: '#inp491',
            value: "".concat(visa.travelPassportSeries, " ").concat(visa.travelPassportNumber)
        }, {
            htmlElementSelector: '#inp493',
            value: visa.travelPassportValidTo
        }, {
            htmlElementSelector: '#inp494',
            value: visa.travelPassportIssueBy
        }, {
            htmlElementSelector: '#inp495',
            value: concatFullAddress(visa)
        }, {
            htmlElementSelector: '#inp496',
            value: visa.email
        }, {
            htmlElementSelector: '#inp497',
            value: visa.mobilePhoneNumber
        }, {
            htmlElementSelector: '#inp499',
            value: visa.occupation
        }, {
            htmlElementSelector: '#inp500',
            value: "".concat(visa.jobCompanyAddress === 'NO' ? '' : visa.jobCompanyAddress, " ").concat(visa.jobPhoneNumber)
        },];
    handleTouristFields(block, touristFields);
    setMaritalStatus(document.querySelector('select[name="inp488"]'), visa);
    setVisaType(document.querySelector('select[name="inp501"]'), visa);
    setHasPreviousVisas(document.querySelector('select[name="inp502"]'), visa);
    setPreviosSchengenVisa(document.querySelector('#inp503'), document.querySelector('#inp504'), document.querySelector('#inp505'), 0);
    setPreviosSchengenVisa(document.querySelector('#inp506'), document.querySelector('#inp507'), document.querySelector('#inp508'), 1);
    setPreviosSchengenVisa(document.querySelector('#inp509'), document.querySelector('#inp510'), document.querySelector('#inp511'), 2);
    setPreviosSchengenVisa(document.querySelector('#inp512'), document.querySelector('#inp513'), document.querySelector('#inp514'), 3);
    setBiometryTakedate(document.querySelector('select[name="inp515"]'), document.querySelector('#inp516'), visa);
};
var navigateToClaimTransferPage = function (tab, claimId, sourceId, navigateUrl, claimTransferDetails) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return navigateToBookedClaimPage(tab, claimId, sourceId, navigateUrl)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, 'form[name="f_main"]'); })
        .then(function () { return getTransferlink(tab); })
        .then(function (lnk) {
        return chrome.tabs.create({ url: lnk, active: true }, function (ntab) {
            return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(ntab, '.blockMsg')
                .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElementDisappear)(ntab, '.blockMsg'); })
                .then(function () { return chrome.tabs.create({ url: (0,_services__WEBPACK_IMPORTED_MODULE_1__.getClaimTransferFileUrl)("".concat(claimTransferDetails.transferId), 'transfer_inturist'), active: false }); })
                .then(function () { return setTransferType(ntab); })
                .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElementDisappear)(ntab, '.blockMsg'); })
                .then(function () { return setTransferDestinationClaimNumber(ntab, claimTransferDetails); })
                .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElementDisappear)(ntab, '.blockMsg'); })
                .then(function () { return setTransferAmount(ntab, claimTransferDetails); });
        });
    });
};
var getTransferlink = function (tab) { return new Promise(function (resolve, reject) {
    var clickTransferLnkinternal = function () { return "\n        Array.prototype.filter.call(document.querySelectorAll('a'), function(x) { return x.innerText.indexOf('\u0432\u043E\u0437\u0432\u0440\u0430\u0442/\u043F\u0435\u0440\u0435\u043D\u043E\u0441') != -1;})[0].href\n    "; };
    chrome.tabs.executeScript(tab.id, { code: clickTransferLnkinternal() }, function (result) {
        if (!result[0]) {
            reject('Failed to get transfer link');
        }
        resolve(result[0]);
    });
}); };
var setTransferType = function (tab) {
    var setTransferTypeInternal = "document.querySelector('#rbOperationKindTransferCell input').click()";
    return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: setTransferTypeInternal });
};
var setTransferDestinationClaimNumber = function (tab, details) {
    var setTransferDestinationClaimNumberInternal = function (data) {
        var select = document.querySelector('#outReservationList');
        Array.prototype.forEach.call(select.options, function (option) {
            if (option.innerText.toLowerCase().trim() === data.destinationTONumber.toLowerCase().trim()) {
                option.selected = true;
            }
        });
        select.dispatchEvent(new Event('change'));
    };
    return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_9__.stringifyFn)(setTransferDestinationClaimNumberInternal, { destinationTONumber: details.claimDestTONumber }) });
};
var setTransferAmount = function (tab, details) {
    var setTransferAmountInternal = function (data) {
        var amountInp = document.querySelector('#txtSum');
        amountInp.value = data.amount.toString();
        amountInp.dispatchEvent(new Event('change'));
    };
    return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_9__.stringifyFn)(setTransferAmountInternal, { amount: details.amount }) });
};
var navigateToClaimRefundPage = function (tab, claimId, sourceId, navigateUrl, claimRefundDetails) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    return navigateToBookedClaimPage(tab, claimId, sourceId, navigateUrl)
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(tab, 'form[name="f_main"]'); })
        .then(function () { return getTransferlink(tab); })
        .then(function (lnk) {
        return chrome.tabs.create({ url: lnk, active: true }, function (ntab) {
            return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElement)(ntab, '.blockMsg')
                .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElementDisappear)(ntab, '.blockMsg'); })
                .then(function () { return chrome.tabs.create({ url: (0,_services__WEBPACK_IMPORTED_MODULE_1__.getClaimRefundFileUrl)("".concat(claimRefundDetails.refundId), 'vozvrat_intourist'), active: false }); })
                .then(function () { return setRefundType(ntab); })
                .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_6__.startTrackingElementDisappear)(ntab, '.blockMsg'); })
                .then(function () { return setRefundAmount(ntab, claimRefundDetails); });
        });
    });
};
var setRefundType = function (tab) {
    var setRefundTypeInternal = function () { return "document.querySelector(\"#rbOperationKind\").click();"; };
    return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: setRefundTypeInternal() });
};
var setRefundAmount = function (tab, details) {
    var setTransferAmountInternal = function (data) {
        var amountInp = document.querySelector('#txtSum');
        amountInp.value = data.amount.toString();
        amountInp.dispatchEvent(new Event('change'));
    };
    return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(tab, { code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_9__.stringifyFn)(setTransferAmountInternal, { amount: details.amount }) });
};


/***/ }),

/***/ "./src/app/operatorScripts/customAuthentification/19.ts":
/*!**************************************************************!*\
  !*** ./src/app/operatorScripts/customAuthentification/19.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   depositCustomAuth: () => (/* binding */ depositCustomAuth)
/* harmony export */ });
/* harmony import */ var _utils_tabs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");




var depositCustomAuth = function (tab, data) { return new Promise(function (resolve, reject) {
    var cookies = ['PHPSESSID'];
    var selectors = {
        authFormSelector: '.auth .panel',
        usernameSelector: 'input[name="DEPOSIT_USERNAME"]',
        passwordSelector: 'input[name="DEPOSIT_PASSWORD"]',
        tokenSelector: 'input[name="DEPOSIT_TOKEN"]',
        submitButton: '.auth .panel button[type="submit"]'
    };
    var tokens = {
        '96C57522-C7B9-43FB-AB7A-15F98D3972D4': '3d65f2492e304ce093d1da21aab981a5', // Все Туры
        '75198CAD-4259-4004-A54F-1B8779231839': 'dde5e305f87a41f79f2ed825c86541cd', // Слетать Ру
        '4016198A-5249-43B7-B3A0-A4CF53B96CD4': '9645d391ca4f4b3bb9b5deac487ec575', // ОЦБ
        '62B8B7E0-C368-4EC0-8FC6-CEE8BBCBBE41': '45536910826d41dcad7f9a4b8aa92892', // Арильд
    };
    var utils = {
        auth: {
            setUsername: function (username) { return new Promise(function (resolve, reject) {
                return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, selectors.usernameSelector, undefined, 10)
                    .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__.executeScriptInTab)(tab, { code: "document.querySelector('".concat(selectors.usernameSelector, "').value = '").concat(username, "'") }); })
                    .then(function () { return resolve(); });
            }); },
            setPassword: function (password) { return new Promise(function (resolve, reject) {
                return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, selectors.usernameSelector, undefined, 10)
                    .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__.executeScriptInTab)(tab, { code: "document.querySelector('".concat(selectors.passwordSelector, "').value = '").concat(password, "'") }); })
                    .then(function () { return resolve(); });
            }); },
            setToken: function (bookingCompanyId) { return new Promise(function (resolve, reject) {
                return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, selectors.usernameSelector, undefined, 10)
                    .then(function () { return new Promise(function (resolve, reject) {
                    var token = tokens[bookingCompanyId.toUpperCase()];
                    if (token) {
                        resolve(token);
                    }
                    reject("Unable to obtain token for Booking company with id '".concat(bookingCompanyId, "'"));
                }); })
                    .then(function (token) { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__.executeScriptInTab)(tab, { code: "document.querySelector('".concat(selectors.tokenSelector, "').value = '").concat(token, "'") }); })
                    .then(function () { return resolve(); });
            }); },
            clickSubmit: function () { return new Promise(function (resolve, reject) {
                return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, selectors.submitButton, undefined, 10)
                    .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_1__.executeScriptInTab)(tab, { code: "document.querySelector('".concat(selectors.submitButton, "').click()") }); });
            }); },
        },
    };
    return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_2__.removeCookies)({ url: 'http://185.113.119.31:50501/', cookieNames: cookies })
        .then(function () { return (0,_utils_tabs__WEBPACK_IMPORTED_MODULE_0__.updateTab)(tab.id, { url: data.loginPath }); })
        .then(function () { return (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, selectors.authFormSelector); })
        .then(function () { return utils.auth.setUsername(data.login); })
        .then(function () { return utils.auth.setPassword(data.password); })
        .then(function () { return utils.auth.setToken(data.bookingCompanyId); })
        .then(function () { return utils.auth.clickSubmit(); })
        .then(function () { return resolve(); });
}); };


/***/ }),

/***/ "./src/app/operatorScripts/goToMyAgentAndFill.ts":
/*!*******************************************************!*\
  !*** ./src/app/operatorScripts/goToMyAgentAndFill.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   goToMyAgentAndFill: () => (/* binding */ goToMyAgentAndFill)
/* harmony export */ });
/* harmony import */ var _chunks_handleNavigateUrl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../chunks/handleNavigateUrl */ "./src/app/chunks/handleNavigateUrl.ts");
/* harmony import */ var _models_chunks_authTypes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../models/chunks/authTypes */ "./src/app/models/chunks/authTypes.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils */ "./src/app/utils/index.ts");
/* harmony import */ var _utils_chunks_checkCookie__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/chunks/checkCookie */ "./src/app/utils/chunks/checkCookie.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _utils_chunks_delay__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/chunks/delay */ "./src/app/utils/chunks/delay.ts");
/* harmony import */ var _utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/chunks/navigateToClaimPage */ "./src/app/utils/chunks/navigateToClaimPage.ts");
/* harmony import */ var _utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _utils_chunks_setSessionStorageKeyInTab__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/chunks/setSessionStorageKeyInTab */ "./src/app/utils/chunks/setSessionStorageKeyInTab.ts");
/* harmony import */ var _utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
/* harmony import */ var _utils_chunks_waitForTabLoad__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../utils/chunks/waitForTabLoad */ "./src/app/utils/chunks/waitForTabLoad.ts");
/* harmony import */ var _utils_tabs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _myAgent__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./myAgent */ "./src/app/operatorScripts/myAgent.ts");

















function goToMyAgentAndFill(_a, data, additionalInfo) {
    // const context: IClaimFillerContext = {
    //     data: data,
    //     tourUrl: tourUrl,
    //     secretField: secretField,
    //     claimNumber: claimNumber,
    //     sourceId: sourceId
    // };
    var tourUrl = _a.tourUrl, claimId = _a.claimId, sourceId = _a.sourceId, claimNumber = _a.claimNumber, secretField = _a.secretField;
    var claimDetails;
    var sourceTab;
    var navigateUrl = '';
    var loginUrl = 'https://myagent.online/#/login';
    return Promise.resolve()
        .then(function () { return new Promise(function (resolve) {
        chrome.tabs.query({ active: true, lastFocusedWindow: true }, function (tabs) {
            sourceTab = tabs[0];
            resolve(0);
        });
    }); })
        .then(function () {
        claimDetails = {
            cityFrom: data.cityFrom,
            countryTo: data.countryTo,
            hotelName: data.hotelName,
            duration: data.duration,
            resort: data.resort,
            travelDate: data.travelDate
        };
        navigateUrl = tourUrl = (0,_chunks_handleNavigateUrl__WEBPACK_IMPORTED_MODULE_0__.handleNavigateUrl)(tourUrl, _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent);
        if (!/^(http|https):\/\/.*$/.test(navigateUrl)) {
            navigateUrl = "http://".concat(navigateUrl);
        }
        // D2.credentials!.login = data.login;
        // D2.credentials!.password = data.password;
        switch (_myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.authType) {
            case _models_chunks_authTypes__WEBPACK_IMPORTED_MODULE_1__.AuthTypes.BASIC:
                navigateUrl = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.insertUrlCreds)(tourUrl, {
                    username: _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.credentials.login,
                    password: _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.credentials.password
                });
                break;
            case _models_chunks_authTypes__WEBPACK_IMPORTED_MODULE_1__.AuthTypes.FORMS:
                break;
        }
        var promise;
        if (_myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.cookie.userInfo) {
            promise = (0,_utils_chunks_checkCookie__WEBPACK_IMPORTED_MODULE_4__.checkCookie)({
                url: _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.link(),
                cookieName: _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.cookie.userInfo,
                searchValue: _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.credentials.login
            });
        }
        else {
            promise = Promise.reject('');
        }
        return promise.then(function () { return console.log('Уже авторизованы под нужным пользователем.'); }, function () { return (0,_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_10__.removeCookies)({
            url: _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.link(),
            cookieNames: _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.cookie.auth
        }); }).then(function () { return (0,_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_6__.createTab)({
            active: true,
            url: loginUrl,
            windowId: chrome.windows.WINDOW_ID_CURRENT
        }); });
    })
        .then(function (tab) {
        var autofillData = {
            behaviorType: 'form_fill',
            token: secretField,
            claimNumber: claimNumber,
            operatorId: sourceId,
            bookingCompanyId: data.bookingCompanyId,
        };
        var t = tab;
        var listener = function (tabId, info) {
            if (t && info.status === 'complete' && tabId === t.id) {
                (0,_utils_chunks_setSessionStorageKeyInTab__WEBPACK_IMPORTED_MODULE_11__.setSessionStorageKeyInTab)(t, 'autofill-data', JSON.stringify(autofillData));
                chrome.tabs.onUpdated.removeListener(listener);
            }
        };
        chrome.tabs.onUpdated.addListener(listener);
        var fillerContext = {
            tab: tab,
            data: data.autoFillerData,
            claimNumber: claimNumber,
            sourceId: sourceId,
            navigateUrl: navigateUrl,
            autofillData: autofillData,
            claimDetails: claimDetails,
            sourceTab: sourceTab,
        };
        return (0,_utils_chunks_navigateToClaimPage__WEBPACK_IMPORTED_MODULE_9__.navigateToClaimPage)(tab, _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent, _myAgent__WEBPACK_IMPORTED_MODULE_16__.MyAgent.credentials.packet)
            .then(function () { return (0,_utils_chunks_waitForTabLoad__WEBPACK_IMPORTED_MODULE_14__.waitForTabLoad)(tab.id); })
            .then(function () { return (0,_utils_chunks_delay__WEBPACK_IMPORTED_MODULE_7__.delay)(2 * 1000); })
            .then(function () {
            if (additionalInfo && additionalInfo.url) {
                return (0,_utils_tabs__WEBPACK_IMPORTED_MODULE_15__.updateTab)(tab.id, { url: additionalInfo.url });
            }
            else {
                return Promise.resolve(tab);
            }
        })
            .then(function () { return new Promise(function (resolve, reject) {
            var updatedLiscener = function (tabId, changeInfo, tab) {
                if (changeInfo.status === 'complete' && tabId === tab.id) {
                    //https://lk.d2insur.ru/sales
                    if (/https:\/\/myagent\.online\/#\/avia\/booking\S+/gm.test(tab.url)) {
                        (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__.startTrackingElement)(tab, 'div.AviaV2BookingForm__Passengers')
                            .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__.executeScriptInTab)(tab, {
                            code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_13__.stringifyFn)(claimFillerAvia, fillerContext.data)
                        }); })
                            .then(function () { return resolve(0); });
                    }
                    if (/https:\/\/myagent\.online\/#\/railway\/booking\S+/gm.test(tab.url)) {
                        (0,_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_12__.startTrackingElement)(tab, 'div.RailwayV2BookingForm__Passengers')
                            .then(function () { return (0,_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_8__.executeScriptInTab)(tab, {
                            code: (0,_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_13__.stringifyFn)(claimFillerRail, fillerContext.data)
                        }); })
                            .then(function () { return resolve(0); });
                    }
                    // if (/https:\/\/lk\.d2insur\.ru\/sales\/(canceltrip|T4collective)\S+(key)/gm.test(tab.url as string)) { // а тут отправка номер ТО
                    //     startTrackingIdSelectorWithClaimNumberValidation(tab, 'table#payment-tbl td.tdp-id', fillerContext.claimNumber)
                    //     .then((response: any) => sendIdsToBookingCenter(fillerContext.claimNumber, response.claimNo))
                    // }
                }
            };
            chrome.tabs.onUpdated.addListener(updatedLiscener);
            var removedLiscener = function (tabId, removeInfo) {
                if (tabId === tab.id) {
                    chrome.tabs.onUpdated.removeListener(updatedLiscener);
                    chrome.tabs.onRemoved.removeListener(removedLiscener);
                }
            };
            chrome.tabs.onRemoved.addListener(removedLiscener);
        }); })
            .then(function () { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.DONE, message: 'Работа с заполнением завершена' }); })
            .catch(function (error) { return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_5__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.FAIL, message: error.message }); });
    });
}
function claimFillerRail(data) {
    var buttonTeg = document.createElement('button');
    buttonTeg.id = 'autoFillButton';
    buttonTeg.setAttribute('onClick', 'doFillScript()');
    document.body.appendChild(buttonTeg);
    var scriptTeg = document.createElement('script');
    scriptTeg.id = 'autoFillScript';
    scriptTeg.innerHTML = "\n        function doFillScript() {\n\n            debugger;\n\n            var data = ".concat(JSON.stringify(data), ";\n\n            ").concat(doFill.toString(), "\n\n            ").concat(delay.toString(), "\n\n            ").concat(fillField.toString(), "\n\n            ").concat(handleTouristFields.toString(), "\n\n            ").concat(doTouristFill.toString(), "\n\n            ").concat(setNativeValue.toString(), "\n\n            doFill(data)\n            .then(\n                () => console.log('done'),\n                () => console.log('done with reject')\n            );\n        }\n    ");
    document.body.appendChild(scriptTeg);
    document.querySelector('#autoFillButton').click();
    function doFill(data) {
        debugger;
        var chain = new Promise(function (resolse) { return resolse(); });
        var touristBlocks = document.querySelectorAll('div.RailwayV2BookingForm__Passengers div.RailwayV2BookingFormPassenger__Main');
        Array.prototype.forEach.call(touristBlocks, function (block, index) {
            var tourist = data.touristDataItems[index];
            chain = chain.then(function () { return doTouristFill(block, tourist, index); });
        });
        return chain.then(function () { return new Promise(function (resolve) { return resolve(); }); });
    }
    function delay(timeout) {
        return new Promise(function (resolve) {
            setTimeout(function () { return resolve(); }, timeout);
        });
    }
    function setNativeValue(element, value) {
        var valueSetter = Object.getOwnPropertyDescriptor(element, 'value').set;
        var prototype = Object.getPrototypeOf(element);
        var prototypeValueSetter = Object.getOwnPropertyDescriptor(prototype, 'value').set;
        if (valueSetter && valueSetter !== prototypeValueSetter) {
            prototypeValueSetter.call(element, value);
        }
        else {
            valueSetter.call(element, value);
        }
    }
    // React fill V1
    function fillField(block, touristField) {
        return new Promise(function (resolve, reject) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                var uiEvents = document.createEvent('UIEvents');
                uiEvents.initEvent('focus', false, false);
                element.dispatchEvent(uiEvents);
                var setValue = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value').set;
                setValue.call(element, touristField.value);
                var e = new Event('input', { bubbles: true, cancelable: false });
                element.dispatchEvent(e);
                uiEvents = document.createEvent('UIEvents');
                uiEvents.initEvent('blur', false, false);
                element.dispatchEvent(uiEvents);
            }
            resolve();
        })
            .then(function () { return delay(touristField.delay || 500); });
    }
    function handleTouristFields(touristFields, block) {
        var chain = new Promise(function (resolse) { return resolse(); });
        touristFields.forEach(function (touristItem) {
            chain = chain.then(function () { return fillField(block, touristItem); });
        });
        return chain;
    }
    function doTouristFill(block, tourist, index) {
        var fields = [{
                htmlElementSelector: "div.RailwayV2BookingFormPassenger__Field--lastName input.FormInput__Input",
                value: tourist.surnameRus
            }, {
                htmlElementSelector: "div.RailwayV2BookingFormPassenger__Field--firstName input.FormInput__Input",
                value: tourist.nameRus
            }, {
                htmlElementSelector: "div.RailwayV2BookingFormPassenger__Field--middleName input.FormInput__Input",
                value: tourist.middleNameRus
            }, {
                htmlElementSelector: "div.RailwayV2BookingFormPassenger__Field--birthDate input.FormInput__Input",
                value: tourist.birthday,
                delay: 1000
            }, {
                htmlElementSelector: "div.RailwayV2BookingFormPassenger__Field--documentNumber input.FormInput__Input",
                value: "".concat(tourist.passportSeries, " ").concat(tourist.passportNumber)
            }, {
                htmlElementSelector: "div.RailwayV2BookingFormPassenger__Field--email input.FormInput__Input",
                value: tourist.email
            }, {
                htmlElementSelector: "div.RailwayV2BookingFormPassenger__Field--phone input.FormInput__Input",
                value: tourist.phone
            }];
        return handleTouristFields(fields, block);
    }
}
function claimFillerAvia(data) {
    var buttonTeg = document.createElement('button');
    buttonTeg.id = 'autoFillButton';
    buttonTeg.setAttribute('onClick', 'doFillScript()');
    document.body.appendChild(buttonTeg);
    var scriptTeg = document.createElement('script');
    scriptTeg.id = 'autoFillScript';
    scriptTeg.innerHTML = "\n        function doFillScript() {\n\n            debugger;\n\n            var data = ".concat(JSON.stringify(data), ";\n\n            ").concat(doFill.toString(), "\n\n            ").concat(delay.toString(), "\n\n            ").concat(fillField.toString(), "\n\n            ").concat(handleTouristFields.toString(), "\n\n            ").concat(doTouristFill.toString(), "\n\n            ").concat(setNativeValue.toString(), "\n\n            doFill(data)\n            .then(\n                () => console.log('done'),\n                () => console.log('done with reject')\n            );\n        }\n    ");
    document.body.appendChild(scriptTeg);
    document.querySelector('#autoFillButton').click();
    function doFill(data) {
        debugger;
        var chain = new Promise(function (resolse) { return resolse(); });
        var touristBlocks = document.querySelectorAll('div.AviaV2BookingForm__Passengers div.AviaV2BookingFormPassenger__Main');
        Array.prototype.forEach.call(touristBlocks, function (block, index) {
            var tourist = data.touristDataItems[index];
            chain = chain.then(function () { return doTouristFill(block, tourist, index); });
        });
        return chain.then(function () { return new Promise(function (resolve) { return resolve(); }); });
    }
    function delay(timeout) {
        return new Promise(function (resolve) {
            setTimeout(function () { return resolve(); }, timeout);
        });
    }
    function setNativeValue(element, value) {
        var valueSetter = Object.getOwnPropertyDescriptor(element, 'value').set;
        var prototype = Object.getPrototypeOf(element);
        var prototypeValueSetter = Object.getOwnPropertyDescriptor(prototype, 'value').set;
        if (valueSetter && valueSetter !== prototypeValueSetter) {
            prototypeValueSetter.call(element, value);
        }
        else {
            valueSetter.call(element, value);
        }
    }
    function fillField(block, touristField) {
        return new Promise(function (resolve, reject) {
            var element = block.querySelector(touristField.htmlElementSelector);
            if (element) {
                var uiEvents = document.createEvent('UIEvents');
                uiEvents.initEvent('focus', false, false);
                element.dispatchEvent(uiEvents);
                var setValue = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, 'value').set;
                setValue.call(element, touristField.value);
                var e = new Event('input', { bubbles: true, cancelable: false });
                element.dispatchEvent(e);
                uiEvents = document.createEvent('UIEvents');
                uiEvents.initEvent('blur', false, false);
                element.dispatchEvent(uiEvents);
            }
            resolve();
        })
            .then(function () { return delay(touristField.delay || 500); });
    }
    function handleTouristFields(touristFields, block) {
        var chain = new Promise(function (resolse) { return resolse(); });
        touristFields.forEach(function (touristItem) {
            chain = chain.then(function () { return fillField(block, touristItem); });
        });
        return chain;
    }
    function doTouristFill(block, tourist, index) {
        var fields = [{
                htmlElementSelector: "div.AviaV2BookingFormPassenger__Field--lastName input.FormInput__Input",
                value: tourist.surnameRus
            }, {
                htmlElementSelector: "div.AviaV2BookingFormPassenger__Field--firstName input.FormInput__Input",
                value: tourist.nameRus
            }, {
                htmlElementSelector: "div.AviaV2BookingFormPassenger__Field--middleName input.FormInput__Input",
                value: tourist.middleNameRus
            }, {
                htmlElementSelector: "div.AviaV2BookingFormPassenger__Field--birthDate input.FormInput__Input",
                value: tourist.birthday,
                delay: 1000
            }, {
                htmlElementSelector: "div.AviaV2BookingFormPassenger__Field--documentNumber input.FormInput__Input",
                value: "".concat(tourist.passportSeries, " ").concat(tourist.passportNumber)
            }, {
                htmlElementSelector: "div.AviaV2BookingFormPassenger__Field--email input.FormInput__Input",
                value: tourist.email
            }, {
                htmlElementSelector: "div.AviaV2BookingFormPassenger__Field--phone input.FormInput__Input",
                value: tourist.phone
            }];
        return handleTouristFields(fields, block);
    }
}


/***/ }),

/***/ "./src/app/operatorScripts/myAgent.ts":
/*!********************************************!*\
  !*** ./src/app/operatorScripts/myAgent.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MyAgent: () => (/* binding */ MyAgent)
/* harmony export */ });
var MyAgent = {
    link: function (operatorClaimId) { return "http://online.letsfly.travel/MasterWeb/login.aspx"; },
    title: 'MyAgent',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'sls@sletat.ru',
        password: 'Sletat2021',
        packet: {
            "loginPath": "div.AuthForm div.LoginForm form input[type=text]",
            "passwordPath": "div.AuthForm div.LoginForm form input[type=password]",
            "submitPath": "div.AuthForm div.LoginForm form button.AuthForm__ButtonRight"
        }
    },
    selectors: {},
    cookie: {
        auth: ['identityCookie']
    }
};


/***/ }),

/***/ "./src/app/operators.ts":
/*!******************************!*\
  !*** ./src/app/operators.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OPERATORS: () => (/* binding */ OPERATORS),
/* harmony export */   tryGetOperator: () => (/* binding */ tryGetOperator)
/* harmony export */ });
/* harmony import */ var _serverScripts_operators_156__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../serverScripts/operators/156 */ "./src/serverScripts/operators/156.ts");
/* harmony import */ var _serverScripts_operators_3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../serverScripts/operators/3 */ "./src/serverScripts/operators/3.ts");
/* harmony import */ var _serverScripts_operators_4__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../serverScripts/operators/4 */ "./src/serverScripts/operators/4.ts");
/* harmony import */ var _serverScripts_operators_6__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../serverScripts/operators/6 */ "./src/serverScripts/operators/6.ts");
/* harmony import */ var _serverScripts_operators_7__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./../serverScripts/operators/7 */ "./src/serverScripts/operators/7.ts");
/* harmony import */ var _serverScripts_operators_inturist__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../serverScripts/operators/inturist */ "./src/serverScripts/operators/inturist.ts");
/* harmony import */ var _serverScripts_operators_14__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./../serverScripts/operators/14 */ "./src/serverScripts/operators/14.ts");
/* harmony import */ var _serverScripts_operators_19__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./../serverScripts/operators/19 */ "./src/serverScripts/operators/19.ts");
/* harmony import */ var _serverScripts_operators_20__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./../serverScripts/operators/20 */ "./src/serverScripts/operators/20.ts");
/* harmony import */ var _serverScripts_operators_rusExpress__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../serverScripts/operators/rusExpress */ "./src/serverScripts/operators/rusExpress.ts");
/* harmony import */ var _serverScripts_operators_39__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./../serverScripts/operators/39 */ "./src/serverScripts/operators/39.ts");
/* harmony import */ var _serverScripts_operators_41__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./../serverScripts/operators/41 */ "./src/serverScripts/operators/41.ts");
/* harmony import */ var _serverScripts_operators_42__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./../serverScripts/operators/42 */ "./src/serverScripts/operators/42.ts");
/* harmony import */ var _serverScripts_operators_46__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./../serverScripts/operators/46 */ "./src/serverScripts/operators/46.ts");
/* harmony import */ var _serverScripts_operators_49__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./../serverScripts/operators/49 */ "./src/serverScripts/operators/49.ts");
/* harmony import */ var _serverScripts_operators_51__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./../serverScripts/operators/51 */ "./src/serverScripts/operators/51.ts");
/* harmony import */ var _serverScripts_operators_53__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./../serverScripts/operators/53 */ "./src/serverScripts/operators/53.ts");
/* harmony import */ var _serverScripts_operators_54__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./../serverScripts/operators/54 */ "./src/serverScripts/operators/54.ts");
/* harmony import */ var _serverScripts_operators_78__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./../serverScripts/operators/78 */ "./src/serverScripts/operators/78.ts");
/* harmony import */ var _serverScripts_operators_81__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./../serverScripts/operators/81 */ "./src/serverScripts/operators/81.ts");
/* harmony import */ var _serverScripts_operators_83__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./../serverScripts/operators/83 */ "./src/serverScripts/operators/83.ts");
/* harmony import */ var _serverScripts_operators_93__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./../serverScripts/operators/93 */ "./src/serverScripts/operators/93.ts");
/* harmony import */ var _serverScripts_operators_107__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./../serverScripts/operators/107 */ "./src/serverScripts/operators/107.ts");
/* harmony import */ var _serverScripts_operators_108__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./../serverScripts/operators/108 */ "./src/serverScripts/operators/108.ts");
/* harmony import */ var _serverScripts_operators_112__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./../serverScripts/operators/112 */ "./src/serverScripts/operators/112.ts");
/* harmony import */ var _serverScripts_operators_113__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./../serverScripts/operators/113 */ "./src/serverScripts/operators/113.ts");
/* harmony import */ var _serverScripts_operators_123__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./../serverScripts/operators/123 */ "./src/serverScripts/operators/123.ts");
/* harmony import */ var _serverScripts_operators_130__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./../serverScripts/operators/130 */ "./src/serverScripts/operators/130.ts");
/* harmony import */ var _serverScripts_operators_131__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./../serverScripts/operators/131 */ "./src/serverScripts/operators/131.ts");
/* harmony import */ var _serverScripts_operators_141__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./../serverScripts/operators/141 */ "./src/serverScripts/operators/141.ts");
/* harmony import */ var _serverScripts_operators_142__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./../serverScripts/operators/142 */ "./src/serverScripts/operators/142.ts");
/* harmony import */ var _serverScripts_operators_145__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./../serverScripts/operators/145 */ "./src/serverScripts/operators/145.ts");
/* harmony import */ var _serverScripts_operators_152__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./../serverScripts/operators/152 */ "./src/serverScripts/operators/152.ts");
/* harmony import */ var _serverScripts_operators_153__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./../serverScripts/operators/153 */ "./src/serverScripts/operators/153.ts");
/* harmony import */ var _serverScripts_operators_155__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./../serverScripts/operators/155 */ "./src/serverScripts/operators/155.ts");
/* harmony import */ var _serverScripts_operators_158__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./../serverScripts/operators/158 */ "./src/serverScripts/operators/158.ts");
/* harmony import */ var _serverScripts_operators_160__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./../serverScripts/operators/160 */ "./src/serverScripts/operators/160.ts");
/* harmony import */ var _serverScripts_operators_162__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./../serverScripts/operators/162 */ "./src/serverScripts/operators/162.ts");
/* harmony import */ var _serverScripts_operators_165__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./../serverScripts/operators/165 */ "./src/serverScripts/operators/165.ts");
/* harmony import */ var _serverScripts_operators_171__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./../serverScripts/operators/171 */ "./src/serverScripts/operators/171.ts");
/* harmony import */ var _serverScripts_operators_174__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./../serverScripts/operators/174 */ "./src/serverScripts/operators/174.ts");
/* harmony import */ var _serverScripts_operators_184__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./../serverScripts/operators/184 */ "./src/serverScripts/operators/184.ts");
/* harmony import */ var _serverScripts_operators_evroport__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./../serverScripts/operators/evroport */ "./src/serverScripts/operators/evroport.ts");
/* harmony import */ var _serverScripts_operators_205__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./../serverScripts/operators/205 */ "./src/serverScripts/operators/205.ts");
/* harmony import */ var _serverScripts_operators_213__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./../serverScripts/operators/213 */ "./src/serverScripts/operators/213.ts");
/* harmony import */ var _serverScripts_operators_219__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ../serverScripts/operators/219 */ "./src/serverScripts/operators/219.ts");
/* harmony import */ var _serverScripts_operators_229__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ../serverScripts/operators/229 */ "./src/serverScripts/operators/229.ts");
/* harmony import */ var _serverScripts_operators_231__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./../serverScripts/operators/231 */ "./src/serverScripts/operators/231.ts");
/* harmony import */ var _serverScripts_operators_237__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./../serverScripts/operators/237 */ "./src/serverScripts/operators/237.ts");
/* harmony import */ var _serverScripts_operators_238__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./../serverScripts/operators/238 */ "./src/serverScripts/operators/238.ts");
/* harmony import */ var _serverScripts_operators_248__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./../serverScripts/operators/248 */ "./src/serverScripts/operators/248.ts");
/* harmony import */ var _serverScripts_operators_252__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./../serverScripts/operators/252 */ "./src/serverScripts/operators/252.ts");
/* harmony import */ var _serverScripts_operators_260__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./../serverScripts/operators/260 */ "./src/serverScripts/operators/260.ts");
/* harmony import */ var _serverScripts_operators_269__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./../serverScripts/operators/269 */ "./src/serverScripts/operators/269.ts");
/* harmony import */ var _serverScripts_operators_277__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./../serverScripts/operators/277 */ "./src/serverScripts/operators/277.ts");
/* harmony import */ var _serverScripts_operators_280__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./../serverScripts/operators/280 */ "./src/serverScripts/operators/280.ts");
/* harmony import */ var _serverScripts_operators_282__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./../serverScripts/operators/282 */ "./src/serverScripts/operators/282.ts");
/* harmony import */ var _serverScripts_operators_301__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./../serverScripts/operators/301 */ "./src/serverScripts/operators/301.ts");
/* harmony import */ var _serverScripts_operators_302__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./../serverScripts/operators/302 */ "./src/serverScripts/operators/302.ts");
/* harmony import */ var _serverScripts_operators_304__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./../serverScripts/operators/304 */ "./src/serverScripts/operators/304.ts");
/* harmony import */ var _serverScripts_operators_309__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./../serverScripts/operators/309 */ "./src/serverScripts/operators/309.ts");
/* harmony import */ var _serverScripts_operators_311__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./../serverScripts/operators/311 */ "./src/serverScripts/operators/311.ts");
/* harmony import */ var _serverScripts_operators_315__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./../serverScripts/operators/315 */ "./src/serverScripts/operators/315.ts");
/* harmony import */ var _serverScripts_operators_331__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./../serverScripts/operators/331 */ "./src/serverScripts/operators/331.ts");
/* harmony import */ var _serverScripts_operators_343__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./../serverScripts/operators/343 */ "./src/serverScripts/operators/343.ts");
/* harmony import */ var _serverScripts_operators_344__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./../serverScripts/operators/344 */ "./src/serverScripts/operators/344.ts");
/* harmony import */ var _serverScripts_operators_345__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ./../serverScripts/operators/345 */ "./src/serverScripts/operators/345.ts");
/* harmony import */ var _serverScripts_operators_348__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ./../serverScripts/operators/348 */ "./src/serverScripts/operators/348.ts");
/* harmony import */ var _serverScripts_operators_361__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ./../serverScripts/operators/361 */ "./src/serverScripts/operators/361.ts");
/* harmony import */ var _serverScripts_operators_378__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ./../serverScripts/operators/378 */ "./src/serverScripts/operators/378.ts");
/* harmony import */ var _serverScripts_operators_380__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ./../serverScripts/operators/380 */ "./src/serverScripts/operators/380.ts");
/* harmony import */ var _serverScripts_operators_382__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ./../serverScripts/operators/382 */ "./src/serverScripts/operators/382.ts");
/* harmony import */ var _serverScripts_operators_392__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ./../serverScripts/operators/392 */ "./src/serverScripts/operators/392.ts");
/* harmony import */ var _serverScripts_operators_415__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ./../serverScripts/operators/415 */ "./src/serverScripts/operators/415.ts");
/* harmony import */ var _serverScripts_operators_429__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(/*! ./../serverScripts/operators/429 */ "./src/serverScripts/operators/429.ts");
/* harmony import */ var _serverScripts_operators_431__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(/*! ./../serverScripts/operators/431 */ "./src/serverScripts/operators/431.ts");
/* harmony import */ var _serverScripts_operators_432__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(/*! ./../serverScripts/operators/432 */ "./src/serverScripts/operators/432.ts");
/* harmony import */ var _serverScripts_operators_439__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(/*! ./../serverScripts/operators/439 */ "./src/serverScripts/operators/439.ts");
/* harmony import */ var _serverScripts_operators_449__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(/*! ./../serverScripts/operators/449 */ "./src/serverScripts/operators/449.ts");
/* harmony import */ var _serverScripts_operators_450__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(/*! ./../serverScripts/operators/450 */ "./src/serverScripts/operators/450.ts");
/* harmony import */ var _serverScripts_operators_452__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(/*! ./../serverScripts/operators/452 */ "./src/serverScripts/operators/452.ts");
/* harmony import */ var _serverScripts_operators_453__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(/*! ../serverScripts/operators/453 */ "./src/serverScripts/operators/453.ts");
/* harmony import */ var _serverScripts_operators_454__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(/*! ./../serverScripts/operators/454 */ "./src/serverScripts/operators/454.ts");
/* harmony import */ var _serverScripts_operators_536__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(/*! ./../serverScripts/operators/536 */ "./src/serverScripts/operators/536.ts");
/* harmony import */ var _serverScripts_operators_544__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(/*! ./../serverScripts/operators/544 */ "./src/serverScripts/operators/544.ts");
/* harmony import */ var _serverScripts_operators_564__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__(/*! ./../serverScripts/operators/564 */ "./src/serverScripts/operators/564.ts");
/* harmony import */ var _serverScripts_operators_587__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__(/*! ./../serverScripts/operators/587 */ "./src/serverScripts/operators/587.ts");
/* harmony import */ var _serverScripts_operators_743__WEBPACK_IMPORTED_MODULE_87__ = __webpack_require__(/*! ./../serverScripts/operators/743 */ "./src/serverScripts/operators/743.ts");
/* harmony import */ var _serverScripts_operators_768__WEBPACK_IMPORTED_MODULE_88__ = __webpack_require__(/*! ./../serverScripts/operators/768 */ "./src/serverScripts/operators/768.ts");
/* harmony import */ var _serverScripts_operators_800__WEBPACK_IMPORTED_MODULE_89__ = __webpack_require__(/*! ./../serverScripts/operators/800 */ "./src/serverScripts/operators/800.ts");
/* harmony import */ var _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_90__ = __webpack_require__(/*! ./../serverScripts/operators/tourClick */ "./src/serverScripts/operators/tourClick.ts");
/* harmony import */ var _serverScripts_operators_letsFly__WEBPACK_IMPORTED_MODULE_91__ = __webpack_require__(/*! ../serverScripts/operators/letsFly */ "./src/serverScripts/operators/letsFly.ts");
/* harmony import */ var _serverScripts_operators_2147483639__WEBPACK_IMPORTED_MODULE_92__ = __webpack_require__(/*! ./../serverScripts/operators/2147483639 */ "./src/serverScripts/operators/2147483639.ts");
/* harmony import */ var _serverScripts_operators_2147483640__WEBPACK_IMPORTED_MODULE_93__ = __webpack_require__(/*! ./../serverScripts/operators/2147483640 */ "./src/serverScripts/operators/2147483640.ts");
/* harmony import */ var _serverScripts_operators_2147483641__WEBPACK_IMPORTED_MODULE_94__ = __webpack_require__(/*! ./../serverScripts/operators/2147483641 */ "./src/serverScripts/operators/2147483641.ts");
/* harmony import */ var _serverScripts_operators_2147483645__WEBPACK_IMPORTED_MODULE_95__ = __webpack_require__(/*! ./../serverScripts/operators/2147483645 */ "./src/serverScripts/operators/2147483645.ts");
/* harmony import */ var _serverScripts_operators_eskazan__WEBPACK_IMPORTED_MODULE_96__ = __webpack_require__(/*! ../serverScripts/operators/eskazan */ "./src/serverScripts/operators/eskazan.ts");
/* harmony import */ var _serverScripts_operators_oneClickTravel__WEBPACK_IMPORTED_MODULE_97__ = __webpack_require__(/*! ../serverScripts/operators/oneClickTravel */ "./src/serverScripts/operators/oneClickTravel.ts");
/* harmony import */ var _serverScripts_operators_kazunion__WEBPACK_IMPORTED_MODULE_98__ = __webpack_require__(/*! ../serverScripts/operators/kazunion */ "./src/serverScripts/operators/kazunion.ts");
/* harmony import */ var _serverScripts_operators_tariTour__WEBPACK_IMPORTED_MODULE_99__ = __webpack_require__(/*! ../serverScripts/operators/tariTour */ "./src/serverScripts/operators/tariTour.ts");
/* harmony import */ var _serverScripts_operators_skanTour__WEBPACK_IMPORTED_MODULE_100__ = __webpack_require__(/*! ../serverScripts/operators/skanTour */ "./src/serverScripts/operators/skanTour.ts");
/* harmony import */ var _serverScripts_operators_vodohod__WEBPACK_IMPORTED_MODULE_101__ = __webpack_require__(/*! ../serverScripts/operators/vodohod */ "./src/serverScripts/operators/vodohod.ts");
/* harmony import */ var _serverScripts_operators_melinoTravel__WEBPACK_IMPORTED_MODULE_102__ = __webpack_require__(/*! ../serverScripts/operators/melinoTravel */ "./src/serverScripts/operators/melinoTravel.ts");
/* harmony import */ var _serverScripts_operators_rivieraTour__WEBPACK_IMPORTED_MODULE_103__ = __webpack_require__(/*! ../serverScripts/operators/rivieraTour */ "./src/serverScripts/operators/rivieraTour.ts");
/* harmony import */ var _serverScripts_operators_unona__WEBPACK_IMPORTED_MODULE_104__ = __webpack_require__(/*! ../serverScripts/operators/unona */ "./src/serverScripts/operators/unona.ts");
/* harmony import */ var _serverScripts_operators_magput__WEBPACK_IMPORTED_MODULE_105__ = __webpack_require__(/*! ../serverScripts/operators/magput */ "./src/serverScripts/operators/magput.ts");




































































//import { Krypton } from './../serverScripts/operators/355';






































var tryGetOperator = function (sletatId, toAlias) {
    if (sletatId) {
        var op = OPERATORS[sletatId];
        if (op) {
            return op;
        }
    }
    if (toAlias) {
        var op = OPERATORS[toAlias];
        if (op) {
            return op;
        }
    }
    return null;
};
var OPERATORS = {
    3: _serverScripts_operators_3__WEBPACK_IMPORTED_MODULE_1__.Pegas,
    4: _serverScripts_operators_4__WEBPACK_IMPORTED_MODULE_2__.TezTour,
    6: _serverScripts_operators_6__WEBPACK_IMPORTED_MODULE_3__.Coral,
    7: _serverScripts_operators_7__WEBPACK_IMPORTED_MODULE_4__.BiblioGlobus,
    //9: Intourist,
    14: _serverScripts_operators_14__WEBPACK_IMPORTED_MODULE_6__.PacGroup,
    19: _serverScripts_operators_19__WEBPACK_IMPORTED_MODULE_7__.Anex,
    20: _serverScripts_operators_20__WEBPACK_IMPORTED_MODULE_8__.IcsTravel,
    38: _serverScripts_operators_rusExpress__WEBPACK_IMPORTED_MODULE_9__.RusExpress,
    39: _serverScripts_operators_39__WEBPACK_IMPORTED_MODULE_10__.DiamondTours,
    41: _serverScripts_operators_41__WEBPACK_IMPORTED_MODULE_11__.Bontour,
    42: _serverScripts_operators_42__WEBPACK_IMPORTED_MODULE_12__.ZlataPraga,
    46: _serverScripts_operators_46__WEBPACK_IMPORTED_MODULE_13__.Troyka,
    49: _serverScripts_operators_49__WEBPACK_IMPORTED_MODULE_14__.Vilar,
    51: _serverScripts_operators_51__WEBPACK_IMPORTED_MODULE_15__.Ambotis,
    53: _serverScripts_operators_53__WEBPACK_IMPORTED_MODULE_16__.IntravelStoleshniki,
    54: _serverScripts_operators_54__WEBPACK_IMPORTED_MODULE_17__.Sunmar,
    78: _serverScripts_operators_78__WEBPACK_IMPORTED_MODULE_18__.Unex,
    81: _serverScripts_operators_81__WEBPACK_IMPORTED_MODULE_19__.Spectrum,
    83: _serverScripts_operators_83__WEBPACK_IMPORTED_MODULE_20__.ArtTour,
    93: _serverScripts_operators_93__WEBPACK_IMPORTED_MODULE_21__.Balkan,
    107: _serverScripts_operators_107__WEBPACK_IMPORTED_MODULE_22__.Danko,
    108: _serverScripts_operators_108__WEBPACK_IMPORTED_MODULE_23__.DeltaTours,
    112: _serverScripts_operators_112__WEBPACK_IMPORTED_MODULE_24__.ExpressTour,
    113: _serverScripts_operators_113__WEBPACK_IMPORTED_MODULE_25__.Grand,
    123: _serverScripts_operators_123__WEBPACK_IMPORTED_MODULE_26__.Itm,
    125: _serverScripts_operators_439__WEBPACK_IMPORTED_MODULE_77__.Paks,
    130: _serverScripts_operators_130__WEBPACK_IMPORTED_MODULE_27__.WestTravel,
    131: _serverScripts_operators_131__WEBPACK_IMPORTED_MODULE_28__.ArtTravel,
    141: _serverScripts_operators_141__WEBPACK_IMPORTED_MODULE_29__.YugoStar,
    142: _serverScripts_operators_142__WEBPACK_IMPORTED_MODULE_30__.MoreTravel,
    145: _serverScripts_operators_145__WEBPACK_IMPORTED_MODULE_31__.RozaVetrov,
    152: _serverScripts_operators_152__WEBPACK_IMPORTED_MODULE_32__.MeridianExpress,
    153: _serverScripts_operators_153__WEBPACK_IMPORTED_MODULE_33__.Delfin,
    155: _serverScripts_operators_155__WEBPACK_IMPORTED_MODULE_34__.BSI,
    156: _serverScripts_operators_156__WEBPACK_IMPORTED_MODULE_0__.Maldives,
    158: _serverScripts_operators_158__WEBPACK_IMPORTED_MODULE_35__.Solvex,
    160: _serverScripts_operators_160__WEBPACK_IMPORTED_MODULE_36__.Dsbw,
    162: _serverScripts_operators_162__WEBPACK_IMPORTED_MODULE_37__.ChinaTravel,
    165: _serverScripts_operators_165__WEBPACK_IMPORTED_MODULE_38__.Devisu,
    171: _serverScripts_operators_171__WEBPACK_IMPORTED_MODULE_39__.AmigoS,
    174: _serverScripts_operators_174__WEBPACK_IMPORTED_MODULE_40__.Capricorn,
    184: _serverScripts_operators_184__WEBPACK_IMPORTED_MODULE_41__.Interunion,
    199: _serverScripts_operators_evroport__WEBPACK_IMPORTED_MODULE_42__.Evroport,
    205: _serverScripts_operators_205__WEBPACK_IMPORTED_MODULE_43__.AmigoTours,
    213: _serverScripts_operators_213__WEBPACK_IMPORTED_MODULE_44__.Mouzenidis,
    219: _serverScripts_operators_219__WEBPACK_IMPORTED_MODULE_45__.SochiPlanet,
    229: _serverScripts_operators_229__WEBPACK_IMPORTED_MODULE_46__.TuiOld,
    231: _serverScripts_operators_231__WEBPACK_IMPORTED_MODULE_47__.MultiTour,
    237: _serverScripts_operators_237__WEBPACK_IMPORTED_MODULE_48__.DvmTour,
    238: _serverScripts_operators_238__WEBPACK_IMPORTED_MODULE_49__.RusTour,
    244: _serverScripts_operators_tariTour__WEBPACK_IMPORTED_MODULE_99__.TariTour,
    248: _serverScripts_operators_248__WEBPACK_IMPORTED_MODULE_50__.AvroraBg,
    252: _serverScripts_operators_252__WEBPACK_IMPORTED_MODULE_51__.Alean,
    260: _serverScripts_operators_260__WEBPACK_IMPORTED_MODULE_52__.Kandagar,
    269: _serverScripts_operators_269__WEBPACK_IMPORTED_MODULE_53__.NatalieTours,
    277: _serverScripts_operators_277__WEBPACK_IMPORTED_MODULE_54__.VremiaTour,
    280: _serverScripts_operators_280__WEBPACK_IMPORTED_MODULE_55__.GTV,
    282: _serverScripts_operators_282__WEBPACK_IMPORTED_MODULE_56__.Petropolitana,
    301: _serverScripts_operators_301__WEBPACK_IMPORTED_MODULE_57__.RobinsonTours,
    302: _serverScripts_operators_302__WEBPACK_IMPORTED_MODULE_58__.Premiera,
    304: _serverScripts_operators_304__WEBPACK_IMPORTED_MODULE_59__.GoodTimeTravel,
    309: _serverScripts_operators_309__WEBPACK_IMPORTED_MODULE_60__.Ivolga,
    311: _serverScripts_operators_311__WEBPACK_IMPORTED_MODULE_61__.Matreshka,
    315: _serverScripts_operators_315__WEBPACK_IMPORTED_MODULE_62__.Beleon,
    322: _serverScripts_operators_kazunion__WEBPACK_IMPORTED_MODULE_98__.Kazunion,
    331: _serverScripts_operators_331__WEBPACK_IMPORTED_MODULE_63__.Acti,
    343: _serverScripts_operators_343__WEBPACK_IMPORTED_MODULE_64__.PlanTravel1,
    344: _serverScripts_operators_344__WEBPACK_IMPORTED_MODULE_65__.Panteon,
    345: _serverScripts_operators_345__WEBPACK_IMPORTED_MODULE_66__.Vand,
    348: _serverScripts_operators_348__WEBPACK_IMPORTED_MODULE_67__.PlanTravel,
    361: _serverScripts_operators_361__WEBPACK_IMPORTED_MODULE_68__.SpaceTravel,
    378: _serverScripts_operators_378__WEBPACK_IMPORTED_MODULE_69__.PearlRiver,
    380: _serverScripts_operators_380__WEBPACK_IMPORTED_MODULE_70__.TUInew,
    382: _serverScripts_operators_382__WEBPACK_IMPORTED_MODULE_71__.SelfieTravel,
    392: _serverScripts_operators_392__WEBPACK_IMPORTED_MODULE_72__.Aerotour,
    415: _serverScripts_operators_415__WEBPACK_IMPORTED_MODULE_73__.Clickvoyage,
    429: _serverScripts_operators_429__WEBPACK_IMPORTED_MODULE_74__.RExpress,
    431: _serverScripts_operators_431__WEBPACK_IMPORTED_MODULE_75__.EliteTravel,
    432: _serverScripts_operators_432__WEBPACK_IMPORTED_MODULE_76__.Unicorn,
    439: _serverScripts_operators_439__WEBPACK_IMPORTED_MODULE_77__.Paks,
    449: _serverScripts_operators_449__WEBPACK_IMPORTED_MODULE_78__.OneTouchTravel,
    450: _serverScripts_operators_450__WEBPACK_IMPORTED_MODULE_79__.PegasTui,
    451: _serverScripts_operators_skanTour__WEBPACK_IMPORTED_MODULE_100__.SkanTour,
    452: _serverScripts_operators_452__WEBPACK_IMPORTED_MODULE_80__.D2,
    453: _serverScripts_operators_453__WEBPACK_IMPORTED_MODULE_81__.Veditour,
    454: _serverScripts_operators_454__WEBPACK_IMPORTED_MODULE_82__.IlineTours,
    521: _serverScripts_operators_vodohod__WEBPACK_IMPORTED_MODULE_101__.Vodohod,
    536: _serverScripts_operators_536__WEBPACK_IMPORTED_MODULE_83__.Krypton,
    544: _serverScripts_operators_544__WEBPACK_IMPORTED_MODULE_84__.CrimeanWave,
    560: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_90__.TourClick,
    564: _serverScripts_operators_564__WEBPACK_IMPORTED_MODULE_85__.RZHDTour,
    565: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_90__.TourClick,
    587: _serverScripts_operators_587__WEBPACK_IMPORTED_MODULE_86__.TourPlatforma,
    593: _serverScripts_operators_letsFly__WEBPACK_IMPORTED_MODULE_91__.LetsFly,
    620: _serverScripts_operators_unona__WEBPACK_IMPORTED_MODULE_104__.Unona,
    743: _serverScripts_operators_743__WEBPACK_IMPORTED_MODULE_87__.Loti,
    747: _serverScripts_operators_magput__WEBPACK_IMPORTED_MODULE_105__.MagPut,
    768: _serverScripts_operators_768__WEBPACK_IMPORTED_MODULE_88__.Mercury,
    797: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_90__.TourClick,
    800: _serverScripts_operators_800__WEBPACK_IMPORTED_MODULE_89__.MyAgent,
    820: _serverScripts_operators_rusExpress__WEBPACK_IMPORTED_MODULE_9__.RusExpress,
    803: _serverScripts_operators_letsFly__WEBPACK_IMPORTED_MODULE_91__.LetsFly,
    821: _serverScripts_operators_eskazan__WEBPACK_IMPORTED_MODULE_96__.EsKazan,
    860: _serverScripts_operators_melinoTravel__WEBPACK_IMPORTED_MODULE_102__.MelinoTravel,
    861: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_90__.TourClick,
    897: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_90__.TourClick,
    917: _serverScripts_operators_inturist__WEBPACK_IMPORTED_MODULE_5__.Intourist,
    926: _serverScripts_operators_oneClickTravel__WEBPACK_IMPORTED_MODULE_97__.OneClickTravel,
    922: _serverScripts_operators_rivieraTour__WEBPACK_IMPORTED_MODULE_103__.RivieraTour,
    943: _serverScripts_operators_tourClick__WEBPACK_IMPORTED_MODULE_90__.TourClick,
    949: _serverScripts_operators_kazunion__WEBPACK_IMPORTED_MODULE_98__.Kazunion,
    970: _serverScripts_operators_587__WEBPACK_IMPORTED_MODULE_86__.TourPlatforma,
    2147483639: _serverScripts_operators_2147483639__WEBPACK_IMPORTED_MODULE_92__.CityTravel,
    2147483640: _serverScripts_operators_2147483640__WEBPACK_IMPORTED_MODULE_93__.AcademService,
    2147483641: _serverScripts_operators_2147483641__WEBPACK_IMPORTED_MODULE_94__.Bronevik,
    2147483642: _serverScripts_operators_7__WEBPACK_IMPORTED_MODULE_4__.BiblioGlobus,
    2147483643: _serverScripts_operators_252__WEBPACK_IMPORTED_MODULE_51__.Alean,
    2147483645: _serverScripts_operators_2147483645__WEBPACK_IMPORTED_MODULE_95__.Ostrovok,
    2147483646: _serverScripts_operators_800__WEBPACK_IMPORTED_MODULE_89__.MyAgent
};


/***/ }),

/***/ "./src/app/services/chunks/getFillerDataByClaimId.ts":
/*!***********************************************************!*\
  !*** ./src/app/services/chunks/getFillerDataByClaimId.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFillerDataByClaimId: () => (/* binding */ getFillerDataByClaimId)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils */ "./src/app/utils/index.ts");
/* harmony import */ var _utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../utils/chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");


function getFillerDataByClaimId(params) {
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_1__.cbApiUrl, "/AutoFillerApi/GetAutoFillerDataByToken?").concat((0,_utils__WEBPACK_IMPORTED_MODULE_0__.stringifyQsParams)(params)))
        .then(function (response) { return response.json(); });
    // .catch((err) => new Promise<ErrorResponse<{}>>(resolve => resolve({
    //     message: err.toString(),
    //     payload: {}
    // } as ErrorResponse<{}>)));
}


/***/ }),

/***/ "./src/app/services/chunks/sendIdsToBookingCenter.ts":
/*!***********************************************************!*\
  !*** ./src/app/services/chunks/sendIdsToBookingCenter.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sendIdsToBookingCenter: () => (/* binding */ sendIdsToBookingCenter)
/* harmony export */ });
/* harmony import */ var _utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../../utils/chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");

function sendIdsToBookingCenter(claimId, tourOperatorClaimId, isConfirmed) {
    if (isConfirmed === void 0) { isConfirmed = false; }
    console.log("sendIdsToBookingCenter: claimId = ".concat(claimId, ", tourOperatorClaimId = ").concat(tourOperatorClaimId, ", cbApiUrl = ").concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl));
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/private/toolbarapi/setTourOperatorClaimNumber"), {
        method: 'post',
        headers: {
            'Content-type': 'application/json; charset=utf-8'
        },
        body: JSON.stringify({
            claimId: claimId,
            tourOperatorClaimId: tourOperatorClaimId,
            isConfirmed: isConfirmed
        })
    })
        .then(function (response) { return response.status === 200
        ? 'Ids has been sent' : 'Fail'; })
        .catch(function (error) { return error.message; });
}


/***/ }),

/***/ "./src/app/services/index.ts":
/*!***********************************!*\
  !*** ./src/app/services/index.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAuthLegalEntities: () => (/* binding */ getAuthLegalEntities),
/* harmony export */   getClaimRefundFileUrl: () => (/* binding */ getClaimRefundFileUrl),
/* harmony export */   getClaimRefundOperationDetails: () => (/* binding */ getClaimRefundOperationDetails),
/* harmony export */   getClaimTransferFileUrl: () => (/* binding */ getClaimTransferFileUrl),
/* harmony export */   getClaimTransferOperationDetails: () => (/* binding */ getClaimTransferOperationDetails),
/* harmony export */   getClaimUrl: () => (/* binding */ getClaimUrl),
/* harmony export */   "getOperatorLoginPathAndСredentials": () => (/* binding */ getOperatorLoginPathAndСredentials),
/* harmony export */   getScriptFromApi: () => (/* binding */ getScriptFromApi),
/* harmony export */   getSletatIdFromURL: () => (/* binding */ getSletatIdFromURL),
/* harmony export */   sendErrorReport: () => (/* binding */ sendErrorReport),
/* harmony export */   sendTourOperatorClaimDetailsToBookingCenter: () => (/* binding */ sendTourOperatorClaimDetailsToBookingCenter)
/* harmony export */ });
/* harmony import */ var _utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../utils/chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils */ "./src/app/utils/index.ts");
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");



function getClaimUrl(params) {
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/AutoFillerApi/GetTourOperatorPathToClaimByToken?").concat((0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params)))
        .then(function (response) { return response.json(); });
}
// при авторизации вызывается третьим
function getScriptFromApi(sletatId, scriptType) {
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.scriptsApiUrl, "/api/scripts/active?sletatId=").concat(sletatId, "&scriptType=").concat(scriptType))
        .then(function (response) { return response.json(); });
    // .catch( (err) => new Promise<null>(resolve => {
    //     console.log(`Error in getScriptFromApi ${err} for sletatId=${sletatId} and scriptType=${scriptType}`);
    //     resolve({});
    // }));
}
var sendTourOperatorClaimDetailsToBookingCenter = function (data) {
    return new Promise(function (resolve) {
        fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/private/toolbarapi/setTourOperatorClaimDetails"), {
            method: 'post',
            headers: {
                'Content-type': 'application/json; charset=utf-8'
            },
            body: JSON.stringify(data)
        }).then(function (response) { return resolve(response.status === 200 ? _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.DONE : _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_2__.SendIdsStatus.FAIL); });
    });
};
var sendErrorReport = function (params) { return new Promise(function (resolve, reject) {
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/AutoFillerApi/AutofillerErrorReport"), {
        method: 'post',
        headers: {
            'Content-type': 'application/json; charset=utf-8'
        },
        body: JSON.stringify(params)
    }).then(function (response) {
        return response.json().then(function (data) { return resolve(data.Result); });
    });
}); };
var getClaimTransferOperationDetails = function (params) { return new Promise(function (resolve, regect) {
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/AutoFillerApi/GetClaimTransferOperationDetails?").concat((0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params))).then(function (response) { return response.json().then(function (data) { return resolve(data.Result); }); });
}); };
var getClaimRefundOperationDetails = function (params) { return new Promise(function (resolve, reject) {
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/AutoFillerApi/GetClaimRefundOperationDetails?").concat((0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params))).then(function (response) { return response.json().then(function (data) { return resolve(data.Result); }); });
}); };
var getAuthLegalEntities = function () { return new Promise(function (resolve, reject) {
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/AutoFillerApi/GetAutofillerAuthLegalEntities")).then(function (response) { return response.json().then(function (data) { return resolve(data.Result); }); });
}); };
// при авторизации вызывается первым
var getSletatIdFromURL = function (params) { return new Promise(function (resolve, reject) {
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/AutoFillerApi/GetAutofillSletatIdFromUrl?").concat((0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params))).then(function (response) {
        if (!response.ok) {
            resolve({
                message: response.statusText,
                payload: {}
            });
        }
        response.json().then(function (data) { return resolve(data.Result); });
    });
}); };
// при авторизации вызывается вторым
var getOperatorLoginPathAndСredentials = function (params) { return new Promise(function (resolve, reject) {
    return fetch("".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/AutoFillerApi/GetOperatorLoginPathAnd\u0421redentials?").concat((0,_utils__WEBPACK_IMPORTED_MODULE_1__.stringifyQsParams)(params))).then(function (response) {
        if (!response.ok) {
            resolve({
                message: response.statusText,
                payload: {}
            });
        }
        response.json().then(function (data) { return resolve(data.Result); });
    });
}); };
var getClaimTransferFileUrl = function (transferId, template) {
    return "".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/api/files/GetClaimTransferDocument?transferId=").concat(transferId, "&template=").concat(template);
};
var getClaimRefundFileUrl = function (refundId, template) {
    return "".concat(_utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_0__.cbApiUrl, "/api/files/GetClaimRefundDocument?refundId=").concat(refundId, "&template=").concat(template);
};


/***/ }),

/***/ "./src/app/utils/chunks/addAsyncScriptToPageAndRun.ts":
/*!************************************************************!*\
  !*** ./src/app/utils/chunks/addAsyncScriptToPageAndRun.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addAsyncScriptToPage: () => (/* binding */ addAsyncScriptToPage),
/* harmony export */   addAsyncScriptToPageAndRun: () => (/* binding */ addAsyncScriptToPageAndRun)
/* harmony export */ });
var addAsyncScriptToPageAndRun = function (script, data) {
    addAsyncScriptToPage(script, data);
    setTimeout(function () {
        console.log('Let\'s roll async!');
        document.querySelector('#autoFillButton').click();
    }, 1000);
};
var addAsyncScriptToPage = function (script, data) {
    var buttonTeg = document.createElement('button');
    buttonTeg.id = 'autoFillButton';
    buttonTeg.setAttribute('onClick', 'doFillScript()');
    document.body.appendChild(buttonTeg);
    var scriptTeg = document.createElement('script');
    scriptTeg.id = 'autoFillScript';
    scriptTeg.innerHTML = "\n        async function doFillScript() {\n\n            debugger;\n\n            var data = ".concat(JSON.stringify(data), ";\n\n            (").concat(script, ")(data);\n        }");
    document.body.appendChild(scriptTeg);
};


/***/ }),

/***/ "./src/app/utils/chunks/addScriptToPageAndRun.ts":
/*!*******************************************************!*\
  !*** ./src/app/utils/chunks/addScriptToPageAndRun.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addScriptToPage: () => (/* binding */ addScriptToPage),
/* harmony export */   addScriptToPageAndRun: () => (/* binding */ addScriptToPageAndRun)
/* harmony export */ });
var addScriptToPageAndRun = function (script, data) {
    addScriptToPage(script, data);
    setTimeout(function () {
        console.log('Let\'s roll!');
        document.querySelector('#autoFillButton').click();
    }, 1000);
};
var addScriptToPage = function (script, data) {
    var buttonTeg = document.createElement('button');
    buttonTeg.id = 'autoFillButton';
    buttonTeg.setAttribute('onClick', 'doFillScript()');
    document.body.appendChild(buttonTeg);
    var scriptTeg = document.createElement('script');
    scriptTeg.id = 'autoFillScript';
    scriptTeg.innerHTML = "\n        function doFillScript() {\n\n            debugger;\n\n            var data = ".concat(JSON.stringify(data), ";\n\n            (").concat(script, ")(data);\n        }");
    document.body.appendChild(scriptTeg);
};


/***/ }),

/***/ "./src/app/utils/chunks/checkCookie.ts":
/*!*********************************************!*\
  !*** ./src/app/utils/chunks/checkCookie.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkCookie: () => (/* binding */ checkCookie)
/* harmony export */ });
function checkCookie(params) {
    return new Promise(function (resolve, reject) {
        chrome.cookies.get({ url: params.url, name: params.cookieName }, function (cookie) { return cookie && cookie.value && cookie.value.toLowerCase() === params.searchValue.toLowerCase()
            ? resolve()
            : reject(); });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/common/clientUtils.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/common/clientUtils.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   wait: () => (/* binding */ wait)
/* harmony export */ });
// тут будут лежать полезные скрипты, которые нужно копировать при добавлении кода на сайте ТО
function getTouristAge(tourist) {
    var _a = tourist.birthday.split('.'), day = _a[0], month = _a[1], year = _a[2];
    var ageDiffMs = Date.now() - new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10)).getTime();
    var ageDate = new Date(ageDiffMs);
    return ageDate.getUTCFullYear() - 1970;
}
function waitForSaving() {
    console.log('s');
    return new Promise(function (resolve, reject) {
        var timer = setInterval(function () {
            if (!document.querySelector('.main-button.save_person , .changePersonDialog[style*="display: block"] .bottom-bar-save-button')) {
                clearInterval(timer);
                console.log('f');
                resolve(true);
            }
        }, 1000);
    });
}
function wait(timeout) {
    return new Promise(function (resolve) {
        setTimeout(function () { return resolve(); }, timeout);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/constants_urls.ts":
/*!************************************************!*\
  !*** ./src/app/utils/chunks/constants_urls.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CB_CLAIM_FULL_PATH: () => (/* binding */ CB_CLAIM_FULL_PATH),
/* harmony export */   CB_CLAIM_ID_PARAM: () => (/* binding */ CB_CLAIM_ID_PARAM),
/* harmony export */   CB_CLAIM_PATH: () => (/* binding */ CB_CLAIM_PATH),
/* harmony export */   CB_HOSTS: () => (/* binding */ CB_HOSTS),
/* harmony export */   cbApiUrl: () => (/* binding */ cbApiUrl),
/* harmony export */   scriptsApiUrl: () => (/* binding */ scriptsApiUrl),
/* harmony export */   toNumberSaveUrl: () => (/* binding */ toNumberSaveUrl)
/* harmony export */ });
var env = 'prod';
// local api: http://local-api-cbdebug.sletat.ru
// dev api: https://api-cbdebug.sletat.ru
// urls
var cbApiUrl = env === 'local' ?
    'http://localhost:8081' :
    env === 'dev' ?
        'https://api-cbdebug.sletat.ru' :
        'https://api-cb.global.sletat.ru';
var toNumberSaveUrl = cbApiUrl + '/private/toolbarapi/setTourOperatorClaimNumber';
// TODO: не забыть поменять обратно https://autofill-api.sletat.ru
var scriptsApiUrl = env === 'local' || env === 'dev' ?
    'https://autofill-api.global.sletat.ru' :
    'https://autofill-api.global.sletat.ru';
//https://autofill-api.sletat.ru;
// dev-api: cbdebug.sletat.ru
// local-api: local-booking.sletat.ru
// url parts
var CB_HOSTS = env === 'local' ?
    ['127.0.0.1:8080', 'local-booking.sletat.ru'] :
    env === 'dev' ?
        ['cbdebug.sletat.ru'] :
        ['cb.sletat.ru', 'cb-25.sletat.ru', 'cb-75.sletat.ru', 'cb-rsv.sletat.ru', 'cb.global.sletat.ru'];
var CB_CLAIM_PATH = '/Claim';
var CB_CLAIM_FULL_PATH = '/Claim/Index';
var CB_CLAIM_ID_PARAM = 'claimId';


/***/ }),

/***/ "./src/app/utils/chunks/createPushNotification.ts":
/*!********************************************************!*\
  !*** ./src/app/utils/chunks/createPushNotification.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPushNotification: () => (/* binding */ createPushNotification)
/* harmony export */ });
/* harmony import */ var _models_chunks_createFillFnMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../models/chunks/createFillFnMessage */ "./src/app/models/chunks/createFillFnMessage.ts");
/* harmony import */ var _models_chunks_createSendIdsMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/chunks/createSendIdsMessage */ "./src/app/models/chunks/createSendIdsMessage.ts");


function createPushNotification(options) {
    var pushMessage = { title: '', body: { toString: function () { return ''; } } };
    switch (true) {
        case (options.hasOwnProperty('claimId')):
            var _a = options, claimId = _a.claimId, operator = _a.operator, errorText = _a.errorText;
            pushMessage = (0,_models_chunks_createFillFnMessage__WEBPACK_IMPORTED_MODULE_0__.createFillFnMessage)({ claimId: claimId, operator: operator, errorText: errorText });
            break;
        case (options.hasOwnProperty('status')):
            var _b = options, status_1 = _b.status, message = _b.message;
            pushMessage = (0,_models_chunks_createSendIdsMessage__WEBPACK_IMPORTED_MODULE_1__.createSendIdsMessage)({ status: status_1, message: message });
            break;
        case (options.hasOwnProperty('notificationMessage')):
            var _c = options, notificationMessage = _c.notificationMessage, title = _c.title;
            pushMessage.body = notificationMessage;
            pushMessage.title = title;
            pushMessage.toString = function () { return pushMessage.body.toString(); };
            break;
        default:
            break;
    }
    return new Promise(function (resolve, reject) {
        chrome.notifications.create({ type: 'basic', iconUrl: 'icon.png', title: pushMessage.title, message: pushMessage.toString() }, function () { return resolve(); });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/createTab.ts":
/*!*******************************************!*\
  !*** ./src/app/utils/chunks/createTab.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTab: () => (/* binding */ createTab)
/* harmony export */ });
function createTab(_a) {
    var active = _a.active, url = _a.url;
    return new Promise(function (resolve, reject) {
        chrome.tabs.query({ active: true, lastFocusedWindow: true }, function (tabs) {
            var properties = {
                url: url,
                active: active,
                index: tabs && tabs.length >= 1
                    ? tabs[0].index + 1
                    : undefined
            };
            chrome.tabs.create(properties, function (tab) { return resolve(tab); });
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/delay.ts":
/*!***************************************!*\
  !*** ./src/app/utils/chunks/delay.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   delay: () => (/* binding */ delay)
/* harmony export */ });
function delay(timeout) {
    return new Promise(function (resolve) {
        setTimeout(function () { return resolve(); }, timeout);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/executeScript.ts":
/*!***********************************************!*\
  !*** ./src/app/utils/chunks/executeScript.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeScript: () => (/* binding */ executeScript)
/* harmony export */ });
function executeScript(frame, code) {
    return new Promise(function (resolve, reject) {
        chrome.tabs.executeScript(frame.tabId, { frameId: frame.id, code: code }, function (result) {
            var message = JSON.parse(result[0]);
            if (message) {
                return reject(message);
            }
            return resolve();
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/executeScriptInTab.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/executeScriptInTab.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   executeScriptInTab: () => (/* binding */ executeScriptInTab)
/* harmony export */ });
/* harmony import */ var _injectCoreFunctionsIntoPage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./injectCoreFunctionsIntoPage */ "./src/app/utils/chunks/injectCoreFunctionsIntoPage.ts");

function executeScriptInTab(tab, options) {
    return new Promise(function (resolve, reject) {
        (0,_injectCoreFunctionsIntoPage__WEBPACK_IMPORTED_MODULE_0__.injectCoreFunctionsIntoPage)(tab)
            .then(function () {
            chrome.tabs.executeScript(tab.id, options, function (result) {
                // in here we are waiting for object with error message to come
                // to send push notification about filling script failure
                try {
                    var message = JSON.parse(result[0]);
                    if (message && message.error) {
                        return reject(message);
                    }
                    // leave catch block empty cause we need to pass
                    // stuff down in case of success
                    // tslint:disable-next-line:no-empty
                }
                catch (e) { }
                return resolve(tab);
            });
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/injectCoreFunctionsIntoPage.ts":
/*!*************************************************************!*\
  !*** ./src/app/utils/chunks/injectCoreFunctionsIntoPage.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   injectCoreFunctionsIntoPage: () => (/* binding */ injectCoreFunctionsIntoPage)
/* harmony export */ });
/* harmony import */ var _pagePanel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../pagePanel */ "./src/app/utils/pagePanel.ts");
/* harmony import */ var _injectFunctionIntoPage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./injectFunctionIntoPage */ "./src/app/utils/chunks/injectFunctionIntoPage.ts");


var injectCoreFunctionsIntoPage = function (tab) { return Promise.all(_pagePanel__WEBPACK_IMPORTED_MODULE_0__.coreFunctions.map(function (x) { return (0,_injectFunctionIntoPage__WEBPACK_IMPORTED_MODULE_1__.injectFunctionIntoPage)(tab, x); })); };


/***/ }),

/***/ "./src/app/utils/chunks/injectFunctionIntoPage.ts":
/*!********************************************************!*\
  !*** ./src/app/utils/chunks/injectFunctionIntoPage.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   injectFunctionIntoPage: () => (/* binding */ injectFunctionIntoPage)
/* harmony export */ });
// injects function definition to window scope. Does not inject dependencies
var injectFunctionIntoPage = function (tab, func) { return new Promise(function (resolve) {
    chrome.tabs.executeScript(tab.id, { code: "window['".concat(func.name, "'] = ").concat(func) }, function (result) { return resolve(0); });
}); };


/***/ }),

/***/ "./src/app/utils/chunks/loginFormCode.ts":
/*!***********************************************!*\
  !*** ./src/app/utils/chunks/loginFormCode.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   loginFormCode: () => (/* binding */ loginFormCode)
/* harmony export */ });
var loginFormCode = function (_a) {
    var login = _a.login, password = _a.password, _b = _a.packet, loginPath = _b.loginPath, passwordPath = _b.passwordPath, submitPath = _b.submitPath;
    return "\n    try {\n\n        debugger;\n\n        if (!login && !password && !submit) {\n            var login;\n            var password;\n            var submit;\n        }\n        login = document.querySelector(\"".concat(loginPath.replace(/\\'/g, '\\\''), "\");\n        password = document.querySelector(\"").concat(passwordPath.replace(/\'/g, '\\\''), "\");\n        submit = document.querySelector(\"").concat(submitPath.replace(/\'/g, '\\\''), "\");\n\n        if (login !== null) {\n            login.dispatchEvent(new Event('focus'));\n            login.value = '").concat(login, "';\n\n            // on TUI site there's Knockout hook matching only on keypress event\n            // so without this workaroud we couldn't post login value\n            login.dispatchEvent(new Event('keypress', { bubbles: true }));\n            login.dispatchEvent(new Event('input', { bubbles: true }));\n            login.dispatchEvent(new Event('change', { bubbles: true }));\n            login.dispatchEvent(new Event('blur', { bubbles: true }));\n\n            password.dispatchEvent(new Event('focus', { bubbles: true }));\n            password.value = '").concat(password, "';\n            password.dispatchEvent(new Event('input', { bubbles: true }));\n            password.dispatchEvent(new Event('keypress', { bubbles: true }));\n            password.dispatchEvent(new Event('change', { bubbles: true }));\n            password.dispatchEvent(new Event('blur', { bubbles: true }));\n\n            setTimeout(function(){submit.click();}, 500)\n        }\n\n\n    } catch (e) {\n        JSON.stringify({error: e.stack});\n    }\n");
};


/***/ }),

/***/ "./src/app/utils/chunks/navigateToClaimPage.ts":
/*!*****************************************************!*\
  !*** ./src/app/utils/chunks/navigateToClaimPage.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navigateToClaimPage: () => (/* binding */ navigateToClaimPage)
/* harmony export */ });
/* harmony import */ var _executeScript__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./executeScript */ "./src/app/utils/chunks/executeScript.ts");
/* harmony import */ var _loginFormCode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./loginFormCode */ "./src/app/utils/chunks/loginFormCode.ts");
/* harmony import */ var _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");



function navigateToClaimPage(tab, operator, packet) {
    return new Promise(function (resolve, reject) {
        function func(frame) {
            if (frame.tabId !== tab.id) {
                return;
            }
            chrome.webNavigation.onCompleted.removeListener(func);
            var code = (0,_loginFormCode__WEBPACK_IMPORTED_MODULE_1__.loginFormCode)(new _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_2__.PageSelectors({
                login: operator.credentials.login,
                packet: packet,
                password: operator.credentials.password
            }));
            console.log('loginFormCode');
            console.log(code);
            (0,_executeScript__WEBPACK_IMPORTED_MODULE_0__.executeScript)(frame, code);
            return resolve(frame);
        }
        chrome.webNavigation.onCompleted.addListener(func);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/navigateToClaimPageCustomeLoginCodeAndCompany.ts":
/*!*******************************************************************************!*\
  !*** ./src/app/utils/chunks/navigateToClaimPageCustomeLoginCodeAndCompany.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navigateToClaimPageCustomeLoginCodeAndCompany: () => (/* binding */ navigateToClaimPageCustomeLoginCodeAndCompany)
/* harmony export */ });
/* harmony import */ var _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _executeScript__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./executeScript */ "./src/app/utils/chunks/executeScript.ts");


function navigateToClaimPageCustomeLoginCodeAndCompany(tab, credentians, packet, customeLoginFormCode) {
    return new Promise(function (resolve, reject) {
        function func(frame) {
            if (frame.tabId !== tab.id) {
                return;
            }
            chrome.webNavigation.onCompleted.removeListener(func);
            var code = customeLoginFormCode(new _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: credentians.login,
                packet: packet,
                password: credentians.password,
                company: credentians.company
            }));
            //console.log('loginFormCode');
            //console.log(code);
            (0,_executeScript__WEBPACK_IMPORTED_MODULE_1__.executeScript)(frame, code);
            return resolve(frame);
        }
        chrome.webNavigation.onCompleted.addListener(func);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/navigateToClaimPageNew.ts":
/*!********************************************************!*\
  !*** ./src/app/utils/chunks/navigateToClaimPageNew.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navigateToClaimPageNew: () => (/* binding */ navigateToClaimPageNew)
/* harmony export */ });
/* harmony import */ var _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../messages/chunks/pageSelectors */ "./src/app/messages/chunks/pageSelectors.ts");
/* harmony import */ var _executeScript__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./executeScript */ "./src/app/utils/chunks/executeScript.ts");
/* harmony import */ var _loginFormCode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./loginFormCode */ "./src/app/utils/chunks/loginFormCode.ts");



function navigateToClaimPageNew(tab, credentians, packet) {
    return new Promise(function (resolve, reject) {
        function func(frame) {
            if (frame.tabId !== tab.id) {
                return;
            }
            chrome.webNavigation.onCompleted.removeListener(func);
            var code = (0,_loginFormCode__WEBPACK_IMPORTED_MODULE_2__.loginFormCode)(new _messages_chunks_pageSelectors__WEBPACK_IMPORTED_MODULE_0__.PageSelectors({
                login: credentians.login,
                packet: packet,
                password: credentians.password
            }));
            console.log('loginFormCode');
            console.log(code);
            (0,_executeScript__WEBPACK_IMPORTED_MODULE_1__.executeScript)(frame, code);
            return resolve(frame);
        }
        chrome.webNavigation.onCompleted.addListener(func);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/reloadTab.ts":
/*!*******************************************!*\
  !*** ./src/app/utils/chunks/reloadTab.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   reloadTab: () => (/* binding */ reloadTab)
/* harmony export */ });
var reloadTab = function (tab) { return new Promise(function (resolve) {
    return chrome.tabs.reload(tab.id, {}, function () { return resolve(0); });
}); };


/***/ }),

/***/ "./src/app/utils/chunks/removeCookies.ts":
/*!***********************************************!*\
  !*** ./src/app/utils/chunks/removeCookies.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   removeCookies: () => (/* binding */ removeCookies)
/* harmony export */ });
function removeCookies(params) {
    var promise = new Promise(function (resolve) { return resolve(); });
    params.cookieNames.forEach(function (cookieName) {
        promise = promise.then(function () { return new Promise(function (resolve, reject) {
            chrome.cookies.remove({ url: params.url, name: cookieName }, function (details) { return resolve(); });
        }); });
    });
    return promise;
}


/***/ }),

/***/ "./src/app/utils/chunks/removeFromLocalStorage.ts":
/*!********************************************************!*\
  !*** ./src/app/utils/chunks/removeFromLocalStorage.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   removeFromLocalStorage: () => (/* binding */ removeFromLocalStorage)
/* harmony export */ });
var storage = chrome.storage.local;
function removeFromLocalStorage(key) {
    return new Promise(function (resolve, reject) {
        storage.remove(key, function () {
            var error = chrome.runtime.lastError;
            if (error) {
                console.error(error);
            }
            resolve();
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/sendTabMessage.ts":
/*!************************************************!*\
  !*** ./src/app/utils/chunks/sendTabMessage.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sendTabMessage: () => (/* binding */ sendTabMessage)
/* harmony export */ });
function sendTabMessage(tabId, message) {
    return new Promise(function (resolve, reject) {
        chrome.tabs.sendMessage(tabId, message, function (response) {
            // console.log('RESPONSE TAB ', response);
            return resolve(response);
        });
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/setSessionStorageKeyInTab.ts":
/*!***********************************************************!*\
  !*** ./src/app/utils/chunks/setSessionStorageKeyInTab.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   setSessionStorageKeyInTab: () => (/* binding */ setSessionStorageKeyInTab)
/* harmony export */ });
/* harmony import */ var _executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _executives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../executives */ "./src/app/utils/executives.ts");


function setSessionStorageKeyInTab(tab, key, value) {
    return (0,_executeScriptInTab__WEBPACK_IMPORTED_MODULE_0__.executeScriptInTab)(tab, { code: (0,_executives__WEBPACK_IMPORTED_MODULE_1__.setSessionStorageKey)({ key: key, value: value }) });
}


/***/ }),

/***/ "./src/app/utils/chunks/startTrackingElementByProp.ts":
/*!************************************************************!*\
  !*** ./src/app/utils/chunks/startTrackingElementByProp.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   startTrackingElementByProp: () => (/* binding */ startTrackingElementByProp)
/* harmony export */ });
function startTrackingElementByProp(tab, selector, prop, predicate, frame, delay, maxWaitTime) {
    if (delay === void 0) { delay = 1000; }
    if (maxWaitTime === void 0) { maxWaitTime = 300000; }
    return new Promise(function (resolve, reject) {
        var getElement_f = function (selector, prop) { return "document.querySelector('".concat(selector, "').").concat(prop); };
        var curTime = Date.now();
        var timer = setInterval(function () {
            chrome.tabs.executeScript(tab.id, { code: getElement_f(selector, prop) }, function (result) {
                if (result && result[0] && predicate(result[0])) {
                    clearInterval(timer);
                    resolve(result[0]);
                }
                if (Date.now() - curTime >= maxWaitTime) {
                    clearInterval(timer);
                    reject(null);
                }
            });
        }, delay);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/startTrackingElementInternal.ts":
/*!**************************************************************!*\
  !*** ./src/app/utils/chunks/startTrackingElementInternal.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   startTrackingElement: () => (/* binding */ startTrackingElement),
/* harmony export */   startTrackingElementDisappear: () => (/* binding */ startTrackingElementDisappear)
/* harmony export */ });
/* harmony import */ var _sendTabMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../messages */ "./src/app/messages/index.ts");


// грубо говоря эта функция ждет появления selector в tab-e
function startTrackingElement(tab, selector, frame, delay, maxWaitTime) {
    if (delay === void 0) { delay = 1000; }
    if (maxWaitTime === void 0) { maxWaitTime = 300000; }
    return startTrackingElementInternal(function (response) { return response.element; }, tab, selector, frame, delay, maxWaitTime);
}
function startTrackingElementDisappear(tab, selector, frame, delay, maxWaitTime) {
    if (delay === void 0) { delay = 1000; }
    if (maxWaitTime === void 0) { maxWaitTime = 300000; }
    return startTrackingElementInternal(function (response) { return !response.element; }, tab, selector, frame, delay, maxWaitTime);
}
var startTrackingElementInternal = function (conditionFunc, tab, selector, frame, delay, maxWaitTime) {
    if (delay === void 0) { delay = 1000; }
    if (maxWaitTime === void 0) { maxWaitTime = 300000; }
    return new Promise(function (resolve, reject) {
        var curTime = Date.now();
        var timer = setInterval(function () {
            (0,_sendTabMessage__WEBPACK_IMPORTED_MODULE_0__.sendTabMessage)(tab.id, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetElementMessage)({ elementSelector: selector, frame: frame }))
                .then(function (response) {
                if (response && conditionFunc(response)) {
                    clearInterval(timer);
                    resolve(response);
                }
                if (Date.now() - curTime >= maxWaitTime) {
                    clearInterval(timer);
                    reject(null);
                }
            });
        }, delay);
    });
};


/***/ }),

/***/ "./src/app/utils/chunks/stringifyFn.ts":
/*!*********************************************!*\
  !*** ./src/app/utils/chunks/stringifyFn.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyFn: () => (/* binding */ stringifyFn)
/* harmony export */ });
function stringifyFn(fn, data) {
    var fnStr = fn.toString();
    return "\n        try {\n            if (!data && !filler) {\n                var data;\n                var filler;\n            }\n\n            try {\n                data = ".concat(JSON.stringify(data), ";\n            } catch (e) {\n                console.dir(e);\n                window.createPagePanel( window.createErrorPanel('\u0421\u043F\u0435\u0446\u0441\u0438\u043C\u0432\u043E\u043B\u044B \u0432 \u0434\u0430\u043D\u043D\u044B\u0445 \u0442\u0443\u0440\u0438\u0441\u0442\u0430!', '<p>\u0424\u0438\u043B\u044F, \u043A \u0441\u043E\u0436\u0430\u043B\u0435\u043D\u0438\u044E, \u043D\u0435 \u0443\u043C\u0435\u0435\u0442 \u0437\u0430\u043F\u043E\u043B\u043D\u044F\u0442\u044C \u0441\u043F\u0435\u0446\u0441\u0438\u043C\u0432\u043E\u043B\u044B.</p><p>\u041F\u0440\u043E\u0432\u0435\u0440\u044C\u0442\u0435 \u0438\u0445 \u043D\u0430\u043B\u0438\u0447\u0438\u0435 \u0432 \u043F\u043E\u043B\u044F\u0445 \u0442\u0443\u0440\u0438\u0441\u0442\u0430.</p> <ul><li><b>&#92; &#47; &#124;</b></li><li><b>&#58; &#59; &#96; &#39; &#44;</b></li><li><b>&#45; &#46; &#95;</b></li><li>\u0438 \u0442\u0430\u043A \u0434\u0430\u043B\u0435\u0435...</li></ul>'));\n                throw e;\n            }\n            if (data) {\n                filler = ").concat(fnStr, ";\n                filler(data);\n            }\n        } catch (e) {\n            console.dir(e);\n            window.createPagePanel( window.createErrorPanel('\u041E\u0448\u0438\u0431\u043A\u0430 \u0432 \u0444\u0438\u043B\u0435 :( executives.ts stringifyFn', e));\n            JSON.stringify({error: e.stack});\n        }\n    ");
}


/***/ }),

/***/ "./src/app/utils/chunks/trackingIdSelector.ts":
/*!****************************************************!*\
  !*** ./src/app/utils/chunks/trackingIdSelector.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   startTrackingElementValue: () => (/* binding */ startTrackingElementValue),
/* harmony export */   startTrackingIdSelector: () => (/* binding */ startTrackingIdSelector),
/* harmony export */   startTrackingIdSelectorWithClaimNumberValidation: () => (/* binding */ startTrackingIdSelectorWithClaimNumberValidation)
/* harmony export */ });
/* harmony import */ var _messages_chunks_createGetIdsMessage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../messages/chunks/createGetIdsMessage */ "./src/app/messages/chunks/createGetIdsMessage.ts");
/* harmony import */ var _sendTabMessage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");


function startTrackingIdSelector(tab, idSelector, delay, timeLimit) {
    if (delay === void 0) { delay = 1000; }
    if (timeLimit === void 0) { timeLimit = 600000; }
    return trackingIdSelector(tab, (0,_messages_chunks_createGetIdsMessage__WEBPACK_IMPORTED_MODULE_0__.createGetIdsMessage)({ claimNo: idSelector }), delay, timeLimit);
}
function startTrackingIdSelectorWithClaimNumberValidation(tab, idSelector, claimNumber, delay, timeLimit) {
    if (delay === void 0) { delay = 1000; }
    if (timeLimit === void 0) { timeLimit = 600000; }
    var message = (0,_messages_chunks_createGetIdsMessage__WEBPACK_IMPORTED_MODULE_0__.createGetIdsMessage)({ claimNo: idSelector });
    message.payload.claimNumber = claimNumber;
    return trackingIdSelector(tab, message, delay, timeLimit, function (response) { return response && response.claimNo.length && response.claimNumber === claimNumber; });
}
function startTrackingElementValue(tab, idSelector, delay, timeLimit) {
    if (delay === void 0) { delay = 1000; }
    if (timeLimit === void 0) { timeLimit = 600000; }
    var message = (0,_messages_chunks_createGetIdsMessage__WEBPACK_IMPORTED_MODULE_0__.createGetIdsMessage)({ claimNo: idSelector });
    return trackingIdSelector(tab, message, delay, timeLimit, function (response) { return response && response.claimNoValue; });
}
function trackingIdSelector(tab, message, delay, timeLimit, resolveCondition) {
    if (timeLimit === void 0) { timeLimit = 600000; }
    if (resolveCondition === void 0) { resolveCondition = function (response) {
        return response && response.claimNo.length;
    }; }
    return new Promise(function (resolve, reject) {
        var curTime = Date.now();
        var timer = setInterval(function () {
            (0,_sendTabMessage__WEBPACK_IMPORTED_MODULE_1__.sendTabMessage)(tab.id, message)
                .then(function (response) {
                // console.log('trackingIdSelector response');
                // console.dir(response);
                if (resolveCondition(response)) {
                    clearInterval(timer);
                    resolve(response);
                }
                if (Date.now() - curTime >= timeLimit && (!response || !response.claimNo.length)) {
                    clearInterval(timer);
                    reject('Time limit exeeded');
                }
            });
        }, delay);
    });
}


/***/ }),

/***/ "./src/app/utils/chunks/unifyTouristIdenify.ts":
/*!*****************************************************!*\
  !*** ./src/app/utils/chunks/unifyTouristIdenify.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   unifyTouristIdenify: () => (/* binding */ unifyTouristIdenify)
/* harmony export */ });
// unified algorithm used to identify tourist in set by some data (preferably scrapped from web page)
var unifyTouristIdenify = function (touristsSet, identifyData) { return new Promise(function (resolve, reject) {
    // tourist matching comparer
    var isTouristMatchData = function (tourist) {
        var prepare = function (val) {
            // omophones list for different transliteration standarts
            var omonims = [
                { key: 'iu', repl: 'yu' },
                { key: 'ye', repl: 'e' },
                { key: 'jj', repl: 'j' },
                { key: 'kh', repl: 'ch' },
                { key: 'cz', repl: 'ts' },
                { key: 'ts', repl: 'c' },
                { key: 'shch', repl: 'shh' },
                { key: 'ja', repl: 'ya' },
                { key: 'ii', repl: 'i' },
            ];
            omonims.forEach(function (om) { val = val.replace(om.key, om.repl); });
            return val;
        };
        var nameMatch = identifyData.name
            ?
                tourist.name ? prepare(identifyData.name.toLowerCase().trim()) === prepare(tourist.name.toLowerCase().trim()) :  false ||
                    tourist.nameEng ? prepare(identifyData.name.toLowerCase().trim()) === prepare(tourist.nameEng.toLowerCase().trim()) :  false ||
                    tourist.nameRus ? prepare(identifyData.name.toLowerCase().trim()) === prepare(tourist.nameRus.toLowerCase().trim()) : false
            : false;
        var surnameMatch = identifyData.surname
            ?
                tourist.surname ? prepare(identifyData.surname.toLowerCase().trim()) === prepare(tourist.surname.toLowerCase().trim()) :  false ||
                    tourist.surnameEng ? prepare(identifyData.surname.toLowerCase().trim()) === prepare(tourist.surnameEng.toLowerCase().trim()) :  false ||
                    tourist.surnameRus ? prepare(identifyData.surname.toLowerCase().trim()) === prepare(tourist.surnameRus.toLowerCase().trim()) : false
            : false;
        // birthdate affects comparer output only if it is determined in both identify data and tourist model
        var birthDateMatch = true;
        if (identifyData.dateOfBirth && tourist.birthday) {
            var dataMatch = identifyData.dateOfBirth.match(/([0-9]{1,2})[\.\/]([0-9]{2})[\.\/]([0-9]{4})/);
            var dataDay = dataMatch[1];
            var dataMonth = dataMatch[2];
            var dataYear = dataMatch[3];
            var touristDataMatch = tourist.birthday.match(/([0-9]{2})[\.\/]([0-9]{2})[\.\/]([0-9]{4})/);
            var touristDay = dataMatch[1];
            var touristMonth = dataMatch[2];
            var touristYear = dataMatch[3];
            birthDateMatch =
                dataDay === touristDay &&
                    dataMonth === touristMonth &&
                    dataYear === touristYear;
        }
        return nameMatch && surnameMatch && birthDateMatch;
    };
    touristsSet.forEach(function (tourist, index) {
        if (isTouristMatchData(tourist)) {
            resolve(tourist);
        }
    });
    console.log(touristsSet);
    reject("Unable to identify tourist (".concat(identifyData.name, " ").concat(identifyData.surname, " ").concat(identifyData.dateOfBirth, ") in given set"));
}); };


/***/ }),

/***/ "./src/app/utils/chunks/waitForTabLoad.ts":
/*!************************************************!*\
  !*** ./src/app/utils/chunks/waitForTabLoad.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   waitForTabLoad: () => (/* binding */ waitForTabLoad)
/* harmony export */ });
function waitForTabLoad(sourceTabId, timeLimit) {
    if (timeLimit === void 0) { timeLimit = 600000; }
    return new Promise(function (resolve, reject) {
        var listener = function (tabId, changeInfo) {
            if (changeInfo.status === 'complete' && tabId === sourceTabId) {
                chrome.tabs.onUpdated.removeListener(listener);
                resolve();
            }
        };
        chrome.tabs.onUpdated.addListener(listener);
        setTimeout(function () {
            chrome.tabs.onUpdated.removeListener(listener);
            reject();
        }, timeLimit);
    });
}


/***/ }),

/***/ "./src/app/utils/constants.ts":
/*!************************************!*\
  !*** ./src/app/utils/constants.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RU_DOMISTIC_COUNTRIES: () => (/* binding */ RU_DOMISTIC_COUNTRIES),
/* harmony export */   claimAnotherTOAliasSelector: () => (/* binding */ claimAnotherTOAliasSelector),
/* harmony export */   claimIdTOSelector: () => (/* binding */ claimIdTOSelector),
/* harmony export */   claimMagnifierButtonStyles: () => (/* binding */ claimMagnifierButtonStyles),
/* harmony export */   claimMagnifierOperatorTypes: () => (/* binding */ claimMagnifierOperatorTypes),
/* harmony export */   claimNumberSelector: () => (/* binding */ claimNumberSelector),
/* harmony export */   claimRefundFillerOperators: () => (/* binding */ claimRefundFillerOperators),
/* harmony export */   claimSecretFieldAttr: () => (/* binding */ claimSecretFieldAttr),
/* harmony export */   claimSecretFieldId: () => (/* binding */ claimSecretFieldId),
/* harmony export */   claimTOAliasSelector: () => (/* binding */ claimTOAliasSelector),
/* harmony export */   claimTransferFillerOperators: () => (/* binding */ claimTransferFillerOperators),
/* harmony export */   fileHostName: () => (/* binding */ fileHostName),
/* harmony export */   loaderImageName: () => (/* binding */ loaderImageName),
/* harmony export */   mockPrevVisasData: () => (/* binding */ mockPrevVisasData),
/* harmony export */   myAgentTicketButtonOptions: () => (/* binding */ myAgentTicketButtonOptions),
/* harmony export */   myAgentTicketTransferButtonOptions: () => (/* binding */ myAgentTicketTransferButtonOptions),
/* harmony export */   refundPaymentTOButtonOptions: () => (/* binding */ refundPaymentTOButtonOptions),
/* harmony export */   sourceAutoFillAccomodationSelector: () => (/* binding */ sourceAutoFillAccomodationSelector),
/* harmony export */   sourceAutoFillAnotherSelector: () => (/* binding */ sourceAutoFillAnotherSelector),
/* harmony export */   sourceAutoFillFlightSelector: () => (/* binding */ sourceAutoFillFlightSelector),
/* harmony export */   sourceAutoFillSelector: () => (/* binding */ sourceAutoFillSelector),
/* harmony export */   sourceAutoFillerToken: () => (/* binding */ sourceAutoFillerToken),
/* harmony export */   sourceAutoFillerTokenAccomodation: () => (/* binding */ sourceAutoFillerTokenAccomodation),
/* harmony export */   sourceAutoFillerTokenAnother: () => (/* binding */ sourceAutoFillerTokenAnother),
/* harmony export */   sourceAutoFillerTokenFlight: () => (/* binding */ sourceAutoFillerTokenFlight),
/* harmony export */   sourceIdSelector: () => (/* binding */ sourceIdSelector),
/* harmony export */   transferPaymentTOButtonOptions: () => (/* binding */ transferPaymentTOButtonOptions)
/* harmony export */ });
var RU_DOMISTIC_COUNTRIES = 'Россия,Абхазия,Беларусь,Казахстан,Армения,Киргизия';
// selectors
var sourceAutoFillSelector = 'input[data-claim="autofill-data-touroperator"]';
var sourceAutoFillAnotherSelector = 'input[data-claim="autofill-data-another-touroperator"]';
var sourceAutoFillAccomodationSelector = 'input[data-claim="autofill-data-accomodation-touroperator"]';
var sourceAutoFillFlightSelector = 'input[data-claim="autofill-data-flight-touroperator"]';
var sourceAutoFillerToken = '#AutoFillerToken';
var sourceAutoFillerTokenAnother = '#AutoFillerTokenAnother';
var sourceAutoFillerTokenAccomodation = '#AutoFillerTokenAccomodation';
var sourceAutoFillerTokenFlight = '#AutoFillerTokenFlight';
var sourceIdSelector = '[data-claim-sourceid]';
var claimNumberSelector = '[data-claim-number]';
var claimIdTOSelector = '[data-claim-touroperatornumber]';
var claimSecretFieldId = '#AutoFillerToken';
var claimSecretFieldAttr = '[data-autofiller]';
var claimTOAliasSelector = '[data-claim-toalias]';
var claimAnotherTOAliasSelector = '[data-claim-anothertoalias]';
var loaderImageName = 'loader.gif';
//export const loaderImageName = 'loader-new_year.gif';
// loaders
var fileHostName = 'https://localhost:5555/api/visa-fill/version';
var mockPrevVisasData = [
    {
        countyName: 'Исландия',
        countryId: 0,
        validFrom: '03.02.2016',
        validTo: '04.02.2016',
        number: 'AAAA',
    },
    {
        countyName: 'Швеция',
        countryId: 0,
        validFrom: '03.02.2017',
        validTo: '04.02.2017',
        number: 'AAAA',
    }
];
var transferPaymentTOButtonOptions = {
    className: 'uk-button uk-button-minw-40',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Перейти на страницу оформления переноса',
};
var refundPaymentTOButtonOptions = {
    className: 'uk-button uk-button-minw-40',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Перейти на страницу оформления возврата',
};
var myAgentTicketButtonOptions = {
    className: 'uk-button uk-button-minw-40',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Купить билет на Мой Агент',
};
var myAgentTicketTransferButtonOptions = {
    className: 'uk-button uk-button-minw-40 myAgentTransfer',
    'data-uk-tooltip': 'data-uk-tooltip',
    title: 'Купить билет на Мой Агент',
};
var claimTransferFillerOperators = [9];
var claimRefundFillerOperators = [9];
//export const goToMyAgentOperators: number[] = [452];
// each operator now has several magnifier buttons with different behaviour
var claimMagnifierOperatorTypes = {
    3: ['default', 'reserve'],
    4: ['default'],
    6: ['default'],
    7: ['default'],
    9: ['default'],
    14: ['default'],
    19: ['default', 'reserve'],
    20: ['default'],
    38: ['default'],
    39: ['default'],
    41: ['default'],
    46: ['default'],
    49: ['default'],
    51: ['default'],
    53: ['default'],
    54: ['default'],
    78: ['default'],
    81: ['default'],
    83: ['default'],
    87: ['default'],
    93: ['default'],
    107: ['default'],
    108: ['default'],
    112: ['default'],
    113: ['default'],
    123: ['default'],
    125: ['default'],
    130: ['default'],
    131: ['default'],
    141: ['default'],
    153: ['default'],
    155: ['default'],
    158: ['default'],
    160: ['default'],
    165: ['default'],
    171: ['default'],
    184: ['default'],
    199: ['default'],
    205: ['default'],
    213: ['default'],
    214: ['default'],
    229: ['default'],
    231: ['default'],
    237: ['default'],
    238: ['default'],
    248: ['default'],
    252: ['default'],
    259: ['default'],
    260: ['default'],
    269: ['default'],
    277: ['default'],
    301: ['default'],
    302: ['default'],
    304: ['default'],
    306: ['default'],
    309: ['default'],
    311: ['default'],
    315: ['default'],
    331: ['default'],
    343: ['default'],
    344: ['default'],
    345: ['default'],
    348: ['default'],
    355: ['default'],
    361: ['default'],
    380: ['default'],
    431: ['default'],
};
// styles for each magnifier buttonType
var claimMagnifierButtonStyles = {
    'default': {
        id: 'autofill-goto-claim',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО',
        activeClass: 'orange',
    },
    'default-another': {
        id: 'autofill-goto-claim-another',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО (фактический)',
        activeClass: 'purple',
    },
    'default-acc': {
        id: 'autofill-goto-claim-accomodation',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО (проживание)',
        activeClass: 'green',
    },
    'default-flg': {
        id: 'autofill-goto-claim-flight',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на сайте ТО (перелет)',
        activeClass: 'yellow',
    },
    'reserve': {
        id: 'autofill-goto-claim',
        className: 'ui icon button',
        style: {
            width: '30px',
            height: '30px',
            marginTop: '4px',
            marginRight: '4px',
            padding: '0px',
            cursor: 'pointer',
            zIndex: 1,
            pointerEvents: 'auto !important',
            display: 'inline-block',
            float: 'left',
        },
        title: 'Перейти в заявку на резервном сайте ТО',
        activeClass: 'blue',
    },
};


/***/ }),

/***/ "./src/app/utils/cookie.ts":
/*!*********************************!*\
  !*** ./src/app/utils/cookie.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCBAutofillAccountCookie: () => (/* binding */ getCBAutofillAccountCookie),
/* harmony export */   startTrackingCookie: () => (/* binding */ startTrackingCookie)
/* harmony export */ });
function startTrackingCookie(params, delay) {
    if (delay === void 0) { delay = 1000; }
    return new Promise(function (resolve, reject) {
        var curTime = Date.now();
        var timer = setInterval(function () {
            chrome.cookies.get({ url: params.url, name: params.cookieName }, function (cookie) {
                if (cookie) {
                    resolve();
                }
                if (Date.now() - curTime >= 300000 && !cookie) {
                    clearInterval(timer);
                    reject('Time limit exeeded');
                }
            });
        }, delay);
    });
}
var getCBAutofillAccountCookie = function () { return new Promise(function (resolve, reject) {
    chrome.cookies.get({ url: 'https://cb.sletat.ru/', name: 'autofill_account_cookie' }, function (cookie) {
        if (cookie) {
            resolve(cookie.value);
        }
        else {
            chrome.cookies.get({ url: 'https://cb.global.sletat.ru/', name: 'autofill_account_cookie' }, function (cookie) {
                if (cookie) {
                    resolve(cookie.value);
                }
                else {
                    reject('Unable to obtain cookie');
                }
            });
        }
    });
}); };


/***/ }),

/***/ "./src/app/utils/dom.ts":
/*!******************************!*\
  !*** ./src/app/utils/dom.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createElement: () => (/* binding */ createElement),
/* harmony export */   getClaimDataFields: () => (/* binding */ getClaimDataFields),
/* harmony export */   getTourOperatorClaimDataFields: () => (/* binding */ getTourOperatorClaimDataFields),
/* harmony export */   makeOperatorGoToMyAgentButton: () => (/* binding */ makeOperatorGoToMyAgentButton),
/* harmony export */   makeOperatorGoToMyAgentTransferButton: () => (/* binding */ makeOperatorGoToMyAgentTransferButton),
/* harmony export */   makeOperatorGoToPaymentRefundButton: () => (/* binding */ makeOperatorGoToPaymentRefundButton),
/* harmony export */   makeOperatorGoToPaymentTransferButton: () => (/* binding */ makeOperatorGoToPaymentTransferButton)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./src/app/utils/constants.ts");

function setElementProps(element, props) {
    Object.keys(props).forEach(function (key) {
        element[key] = props[key];
        if (props[key] instanceof Object) {
            setElementProps(element[key], props[key]);
        }
    });
}
function createElement(tagName, options) {
    var element = document.createElement(tagName);
    if (options) {
        setElementProps(element, options);
    }
    return element;
}
function getClaimDataFields() {
    return {
        sourceId: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.sourceIdSelector),
        claimIdTO: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimIdTOSelector),
        claimNumber: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimNumberSelector),
        secretField: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimSecretFieldId + _constants__WEBPACK_IMPORTED_MODULE_0__.claimSecretFieldAttr),
        toAlias: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimTOAliasSelector),
        anotherToAlias: document.querySelector(_constants__WEBPACK_IMPORTED_MODULE_0__.claimAnotherTOAliasSelector),
    };
}
function getTourOperatorClaimDataFields(sourceSelector, tokenSelector) {
    if (sourceSelector != undefined || sourceSelector != null) {
        return {
            claimData: document.querySelector(sourceSelector),
            secretField: document.querySelector(tokenSelector)
        };
    }
    return {};
}
var makeOperatorGoToPaymentTransferButton = function () {
    var button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.transferPaymentTOButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-arrow-right' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};
var makeOperatorGoToPaymentRefundButton = function () {
    var button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.refundPaymentTOButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-arrow-right' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};
var makeOperatorGoToMyAgentButton = function () {
    var button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.myAgentTicketButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-ticket' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};
var makeOperatorGoToMyAgentTransferButton = function () {
    var button = createElement('button', _constants__WEBPACK_IMPORTED_MODULE_0__.myAgentTicketTransferButtonOptions);
    button.appendChild(createElement('i', { className: 'uk-icon-ticket' }));
    button.setAttribute('data-uk-tooltip', 'data-uk-tooltip');
    return button;
};


/***/ }),

/***/ "./src/app/utils/executives.ts":
/*!*************************************!*\
  !*** ./src/app/utils/executives.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAutofillSessoinStorageData: () => (/* binding */ getAutofillSessoinStorageData),
/* harmony export */   setSessionStorageKey: () => (/* binding */ setSessionStorageKey)
/* harmony export */ });
var setSessionStorageKey = function (data) { return "\n    sessionStorage.setItem('".concat(data.key, "', '").concat(data.value, "');\n"); };
var getAutofillSessoinStorageData = function (tab) { return new Promise(function (resolve, reject) {
    var getAutofillSessoinStorageDataInternal = function () { return "sessionStorage['autofill-data']"; };
    chrome.tabs.executeScript(tab.id, { code: getAutofillSessoinStorageDataInternal() }, function (result) {
        if (!result[0]) {
            reject('Failed to get tab storage data');
            return;
        }
        resolve(JSON.parse(result[0]));
    });
}); };


/***/ }),

/***/ "./src/app/utils/fillCBLegalEntities.ts":
/*!**********************************************!*\
  !*** ./src/app/utils/fillCBLegalEntities.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillCBLegalEntities: () => (/* binding */ fillCBLegalEntities)
/* harmony export */ });
/* harmony import */ var _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models/chunks/notificationBody */ "./src/app/models/chunks/notificationBody.ts");
/* harmony import */ var _chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");




var CbLeList = {
    aryld: {
        name: 'ООО «АРИЛЬД»',
        dirFullName: 'Князева Анна Андреевна',
        legalAddress: '197198, г. Санкт-Петербург, ул. Кирочная, д. 9 литера А, помещение 3-Н',
        postAddress: '197198, г. Санкт-Петербург, ул. Кирочная, д. 9 литера А, помещение 3-Н',
        phone: '+7 981 131 71 05',
        ogrn: '1187847239678',
        inn: '7841076829',
        kpp: '784101001',
        rs: '40702810701460009067',
        buk: '044525297',
        ks: '30101810945250000297',
        baseOn: 'устава'
    },
    ocb: {
        name: 'ООО «ОЦБ»',
        dirFullName: 'Поплавская Евгения Вячеславовна',
        legalAddress: '195112, г. Санкт-Петербург, пл. Карла Фаберже, д.8, Литер Б, офис 710',
        postAddress: '195112, г. Санкт-Петербург, пл. Карла Фаберже, д.8, Литер Б, офис 710',
        phone: '8 (812) 309-26-66 , 8-981-820-10-86',
        ogrn: '1167847394758',
        inn: '7806253031',
        kpp: '780601001',
        rs: '40702810101460008891',
        buk: '044525297',
        ks: '30101810945250000297',
        baseOn: 'устава'
    }
};
function fillCBLegalEntities(info) {
    return Promise.resolve()
        .then(function () { return new Promise(function (resolve) {
        chrome.tabs.query({ active: true, lastFocusedWindow: true }, function (tabs) {
            resolve(tabs[0]);
        });
    }); })
        .then(function (tab) { return (0,_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: (0,_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_3__.stringifyFn)(requestFiller, CbLeList[info.cbLe]) }); })
        .catch(function (error) { return (0,_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_1__.createPushNotification)({ status: _models_chunks_notificationBody__WEBPACK_IMPORTED_MODULE_0__.SendIdsStatus.FAIL, message: error.message }); });
}
function requestFiller(cbLe) {
    var buttonTeg = document.createElement('button');
    buttonTeg.id = 'autoFillButton';
    buttonTeg.setAttribute('onClick', 'doFillScript()');
    document.body.appendChild(buttonTeg);
    var scriptTeg = document.createElement('script');
    scriptTeg.id = 'autoFillScript';
    scriptTeg.innerHTML = "\n        function doFillScript() {\n\n            debugger;\n\n            var cbLe = ".concat(JSON.stringify(cbLe), ";\n\n            ").concat(handleLeFields.toString(), "\n\n            ").concat(doFill.toString(), "\n\n            doFill(cbLe);\n        }\n    ");
    document.body.appendChild(scriptTeg);
    document.querySelector('#autoFillButton').click();
    function handleLeFields(leFields) {
        leFields.forEach(function (leField) {
            // @ts-ignore
            var element = jQuery(leField.htmlElementSelector);
            if (element && leField.value) {
                element.val(leField.value);
                // element.dispatchEvent(new Event("change", { bubbles: true }));
                // element.dispatchEvent(new Event("input", { bubbles: true }));
                // element.dispatchEvent(new Event("keyup", { bubbles: true }));
            }
        });
    }
    function doFill(cbLe) {
        var leFields = [{
                htmlElementSelector: 'input[name=orgName]',
                value: cbLe.name
            }, {
                htmlElementSelector: 'input[name=org_director]',
                value: cbLe.dirFullName
            }, {
                htmlElementSelector: 'input[name=jurAddress]',
                value: cbLe.legalAddress
            }, {
                htmlElementSelector: 'input[name=postalAddress]',
                value: cbLe.postAddress
            }, {
                htmlElementSelector: 'input[name=agPhone]',
                value: cbLe.phone
            }, {
                htmlElementSelector: 'input[name=agOgrn]',
                value: cbLe.ogrn
            }, {
                htmlElementSelector: 'input[name=agInn]',
                value: cbLe.inn
            }, {
                htmlElementSelector: 'input[name=agKPP]',
                value: cbLe.kpp
            }, {
                htmlElementSelector: 'input[name=agRS]',
                value: cbLe.rs
            }, {
                htmlElementSelector: 'input[name=agBIK]',
                value: cbLe.buk
            }, {
                htmlElementSelector: 'input[name=agKS]',
                value: cbLe.ks
            }, {
                htmlElementSelector: 'input[name=doverforsign]',
                value: cbLe.baseOn
            }];
        handleLeFields(leFields);
    }
}


/***/ }),

/***/ "./src/app/utils/index.ts":
/*!********************************!*\
  !*** ./src/app/utils/index.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addMessageListener: () => (/* reexport safe */ _messages__WEBPACK_IMPORTED_MODULE_3__.addMessageListener),
/* harmony export */   createElement: () => (/* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_2__.createElement),
/* harmony export */   detectSender: () => (/* reexport safe */ _messages__WEBPACK_IMPORTED_MODULE_3__.detectSender),
/* harmony export */   getClaimDataFields: () => (/* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_2__.getClaimDataFields),
/* harmony export */   getCurrentTab: () => (/* reexport safe */ _tabs__WEBPACK_IMPORTED_MODULE_1__.getCurrentTab),
/* harmony export */   getTourOperatorClaimDataFields: () => (/* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_2__.getTourOperatorClaimDataFields),
/* harmony export */   insertUrlCreds: () => (/* reexport safe */ _url__WEBPACK_IMPORTED_MODULE_0__.insertUrlCreds),
/* harmony export */   sendMessage: () => (/* reexport safe */ _messages__WEBPACK_IMPORTED_MODULE_3__.sendMessage),
/* harmony export */   startTrackingElementInCurTab: () => (/* binding */ startTrackingElementInCurTab),
/* harmony export */   stringifyQsParams: () => (/* reexport safe */ _url__WEBPACK_IMPORTED_MODULE_0__.stringifyQsParams),
/* harmony export */   waitForDocumentReady: () => (/* binding */ waitForDocumentReady)
/* harmony export */ });
/* harmony import */ var _url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./url */ "./src/app/utils/url.ts");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dom */ "./src/app/utils/dom.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./messages */ "./src/app/utils/messages.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../messages */ "./src/app/messages/index.ts");
/* harmony import */ var _chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./chunks/sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};







function waitForDocumentReady(tab, delay) {
    if (delay === void 0) { delay = 1000; }
    return new Promise(function (resolve, reject) {
        function func() {
            chrome.webNavigation.onDOMContentLoaded.removeListener(func);
            resolve(0);
        }
        chrome.webNavigation.onDOMContentLoaded.addListener(func);
    });
}
function startTrackingElementInCurTab(selector, delay) {
    var _this = this;
    if (delay === void 0) { delay = 1000; }
    return new Promise(function (resolve, reject) {
        var curTime = Date.now();
        var timer = setInterval(function () { return __awaiter(_this, void 0, void 0, function () {
            var tab;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, (0,_tabs__WEBPACK_IMPORTED_MODULE_1__.getCurrentTab)()];
                    case 1:
                        tab = _a.sent();
                        (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_5__.sendTabMessage)(tab.id, (0,_messages__WEBPACK_IMPORTED_MODULE_4__.createGetElementMessage)({ elementSelector: selector }))
                            .then(function (response) {
                            if (response && response.element) {
                                clearInterval(timer);
                                resolve(tab);
                            }
                            if (Date.now() - curTime >= 300000 && !response.element) {
                                clearInterval(timer);
                                reject('Time limit exeeded');
                            }
                        });
                        return [2 /*return*/];
                }
            });
        }); }, delay);
    });
}


/***/ }),

/***/ "./src/app/utils/messages.ts":
/*!***********************************!*\
  !*** ./src/app/utils/messages.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addMessageListener: () => (/* binding */ addMessageListener),
/* harmony export */   detectSender: () => (/* binding */ detectSender),
/* harmony export */   requestOnClaimPageLogin: () => (/* binding */ requestOnClaimPageLogin),
/* harmony export */   requestSearchForm: () => (/* binding */ requestSearchForm),
/* harmony export */   requestToursitLinks: () => (/* binding */ requestToursitLinks),
/* harmony export */   sendMessage: () => (/* binding */ sendMessage)
/* harmony export */ });
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models */ "./src/app/models/index.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../messages */ "./src/app/messages/index.ts");
/* harmony import */ var _chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./chunks/sendTabMessage */ "./src/app/utils/chunks/sendTabMessage.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};



function addMessageListener(listener) {
    chrome.runtime.onMessage.addListener(listener);
    return function () {
        chrome.runtime.onMessage.removeListener(listener);
    };
}
function sendMessage(message) {
    return new Promise(function (resolve, reject) {
        chrome.runtime.sendMessage(message, function (response) { return resolve(response); });
    });
}
function detectSender(sender) {
    var url = sender.url;
    if (url.indexOf('chrome-extension') > -1) {
        return _models__WEBPACK_IMPORTED_MODULE_0__.SenderTypes.EXT_SENDER;
    }
    return _models__WEBPACK_IMPORTED_MODULE_0__.SenderTypes.TAB_SENDER;
}
function requestOnClaimPageLogin(tabId, params, delay) {
    if (delay === void 0) { delay = 1000; }
    return new Promise(function (resolve, reject) {
        var curTime = Date.now();
        var timer = setInterval(function () {
            (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__.sendTabMessage)(tabId, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetPageLoginFormMessage)(params))
                .then(function (response) {
                if (response.loginForm !== null) {
                    clearInterval(timer);
                    resolve({ needToLogin: true });
                }
                if (Date.now() - curTime >= 5000 && !response.loginForm) {
                    clearInterval(timer);
                    resolve({ needToLogin: false });
                }
            });
        }, delay);
    });
}
function requestSearchForm(tabId, params, delay) {
    var _this = this;
    if (delay === void 0) { delay = 1000; }
    return new Promise(function (resolve, reject) {
        var timer = setInterval(function () { return __awaiter(_this, void 0, void 0, function () {
            var message, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__.sendTabMessage)(tabId, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetPageSearchFormMessage)(params))];
                    case 1:
                        message = _a.sent();
                        if (message && message.queryInput !== null) {
                            clearInterval(timer);
                            resolve(0);
                        }
                        else {
                            clearInterval(timer);
                            reject();
                        }
                        return [3 /*break*/, 3];
                    case 2:
                        e_1 = _a.sent();
                        clearInterval(timer);
                        reject();
                        return [3 /*break*/, 3];
                    case 3: return [2 /*return*/];
                }
            });
        }); }, delay);
    });
}
function requestToursitLinks(tabId, params, delay) {
    if (delay === void 0) { delay = 1000; }
    return new Promise(function (resolve, reject) {
        var curTime = Date.now();
        var timer = setInterval(function () {
            (0,_chunks_sendTabMessage__WEBPACK_IMPORTED_MODULE_2__.sendTabMessage)(tabId, (0,_messages__WEBPACK_IMPORTED_MODULE_1__.createGetTouristLinksMessage)(params))
                .then(function (response) {
                if (response.links.length) {
                    clearInterval(timer);
                    resolve(response);
                }
                if (Date.now() - curTime >= 10000 && !response.links.length) {
                    clearInterval(timer);
                    reject('Time limit exeeded');
                }
            });
        }, delay);
    });
}


/***/ }),

/***/ "./src/app/utils/pagePanel.ts":
/*!************************************!*\
  !*** ./src/app/utils/pagePanel.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   coreFunctions: () => (/* binding */ coreFunctions),
/* harmony export */   createBasicPanelBody: () => (/* binding */ createBasicPanelBody),
/* harmony export */   createErrorPanel: () => (/* binding */ createErrorPanel),
/* harmony export */   createPagePanel: () => (/* binding */ createPagePanel),
/* harmony export */   createPagePanelsStack: () => (/* binding */ createPagePanelsStack),
/* harmony export */   createPanelCaption: () => (/* binding */ createPanelCaption),
/* harmony export */   createTabError: () => (/* binding */ createTabError),
/* harmony export */   createTabErrorInCurrent: () => (/* binding */ createTabErrorInCurrent)
/* harmony export */ });
/* harmony import */ var _chunks_addAsyncScriptToPageAndRun__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./chunks/addAsyncScriptToPageAndRun */ "./src/app/utils/chunks/addAsyncScriptToPageAndRun.ts");
/* harmony import */ var _chunks_addScriptToPageAndRun__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./chunks/addScriptToPageAndRun */ "./src/app/utils/chunks/addScriptToPageAndRun.ts");
/* harmony import */ var _chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");



// Creates autofiller error panel in tab context
var createTabError = function (tab, errorHeader, errorText) {
    return (0,_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_2__.executeScriptInTab)(tab, { code: "window.createPagePanel(window.createErrorPanel('".concat(errorHeader, "', '").concat(errorText, "'))") });
};
var createTabErrorInCurrent = function (errorHeader, errorText) { return new Promise(function (resolve) {
    return chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
        return createTabError(tabs[0], errorHeader, errorText)
            .then(function () { return resolve(0); });
    });
}); };
var createPagePanel = function (innerElement) {
    var stack = document.querySelector('#Autofill-infoPanelStack');
    if (!stack) {
        window.createPagePanelsStack();
        stack = document.querySelector('#Autofill-infoPanelStack');
    }
    var p = document.createElement('div');
    p.style.width = '100%';
    p.style.minHeight = '100px';
    p.style.marginBottom = '8px';
    p.appendChild(innerElement);
    stack.appendChild(p);
};
var createPagePanelsStack = function () {
    var stack = document.createElement('div');
    stack.id = 'Autofill-infoPanelStack';
    stack.style.position = 'fixed';
    stack.style.right = '10px';
    stack.style.bottom = '10px';
    stack.style.width = '300px';
    window.document.body.appendChild(stack);
};
var createErrorPanel = function (caption, error) {
    var panel = document.createElement('div');
    panel.appendChild(window.createPanelCaption(caption, '#f5f6fa', '#e74c3c', function () {
        panel.parentElement.remove();
    }));
    panel.appendChild(window.createBasicPanelBody(error));
    return panel;
};
var createPanelCaption = function (caption, captionColor, captionBGColor, closeClick) {
    var captel = document.createElement('div');
    captel.style.minHeight = '30px';
    captel.style.backgroundColor = captionBGColor;
    captel.style.color = captionColor;
    captel.style.lineHeight = '30px';
    captel.style.font = 'Courier New';
    captel.align = 'center';
    var captionSpan = document.createElement('span');
    captionSpan.innerText = caption;
    var closeSpan = document.createElement('span');
    closeSpan.style.position = 'absolute';
    closeSpan.style.right = '10px';
    closeSpan.innerText = '⛌';
    closeSpan.style.cursor = 'pointer';
    closeSpan.onclick = closeClick;
    captel.appendChild(captionSpan);
    captel.appendChild(closeSpan);
    return captel;
};
var createBasicPanelBody = function (text) {
    var el = document.createElement('div');
    el.style.minHeight = '50px';
    el.style.backgroundColor = '#f5f6fa';
    el.style.font = 'Courier New';
    el.style.border = '1px solid #95a5a6';
    el.style.fontSize = '10pt';
    el.style.padding = '4px';
    el.style.textAlign = 'left';
    el.innerHTML = text;
    return el;
};
var coreFunctions = [
    createPagePanel,
    createPagePanelsStack,
    createErrorPanel,
    createPanelCaption,
    createBasicPanelBody,
    _chunks_addScriptToPageAndRun__WEBPACK_IMPORTED_MODULE_1__.addScriptToPageAndRun,
    _chunks_addScriptToPageAndRun__WEBPACK_IMPORTED_MODULE_1__.addScriptToPage,
    _chunks_addAsyncScriptToPageAndRun__WEBPACK_IMPORTED_MODULE_0__.addAsyncScriptToPageAndRun,
    _chunks_addAsyncScriptToPageAndRun__WEBPACK_IMPORTED_MODULE_0__.addAsyncScriptToPage
];


/***/ }),

/***/ "./src/app/utils/parseDateString.ts":
/*!******************************************!*\
  !*** ./src/app/utils/parseDateString.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseDateString: () => (/* binding */ parseDateString)
/* harmony export */ });
var parseDateString = function (dateString) {
    var _a = dateString.split('.'), day = _a[0], month = _a[1], year = _a[2];
    return new Date(parseInt(year, 10), parseInt(month, 10), parseInt(day, 10));
};


/***/ }),

/***/ "./src/app/utils/tabs.ts":
/*!*******************************!*\
  !*** ./src/app/utils/tabs.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCurrentTab: () => (/* binding */ getCurrentTab),
/* harmony export */   getCurrentWindow: () => (/* binding */ getCurrentWindow),
/* harmony export */   removeTab: () => (/* binding */ removeTab),
/* harmony export */   updateTab: () => (/* binding */ updateTab),
/* harmony export */   waitNewTab: () => (/* binding */ waitNewTab)
/* harmony export */ });
function waitNewTab() {
    return new Promise(function (resolve, reject) {
        var func = function (tab) {
            chrome.tabs.onCreated.removeListener(func);
            resolve(tab);
        };
        chrome.tabs.onCreated.addListener(func);
    });
}
function getCurrentTab(windowId) {
    if (windowId === void 0) { windowId = chrome.windows.WINDOW_ID_CURRENT; }
    var params = { active: true, windowId: windowId };
    return new Promise(function (resolve, reject) {
        chrome.tabs.query(params, function (tabs) { return resolve(tabs[0]); });
    });
}
function getCurrentWindow() {
    return new Promise(function (resolve, reject) {
        chrome.windows.getCurrent({
            populate: true
        }, function (browserWindow) { return resolve(browserWindow); });
    });
}
function updateTab(tabId, options) {
    return new Promise(function (resolve, reject) {
        chrome.tabs.update(tabId, options, function (updatedTab) { return resolve(updatedTab); });
    });
}
var removeTab = function (tab) { return new Promise(function (resolve) {
    return chrome.tabs.remove(tab.id, function () { return resolve(); });
}); };


/***/ }),

/***/ "./src/app/utils/tourist.ts":
/*!**********************************!*\
  !*** ./src/app/utils/tourist.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GetAllTouristsInPackage: () => (/* binding */ GetAllTouristsInPackage)
/* harmony export */ });
// returns list of all tourists related to claims package
var GetAllTouristsInPackage = function (data) {
    var touristsArr = [];
    data.autoFillerData.claimsInPackage.forEach(function (claim) {
        touristsArr = touristsArr.concat(claim.tourists);
    });
    touristsArr = touristsArr.concat(data.autoFillerData.touristDataItems);
    return touristsArr;
};


/***/ }),

/***/ "./src/app/utils/url.ts":
/*!******************************!*\
  !*** ./src/app/utils/url.ts ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   insertUrlCreds: () => (/* binding */ insertUrlCreds),
/* harmony export */   stringifyQsParams: () => (/* binding */ stringifyQsParams)
/* harmony export */ });
function stringifyQsParams(params) {
    return Object.keys(params).reduce(function (acc, param, index, array) {
        return acc += "".concat(param, "=").concat(params[param]).concat(index === (array.length - 1) ? '' : '&');
    }, '');
}
function insertUrlCreds(url, params) {
    var credUrl = url.split('//');
    credUrl.splice(1, 0, "//".concat(params.username, ":").concat(params.password, "@"));
    return credUrl.join('');
}


/***/ }),

/***/ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483634.ts":
/*!***************************************************************************!*\
  !*** ./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483634.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navToBookedClaim: () => (/* binding */ navToBookedClaim)
/* harmony export */ });
/* harmony import */ var _operators_rusSeasons__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/rusSeasons */ "./src/serverScripts/operators/rusSeasons.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/navigateToClaimPageNew */ "./src/app/utils/chunks/navigateToClaimPageNew.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};







//navToBookedClaim(navToBookedClaiArgs);
function navToBookedClaim(args) {
    return __awaiter(this, void 0, void 0, function () {
        var credentials, claimId, tourUrl, tab, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    credentials = args.credentials, claimId = args.claimId, tourUrl = args.tourUrl;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 9, , 10]);
                    return [4 /*yield*/, (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({
                            url: tourUrl,
                            cookieNames: _operators_rusSeasons__WEBPACK_IMPORTED_MODULE_0__.RusSeasons.cookie.auth
                        })];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                            active: true,
                            url: tourUrl
                        })];
                case 3:
                    tab = _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPageNew)(tab, {
                            login: credentials.login,
                            password: credentials.password
                        }, _operators_rusSeasons__WEBPACK_IMPORTED_MODULE_0__.RusSeasons.credentials.packet)];
                case 4:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__.wait)(1000)];
                case 5:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_5__.updateTab)(tab.id, { url: tourUrl })];
                case 6:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__.wait)(2 * 1000)];
                case 7:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_6__.executeScriptInTab)(tab, { code: "document.querySelector('table#reqlist tbody tr td:nth-child(2) a').click()" })];
                case 8:
                    _a.sent();
                    return [3 /*break*/, 10];
                case 9:
                    error_1 = _a.sent();
                    console.log("navToBookedClaim RusSeasons. Error: ".concat(error_1));
                    return [3 /*break*/, 10];
                case 10: return [2 /*return*/, Promise.resolve({})];
            }
        });
    });
}


/***/ }),

/***/ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483639.ts":
/*!***************************************************************************!*\
  !*** ./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483639.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navToBookedClaim: () => (/* binding */ navToBookedClaim)
/* harmony export */ });
/* harmony import */ var _operators_2147483639__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/2147483639 */ "./src/serverScripts/operators/2147483639.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/navigateToClaimPageNew */ "./src/app/utils/chunks/navigateToClaimPageNew.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};






//navToBookedClaim(navToBookedClaiArgs);
function navToBookedClaim(args) {
    return __awaiter(this, void 0, void 0, function () {
        var credentials, claimId, tourUrl, tab, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    credentials = args.credentials, claimId = args.claimId, tourUrl = args.tourUrl;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 7, , 8]);
                    return [4 /*yield*/, (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({
                            url: tourUrl,
                            cookieNames: _operators_2147483639__WEBPACK_IMPORTED_MODULE_0__.CityTravel.cookie.auth
                        })];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                            active: true,
                            url: tourUrl
                        })];
                case 3:
                    tab = _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPageNew)(tab, {
                            login: credentials.login,
                            password: credentials.password
                        }, _operators_2147483639__WEBPACK_IMPORTED_MODULE_0__.CityTravel.credentials.packet)];
                case 4:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__.wait)(1000)];
                case 5:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_5__.updateTab)(tab.id, { url: tourUrl })];
                case 6:
                    _a.sent();
                    return [3 /*break*/, 8];
                case 7:
                    error_1 = _a.sent();
                    console.log("navToBookedClaim CityTravel. Error: ".concat(error_1));
                    return [3 /*break*/, 8];
                case 8: return [2 /*return*/, Promise.resolve({})];
            }
        });
    });
}


/***/ }),

/***/ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483640.ts":
/*!***************************************************************************!*\
  !*** ./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483640.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   loginFormCode: () => (/* binding */ loginFormCode),
/* harmony export */   navToBookedClaim: () => (/* binding */ navToBookedClaim)
/* harmony export */ });
/* harmony import */ var _operators_2147483640__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/2147483640 */ "./src/serverScripts/operators/2147483640.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_navigateToClaimPageCustomeLoginCodeAndCompany__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../../app/utils/chunks/navigateToClaimPageCustomeLoginCodeAndCompany */ "./src/app/utils/chunks/navigateToClaimPageCustomeLoginCodeAndCompany.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};




//navToBookedClaim(navToBookedClaiArgs);
function navToBookedClaim(args) {
    return __awaiter(this, void 0, void 0, function () {
        var credentials, claimId, tourUrl, tab, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    credentials = args.credentials, claimId = args.claimId, tourUrl = args.tourUrl;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 5, , 6]);
                    return [4 /*yield*/, (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({
                            url: tourUrl,
                            cookieNames: _operators_2147483640__WEBPACK_IMPORTED_MODULE_0__.AcademService.cookie.auth
                        })];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                            active: true,
                            url: tourUrl
                        })];
                case 3:
                    tab = _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_navigateToClaimPageCustomeLoginCodeAndCompany__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPageCustomeLoginCodeAndCompany)(tab, {
                            login: credentials.login,
                            password: credentials.password,
                            company: credentials.company
                        }, _operators_2147483640__WEBPACK_IMPORTED_MODULE_0__.AcademService.credentials.packet, loginFormCode)];
                case 4:
                    _a.sent();
                    return [3 /*break*/, 6];
                case 5:
                    error_1 = _a.sent();
                    console.log("navToBookedClaim AcademService. Error: ".concat(error_1));
                    return [3 /*break*/, 6];
                case 6: return [2 /*return*/, Promise.resolve({})];
            }
        });
    });
}
var loginFormCode = function (_a) {
    var login = _a.login, password = _a.password, company = _a.company, _b = _a.packet, loginPath = _b.loginPath, passwordPath = _b.passwordPath, companyPath = _b.companyPath, submitPath = _b.submitPath;
    return "\n    try {\n        if (!company && !login && !password && !submit) {\n            var company;\n            var login;\n            var password;\n            var submit;\n        }\n\n        company = document.querySelector(\"".concat(companyPath.replace(/\\'/g, '\\\''), "\");\n        login = document.querySelector(\"").concat(loginPath.replace(/\\'/g, '\\\''), "\");\n        password = document.querySelector(\"").concat(passwordPath.replace(/\'/g, '\\\''), "\");\n        submit = document.querySelector(\"").concat(submitPath.replace(/\'/g, '\\\''), "\");\n\n        if (login !== null) {\n            company.dispatchEvent(new Event('focus'));\n            company.value = '").concat(company, "';\n            company.dispatchEvent(new Event('keypress', { bubbles: true }));\n            company.dispatchEvent(new Event('input', { bubbles: true }));\n            company.dispatchEvent(new Event('change', { bubbles: true }));\n            company.dispatchEvent(new Event('blur', { bubbles: true }));\n\n            login.dispatchEvent(new Event('focus'));\n            login.value = '").concat(login, "';\n            login.dispatchEvent(new Event('keypress', { bubbles: true }));\n            login.dispatchEvent(new Event('input', { bubbles: true }));\n            login.dispatchEvent(new Event('change', { bubbles: true }));\n            login.dispatchEvent(new Event('blur', { bubbles: true }));\n\n            password.dispatchEvent(new Event('focus', { bubbles: true }));\n            password.value = '").concat(password, "';\n            password.dispatchEvent(new Event('input', { bubbles: true }));\n            password.dispatchEvent(new Event('keypress', { bubbles: true }));\n            password.dispatchEvent(new Event('change', { bubbles: true }));\n            password.dispatchEvent(new Event('blur', { bubbles: true }));\n\n            setTimeout(function(){submit.click();}, 500)\n        }\n\n\n    } catch (e) {\n        JSON.stringify({error: e.stack});\n    }\n");
};


/***/ }),

/***/ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483641.ts":
/*!***************************************************************************!*\
  !*** ./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483641.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navToBookedClaim: () => (/* binding */ navToBookedClaim)
/* harmony export */ });
/* harmony import */ var _operators_2147483641__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/2147483641 */ "./src/serverScripts/operators/2147483641.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/navigateToClaimPageNew */ "./src/app/utils/chunks/navigateToClaimPageNew.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};






//navToBookedClaim(navToBookedClaiArgs);
function navToBookedClaim(args) {
    return __awaiter(this, void 0, void 0, function () {
        var credentials, claimId, tourUrl, tab, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    credentials = args.credentials, claimId = args.claimId, tourUrl = args.tourUrl;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 7, , 8]);
                    return [4 /*yield*/, (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({
                            url: tourUrl,
                            cookieNames: _operators_2147483641__WEBPACK_IMPORTED_MODULE_0__.Bronevik.cookie.auth
                        })];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                            active: true,
                            url: tourUrl
                        })];
                case 3:
                    tab = _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPageNew)(tab, {
                            login: credentials.login,
                            password: credentials.password
                        }, _operators_2147483641__WEBPACK_IMPORTED_MODULE_0__.Bronevik.credentials.packet)];
                case 4:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_4__.wait)(1000)];
                case 5:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_5__.updateTab)(tab.id, { url: tourUrl })];
                case 6:
                    _a.sent();
                    return [3 /*break*/, 8];
                case 7:
                    error_1 = _a.sent();
                    console.log("navToBookedClaim Bronevik. Error: ".concat(error_1));
                    return [3 /*break*/, 8];
                case 8: return [2 /*return*/, Promise.resolve({})];
            }
        });
    });
}


/***/ }),

/***/ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483645.ts":
/*!***************************************************************************!*\
  !*** ./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483645.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navToBookedClaim: () => (/* binding */ navToBookedClaim)
/* harmony export */ });
/* harmony import */ var _operators_2147483645__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/2147483645 */ "./src/serverScripts/operators/2147483645.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../../app/utils/chunks/navigateToClaimPageNew */ "./src/app/utils/chunks/navigateToClaimPageNew.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};




//navToBookedClaim(navToBookedClaiArgs);
function navToBookedClaim(args) {
    return __awaiter(this, void 0, void 0, function () {
        var credentials, claimId, tourUrl, tab, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    credentials = args.credentials, claimId = args.claimId, tourUrl = args.tourUrl;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 5, , 6]);
                    return [4 /*yield*/, (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({
                            url: tourUrl,
                            cookieNames: _operators_2147483645__WEBPACK_IMPORTED_MODULE_0__.Ostrovok.cookie.auth
                        })];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                            active: true,
                            url: tourUrl
                        })];
                case 3:
                    tab = _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPageNew)(tab, {
                            login: credentials.login,
                            password: credentials.password
                        }, _operators_2147483645__WEBPACK_IMPORTED_MODULE_0__.Ostrovok.credentials.packet)];
                case 4:
                    _a.sent();
                    return [3 /*break*/, 6];
                case 5:
                    error_1 = _a.sent();
                    console.log("navToBookedClaim Ostrovok. Error: ".concat(error_1));
                    return [3 /*break*/, 6];
                case 6: return [2 /*return*/, Promise.resolve({})];
            }
        });
    });
}


/***/ }),

/***/ "./src/serverScripts/navToBookedClaim/navToBookedClaim_252.ts":
/*!********************************************************************!*\
  !*** ./src/serverScripts/navToBookedClaim/navToBookedClaim_252.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navToBookedClaim: () => (/* binding */ navToBookedClaim)
/* harmony export */ });
/* harmony import */ var _operators_252__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operators/252 */ "./src/serverScripts/operators/252.ts");
/* harmony import */ var _app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/removeCookies */ "./src/app/utils/chunks/removeCookies.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/navigateToClaimPageNew */ "./src/app/utils/chunks/navigateToClaimPageNew.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};




//navToBookedClaim(navToBookedClaiArgs);
_operators_252__WEBPACK_IMPORTED_MODULE_0__.Alean.credentials.packet = {
    loginPath: 'form.cabinetLogin-form input#login',
    passwordPath: 'form.cabinetLogin-form input#password',
    submitPath: 'form.cabinetLogin-form button[type=submit]'
};
function navToBookedClaim(args) {
    return __awaiter(this, void 0, void 0, function () {
        var credentials, claimId, tourUrl, tab;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    credentials = args.credentials, claimId = args.claimId, tourUrl = args.tourUrl;
                    return [4 /*yield*/, (0,_app_utils_chunks_removeCookies__WEBPACK_IMPORTED_MODULE_1__.removeCookies)({
                            url: 'https://www.alean.ru',
                            cookieNames: ['ksb_PRO_agency_account_id']
                        })];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_2__.createTab)({
                            active: true,
                            url: tourUrl
                        })];
                case 2:
                    tab = _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_navigateToClaimPageNew__WEBPACK_IMPORTED_MODULE_3__.navigateToClaimPageNew)(tab, {
                            login: credentials.login,
                            password: credentials.password
                        }, _operators_252__WEBPACK_IMPORTED_MODULE_0__.Alean.credentials.packet)];
                case 3:
                    _a.sent();
                    return [2 /*return*/, new Promise(function (res, rej) { return res({}); })];
            }
        });
    });
}


/***/ }),

/***/ "./src/serverScripts/navToBookedClaim/navToBookedClaim_7.ts":
/*!******************************************************************!*\
  !*** ./src/serverScripts/navToBookedClaim/navToBookedClaim_7.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navToBookedClaim: () => (/* binding */ navToBookedClaim)
/* harmony export */ });
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_setSessionStorageKeyInTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/setSessionStorageKeyInTab */ "./src/app/utils/chunks/setSessionStorageKeyInTab.ts");
/* harmony import */ var _app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../../app/utils/chunks/common/clientUtils */ "./src/app/utils/chunks/common/clientUtils.ts");
/* harmony import */ var _app_utils_tabs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/tabs */ "./src/app/utils/tabs.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");






//navToBookedClaim(navToBookedClaiArgs);
function navToBookedClaim(args) {
    var credentials = args.credentials, tourUrl = args.tourUrl, secretField = args.secretField, claimNumber = args.claimNumber, sourceId = args.sourceId, claimId = args.claimId;
    var sourceTab;
    return Promise.resolve()
        .then(function () { return (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_0__.createTab)({
        active: true,
        url: "https://".concat(credentials.login, ":").concat(credentials.password, "@www.bgoperator.ru/spis?nrequest=").concat(claimId)
    }); })
        .then(function (tab) { return new Promise(function (res, rej) {
        sourceTab = tab;
        res();
    }); })
        .then(function () { return (0,_app_utils_chunks_common_clientUtils__WEBPACK_IMPORTED_MODULE_2__.wait)(1 * 1000); })
        .then(function () { return (0,_app_utils_tabs__WEBPACK_IMPORTED_MODULE_3__.updateTab)(sourceTab.id, { url: "https://www.bgoperator.ru/spis?nrequest=".concat(claimId) }); })
        .then(function () {
        var autofillData = {
            behaviorType: 'magnifier',
            token: secretField,
            claimNumber: claimNumber,
            operatorId: sourceId,
        };
        var t = sourceTab;
        var listener = function (tabId, info) {
            if (t && info.status === 'complete' && tabId === t.id) {
                (0,_app_utils_chunks_setSessionStorageKeyInTab__WEBPACK_IMPORTED_MODULE_1__.setSessionStorageKeyInTab)(t, 'autofill-data', JSON.stringify(autofillData));
                chrome.tabs.onUpdated.removeListener(listener);
            }
        };
        chrome.tabs.onUpdated.addListener(listener);
        var getNoLogopassUrl = function (tab) {
            var url = tab.url && tab.url !== '' ? tab.url : tab.pendingUrl;
            var newUrl = ((url === null || url === void 0 ? void 0 : url.indexOf('@')) !== -1 ? url === null || url === void 0 ? void 0 : url.substring(url.indexOf('@') + 1) : url) || '';
            return newUrl.replace('www.', '');
        };
        return (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__.startTrackingElement)(sourceTab, 'table#reqlist')
            .then(function () { return (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__.startTrackingElement)(sourceTab, 'tr#rcmrow1 a'); })
            // .then(() => wait(1 * 1000))
            // .then(() => updateTab((tab.id as number), { url: getNoLogopassUrl(tab) }))
            //.then(() => startTrackingElement(tab, 'tr#rcmrow1 a'))
            .then(function () { return (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(sourceTab, { code: "document.querySelector('tr#rcmrow1 td a').removeAttribute('target')" }); })
            .then(function () { return (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(sourceTab, { code: "document.querySelector('tr#rcmrow1 a').click()" }); })
            .then(function () { return (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_4__.startTrackingElement)(sourceTab, 'a.showPayAg'); })
            .then(function () { return (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(sourceTab, { code: "\n                var link = document.querySelector('a.showPayAg');\n                link.setAttribute('href', 'https://www.bgoperator.ru' + link.getAttribute('href'))\n            " }); })
            .then(function () { return (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_5__.executeScriptInTab)(sourceTab, { code: "\n                var link = document.querySelector('a.tour_is_ready-btn')\n                link.setAttribute('href', 'https://www.bgoperator.ru/' + link.getAttribute('href'))\n            " }); });
    });
}


/***/ }),

/***/ "./src/serverScripts/navToBookedClaim/navToBookedClaim_800.ts":
/*!********************************************************************!*\
  !*** ./src/serverScripts/navToBookedClaim/navToBookedClaim_800.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navToBookedClaim: () => (/* binding */ navToBookedClaim)
/* harmony export */ });
/* harmony import */ var _operators_800__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../operators/800 */ "./src/serverScripts/operators/800.ts");
/* harmony import */ var _app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../app/utils/chunks/createTab */ "./src/app/utils/chunks/createTab.ts");
/* harmony import */ var _app_utils_chunks_removeFromLocalStorage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../../app/utils/chunks/removeFromLocalStorage */ "./src/app/utils/chunks/removeFromLocalStorage.ts");
/* harmony import */ var _app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../app/utils/chunks/startTrackingElementInternal */ "./src/app/utils/chunks/startTrackingElementInternal.ts");
/* harmony import */ var _app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../app/utils/chunks/executeScriptInTab */ "./src/app/utils/chunks/executeScriptInTab.ts");
/* harmony import */ var _app_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../app/utils/chunks/stringifyFn */ "./src/app/utils/chunks/stringifyFn.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};






//navToBookedClaim(navToBookedClaiArgs);
var authUrl = 'https://myagent.online/#/login';
function navToBookedClaim(args) {
    return __awaiter(this, void 0, void 0, function () {
        var credentials, claimId, tourUrl, tab, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    credentials = args.credentials, claimId = args.claimId, tourUrl = args.tourUrl;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 6, , 7]);
                    return [4 /*yield*/, (0,_app_utils_chunks_removeFromLocalStorage__WEBPACK_IMPORTED_MODULE_2__.removeFromLocalStorage)(_operators_800__WEBPACK_IMPORTED_MODULE_0__.MyAgent.cookie.auth[0])];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_createTab__WEBPACK_IMPORTED_MODULE_1__.createTab)({
                            active: true,
                            url: tourUrl
                        })];
                case 3:
                    tab = _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_startTrackingElementInternal__WEBPACK_IMPORTED_MODULE_3__.startTrackingElement)(tab, 'div.LoginForm')];
                case 4:
                    _a.sent();
                    return [4 /*yield*/, (0,_app_utils_chunks_executeScriptInTab__WEBPACK_IMPORTED_MODULE_4__.executeScriptInTab)(tab, {
                            code: (0,_app_utils_chunks_stringifyFn__WEBPACK_IMPORTED_MODULE_5__.stringifyFn)(login, {
                                login: args.credentials.login,
                                password: args.credentials.password,
                                packet: _operators_800__WEBPACK_IMPORTED_MODULE_0__.MyAgent.credentials.packet
                            })
                        })];
                case 5:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 6:
                    error_1 = _a.sent();
                    console.log("navToBookedClaim MyAgent. Error: ".concat(error_1));
                    return [3 /*break*/, 7];
                case 7: return [2 /*return*/, Promise.resolve({})];
            }
        });
    });
}
function login(args) {
    var buttonTeg = document.createElement('button');
    buttonTeg.id = 'autoFillButtonLogIn';
    buttonTeg.setAttribute('onClick', 'doLogIn()');
    document.body.appendChild(buttonTeg);
    var scriptTeg = document.createElement('script');
    scriptTeg.id = 'autoFillLogInScript';
    scriptTeg.innerHTML = "\n        function doLogIn() {\n\n            debugger;\n\n            try {\n                if (!login && !password && !submit) {\n                    var login;\n                    var password;\n                    var submit;\n                }\n                login = document.querySelector(\"".concat(args.packet.loginPath.replace(/\\'/g, '\\\''), "\");\n                password = document.querySelector(\"").concat(args.packet.passwordPath.replace(/\'/g, '\\\''), "\");\n                submit = document.querySelector(\"").concat(args.packet.submitPath.replace(/\'/g, '\\\''), "\");\n        \n                if (login !== null) {\n                    login.dispatchEvent(new Event('focus'));\n                    login.value = '").concat(args.login, "';\n        \n                    // on TUI site there's Knockout hook matching only on keypress event\n                    // so without this workaroud we couldn't post login value\n                    login.dispatchEvent(new Event('keypress', { bubbles: true }));\n                    login.dispatchEvent(new Event('input', { bubbles: true }));\n                    login.dispatchEvent(new Event('change', { bubbles: true }));\n        \n                    password.dispatchEvent(new Event('focus', { bubbles: true }));\n                    password.value = '").concat(args.password, "';\n                    password.dispatchEvent(new Event('input', { bubbles: true }));\n                    password.dispatchEvent(new Event('keypress', { bubbles: true }));\n                    password.dispatchEvent(new Event('change', { bubbles: true }));\n        \n                    setTimeout(function(){submit.click();}, 500)\n                }\n        \n        \n            } catch (e) {\n                JSON.stringify({error: e.stack});\n            }\n        }\n    ");
    document.body.appendChild(scriptTeg);
    document.querySelector('#autoFillButtonLogIn').click();
}


/***/ }),

/***/ "./src/serverScripts/operators/107.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/107.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Danko: () => (/* binding */ Danko)
/* harmony export */ });
var Danko = {
    link: function (operatorClaimId) { return 'https://online.danko.ru/private/account/login.aspx'; },
    title: 'ДАНКО Трэвел Компани',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'userName\']",' +
            '"passwordPath":"input[name=\'password\']", ' +
            '"submitPath": "input[name=\'ctl00$General$btLogin\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/108.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/108.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DeltaTours: () => (/* binding */ DeltaTours)
/* harmony export */ });
var DeltaTours = {
    link: function (operatorClaimId) { return "http://delta-tours.tourmanager.ru/login"; },
    title: 'DELTA TOURS / Дельта Интерконтиненталь',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#ls-main #login",' +
            '"passwordPath":"#ls-main #password", ' +
            '"submitPath": "#ls-main .login input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['current_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/112.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/112.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ExpressTour: () => (/* binding */ ExpressTour)
/* harmony export */ });
var ExpressTour = {
    link: function (operatorClaimId) { return "http://91.122.31.67/MasterWeb/OrderInfo.aspx?dg_code=".concat(operatorClaimId); },
    title: 'Экспресс тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'sletatru',
        packetMagnifier: JSON.parse('{"loginPath":"#ctl00_generalContent_LoginControl_txtUserName","passwordPath": "#ctl00_generalContent_LoginControl_txtPassword", "submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"}'),
        packet: {
            loginPath: "#ctl00_Login_ctl01, #ctl00_generalContent_LoginControl_txtUserName",
            passwordPath: "#ctl00_Login_ctl02, #ctl00_generalContent_LoginControl_txtPassword",
            submitPath: "input[name='ctl00$Login$ctl03'], #ctl00_generalContent_LoginControl_btnLogin"
        },
        password: 'zi71kk30'
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/113.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/113.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Grand: () => (/* binding */ Grand)
/* harmony export */ });
var Grand = {
    link: function (operatorClaimId) { return 'http://online.grand-ptc.ru/MW/login.aspx'; },
    title: 'Grand',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: {
            loginPath: '#ctl00_generalContent_LoginControl_txtUserName',
            passwordPath: '#ctl00_generalContent_LoginControl_txtPassword',
            submitPath: '#ctl00_generalContent_LoginControl_btnLogin'
        },
        packet: {
            loginPath: '#ctl00_Login_ctl01',
            passwordPath: '#ctl00_Login_ctl02',
            submitPath: '.loginbutton'
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/123.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/123.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Itm: () => (/* binding */ Itm)
/* harmony export */ });
var Itm = {
    link: function () { return ""; },
    title: 'ITM Group',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        packet: JSON.parse('{"' +
            'loginPath":"#ctl00_generalContent_LoginControl_txtUserName , #login",' +
            '"passwordPath": "#ctl00_generalContent_LoginControl_txtPassword , #password", ' +
            '"submitPath": "#ctl00_generalContent_LoginControl_btnLogin , button.btn.sign-in' +
            '"}'),
        password: ''
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth', '.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/130.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/130.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WestTravel: () => (/* binding */ WestTravel)
/* harmony export */ });
var WestTravel = {
    link: function (operatorClaimId) { return "http://online.west-travel.ru/MasterWebStandard/login.aspx"; },
    title: 'Вест Тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/131.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/131.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArtTravel: () => (/* binding */ ArtTravel)
/* harmony export */ });
var ArtTravel = {
    link: function (operatorClaimId) { return "http://res.art-travel.ru/MasterWebStandard/login.aspx"; },
    title: 'Арт-Тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#ctl00_Login_ctl01, #Login',
            passwordPath: '#ctl00_Login_ctl02, #Password',
            submitPath: 'input[name=\'ctl00$Login$ctl03\'], div.loginForm-rightCol input[type=submit]'
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/14.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/14.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PacGroup: () => (/* binding */ PacGroup)
/* harmony export */ });
var PacGroup = {
    link: function (operatorClaimId) { return 'https://online.pac.ru/online/login.aspx'; },
    title: 'PAC GROUP',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: {
            loginPath: 'input[name=\'ctl00$generalContent$LoginControl$txtUserName\']  , #UserName',
            passwordPath: 'input[name=\'ctl00$generalContent$LoginControl$txtPassword\'] , #Password',
            submitPath: 'input[name=\'ctl00$generalContent$LoginControl$btnLogin\'] , form button[type=\'submit\']'
        },
        packet: {
            loginPath: "input[name='ctl00$generalContent$regLoginAgent'] , input[name='ctl00$generalContent$LoginControl$txtUserName'] , input[name='login'] , input[name='ctl00$Login$ctl01'] , #UserName , input[name='UserName']",
            passwordPath: "input[name='ctl00$generalContent$regPassAgent'], input[name='ctl00$generalContent$LoginControl$txtPassword'] , input[name='pass'] , input[name='ctl00$Login$ctl02'] , #Password , input[name='Password']",
            submitPath: "input[name='ctl00$generalContent$btAuthAgent'], input[name='ctl00$generalContent$LoginControl$btnLogin'] , input[name='ctl00$Login$ctl03'] , .js-auth-login"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', '.ASPXAUTH']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/141.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/141.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   YugoStar: () => (/* binding */ YugoStar)
/* harmony export */ });
var YugoStar = {
    link: function (operatorClaimId) { return "http://online.yugo-star.ru/masterweb/login.aspx"; },
    title: 'Юго Стар',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_Login_ctl02", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', 'MagTravelWebClient']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/142.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/142.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MoreTravel: () => (/* binding */ MoreTravel)
/* harmony export */ });
var MoreTravel = {
    link: function (operatorClaimId) { return "https://www.moretravel.ru/login.php"; },
    title: 'More Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#form_login > fieldset > label > span > input[name=login]',
            passwordPath: '#form_login > fieldset > label > span > input[name=pass]',
            submitPath: '#form_login > div > button[type=submit]'
        }
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/145.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/145.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RozaVetrov: () => (/* binding */ RozaVetrov)
/* harmony export */ });
var RozaVetrov = {
    link: function () { return ""; },
    title: 'Роза Ветров',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        packet: {
            loginPath: "input#ctl00_generalContent_LoginControl_txtUserName, input#ctl00_Login_ctl01",
            passwordPath: "input#ctl00_generalContent_LoginControl_txtPassword, input#ctl00_Login_ctl02",
            submitPath: "input[name='ctl00$generalContent$LoginControl$btnLogin'], input[name='ctl00$Login$ctl03']"
        },
        password: ''
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth', '.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/152.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/152.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MeridianExpress: () => (/* binding */ MeridianExpress)
/* harmony export */ });
var MeridianExpress = {
    link: function (operatorClaimId) { return "http://remote.meridian-express.ru:8585"; },
    title: 'Меридиан Экспресс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', 'ASP.NET_SessionId']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/153.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/153.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Delfin: () => (/* binding */ Delfin)
/* harmony export */ });
var Delfin = {
    link: function (operatorClaimId) { return "https://www.delfin-tour.ru/cabinet/Orders/List#remember"; },
    title: 'ДЕЛЬФИН',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":".form-group input[name=\'lg-login\']",' +
            '"passwordPath":".form-group input[name=\'lg-pass\']", ' +
            '"submitPath": ".form-actions button[type=\'submit\']"' +
            '}'),
        packet: {
            loginPath: "input[name='login'], input[name='lg-login']",
            passwordPath: "input[name='password'], input[name='lg-pass']",
            submitPath: "button.login-form__submit, form[class~='login-form'] button[type='submit']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['token', 'delfin-tour']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/155.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/155.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BSI: () => (/* binding */ BSI)
/* harmony export */ });
var BSI = {
    link: function (operatorClaimId) { return "https://www.bsigroup.ru/cabinet/"; },
    title: 'Би Эс Ай (BSI)',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#bottom_login_form input[name=\'login\']",' +
            '"passwordPath":"#bottom_login_form input[name=\'pass\']", ' +
            '"submitPath": "#bottom_login_form input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID BITRIX_SM_atkn_w']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/156.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/156.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Maldives: () => (/* binding */ Maldives)
/* harmony export */ });
var Maldives = {
    link: function (operatorClaimId) { return "http://online.maldives.ru/cl_refer?"; },
    title: 'Мальдивиана',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": "button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID BITRIX_SM_atkn_w']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/158.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/158.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Solvex: () => (/* binding */ Solvex)
/* harmony export */ });
var Solvex = {
    link: function (operatorClaimId) { return 'http://online.solvex.ru/DistributedSearch/login.aspx'; },
    title: 'SOLVEX',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#inputEmail3, input#ctl00_generalContent_LoginControl_txtUserName , #login",
            "passwordPath": "#inputPassword3, input#ctl00_generalContent_LoginControl_txtPassword , #password",
            "submitPath": "#enter, input#ctl00_generalContent_LoginControl_btnLogin , #loginDialog > div > div > div.modal-footer > div.row > div.col-lg-2.col-md-2.col-sm-2 > button > span"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', 'kx-auth', 'ASP.NET_SessionId']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/160.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/160.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Dsbw: () => (/* binding */ Dsbw)
/* harmony export */ });
var Dsbw = {
    link: function (operatorClaimId) { return "http://tourml.dsbw.ru/MasterWeb15/login.aspx"; },
    title: 'ДСБВ (DSBW)',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "#ctl00_generalContent_LoginControl_btnLogin"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#login , #ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#password , #ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "#loginDialog .modal-footer button , #ctl00_generalContent_LoginControl_btnLogin"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth', '.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/162.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/162.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChinaTravel: () => (/* binding */ ChinaTravel)
/* harmony export */ });
var ChinaTravel = {
    link: function (operatorClaimId) { return "http://online.chinatravel.ru/mw/login.aspx"; },
    title: 'China Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName , #ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword , #ctl00_Login_ctl02", ' +
            '"submitPath": "#ctl00_generalContent_LoginControl_btnLogin , .loginbutton"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['identityCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/165.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/165.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Devisu: () => (/* binding */ Devisu)
/* harmony export */ });
var Devisu = {
    link: function (operatorClaimId) { return 'http://ttt.devisu.ru/mw9/login.aspx'; },
    title: 'De Visu',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_Login_ctl02", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/171.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/171.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AmigoS: () => (/* binding */ AmigoS)
/* harmony export */ });
var AmigoS = {
    link: function (operatorClaimId) { return 'http://dynamic.amigo-s.ru/mw/login.aspx'; },
    title: 'Amigo S',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input[name='ctl00$generalContent$LoginControl$txtUserName']",
            "passwordPath": "input[name='ctl00$generalContent$LoginControl$txtPassword']",
            "submitPath": "input[name='ctl00$generalContent$LoginControl$btnLogin']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['kx-auth3']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/174.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/174.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Capricorn: () => (/* binding */ Capricorn)
/* harmony export */ });
var Capricorn = {
    link: function (operatorClaimId) { return 'https://www.capricorn.ru/'; },
    title: 'Каприкон',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_Login_ctl02", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/184.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/184.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Interunion: () => (/* binding */ Interunion)
/* harmony export */ });
var Interunion = {
    link: function (operatorClaimId) { return 'http://online.interunion.ru/MW2018/login.aspx'; },
    title: 'Интерюнион',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$Login$ctl01\']",' +
            '"passwordPath":"input[name=\'ctl00$Login$ctl02\']", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/19.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/19.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Anex: () => (/* binding */ Anex)
/* harmony export */ });
var Anex = {
    link: function (operatorClaimId) { return 'http://online3.anextour.ru/default.php?page=cl_refer&samo=ok'; },
    title: 'Anex',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'SletatRu',
        packet: {
            "loginPath": "#login , input[name='username']",
            "passwordPath": "#passwd , input[name='password']",
            "submitPath": "#loginForm .button , button[type='submit']",
            "operatorIdGetter": "function() { var selector = '.claim'; var el = document.querySelector(selector); if (el) return el.innerHTML; }",
            "operatorIdSelector": ".claim"
        },
        password: 'pHdlYZwb'
    },
    selectors: {
        queryInput: '.frm-input.element.CLAIMBEGIN.cl',
        searchButton: '.load'
    },
    cookie: {
        auth: ['.AspNetCore.Identity.DmfVbrQPek', 'SAMO']
    },
};


/***/ }),

/***/ "./src/serverScripts/operators/20.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/20.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IcsTravel: () => (/* binding */ IcsTravel)
/* harmony export */ });
var IcsTravel = {
    link: function (operatorClaimId) { return "https://www.icstrvl.ru/agent/login.html"; },
    title: 'ICS Travel Group',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#lform_login",
            "passwordPath": "#lform_password",
            "submitPath": ".for_form .sbmt"
        }
    },
    selectors: {},
    cookie: {
        auth: ['ag_ticket']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/205.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/205.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AmigoTours: () => (/* binding */ AmigoTours)
/* harmony export */ });
var AmigoTours = {
    link: function (operatorClaimId) { return 'http://online.amigo-tours.ru/MasterWebStandard/login.aspx'; },
    title: 'Amigo Tours',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#ctl00_Login_ctl01, #ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "#ctl00_Login_ctl02, #ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "input[name='ctl00$Login$ctl03'], input[name='ctl00$generalContent$LoginControl$btnLogin']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/213.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/213.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mouzenidis: () => (/* binding */ Mouzenidis)
/* harmony export */ });
var Mouzenidis = {
    link: function (operatorClaimId) { return 'https://online215.mouzenidis-travel.ru/Account/LogOn'; },
    title: 'Mouzenidis Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#AuthenticateUser div[data-bind='bsValid: quickReservationController.UserName'] input , #LoginViewModel_Username",
            "passwordPath": "#AuthenticateUser div[data-bind='bsValid: quickReservationController.Password'] input , #LoginViewModel_Password",
            "submitPath": "#AuthenticateUser button.btn-primary , button[value='login']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.AUTHMZT1', 'idsrv.session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/2147483639.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/2147483639.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CityTravel: () => (/* binding */ CityTravel)
/* harmony export */ });
var CityTravel = {
    link: function (operatorClaimId) { return "https://city.travel"; },
    title: 'City Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form input[name=user_mail]",
            "passwordPath": "form input[name=user_pwd]",
            "submitPath": "form button[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/2147483640.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/2147483640.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AcademService: () => (/* binding */ AcademService)
/* harmony export */ });
var AcademService = {
    link: function (operatorClaimId) { return "https://b2b.acase.ru/"; },
    title: 'Академ Сервис',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "companyPath": "form input#buyer_input",
            "loginPath": "form input#login_input",
            "passwordPath": "form input#password_input",
            "submitPath": "form input[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/2147483641.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/2147483641.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Bronevik: () => (/* binding */ Bronevik)
/* harmony export */ });
var Bronevik = {
    link: function (operatorClaimId) { return "https://bronevik.com"; },
    title: 'Мой Агент',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form.auth_form input[aria-label=Login]",
            "passwordPath": "form.auth_form input[type=password]",
            "submitPath": "form.auth_form button[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/2147483645.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/2147483645.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ostrovok: () => (/* binding */ Ostrovok)
/* harmony export */ });
var Ostrovok = {
    link: function (operatorClaimId) { return "https://b2b.ostrovok.ru"; },
    title: 'Мой Агент',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input[name=email]",
            "passwordPath": "input[name=pass]",
            "submitPath": "button[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/219.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/219.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SochiPlanet: () => (/* binding */ SochiPlanet)
/* harmony export */ });
var SochiPlanet = {
    link: function (operatorClaimId) { return "http://online.mercury-europe.ru/MasterWebMercury/login.aspx"; },
    title: 'Планета Сочи',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input[name='ctl00$generalContent$LoginControl$txtUserName'] , #login",
            "passwordPath": "input[name='ctl00$generalContent$LoginControl$txtPassword'] , #password",
            "submitPath": "input[name='ctl00$generalContent$LoginControl$btnLogin'] , #loginDialog > div > div > div.modal-footer > div > div.col-lg-4.col-md-4.col-sm-4 > button > span"
        },
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/229.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/229.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TuiOld: () => (/* binding */ TuiOld)
/* harmony export */ });
var TuiOld = {
    link: function (operatorClaimId) { return "http://my.tui.ru/Online/Orders/?sr_id=".concat(operatorClaimId); },
    title: 'TUI old',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'info@sleta',
        packet: {
            "loginPath": "#form_login",
            "passwordPath": "#form_password",
            "submitPath": "#form_submit",
            "pageFormPath": {
                "loginPath": "#popupAuthLogin",
                "passwordPath": "#popupAuthPassword",
                "submitPath": "#authPopup .buttonContainer button"
            },
            "operatorIdSelector": "#ctl00_generalContent_lbDogovorCode"
        },
        password: 'drfiv86yu8'
    },
    selectors: {
        claimButton: '.zayavki tbody tr:nth-child(1)'
    },
    cookie: {
        auth: ['.ASPXFORMSAUTH', 'PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/231.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/231.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MultiTour: () => (/* binding */ MultiTour)
/* harmony export */ });
var MultiTour = {
    link: function (operatorClaimId) { return "http://samo.premiera.travel/cl_refer"; },
    title: 'МУЛЬТИТУР',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: ".auth-form input[name='login']",
            passwordPath: ".auth-form input[name='pass']",
            submitPath: "form button[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/237.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/237.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DvmTour: () => (/* binding */ DvmTour)
/* harmony export */ });
var DvmTour = {
    link: function (operatorClaimId) { return "http://online.dvm-tour.ru/toursearch/"; },
    title: 'ДВМ-Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#auth_blk #auth_login",
            "passwordPath": "#auth_blk #auth_pwd",
            "submitPath": "#auth_blk .auth_sub"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.ASPXAUTH']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/238.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/238.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RusTour: () => (/* binding */ RusTour)
/* harmony export */ });
var RusTour = {
    link: function (operatorClaimId) { return 'http://online.rus-tour.travel/server/auth.php'; },
    title: 'Русь-Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": "#loginForm .button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/248.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/248.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AvroraBg: () => (/* binding */ AvroraBg)
/* harmony export */ });
var AvroraBg = {
    link: function (operatorClaimId) { return "http://online.avrorabg.ru/MasterWebStandard/login.aspx"; },
    title: 'Аврора БГ',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#ctl00_Login_ctl01",
            "passwordPath": "#ctl00_Login_ctl02",
            "submitPath": "input[name='ctl00$Login$ctl03']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/252.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/252.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Alean: () => (/* binding */ Alean)
/* harmony export */ });
var Alean = {
    link: function (operatorClaimId) { return 'https://www.alean.ru/cabinet/login/'; },
    title: 'Алеан',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            'loginPath': "input[ng-model='vm.userData.login'], input[ng-model='vm.user.login'], input[ng-model='vm.account.login']",
            'passwordPath': "input[ng-model='vm.userData.password'], input[ng-model='vm.user.password'], input[ng-model='vm.account.password']",
            'submitPath': "form[name='vm.userAgencyForm'] button[type='submit'], form[name='loginForm'] button[type='submit'], div.cabinetLogin-control > button[type='submit']"
        },
        packetMagnifier: JSON.parse("{\n            \"loginPath\":\"input[ng-model='vm.user.login']\",\n            \"passwordPath\":\"input[ng-model='vm.user.password']\",\n            \"submitPath\":\"button[type='submit']\"\n        }")
    },
    selectors: {},
    cookie: {
        auth: ['production_crs_site_1_password']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/260.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/260.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Kandagar: () => (/* binding */ Kandagar)
/* harmony export */ });
var Kandagar = {
    link: function (operatorClaimId) { return 'http://online.kandagar.com/MW/login.aspx'; },
    title: 'Кандагар',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: {
            "loginPath": "#loginValue , input[name='ctl00$generalContent$LoginControl$txtUserName']",
            "passwordPath": "#passwordValue , input[name='ctl00$generalContent$LoginControl$txtPassword']",
            "submitPath": "#exitButton , input[name='ctl00$generalContent$LoginControl$btnLogin'] , #logon"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/269.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/269.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NatalieTours: () => (/* binding */ NatalieTours)
/* harmony export */ });
var NatalieTours = {
    link: function () { return ""; },
    title: 'NatalieTours',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        packet: JSON.parse('{"loginPath":"#login","passwordPath": "#password", "submitPath": "#ok"}'),
        password: ''
    },
    selectors: {},
    cookie: {
        auth: ['JSESSIONID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/277.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/277.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   VremiaTour: () => (/* binding */ VremiaTour)
/* harmony export */ });
var VremiaTour = {
    link: function (operatorClaimId) { return "https://vremiatour.ru/tourmanager?countryId=2&tm_page=%2Flogin"; },
    title: 'Время-тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":".login input[name=\'login\']",' +
            '"passwordPath":".login input[name=\'password\']", ' +
            '"submitPath": ".login .submit input"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'login\']",' +
            '"passwordPath":"input[name=\'password\']", ' +
            '"submitPath": "#login-form input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['current_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/280.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/280.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GTV: () => (/* binding */ GTV)
/* harmony export */ });
var GTV = {
    link: function (operatorClaimId) { return "http://online.gtv-operator.ru/"; },
    title: 'GTV Operator',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_Login_ctl01",' +
            '"passwordPath":"#ctl00_Login_ctl02", ' +
            '"submitPath": "input[name=\'ctl00$Login$ctl03\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    },
};


/***/ }),

/***/ "./src/serverScripts/operators/282.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/282.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Petropolitana: () => (/* binding */ Petropolitana)
/* harmony export */ });
var Petropolitana = {
    link: function (operatorClaimId) { return "http://www.petropolitana.com/"; },
    title: 'Petropolitana',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "input#login, input#ctl00_generalContent_LoginControl_txtUserName",
            passwordPath: "input#password, input#ctl00_generalContent_LoginControl_txtPassword",
            submitPath: "button.sign-in, input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth']
    },
};


/***/ }),

/***/ "./src/serverScripts/operators/3.ts":
/*!******************************************!*\
  !*** ./src/serverScripts/operators/3.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Pegas: () => (/* binding */ Pegas)
/* harmony export */ });
var Pegas = {
    link: function (operatorClaimId) { return "https://pegast.ru/agency/private/pegasys/booking/".concat(operatorClaimId); },
    title: 'Pegas',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'sletat',
        packet: JSON.parse('{"loginPath":"#username","passwordPath": "#password", "submitPath": ".auth_block input.main-button , #login-button , .auth-form #submit", "operatorIdSelector": ".pegasys-order-id"}'),
        password: 'nGtyxm'
    },
    selectors: {},
    cookie: {
        auth: ['SESSID', 'ASP.NET_SessionId', '__RequestVerificationToken', '.ASPXAUTH', 'PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/301.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/301.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RobinsonTours: () => (/* binding */ RobinsonTours)
/* harmony export */ });
var RobinsonTours = {
    link: function (operatorClaimId) { return "http://109.167.211.76/MasterWeb/login.aspx"; },
    title: 'Робинзон',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#ctl00_Login_ctl01, #ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "#ctl00_Login_ctl02, #ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "input[name='ctl00$Login$ctl03'], #ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/302.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/302.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Premiera: () => (/* binding */ Premiera)
/* harmony export */ });
var Premiera = {
    link: function (operatorClaimId) { return "http://samo.premiera.travel/cl_refer"; },
    title: 'Премьера',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#loginForm #login",
            "passwordPath": "#loginForm #passwd",
            "submitPath": "#loginForm button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/304.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/304.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GoodTimeTravel: () => (/* binding */ GoodTimeTravel)
/* harmony export */ });
var GoodTimeTravel = {
    link: function (operatorClaimId) { return 'http://online.goodtimetravel.ru/cl_refer?'; },
    title: 'Good Time Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": "#loginForm .button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/309.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/309.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ivolga: () => (/* binding */ Ivolga)
/* harmony export */ });
var Ivolga = {
    link: function (operatorClaimId) { return "http://www.ivolgatour.com/tm?id=1409&tm_page=%2Forder%2Fwork"; },
    title: 'Иволга',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#login",' +
            '"passwordPath":"#password", ' +
            '"submitPath": ".login .submit input"' +
            '}'),
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#login-form input[name=\'login\']",' +
            '"passwordPath":"#login-form input[name=\'password\']", ' +
            '"submitPath": "#login-form input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['current_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/311.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/311.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Matreshka: () => (/* binding */ Matreshka)
/* harmony export */ });
var Matreshka = {
    link: function (operatorClaimId) { return "http://online.matreshkatour.com/MasterWeb/login.aspx"; },
    title: 'Матрёшка-Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'ctl00$generalContent$LoginControl$txtUserName\']",' +
            '"passwordPath":"input[name=\'ctl00$generalContent$LoginControl$txtPassword\']", ' +
            '"submitPath": "input[name=\'ctl00$generalContent$LoginControl$btnLogin\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/315.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/315.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Beleon: () => (/* binding */ Beleon)
/* harmony export */ });
var Beleon = {
    link: function (operatorClaimId) { return "http://online.beleontours.ru/account/login"; },
    title: 'Beleon Tours',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#Login",' +
            '"passwordPath":"#Password", ' +
            '"submitPath": "#loginform input[type=\'submit\']"' +
            '}'),
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#Login",' +
            '"passwordPath":"#Password", ' +
            '"submitPath": "#loginForm input[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.AspNet.ApplicationCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/331.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/331.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Acti: () => (/* binding */ Acti)
/* harmony export */ });
var Acti = {
    link: function (operatorClaimId) { return 'http://online.actitour.ru/cl_refer'; },
    title: 'ACTI tour Russia',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#login",' +
            '"passwordPath":"#passwd", ' +
            '"submitPath": "#loginForm button.button"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/343.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/343.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlanTravel1: () => (/* binding */ PlanTravel1)
/* harmony export */ });
var PlanTravel1 = {
    link: function (operatorClaimId) { return "http://online1.plantravel.ru/cl_refer"; },
    title: 'Планета тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "#loginForm #login, input#ctl00_generalContent_LoginControl_txtUserName",
            passwordPath: "#loginForm #passwd, input#ctl00_generalContent_LoginControl_txtPassword",
            submitPath: "#loginForm button, input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/344.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/344.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Panteon: () => (/* binding */ Panteon)
/* harmony export */ });
var Panteon = {
    link: function (operatorClaimId) { return "http://booking.panteon.ru/MasterWeb1/login.aspx"; },
    title: 'Пантеон Тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login, #ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "#password, #ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "#loginDialog button.sign-in, #ctl00_generalContent_LoginControl_btnLogin"
        },
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth', 'CommonApplicationAuthCookie_.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/345.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/345.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Vand: () => (/* binding */ Vand)
/* harmony export */ });
var Vand = {
    link: function () { return ""; },
    title: 'Ванд',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        packet: {
            "loginPath": "form#login-auth-form input[name='login']",
            "passwordPath": "form#login-auth-form input[name='password']",
            "submitPath": "form#login-auth-form button[type='submit']"
        },
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/348.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/348.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PlanTravel: () => (/* binding */ PlanTravel)
/* harmony export */ });
var PlanTravel = {
    link: function (operatorClaimId) { return "http://online.plantravel.ru/cl_refer?loggedout=1"; },
    title: 'Планета тревел Lets Fly',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#loginForm #login",
            "passwordPath": "#loginForm #passwd",
            "submitPath": "#loginForm button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/361.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/361.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SpaceTravel: () => (/* binding */ SpaceTravel)
/* harmony export */ });
var SpaceTravel = {
    link: function (operatorClaimId) { return 'https://online.space-travel.ru/default.php?page=cl_refer'; },
    title: 'Спейс Тревел',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": ".samo_container .panel button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/378.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/378.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PearlRiver: () => (/* binding */ PearlRiver)
/* harmony export */ });
var PearlRiver = {
    link: function (operatorClaimId) { return 'http://web.prtc.travel'; },
    title: 'Жемчужная река',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": ".samo_container .panel button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/380.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/380.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TUInew: () => (/* binding */ TUInew)
/* harmony export */ });
var TUInew = {
    link: function (operatorClaimId) { return "http://b2b.tui.ru/default.php?page=cl_refer"; },
    title: 'TUI new',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'info@sleta',
        packet: {
            loginPath: "#login , #MainContent_LoginControl_UserName",
            passwordPath: "#passwd , #MainContent_LoginControl_Password",
            submitPath: "button.button , input[name='ctl00$MainContent$LoginControl$ctl05'] , #login_button",
            pageFormPath: {
                loginPath: "#login",
                passwordPath: "#passwd",
                submitPath: "button.button"
            },
            "operatorIdSelector": "#ctl00_generalContent_lbDogovorCode"
        },
        password: 'drfiv86yu8'
    },
    selectors: {
        queryInput: '.frm-input.element.CLAIMBEGIN.cl',
        searchButton: '.load'
    },
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/382.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/382.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelfieTravel: () => (/* binding */ SelfieTravel)
/* harmony export */ });
var SelfieTravel = {
    link: function (operatorClaimId) { return 'http://b2b.selfietravel.kz'; },
    title: 'SelfieTravel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: 'form#loginForm input#login',
            passwordPath: 'form#loginForm input#passwd',
            submitPath: 'form#loginForm button.button'
        },
    },
    selectors: {
        queryInput: 'input[name="CLAIMBEGIN"]',
        searchButton: 'button.load',
    },
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/39.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/39.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DiamondTours: () => (/* binding */ DiamondTours)
/* harmony export */ });
var DiamondTours = {
    link: function (operatorClaimId) { return "http://www.diamondtours.ru/diamond/agency/pa.jsp"; },
    title: 'Даймонд Турс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#entrance .nickname",' +
            '"passwordPath":"#entrance #password", ' +
            '"submitPath": "#entrance button"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"input[name=\'j_username\']",' +
            '"passwordPath":"input[name=\'j_password\']", ' +
            '"submitPath": "button[type=\'submit\']"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['JSESSIONID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/392.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/392.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Aerotour: () => (/* binding */ Aerotour)
/* harmony export */ });
var Aerotour = {
    link: function (operatorClaimId) { return "https://online.aerotur.travel/MasterWeb/login.aspx"; },
    title: 'АЭРОТУР',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#ctl00_generalContent_LoginControl_txtUserName , #login",
            "passwordPath": "#ctl00_generalContent_LoginControl_txtPassword , #password",
            "submitPath": "#ctl00_generalContent_LoginControl_btnLogin , .btn .btn-default .sign-in , #loginDialog > div > div > div.modal-footer > div.row > div.col-lg-2.col-md-2.col-sm-2 > button > span"
        }
    },
    selectors: {},
    cookie: {
        auth: ['identityCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/4.ts":
/*!******************************************!*\
  !*** ./src/serverScripts/operators/4.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TezTour: () => (/* binding */ TezTour)
/* harmony export */ });
var TezTour = {
    link: function (operatorClaimId) { return "http://online.tez-tour.com/armmanager/workplace/section/orders/preview-order?orderId=".concat(operatorClaimId); },
    title: 'TezTour',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'sletat',
        packet: {
            loginPath: "#j_username , #login-edit-0-email",
            passwordPath: "#j_password , #login-edit-0-password",
            submitPath: ".login-butt , form#login-form input[type='submit'] , div#loginform input[type='submit']"
        },
        password: 'B.AD5AJM7Uv8U)4d'
    },
    selectors: {},
    cookie: {
        auth: ['aid']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/41.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/41.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Bontour: () => (/* binding */ Bontour)
/* harmony export */ });
var Bontour = {
    link: function (operatorClaimId) { return "http://bontour.ru/agencies/online-booking/"; },
    title: 'Бон Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packetMagnifier: JSON.parse('{' +
            '"loginPath":"#login",' +
            '"passwordPath":"#passwd", ' +
            '"submitPath": "#loginbox input[type=\'submit\']"' +
            '}'),
        packet: JSON.parse('{' +
            '"loginPath":"#login",' +
            '"passwordPath":"#passwd", ' +
            '"submitPath": "#loginForm input.button"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/415.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/415.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Clickvoyage: () => (/* binding */ Clickvoyage)
/* harmony export */ });
var Clickvoyage = {
    link: function (operatorClaimId) { return "https://clickvoyage.ru/DisplayOrders/AgencyOrders"; },
    title: 'Click Voyage',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'info@sleta',
        password: 'drfiv86yu8',
        packet: {
            "loginPath": "#UserName, #ctl00_generalContent_LoginControl_txtUserName, #app > div > div > div > form > div:nth-child(1) > div > div > input",
            "passwordPath": "#Password, #ctl00_generalContent_LoginControl_txtPassword, #app > div > div > div > form > div:nth-child(2) > div > div > input",
            "submitPath": "#submitLoginForm, #ctl00_generalContent_LoginControl_btnLogin, #app > div > div > div > div > button"
        }
    },
    selectors: {
        queryInput: '.frm-input.element.CLAIMBEGIN.cl',
        searchButton: '.load'
    },
    cookie: {
        auth: ['.ASPXAUTH', 'SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/42.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/42.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ZlataPraga: () => (/* binding */ ZlataPraga)
/* harmony export */ });
var ZlataPraga = {
    link: function (operatorClaimId) { return "https://www.zlatapraga.ru/on-line/?url=cl_refer"; },
    title: 'Злата Прага',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#loginForm #login',
            passwordPath: '#loginForm #passwd',
            submitPath: '#loginForm button',
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/429.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/429.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RExpress: () => (/* binding */ RExpress)
/* harmony export */ });
var RExpress = {
    link: function (operatorClaimId) { return 'https://book.r-express.ru/login.aspx'; },
    title: 'Русский Экспресс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "#ctl00_generalContent_LoginControl_btnLogin"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/431.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/431.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EliteTravel: () => (/* binding */ EliteTravel)
/* harmony export */ });
var EliteTravel = {
    link: function (operatorClaimId) { return 'http://elita-travel.com/login'; },
    title: 'Elite Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#tabs input[name='login'], input#ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "#tabs input[name='password'], input#ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "#tabs-3 input[type='submit'], input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['current_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/432.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/432.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Unicorn: () => (/* binding */ Unicorn)
/* harmony export */ });
var Unicorn = {
    link: function (operatorClaimId) { return "http://b2b.unicorn.ru/Login.aspx"; },
    title: 'Unicorn',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#edtUsername',
            passwordPath: '#edtPassw',
            submitPath: '#BtnLogin'
        }
    },
    selectors: {},
    cookie: {
        auth: ['identityCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/439.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/439.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Paks: () => (/* binding */ Paks)
/* harmony export */ });
var Paks = {
    link: function (operatorClaimId) { return 'http://online.paks.ru/mw6/login.aspx'; },
    title: 'Пакс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form#loginForm input#login",
            passwordPath: "form#loginForm input#password",
            submitPath: "form#loginForm button.button"
        },
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/449.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/449.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OneTouchTravel: () => (/* binding */ OneTouchTravel)
/* harmony export */ });
var OneTouchTravel = {
    link: function (operatorClaimId) { return 'https://onetouch.travel'; },
    title: 'OneTouchTrravel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: 'form#loginForm input#login',
            passwordPath: 'form#loginForm input#passwd',
            submitPath: 'form#loginForm button.button'
        },
    },
    selectors: {
        queryInput: 'input[name="CLAIMBEGIN"]',
        searchButton: 'button.load',
    },
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/450.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/450.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PegasTui: () => (/* binding */ PegasTui)
/* harmony export */ });
var PegasTui = {
    link: function (operatorClaimId) { return "https://pegast.ru/agency/private/pegasys/booking/".concat(operatorClaimId); },
    title: 'Pegas from tui',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'sletat',
        packet: JSON.parse('{"loginPath":"#username","passwordPath": "#password", "submitPath": ".auth_block input.main-button , #login-button , .auth-form #submit", "operatorIdSelector": ".pegasys-order-id"}'),
        password: 'nGtyxm'
    },
    selectors: {},
    cookie: {
        auth: ['SESSID', 'ASP.NET_SessionId', '__RequestVerificationToken', '.ASPXAUTH', 'PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/452.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/452.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D2: () => (/* binding */ D2)
/* harmony export */ });
var D2 = {
    link: function (operatorClaimId) { return "https://lk.d2insur.ru"; },
    title: 'D2',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input#USER_LOGIN",
            "passwordPath": "input#USER_PASSWORD",
            "submitPath": "input#Login"
        }
    },
    selectors: {},
    cookie: {
        auth: ['identityCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/453.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/453.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Veditour: () => (/* binding */ Veditour)
/* harmony export */ });
var Veditour = {
    link: function (operatorClaimId) { return "http://advanced.veditour.ru/login.aspx"; },
    title: 'ВЕДИ ТУРГРУПП',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#ctl00_Login_ctl01, input#ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "#ctl00_Login_ctl02, input#ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "input[name='ctl00$Login$ctl03'], input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/454.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/454.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IlineTours: () => (/* binding */ IlineTours)
/* harmony export */ });
var IlineTours = {
    link: function (operatorClaimId) { return 'https://i-lin.tours'; },
    title: 'Турплатформа',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input#login",
            "passwordPath": "input#passwd",
            "submitPath": "form#loginForm button.button"
        }
    },
    selectors: {
        queryInput: '.frm-input.element.CLAIMBEGIN.cl',
        searchButton: '.load'
    },
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/46.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/46.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Troyka: () => (/* binding */ Troyka)
/* harmony export */ });
var Troyka = {
    link: function (operatorClaimId) { return "http://www.troyka.travel/online/cl_refer"; },
    title: 'Тройка Холдинг',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#loginForm #login",' +
            '"passwordPath":"#loginForm #passwd", ' +
            '"submitPath": "#loginForm button"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/49.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/49.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Vilar: () => (/* binding */ Vilar)
/* harmony export */ });
var Vilar = {
    link: function (operatorClaimId) { return "http://online.vilar-tours.ru/default.php?page=cl_refer"; },
    title: 'Vilar Tours',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#loginForm #login",' +
            '"passwordPath":"#loginForm #passwd", ' +
            '"submitPath": "#loginForm button"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/51.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/51.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ambotis: () => (/* binding */ Ambotis)
/* harmony export */ });
var Ambotis = {
    link: function (operatorClaimId) { return 'https://online.ambotis.ru/cl_refer?'; },
    title: 'Ambotis Holidays',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#login',
            passwordPath: '#passwd',
            submitPath: '#loginForm button.button'
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/53.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/53.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IntravelStoleshniki: () => (/* binding */ IntravelStoleshniki)
/* harmony export */ });
var IntravelStoleshniki = {
    link: function (operatorClaimId) { return 'https://online.intravel.ru/online/cl_refer?'; },
    title: 'Intravel Stoleshniki',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "#login",
            passwordPath: "#passwd",
            submitPath: "#loginbox .button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/536.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/536.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Krypton: () => (/* binding */ Krypton)
/* harmony export */ });
var Krypton = {
    link: function (operatorClaimId) { return 'http://online.kryptontour.ru'; },
    title: 'Криптон',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input#Login",
            "passwordPath": "input#Password",
            "submitPath": "form#loginform input[type=submit] , section#loginForm input[type='submit']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/54.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/54.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Sunmar: () => (/* binding */ Sunmar)
/* harmony export */ });
var Sunmar = {
    link: function (operatorClaimId) { return 'http://bron.sunmar.ru/Pages/Reservation/ReservationSearch.aspx'; },
    title: 'Sunmar',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'TATELS',
        packet: {
            loginPath: '#ctl00_ContentPlaceHolder1_UserName_I , #ctl00_TopMainPlace_tbx_login_text , #tbLogin , #txtUsername',
            passwordPath: '#ctl00_ContentPlaceHolder1_UserPassword_I , #ctl00_TopMainPlace_tbx_passwd_text , #tbPass , #txtPassword',
            submitPath: '#ctl00_ContentPlaceHolder1_GirisBtn_CD , #ctl00_TopMainPlace_btn_ok , #btnLogin , #btnLogin',
            operatorIdSelector: 'td[id^="col_ID_"] span '
        },
        password: 'KzbZmaPdHIOHWwTV'
    },
    selectors: {
        queryInput: '#ctl00_ContentPlaceHolder1_txtVoucherNo_I',
        searchButton: '#ctl00_ContentPlaceHolder1_ASPxButton1',
    },
    cookie: {
        auth: ['ASP.NET_SessionId'],
        userInfo: 'userInfo'
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/544.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/544.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CrimeanWave: () => (/* binding */ CrimeanWave)
/* harmony export */ });
var CrimeanWave = {
    link: function (operatorClaimId) { return 'https://b2b.besttt.ru'; },
    title: 'Крымская Волна',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "div#loginbox input#login",
            "passwordPath": "div#loginbox input#passwd",
            "submitPath": "div#loginbox button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/564.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/564.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RZHDTour: () => (/* binding */ RZHDTour)
/* harmony export */ });
var RZHDTour = {
    link: function (operatorClaimId) { return 'https://rzdtour.com'; },
    title: 'РЖД Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input#ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "input#ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/587.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/587.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TourPlatforma: () => (/* binding */ TourPlatforma)
/* harmony export */ });
var TourPlatforma = {
    link: function (operatorClaimId) { return 'https://tour-platform.ru'; },
    title: 'Турплатформа',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form.login input[type='text'], input#ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "form.login input[type='password'], input#ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "form.login div.base-button, input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/6.ts":
/*!******************************************!*\
  !*** ./src/serverScripts/operators/6.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Coral: () => (/* binding */ Coral)
/* harmony export */ });
var Coral = {
    link: function (operatorClaimId) { return 'http://online.coral.ru/Pages/Reservation/ReservationSearch.aspx'; },
    title: 'Coral',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: '#ctl00_ContentPlaceHolder1_UserName_I , #ctl00_TopMainPlace_tbx_login_text , #tbLogin , #txtUsername',
            passwordPath: '#ctl00_ContentPlaceHolder1_UserPassword_I , #ctl00_TopMainPlace_tbx_passwd_text , #tbPass , #txtPassword',
            submitPath: '#ctl00_ContentPlaceHolder1_GirisBtn_CD , #ctl00_TopMainPlace_btn_ok , #btnLogin , #btnLogin'
        },
    },
    selectors: {
        queryInput: '#ctl00_ContentPlaceHolder1_txtVoucherNo_I',
        searchButton: '#ctl00_ContentPlaceHolder1_ASPxButton1',
    },
    cookie: {
        auth: ['ASP.NET_SessionId', 'CoralPreference', 'ConferenceLogged'],
        userInfo: 'userInfo'
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/7.ts":
/*!******************************************!*\
  !*** ./src/serverScripts/operators/7.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BiblioGlobus: () => (/* binding */ BiblioGlobus)
/* harmony export */ });
var BiblioGlobus = {
    link: function (operatorClaimId) { return "https://www.bgoperator.ru/spis?nrequest=".concat(operatorClaimId); },
    title: 'Biblio Globus',
    authType: 'forms',
    claimUrlAuthType: 'basic',
    credentials: {
        login: 'sletat',
        packet: {
            "operatorIdSelector": ".claim_no",
            "loginPath": "#login",
            "passwordPath": "#pwd",
            "submitPath": "button.auth_tbl_btn_send"
        },
        password: '0I9~6!0!RWabduJ6Nw',
    },
    selectors: {
        claimButton: '#reqlist tbody td:nth-child(1) a',
        provisaButton: '#Form .buttons a[href^="chservice"]'
    },
    cookie: {
        auth: ['A1', 'L', 'Z1', 'T']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/743.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/743.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Loti: () => (/* binding */ Loti)
/* harmony export */ });
var Loti = {
    link: function (operatorClaimId) { return 'https://online.loti.ru'; },
    title: 'Loti',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form#loginForm input#login",
            "passwordPath": "form#loginForm input#passwd",
            "submitPath": "form#loginForm button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/768.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/768.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mercury: () => (/* binding */ Mercury)
/* harmony export */ });
var Mercury = {
    link: function (operatorClaimId) { return "http://online.mercury-europe.ru/MasterWebMercury/login.aspx"; },
    title: 'Меркурий',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form#loginForm input#login",
            "passwordPath": "form#loginForm input#passwd",
            "submitPath": "form#loginForm button.button"
        },
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/78.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/78.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Unex: () => (/* binding */ Unex)
/* harmony export */ });
var Unex = {
    link: function (operatorClaimId) { return "http://www.unextour.ru/account/login"; },
    title: 'UNEX',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "#Login",
            passwordPath: "#Password",
            submitPath: "#loginmenu .form-group input[type=\'submit\']"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.AspNet.ApplicationCookie', '.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/800.ts":
/*!********************************************!*\
  !*** ./src/serverScripts/operators/800.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MyAgent: () => (/* binding */ MyAgent)
/* harmony export */ });
var MyAgent = {
    link: function (operatorClaimId) { return "https://myagent.online/#/"; },
    title: 'Мой Агент',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "div.LoginForm input[type=text]",
            "passwordPath": "div.LoginForm input[type=password]",
            "submitPath": "div.LoginForm button[type=submit]"
        },
    },
    selectors: {},
    cookie: {
        auth: ['auth_token']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/81.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/81.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Spectrum: () => (/* binding */ Spectrum)
/* harmony export */ });
var Spectrum = {
    link: function (operatorClaimId) { return 'http://online.spectrum.ru/cl_refer?'; },
    title: 'Спектрум',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#login",' +
            '"passwordPath":"#passwd", ' +
            '"submitPath": "#loginForm button.button"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/83.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/83.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArtTour: () => (/* binding */ ArtTour)
/* harmony export */ });
var ArtTour = {
    link: function (operatorClaimId) { return "http://online.arttour.ru/cl_refer"; },
    title: 'АРТ-ТУР',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#login",
            "passwordPath": "#passwd",
            "submitPath": "#loginForm .button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/93.ts":
/*!*******************************************!*\
  !*** ./src/serverScripts/operators/93.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Balkan: () => (/* binding */ Balkan)
/* harmony export */ });
var Balkan = {
    link: function (operatorClaimId) { return "http://tour.balkan.ru/login.aspx"; },
    title: 'BALKAN',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "#ctl00_Login_ctl01 , #ctl00_generalContent_LoginControl_txtUserName , #a_log",
            passwordPath: "#ctl00_Login_ctl02 , #ctl00_generalContent_LoginControl_txtPassword , #a_pass",
            submitPath: "input[name='ctl00$Login$ctl03'] , input[name='ctl00$generalContent$LoginControl$btnLogin'] , header ~ .container button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/eskazan.ts":
/*!************************************************!*\
  !*** ./src/serverScripts/operators/eskazan.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EsKazan: () => (/* binding */ EsKazan)
/* harmony export */ });
var EsKazan = {
    link: function (operatorClaimId) { return 'https://tour-platform.ru'; },
    title: 'Турплатформа',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form.login input[type='text'], input#ctl00_generalContent_LoginControl_txtUserName",
            "passwordPath": "form.login input[type='password'], input#ctl00_generalContent_LoginControl_txtPassword",
            "submitPath": "form.login div.base-button, input#ctl00_generalContent_LoginControl_btnLogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['CommonApplicationAuthCookie_.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/evroport.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/evroport.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Evroport: () => (/* binding */ Evroport)
/* harmony export */ });
var Evroport = {
    link: function (operatorClaimId) { return 'http://evroport.ru/booking/login/loginform'; },
    title: 'Evroport',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "#LoginForm input[name='login'], input[name='authLogin']",
            "passwordPath": "#LoginForm input[name='password'], input[name='authPassword']",
            "submitPath": "#LoginDialog ~ div.ui-dialog-buttonpane button, button#blogin"
        }
    },
    selectors: {},
    cookie: {
        auth: ['PHPSESSID']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/inturist.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/inturist.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Intourist: () => (/* binding */ Intourist)
/* harmony export */ });
var Intourist = {
    link: function (operatorClaimId) { return 'http://www.ntk-intourist.ru/masterwebstandard/orderlist.aspx'; },
    title: 'NTK Intourist',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: 'SLETATRU',
        packet: {
            loginPath: "input[name='lgn'], input#header_lgn, input#headerLoginFormEmail",
            passwordPath: "input[name='pwd'], input#header_pwd, input#headerLoginFormPassword",
            submitPath: "form[name='f1'] input[type='submit'] , button.btn_go, div.login-popup__button > button.login-popup__btn-auth, div#headerLoginFormSignInButton",
        },
        password: 'MQSI9lF4',
    },
    selectors: {
        queryInput: 'input[name="dg"]',
        searchButton: 'input[value="Поиск"]',
        claimButton: 'body > table tr:nth-child(2) table.int tr.orderlist a.orderlist'
    },
    cookie: {
        auth: ['.ntkauth100316', 'ASP.NET_SessionId', '.intourist.authorization']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/kazunion.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/kazunion.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Kazunion: () => (/* binding */ Kazunion)
/* harmony export */ });
var Kazunion = {
    link: function (operatorClaimId) { return 'https://online.kazunion.com'; },
    title: 'kazunion',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form input#login",
            "passwordPath": "form input#passwd",
            "submitPath": "form button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['SAMO']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/letsFly.ts":
/*!************************************************!*\
  !*** ./src/serverScripts/operators/letsFly.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LetsFly: () => (/* binding */ LetsFly)
/* harmony export */ });
var LetsFly = {
    link: function (operatorClaimId) { return "http://online.letsfly.travel/MasterWeb/login.aspx"; },
    title: 'LetsFly',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form#loginForm input#login",
            "passwordPath": "form#loginForm input#password",
            "submitPath": "form#loginForm button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['identityCookie']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/magput.ts":
/*!***********************************************!*\
  !*** ./src/serverScripts/operators/magput.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MagPut: () => (/* binding */ MagPut)
/* harmony export */ });
var MagPut = {
    link: function (operatorClaimId) { return 'https://tury.magput.ru/agent/search_page.php'; },
    title: 'Магазин Путешествий',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form input#login",
            passwordPath: "form input#inputPassword",
            submitPath: "form button[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/melinoTravel.ts":
/*!*****************************************************!*\
  !*** ./src/serverScripts/operators/melinoTravel.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MelinoTravel: () => (/* binding */ MelinoTravel)
/* harmony export */ });
var MelinoTravel = {
    link: function (operatorClaimId) { return 'https://online.melinotravel.com'; },
    title: 'Melino Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form input#login",
            "passwordPath": "form input#passwd",
            "submitPath": "form button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/oneClickTravel.ts":
/*!*******************************************************!*\
  !*** ./src/serverScripts/operators/oneClickTravel.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OneClickTravel: () => (/* binding */ OneClickTravel)
/* harmony export */ });
var OneClickTravel = {
    link: function (operatorClaimId) { return 'https://93.184.162.101'; },
    title: 'One Click Travel',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form input#login",
            "passwordPath": "form input#passwd",
            "submitPath": "form button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/rivieraTour.ts":
/*!****************************************************!*\
  !*** ./src/serverScripts/operators/rivieraTour.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RivieraTour: () => (/* binding */ RivieraTour)
/* harmony export */ });
var RivieraTour = {
    link: function (operatorClaimId) { return "http://online.riviera-sochi.ru/MasterWeb_15/login.aspx"; },
    title: 'Ривьера Сочи',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form input#login",
            "passwordPath": "form input#passwd",
            "submitPath": "form button.button"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/rusExpress.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/rusExpress.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RusExpress: () => (/* binding */ RusExpress)
/* harmony export */ });
var RusExpress = {
    link: function (operatorClaimId) { return 'https://book.r-express.ru/login.aspx'; },
    title: 'Русский Экспресс',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: JSON.parse('{' +
            '"loginPath":"#ctl00_generalContent_LoginControl_txtUserName",' +
            '"passwordPath":"#ctl00_generalContent_LoginControl_txtPassword", ' +
            '"submitPath": "#ctl00_generalContent_LoginControl_btnLogin"' +
            '}')
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/rusSeasons.ts":
/*!***************************************************!*\
  !*** ./src/serverScripts/operators/rusSeasons.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RusSeasons: () => (/* binding */ RusSeasons)
/* harmony export */ });
var RusSeasons = {
    link: function (operatorClaimId) { return 'https://www.russeas.ru'; },
    title: 'Русские Сезоны',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "form input#login",
            "passwordPath": "form input#pwd",
            "submitPath": "form button[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/skanTour.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/skanTour.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SkanTour: () => (/* binding */ SkanTour)
/* harmony export */ });
var SkanTour = {
    link: function (operatorClaimId) { return 'https://old.scantour.ru'; },
    title: 'СканТур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input[name=login]",
            "passwordPath": "input[name=password]",
            "submitPath": "input[name=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/tariTour.ts":
/*!*************************************************!*\
  !*** ./src/serverScripts/operators/tariTour.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TariTour: () => (/* binding */ TariTour)
/* harmony export */ });
var TariTour = {
    link: function (operatorClaimId) { return 'https://www.tarispb.ru'; },
    title: 'Тари Тур',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "input#agentLoginName",
            "passwordPath": "input#agentLoginPswd",
            "submitPath": "form#agentLoginForm button[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/tourClick.ts":
/*!**************************************************!*\
  !*** ./src/serverScripts/operators/tourClick.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TourClick: () => (/* binding */ TourClick)
/* harmony export */ });
var TourClick = {
    link: function (operatorClaimId) { return 'https://id154.tour-click.ru'; },
    title: 'TourClick',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form#login-form input#input-18",
            passwordPath: "form#login-form input#input-21",
            submitPath: "button[form=login-form]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['tourclick_session']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/unona.ts":
/*!**********************************************!*\
  !*** ./src/serverScripts/operators/unona.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Unona: () => (/* binding */ Unona)
/* harmony export */ });
var Unona = {
    link: function (operatorClaimId) { return 'https://kldtur.ru'; },
    title: 'Vodohod',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            loginPath: "form.form-login input#log",
            passwordPath: "form.form-login input#pwd",
            submitPath: "form.form-login input[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ }),

/***/ "./src/serverScripts/operators/vodohod.ts":
/*!************************************************!*\
  !*** ./src/serverScripts/operators/vodohod.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Vodohod: () => (/* binding */ Vodohod)
/* harmony export */ });
var Vodohod = {
    link: function (operatorClaimId) { return 'https://vodohod.com'; },
    title: 'Vodohod',
    authType: 'forms',
    claimUrlAuthType: 'forms',
    credentials: {
        login: '',
        password: '',
        packet: {
            "loginPath": "div.section-auth__content input[name=login]",
            "passwordPath": "div.section-auth__content input[name=password]",
            "submitPath": "div.section-auth__bottom button[type=submit]"
        }
    },
    selectors: {},
    cookie: {
        auth: ['.masterweblight-auth']
    }
};


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!*******************************!*\
  !*** ./src/app/background.ts ***!
  \*******************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillVisaFormsInCurrentTab: () => (/* binding */ fillVisaFormsInCurrentTab),
/* harmony export */   navigateToBookedClaim: () => (/* binding */ navigateToBookedClaim),
/* harmony export */   navigateToClaimPaymentTransferForm: () => (/* binding */ navigateToClaimPaymentTransferForm),
/* harmony export */   navigateToClaimRefundTransgerForm: () => (/* binding */ navigateToClaimRefundTransgerForm),
/* harmony export */   navigateToFormFill: () => (/* binding */ navigateToFormFill),
/* harmony export */   performTOAuth: () => (/* binding */ performTOAuth)
/* harmony export */ });
/* harmony import */ var _operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operators */ "./src/app/operators.ts");
/* harmony import */ var _services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./services */ "./src/app/services/index.ts");
/* harmony import */ var _messages__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./messages */ "./src/app/messages/index.ts");
/* harmony import */ var _models__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./models */ "./src/app/models/index.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./src/app/utils/index.ts");
/* harmony import */ var _operatorScripts_3__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./operatorScripts/3 */ "./src/app/operatorScripts/3.ts");
/* harmony import */ var _operatorScripts_6__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./operatorScripts/6 */ "./src/app/operatorScripts/6.ts");
/* harmony import */ var _operatorScripts_7__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./operatorScripts/7 */ "./src/app/operatorScripts/7.ts");
/* harmony import */ var _operatorScripts_9__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./operatorScripts/9 */ "./src/app/operatorScripts/9.ts");
/* harmony import */ var _operatorScripts_19__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./operatorScripts/19 */ "./src/app/operatorScripts/19.ts");
/* harmony import */ var _operatorScripts_20__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./operatorScripts/20 */ "./src/app/operatorScripts/20.ts");
/* harmony import */ var _operatorScripts_51__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./operatorScripts/51 */ "./src/app/operatorScripts/51.ts");
/* harmony import */ var _operatorScripts_171__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./operatorScripts/171 */ "./src/app/operatorScripts/171.ts");
/* harmony import */ var _operatorScripts_380__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./operatorScripts/380 */ "./src/app/operatorScripts/380.ts");
/* harmony import */ var _operatorScripts_customAuthentification_19__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./operatorScripts/customAuthentification/19 */ "./src/app/operatorScripts/customAuthentification/19.ts");
/* harmony import */ var _utils_pagePanel__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./utils/pagePanel */ "./src/app/utils/pagePanel.ts");
/* harmony import */ var _chunks_createTabAndDeleteCookies__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./chunks/createTabAndDeleteCookies */ "./src/app/chunks/createTabAndDeleteCookies.ts");
/* harmony import */ var _utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./utils/chunks/createPushNotification */ "./src/app/utils/chunks/createPushNotification.ts");
/* harmony import */ var _services_chunks_getFillerDataByClaimId__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./services/chunks/getFillerDataByClaimId */ "./src/app/services/chunks/getFillerDataByClaimId.ts");
/* harmony import */ var _utils_parseDateString__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./utils/parseDateString */ "./src/app/utils/parseDateString.ts");
/* harmony import */ var _operatorScripts_goToMyAgentAndFill__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./operatorScripts/goToMyAgentAndFill */ "./src/app/operatorScripts/goToMyAgentAndFill.ts");
/* harmony import */ var _utils_fillCBLegalEntities__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./utils/fillCBLegalEntities */ "./src/app/utils/fillCBLegalEntities.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483634__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./../serverScripts/navToBookedClaim/navToBookedClaim_2147483634 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483634.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483639__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./../serverScripts/navToBookedClaim/navToBookedClaim_2147483639 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483639.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483640__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./../serverScripts/navToBookedClaim/navToBookedClaim_2147483640 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483640.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483641__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./../serverScripts/navToBookedClaim/navToBookedClaim_2147483641 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483641.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_7__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./../serverScripts/navToBookedClaim/navToBookedClaim_7 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_7.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_252__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./../serverScripts/navToBookedClaim/navToBookedClaim_252 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_252.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_2147483645__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./../serverScripts/navToBookedClaim/navToBookedClaim_2147483645 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_2147483645.ts");
/* harmony import */ var _serverScripts_navToBookedClaim_navToBookedClaim_800__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./../serverScripts/navToBookedClaim/navToBookedClaim_800 */ "./src/serverScripts/navToBookedClaim/navToBookedClaim_800.ts");
/* harmony import */ var _utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./utils/chunks/constants_urls */ "./src/app/utils/chunks/constants_urls.ts");































function navigateToBookedClaim(_a, Creditans) {
    var tourUrl = _a.tourUrl, claimId = _a.claimId, sourceId = _a.sourceId, claimNumber = _a.claimNumber, secretField = _a.secretField;
    var navToBookedClaiArgs = {
        credentials: Creditans,
        tourUrl: tourUrl,
        secretField: secretField,
        claimNumber: claimNumber,
        sourceId: sourceId,
        claimId: claimId
    };
    switch (sourceId) {
        case 2147483639: {
            navToBookedClaiArgs.credentials.login = 'sletatdt@sletat.ru';
            navToBookedClaiArgs.credentials.password = 'Sletat2022';
            navToBookedClaiArgs.tourUrl = 'https://city.travel/user/orders?bookid={0}'.replace('{0}', claimId);
            return (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483639__WEBPACK_IMPORTED_MODULE_23__.navToBookedClaim)(navToBookedClaiArgs);
        }
        case 2147483640: {
            navToBookedClaiArgs.credentials.company = 'GORTRAVEL';
            navToBookedClaiArgs.credentials.login = 'roman';
            navToBookedClaiArgs.credentials.password = '111111';
            navToBookedClaiArgs.tourUrl = 'https://b2b.acase.ru/order/{0}'.replace('{0}', claimId);
            return (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483640__WEBPACK_IMPORTED_MODULE_24__.navToBookedClaim)(navToBookedClaiArgs);
        }
        case 2147483641: {
            navToBookedClaiArgs.credentials.login = 'r.shvets';
            navToBookedClaiArgs.credentials.password = 'zM3PsU8';
            navToBookedClaiArgs.tourUrl = 'https://bronevik.com/ru/client/view.php?claim={0}'.replace('{0}', claimId);
            return (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483641__WEBPACK_IMPORTED_MODULE_25__.navToBookedClaim)(navToBookedClaiArgs);
        }
        case 2147483642: {
            navToBookedClaiArgs.credentials.login = 'gortr';
            navToBookedClaiArgs.credentials.password = 'Nv7N3-*tOQQatN6vh';
            return (0,_serverScripts_navToBookedClaim_navToBookedClaim_7__WEBPACK_IMPORTED_MODULE_26__.navToBookedClaim)(navToBookedClaiArgs);
        }
        case 2147483643: {
            navToBookedClaiArgs.credentials.login = 'mgt@cb.sletat.ru';
            navToBookedClaiArgs.credentials.password = 'mgt@cb.sletat.ru';
            navToBookedClaiArgs.tourUrl = 'https://www.alean.ru/agency/cabinet/#!/orderbook/{0}'.replace('{0}', claimId);
            return (0,_serverScripts_navToBookedClaim_navToBookedClaim_252__WEBPACK_IMPORTED_MODULE_27__.navToBookedClaim)(navToBookedClaiArgs);
        }
        case 2147483645: {
            navToBookedClaiArgs.credentials.login = 'sletatdt@sletat.ru';
            navToBookedClaiArgs.credentials.password = 'Sletat2022.//';
            navToBookedClaiArgs.tourUrl = 'https://b2b.ostrovok.ru/my/orders/?order_id={0}'.replace('{0}', claimId);
            return (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483645__WEBPACK_IMPORTED_MODULE_28__.navToBookedClaim)(navToBookedClaiArgs);
        }
        case 2147483646: {
            navToBookedClaiArgs.credentials.login = 'sletatdt@sletat.ru';
            navToBookedClaiArgs.credentials.password = 'LewCwp7ef8';
            navToBookedClaiArgs.tourUrl = 'https://simpleconnect.online/#/avia/order/{0}'.replace('{0}', claimId);
            return (0,_serverScripts_navToBookedClaim_navToBookedClaim_800__WEBPACK_IMPORTED_MODULE_29__.navToBookedClaim)(navToBookedClaiArgs);
        }
        case 2147483634: {
            navToBookedClaiArgs.credentials.login = 'sletatdt';
            navToBookedClaiArgs.credentials.password = 'T#-uI35_17ez0cz';
            navToBookedClaiArgs.tourUrl = 'https://www.russeas.ru/requests?nrequest={0}'.replace('{0}', claimId);
            return (0,_serverScripts_navToBookedClaim_navToBookedClaim_2147483634__WEBPACK_IMPORTED_MODULE_22__.navToBookedClaim)(navToBookedClaiArgs);
        }
    }
    return (0,_services__WEBPACK_IMPORTED_MODULE_1__.getScriptFromApi)(sourceId, _models__WEBPACK_IMPORTED_MODULE_3__.ScriptType.NavToBookedClaim)
        .then(function (serverScript) {
        /************************************************/
        var execError = null;
        // ----------------------------------------------
        // для тестирования
        // try {
        //     navToBookedClaimScript(navToBookedClaiArgs);
        // } catch (error) {
        //     console.dir(error);
        //     execError = error;
        // }
        // ----------------------------------------------
        // ----------------------------------------------
        // боевой
        if (serverScript && serverScript.body) {
            var navToBookedClaim = new Function('navToBookedClaiArgs', serverScript.body);
            try {
                navToBookedClaim(navToBookedClaiArgs);
            }
            catch (error) {
                // createPushNotification({
                //     title: 'Провальный провал',
                //     notificationMessage: 'При выполнении серверного скрипта произошла ошибка'
                // });
                console.log('Провальный провал при выполнении серверного скрипта NavToBookedClaim:');
                console.dir(error);
                execError = error;
            }
        }
        else {
            console.log("\u0421\u043A\u0440\u0438\u043F\u0442 \u0442\u0438\u043F\u0430 NavToBookedClaim \u0434\u043B\u044F sletaId = ".concat(sourceId, " \u043D\u0435 \u0431\u044B\u043B \u043E\u0431\u043D\u0430\u0440\u0443\u0436\u0435\u043D"));
            execError = 'Печалька, нет скрипта';
        }
        // ----------------------------------------------
        if (!execError) {
            // createPushNotification({
            //     title: 'Успешный успех',
            //     notificationMessage: 'Выполнено при помощи серверного скрипта'
            // });
            throw new Error('Выполнено при помощи серверного скрипта');
        }
        /************************************************/
        return new Promise(function (res, rej) { return res({}); });
    });
}
function navigateToFormFill(_a, data) {
    var tourUrl = _a.tourUrl, claimId = _a.claimId, sourceId = _a.sourceId, claimNumber = _a.claimNumber, secretField = _a.secretField;
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    var operatorsExclusion = [7, 9, 269];
    var navigateUrl = '';
    var claimDetails;
    var sourceTab;
    var newTab;
    return (0,_services__WEBPACK_IMPORTED_MODULE_1__.getScriptFromApi)(sourceId, _models__WEBPACK_IMPORTED_MODULE_3__.ScriptType.FormFill)
        .then(function (serverScript) {
        /************************************************/
        var execError = null;
        var context = {
            data: data,
            tourUrl: tourUrl,
            secretField: secretField,
            claimNumber: claimNumber,
            sourceId: sourceId,
            toNumberSaveUrl: _utils_chunks_constants_urls__WEBPACK_IMPORTED_MODULE_30__.toNumberSaveUrl
        };
        // ----------------------------------------------
        // для тестирования
        // try {
        //     formFillScript(context);
        // } catch (error) {
        //     console.dir(error);
        //     execError = error;
        // }
        // ----------------------------------------------
        // ----------------------------------------------
        // боевой
        if (serverScript && serverScript.body) {
            var formFill = new Function('context', serverScript.body);
            try {
                formFill(context);
            }
            catch (error) {
                // createPushNotification({
                //     title: 'Провальный провал',
                //     notificationMessage: 'При выполнении серверного скрипта произошла ошибка'
                // });
                console.log('Провальный провал FormFill');
                console.dir(error);
                execError = error;
            }
        }
        else {
            console.log("\u0421\u043A\u0440\u0438\u043F\u0442 \u0442\u0438\u043F\u0430 FormFill \u0434\u043B\u044F sletaId = ".concat(sourceId, " \u043D\u0435 \u0431\u044B\u043B \u043E\u0431\u043D\u0430\u0440\u0443\u0436\u0435\u043D"));
            execError = 'Печалька, нет скрипта';
        }
        // ----------------------------------------------
        if (!execError) {
            // createPushNotification({
            //     title: 'Успешный успех',
            //     notificationMessage: 'Выполнено при помощи серверного скрипта'
            // });
            throw new Error('Выполнено при помощи серверного скрипта');
        }
        /************************************************/
        return new Promise(function (res, rej) { return res(); });
    });
}
function fillVisaFormsInCurrentTab(_a, data) {
    var tourUrl = _a.tourUrl, claimId = _a.claimId, sourceId = _a.sourceId, claimNumber = _a.claimNumber, secretField = _a.secretField;
    return (0,_services__WEBPACK_IMPORTED_MODULE_1__.getScriptFromApi)(sourceId, _models__WEBPACK_IMPORTED_MODULE_3__.ScriptType.VisaFill)
        .then(function (script) {
        /************************************************/
        var execError = null;
        var visaFillArgs = {
            data: data,
            claimNumber: claimNumber,
            sourceId: sourceId
        };
        // ----------------------------------------------
        // для тестирования
        // try {
        //     visaFillScript(visaFillArgs);
        // } catch (error) {
        //     console.dir(error);
        //     execError = error;
        // }
        // ----------------------------------------------
        // ----------------------------------------------
        // боевой
        if (script && script.body) {
            var visaFill = new Function('visaFillArgs', script.body);
            try {
                visaFill(visaFillArgs);
            }
            catch (error) {
                // createPushNotification({
                //     title: 'Провальный провал',
                //     notificationMessage: 'При выполнении серверного скрипта произошла ошибка'
                // });
                console.log('Провальный провал VisaFill');
                console.dir(error);
                execError = error;
            }
        }
        else {
            console.log("\u0421\u043A\u0440\u0438\u043F\u0442 \u0442\u0438\u043F\u0430 VisaFill \u0434\u043B\u044F sletaId = ".concat(sourceId, " \u043D\u0435 \u0431\u044B\u043B \u043E\u0431\u043D\u0430\u0440\u0443\u0436\u0435\u043D"));
            execError = 'Печалька, нет скрипта';
        }
        // ----------------------------------------------
        if (!execError) {
            // createPushNotification({
            //     title: 'Успешный успех',
            //     notificationMessage: 'Выполнено при помощи серверного скрипта'
            // });
            throw new Error('Выполнено при помощи серверного скрипта');
        }
        /************************************************/
        return Promise.resolve();
    })
        .then(function () {
        chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
            var currentTab = tabs[0];
            switch (sourceId) {
                case 3:
                    return (0,_operatorScripts_3__WEBPACK_IMPORTED_MODULE_5__.fillVisaForms)(currentTab, data, claimNumber, sourceId);
                case 6:
                    return (0,_operatorScripts_6__WEBPACK_IMPORTED_MODULE_6__.fillVisaForms)(currentTab, data.autoFillerData, claimNumber, sourceId);
                case 7:
                    return (0,_operatorScripts_7__WEBPACK_IMPORTED_MODULE_7__.fillVisaForms)(currentTab, data, claimNumber, sourceId);
                case 9:
                    return (0,_operatorScripts_9__WEBPACK_IMPORTED_MODULE_8__.fillVisaForms)(currentTab, data.autoFillerData, claimNumber, sourceId);
                case 19:
                    return (0,_operatorScripts_19__WEBPACK_IMPORTED_MODULE_9__.fillVisaForms)(currentTab, data, claimNumber, sourceId);
                case 20:
                    return (0,_operatorScripts_20__WEBPACK_IMPORTED_MODULE_10__.fillVisaForms)(currentTab, data.autoFillerData, claimNumber, sourceId);
                case 51:
                    return (0,_operatorScripts_51__WEBPACK_IMPORTED_MODULE_11__.fillVisaForms)(currentTab, data.autoFillerData, claimNumber, sourceId);
                case 54:
                    return (0,_operatorScripts_6__WEBPACK_IMPORTED_MODULE_6__.fillVisaForms)(currentTab, data.autoFillerData, claimNumber, sourceId);
                case 171:
                    return (0,_operatorScripts_171__WEBPACK_IMPORTED_MODULE_12__.fillVisaForms)(currentTab, data.autoFillerData, claimNumber, sourceId);
                case 380:
                    return (0,_operatorScripts_380__WEBPACK_IMPORTED_MODULE_13__.fillVisaForms)(currentTab, data.autoFillerData, claimNumber, sourceId);
                default: break;
            }
        });
    });
}
var navigateToClaimPaymentTransferForm = function (_a, Creditans, claimTransferDetails) {
    var tourUrl = _a.tourUrl, claimId = _a.claimId, sourceId = _a.sourceId, claimNumber = _a.claimNumber, secretField = _a.secretField;
    return new Promise(function (resolve) {
        var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
        return (0,_chunks_createTabAndDeleteCookies__WEBPACK_IMPORTED_MODULE_16__.createTabAndDeleteCookies)(operator, tourUrl, Creditans)
            .then(function (data) {
            switch (sourceId) {
                case 9: return (0,_operatorScripts_9__WEBPACK_IMPORTED_MODULE_8__.navigateToClaimTransferPage)(data.tab, claimId, sourceId, data.navigate_url, claimTransferDetails);
            }
        });
    });
};
var navigateToClaimRefundTransgerForm = function (_a, Creditans, claimRefundDetails) {
    var tourUrl = _a.tourUrl, claimId = _a.claimId, sourceId = _a.sourceId, claimNumber = _a.claimNumber, secretField = _a.secretField;
    return new Promise(function (resolve) {
        var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
        return (0,_chunks_createTabAndDeleteCookies__WEBPACK_IMPORTED_MODULE_16__.createTabAndDeleteCookies)(operator, tourUrl, Creditans)
            .then(function (data) {
            switch (sourceId) {
                case 9: return (0,_operatorScripts_9__WEBPACK_IMPORTED_MODULE_8__.navigateToClaimRefundPage)(data.tab, claimId, sourceId, data.navigate_url, claimRefundDetails);
            }
        });
    });
};
var performTOAuth = function (sourceId, data) { return new Promise(function (resolve) {
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[sourceId];
    var notRemoveLoginTabOperators = [4, 7, 113, 125];
    var alwaysNewtabOperators = [19, 125];
    data.loginPath = data.loginPath.replace('{0}', encodeURIComponent(data.login));
    data.loginPath = data.loginPath.replace('{1}', encodeURIComponent(data.password));
    // обработчики для особых случаев авторизации где недостаточно просто перейти на нужную страницу и заполнить стандартную форму логина/пароля
    var specialCases = {
        19: [{
                performer: _operatorScripts_customAuthentification_19__WEBPACK_IMPORTED_MODULE_14__.depositCustomAuth,
                urlReg: /(http:\/\/|https:\/\/)185\.113\.119\.31:50501.*/
            }]
    };
    return (0,_services__WEBPACK_IMPORTED_MODULE_1__.getScriptFromApi)(sourceId, _models__WEBPACK_IMPORTED_MODULE_3__.ScriptType.Login)
        .then(function (script) {
        /************************************************/
        var execError = null;
        var loginArgs = {
            data: data
        };
        // ----------------------------------------------
        // для тестирования
        // try {
        //     loginScript(loginArgs);
        // } catch (error) {
        //     console.dir(error);
        //     execError = error;
        // }
        // ----------------------------------------------
        // ----------------------------------------------
        // боевой
        if (script && script.body) {
            var login = new Function('loginArgs', script.body);
            try {
                login(loginArgs);
            }
            catch (error) {
                // createPushNotification({
                //     title: 'Провальный провал',
                //     notificationMessage: 'При выполнении серверного скрипта произошла ошибка'
                // });
                console.log('Провальный провал Login');
                console.dir(error);
                execError = error;
            }
        }
        else {
            console.log("\u0421\u043A\u0440\u0438\u043F\u0442 \u0442\u0438\u043F\u0430 Login \u0434\u043B\u044F sletaId = ".concat(sourceId, " \u043D\u0435 \u0431\u044B\u043B \u043E\u0431\u043D\u0430\u0440\u0443\u0436\u0435\u043D"));
            execError = 'Печалька, нет скрипта';
        }
        // -----------------------------------------------
        if (!execError) {
            // createPushNotification({
            //     title: 'Успешный успех',
            //     notificationMessage: 'Выполнено при помощи серверного скрипта'
            // });
            throw new Error('Выполнено при помощи серверного скрипта');
        }
        /************************************************/
        return new Promise(function (res, rej) { return res({}); });
    });
}); };
(0,_utils__WEBPACK_IMPORTED_MODULE_4__.addMessageListener)(function (request, sender, sendResponse) {
    var messageSender = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.detectSender)(sender);
    var operator = _operators__WEBPACK_IMPORTED_MODULE_0__.OPERATORS[request.payload.sourceId];
    //const dateFormat = 'DD.MM.YYYY';
    var defaultDate = '01.01.1900';
    var orderFunc = function (t1, t2) {
        return (0,_utils_parseDateString__WEBPACK_IMPORTED_MODULE_19__.parseDateString)(t1.birthday || defaultDate).getTime() -
            (0,_utils_parseDateString__WEBPACK_IMPORTED_MODULE_19__.parseDateString)(t2.birthday || defaultDate).getTime();
    };
    if (request.payload.senderElementId === 'fillCbLe') {
        (0,_utils_fillCBLegalEntities__WEBPACK_IMPORTED_MODULE_21__.fillCBLegalEntities)(request.payload.additionalInfo);
    }
    if (request.payload.senderElementId === 'authBt') {
        performTOAuth(request.payload.sourceId, request.payload.additionalInfo);
    }
    else {
        switch (messageSender) {
            case _models__WEBPACK_IMPORTED_MODULE_3__.SenderTypes.TAB_SENDER:
                switch (request.payload.senderElementId) {
                    case 'magnifier':
                        var magnifierType = request.payload.additionalInfo.magnifierType;
                        return (0,_services__WEBPACK_IMPORTED_MODULE_1__.getClaimUrl)({ token: request.payload.secretField, type: magnifierType })
                            .then(function (data) {
                            if (!data.Credentials) {
                                return (0,_utils_pagePanel__WEBPACK_IMPORTED_MODULE_15__.createTabErrorInCurrent)('Не удалось получить логин/пароль!', 'Похоже все логины для этого оператора сейчас заняты.');
                            }
                            else {
                                return navigateToBookedClaim({
                                    tourUrl: data.Url,
                                    claimId: request.payload.claimId,
                                    sourceId: request.payload.sourceId,
                                    claimNumber: request.payload.claimNumber,
                                    secretField: request.payload.secretField
                                }, {
                                    login: data.Credentials.Login,
                                    password: data.Credentials.Password
                                });
                            }
                        })
                            .catch(function (error) {
                            return (0,_utils__WEBPACK_IMPORTED_MODULE_4__.sendMessage)((0,_messages__WEBPACK_IMPORTED_MODULE_2__.createErrorMessage)(error.message));
                        });
                    case 'goToPaymentTransferBt':
                        return (0,_services__WEBPACK_IMPORTED_MODULE_1__.getClaimUrl)({ token: request.payload.secretField, type: 'default' })
                            .then(function (data) {
                            return (0,_services__WEBPACK_IMPORTED_MODULE_1__.getClaimTransferOperationDetails)({
                                token: request.payload.secretField,
                                trasferOperationRequestId: request.payload.paymentOperationId
                            })
                                .then(function (transferData) {
                                navigateToClaimPaymentTransferForm({
                                    tourUrl: data.Url,
                                    claimId: request.payload.claimId,
                                    sourceId: request.payload.sourceId,
                                    claimNumber: request.payload.claimNumber,
                                    secretField: request.payload.secretField
                                }, {
                                    login: data.Credentials.Login,
                                    password: data.Credentials.Password
                                }, transferData);
                            });
                        });
                    case 'goToPaymentRefundBt':
                        return (0,_services__WEBPACK_IMPORTED_MODULE_1__.getClaimUrl)({ token: request.payload.secretField, type: 'default' })
                            .then(function (data) {
                            return (0,_services__WEBPACK_IMPORTED_MODULE_1__.getClaimRefundOperationDetails)({
                                token: request.payload.secretField,
                                refundOperationId: request.payload.paymentOperationId
                            })
                                .then(function (refundData) {
                                navigateToClaimRefundTransgerForm({
                                    tourUrl: data.Url,
                                    claimId: request.payload.claimId,
                                    sourceId: request.payload.sourceId,
                                    claimNumber: request.payload.claimNumber,
                                    secretField: request.payload.secretField
                                }, {
                                    login: data.Credentials.Login,
                                    password: data.Credentials.Password
                                }, refundData);
                            });
                        });
                    case 'goToMyAgent':
                        return (0,_services_chunks_getFillerDataByClaimId__WEBPACK_IMPORTED_MODULE_18__.getFillerDataByClaimId)({ token: request.payload.secretField })
                            .then(function (data) {
                            data.autoFillerData.touristDataItems = data.autoFillerData.touristDataItems
                                ? data.autoFillerData.touristDataItems.sort(orderFunc)
                                : data.autoFillerData.touristDataItems;
                            // if (!data.login || !data.password) {
                            //     createTabErrorInCurrent('Не удалось получить логин/пароль!', 'Похоже все логины для этого оператора сейчас заняты.');
                            //     return;
                            // }
                            return (0,_operatorScripts_goToMyAgentAndFill__WEBPACK_IMPORTED_MODULE_20__.goToMyAgentAndFill)({
                                tourUrl: data.autoFillerData.tourUrl,
                                claimId: request.payload.claimId,
                                sourceId: request.payload.sourceId,
                                claimNumber: request.payload.claimNumber,
                                secretField: request.payload.secretField,
                            }, data, request.payload.additionalInfo)
                                .then(function () {
                                return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_17__.createPushNotification)({
                                    claimId: request.payload.claimNumber,
                                    operator: operator,
                                    errorText: null
                                });
                            })
                                .catch(function (message) {
                                console.log(message);
                                return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_17__.createPushNotification)({
                                    claimId: request.payload.claimNumber,
                                    operator: operator,
                                    errorText: message.error
                                });
                            });
                        })
                            .catch(function (error) {
                            return (0,_utils__WEBPACK_IMPORTED_MODULE_4__.sendMessage)((0,_messages__WEBPACK_IMPORTED_MODULE_2__.createErrorMessage)(error.message));
                        });
                }
            case _models__WEBPACK_IMPORTED_MODULE_3__.SenderTypes.EXT_SENDER:
                return (0,_services_chunks_getFillerDataByClaimId__WEBPACK_IMPORTED_MODULE_18__.getFillerDataByClaimId)({ token: request.payload.secretField })
                    .then(function (data) {
                    data.autoFillerData.touristDataItems = data.autoFillerData.touristDataItems
                        ? data.autoFillerData.touristDataItems.sort(orderFunc)
                        : data.autoFillerData.touristDataItems;
                    switch (request.payload.senderElementId) {
                        case 'transferBt':
                            if (!data.login || !data.password) {
                                (0,_utils_pagePanel__WEBPACK_IMPORTED_MODULE_15__.createTabErrorInCurrent)('Не удалось получить логин/пароль!', 'Похоже все логины для этого оператора сейчас заняты.');
                                return;
                            }
                            return navigateToFormFill({
                                tourUrl: data.autoFillerData.tourUrl,
                                claimId: request.payload.claimId,
                                sourceId: request.payload.sourceId,
                                claimNumber: request.payload.claimNumber,
                                secretField: request.payload.secretField
                            }, data)
                                .then(function () {
                                return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_17__.createPushNotification)({
                                    claimId: request.payload.claimNumber,
                                    operator: operator,
                                    errorText: null
                                });
                            })
                                .catch(function (message) {
                                console.log(message);
                                return (0,_utils_chunks_createPushNotification__WEBPACK_IMPORTED_MODULE_17__.createPushNotification)({
                                    claimId: request.payload.claimNumber,
                                    operator: operator,
                                    errorText: message.error
                                });
                            });
                        case 'visafillBt':
                            // data.autoFillerData = mockFillerData.autoFillerData;
                            return fillVisaFormsInCurrentTab({
                                tourUrl: data.autoFillerData.tourUrl,
                                claimId: request.payload.claimId,
                                sourceId: request.payload.sourceId,
                                claimNumber: request.payload.claimNumber,
                                secretField: request.payload.secretField
                            }, data);
                        default: break;
                    }
                })
                    .catch(function (error) {
                    return (0,_utils__WEBPACK_IMPORTED_MODULE_4__.sendMessage)((0,_messages__WEBPACK_IMPORTED_MODULE_2__.createErrorMessage)(error.message));
                });
        }
    }
});

})();

/******/ })()
;
//# sourceMappingURL=background.js.map